/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class Processor {
    private String name = null;
    private String version = null;
    private int[] opCodes = new int[0];
    private int[] addresses = new int[0];
    private int minDataAddress = 100;
    private int maxDataAddress = 128;
    private int RAMAddress = 256;
    private int startOffset = 3;
    private int oscillatorFreq = 2000000;
    private int carrierTotalOffset = 0;
    private int carrierOnOffset = 0;
    private int addressLength = 2;
    private int pageSize = 1;
    private int dataStyle = -1;
    private boolean relativeToOpStart = false;
    private boolean oneByteAbsoluteAddresses = false;
    private List<AssemblerOpCode[]> instructions = new ArrayList<AssemblerOpCode[]>();
    protected LinkedHashMap<String, LinkedHashMap<String, AssemblerOpCode>> opMap = new LinkedHashMap();
    private LinkedHashMap<String, AssemblerOpCode.AddressMode> addressModes = new LinkedHashMap();
    private LinkedHashMap<String, List<String>> modesByOutline = new LinkedHashMap();
    private LinkedHashMap<Integer, String> absLabels = new LinkedHashMap();
    private LinkedHashMap<String, Integer> absAddresses = new LinkedHashMap();
    private LinkedHashMap<String, Integer> absData = new LinkedHashMap();
    private LinkedHashMap<String, String> lblComments = new LinkedHashMap();
    private LinkedHashMap<Integer, String[]> zeroLabels = new LinkedHashMap();
    private LinkedHashMap<String, Integer> zeroAddresses = new LinkedHashMap();
    private LinkedHashMap<String, Integer> zeroSizes = new LinkedHashMap();
    private String[][] baseZeroLabels = null;
    private int dcBufStart = 0;
    private int protocolHeaderSize = 3;
    private String nativeProcessorName = null;
    private short erasedByte = (short)255;
    protected List<Integer> addressList = null;

    public Processor(String name) {
        this(name, null, false);
    }

    public Processor(String name, boolean reverse) {
        this(name, null, reverse);
    }

    public Processor(String name, String version) {
        this(name, version, false);
    }

    public Processor(String name, String version, boolean reverse) {
        this.name = name;
        this.version = version;
    }

    public void setVectorEditData(int[] opcodes, int[] addresses) {
        this.opCodes = opcodes;
        this.addresses = addresses;
    }

    public void setDataEditData(int min, int max) {
        this.minDataAddress = min;
        this.maxDataAddress = max;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFullName() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + '-' + this.version;
    }

    public String getEquivalentName() {
        return this.getFullName();
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public void setAddressLength(int addressLength) {
        this.addressLength = addressLength;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Hex translate(Hex hex, Remote remote) {
        int vectorOffset = remote.getProtocolVectorOffset();
        int dataOffset = remote.getProtocolDataOffset();
        if (vectorOffset != 0 || dataOffset != 0) {
            try {
                hex = (Hex)hex.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (vectorOffset != 0) {
            this.doVectorEdit(hex, vectorOffset);
        }
        if (dataOffset != 0) {
            this.doDataEdit(hex, dataOffset);
        }
        return hex;
    }

    public Hex importCode(Hex code, String processorName) {
        return code;
    }

    public abstract int getInt(short[] var1, int var2);

    public abstract void putInt(int var1, short[] var2, int var3);

    protected void doVectorEdit(Hex hex, int vectorOffset) {
        short[] data = hex.getData();
        block0: for (int i = 0; i < data.length; ++i) {
            short opCode = data[i];
            for (int j = 0; j < this.opCodes.length; ++j) {
                if (opCode != this.opCodes[j]) continue;
                int address = this.getInt(data, i + 1);
                for (int k = 0; k < this.addresses.length; ++k) {
                    if (this.addresses[k] != address) continue;
                    this.putInt(address += vectorOffset, data, i + 1);
                    break;
                }
                i += 2;
                continue block0;
            }
        }
    }

    private void doDataEdit(Hex hex, int dataOffset) {
        int temp;
        int i;
        short[] data = hex.getData();
        for (i = 0; i < data.length - 1; ++i) {
            if ((data[i] & Hex.ADD_OFFSET) == 0 || (data[i + 1] & Hex.ADD_OFFSET) == 0 || (temp = this.getInt(data, i)) < this.minDataAddress || temp > this.maxDataAddress) continue;
            this.putInt(temp += dataOffset, data, i);
            ++i;
        }
        for (i = 0; i < data.length; ++i) {
            temp = data[i];
            if ((temp & Hex.ADD_OFFSET) == 0) continue;
            temp &= 0xFF;
            data[i] = (short)((temp += dataOffset) & 0xFF);
        }
    }

    public String toString() {
        return this.getFullName();
    }

    public int getRAMAddress() {
        return this.RAMAddress;
    }

    public void setRAMAddress(int address) {
        this.RAMAddress = address;
    }

    public List<AssemblerOpCode[]> getInstructions() {
        return this.instructions;
    }

    public LinkedHashMap<String, AssemblerOpCode.AddressMode> getAddressModes() {
        return this.addressModes;
    }

    public void setAddressModes(String[][] modeArray) {
        this.addressModes.clear();
        this.modesByOutline.clear();
        for (int i = 0; i < modeArray.length; ++i) {
            AssemblerOpCode.AddressMode mode = new AssemblerOpCode.AddressMode(modeArray[i]);
            mode.outline = this.simplifyOutline(mode.outline);
            this.addressModes.put(modeArray[i][0], mode);
            if (this.modesByOutline.containsKey(mode.outline)) {
                this.modesByOutline.get(mode.outline).add(mode.name);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(mode.name);
            this.modesByOutline.put(mode.outline, list);
        }
    }

    public LinkedHashMap<Integer, String> getAbsLabels() {
        return this.absLabels;
    }

    public LinkedHashMap<String, Integer> getAbsAddresses() {
        return this.absAddresses;
    }

    public LinkedHashMap<String, Integer> getAbsData() {
        return this.absData;
    }

    public LinkedHashMap<String, String> getLblComments() {
        return this.lblComments;
    }

    public void setAbsLabels(String[][] labelArray) {
        this.absLabels.clear();
        for (int i = 0; i < labelArray.length; ++i) {
            String str;
            this.absLabels.put(Integer.parseInt(labelArray[i][1], 16), labelArray[i][0]);
            this.absAddresses.put(labelArray[i][0], Integer.parseInt(labelArray[i][1], 16));
            if (labelArray[i].length > 2 && (str = labelArray[i][2]) != null && !str.isEmpty()) {
                this.lblComments.put(labelArray[i][0], str);
            }
            if (labelArray[i].length <= 3 || (str = labelArray[i][3]) == null || str.isEmpty()) continue;
            this.absData.put(labelArray[i][0], Integer.parseInt(str, 16));
        }
    }

    public LinkedHashMap<Integer, String[]> getZeroLabels() {
        return this.zeroLabels;
    }

    public LinkedHashMap<String, Integer> getZeroSizes() {
        return this.zeroSizes;
    }

    public LinkedHashMap<String, Integer> getZeroAddresses() {
        return this.zeroAddresses;
    }

    public void setZeroLabels(String[][] labelArray) {
        this.zeroLabels.clear();
        this.zeroSizes.clear();
        this.zeroAddresses.clear();
        for (int i = 0; i < labelArray.length; ++i) {
            int n = 0;
            String[] strArray = null;
            if (labelArray[i].length > 3) {
                strArray = new String[labelArray[i].length > 4 ? 3 : 2];
                strArray[1] = labelArray[i][2];
                if (strArray.length > 2) {
                    strArray[2] = labelArray[i][4];
                }
                n = Integer.parseInt(labelArray[i][3], 16);
                this.zeroSizes.put(labelArray[i][0], n);
            } else {
                String str;
                strArray = new String[1];
                if (labelArray[i].length == 3 && (str = labelArray[i][2]) != null && !str.isEmpty()) {
                    this.lblComments.put(labelArray[i][0], str);
                }
            }
            n = Integer.parseInt(labelArray[i][1], 16);
            strArray[0] = labelArray[i][0];
            this.zeroLabels.put(n, strArray);
            this.zeroAddresses.put(labelArray[i][0], n);
        }
    }

    public LinkedHashMap<String, String> getAsmLabels() {
        int addr;
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        String formatAddr = null;
        formatAddr = this.getAddressModes().get("EQUR") == null ? this.getAddressModes().get((Object)"EQU2").format : this.getAddressModes().get((Object)"EQUR").format;
        for (String text : this.getZeroSizes().keySet()) {
            addr = this.getZeroAddresses().get(text);
            int size = this.getZeroSizes().get(text);
            String labelBody = this.getZeroLabels().get(addr)[1];
            if (labelBody.length() >= text.length()) {
                labels.put(text.toUpperCase(), String.format(formatAddr, addr));
                continue;
            }
            for (int i = 0; i < size; ++i) {
                String formatLbl = labelBody + "%0" + (text.length() - labelBody.length()) + "X";
                labels.put(String.format(formatLbl, i).toUpperCase(), String.format(formatAddr, addr + i));
            }
        }
        for (String text : this.getZeroAddresses().keySet()) {
            addr = this.getZeroAddresses().get(text);
            if (this.getZeroSizes().keySet().contains(text)) continue;
            labels.put(text.toUpperCase(), String.format(formatAddr, addr));
        }
        formatAddr = this.getAddressModes().get((Object)"EQU4").format;
        for (String text : this.getAbsAddresses().keySet()) {
            addr = this.getAbsAddresses().get(text);
            labels.put(text.toUpperCase(), String.format(formatAddr, addr));
        }
        return labels;
    }

    public void setInstructions(String[][][] instArray) {
        int i;
        this.instructions.clear();
        HashMap<Integer, Integer> firstBytes = new HashMap<Integer, Integer>();
        for (i = 0; i < instArray.length; ++i) {
            AssemblerOpCode[] opCodes = new AssemblerOpCode[instArray[i].length];
            for (int j = 0; j < instArray[i].length; ++j) {
                Hex hex = new Hex(new short[]{(short)j});
                AssemblerOpCode op = new AssemblerOpCode(this, instArray[i][j]);
                if (op.getName().equals("*") && op.getIndex() > 0) {
                    firstBytes.put(op.getIndex(), j);
                } else if (i > 0 && firstBytes.get(i) != null) {
                    hex = new Hex(2);
                    hex.set(((Integer)firstBytes.get(i)).shortValue(), 0);
                    hex.set((short)j, 1);
                }
                op.setHex(hex);
                op.setLength(hex.length());
                opCodes[j] = op;
            }
            this.instructions.add(opCodes);
        }
        for (i = 0; i < this.instructions.size(); ++i) {
            for (int j = 0; j < this.instructions.get(i).length; ++j) {
                this.addToMap(this.instructions.get(i)[j]);
            }
        }
    }

    public void addToMap(AssemblerOpCode op) {
        String name = op.getName();
        if (op.getMode() == null) {
            return;
        }
        String modeName = op.getMode().name;
        LinkedHashMap<Object, Object> map = null;
        if (this.opMap.containsKey(name)) {
            map = this.opMap.get(name);
        } else {
            map = new LinkedHashMap();
            this.opMap.put(name, map);
        }
        if (!map.containsKey(modeName)) {
            map.put(modeName, op);
        }
    }

    public AssemblerOpCode.AddressMode disasmModify(AssemblerOpCode.AddressMode mode, Object[] obj) {
        switch (mode.modifier) {
            case 1: {
                obj[0] = (Integer)obj[0] >> 1;
                break;
            }
            case 2: {
                obj[0] = (Integer)obj[0] + 65280;
            }
        }
        return mode;
    }

    public void asmModify(int modifier, int[] obj) {
        switch (modifier) {
            case 1: {
                obj[0] = obj[0] << 1;
                break;
            }
            case 2: {
                obj[0] = obj[0] & 0xFF;
            }
        }
    }

    public boolean checkModifier(AssemblerOpCode.AddressMode mode, AssemblerOpCode.OpArg args) {
        for (int i = 0; i < args.size(); ++i) {
            int val;
            AssemblerOpCode.Token t = (AssemblerOpCode.Token)args.get(i);
            if (t.type != AssemblerOpCode.TokenType.NUMBER || (val = t.value.intValue()) >= 0 && val <= mode.argLimits[i]) continue;
            return false;
        }
        switch (mode.modifier) {
            case 2: {
                Integer val = ((AssemblerOpCode.Token)args.get((int)0)).value;
                return val != null && val >= 65280;
            }
        }
        return true;
    }

    public AssemblerOpCode getOpCode(Hex hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        if (hex.getData()[0] >= this.instructions.get(0).length) {
            String opName = String.format("***Op%02X", hex.getData()[0]);
            String[] parms = new String[]{opName, "Nil"};
            return new AssemblerOpCode(this, parms);
        }
        AssemblerOpCode opCode = this.instructions.get(0)[hex.getData()[0]].clone();
        if (opCode.getIndex() > 0 && hex.length() > 1) {
            opCode = this.instructions.get(opCode.getIndex())[hex.getData()[1]].clone();
        }
        return opCode;
    }

    public AssemblerOpCode.OpArg getArgs(String argText, LinkedHashMap<String, String> labels) {
        return AssemblerOpCode.OpArg.getArgs(argText, this, labels);
    }

    public List<String> getAddressModes(AssemblerOpCode.OpArg args) {
        ArrayList<String> modes = new ArrayList<String>();
        String simpleOutline = this.simplifyOutline(args.outline);
        if (this.modesByOutline.get(simpleOutline) == null) {
            return modes;
        }
        for (String string : this.modesByOutline.get(simpleOutline)) {
            modes.add(string);
        }
        Iterator it = modes.iterator();
        block1: while (it.hasNext()) {
            AssemblerOpCode.AddressMode addressMode = this.addressModes.get(it.next());
            if (!this.checkModifier(addressMode, args)) {
                it.remove();
                continue;
            }
            for (int i = 0; i < args.size(); ++i) {
                int n;
                AssemblerOpCode.Token t = (AssemblerOpCode.Token)args.get(i);
                if (t.type == AssemblerOpCode.TokenType.OFFSET) {
                    n = addressMode.argMap[i] - addressMode.nibbleArgs - 1;
                    if (n >= 0 && (addressMode.relMap >> n & 1) != 0) continue;
                    it.remove();
                    continue block1;
                }
                if (t.type == AssemblerOpCode.TokenType.CONDITION_CODE) {
                    n = addressMode.argMap[i] - 1;
                    if ((addressMode.ccMap >> n & 1) != 0) continue;
                    it.remove();
                    continue block1;
                }
                if (t.type != AssemblerOpCode.TokenType.ERROR) continue;
                it.remove();
                continue block1;
            }
        }
        return modes;
    }

    public String getAlternateArgument(String argText, int n) {
        argText = argText.replaceAll("\\s", "").toUpperCase();
        return argText;
    }

    public List<String> getHexPrefixes() {
        return new ArrayList<String>();
    }

    public String simplifyOutline(String outline) {
        return outline;
    }

    public String getConditionCode(int n) {
        return null;
    }

    public int getConditionIndex(String cc) {
        return -1;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getOscillatorFreq() {
        return this.oscillatorFreq;
    }

    public void setOscillatorData(int[] oscData) {
        this.oscillatorFreq = oscData[0];
        this.carrierTotalOffset = oscData[1];
        this.carrierOnOffset = oscData[2];
    }

    public int[] getCarrierData(Hex hex) {
        return null;
    }

    public int getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(int dataStyle) {
        this.dataStyle = dataStyle;
    }

    public int getCarrierTotalOffset() {
        return this.carrierTotalOffset;
    }

    public int getCarrierOnOffset() {
        return this.carrierOnOffset;
    }

    public boolean isRelativeToOpStart() {
        return this.relativeToOpStart;
    }

    public void setRelativeToOpStart(boolean relativeToOpStart) {
        this.relativeToOpStart = relativeToOpStart;
    }

    public boolean hasOneByteAbsoluteAddresses() {
        return this.oneByteAbsoluteAddresses;
    }

    public void setOneByteAbsoluteAddresses(boolean oneByteAbsoluteAddresses) {
        this.oneByteAbsoluteAddresses = oneByteAbsoluteAddresses;
    }

    public String getRegisterPrefix() {
        return "$";
    }

    public LinkedHashMap<String, LinkedHashMap<String, AssemblerOpCode>> getOpMap() {
        return this.opMap;
    }

    public String[][] getBaseZeroLabels() {
        return this.baseZeroLabels;
    }

    public void setBaseZeroLabels(String[][] baseZeroLabels) {
        this.baseZeroLabels = baseZeroLabels;
    }

    public int getDcBufStart() {
        return this.dcBufStart;
    }

    public void setDcBufStart(int dcBufStart) {
        this.dcBufStart = dcBufStart;
    }

    public int getProtocolHeaderSize() {
        return this.protocolHeaderSize;
    }

    public void setProtocolHeaderSize(int protocolHeaderSize) {
        this.protocolHeaderSize = protocolHeaderSize;
    }

    public String getNativeProcessorName() {
        return this.nativeProcessorName;
    }

    public void setNativeProcessorName(String nativeProcessorName) {
        this.nativeProcessorName = nativeProcessorName;
    }

    public List<Integer> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(List<Integer> addressList) {
        this.addressList = addressList;
    }

    public short getErasedByte() {
        return this.erasedByte;
    }

    public void setErasedByte(short erasedByte) {
        this.erasedByte = erasedByte;
    }
}

