/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.BigEndianProcessor;
import com.hifiremote.jp1.LittleEndianProcessor;
import com.hifiremote.jp1.MAXQProcessor;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.S3C80Processor;
import com.hifiremote.jp1.S3F80Processor;
import com.hifiremote.jp1.TI2541Processor;
import com.hifiremote.jp1.assembler.HCS08data;
import com.hifiremote.jp1.assembler.JP2CommonData;
import com.hifiremote.jp1.assembler.MAXQ610data;
import com.hifiremote.jp1.assembler.P6805data;
import com.hifiremote.jp1.assembler.P740data;
import com.hifiremote.jp1.assembler.S3C80data;
import com.hifiremote.jp1.assembler.TI2541data;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;

public class ProcessorManager {
    private static ProcessorManager processorManager = new ProcessorManager();
    private LinkedHashMap<String, Processor> processors = new LinkedHashMap();

    private ProcessorManager() {
        Processor p = new S3C80Processor();
        p.setAddressModes(S3C80data.AddressModes);
        String[][][] S3C80Array = new String[][][]{S3C80data.Instructions};
        p.setInstructions(S3C80Array);
        p.setAbsLabels(S3C80data.absLabels_C80);
        p.setZeroLabels(S3C80data.zeroLabels);
        p.setOscillatorData(S3C80data.oscData);
        p.setDataStyle(0);
        this.add(p);
        p = new S3F80Processor();
        p.setAddressModes(S3C80data.AddressModes);
        p.setInstructions(S3C80Array);
        p.setAbsLabels(S3C80data.absLabels_F80);
        p.setZeroLabels(S3C80data.zeroLabels);
        p.setOscillatorData(S3C80data.oscData);
        p.setDataStyle(0);
        this.add(p);
        p = new S3F80Processor("S3F80_32K");
        this.add(p);
        p = new S3F80Processor("S3F80P5X");
        this.add(p);
        p = new BigEndianProcessor("6805", "C9");
        int[] opcodes = new int[]{204, 205};
        int[] addresses = new int[]{384, 387, 390, 393, 396, 399, 402, 405, 408, 411, 414, 415, 422, 425, 429, 434, 436, 444};
        p.setAddressModes(P6805data.AddressModes);
        String[][][] p6805Array = new String[][][]{P6805data.Instructions};
        p.setInstructions(p6805Array);
        p.setAbsLabels(P6805data.absLabels_C9);
        p.setZeroLabels(P6805data.zeroLabels_C9);
        p.setOscillatorData(P6805data.oscData_C9);
        p.setDataStyle(3);
        p.setVectorEditData(opcodes, addresses);
        this.add(p);
        p = new BigEndianProcessor("6805", "RC16/18");
        int[] moreAddresses = new int[]{384, 387, 390, 393, 396, 399, 402, 405, 406, 413, 417, 421, 431, 434, 437, 440, 443, 446, 449, 452, 455, 458};
        p.setAddressModes(P6805data.AddressModes);
        p.setInstructions(p6805Array);
        p.setAbsLabels(P6805data.absLabels_RC16);
        p.setZeroLabels(P6805data.zeroLabels_RC16);
        p.setOscillatorData(P6805data.oscData_RC16);
        p.setDataStyle(2);
        p.setVectorEditData(opcodes, moreAddresses);
        this.add(p);
        p = new BigEndianProcessor("SST");
        p.setAddressModes(P6805data.AddressModes);
        p.setInstructions(p6805Array);
        p.setAbsLabels(P6805data.absLabels_SST);
        p.setZeroLabels(P6805data.zeroLabels_RC16);
        p.setOscillatorData(P6805data.oscData_RC16);
        p.setDataStyle(2);
        this.add(p);
        p = new LittleEndianProcessor("740");
        p.setAddressModes(P740data.AddressModes);
        String[][][] p740Array = new String[][][]{P740data.Instructions};
        p.setInstructions(p740Array);
        p.setAbsLabels(P740data.absLabels);
        p.setZeroLabels(P740data.zeroLabels);
        p.setOscillatorData(P740data.oscData);
        p.setDataStyle(4);
        this.add(p);
        p = new BigEndianProcessor("HCS08");
        p.setAddressModes(HCS08data.AddressModes);
        String[][][] HCS08Array = new String[][][]{HCS08data.Instructions, HCS08data.Instructions2};
        p.setInstructions(HCS08Array);
        p.setAbsLabels(HCS08data.absLabels);
        p.setZeroLabels(HCS08data.zeroLabels);
        p.setOscillatorData(HCS08data.oscData);
        p.setDataStyle(1);
        p.setStartOffset(0);
        this.add(p);
        p = new MAXQProcessor("MAXQ610");
        p.setAddressModes(JP2CommonData.AddressModes);
        String[][][] MAXQArray = new String[][][]{MAXQ610data.Instructions};
        p.setInstructions(MAXQArray);
        p.setAbsLabels(JP2CommonData.absLabels);
        p.setBaseZeroLabels(MAXQ610data.zeroLabels);
        p.setOscillatorData(MAXQ610data.oscData);
        p.setDcBufStart(208);
        p.setNativeProcessorName("MAXQNative");
        this.add(p);
        p = new MAXQProcessor("MAXQ612");
        p.setAddressLength(4);
        this.add(p);
        p = new MAXQProcessor("MAXQ622");
        p.setAddressLength(4);
        this.add(p);
        p = new MAXQProcessor("MAXQNative");
        p.setAddressModes(MAXQ610data.AddressModes);
        p.setRelativeToOpStart(true);
        this.add(p);
        p = new TI2541Processor("TI2541");
        p.setAddressLength(4);
        p.setAddressModes(JP2CommonData.AddressModes);
        String[][][] TI2541Array = new String[][][]{TI2541data.Instructions};
        p.setInstructions(TI2541Array);
        p.setAbsLabels(JP2CommonData.absLabels);
        p.setBaseZeroLabels(TI2541data.zeroLabels);
        p.setOscillatorData(TI2541data.oscData);
        p.setDcBufStart(2);
        p.setProtocolHeaderSize(5);
        this.add(p);
        p = new TI2541Processor("TI2530");
        p.setAddressLength(4);
        this.add(p);
        p = new TI2541Processor("TI2533");
        p.setAddressLength(4);
        p.setPageSize(1024);
        this.add(p);
        p = new TI2541Processor("GP541");
        p.setAddressLength(2);
        p.setPageSize(512);
        this.add(p);
        p = new TI2541Processor("GP565");
        p.setAddressLength(4);
        p.setErasedByte((short)0);
        p.setPageSize(128);
        this.add(p);
    }

    public static Processor getProcessor(String name, String version) {
        if (name == null) {
            return null;
        }
        String lookup = name;
        if (version != null) {
            lookup = name + '-' + version;
        }
        return ProcessorManager.processorManager.processors.get(lookup);
    }

    public static Processor getProcessor(String text) {
        if (text == null) {
            return null;
        }
        String name = "";
        name = text.startsWith("S3C8") ? "S3C80" : (text.startsWith("M6805") ? text.substring(1) : (text.equals("P8/740") ? "740" : text));
        return ProcessorManager.processorManager.processors.get(name);
    }

    public static Set<String> getProcessorNames() {
        return ProcessorManager.processorManager.processors.keySet();
    }

    private void add(Processor p) {
        this.processors.put(p.getFullName(), p);
    }

    public static Processor[] getProcessors() {
        Collection<Processor> procs = ProcessorManager.processorManager.processors.values();
        Processor[] rc = new Processor[procs.size()];
        rc = procs.toArray(rc);
        return rc;
    }
}

