/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.UnpackLearned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;

public class ProntoSignal {
    private int[] pronto = null;
    private int[] durations = null;
    private int oneTime = 0;
    private int repeat = 0;
    private int extra = 0;
    private int frequency = 0;
    private static boolean fix = false;
    public String error = null;
    private static short[][] zMaskWords = new short[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 7, 8}, {0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 9, 10, 11, 12, 13, 14}, {0, 0, 0, 0, 0, 0, 0, 0, 7, 8, 9, 10, 11, 12, 13, 14}, {0, 0, 0, 0, 0, 0, 0, 0, 15, 16, 17, 18, 19, 20, 21, 22}, {0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 18, 19, 20, 21}, {8, 7, 6, 5, 4, 3, 2, 1, 16, 15, 14, 13, 12, 11, 10, 9}, {24, 23, 22, 21, 20, 19, 18, 17, 32, 31, 30, 29, 28, 27, 26, 25}, {9, 8, 7, 6, 5, 4, 3, 2, 17, 16, 15, 14, 13, 12, 11, 10}, {25, 24, 23, 22, 21, 20, 19, 18, 33, 32, 31, 30, 29, 28, 27, 26}, {42, 41, 40, 39, 38, 37, 36, 35, 50, 49, 48, 47, 46, 45, 44, 43}, {58, 57, 56, 55, 54, 53, 52, 51, 66, 65, 64, 63, 62, 61, 60, 59}, {43, 42, 41, 40, 39, 38, 37, 36, 51, 50, 49, 48, 47, 46, 45, 44}, {59, 58, 57, 56, 55, 54, 53, 52, 67, 66, 65, 64, 63, 62, 61, 60}, {0, 0, 0, 0, 0, 0, 0, 0, 8, 7, 6, 5, 4, 3, 2, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 16, 15, 14, 13, 12, 11, 10, 9}, {0, 0, 0, 0, 0, 0, 0, 0, 24, 23, 22, 21, 20, 19, 18, 17}, {0, 0, 0, 0, 0, 0, 0, 0, 32, 31, 30, 29, 28, 27, 26, 25}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 9, 10, 11, 12, 13, 14}, {0, 0, 0, 0, 0, 0, 0, 0, 23, 24, 25, 26, 27, 28, 29, 30}, {0, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22}, {0, 0, 0, 0, 0, 0, 0, 0, 31, 32, 33, 34, 35, 36, 37, 38}, {0, 0, 0, 0, 0, 0, 0, 0, -16, -15, -14, -13, -12, -11, -10, -9}, {0, 0, 0, 0, 0, 0, 0, 0, -32, -31, -30, -29, -28, -27, -26, -25}};
    private static short[] tm00 = new short[]{-1, 2, 0};
    private static short[] tm01 = new short[]{-1, 0, 4, 3, 3, 3, 5};
    private static short[] tm02 = new short[]{-1, 3, 1, 0};
    private static short[] tm13 = new short[]{0, 1, -1, 4};
    private static short[] tm14 = new short[]{-1, 0, 1};
    private static short[] tm15 = new short[]{0, 1, 0, 1, -1, 4};
    private static short[] tm16 = new short[]{0, 1, -1, 0, 1};
    private static short[] tm17 = new short[]{-1, 0, 1, 0, 1};
    private static short[] tm40 = new short[]{-1, 0, 4, 4, 4, 3, 3, 5};
    private static short[] tm41 = new short[]{-1, 0, 4, 4, 4, 3, 4, 5};
    private static int[][] bst00 = new int[][]{{-3232}, {32, -32}, {-32, 32}};
    private static int[][] bst01 = new int[][]{{96, -32}, {32, -32}, {-32, 32}, {-16, 16}, {16, -16}, {-3008}};
    private static int[][] bst02 = new int[][]{{-2720}, {-128}, {32, -32}, {-32, 32}};
    private static int[][] bst03 = new int[][]{{91, -50210}, {91, -7104}, {91, -5666}, {91, -4227}, {91, -2788}, {91, -1350}};
    private static int[][] bst04 = new int[][]{{259, -44289}, {259, -18389}, {259, -5957}, {4112, -1036}, {259, -777}, {259, -259}, {4112, -2078}};
    private static int[][] bst05 = new int[][]{{8827, -4448}, {8748, -36858}, {8748, -24840}, {8748, -16741}, {8748, -12719}, {8748, -11283}, {8748, -1668}, {8748, -8748}, {8827, -4448}};
    private static int[][] bst06 = new int[][]{{252, -13435}, {252, -252}, {252, -126}, {126, -13435}, {126, -628}, {126, -378}, {126, -252}, {126, -126}};
    private static int[][] bst08 = new int[][]{{25, -90, 40}, {-68, 36}, {-54, 18, -14, 18}, {-34, 18, -34, 18}, {-14, 18, -54, 18}, {-2044}};
    private static int[][] bst0A = new int[][]{{6, -2135}, {6, -282}, {6, -187}};
    private static int[][] bst0B = new int[][]{{16, -2135}, {16, -1602}, {16, -274}, {16, -177}};
    private static int[][] bst0C = new int[][]{{16, -1437}, {16, -1047}, {16, -763}, {16, -153}, {16, -68}};
    private static int[][] bst0D = new int[][]{{8, -19323}, {8, -14964}, {8, -2603}, {8, -1731}, {8, -1301}};
    private static int[][] bst0E = new int[][]{{8, -11182}, {8, -8452}, {8, -1482}, {8, -985}};
    private static int[][] bst0F = new int[][]{{25, -588}, {25, -266}, {25, -175}};
    private static int[][] bst10 = new int[][]{{9, -29939}, {9, -22738}, {9, -3902}, {9, -2602}};
    private static int[][] bst11 = new int[][]{{6, -2113}, {6, -1627}, {6, -282}, {6, -187}};
    private static int[][] bst13 = new int[][]{{343, -171}, {22, -1511}, {22, -64}, {22, -21}, {343, -85, 22, -3643}};
    private static int[][] bst14 = new int[][]{{343, -171}, {22, -1511}, {22, -64}, {22, -21}};
    private static int[][] bst40 = new int[][]{{112, -32}, {32, -32}, {-32, 32}, {-16, 16}, {16, -16}, {2736}};
    private static int[][] bst41 = new int[][]{{112, -32}, {32, -32}, {-32, 32}, {-16, 16}, {16, -16}, {2480}};
    private static ProntoFormat[] pfList = new ProntoFormat[]{new ProntoFormat(20480, 0, 115, bst00, 1, tm00, new short[]{0, 1}, new Toggle(1, 2, 3)), new ProntoFormat(24576, 1, 115, bst01, 3, tm01, new short[]{2, 3}, new Toggle(2, 1, 6)), new ProntoFormat(20481, 2, 115, bst02, 2, tm02, new short[]{0, 4, 5}, new Toggle(2, 3, 3)), new ProntoFormat(28672, 3, 9, bst03, new Toggle[0]), new ProntoFormat(28672, 4, 9, bst04, new Toggle[0]), new ProntoFormat(28672, 5, 4, bst05, new Toggle[0]), new ProntoFormat(28672, 6, 12, bst06, new Toggle[0]), new ProntoFormat(28672, 7, 12, bst06, new Toggle[0]), new ProntoFormat(28672, 8, 136, bst08, new Toggle(1, 3, 3)), new ProntoFormat(28672, 9, 136, bst08, new Toggle(2, 4, 3)), new ProntoFormat(28672, 10, 124, bst0A, new Toggle(2, 1, 3)), new ProntoFormat(28672, 11, 124, bst0B, new Toggle(3, 2, 2, 6)), new ProntoFormat(28672, 12, 124, bst0C, new Toggle(4, 3, 8)), new ProntoFormat(28672, 13, 12, bst0D, new Toggle(2, 3, 5)), new ProntoFormat(28672, 14, 24, bst0E, new Toggle(2, 3, 2, 6)), new ProntoFormat(28672, 15, 66, bst0F, new Toggle[0]), new ProntoFormat(28672, 16, 8, bst10, new Toggle(2, 3, 2, 6)), new ProntoFormat(28672, 17, 109, bst11, new Toggle(3, 2, 3)), new ProntoFormat(28672, 18, 99, bst11, new Toggle(3, 2, 3)), new ProntoFormat(36874, 19, 109, bst13, -3, tm13, new short[]{6, 7}, new Toggle[0]), new ProntoFormat(36875, 20, 109, bst14, -3, tm14, new short[]{8, 9}, new Toggle[0]), new ProntoFormat(36876, 21, 109, bst13, -3, tm15, new short[]{6, 7, 10, 11}, new Toggle[0]), new ProntoFormat(36877, 22, 109, bst14, -3, tm16, new short[]{6, 7, 12, 13}, new Toggle[0]), new ProntoFormat(36878, 23, 109, bst14, -3, tm17, new short[]{8, 9, 12, 13}, new Toggle[0]), new ProntoFormat(36874, 24, 104, bst13, -3, tm13, new short[]{6, 7}, new Toggle[0]), new ProntoFormat(36875, 25, 104, bst14, -3, tm14, new short[]{8, 9}, new Toggle[0]), new ProntoFormat(36876, 26, 104, bst13, -3, tm15, new short[]{6, 7, 10, 11}, new Toggle[0]), new ProntoFormat(36877, 27, 104, bst14, -3, tm16, new short[]{6, 7, 12, 13}, new Toggle[0]), new ProntoFormat(36878, 28, 104, bst14, -3, tm17, new short[]{8, 9, 12, 13}, new Toggle[0]), new ProntoFormat(36864, 29, 109, bst13, -3, tm13, new short[]{14, 15, 16, 17}, new Toggle[0]), new ProntoFormat(24577, 64, 115, bst40, 3, tm40, new short[]{18, 3, 19}, new Toggle(2, 1, 6)), new ProntoFormat(24577, 65, 115, bst41, 3, tm41, new short[]{20, 19, 21}, new Toggle(2, 1, 6)), new ProntoFormat(36865, 66, 109, bst13, -3, tm13, new short[]{14, 16, 22, 23}, new Toggle[0])};

    public ProntoSignal(String str) {
        short[] p = Hex.parseHex(str);
        this.pronto = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.pronto[i] = p[i] + (p[i] < 0 ? 65536 : 0);
        }
    }

    public ProntoSignal(LearnedSignal ls) {
        this(ls.getUnpackLearned());
        if (this.error != null) {
            this.error = "Unable to unpack the learned signal";
        }
    }

    public ProntoSignal(UnpackLearned ul) {
        if (ul != null && ul.ok) {
            this.oneTime = ul.oneTime;
            this.repeat = ul.repeat;
            this.extra = ul.extra;
            this.frequency = ul.frequency;
            this.durations = (int[])ul.durations.clone();
        } else {
            this.error = "Invalid UnpackLearned";
        }
    }

    public static void setFix(boolean fix) {
        ProntoSignal.fix = fix;
    }

    public int[] getDurations() {
        return this.durations;
    }

    public void makePronto() {
        int unit = 0;
        if (this.frequency > 0) {
            unit = (int)Math.floor(4145146.0 / (double)this.frequency + 0.5);
        } else {
            int shortest = this.durations[0];
            for (int val : this.durations) {
                shortest = Math.min(val, shortest);
            }
            unit = (int)Math.floor(0.51814325 * (double)shortest + 0.5);
            unit &= 0xFFFFFFFE;
        }
        if (unit <= 0) {
            unit = 1;
        }
        this.pronto = new int[this.durations.length + 4];
        this.pronto[0] = this.frequency > 0 ? 0 : 256;
        this.pronto[1] = unit;
        this.pronto[2] = this.oneTime / 2;
        this.pronto[3] = this.repeat / 2;
        for (int i = 0; i < this.durations.length; i += 2) {
            int v2;
            int v1 = (int)Math.floor((double)this.durations[i] * 4.145146 / (double)unit + 0.5);
            if (v1 == 0) {
                v1 = 1;
            }
            if (v1 > 65535) {
                v1 = 65535;
            }
            if ((v2 = (int)Math.floor((double)(this.durations[i] + this.durations[i + 1]) * 4.145146 / (double)unit + 0.5) - v1) == 0) {
                v2 = 1;
            }
            if (v2 > 65535) {
                v2 = 65535;
            }
            this.pronto[i + 4] = v1;
            this.pronto[i + 5] = v2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unpack(int togNum) {
        this.error = null;
        if (this.pronto.length < 6 || this.pronto.length < 2 * (this.pronto[2] + this.pronto[3]) + 4) {
            this.error = "Pronto signal has invalid length";
            return;
        }
        int prontoSize = 2 * (this.pronto[2] + this.pronto[3]) + 4;
        ProntoFormat pfm = null;
        int[] pData = null;
        for (ProntoFormat pfTest : pfList) {
            if (pfTest.fmtID != this.pronto[0] || pfTest.fmtID == 24577 && pfTest.subID != (this.pronto[4] < 32768 ? 64 : 65) || pfTest.fmtID == 28672 && pfTest.subID != this.pronto[4] || pfTest.fmtID >= 36874 && this.pronto[1] == 104 && pfTest.freqDiv != 104) continue;
            pfm = pfTest;
            break;
        }
        if (pfm == null) {
            if (this.pronto[0] == 0 || this.pronto[0] == 256) {
                pfm = new ProntoFormat();
                pfm.fmtID = this.pronto[0];
                pfm.freqDiv = this.pronto[1];
                this.oneTime = 2 * this.pronto[2];
                this.repeat = 2 * this.pronto[3];
                this.extra = 0;
                pData = Arrays.copyOfRange(this.pronto, 4, this.pronto.length);
            } else {
                this.error = "Pronto format " + String.format("%04X", this.pronto[0]) + (this.pronto[0] == 32768 ? " is not supported" : " is invalid");
                return;
            }
        }
        short[] stringCode = null;
        int scSize = 0;
        if (pfm.fmtID == 28672) {
            int i;
            scSize = this.pronto[5];
            if (scSize + (scSize & 1) + 6 != prontoSize) {
                this.error = "Invalid length data for pronto format 7000";
                return;
            }
            int barCount = 0;
            for (i = 0; i < scSize; ++i) {
                if (this.pronto[i + 6] == 16) {
                    ++barCount;
                }
                if (!(this.pronto[i + 6] > 16 && !pfm.toggle.atLocation(this.pronto[i + 6] - 20) || this.pronto[i + 6] < 16 && this.pronto[i + 6] >= pfm.bursts.length) && (i != scSize - 1 || barCount == 1)) continue;
                this.error = "Invalid values in pronto format 7000";
                return;
            }
            stringCode = new short[scSize];
            for (i = 0; i < scSize; ++i) {
                stringCode[i] = this.pronto[i + 6] < 16 ? (short)this.pronto[i + 6] : (this.pronto[i + 6] == 16 ? (short)-1 : (short)pfm.toggle.chars[togNum & 1]);
            }
        } else if (pfm.fmtID > 4096) {
            void var9_16;
            int dataSize;
            int n = dataSize = pfm.fmtID == 36865 ? 2 : pfm.zMask.length + (pfm.zMask.length & 1);
            if (dataSize != prontoSize - 4) {
                this.error = "Invalid data in Pronto signal";
                return;
            }
            stringCode = new short[70];
            Arrays.fill(stringCode, (short)-2);
            int ndx = 0;
            for (int i : pfm.zMask) {
                short z;
                for (int j = 15; j >= 0 && (z = zMaskWords[i][j]) != 0; --j) {
                    if (Math.abs(z) >= stringCode.length) {
                        this.error = "Error in internal Pronto tables";
                        return;
                    }
                    stringCode[Math.abs((int)z)] = (short)Math.abs((this.pronto[ndx + 4] >> 15 - j & 1 ^ (z < 0 ? 1 : 0)) + pfm.offset);
                    ++scSize;
                }
                ndx = ndx + 1 & dataSize - 1;
            }
            for (int i : pfm.toggle.locations) {
                stringCode[i] = (short)pfm.toggle.chars[togNum & 1];
                ++scSize;
            }
            boolean bl = false;
            int j = 0;
            while (var9_16 < stringCode.length) {
                if (stringCode[var9_16] == -2) {
                    if (j == pfm.cData.length) {
                        if (var9_16 >= scSize) break;
                        this.error = "Invalid value in Pronto data";
                        return;
                    }
                    stringCode[var9_16] = pfm.cData[j++];
                    ++scSize;
                }
                ++var9_16;
            }
            stringCode = Arrays.copyOf(stringCode, scSize);
        }
        if (scSize > 0) {
            int n;
            int carry = 0;
            int count = 0;
            boolean bl = false;
            ArrayList<Integer> burstList = new ArrayList<Integer>();
            for (short ndx : stringCode) {
                if (ndx < 0) {
                    if (n > 0) {
                        burstList.add(n);
                        n = 0;
                        ++count;
                    }
                    if (count & true) {
                        burstList.add(0);
                    }
                    this.oneTime = ++count;
                    count = 0;
                    carry = 0;
                    continue;
                }
                for (int n2 : pfm.bursts[ndx]) {
                    if (count == 0 && n == 0 && n2 < 0) {
                        carry += -n2;
                        continue;
                    }
                    if ((count & 1) == (n2 < 0 ? 0 : 1)) {
                        burstList.add(n);
                        n = Math.abs(n2);
                        ++count;
                        continue;
                    }
                    n += Math.abs(n2);
                }
            }
            if (count & true) {
                void var9_19 = n + carry;
                burstList.add((int)var9_19);
                ++count;
            } else if (n > 0) {
                burstList.add(n);
                burstList.add(carry);
                count += 2;
            } else if (carry > 0 && count > 0) {
                int n3 = (Integer)burstList.get(count - 1);
                burstList.set(count - 1, n3 + carry);
            }
            this.repeat = count;
            this.extra = 0;
            if (carry > 0 && this.oneTime > 0) {
                int n4 = (Integer)burstList.get(this.oneTime - 1);
                burstList.set(this.oneTime - 1, n4 + carry);
            }
            pData = new int[burstList.size()];
            for (int i = 0; i < burstList.size(); ++i) {
                pData[i] = (Integer)burstList.get(i);
            }
        }
        int unit = pfm.freqDiv;
        if (pfm.fmtID != 256 && (pfm.fmtID != 0 || unit != 1)) {
            this.frequency = (int)Math.floor(4145146.0 / (double)unit + 0.5);
        }
        this.durations = new int[this.oneTime + this.repeat];
        for (int i = 0; i < this.oneTime + this.repeat; i += 2) {
            this.durations[i] = (int)Math.floor((double)(pData[i] * unit) / 4.145146 + 0.5);
            this.durations[i + 1] = (int)Math.floor((double)((pData[i] + pData[i + 1]) * unit) / 4.145146 + 0.5) - this.durations[i];
        }
    }

    private boolean equalTimes(int[] t1, int[] t2, int errLimit) {
        for (int i = 0; i < t1.length && i < t2.length; ++i) {
            if (!((double)Math.abs(t2[i]) < Math.floor(0.975 * (double)Math.abs(t1[i])) && Math.abs(t2[i]) < Math.abs(t1[i]) - errLimit) && (!((double)Math.abs(t2[i]) > Math.ceil(1.025 * (double)Math.abs(t1[i]))) || Math.abs(t2[i]) <= Math.abs(t1[i]) + errLimit)) continue;
            return false;
        }
        return true;
    }

    private void makeLearnBursts(List<int[]> bursts, int[] data) {
        int errLimit = this.frequency > 0 ? (int)Math.round(2500000.0 / (double)this.frequency) : 25;
        for (int i = 0; i < this.oneTime + this.repeat + this.extra; i += 2) {
            boolean found = false;
            int[] next = new int[]{this.durations[i], this.durations[i + 1]};
            for (int j = 0; j < bursts.size(); ++j) {
                if (!this.equalTimes(bursts.get(j), next, errLimit)) continue;
                data[i / 2] = j;
                found = true;
                break;
            }
            if (found) continue;
            data[i / 2] = bursts.size();
            bursts.add(next);
        }
    }

    public LearnedSignal makeLearned(int format) {
        int x;
        int i;
        int period;
        this.error = null;
        if (format > 4) {
            this.error = "Format value " + format + " is not supported";
            return null;
        }
        int[] data = new int[(this.oneTime + this.repeat + this.extra) / 2];
        ArrayList<int[]> bursts = new ArrayList<int[]>();
        this.makeLearnBursts(bursts, data);
        if (bursts.size() > 16) {
            this.error = "There are " + bursts.size() + " bursts, maximum permitted is 16";
            return null;
        }
        int length = 3 + 4 * bursts.size();
        if (this.oneTime > 255) {
            this.error = "Maximum length of 127 bits for one-time signal exceeded";
            return null;
        }
        if (this.oneTime > 0) {
            length += (this.oneTime / 2 + 1) / 2 + 1;
        }
        if (this.repeat > 255) {
            this.error = "Maximum length of 127 bits for repeat signal exceeded";
            return null;
        }
        if (this.repeat > 0) {
            length += (this.repeat / 2 + 1) / 2 + 1;
        }
        if (this.extra > 255) {
            this.error = "Maximum length of 127 bits for extra signal exceeded";
            return null;
        }
        if (this.extra > 0) {
            length += (this.extra / 2 + 1) / 2 + 1;
        }
        if (length + 3 > 128) {
            this.error = "Total length is " + (length + 3) + " bytes, maximum permitted is 128";
            return null;
        }
        Hex hex = new Hex(length);
        double clock = 1000000.0 * (double)UnpackLearned.clockMHz[format];
        int n = period = this.frequency > 0 ? (int)Math.floor(clock / (double)this.frequency + 0.5) : 0;
        if (period > Short.MAX_VALUE) {
            this.error = "Nonzero frequency is below supported lower limit";
            return null;
        }
        double[] units = UnpackLearned.getBurstUnits(format, this.frequency);
        hex.put(period, format == 3 ? 1 : 0);
        hex.set((short)bursts.size(), format == 3 ? 0 : 2);
        int ndx = 3;
        String title = "Pronto to Learned Conversion";
        String message = "There are SPACE durations in the Pronto signal that exceed the maximum that this\nLearned Signal format supports.  If you continue the conversion, these will be\nreplaced by the maximum supported value.  Do you wish to continue?";
        Object[] options = new String[]{"Continue conversion", "Cancel conversion"};
        for (i = 0; i < bursts.size(); ++i) {
            int tOn = (int)Math.round((double)((int[])bursts.get(i))[0] / units[0]);
            int tOff = (int)Math.round((double)((int[])bursts.get(i))[1] / units[1]);
            if (format == 1 || format == 2 || format == 3) {
                if (tOn > 4095) {
                    tOn = 4095;
                    this.error = "Burst MARK duration out of range for format " + format;
                    return null;
                }
                if (tOff > 1048575) {
                    if (!fix) {
                        boolean bl = fix = JOptionPane.showOptionDialog(RemoteMaster.getFrame(), message, title, -1, 3, null, options, options[0]) == 0;
                    }
                    if (fix) {
                        tOff = 1048575;
                    } else {
                        return null;
                    }
                }
                tOn = tOn << 4 | tOff >> 16;
                tOff &= 0xFFFF;
            } else {
                if (tOn > 65535) {
                    tOn = 65535;
                    this.error = "Burst MARK duration out of range for format 0";
                    return null;
                }
                if (tOff > 65535) {
                    if (!fix) {
                        boolean bl = fix = JOptionPane.showOptionDialog(RemoteMaster.getFrame(), message, title, -1, 3, null, options, options[0]) == 0;
                    }
                    if (fix) {
                        tOff = 65535;
                    } else {
                        return null;
                    }
                }
            }
            hex.put(tOn, ndx);
            hex.put(tOff, ndx += 2);
            ndx += 2;
        }
        if (this.oneTime > 0) {
            hex.set((short)(this.oneTime / 2), ndx++);
            i = 0;
            while (i < this.oneTime / 2) {
                x = data[i++] << 4;
                if (i < this.oneTime / 2) {
                    x |= data[i++];
                }
                hex.set((short)x, ndx++);
            }
        }
        if (this.repeat > 0) {
            hex.set((short)(this.repeat / 2 | 0x80), ndx++);
            i = this.oneTime / 2;
            while (i < (this.oneTime + this.repeat) / 2) {
                x = data[i++] << 4;
                if (i < (this.oneTime + this.repeat) / 2) {
                    x |= data[i++];
                }
                hex.set((short)x, ndx++);
            }
        }
        if (this.extra > 0) {
            hex.set((short)(this.extra / 2), ndx++);
            i = (this.oneTime + this.repeat) / 2;
            while (i < (this.oneTime + this.repeat + this.extra) / 2) {
                x = data[i++] << 4;
                if (i < (this.oneTime + this.repeat + this.extra) / 2) {
                    x |= data[i++];
                }
                hex.set((short)x, ndx++);
            }
        }
        return new LearnedSignal(0, 0, format, hex, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.pronto != null && this.pronto.length > 0) {
            for (int val : this.pronto) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(String.format("%04X", val));
            }
        }
        return sb.length() > 0 ? sb.toString() : "** No pronto signal **";
    }

    public String[] toStringArray() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.pronto != null && this.pronto.length > 0) {
            for (int val : this.pronto) {
                list.add(String.format("%04X", val));
            }
        }
        return list.toArray(new String[0]);
    }

    public static class ProntoFormat {
        private int fmtID = 0;
        private int subID = 0;
        private int freqDiv = 0;
        private short[] zMask = null;
        private int offset = 0;
        private int[][] bursts = null;
        private short[] cData = null;
        private Toggle toggle = new Toggle(new int[0]);

        public ProntoFormat() {
        }

        public ProntoFormat(int fmtID, int subID, int freqDiv, int[][] bursts, Toggle ... toggle) {
            this.fmtID = fmtID;
            this.subID = subID;
            this.freqDiv = freqDiv;
            this.bursts = bursts;
            if (toggle != null && toggle.length > 0) {
                this.toggle = toggle[0];
            }
        }

        public ProntoFormat(int fmtID, int subID, int freqDiv, int[][] bursts, int offset, short[] cData, short[] zMask, Toggle ... toggle) {
            this(fmtID, subID, freqDiv, bursts, toggle);
            this.offset = offset;
            this.cData = cData;
            this.zMask = zMask;
        }
    }

    private static class Toggle {
        private int[] chars = null;
        private int[] locations = new int[0];

        public Toggle(int ... vals) {
            if (vals != null && vals.length > 2) {
                this.chars = Arrays.copyOf(vals, 2);
                this.locations = Arrays.copyOfRange(vals, 2, vals.length);
            }
        }

        public boolean atLocation(int pos) {
            for (int loc : this.locations) {
                if (pos != loc) continue;
                return true;
            }
            return false;
        }
    }
}

