/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PropertyFile
extends Properties {
    private File file = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PropertyFile(File file) throws IOException {
        this.file = file;
        if (file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            this.load(in);
            in.close();
            this.updatePropertyNames("Bounds", "KMBounds");
            this.updatePropertyNames("RecentFiles.", "RecentUpgrades.");
        }
    }

    private void updatePropertyNames(String oldBase, String newBase) {
        int i = 0;
        if (oldBase.endsWith(".")) {
            String value;
            do {
                String propertyName;
                if ((value = this.getProperty(propertyName = oldBase + i)) != null) {
                    this.remove(propertyName);
                    this.setProperty(newBase + i, value);
                }
                ++i;
            } while (value != null);
        } else {
            String value = this.getProperty(oldBase);
            if (value != null) {
                this.remove(oldBase);
                this.setProperty(newBase, value);
            }
        }
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file);
        this.store(out, null);
        out.close();
    }

    @Override
    public String setProperty(String name, String value) {
        String oldValue = (String)super.setProperty(name, value);
        this.propertyChangeSupport.firePropertyChange(name, oldValue, value);
        return oldValue;
    }

    public void setProperty(String name, File file) {
        this.setProperty(name, file.getAbsolutePath());
    }

    public File getFileProperty(String name) {
        String value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    public File getFileProperty(String name, File defaultFile) {
        File file = this.getFileProperty(name);
        if (file == null) {
            this.setProperty(name, defaultFile);
            return defaultFile;
        }
        return file;
    }

    public void populateFileMenu(JMenu menu, String prefix, ActionListener l) {
        File f = null;
        int i = 0;
        do {
            String name;
            if ((f = this.getFileProperty(name = prefix + i++)) == null) continue;
            if (f.canRead()) {
                JMenuItem item = new JMenuItem(f.getAbsolutePath());
                menu.add(item);
                item.addActionListener(l);
                continue;
            }
            this.remove(name);
        } while (f != null);
        menu.setEnabled(menu.getItemCount() > 0);
    }

    public File getFile() {
        return this.file;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

