/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.IniSection;
import com.hifiremote.jp1.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Queue;

public class PropertyReader {
    private BufferedReader reader = null;
    private Queue<Property> queue = null;
    private boolean queueSet = false;
    private static final String[] exceptions = new String[]{"Function", "ExtFunction", "Button"};

    public PropertyReader(BufferedReader reader) {
        this.reader = reader;
    }

    public PropertyReader(Queue<Property> queue) {
        this.queue = queue;
    }

    public Property nextProperty() {
        if (this.queue != null) {
            Property p = this.queue.poll();
            if (p != null && p.value.length() == 0 && p.name.length() > 0) {
                p.name = "[" + p.name + "]";
            }
            return p;
        }
        Property property = new Property();
        try {
            String line;
            do {
                if ((line = this.reader.readLine()) != null) continue;
                return null;
            } while ((line = line.trim()).length() != 0 && (line.charAt(0) == '#' || line.charAt(0) == '!'));
            int pos = line.indexOf(61);
            if (pos == -1) {
                pos = line.indexOf(58);
            }
            if (pos == -1) {
                property.name = line;
                property.value = "";
                return property;
            }
            property.name = line.substring(0, pos);
            if (property.name.charAt(pos - 1) == ':') {
                property.name = property.name.substring(0, pos - 1);
            }
            line = line.substring(pos + 1);
            while (line.endsWith("\\") && !this.isException(property.name)) {
                line = line.substring(0, line.length() - 1).trim() + this.reader.readLine().trim();
            }
            property.value = PropertyReader.decode(line);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return property;
    }

    public static String decode(String text) {
        StringBuilder buff = new StringBuilder(text.length());
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '\\') {
                if (chars.length == i + 1) {
                    buff.append(' ');
                    continue;
                }
                if ((ch = chars[++i]) == 'n') {
                    buff.append('\n');
                    continue;
                }
                if (ch == 't') {
                    buff.append('\t');
                    continue;
                }
                if (ch == 'r') {
                    buff.append('\r');
                    continue;
                }
                if (ch == 'u') {
                    String val = new String(chars, ++i, 4);
                    buff.append((char)Integer.parseInt(val));
                    i += 4;
                    continue;
                }
                buff.append(ch);
                continue;
            }
            if (ch == '\u00ae') {
                buff.append('\n');
                continue;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    public IniSection nextSection(Queue<Property> queue) {
        Property p = this.nextProperty();
        while (p != null && p.name.length() == 0) {
            p = this.nextProperty();
        }
        if (p == null) {
            return null;
        }
        IniSection section = new IniSection();
        if (queue != null) {
            section.setQueue(queue);
            this.queueSet = true;
        }
        if (p.name.charAt(0) == '[') {
            section.setName(p.name.substring(1, p.name.length() - 1));
            p = this.nextProperty();
        }
        while (p != null && p.name.length() != 0) {
            section.add(p);
            p = this.nextProperty();
        }
        return section;
    }

    public IniSection nextSection() {
        return this.nextSection(null);
    }

    private boolean isException(String value) {
        for (String exception : exceptions) {
            if (!value.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    public Queue<Property> getQueue() {
        return this.queue;
    }

    public boolean setsQueue() {
        return this.queueSet;
    }
}

