/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.io.FilterWriter;
import java.io.PrintWriter;

public class PropertyWriter
extends FilterWriter {
    private PrintWriter writer = null;
    private boolean fresh = true;

    public PropertyWriter(PrintWriter writer) {
        super(writer);
        this.writer = writer;
    }

    public void printHeader(String name) {
        if (!this.fresh) {
            this.writer.println();
        }
        this.fresh = false;
        this.writer.print('[');
        this.writer.print(name);
        this.writer.println(']');
    }

    public void print(String name, int value) {
        this.print(name, Integer.toString(value));
    }

    public void print(String name, Object obj) {
        this.print(name, obj.toString());
    }

    public void print(String name, String value) {
        this.fresh = false;
        this.writer.print(name);
        this.writer.print('=');
        if (value != null) {
            boolean escapeSpace = true;
            block10: for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == ' ') {
                    if (escapeSpace) {
                        this.writer.print("\\ ");
                        continue;
                    }
                    this.writer.print(ch);
                    continue;
                }
                escapeSpace = false;
                switch (ch) {
                    case '\\': {
                        this.writer.print("\\\\");
                        continue block10;
                    }
                    case '\t': {
                        this.writer.print("\\t");
                        continue block10;
                    }
                    case '\n': {
                        this.writer.print("\\n");
                        continue block10;
                    }
                    case '\r': {
                        this.writer.print("\\r");
                        continue block10;
                    }
                    case '#': {
                        this.writer.print("\\#");
                        continue block10;
                    }
                    case '!': {
                        this.writer.print("\\!");
                        continue block10;
                    }
                    case '=': {
                        this.writer.print("\\=");
                        continue block10;
                    }
                    case ':': {
                        this.writer.print("\\:");
                        continue block10;
                    }
                    default: {
                        this.writer.print(ch);
                    }
                }
            }
        }
        this.writer.println();
    }
}

