/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerPanel;
import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceCmdParm;
import com.hifiremote.jp1.ChoiceDeviceParm;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.CmdParmFactory;
import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceParmFactory;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DirectDefaultValue;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.FlagDeviceParm;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionTableModel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsDialog;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.NumberCmdParm;
import com.hifiremote.jp1.NumberDeviceParm;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.importer.Importer;
import com.hifiremote.jp1.importer.ImporterFactory;
import com.hifiremote.jp1.importer.ReorderImporter;
import com.hifiremote.jp1.initialize.CmdIndexInitializer;
import com.hifiremote.jp1.initialize.Initializer;
import com.hifiremote.jp1.initialize.InitializerFactory;
import com.hifiremote.jp1.translate.Translate;
import com.hifiremote.jp1.translate.Translator;
import com.hifiremote.jp1.translate.TranslatorFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class Protocol {
    public static final int tooDifferent = Integer.MAX_VALUE;
    protected String name = null;
    protected Hex id = null;
    private Hex alternatePID = null;
    private Hashtable<String, List<Hex>> remoteAltPIDs = new Hashtable();
    private Hashtable<String, Hex> remoteAltPID = new Hashtable();
    protected String variantName = null;
    protected String iniIntro = null;
    protected Hex defaultFixedData = null;
    protected Hex fixedDataMask = null;
    protected Hex defaultCmd = null;
    protected int cmdIndex;
    protected DeviceParameter[] devParms = null;
    protected Translate[] deviceTranslators = new Translate[0];
    protected Translate[] devImportTranslators = null;
    protected CmdParameter[] cmdParms = null;
    protected Translate[] cmdTranslators = null;
    private String cmdTranslatorText = null;
    protected Translate[] importCmdTranslators = null;
    protected Importer[] devImporters = null;
    protected HashMap<String, Hex> code = new HashMap(8);
    protected HashMap<String, Hex> customCode = new HashMap(8);
    protected HashMap<String, Translate[]> codeTranslator = new HashMap(7);
    protected Initializer[] cmdParmInit = null;
    protected String notes = null;
    private Integer modifier = null;
    private List<String> oldNames = new ArrayList<String>();
    private List<String> altPIDOverrideList = new ArrayList<String>();
    private List<String> oldRefList = null;
    private boolean keyMovesOnly = false;
    private boolean match = true;
    public Hex oldCustomCode = null;
    public ProtocolUpgrade newCustomCode = null;
    public static final Protocol blank = new Protocol("Blank", new Hex("FF FF"), null);

    public Protocol(String name, Hex id, Properties props) {
        int i;
        StringTokenizer st;
        this.name = name;
        this.id = id;
        if (props == null) {
            props = new Properties();
        }
        this.variantName = props.getProperty("VariantName", "");
        String temp = props.getProperty("DefaultCmd", "00");
        if (temp != null) {
            this.defaultCmd = new Hex(temp);
        }
        this.cmdIndex = Integer.parseInt(props.getProperty("CmdIndex", "0"));
        temp = props.getProperty("AlternatePID");
        if (temp != null) {
            st = new StringTokenizer(temp.trim(), ",");
            this.alternatePID = new Hex(st.nextToken());
            while (st.hasMoreTokens()) {
                this.altPIDOverrideList.add(st.nextToken());
            }
        }
        if ((temp = props.getProperty("OldRefs")) != null) {
            if (this.oldRefList == null) {
                this.oldRefList = new ArrayList<String>();
            }
            st = new StringTokenizer(temp.trim(), ",");
            while (st.hasMoreTokens()) {
                this.oldRefList.add(st.nextToken().trim());
            }
        }
        if ((temp = props.getProperty("DevParms", "")) != null) {
            this.devParms = DeviceParmFactory.createParameters(temp);
        }
        if ((temp = props.getProperty("DeviceTranslator")) != null) {
            this.deviceTranslators = TranslatorFactory.createTranslators(temp);
        }
        if ((temp = props.getProperty("DeviceImporter")) != null) {
            this.devImporters = ImporterFactory.createImporters(temp);
        } else {
            int mappedIndex = 0;
            boolean needRemap = false;
            String[] map = new String[6];
            int maxParm = Math.min(map.length, this.devParms.length);
            for (i = 0; i < maxParm; ++i) {
                if (this.devParms[i].getClass() != FlagDeviceParm.class) {
                    map[i] = Integer.toString(mappedIndex);
                } else {
                    needRemap = true;
                }
                ++mappedIndex;
            }
            if (needRemap) {
                this.devImporters = new Importer[1];
                this.devImporters[0] = new ReorderImporter(map);
            }
        }
        this.defaultFixedData = new Hex(props.getProperty("FixedData", ""));
        temp = props.getProperty("FixedDataMask");
        if (temp != null) {
            this.fixedDataMask = new Hex(temp);
        } else {
            short[] mask = new short[this.defaultFixedData.length()];
            for (int i2 = 0; i2 < mask.length; ++i2) {
                mask[i2] = 255;
            }
            this.fixedDataMask = new Hex(mask);
        }
        temp = props.getProperty("CmdTranslator");
        if (temp != null) {
            this.cmdTranslators = TranslatorFactory.createTranslators(temp);
            this.cmdTranslatorText = temp;
        } else {
            this.cmdTranslators = new Translate[0];
        }
        temp = props.getProperty("ImportCmdTranslator");
        if (temp != null) {
            this.importCmdTranslators = TranslatorFactory.createTranslators(temp);
        }
        if ((temp = props.getProperty("Modifier")) != null) {
            this.modifier = Integer.parseInt(temp);
        }
        this.notes = props.getProperty("Notes");
        int fixedBytes = -1;
        int variableBytes = -1;
        for (String pName : ProcessorManager.getProcessorNames()) {
            temp = props.getProperty("Code." + pName);
            if (temp != null && temp.length() > 0) {
                Hex hex = new Hex(temp);
                short value = hex.getData()[2];
                if (pName.equals("HCS08") || pName.equals("TI2541")) {
                    value = hex.getData()[4];
                }
                int fixedDataLength = value >> 4;
                int cmdLength = value & 0xF;
                if (fixedBytes == -1) {
                    fixedBytes = fixedDataLength;
                    variableBytes = cmdLength;
                } else if (fixedBytes != fixedDataLength || variableBytes != cmdLength) {
                    System.err.println("Protocol code for " + pName + " uses " + fixedDataLength + " fixed bytes and " + cmdLength + " variable bytes instead of " + fixedBytes + " and " + variableBytes);
                }
                this.code.put(pName, hex);
            }
            if (this.code.get("SST") == null && this.code.get("6805-RC16/18") != null) {
                Hex hex = new Hex(this.code.get("6805-RC16/18"));
                Processor p = ProcessorManager.getProcessor("6805", "RC16/18");
                p.doVectorEdit(hex, 48768);
                this.code.put("SST", hex);
            }
            if ((temp = props.getProperty("CodeTranslator." + pName)) == null) continue;
            Translate[] xlators = TranslatorFactory.createTranslators(temp);
            this.codeTranslator.put(pName, xlators);
        }
        temp = props.getProperty("CmdParms", "");
        StringTokenizer st2 = new StringTokenizer(temp, ",");
        int count = st2.countTokens();
        this.cmdParms = new CmdParameter[count];
        for (i = 0; i < count; ++i) {
            String str = st2.nextToken();
            this.cmdParms[i] = CmdParmFactory.createParameter(str, this.devParms, this.cmdParms);
            if (this.cmdParms[i] != null) continue;
            System.err.println("Protocol.Protocol(" + name + ") failed createParameter(" + str + ")");
        }
        temp = props.getProperty("CmdParmInit");
        if (temp != null) {
            this.cmdParmInit = InitializerFactory.create(temp);
        }
        if ((temp = props.getProperty("OldNames")) != null) {
            StringTokenizer st22 = new StringTokenizer(temp, ",");
            while (st22.hasMoreTokens()) {
                this.oldNames.add(st22.nextToken().trim());
            }
        }
        boolean bl = this.keyMovesOnly = (temp = props.getProperty("KeyMovesOnly")) != null;
        if (this.cmdParms.length == 0 && this.code.size() > 0) {
            int i3;
            Set<String> keys = this.code.keySet();
            Iterator<String> it = keys.iterator();
            String key = it.next();
            Hex pCode = this.code.get(key);
            short value = pCode.getData()[2];
            if (key.equals("HCS08") || key.equals("TI2541")) {
                value = pCode.getData()[4];
            }
            int fixedDataLength = value >> 4;
            int cmdLength = value & 0xF;
            short[] hex = new short[fixedDataLength];
            this.defaultFixedData = new Hex(hex);
            int numDevParms = fixedDataLength;
            int styleIndex = numDevParms++;
            int devBitsIndex = -1;
            if (fixedDataLength > 0) {
                devBitsIndex = numDevParms++;
            }
            int cmdBitsIndex = numDevParms++;
            int cmdByteIndex = -1;
            if (cmdLength > 1) {
                cmdByteIndex = numDevParms++;
            }
            this.devParms = new DeviceParameter[numDevParms];
            this.deviceTranslators = new Translator[fixedDataLength];
            DirectDefaultValue defaultZero = new DirectDefaultValue(new Integer(0));
            String[] choices = new String[]{"MSB", "MSB-COMP", "LSB", "LSB-COMP"};
            this.devParms[styleIndex] = new ChoiceDeviceParm("Signal Style", defaultZero, choices);
            DirectDefaultValue defaultEight = new DirectDefaultValue(new Integer(8));
            if (devBitsIndex != -1) {
                this.devParms[devBitsIndex] = new NumberDeviceParm("Bits / Device", defaultEight, 10, 4);
            }
            this.devParms[cmdBitsIndex] = new NumberDeviceParm("Bits / Command", defaultEight, 10, 4);
            if (cmdByteIndex != -1) {
                String[] indexChoices = new String[]{"0", "1"};
                this.devParms[cmdByteIndex] = new ChoiceDeviceParm("Cmd byte index", defaultZero, indexChoices);
                this.cmdParmInit = new Initializer[1];
                this.cmdParmInit[0] = new CmdIndexInitializer(cmdByteIndex, this);
            }
            for (i3 = 0; i3 < fixedDataLength; ++i3) {
                this.devParms[i3] = new NumberDeviceParm("Device " + i3, defaultZero, 10);
                Translator translator = new Translator(false, false, i3, 8, i3 * 8);
                this.deviceTranslators[i3] = translator;
                translator.setStyleIndex(styleIndex);
                if (devBitsIndex == -1) continue;
                translator.setBitsIndex(devBitsIndex);
            }
            hex = new short[cmdLength];
            this.defaultCmd = new Hex(hex);
            this.cmdTranslators = new Translate[cmdLength];
            this.cmdParms = new CmdParameter[cmdLength];
            for (i3 = 0; i3 < cmdLength; ++i3) {
                String parmName = "OBC";
                if (i3 != this.cmdIndex) {
                    parmName = "Byte " + (i3 + 1);
                }
                this.cmdParms[i3] = new NumberCmdParm(parmName, null);
                Translator translator = new Translator(false, false, i3, 8, i3 * 8);
                this.cmdTranslators[i3] = translator;
                translator.setStyleIndex(styleIndex);
                translator.setBitsIndex(cmdBitsIndex);
            }
            short[] mask = new short[this.defaultFixedData.length()];
            for (int i4 = 0; i4 < mask.length; ++i4) {
                mask[i4] = 255;
            }
            this.fixedDataMask = new Hex(mask);
        }
    }

    public Hex getFixedDataMask() {
        return this.fixedDataMask;
    }

    public String getFirstProcessor() {
        Set<String> keys = this.code.keySet();
        Iterator<String> it = keys.iterator();
        String key = it.next();
        System.err.println("Protocol.getFirstProcessor() key=" + key);
        return key;
    }

    public int getCmdLengthFromCode() {
        String proc = this.getFirstProcessor();
        System.err.println("Protocol.getCmdLengthFromCode() proc=" + proc);
        return Protocol.getCmdLengthFromCode(proc, this.code.get(proc));
    }

    public static int getCmdLengthFromCode(String proc, Hex pCode) {
        short value = pCode.getData()[2];
        if (proc.equals("HCS08") || proc.equals("TI2541")) {
            value = pCode.getData()[4];
        }
        return value & 0xF;
    }

    public int getFixedDataLengthFromCode() {
        String proc = this.getFirstProcessor();
        return Protocol.getFixedDataLengthFromCode(proc, this.code.get(proc));
    }

    public static int getFixedDataLengthFromCode(String proc, Hex pCode) {
        short value = pCode.getData()[2];
        if (proc.equals("HCS08") || proc.equals("TI2541")) {
            value = pCode.getData()[4];
        }
        return value >> 4;
    }

    public void reset() {
        int len = this.devParms.length;
        Value[] vals = new Value[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = new Value(null, this.devParms[i].getDefaultValue());
        }
        this.setDeviceParms(vals);
    }

    public void setProperties(Properties props, Remote remote) {
        this.customCode.clear();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith("CustomCode.")) continue;
            String procName = key.substring(11);
            Processor proc = ProcessorManager.getProcessor(procName);
            this.addCustomCode(proc, new Hex(props.getProperty(key)));
        }
    }

    public Hex importUpgradeCode(String notes) {
        Hex importedCode = null;
        StringTokenizer st = new StringTokenizer(notes, "\n");
        String text = null;
        String processor = null;
        while (st.hasMoreTokens()) {
            String temp;
            while (st.hasMoreTokens()) {
                int pos2;
                text = st.nextToken().toUpperCase();
                if (!text.startsWith("UPGRADE PROTOCOL 0 =")) continue;
                int pos = text.indexOf(40);
                processor = text.substring(pos + 1, pos2 = text.indexOf(41, pos));
                if (processor.startsWith("S3C8")) {
                    processor = "S3C80";
                }
                System.err.println("Imported processor name=" + processor);
                break;
            }
            if (!st.hasMoreTokens()) continue;
            text = st.nextToken();
            while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("End")) {
                text = text + ' ' + temp;
            }
            Processor p = ProcessorManager.getProcessor(processor);
            System.err.println("Processor=" + p);
            importedCode = new Hex(text);
            System.err.println("Protocol.importUpgradeCode(), putting code for name=" + p.getEquivalentName() + ",code=" + importedCode);
            this.code.put(p.getEquivalentName(), importedCode);
        }
        return importedCode;
    }

    public void addCustomCode(Processor processor, Hex code) {
        this.customCode.put(processor.getEquivalentName(), code);
    }

    public Hex getCustomCode(Processor processor) {
        return this.customCode.get(processor.getEquivalentName());
    }

    public boolean hasCustomCode() {
        return !this.customCode.isEmpty();
    }

    public ProtocolUpgrade getCustomUpgrade(RemoteConfiguration remoteConfig, boolean checkDevices) {
        if (remoteConfig == null) {
            return null;
        }
        Remote remote = remoteConfig.getRemote();
        String proc = remote.getProcessor().getEquivalentName();
        int pid = this.getID(remote).get(0);
        Hex code = null;
        if (checkDevices) {
            for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                Hex hex = code = du.needsProtocolCode() ? du.getCode() : null;
                Protocol p = du.getProtocol();
                if (p == null || p == this || p.getID(remote).get(0) != pid || code == null) continue;
                this.match = Protocol.getFixedDataLengthFromCode(proc, code) == this.getFixedDataLength() && Protocol.getCmdLengthFromCode(proc, code) == this.getDefaultCmdLength();
                return new ProtocolUpgrade(pid, code, null);
            }
        }
        code = this.getCode(remote);
        this.match = false;
        ProtocolUpgrade first = null;
        ProtocolUpgrade equalled = null;
        for (ProtocolUpgrade pu : remoteConfig.getProtocolUpgrades()) {
            Hex puCode = pu.getCode();
            if (pu.getPid() != pid) continue;
            if (first == null) {
                first = pu;
            }
            if (equalled == null && puCode.equals(code)) {
                equalled = pu;
            }
            boolean bl = this.match = !puCode.equals(code) && Protocol.getFixedDataLengthFromCode(proc, puCode) == this.getFixedDataLength() && Protocol.getCmdLengthFromCode(proc, puCode) == this.getDefaultCmdLength();
            if (!this.match) continue;
            return pu;
        }
        if (equalled != null) {
            this.match = true;
            return equalled;
        }
        this.match = false;
        return first;
    }

    public boolean matched() {
        return this.match;
    }

    public KMPanel getPanel(DeviceUpgrade deviceUpgrade) {
        return null;
    }

    public void initializeParms() {
        if (this.cmdParmInit != null) {
            for (int i = 0; i < this.cmdParmInit.length; ++i) {
                this.cmdParmInit[i].initialize(this.devParms, this.cmdParms);
            }
        }
    }

    public boolean needsCode(Remote remote) {
        return this.getCustomCode(remote.getProcessor()) != null || !remote.supportsVariant(this.id, this.variantName);
    }

    public boolean hasAnyCode() {
        return !this.code.isEmpty();
    }

    public boolean hasCode(Remote remote) {
        return this.getCode(remote) != null;
    }

    public Hex getCode(Remote remote) {
        return this.getCode(remote.getProcessor());
    }

    public Hex getCode(Processor p) {
        Hex hex = this.customCode.get(p.getEquivalentName());
        if (hex == null) {
            hex = this.code.get(p.getEquivalentName());
        }
        return hex;
    }

    public HashMap<String, Hex> getCode() {
        return this.code;
    }

    public Translate[] getCodeTranslators(Remote remote) {
        return this.codeTranslator.get(remote.getProcessor().getEquivalentName());
    }

    public void importDeviceParms(Value[] parms) {
        if (this.devImporters != null) {
            for (int i = 0; i < this.devImporters.length; ++i) {
                parms = this.devImporters[i].convertParms(parms);
            }
        }
        this.setDeviceParms(parms);
    }

    public Value[] importFixedData(Hex hex) {
        Value[] vals = this.getDeviceParmValues();
        for (int i = 0; i < this.deviceTranslators.length; ++i) {
            this.deviceTranslators[i].out(hex, vals, this.devParms);
        }
        return vals;
    }

    public void setDeviceParms(Value[] parms) {
        if (parms.length != this.devParms.length) {
            System.err.println("Protocol.setDeviceParms(), protocol=" + this.getDiagnosticName() + ", parms.length=" + parms.length + " and devParms.length=" + this.devParms.length);
        }
        for (int i = 0; i < parms.length; ++i) {
            if (i >= this.devParms.length || parms[i] == null) continue;
            this.devParms[i].setValue(parms[i].getUserValue());
        }
    }

    public Value[] getDeviceParmValues() {
        Value[] rc = new Value[this.devParms.length];
        for (int i = 0; i < rc.length; ++i) {
            DeviceParameter parm = this.devParms[i];
            rc[i] = new Value(parm.getValue(), parm.getDefaultValue());
        }
        return rc;
    }

    public int getOEMParmVariance(Value[] vals) {
        int index = 0;
        for (int i = 0; i < this.devParms.length; ++i) {
            String parmName = this.devParms[i].getName().toUpperCase();
            if (!parmName.startsWith("OEM") && !parmName.startsWith("PARM") || !(vals[i].getValue() instanceof Integer) || !(this.devParms[i].getDefaultValue().value() instanceof Integer)) continue;
            Integer userValue = (Integer)vals[i].getValue();
            Integer defaultValue = (Integer)this.devParms[i].getDefaultValue().value();
            index += Math.abs(userValue - defaultValue);
        }
        return index;
    }

    public Hex getDefaultCmd() {
        int i;
        Hex rc = null;
        try {
            rc = (Hex)this.defaultCmd.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        Value[] vals = new Value[this.cmdParms.length];
        for (i = 0; i < this.cmdParms.length; ++i) {
            DefaultValue def = this.cmdParms[i].getDefaultValue();
            Object val = null;
            if (def != null) {
                val = def.value();
            }
            vals[i] = new Value(val);
        }
        for (i = 0; i < this.cmdTranslators.length; ++i) {
            this.cmdTranslators[i].in(vals, rc, this.devParms, -1);
        }
        return rc;
    }

    public int getCmdIndex() {
        return this.cmdIndex;
    }

    public boolean setCmdIndex(int newIndex) {
        boolean nameChanged = false;
        if (this.cmdIndex != newIndex) {
            if (this.cmdParms[newIndex].getName().equals("Byte " + (newIndex + 1))) {
                this.cmdParms[newIndex].setName("OBC");
                nameChanged = true;
            }
            if (this.cmdParms[this.cmdIndex].getName().equals("OBC")) {
                this.cmdParms[this.cmdIndex].setName("Byte " + (this.cmdIndex + 1));
                nameChanged = true;
            }
            this.cmdIndex = newIndex;
        }
        return nameChanged;
    }

    public DeviceParameter[] getDeviceParameters() {
        return this.devParms;
    }

    public CmdParameter[] getCommandParameters() {
        return this.cmdParms;
    }

    public String getNotes() {
        return this.notes;
    }

    public List<String> getOldNames() {
        return this.oldNames;
    }

    public int getColumnCount() {
        return this.cmdParms.length;
    }

    public Class<?> getColumnClass(int col) {
        return this.cmdParms[col].getValueClass();
    }

    public TableCellEditor getColumnEditor(int col) {
        return this.cmdParms[col].getEditor();
    }

    public TableCellRenderer getColumnRenderer(int col) {
        return this.cmdParms[col].getRenderer();
    }

    public String getColumnName(int col) {
        return this.cmdParms[col].getDisplayName();
    }

    public Value[] getValues(Hex hex) {
        int i;
        Value[] vals = new Value[this.cmdParms.length];
        for (i = 0; i < this.cmdTranslators.length; ++i) {
            this.cmdTranslators[i].out(hex, vals, this.devParms);
        }
        for (i = 0; i < this.cmdParms.length; ++i) {
            vals[i].setDefaultValue(this.cmdParms[i].getDefaultValue());
        }
        return vals;
    }

    public Object getValueAt(int col, Hex hex) {
        Value[] vals = this.getValues(hex);
        Value v = vals[col];
        if (v == null) {
            System.err.println("Protocol.getValueAt(" + col + ") failed");
            return new Integer(0);
        }
        return this.cmdParms[col].getValue(v.getValue());
    }

    public void setValueAt(int col, Hex hex, Object value) {
        Value[] vals = this.getValues(hex);
        vals[col] = new Value(this.cmdParms[col].convertValue(value), null);
        for (int i = 0; i < this.cmdTranslators.length; ++i) {
            this.cmdTranslators[i].in(vals, hex, this.devParms, col);
        }
    }

    public void importCommand(Hex hex, String text, boolean useOBC, int obcIndex, boolean useEFC) {
        if (useEFC) {
            EFC.toHex(Short.parseShort(text), hex, this.cmdIndex);
        } else if (useOBC) {
            this.setValueAt(obcIndex, hex, new Short(text));
        } else {
            EFC5.toHex(Integer.parseInt(text), hex);
        }
    }

    public void importCommandParms(Hex hex, String text) {
        System.err.println("Protocol.importCommandParms( " + text + " ), cmdParms.length=" + this.cmdParms.length);
        if (this.cmdParms.length == 1) {
            return;
        }
        Translate[] translators = this.importCmdTranslators;
        if (translators == null) {
            translators = this.cmdTranslators;
        }
        StringTokenizer st = new StringTokenizer(text);
        Value[] values = new Value[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            Object obj = null;
            try {
                obj = new Integer(val);
            }
            catch (NumberFormatException x) {
                obj = val;
            }
            values[index++] = new Value(obj);
        }
        for (index = 0; index < values.length; ++index) {
            for (int i = 0; i < translators.length; ++i) {
                translators[i].in(values, hex, this.devParms, index);
            }
        }
    }

    public boolean isEditable(int col) {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Hex getID() {
        return this.id;
    }

    public Hex getAlternatePID() {
        return this.alternatePID;
    }

    public List<String> getOldRefList() {
        return this.oldRefList;
    }

    public void saveAltPID(Remote remote) {
        if (this instanceof ManualProtocol) {
            return;
        }
        Hex id = this.remoteAltPID.get(remote.getSignature());
        if (id != null && id.length() > 0) {
            this.putAlternatePID(remote, id);
        }
    }

    public boolean putAlternatePID(Remote remote, Hex id) {
        boolean isNew = true;
        String sig = remote.getSignature();
        List<Hex> pids = this.remoteAltPIDs.get(sig);
        if (pids == null) {
            pids = new ArrayList<Hex>();
            pids.add(id);
            this.remoteAltPIDs.put(sig, pids);
        } else {
            boolean bl = isNew = !pids.contains(id);
            if (!isNew) {
                pids.remove(id);
            }
            pids.add(id);
        }
        ProtocolManager.getProtocolManager().putAltPIDRemote(id, remote, this);
        return isNew;
    }

    public void removeAltPID(Remote remote) {
        this.remoteAltPID.remove(remote.getSignature());
    }

    public void setAltPID(Remote remote, Hex id) {
        if (this instanceof ManualProtocol) {
            if (id.get(0) > 511 && !remote.usesTwoBytePID()) {
                this.alternatePID = new Hex(id);
                return;
            }
            this.alternatePID = null;
            ProtocolManager pm = ProtocolManager.getProtocolManager();
            pm.remove(this);
            String pidStr1 = this.id.toString();
            String pidStr2 = id.toString();
            String newName = null;
            String defaultName = null;
            if (this.name.contains(pidStr1)) {
                newName = this.name.replace(pidStr1, pidStr2);
            } else {
                pidStr1 = pidStr1.replace(" ", "");
                pidStr2 = pidStr2.replace(" ", "");
                if (this.name.contains(pidStr1)) {
                    newName = this.name.replace(pidStr1, pidStr2);
                }
            }
            if (newName != null && pm.findProtocolForRemote(remote, newName) != null) {
                defaultName = ManualProtocol.getDefaultName(id);
                String title = "Change of PID for Manual Protocol";
                String message = "Changing the PID of this protocol from " + this.id + " to " + id + " would normally also change its name\nfrom \"" + this.name + "\" to \"" + newName + "\", but there is already a protocol\nwith that name so it will instead be re-named as \"" + defaultName + "\".\n\nIs this OK?  Answering NO will cancel the change and allow you to choose a different PID.";
                if (JOptionPane.showConfirmDialog(null, message, title, 0, 2) == 0) {
                    newName = defaultName;
                } else {
                    return;
                }
            }
            if (newName != null) {
                this.name = newName;
            }
            this.id.put(id);
            pm.add(this);
            return;
        }
        if (id == null || id.length() == 0) {
            this.remoteAltPID.remove(remote.getSignature());
        } else {
            this.remoteAltPID.put(remote.getSignature(), id);
        }
    }

    public Hex getID(Remote remote) {
        return this.getID(remote, true);
    }

    public Hex getID(Remote remote, boolean allowUserPID) {
        if (remote.supportsVariant(this.id, this.variantName)) {
            return this.id;
        }
        Hex altPID = this.remoteAltPID.get(remote.getSignature());
        if (allowUserPID && altPID != null) {
            return altPID;
        }
        if (this.alternatePID == null) {
            return this.id;
        }
        Protocol p = ProtocolManager.getProtocolManager().findProtocolForRemote(remote, this.id, false);
        if (p == null && (remote.usesTwoBytePID() || this.id.get(0) < 512)) {
            return this.id;
        }
        if (this.altPIDOverrideList.isEmpty()) {
            return this.alternatePID;
        }
        String builtin = p.getVariantName();
        if (builtin == null || builtin.isEmpty()) {
            builtin = "none";
        }
        for (String temp : this.altPIDOverrideList) {
            if (!temp.equalsIgnoreCase(builtin)) continue;
            return this.id;
        }
        return this.alternatePID;
    }

    public Hashtable<String, List<Hex>> getRemoteAltPIDs() {
        return this.remoteAltPIDs;
    }

    public Hashtable<String, Hex> getRemoteAltPID() {
        return this.remoteAltPID;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    public String getVariantDisplayName(Processor processor) {
        String variant = this.variantName;
        if (this.getCustomCode(processor) != null) {
            variant = variant.equals("") ? "Custom" : variant + "-Custom";
        }
        return variant;
    }

    public String getDiagnosticName() {
        String result = "\"" + this.name + "\" (" + this.id;
        if (this.variantName.length() > 0) {
            result = result + " : " + this.variantName;
        }
        return result + ")";
    }

    public Hex getFixedData(Value[] parms) {
        Hex temp = null;
        try {
            temp = (Hex)this.defaultFixedData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (parms == null) {
            return temp;
        }
        if (this.deviceTranslators != null) {
            for (int i = 0; i < this.deviceTranslators.length; ++i) {
                this.deviceTranslators[i].in(parms, temp, this.devParms, -1);
            }
        }
        return temp;
    }

    public int getFixedDataLength() {
        return this.defaultFixedData.length();
    }

    public int getDefaultCmdLength() {
        return this.defaultCmd.length();
    }

    public ManualProtocol convertToManual(Remote remote, Value[] parmValues, Hex customCode) {
        int cmdLen = this.getDefaultCmdLength();
        int cmdType = cmdLen == 1 ? 0 : 1;
        Hex pid = null;
        try {
            pid = (Hex)(remote != null ? this.getID(remote) : this.getID()).clone();
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        String newName = ManualProtocol.getDefaultName(pid);
        short[] fixedData = this.getFixedData(parmValues).getData();
        ArrayList<Value> parms = new ArrayList<Value>();
        for (int i = 0; i < fixedData.length; ++i) {
            parms.add(new Value(fixedData[i]));
        }
        ManualProtocol convertedProtocol = new ManualProtocol(newName, pid, cmdType, "", 8, parms, new short[0], 8);
        if (remote != null) {
            convertedProtocol.setCode(customCode, remote.getProcessor());
        }
        return convertedProtocol;
    }

    public boolean convertFunctions(List<Function> funcs, Protocol newProtocol, boolean preserveOBC) {
        Object[] buttonText;
        String message;
        JPanel panel;
        int rc;
        if (!preserveOBC) {
            int oldLength = this.defaultCmd.length();
            int newLength = newProtocol.getDefaultCmdLength();
            if (newLength == oldLength) {
                return true;
            }
            for (Function f : funcs) {
                Hex hex = f.getHex();
                if (hex == null) continue;
                Hex newHex = new Hex(newLength);
                for (int i = 0; i < newLength; ++i) {
                    newHex.getData()[i] = i < oldLength ? hex.getData()[i] : (short)0;
                }
                f.setHex(newHex);
            }
            return true;
        }
        CmdParameter[] newParms = newProtocol.cmdParms;
        int max = this.cmdParms.length;
        if (newProtocol.cmdParms.length < max) {
            max = newProtocol.cmdParms.length;
        }
        int matchingParms = 0;
        int[] oldIndex = new int[max];
        int[] newIndex = new int[max];
        block4: for (int i = 0; i < this.cmdParms.length; ++i) {
            String name = this.cmdParms[i].getName();
            for (int j = 0; j < newParms.length; ++j) {
                if (!name.equals(newParms[j].getName())) continue;
                oldIndex[matchingParms] = i;
                newIndex[matchingParms] = j;
                ++matchingParms;
                continue block4;
            }
        }
        Value[] currValues = new Value[this.cmdParms.length];
        Value[] newValues = new Value[newProtocol.cmdParms.length];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = new Value(null, newProtocol.cmdParms[i].getDefaultValue());
        }
        ArrayList<List<String>> failedToConvert = new ArrayList<List<String>>();
        Hex[] convertedHex = new Hex[funcs.size()];
        int index = 0;
        for (Function f : funcs) {
            Hex hex = f.getHex();
            Hex newHex = newProtocol.getDefaultCmd();
            if (hex != null) {
                int i;
                for (i = 0; i < this.cmdTranslators.length; ++i) {
                    this.cmdTranslators[i].out(hex, currValues, this.devParms);
                }
                for (i = 0; i < matchingParms; ++i) {
                    newValues[newIndex[i]] = currValues[oldIndex[i]];
                }
                try {
                    for (i = 0; i < newProtocol.cmdTranslators.length; ++i) {
                        newProtocol.cmdTranslators[i].in(newValues, newHex, newProtocol.devParms, -1);
                    }
                }
                catch (IllegalArgumentException ex) {
                    ArrayList<String> temp = new ArrayList<String>(2);
                    temp.add(f.getName());
                    temp.add(ex.getMessage());
                    failedToConvert.add(temp);
                }
                convertedHex[index++] = newHex;
                continue;
            }
            convertedHex[index++] = null;
        }
        if (!failedToConvert.isEmpty() && (rc = JOptionPane.showOptionDialog(null, panel = Protocol.getErrorPanel(message = "<html>The following functions could not be converted for use with the " + newProtocol.getName() + " protocol.<p>If you need help figuring out what to do about this, please post<br>a question in the JP1 Forums at http://www.hifi-remote.com/forums</html>", failedToConvert), "Change Protocol Error", 0, 2, null, buttonText = new String[]{"Use " + newProtocol + " anyway", "Revert to " + this}, buttonText[0])) == 1) {
            return false;
        }
        index = 0;
        for (Function f : funcs) {
            f.setHex(convertedHex[index++]);
        }
        return true;
    }

    public static JPanel getErrorPanel(String message, List<List<String>> failedToConvert) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel text = new JLabel(message);
        text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)text, "North");
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("Function");
        titles.add("Reason");
        Object[][] failedToConvertArray = new String[failedToConvert.size()][];
        int i = 0;
        for (List<String> l : failedToConvert) {
            failedToConvertArray[i++] = l.toArray(new String[2]);
        }
        JTableX table = new JTableX(failedToConvertArray, titles.toArray());
        Dimension d = table.getPreferredScrollableViewportSize();
        int showRows = Math.min(14, failedToConvert.size());
        d.height = table.getRowHeight() * showRows;
        int nameWidth = 0;
        int warningWidth = 0;
        TableColumnModel cm = table.getColumnModel();
        JTableHeader th = table.getTableHeader();
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)th.getDefaultRenderer();
        for (int j = 0; j < failedToConvertArray.length; ++j) {
            Object[] vals = failedToConvertArray[j];
            cr.setText((String)vals[0]);
            nameWidth = Math.max(nameWidth, cr.getPreferredSize().width);
            cr.setText((String)vals[1]);
            warningWidth = Math.max(warningWidth, cr.getPreferredSize().width);
        }
        cm.getColumn(0).setPreferredWidth(nameWidth);
        cm.getColumn(1).setPreferredWidth(warningWidth);
        d.width = nameWidth + table.getIntercellSpacing().width + warningWidth + 10;
        table.setPreferredScrollableViewportSize(d);
        panel.add((Component)new JScrollPane(table), "Center");
        return panel;
    }

    public ProtocolUpgrade getProtocolUpgrade(Remote remote) {
        int pid = this.getID(remote).get(0);
        Hex code = this.getCode(remote);
        if (code == null) {
            return null;
        }
        if (code.length() != 0) {
            code = remote.getProcessor().translate(code, remote);
        }
        ProtocolUpgrade pu = new ProtocolUpgrade(pid, code, null);
        pu.setProtocol(this);
        return pu;
    }

    public void saveCode(RemoteConfiguration remoteConfig, Hex code) {
        Remote remote = remoteConfig.getRemote();
        ProtocolUpgrade pu = this.getProtocolUpgrade(remote);
        if (code != null) {
            pu.setCode(code);
        }
        remoteConfig.getProtocolUpgrades().add(pu);
        if (!(this instanceof ManualProtocol)) {
            pu.setManualProtocol(remote);
        }
    }

    public void updateFunctions(List<Function> funcs) {
        Value[] values = new Value[this.cmdParms.length];
        for (Function f : funcs) {
            int i;
            Hex hex = f.getHex();
            if (hex == null) continue;
            for (i = 0; i < this.cmdTranslators.length; ++i) {
                this.cmdTranslators[i].out(hex, values, this.devParms);
            }
            for (i = 0; i < this.cmdTranslators.length; ++i) {
                this.cmdTranslators[i].in(values, hex, this.devParms, -1);
            }
            f.setHex(hex);
        }
    }

    public int different(Properties props) {
        Hex hex;
        Hex pid = new Hex(props.getProperty("Protocol"));
        if (!pid.equals(this.id)) {
            return Integer.MAX_VALUE;
        }
        int result = 0;
        String str = props.getProperty("Protocol.name");
        if (str != null && !str.equals(this.name)) {
            result += 1000;
        }
        if ((str = props.getProperty("FixedData")) != null && (hex = new Hex(str)).length() != this.defaultFixedData.length()) {
            result += 2000;
        }
        return result;
    }

    public Protocol editProtocol(Remote remote, Component locator) {
        ManualProtocol mp = null;
        Hex codeWhenNull = null;
        Processor processor = remote.getProcessor();
        String proc = processor.getEquivalentName();
        ProtocolManager pm = ProtocolManager.getProtocolManager();
        Hex originalCode = this.code.get(proc);
        originalCode = originalCode != null ? processor.translate(originalCode, remote) : new Hex(0);
        if (this.getClass() == ManualProtocol.class) {
            pm.remove(this);
            mp = new ManualProtocol(((ManualProtocol)this).getIniSection());
            pm.add(mp);
        } else {
            ProtocolUpgrade pu = this.getProtocolUpgrade(remote);
            if (pu == null) {
                pu = new ProtocolUpgrade(this.getID(remote).get(0), new Hex(0), null);
            }
            int fixedDataLength = this.getFixedDataLength();
            int cmdLength = this.getDefaultCmdLength();
            pu.setManualProtocol(remote, fixedDataLength, cmdLength);
            mp = pu.getManualProtocol(remote);
            pm.remove(mp);
            mp.setName(this.getName());
            mp.setVariantName(this.variantName == null || this.variantName.equals("") ? "Custom" : this.variantName + "-Custom");
            mp.iniIntro = this.iniIntro;
            if (ProtocolManager.getProtocolManager().getBuiltinProtocolsForRemote(remote, mp.getID()).contains(this) && this.getCodeTranslators(remote) == null) {
                if (this.getCustomCode(remote.getProcessor()) == null) {
                    mp.setCode(new Hex(), remote.getProcessor());
                }
            } else {
                codeWhenNull = originalCode;
            }
        }
        ManualSettingsDialog dialog = new ManualSettingsDialog((JFrame)SwingUtilities.getRoot(locator), mp);
        dialog.setRemote(remote);
        ManualSettingsPanel settingsPanel = dialog.getManualSettingsPanel();
        settingsPanel.pid.setEditable(false);
        settingsPanel.pid.setEnabled(false);
        if (this.getClass() != ManualProtocol.class) {
            settingsPanel.getDevicePanel().setForCustomCode();
            settingsPanel.setDisplayProtocol(this);
            settingsPanel.setProtocol(mp, false);
            settingsPanel.setDisplayProcessor(processor);
            settingsPanel.setSelectedCode(processor);
            settingsPanel.getDeviceText().setText(settingsPanel.getProtocolText(true, false));
        } else {
            settingsPanel.setSelectedCode(processor);
            settingsPanel.getDeviceText().setText(settingsPanel.getProtocolText(true, true));
        }
        AssemblerPanel ap = settingsPanel.getAssemblerPanel();
        ap.getEditorPanel().actionPerformed(new ActionEvent(ap.importHexButton, 1001, ""));
        dialog.setMessage(this instanceof ManualProtocol ? 1 : 2);
        settingsPanel.getTablePanel().getCodeModel().setCodeWhenNull(codeWhenNull);
        dialog.setVisible(true);
        ManualProtocol result = dialog.getProtocol();
        if (result != null && this.getClass() != ManualProtocol.class) {
            Hex returnCode = result.code.get(proc);
            if (returnCode != null && returnCode.length() != 0) {
                returnCode = processor.translate(returnCode, remote);
            }
            if (returnCode == null || returnCode.length() == 0) {
                if (codeWhenNull != null) {
                    this.customCode.put(proc, new Hex());
                } else {
                    this.customCode.remove(proc);
                }
            } else if (returnCode.equals(originalCode)) {
                this.customCode.remove(proc);
            } else {
                String title = "Custom protocol code";
                String message = "The custom code you have set is not consistent with the protocol\nconcerned.  It differs in the length of either the fixed or command\ndata.  Do you wish to cancel this edit?\n\nTo apply the edit despite this problem, select NO.";
                if (originalCode.length() < 5 || Protocol.getFixedDataLengthFromCode(proc, returnCode) == Protocol.getFixedDataLengthFromCode(proc, originalCode) && Protocol.getCmdLengthFromCode(proc, returnCode) == Protocol.getCmdLengthFromCode(proc, originalCode) || JOptionPane.showConfirmDialog(null, message, title, 0, 2) == 1) {
                    this.customCode.put(proc, returnCode);
                }
            }
        } else if (result == null && this.getClass() == ManualProtocol.class) {
            pm.remove(mp);
            pm.add(this);
        }
        return result;
    }

    public String getIniIntro() {
        return this.iniIntro;
    }

    public void store(PropertyWriter out, Value[] parms, Remote remote) throws IOException {
        Hex fixedData;
        out.print("Protocol", this.getID(remote, false).toString());
        Hex altPID = this.remoteAltPID.get(remote.getSignature());
        if (!(this instanceof ManualProtocol) && altPID != null && altPID.length() > 0) {
            out.print("Protocol.altPID", altPID.toString());
        }
        out.print("Protocol.name", this.getName());
        if (this.variantName.length() > 0) {
            out.print("Protocol.variantName", this.variantName);
        }
        if (parms != null && parms.length != 0) {
            out.print("ProtocolParms", DeviceUpgrade.valueArrayToString(parms));
        }
        if ((fixedData = this.getFixedData(parms)) != null) {
            out.print("FixedData", fixedData.toString());
        }
        for (Map.Entry<String, Hex> entry : this.customCode.entrySet()) {
            out.print("CustomCode." + entry.getKey(), entry.getValue().toString());
        }
    }

    public void modifyParms(FunctionTableModel model, int row) {
        if (this.modifier == null) {
            return;
        }
        if (this.modifier == 1) {
            Hex hex = null;
            Protocol protocol = model.getProtocol();
            for (int n = 0; n < model.getColumnCount(); ++n) {
                if (!model.getColumnName(n).equals("Hex")) continue;
                Object obj = model.getValueAt(row, n);
                if (!(obj instanceof Hex)) break;
                hex = (Hex)obj;
                break;
            }
            if (hex != null) {
                boolean hasPrefix = (hex.getData()[1] & 1) == 1;
                CmdParameter cmdParm = protocol.getCommandParameters()[2];
                Choice[] choices = null;
                int variant = Integer.parseInt(this.variantName);
                if (cmdParm instanceof ChoiceCmdParm) {
                    choices = ((ChoiceCmdParm)cmdParm).getChoices();
                }
                if (choices != null) {
                    choices[0].setHidden(hasPrefix);
                    choices[1].setHidden(hasPrefix && variant == 4);
                    choices[2].setHidden(hasPrefix && variant == 4);
                    choices[3].setHidden(hasPrefix && variant == 4);
                    choices[4].setHidden(!hasPrefix || variant == 4);
                    choices[5].setHidden(!hasPrefix);
                }
            }
        }
    }

    public Translate[] getDeviceTranslators() {
        return this.deviceTranslators;
    }

    public Translate[] getCmdTranslators() {
        return this.cmdTranslators;
    }

    public String getCmdTranslatorText() {
        return this.cmdTranslatorText;
    }

    public boolean isColumnWidthFixed(int col) {
        return true;
    }

    public boolean getKeyMovesOnly() {
        return this.keyMovesOnly;
    }

    public Integer getModifier() {
        return this.modifier;
    }
}

