/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerTableModel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexFormat;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.assembler.CommonData;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;

public class ProtocolDataPanel
extends JPanel {
    private ActionListener pfpdListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean is2;
            int val;
            Object source = e.getSource();
            if (source == ProtocolDataPanel.this.frequency || source == ProtocolDataPanel.this.dutyCycle) {
                Hex.put(ProtocolDataPanel.this.getCarrierData(ProtocolDataPanel.this.frequency.getValue(), ProtocolDataPanel.this.dutyCycle.getValue()), ProtocolDataPanel.this.basicValues, 0);
                if (ProtocolDataPanel.this.dataStyle > 2 && source == ProtocolDataPanel.this.frequency && ProtocolDataPanel.this.basicValues[0] == 0) {
                    ProtocolDataPanel.this.setPFbits(2, 16, 2, 5);
                }
            } else if (source == ProtocolDataPanel.this.devBytes) {
                val = ProtocolDataPanel.this.devBytes.getSelectedIndex();
                boolean bl = is2 = val == 2;
                if (ProtocolDataPanel.this.dataStyle > 2) {
                    is2 = is2 && (ProtocolDataPanel.this.pfValues[0] & 0x58) != 8;
                }
                ProtocolDataPanel.this.devBits1lbl.setText(is2 ? "Bits/Dev1" : "Bits/Dev");
                ProtocolDataPanel.this.devBits2lbl.setVisible(is2);
                if (!is2) {
                    ProtocolDataPanel.this.devBits2.setSelectedIndex(-1);
                }
                ProtocolDataPanel.this.devBits2.setEnabled(is2);
                if (!ProtocolDataPanel.this.isSettingPF) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(0, Math.min(val, 3), 0, 2);
                    }
                    if (ProtocolDataPanel.this.basicValues[2] == null) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[2] = 0;
                    }
                    ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[2] = (short)(ProtocolDataPanel.this.basicValues[2] & 0xF | ProtocolDataPanel.this.devBytes.getSelectedIndex() << 4);
                    if (!is2) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[((ProtocolDataPanel)ProtocolDataPanel.this).dataStyle < 2 ? 16 : (((ProtocolDataPanel)ProtocolDataPanel.this).dataStyle < 3 ? 14 : 13)] = null;
                    }
                }
            } else if (source == ProtocolDataPanel.this.cmdBytes) {
                val = ProtocolDataPanel.this.cmdBytes.getSelectedIndex();
                is2 = val == 2 && ProtocolDataPanel.this.dataStyle < 3;
                ProtocolDataPanel.this.cmdBits1lbl.setText(is2 ? "Bits/Cmd1" : "Bits/Cmd");
                ProtocolDataPanel.this.cmdBits2lbl.setVisible(is2);
                if (!is2) {
                    ProtocolDataPanel.this.cmdBits2.setSelectedIndex(-1);
                }
                ProtocolDataPanel.this.cmdBits2.setEnabled(is2);
                if (!ProtocolDataPanel.this.isSettingPF) {
                    if (ProtocolDataPanel.this.basicValues[2] == null) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[2] = 0;
                    }
                    ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[2] = (short)(ProtocolDataPanel.this.basicValues[2] & 0xF0 | ProtocolDataPanel.this.cmdBytes.getSelectedIndex());
                    if (!is2 && ProtocolDataPanel.this.dataStyle < 3) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[((ProtocolDataPanel)ProtocolDataPanel.this).dataStyle < 2 ? 18 : 16] = null;
                    }
                }
            } else if (source == ProtocolDataPanel.this.leadInStyle) {
                int index = ProtocolDataPanel.this.leadInStyle.getSelectedIndex();
                ProtocolDataPanel.this.leadInOn.setEnabled(index > 0);
                ProtocolDataPanel.this.leadInOff.setEnabled(index > 0);
                ProtocolDataPanel.this.leadInOnLbl.setEnabled(index > 0);
                ProtocolDataPanel.this.leadInOffLbl.setEnabled(index > 0);
                if (ProtocolDataPanel.this.isSettingPF) {
                    return;
                }
                if (index == 0) {
                    ProtocolDataPanel.this.burstMidFrame.setSelectedIndex(0);
                    ProtocolDataPanel.this.leadInOn.setValue("");
                    ProtocolDataPanel.this.leadInOff.setValue("");
                } else {
                    if (ProtocolDataPanel.this.leadInOn.getValue() == null) {
                        ProtocolDataPanel.this.leadInOn.setValue(ProtocolDataPanel.this.dataStyle == 2 ? "4" : (ProtocolDataPanel.this.dataStyle > 2 ? "" + Math.max(ProtocolDataPanel.this.burstUnit / 1000, 5) : "0"));
                    }
                    if (ProtocolDataPanel.this.leadInOff.getValue() == null) {
                        ProtocolDataPanel.this.leadInOff.setValue("0");
                    }
                }
                if (ProtocolDataPanel.this.dataStyle < 3) {
                    ProtocolDataPanel.this.setPFbits(1, index, 2, 2);
                    if (index == 0) {
                        ProtocolDataPanel.this.burstMidFrame.setSelectedIndex(0);
                    }
                }
            }
            if (ProtocolDataPanel.this.dataStyle > 2) {
                boolean rpt = ProtocolDataPanel.this.rptType.getSelectedIndex() >= 0 && ProtocolDataPanel.this.rptValue.getValue() != null && (Long)ProtocolDataPanel.this.rptValue.getValue() > 0L;
                ProtocolDataPanel.this.rptHold.setEnabled(!rpt);
                if (rpt && ProtocolDataPanel.this.rptType.getSelectedIndex() < ProtocolDataPanel.this.rptHold.getModel().getSize()) {
                    ProtocolDataPanel.this.rptHold.setSelectedIndex(ProtocolDataPanel.this.rptType.getSelectedIndex());
                }
                ProtocolDataPanel.this.useAltLeadOut.setEnabled(true);
            } else {
                ProtocolDataPanel.this.rptHold.setEnabled(true);
                boolean b = ProtocolDataPanel.this.useAltFreq.getSelectedIndex() == 0 && ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() == 0;
                ProtocolDataPanel.this.useAltLeadOut.setEnabled(b);
                ProtocolDataPanel.this.altLeadOut.setEnabled(b);
                b = ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 0 && ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() == 0;
                ProtocolDataPanel.this.useAltFreq.setEnabled(b);
                ProtocolDataPanel.this.altFreq.setEnabled(b);
                ProtocolDataPanel.this.altDuty.setEnabled(b);
                b = ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 0 && ProtocolDataPanel.this.useAltFreq.getSelectedIndex() == 0 && ProtocolDataPanel.this.leadInStyle.getSelectedIndex() > 0;
                ProtocolDataPanel.this.burstMidFrame.setEnabled(b);
                ProtocolDataPanel.this.afterBits.setEnabled(b);
            }
            if (!ProtocolDataPanel.this.isSettingPF) {
                if (ProtocolDataPanel.this.dataStyle > 2) {
                    boolean altLO = ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 1 && ProtocolDataPanel.this.altLeadOut.getValue() != null && (Long)ProtocolDataPanel.this.altLeadOut.getValue() > 0L;
                    ProtocolDataPanel.this.setPFbits(1, altLO || ProtocolDataPanel.this.rptHold.getSelectedIndex() == 1 ? 1 : 0, 1, 1);
                    ProtocolDataPanel.this.setPFbits(1, altLO || ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 3 ? 1 : 0, 2, 1);
                    ProtocolDataPanel.this.setPFbits(1, ProtocolDataPanel.this.leadInStyle.getSelectedIndex() > 0 ? 1 : 0, 4, 1);
                    Long val2 = (Long)ProtocolDataPanel.this.rptValue.getValue();
                    if (ProtocolDataPanel.this.rptType.getSelectedIndex() == 1) {
                        ProtocolDataPanel.this.assemblerModel.setForcedRptCount(0);
                    } else {
                        ProtocolDataPanel.this.assemblerModel.setForcedRptCount((short)(val2 == null ? 0 : (short)val2.longValue()));
                    }
                    Long t = (Long)ProtocolDataPanel.this.burst1On.getValue();
                    if (t == null) {
                        t = (Long)ProtocolDataPanel.this.burst0On.getValue();
                    }
                    ProtocolDataPanel.this.setONtime34(t, 0, null);
                    if (ProtocolDataPanel.this.burst0On.getValue() == null || ProtocolDataPanel.this.burst1On.getValue() == null || ProtocolDataPanel.this.testONtime34((Long)ProtocolDataPanel.this.burst0On.getValue()) == ProtocolDataPanel.this.testONtime34((Long)ProtocolDataPanel.this.burst1On.getValue())) {
                        ProtocolDataPanel.this.setPFbits(2, 0, 3, 1);
                        if (ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 3) {
                            if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 0) {
                                t = (Long)ProtocolDataPanel.this.leadOutOff.getValue();
                                if (ProtocolDataPanel.this.dataStyle == 3) {
                                    ProtocolDataPanel.this.setOFFtime34(t, 14, CommonData.leadinOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                                }
                                if (ProtocolDataPanel.this.dataStyle == 4) {
                                    Hex.put(t == null ? null : Integer.valueOf((int)(t / 4L + 10L)), ProtocolDataPanel.this.pdValues, 14);
                                }
                                ProtocolDataPanel.this.setOFFtime34((t = (Long)ProtocolDataPanel.this.leadInOff.getValue()) == null ? null : Long.valueOf(t / 2L), 16, CommonData.burstOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                            } else {
                                ProtocolDataPanel.this.errorMessage(2);
                            }
                        } else {
                            Hex.put(null, ProtocolDataPanel.this.pdValues, 16);
                            if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 1) {
                                t = (Long)ProtocolDataPanel.this.altLeadOut.getValue();
                                if (ProtocolDataPanel.this.dataStyle == 3) {
                                    ProtocolDataPanel.this.setOFFtime34(t, 14, CommonData.leadinOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                                }
                                if (ProtocolDataPanel.this.dataStyle == 4) {
                                    Hex.put(t == null ? null : Integer.valueOf((int)(t / 4L + 10L)), ProtocolDataPanel.this.pdValues, 14);
                                }
                            } else {
                                Hex.put(null, ProtocolDataPanel.this.pdValues, 14);
                            }
                        }
                    } else if (ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 3) {
                        ProtocolDataPanel.this.errorMessage(0);
                    } else if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 1) {
                        ProtocolDataPanel.this.errorMessage(1);
                    } else {
                        ProtocolDataPanel.this.setPFbits(2, 1, 3, 1);
                        t = (Long)ProtocolDataPanel.this.burst0On.getValue();
                        ProtocolDataPanel.this.setONtime34(t, 14, null);
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[15] = null;
                        Hex.put(null, ProtocolDataPanel.this.pdValues, 16);
                    }
                } else {
                    int n;
                    Long val3 = (Long)ProtocolDataPanel.this.rptValue.getValue();
                    int n2 = n = ProtocolDataPanel.this.dataStyle < 2 ? 17 : 15;
                    if (ProtocolDataPanel.this.rptType.getSelectedIndex() == 1) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[n] = val3 == null ? (short)0 : (short)val3.longValue();
                        ProtocolDataPanel.this.assemblerModel.setForcedRptCount(0);
                    } else {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[n] = null;
                        ProtocolDataPanel.this.assemblerModel.setForcedRptCount((short)(val3 == null ? 0 : (short)val3.longValue()));
                    }
                }
                if (source == ProtocolDataPanel.this.devBits1) {
                    Short pdval;
                    short val4 = (short)ProtocolDataPanel.this.devBits1.getSelectedIndex();
                    Short s = pdval = val4 == -1 ? null : Short.valueOf(val4);
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[0] = pdval;
                    } else if ((ProtocolDataPanel.this.pfValues[0] & 0x58) != 8) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[1] = pdval;
                    } else {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[13] = pdval;
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[1] = 0;
                    }
                } else if (source == ProtocolDataPanel.this.cmdBits1) {
                    Short pdval;
                    short val5 = (short)ProtocolDataPanel.this.cmdBits1.getSelectedIndex();
                    Short s = pdval = val5 == -1 ? null : Short.valueOf(val5);
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[1] = pdval;
                    } else {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[2] = pdval;
                    }
                } else if (source == ProtocolDataPanel.this.devBits2) {
                    short val6 = (short)ProtocolDataPanel.this.devBits2.getSelectedIndex();
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[((ProtocolDataPanel)ProtocolDataPanel.this).dataStyle < 2 ? 16 : 14] = val6 == -1 ? null : Short.valueOf(val6);
                    } else if (ProtocolDataPanel.this.devBits2.isEnabled()) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[13] = val6 == -1 ? null : Short.valueOf(val6);
                    } else if ((ProtocolDataPanel.this.pfValues[0] & 0x58) != 8) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[13] = null;
                    }
                } else if (source == ProtocolDataPanel.this.cmdBits2) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        short val7 = (short)ProtocolDataPanel.this.cmdBits2.getSelectedIndex();
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[((ProtocolDataPanel)ProtocolDataPanel.this).dataStyle < 2 ? 18 : 16] = val7 == -1 ? null : Short.valueOf(val7);
                    }
                } else if (source == ProtocolDataPanel.this.sigStruct) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(0, ProtocolDataPanel.this.sigStruct.getSelectedIndex(), 4, 2);
                    } else {
                        int n;
                        String sig = (String)ProtocolDataPanel.this.sigStruct.getSelectedItem() + "-";
                        String[] items = new String[]{"devs", "dev", "cmd", "!dev", "dev2", "cmd", "!cmd"};
                        int key = 0;
                        int p = 0;
                        while ((n = sig.indexOf(45)) >= 0) {
                            String item = sig.substring(0, n);
                            while (p < items.length && !items[p].equals(item)) {
                                ++p;
                            }
                            if (p == items.length) break;
                            key |= 1 << 6 - p;
                            sig = sig.substring(n + 1);
                        }
                        int val8 = 0;
                        if ((key & 2) == 2) {
                            val8 |= 2;
                            key ^= 0x12;
                        }
                        if ((key & 0x40) == 64) {
                            val8 |= 1;
                            key ^= 0x60;
                        }
                        ProtocolDataPanel.this.setPFbits(0, val8 |= (key & 0x3C) << 1 | (key & 1) << 2, 0, 7);
                        this.actionPerformed(new ActionEvent(ProtocolDataPanel.this.devBytes, 1001, "Internal"));
                        this.actionPerformed(new ActionEvent(ProtocolDataPanel.this.devBits1, 1001, "Internal"));
                        this.actionPerformed(new ActionEvent(ProtocolDataPanel.this.devBits2, 1001, "Internal"));
                    }
                } else if (source == ProtocolDataPanel.this.devBitDbl) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.devBitDbl.getSelectedIndex(), 0, 2);
                    } else {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.devBitDbl.getSelectedIndex(), 1, 1);
                        ProtocolDataPanel.this.isSettingPF = true;
                        ProtocolDataPanel.this.cmdBitDbl.setSelectedIndex(ProtocolDataPanel.this.devBitDbl.getSelectedIndex());
                        ProtocolDataPanel.this.isSettingPF = false;
                    }
                } else if (source == ProtocolDataPanel.this.cmdBitDbl) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.cmdBitDbl.getSelectedIndex(), 2, 2);
                    } else {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.devBitDbl.getSelectedIndex(), 1, 1);
                        ProtocolDataPanel.this.isSettingPF = true;
                        ProtocolDataPanel.this.devBitDbl.setSelectedIndex(ProtocolDataPanel.this.cmdBitDbl.getSelectedIndex());
                        ProtocolDataPanel.this.isSettingPF = false;
                    }
                } else if (source == ProtocolDataPanel.this.rptType) {
                    int index = ProtocolDataPanel.this.rptType.getSelectedIndex();
                    Long val9 = (Long)ProtocolDataPanel.this.rptValue.getValue();
                    if (!ProtocolDataPanel.this.assemblerModel.testBuildMode(ProtocolDataPanel.this.processor) && val9 != null && val9 != 0L) {
                        ProtocolDataPanel.this.errorMessage(3);
                    }
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        return;
                    }
                    ProtocolDataPanel.this.setPFbits(1, index, 4, 1);
                    int n = ProtocolDataPanel.this.dataStyle < 2 ? 17 : 15;
                    ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[n] = index == 0 ? null : Short.valueOf(ProtocolDataPanel.this.pdValues[n] == null || ProtocolDataPanel.this.pdValues[n] == 255 ? (short)0 : ProtocolDataPanel.this.pdValues[n]);
                } else if (source == ProtocolDataPanel.this.rptValue) {
                    int index = ProtocolDataPanel.this.rptType.getSelectedIndex();
                    if (!ProtocolDataPanel.this.assemblerModel.testBuildMode(ProtocolDataPanel.this.processor) && index != 1) {
                        ProtocolDataPanel.this.errorMessage(4);
                    }
                } else if (source == ProtocolDataPanel.this.rptHold) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(1, ProtocolDataPanel.this.rptHold.getSelectedIndex(), 0, 2);
                    }
                } else if (source == ProtocolDataPanel.this.xmit0rev) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.xmit0rev.getSelectedIndex(), 4, 1);
                    } else {
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.xmit0rev.getSelectedIndex(), 2, 3);
                    }
                } else if (source == ProtocolDataPanel.this.leadOutStyle) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(1, ProtocolDataPanel.this.leadOutStyle.getSelectedIndex(), 5, 2);
                    } else {
                        ProtocolDataPanel.this.setPFbits(1, ProtocolDataPanel.this.leadOutStyle.getSelectedIndex() >> 1, 5, 1);
                        ProtocolDataPanel.this.setPFbits(1, 1 - ProtocolDataPanel.this.offAsTotal.getSelectedIndex(), 6, 1);
                    }
                } else if (source == ProtocolDataPanel.this.offAsTotal) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(0, ProtocolDataPanel.this.offAsTotal.getSelectedIndex(), 6, 1);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 4) {
                        ProtocolDataPanel.this.setPFbits(1, ProtocolDataPanel.this.offAsTotal.getSelectedIndex(), 6, 1);
                        ProtocolDataPanel.this.setPFbits(2, ProtocolDataPanel.this.offAsTotal.getSelectedIndex(), 0, 1);
                        this.actionPerformed(new ActionEvent(ProtocolDataPanel.this.leadOutStyle, 1001, "Internal"));
                    }
                } else if (source == ProtocolDataPanel.this.burstMidFrame) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        if (ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() <= 0) {
                            ProtocolDataPanel.this.afterBits.setValue("");
                        } else if (ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() == 1 && ProtocolDataPanel.this.afterBits.getValue() == null) {
                            ProtocolDataPanel.this.afterBits.setValue("0");
                        }
                        ProtocolDataPanel.this.assemblerModel.setMidFrameIndex(ProtocolDataPanel.this.burstMidFrame.getSelectedIndex());
                    }
                } else if (source == ProtocolDataPanel.this.burst1On) {
                    Long t = (Long)ProtocolDataPanel.this.burst1On.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 2);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null ? null : Integer.valueOf((int)((t / 4L + 255L) % 256L)), ProtocolDataPanel.this.pdValues, 2, 0);
                    }
                } else if (source == ProtocolDataPanel.this.burst1Off) {
                    Long t = (Long)ProtocolDataPanel.this.burst1Off.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        if (t != null) {
                            t = Math.max(t - (long)(ProtocolDataPanel.this.dataStyle == 0 ? 40 : 0), 0L);
                        }
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 4);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null ? null : Integer.valueOf((int)(t / 4L)), ProtocolDataPanel.this.pdValues, 2, 1);
                    }
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        ProtocolDataPanel.this.setOFFtime34(t, 3, CommonData.burstOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                    }
                } else if (source == ProtocolDataPanel.this.burst0On) {
                    Long t = (Long)ProtocolDataPanel.this.burst0On.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 6);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null ? null : Integer.valueOf((int)((t / 4L + 255L) % 256L)), ProtocolDataPanel.this.pdValues, 5, 0);
                    }
                } else if (source == ProtocolDataPanel.this.burst0Off) {
                    Long t = (Long)ProtocolDataPanel.this.burst0Off.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        if (t != null) {
                            t = Math.max(t - (long)(ProtocolDataPanel.this.dataStyle == 0 ? 40 : 0), 0L);
                        }
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 8);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null ? null : Integer.valueOf((int)(t / 4L)), ProtocolDataPanel.this.pdValues, 5, 1);
                    }
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        ProtocolDataPanel.this.setOFFtime34(t, 5, CommonData.burstOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                    }
                } else if (source == ProtocolDataPanel.this.leadInOn) {
                    Long t = (Long)ProtocolDataPanel.this.leadInOn.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        Hex.put(t == null || ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 12);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null || ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : Integer.valueOf((int)((t / 4L + 255L) % 256L)), ProtocolDataPanel.this.pdValues, 11, 0);
                    }
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        ProtocolDataPanel.this.setONtime34(ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : t, 9, 12);
                    }
                } else if (source == ProtocolDataPanel.this.leadInOff) {
                    Long t = (Long)ProtocolDataPanel.this.leadInOff.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        if (t != null) {
                            t = Math.max(t - (long)(ProtocolDataPanel.this.dataStyle == 0 ? 40 : 0), 0L);
                        }
                        Hex.put(t == null || ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 14);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.semiPut(t == null || ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : Integer.valueOf((int)(t / 4L)), ProtocolDataPanel.this.pdValues, 11, 1);
                    }
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        ProtocolDataPanel.this.isSettingPF = true;
                        ProtocolDataPanel.this.setOFFtime34(ProtocolDataPanel.this.leadInStyle.getSelectedIndex() == 0 ? null : t, 10, CommonData.leadinOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                        this.actionPerformed(new ActionEvent(ProtocolDataPanel.this.leadInStyle, 1001, "Internal"));
                        ProtocolDataPanel.this.isSettingPF = false;
                    }
                } else if (source == ProtocolDataPanel.this.leadOutOff) {
                    Long t = (Long)ProtocolDataPanel.this.leadOutOff.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 2) {
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 10);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 2) {
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 4L + 10L)), ProtocolDataPanel.this.pdValues, 8);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 3) {
                        ProtocolDataPanel.this.setOFFtime34(t, 7, CommonData.leadinOFFoffsets34, ProtocolDataPanel.this.dataStyle);
                    }
                    if (ProtocolDataPanel.this.dataStyle == 4) {
                        Hex.put(t == null ? null : Integer.valueOf((int)(t / 4L + 10L)), ProtocolDataPanel.this.pdValues, 7);
                    }
                } else if (source == ProtocolDataPanel.this.useAltLeadOut) {
                    if (ProtocolDataPanel.this.dataStyle < 3) {
                        ProtocolDataPanel.this.setPFbits(3, ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex(), 5, 1);
                    }
                    if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() <= 0) {
                        ProtocolDataPanel.this.altLeadOut.setValue("");
                    }
                    if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 1 && ProtocolDataPanel.this.altLeadOut.getValue() == null) {
                        ProtocolDataPanel.this.altLeadOut.setValue("0");
                    }
                } else if (source == ProtocolDataPanel.this.altLeadOut) {
                    if (ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() == 1 || ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() < 1 && ProtocolDataPanel.this.useAltFreq.getSelectedIndex() < 1 && ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() < 1) {
                        Long t;
                        Long l = t = ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() < 1 ? null : (Long)ProtocolDataPanel.this.altLeadOut.getValue();
                        if (ProtocolDataPanel.this.dataStyle < 2) {
                            Hex.put(t == null ? null : Integer.valueOf((int)(t / 2L)), ProtocolDataPanel.this.pdValues, 19);
                        }
                        if (ProtocolDataPanel.this.dataStyle == 2) {
                            Hex.put(t == null ? null : Integer.valueOf((int)(t / 4L + 10L)), ProtocolDataPanel.this.pdValues, 17);
                        }
                    }
                } else if (source == ProtocolDataPanel.this.useAltFreq) {
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        return;
                    }
                    ProtocolDataPanel.this.setPFbits(3, ProtocolDataPanel.this.useAltFreq.getSelectedIndex(), 6, 1);
                    if (ProtocolDataPanel.this.useAltFreq.getSelectedIndex() <= 0) {
                        ProtocolDataPanel.this.altFreq.setValue("");
                        ProtocolDataPanel.this.altDuty.setValue("");
                    } else if (ProtocolDataPanel.this.altFreq.getValue() == null) {
                        ProtocolDataPanel.this.altFreq.setValue("0");
                    }
                } else if (source == ProtocolDataPanel.this.altFreq || source == ProtocolDataPanel.this.altDuty) {
                    if (ProtocolDataPanel.this.dataStyle > 2) {
                        return;
                    }
                    if (ProtocolDataPanel.this.useAltFreq.getSelectedIndex() == 1 || ProtocolDataPanel.this.useAltLeadOut.getSelectedIndex() < 1 && ProtocolDataPanel.this.useAltFreq.getSelectedIndex() < 1 && ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() < 1) {
                        Integer cd;
                        int ndx;
                        int n = ndx = ProtocolDataPanel.this.dataStyle < 2 ? 19 : 17;
                        Integer n3 = ProtocolDataPanel.this.useAltFreq.getSelectedIndex() < 1 ? null : (cd = ProtocolDataPanel.this.useAltFreq.getSelectedIndex() <= 0 ? null : ProtocolDataPanel.this.getCarrierData(ProtocolDataPanel.this.altFreq.getValue(), ProtocolDataPanel.this.altDuty.getValue()));
                        if (cd == null || cd == 65535) {
                            ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[ndx] = null;
                            ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[ndx + 1] = null;
                        } else {
                            Hex.put(ProtocolDataPanel.this.getCarrierData(ProtocolDataPanel.this.altFreq.getValue(), ProtocolDataPanel.this.altDuty.getValue()), ProtocolDataPanel.this.pdValues, ProtocolDataPanel.this.dataStyle < 2 ? 19 : 17);
                        }
                    }
                } else if (source == ProtocolDataPanel.this.afterBits) {
                    Long val10 = (Long)ProtocolDataPanel.this.afterBits.getValue();
                    if (ProtocolDataPanel.this.dataStyle < 3 && ProtocolDataPanel.this.burstMidFrame.getSelectedIndex() == 1) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[19] = val10 == null ? null : Short.valueOf((short)(val10 + 1L));
                    }
                }
            }
        }
    };
    private Component[][] dataComponents = null;
    private String[][] dataLabels = new String[][]{{"Frequency", "kHz"}, {"Duty Cycle", "%"}, {"Signal Structure"}, null, {"Device Bytes"}, {"Bits/Dev1"}, {"Bits/Dev2"}, {"Dev Bit Doubling"}, null, {"Command Bytes"}, {"Bits/Cmd1"}, {"Bits/Cmd2"}, {"Cmd Bit Doubling"}, null, {"Repeat Type"}, {"Hold"}, {"Count"}, null, {"1 Burst ON", "uSec"}, {"OFF", "uSec"}, null, {"0 Burst ON", "uSec"}, {"OFF", "uSec"}, {"Xmit 0 Reversed"}, null, {"Lead-In Style"}, {"Lead-In ON", "uSec"}, {"OFF", "uSec"}, null, {"Lead-Out Style"}, {"Lead-Out OFF", "uSec"}, {"OFF as Total"}, null, {"Use Alt Lead-Out"}, {"Alt Lead-Out", "uSec"}, null, {"Use Alt Freq"}, {"Alt Freq", "kHz"}, {"Alt Duty", "%"}, null, {"*****    Active in Build mode only    *****"}, null, {"Burst Mid-Frame"}, {"After # of bits"}};
    public RMFormattedTextField frequency = null;
    public RMFormattedTextField dutyCycle = null;
    public JComboBox sigStruct = new JComboBox();
    public JComboBox devBytes = new JComboBox();
    public JComboBox devBits1 = new JComboBox();
    public JComboBox devBits2 = new JComboBox();
    public JComboBox devBitDbl = new JComboBox();
    public JComboBox cmdBytes = new JComboBox();
    public JComboBox cmdBits1 = new JComboBox();
    public JComboBox cmdBits2 = new JComboBox();
    public JComboBox cmdBitDbl = new JComboBox();
    public RMFormattedTextField rptValue = null;
    public JComboBox rptType = new JComboBox();
    public JComboBox rptHold = new JComboBox();
    public RMFormattedTextField burst1On = null;
    public RMFormattedTextField burst1Off = null;
    public RMFormattedTextField burst0On = null;
    public RMFormattedTextField burst0Off = null;
    public JComboBox xmit0rev = new JComboBox();
    public JComboBox leadInStyle = new JComboBox();
    public JComboBox burstMidFrame = new JComboBox();
    public RMFormattedTextField afterBits = null;
    public RMFormattedTextField leadInOn = null;
    public RMFormattedTextField leadInOff = null;
    public JComboBox leadOutStyle = new JComboBox();
    public RMFormattedTextField leadOutOff = null;
    public JComboBox offAsTotal = new JComboBox();
    public JComboBox useAltLeadOut = new JComboBox();
    public RMFormattedTextField altLeadOut = null;
    public JComboBox useAltFreq = new JComboBox();
    public RMFormattedTextField altFreq = null;
    public RMFormattedTextField altDuty = null;
    public JLabel devBits1lbl = new JLabel();
    public JLabel devBits2lbl = new JLabel();
    public JLabel cmdBits1lbl = new JLabel();
    public JLabel cmdBits2lbl = new JLabel();
    public JLabel burstMidFrameLbl = new JLabel();
    public JLabel afterBitsLbl = new JLabel();
    public JLabel altFreqLbl = new JLabel();
    public JLabel altDutyLbl = new JLabel();
    public JLabel rptValueLbl = new JLabel();
    public JLabel leadInOnLbl = new JLabel();
    public JLabel leadInOffLbl = new JLabel();
    public JLabel offAsTotalLbl = new JLabel();
    public JLabel altLeadOutLbl = new JLabel();
    private String ns = "";
    private Object[] interpretations = null;
    private Short[] basicValues = null;
    private Short[] pdValues = null;
    private List<RMFormattedTextField> pdFields = null;
    private Short[] pfValues = null;
    private JComboBox[][] pfBoxes = null;
    private boolean isSettingPF = false;
    private int boxCount = 0;
    private int dataStyle = 0;
    private int nestLevel = 0;
    private AssemblerTableModel assemblerModel = null;
    private int burstUnit = 0;
    private boolean[] enableStates = null;
    private int errorNumber = -1;
    private Processor processor = null;
    private Mode mode = null;
    private boolean isActive = false;
    private boolean showMessages = true;
    private Dimension prefSize = null;
    public PFMainPanel pfMainPanel = null;
    public PDMainPanel pdMainPanel = null;
    public FunctionMainPanel fnMainPanel = null;

    public ProtocolDataPanel(Component owner) {
        double b = 5.0;
        double c = 10.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size3 = new double[][]{{b, pr, c, pf, b, pr, b}, null};
        ProtocolDataPanel.setTableLayout(size3, this.dataLabels, false);
        this.setLayout(new TableLayout(size3));
        this.prefSize = new JScrollPane(this).getPreferredSize();
        this.basicValues = new Short[3];
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        this.frequency = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.dutyCycle = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.altFreq = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.altDuty = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        nf.setParseIntegerOnly(true);
        this.rptValue = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.burst1On = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.burst1Off = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.burst0On = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.burst0Off = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.afterBits = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.leadInOn = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.leadInOff = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.leadOutOff = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.altLeadOut = new RMFormattedTextField(new RMNumberFormatter((NumberFormat)nf.clone()), this.pfpdListener);
        this.dataComponents = new Component[][]{{this.frequency}, {this.dutyCycle}, {this.sigStruct}, null, {this.devBytes}, {this.devBits1, this.devBits1lbl}, {this.devBits2, this.devBits2lbl}, {this.devBitDbl}, null, {this.cmdBytes}, {this.cmdBits1, this.cmdBits1lbl}, {this.cmdBits2, this.cmdBits2lbl}, {this.cmdBitDbl}, null, {this.rptType}, {this.rptHold}, {this.rptValue, this.rptValueLbl}, null, {this.burst1On}, {this.burst1Off}, null, {this.burst0On}, {this.burst0Off}, {this.xmit0rev}, null, {this.leadInStyle}, {this.leadInOn, this.leadInOnLbl}, {this.leadInOff, this.leadInOffLbl}, null, {this.leadOutStyle}, {this.leadOutOff}, {this.offAsTotal, this.offAsTotalLbl}, null, {this.useAltLeadOut}, {this.altLeadOut, this.altLeadOutLbl}, null, {this.useAltFreq}, {this.altFreq, this.altFreqLbl}, {this.altDuty, this.altDutyLbl}, null, null, null, {this.burstMidFrame, this.burstMidFrameLbl}, {this.afterBits, this.afterBitsLbl}};
        this.boxCount = 0;
        JLabel label = null;
        for (int i = 0; i < this.dataComponents.length; ++i) {
            if (this.dataComponents[i] == null) {
                if (this.dataLabels[i] == null) continue;
                label = new JLabel(this.dataLabels[i][0], 0);
                label.setFocusable(false);
                this.add((Component)label, "1, " + (i + 1) + ", 5, " + (i + 1));
                continue;
            }
            label = this.dataComponents[i].length > 1 ? (JLabel)this.dataComponents[i][1] : new JLabel();
            ++this.boxCount;
            label.setFocusable(false);
            label.setText(this.dataLabels[i][0]);
            this.add((Component)label, "1, " + (i + 1));
            this.add(this.dataComponents[i][0], "3, " + (i + 1));
            if (this.dataLabels[i].length <= 1) continue;
            label = new JLabel(this.dataLabels[i][1]);
            label.setFocusable(false);
            this.add((Component)label, "5, " + (i + 1));
        }
        if (owner instanceof ManualSettingsPanel) {
            this.assemblerModel = ((ManualSettingsPanel)owner).getAssemblerModel();
        }
        this.pfMainPanel = new PFMainPanel();
        this.pdMainPanel = new PDMainPanel();
        this.fnMainPanel = new FunctionMainPanel();
    }

    public static void setTableLayout(double[][] size, String[][] data, boolean interleave) {
        int i;
        double b = 5.0;
        double c = 10.0;
        ArrayList<Double> rows = new ArrayList<Double>();
        rows.add(b);
        for (i = 0; i < data.length; ++i) {
            if (data[i] != null && data[i][0] != null && data[i][0].equals("0")) continue;
            if (interleave) {
                for (int j = 2; j < Math.max(data[i].length, 3); ++j) {
                    rows.add(-2.0);
                }
            } else {
                rows.add(data[i] == null ? c : -2.0);
            }
            if ((i != data.length - 1 || data[i] == null) && !interleave) continue;
            rows.add(b);
        }
        size[1] = new double[rows.size()];
        for (i = 0; i < rows.size(); ++i) {
            size[1][i] = (Double)rows.get(i);
        }
    }

    private Integer getCarrierData(Object freq, Object duty) {
        double f;
        if (freq == null) {
            return null;
        }
        double d = f = freq instanceof Double ? (Double)freq : (double)((Long)freq).longValue();
        if (f == 0.0 || duty == null) {
            return 0;
        }
        double dc = duty instanceof Double ? (Double)duty : (double)((Long)duty).longValue();
        this.burstUnit = (int)Math.round(1000000.0 / f);
        int tot = (int)((double)this.processor.getOscillatorFreq() / (f * 1000.0) + 0.5);
        int on = (int)(dc * (double)tot / 100.0 + 0.5) - this.processor.getCarrierOnOffset();
        return on * 255 + tot - this.processor.getCarrierTotalOffset();
    }

    private void setPFbits(int index, int value, int bitStart, int bitCount) {
        int i;
        for (i = -1; i < index; ++i) {
            if (this.pfValues[i + 1] != null) continue;
            if (i >= 0) {
                this.pfValues[i] = (short)(this.pfValues[i] | 0x80);
            }
            this.pfValues[i + 1] = 0;
        }
        this.putPFbits(index, value, bitStart, bitCount);
        for (i = index; i > 0; --i) {
            if (this.pfValues[i] != 0) continue;
            this.pfValues[i] = null;
            this.pfValues[i - 1] = (short)(this.pfValues[i - 1] & 0x7F);
        }
    }

    private void putPFbits(int index, int value, int bitStart, int bitCount) {
        int mask = (1 << bitCount) - 1 << bitStart;
        this.pfValues[index] = (short)(this.pfValues[index] & ~mask | value << bitStart & mask);
    }

    private void setOFFtime34(Long time, int pdIndex, int[] offsets, int dataStyle) {
        if (time == null) {
            this.pdValues[pdIndex] = this.ns.isEmpty() ? null : Short.valueOf((short)1);
            this.pdValues[pdIndex + 1] = this.ns.isEmpty() ? null : Short.valueOf((short)1);
        } else {
            double d = dataStyle == 3 ? 257.0 : 257.5;
            time = dataStyle == 3 ? (time - (long)offsets[0]) / 3L : (time - (long)offsets[1]) / 2L;
            if (time < 0L) {
                time = 0L;
            }
            int tHigh = (int)((double)time.longValue() / d);
            int tLow = (int)((double)time.longValue() - (double)tHigh * d);
            tHigh = (tHigh + 1) % 256;
            tLow = (tLow + 1) % 256;
            this.pdValues[pdIndex] = (short)tHigh;
            this.pdValues[pdIndex + 1] = (short)tLow;
        }
    }

    private void setONtime34(Long time, int pdIndex1, Integer pdIndex2) {
        if (time == null) {
            Short s = this.pdValues[pdIndex1] = this.ns.isEmpty() ? null : Short.valueOf((short)1);
            if (pdIndex2 != null) {
                this.pdValues[pdIndex2.intValue()] = this.ns.isEmpty() ? null : Short.valueOf((short)1);
            }
        } else if (this.pfValues[2] != null && (this.pfValues[2] & 0x7C) == 64) {
            time = Math.max((time - 2L) / 3L, 0L);
            this.pdValues[pdIndex1] = (short)(time % 256L);
        } else if (this.burstUnit > 0) {
            if ((time = Long.valueOf((time * 1000L + (long)(this.burstUnit / 2)) / (long)this.burstUnit)) == 0L) {
                time = 1L;
            }
            time = (time + 65535L) % 65536L;
            int tHigh = ((int)time.longValue() / 256 + 1) % 256;
            int tLow = ((int)time.longValue() + 1) % 256;
            this.pdValues[pdIndex1] = (short)tLow;
            if (pdIndex2 != null) {
                if (tHigh == 1) {
                    this.pdValues[pdIndex2.intValue()] = null;
                    this.setPFbits(1, 0, 3, 1);
                } else {
                    this.pdValues[pdIndex2.intValue()] = (short)tHigh;
                    this.setPFbits(1, 1, 3, 1);
                }
            }
        } else {
            this.pdValues[pdIndex1] = null;
            if (pdIndex2 != null) {
                this.pdValues[pdIndex2.intValue()] = null;
            }
        }
    }

    private int testONtime34(Long time) {
        if (time == null) {
            return -1;
        }
        if (this.pfValues[2] != null && (this.pfValues[2] & 0x7C) == 64) {
            return (int)Math.max((time - 2L) / 3L, 0L);
        }
        if (this.burstUnit > 0) {
            return (int)((time * 1000L + (long)(this.burstUnit / 2)) / (long)this.burstUnit);
        }
        return -2;
    }

    public void populateComboBox(Component component, Object[] array) {
        if (!(component instanceof JComboBox)) {
            return;
        }
        this.isSettingPF = true;
        JComboBox comboBox = (JComboBox)component;
        ((DefaultComboBoxModel)comboBox.getModel()).removeAllElements();
        if (array == null) {
            this.isSettingPF = false;
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            comboBox.addItem(array[i]);
        }
        if (comboBox.getActionListeners().length == 0) {
            comboBox.addActionListener(this.pfpdListener);
        }
        this.isSettingPF = false;
    }

    public void doBoxEnableStates(EnableOps op) {
        block13: {
            block14: {
                block12: {
                    if (this.dataComponents == null) {
                        return;
                    }
                    if (op != EnableOps.DISABLE || this.nestLevel != 0) break block12;
                    for (int i = 0; i < this.dataComponents.length; ++i) {
                        if (this.dataComponents[i] == null) continue;
                        Component cpt = this.dataComponents[i][0];
                        cpt.setEnabled(false);
                    }
                    JComboBox[][] i = this.pfBoxes;
                    int cpt = i.length;
                    for (int j = 0; j < cpt; ++j) {
                        JComboBox[] cbArray;
                        for (JComboBox cb : cbArray = i[j]) {
                            if (cb == null) continue;
                            cb.setEnabled(false);
                        }
                    }
                    for (RMFormattedTextField field : this.pdFields) {
                        if (field == null) continue;
                        field.setEnabled(false);
                    }
                    break block13;
                }
                if (op != EnableOps.SAVE || --this.nestLevel != 0) break block14;
                int n = 0;
                for (int i = 0; i < this.dataComponents.length; ++i) {
                    if (this.dataComponents[i] == null) continue;
                    Component cpt = this.dataComponents[i][0];
                    this.enableStates[n++] = cpt.isEnabled();
                }
                JComboBox[][] i = this.pfBoxes;
                int cpt = i.length;
                for (int j = 0; j < cpt; ++j) {
                    JComboBox[] cbArray;
                    for (JComboBox cb : cbArray = i[j]) {
                        if (cb == null) continue;
                        this.enableStates[n++] = cb.isEnabled();
                    }
                }
                break block13;
            }
            if (op != EnableOps.RESTORE || this.nestLevel++ != 0) break block13;
            int n = 0;
            for (int i = 0; i < this.dataComponents.length; ++i) {
                if (this.dataComponents[i] == null) continue;
                Component cpt = this.dataComponents[i][0];
                cpt.setEnabled(this.enableStates[n++]);
            }
            JComboBox[][] jComboBoxArray = this.pfBoxes;
            int cpt = jComboBoxArray.length;
            for (int i = 0; i < cpt; ++i) {
                JComboBox[] cbArray;
                for (JComboBox cb : cbArray = jComboBoxArray[i]) {
                    if (cb == null) continue;
                    cb.setEnabled(this.enableStates[n++]);
                }
            }
            for (RMFormattedTextField field : this.pdFields) {
                if (field == null) continue;
                field.setEnabled(true);
            }
        }
    }

    private void errorMessage(int n) {
        if (!this.showMessages || this.errorNumber >= 0) {
            return;
        }
        this.errorNumber = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProtocolDataPanel.this.errorNumber < 0) {
                    return;
                }
                String title = "Data Error";
                String message = null;
                switch (ProtocolDataPanel.this.errorNumber) {
                    case 0: {
                        message = "Half-size leadout after first frame is not allowed when\n0-Burst and 1-Burst have different ON times";
                        break;
                    }
                    case 1: {
                        message = "Alternate lead-out is not allowed when 0-Burst and 1-Burst\nhave different ON times";
                        break;
                    }
                    case 2: {
                        message = "Half-size leadout after first frame and Alternate lead-out cannot both be selected.";
                        break;
                    }
                    case 3: {
                        message = "A change of Repeat Type between Minimum and Forced when the Repeat Count\nis nonzero will only be effective in Build mode, i.e. when the assembler\nlisting is empty or contains only directives.";
                        break;
                    }
                    case 4: {
                        message = "A change of Repeat Count when the Repeat Type is Forced will only be\neffective in Build mode, i.e. when the assembler listing is empty or\ncontains only directives.";
                        break;
                    }
                    default: {
                        message = "Unknown error";
                    }
                }
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 0);
                ProtocolDataPanel.this.errorNumber = -1;
            }
        });
    }

    private String getOFFtime34(int pdIndex, int[] offsets, int dataStyle) {
        if (Hex.get(this.pdValues, pdIndex) == null) {
            return this.ns;
        }
        int t = (this.pdValues[pdIndex + 1] + 255) % 256;
        t = (int)((double)t + (double)((this.pdValues[pdIndex] + 255) % 256) * (dataStyle == 3 ? 257.0 : 257.5));
        t = dataStyle == 3 ? 3 * t + offsets[0] : 2 * t + offsets[1];
        return "" + t;
    }

    private String getONtime34(int pdIndex1, Integer pdIndex2) {
        if (this.pdValues[pdIndex1] == null) {
            return this.ns;
        }
        if (this.pfValues[2] != null && (this.pfValues[2] & 0x7C) == 64) {
            int t = (this.pdValues[pdIndex1] + 255) % 256 + 1;
            return "" + (3 * t + 2);
        }
        int t = (this.pdValues[pdIndex1] + 255) % 256 + 1;
        if (pdIndex2 != null && this.pfValues[1] != null && (this.pfValues[1] & 8) == 8 && this.pdValues[pdIndex2] != null) {
            t += (this.pdValues[pdIndex2] + 255) % 256 * 256;
        }
        return "" + this.burstUnit * t / 1000;
    }

    public String getFrequency(int times) {
        this.burstUnit = 0;
        int on = times >> 8;
        int off = times & 0xFF;
        if (on > 0 && off > 0) {
            double f = this.processor.getOscillatorFreq() / (on + off + this.processor.getCarrierTotalOffset());
            this.burstUnit = (int)Math.round(1.0E9 / f);
            return String.format("%.3f", f / 1000.0);
        }
        if (on == 0 && off == 0) {
            return "0";
        }
        return "** Error **";
    }

    public String getDutyCycle(int times) {
        int on = times >> 8;
        int off = times & 0xFF;
        int totOffset = this.processor.getCarrierTotalOffset();
        int onOffset = this.processor.getCarrierOnOffset();
        if (on > 0 && off > 0) {
            double dc = 100.0 * (double)(on + onOffset) / (double)(on + off + totOffset);
            return String.format("%.2f", dc);
        }
        if (on == 0 && off == 0) {
            return "";
        }
        return "** Error **";
    }

    public Component[][] getDataComponents() {
        return this.dataComponents;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void interpretPFPD(boolean force) {
        Short valS;
        if (this.processor == null || !force && !this.isActive) {
            return;
        }
        int ni = this.ns.isEmpty() ? -1 : 0;
        int dataStyle = this.processor.getDataStyle();
        if (((DefaultComboBoxModel)this.devBits1.getModel()).getSize() == 0) {
            this.populateComboBox(this.devBytes, CommonData.to15);
            this.populateComboBox(this.cmdBytes, CommonData.to15);
            this.populateComboBox(this.devBits1, CommonData.to8);
            this.populateComboBox(this.cmdBits1, CommonData.to8);
            this.populateComboBox(this.devBits2, CommonData.to8);
            this.populateComboBox(this.cmdBits2, CommonData.to8);
            this.populateComboBox(this.xmit0rev, CommonData.noYes);
            this.populateComboBox(this.leadInStyle, CommonData.leadInStyle);
            this.populateComboBox(this.offAsTotal, CommonData.noYes);
            this.populateComboBox(this.useAltLeadOut, CommonData.noYes);
            this.populateComboBox(this.useAltFreq, CommonData.noYes);
            this.populateComboBox(this.leadOutStyle, CommonData.leadOutStyle);
            this.populateComboBox(this.rptType, CommonData.repeatType);
            this.populateComboBox(this.burstMidFrame, CommonData.noYes);
        }
        this.populateComboBox(this.sigStruct, dataStyle < 3 ? CommonData.sigStructs012 : CommonData.sigStructs34);
        this.populateComboBox(this.devBitDbl, dataStyle < 3 ? CommonData.bitDouble012 : CommonData.bitDouble34);
        this.populateComboBox(this.cmdBitDbl, dataStyle < 3 ? CommonData.bitDouble012 : CommonData.bitDouble34);
        this.populateComboBox(this.rptHold, dataStyle < 3 ? CommonData.repeatHeld012 : CommonData.noYes);
        this.isSettingPF = !force;
        this.doBoxEnableStates(EnableOps.RESTORE);
        Integer valI = Hex.get(this.basicValues, 0);
        this.frequency.setValue(valI == null ? "35" : this.getFrequency(valI));
        this.dutyCycle.setValue(valI == null ? "30" : this.getDutyCycle(valI));
        if (valI == null) {
            valI = Hex.get(this.basicValues, 0);
            this.frequency.setValue(this.getFrequency(valI));
            this.dutyCycle.setValue(this.getDutyCycle(valI));
        }
        this.devBytes.setSelectedIndex((valS = this.basicValues[2]) == null ? 0 : valS >> 4);
        this.cmdBytes.setSelectedIndex(valS == null ? 0 : valS & 0xF);
        this.burstMidFrame.setEnabled(dataStyle < 3);
        if (dataStyle >= 3) {
            this.burstMidFrame.setSelectedIndex(0);
        }
        this.afterBitsLbl.setEnabled(dataStyle < 3);
        this.afterBits.setEnabled(dataStyle < 3);
        this.useAltFreq.setEnabled(dataStyle < 3);
        this.altFreqLbl.setEnabled(dataStyle < 3);
        this.altFreq.setEnabled(dataStyle < 3);
        this.altDutyLbl.setEnabled(dataStyle < 3);
        this.altDuty.setEnabled(dataStyle < 3);
        this.offAsTotal.setEnabled(dataStyle != 3);
        if (dataStyle < 3) {
            boolean b;
            this.devBits1.setSelectedIndex(this.pdValues[0] != null && this.pdValues[0] <= 8 ? (int)this.pdValues[0].shortValue() : ni);
            this.cmdBits1.setSelectedIndex(this.pdValues[1] != null && this.pdValues[1] <= 8 ? (int)this.pdValues[1].shortValue() : ni);
            int n = dataStyle < 2 ? 16 : 14;
            this.devBits2.setSelectedIndex(this.pdValues[n] != null && this.pdValues[n] <= 8 ? (int)this.pdValues[n].shortValue() : -1);
            n = dataStyle < 2 ? 18 : 16;
            this.cmdBits2.setSelectedIndex(this.pdValues[n] != null && this.pdValues[n] <= 8 ? (int)this.pdValues[n].shortValue() : -1);
            this.sigStruct.setSelectedIndex(this.pfValues[0] != null ? this.pfValues[0] >> 4 & 3 : -1);
            this.devBitDbl.setSelectedIndex(this.pfValues[2] != null ? this.pfValues[2] & 3 : 0);
            this.cmdBitDbl.setSelectedIndex(this.pfValues[2] != null ? this.pfValues[2] >> 2 & 3 : 0);
            n = dataStyle < 2 ? 17 : 15;
            this.rptType.setSelectedIndex(this.pfValues[1] != null && (this.pfValues[1] & 0x10) != 0 && this.pdValues[n] != null && this.pdValues[n] != 255 ? 1 : 0);
            this.rptValue.setValue(this.rptType.getSelectedIndex() == 1 ? (this.pdValues[n] != null ? "" + this.pdValues[n] : "") : "" + this.assemblerModel.getForcedRptCount());
            this.rptHold.setSelectedIndex(this.pfValues[1] != null ? this.pfValues[1] & 3 : 0);
            this.xmit0rev.setSelectedIndex(this.pfValues[2] != null ? this.pfValues[2] >> 4 & 1 : 0);
            this.leadInStyle.setSelectedIndex(this.pfValues[1] != null ? this.pfValues[1] >> 2 & 3 : 0);
            if (this.burstMidFrame.isEnabled()) {
                b = this.assemblerModel.getMidFrameIndex() > 0;
                this.burstMidFrame.setSelectedIndex(b ? 1 : 0);
                this.afterBits.setValue(b && this.pdValues[19] != null ? "" + (this.pdValues[19] - 1) : "");
                this.afterBits.setEnabled(b);
                this.afterBitsLbl.setEnabled(b);
            } else {
                this.burstMidFrame.setSelectedIndex(0);
                this.afterBits.setEnabled(false);
                this.afterBitsLbl.setEnabled(false);
            }
            this.leadOutStyle.setSelectedIndex(this.pfValues[1] != null ? this.pfValues[1] >> 5 & 3 : 0);
            this.offAsTotal.setSelectedIndex(this.pfValues[0] != null ? this.pfValues[0] >> 6 & 1 : 0);
            this.useAltLeadOut.setSelectedIndex(this.pfValues[3] != null ? this.pfValues[3] >> 5 & 1 : 0);
            this.useAltFreq.setSelectedIndex(this.pfValues[3] != null ? this.pfValues[3] >> 6 & 1 : 0);
            int ndx = dataStyle < 2 ? 19 : 17;
            b = this.useAltFreq.getSelectedIndex() > 0 && Hex.get(this.pdValues, ndx) != null && Hex.get(this.pdValues, ndx) != 65535;
            this.altFreq.setValue(b ? this.getFrequency(Hex.get(this.pdValues, ndx)) : "");
            this.altDuty.setValue(b ? this.getDutyCycle(Hex.get(this.pdValues, ndx)) : "");
            if (dataStyle < 2) {
                this.burst1On.setValue(Hex.get(this.pdValues, 2) != null ? "" + Hex.get(this.pdValues, 2) * 2 : this.ns);
                this.burst1Off.setValue(Hex.get(this.pdValues, 4) != null ? "" + (Hex.get(this.pdValues, 4) * 2 + (dataStyle == 0 ? 40 : 0)) : this.ns);
                this.burst0On.setValue(Hex.get(this.pdValues, 6) != null ? "" + Hex.get(this.pdValues, 6) * 2 : this.ns);
                this.burst0Off.setValue(Hex.get(this.pdValues, 8) != null ? "" + (Hex.get(this.pdValues, 8) * 2 + (dataStyle == 0 ? 40 : 0)) : this.ns);
                this.leadInOn.setValue(this.leadInStyle.getSelectedIndex() > 0 && Hex.get(this.pdValues, 12) != null && Hex.get(this.pdValues, 12) != 65535 ? "" + Hex.get(this.pdValues, 12) * 2 : "");
                this.leadInOff.setValue(this.leadInStyle.getSelectedIndex() > 0 && Hex.get(this.pdValues, 14) != null && Hex.get(this.pdValues, 14) != 65535 ? "" + (Hex.get(this.pdValues, 14) * 2 + (dataStyle == 0 ? 40 : 0)) : "");
                this.leadOutOff.setValue(Hex.get(this.pdValues, 10) != null ? "" + Hex.get(this.pdValues, 10) * 2 : this.ns);
                this.altLeadOut.setValue(this.useAltLeadOut.getSelectedIndex() == 1 && Hex.get(this.pdValues, 19) != null ? "" + Hex.get(this.pdValues, 19) * 2 : "");
            } else {
                int t = Hex.semiGet(this.pdValues, 2, 0) != null ? Hex.semiGet(this.pdValues, 2, 0) : -1;
                this.burst1On.setValue(t >= 0 ? "" + 4 * (t + 1) : this.ns);
                t = Hex.semiGet(this.pdValues, 2, 1) != null ? Hex.semiGet(this.pdValues, 2, 1) : -1;
                this.burst1Off.setValue(t >= 0 ? "" + 4 * t : this.ns);
                t = Hex.semiGet(this.pdValues, 5, 0) != null ? Hex.semiGet(this.pdValues, 5, 0) : -1;
                this.burst0On.setValue(t >= 0 ? "" + 4 * (t + 1) : this.ns);
                t = Hex.semiGet(this.pdValues, 5, 1) != null ? Hex.semiGet(this.pdValues, 5, 1) : -1;
                this.burst0Off.setValue(t >= 0 ? "" + 4 * t : this.ns);
                t = Hex.semiGet(this.pdValues, 11, 0) != null ? Hex.semiGet(this.pdValues, 11, 0) : -1;
                this.leadInOn.setValue(this.leadInStyle.getSelectedIndex() > 0 && t >= 0 ? "" + 4 * (t + 1) : "");
                t = Hex.semiGet(this.pdValues, 11, 1) != null ? Hex.semiGet(this.pdValues, 11, 1) : -1;
                this.leadInOff.setValue(this.leadInStyle.getSelectedIndex() > 0 && t >= 0 ? "" + 4 * t : "");
                t = Hex.get(this.pdValues, 8) != null ? Hex.get(this.pdValues, 8) - 10 : -1;
                this.leadOutOff.setValue(t >= 0 ? "" + 4 * t : this.ns);
                t = Hex.get(this.pdValues, 17) != null ? Hex.get(this.pdValues, 17) - 10 : -1;
                this.altLeadOut.setValue(this.useAltLeadOut.getSelectedIndex() == 1 && t >= 0 ? "" + 4 * t : "");
            }
        } else {
            if (dataStyle == 3) {
                this.offAsTotal.setSelectedIndex(-1);
                this.offAsTotalLbl.setEnabled(false);
            } else {
                this.offAsTotalLbl.setEnabled(true);
            }
            if (this.pfValues[0] != null && (this.pfValues[0] & 0x58) == 8) {
                this.devBits1.setSelectedIndex(this.pdValues[13] != null ? (int)this.pdValues[13].shortValue() : ni);
            } else {
                this.devBits1.setSelectedIndex(this.pdValues[1] != null ? (int)this.pdValues[1].shortValue() : ni);
                if (this.devBits2.isEnabled()) {
                    this.devBits2.setSelectedIndex(this.pdValues[13] != null ? (int)this.pdValues[13].shortValue() : ni);
                }
            }
            this.cmdBits1.setSelectedIndex(this.pdValues[2] != null ? (int)this.pdValues[2].shortValue() : ni);
            String sig = "";
            String[] items = new String[]{"devs", "dev", "cmd", "!dev", "dev2", "cmd", "!cmd"};
            if (this.pfValues[0] != null) {
                int key = this.pfValues[0] >> 1 & 0x3C | this.pfValues[0] >> 2 & 1;
                if ((this.pfValues[0] & 0x41) == 65) {
                    key ^= 0x60;
                }
                if ((this.pfValues[0] & 0x22) == 34) {
                    key ^= 0x12;
                }
                for (int i = 0; i < 7; ++i) {
                    if ((key << i & 0x40) != 64) continue;
                    sig = sig + items[i] + "-";
                }
                sig = sig.substring(0, Math.max(sig.length() - 1, 0));
                this.sigStruct.setSelectedItem(sig);
            } else {
                this.sigStruct.setSelectedIndex(-1);
            }
            this.sigStruct.setSelectedItem(this.pfValues[0] == null ? Integer.valueOf(-1) : sig);
            this.devBitDbl.setSelectedIndex(this.pfValues[2] != null ? this.pfValues[2] >> 1 & 1 : 0);
            this.cmdBitDbl.setSelectedIndex(this.pfValues[2] != null ? this.pfValues[2] >> 1 & 1 : 0);
            int count = this.assemblerModel.getForcedRptCount();
            this.rptType.setSelectedIndex(count > 0 ? 0 : (this.pfValues[1] != null && (this.pfValues[1] & 2) != 0 ? 1 : -1));
            if (this.rptType.getSelectedIndex() == 0) {
                this.rptValue.setValue("" + count);
            }
            this.rptHold.setSelectedIndex(this.pfValues[1] != null && (this.pfValues[1] & 2) != 0 ? 1 : 0);
            this.burst1On.setValue(this.getONtime34(0, null));
            this.burst0On.setValue(this.pfValues[2] != null && (this.pfValues[2] & 8) == 8 ? this.getONtime34(14, null) : this.getONtime34(0, null));
            this.burst1Off.setValue(this.getOFFtime34(3, CommonData.burstOFFoffsets34, dataStyle));
            this.burst0Off.setValue(this.getOFFtime34(5, CommonData.burstOFFoffsets34, dataStyle));
            this.xmit0rev.setSelectedIndex(this.pfValues[2] != null && (this.pfValues[2] & 0x1C) == 4 ? 1 : 0);
            this.leadInStyle.setSelectedIndex(this.pfValues[1] != null && (this.pfValues[1] & 0x10) == 16 ? ((this.pfValues[1] & 4) == 4 && Hex.get(this.pdValues, 16) != null && Hex.get(this.pdValues, 16) != Hex.get(this.pdValues, 10) ? 3 : 1) : 0);
            this.leadInOn.setValue(this.leadInStyle.getSelectedIndex() > 0 ? this.getONtime34(9, 12) : "");
            this.leadInOff.setValue(this.leadInStyle.getSelectedIndex() > 0 ? this.getOFFtime34(10, CommonData.leadinOFFoffsets34, dataStyle) : "");
            this.offAsTotal.setSelectedIndex(dataStyle == 4 && this.pfValues[2] != null ? this.pfValues[2] & 1 : 0);
            this.leadOutStyle.setSelectedIndex(this.pfValues[1] != null ? (this.offAsTotal.getSelectedIndex() == (this.pfValues[1] >> 6 & 1) ? -1 : this.pfValues[1] >> 4 & 2) : 0);
            this.leadOutOff.setValue(dataStyle == 3 ? this.getOFFtime34(7, CommonData.leadinOFFoffsets34, dataStyle) : (Hex.get(this.pdValues, 7) != null && Hex.get(this.pdValues, 7) > 0 ? "" + Math.max(Hex.get(this.pdValues, 7) * 4 - 40, 0) : "0"));
            boolean b = this.pfValues[1] != null && (this.pfValues[1] & 4) == 4 && (this.pfValues[2] == null || (this.pfValues[2] & 8) == 0);
            int i1 = Hex.get(this.pdValues, 14) == null ? -1 : Hex.get(this.pdValues, 14);
            int i2 = Hex.get(this.pdValues, 7) == null ? -1 : Hex.get(this.pdValues, 7);
            b = b && i1 > 0 && i2 > 0 && i1 != i2;
            int ndx = b ? 1 : 0;
            this.useAltLeadOut.setSelectedIndex(ndx);
            this.altLeadOut.setValue(this.useAltLeadOut.getSelectedIndex() == 1 ? (dataStyle == 3 ? this.getOFFtime34(14, CommonData.leadinOFFoffsets34, dataStyle) : (Hex.get(this.pdValues, 14) != null && Hex.get(this.pdValues, 14) > 0 ? "" + (Hex.get(this.pdValues, 14) * 4 - 40) : "")) : "");
        }
        this.isSettingPF = false;
        this.doBoxEnableStates(EnableOps.SAVE);
        if (this.mode == Mode.DISASM) {
            this.doBoxEnableStates(EnableOps.DISABLE);
        }
    }

    public void reset() {
        this.setDefaultInterpretations();
        this.restoreInterpretations();
    }

    public void refreshPD() {
        this.ns = "0";
        this.interpretPFPD(true);
        this.ns = "";
        int i = 0;
        for (i = 0; i < this.pfValues.length && this.pfValues[i] != null; ++i) {
        }
        this.assemblerModel.setPfCount(i);
        this.pfpdListener.actionPerformed(new ActionEvent(this.sigStruct, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.leadInStyle, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.rptType, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.devBytes, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.cmdBytes, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.useAltLeadOut, 1001, "Internal"));
        this.pfpdListener.actionPerformed(new ActionEvent(this.useAltFreq, 1001, "Internal"));
    }

    public void setAssemblerData(boolean refresh) {
        this.assemblerModel.setPfCount(this.getPfCount());
        if (refresh) {
            this.refreshPD();
        }
        boolean fill = false;
        short[] fillValues = CommonData.pdDefaults[this.dataStyle];
        int i = 0;
        for (i = this.pdValues.length - 1; i >= 0; --i) {
            if (!fill && this.pdValues[i] != null) {
                fill = true;
                this.assemblerModel.setPdCount(i + 1);
            }
            if (this.pdValues[i] != null || !fill) continue;
            this.pdValues[i] = i < fillValues.length ? fillValues[i] : (short)0;
        }
        Hex hex = new Hex(this.assemblerModel.getPdCount() + 10);
        this.assemblerModel.setHex(hex);
        for (i = 0; i < this.processor.getStartOffset(); ++i) {
            hex.set(this.basicValues[i], i);
        }
        for (i = this.processor.getStartOffset(); i < 3; ++i) {
            hex.set(this.basicValues[i], i + 2);
        }
        for (i = 0; i < this.pfValues.length && this.pfValues[i] != null; ++i) {
            hex.set(this.pfValues[i], i + 5);
        }
        for (int j = 0; j < this.assemblerModel.getPdCount(); ++j) {
            hex.set(this.pdValues[j], i + j + 5);
        }
    }

    public void setDefaultInterpretations() {
        this.interpretations = new Object[this.dataComponents.length];
        for (int i = 0; i < this.dataComponents.length; ++i) {
            if (this.dataComponents[i] == null) continue;
            Component cpt = this.dataComponents[i][0];
            if (cpt instanceof JComboBox) {
                this.interpretations[i] = 0;
            } else if (cpt instanceof RMFormattedTextField) {
                this.interpretations[i] = "";
            }
            this.interpretations[0] = "35";
            this.interpretations[1] = "30";
            this.interpretations[4] = 1;
            this.interpretations[5] = 8;
            this.interpretations[9] = 1;
            this.interpretations[10] = 8;
            this.interpretations[14] = 1;
            this.interpretations[15] = 1;
        }
    }

    public void setInterpretations() {
        if (this.interpretations == null) {
            this.setDefaultInterpretations();
            return;
        }
        this.interpretations = new Object[this.dataComponents.length];
        for (int i = 0; i < this.dataComponents.length; ++i) {
            if (this.dataComponents[i] == null) continue;
            Component cpt = this.dataComponents[i][0];
            if (cpt instanceof JComboBox) {
                this.interpretations[i] = ((JComboBox)cpt).getSelectedIndex();
                continue;
            }
            if (!(cpt instanceof RMFormattedTextField)) continue;
            this.interpretations[i] = ((RMFormattedTextField)cpt).getText();
        }
    }

    public void restoreInterpretations() {
        if (this.interpretations == null) {
            return;
        }
        this.interpretPFPD(true);
        for (int i = 0; i < this.dataComponents.length; ++i) {
            Component cpt;
            if (this.dataComponents[i] == null || !(cpt = this.dataComponents[i][0]).isEnabled()) continue;
            if (cpt instanceof JComboBox) {
                ((JComboBox)cpt).setSelectedIndex((Integer)this.interpretations[i]);
                continue;
            }
            if (!(cpt instanceof RMFormattedTextField)) continue;
            ((RMFormattedTextField)cpt).setValue((String)this.interpretations[i]);
        }
    }

    public int getRptType() {
        return this.rptType.getSelectedIndex();
    }

    public int getBurstMidFrame() {
        return this.burstMidFrame.getSelectedIndex();
    }

    private int getWidth(String text) {
        return new JLabel((String)text).getPreferredSize().width + 4;
    }

    public Short[] getPdValues() {
        return this.pdValues;
    }

    public Short[] getPfValues() {
        return this.pfValues;
    }

    public int getPfCount() {
        int i = 0;
        if (this.pfValues[0] == null) {
            this.pfValues[0] = 0;
        }
        for (i = 0; i < this.pfValues.length && this.pfValues[i] != null; ++i) {
        }
        return i;
    }

    public Short[] getBasicValues() {
        return this.basicValues;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setShowMessages(boolean showMessages) {
        this.showMessages = showMessages;
    }

    public int getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(int dataStyle) {
        this.dataStyle = dataStyle;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public Dimension getPrefSize() {
        return this.prefSize;
    }

    public List<RMFormattedTextField> getPdFields() {
        return this.pdFields;
    }

    static /* synthetic */ JComboBox[][] access$102(ProtocolDataPanel x0, JComboBox[][] x1) {
        x0.pfBoxes = x1;
        return x1;
    }

    static /* synthetic */ Short[] access$202(ProtocolDataPanel x0, Short[] x1) {
        x0.pfValues = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$402(ProtocolDataPanel x0, boolean[] x1) {
        x0.enableStates = x1;
        return x1;
    }

    static /* synthetic */ Short[] access$1102(ProtocolDataPanel x0, Short[] x1) {
        x0.pdValues = x1;
        return x1;
    }

    public static enum Mode {
        ASM,
        DISASM;

    }

    public class RMFormattedTextField
    extends JFormattedTextField
    implements KeyListener {
        private Format fmt;
        private DefaultFormatter ff;
        private String lastText;
        private ActionListener al;

        public RMFormattedTextField(Format fmt, ActionListener al) {
            super(fmt);
            this.lastText = "";
            this.al = null;
            this.fmt = fmt;
            this.al = al;
            this.addKeyListener(this);
            this.setFocusLostBehavior(0);
        }

        public RMFormattedTextField(DefaultFormatter ff, ActionListener al) {
            super(ff);
            this.lastText = "";
            this.al = null;
            this.ff = ff;
            this.al = al;
            this.addKeyListener(this);
            this.setFocusLostBehavior(0);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.selectAll();
            } else if (e.getID() == 1005) {
                this.endEdit();
            }
        }

        protected void setValue(String text) {
            try {
                Object obj = this.fmt == null ? this.ff.stringToValue(text) : this.fmt.parseObject(text);
                this.lastText = obj == null ? "" : obj.toString();
                this.setText(this.lastText);
                this.commitEdit();
                if (this.al != null && this.al == ProtocolDataPanel.this.pfpdListener) {
                    this.update();
                }
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }

        public String getLastText() {
            return this.lastText;
        }

        protected void update() {
            this.al.actionPerformed(new ActionEvent(this, 1001, ""));
        }

        public void endEdit() {
            if (!this.isEditValid()) {
                this.showWarning(this.getText() + " : Invalid value");
                this.setText(this.getValue() == null ? "" : this.getValue().toString());
            } else {
                try {
                    this.commitEdit();
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
            if (!this.getText().equals(this.lastText)) {
                this.lastText = this.getText();
                this.update();
            }
        }

        private void showWarning(String message) {
            JOptionPane.showMessageDialog(this, message, "Invalid Value", 0);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                this.endEdit();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    public class PFMainPanel
    extends JPanel
    implements ActionListener,
    ItemListener {
        private JPanel pfPanel = null;
        private JScrollPane pfScrollPane = null;
        private JRadioButton[] pfButtons = null;
        private boolean isActive = false;

        public PFMainPanel() {
            this.setLayout(new BorderLayout());
            this.pfPanel = new JPanel();
            this.pfScrollPane = new JScrollPane(this.pfPanel, 20, 31);
            this.pfScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.pfScrollPane, "Center");
            JPanel headerPanel = new JPanel(new BorderLayout());
            headerPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            JPanel pfChoice = new JPanel(new GridLayout(1, CommonData.pfData.length));
            headerPanel.add((Component)pfChoice, "First");
            String text = "Bits per byte, current protocol values selected";
            headerPanel.add((Component)new JLabel(text, 0), "Last");
            this.add((Component)headerPanel, "First");
            ButtonGroup grp = new ButtonGroup();
            this.pfButtons = new JRadioButton[CommonData.pfData.length];
            ProtocolDataPanel.access$102(ProtocolDataPanel.this, new JComboBox[CommonData.pfData.length][]);
            ProtocolDataPanel.access$202(ProtocolDataPanel.this, new Short[CommonData.pfData.length]);
            for (int i = 0; i < this.pfButtons.length; ++i) {
                this.pfButtons[i] = new JRadioButton("PF" + i, false);
                this.pfButtons[i].addItemListener(this);
                pfChoice.add(this.pfButtons[i]);
                grp.add(this.pfButtons[i]);
                ((ProtocolDataPanel)ProtocolDataPanel.this).pfBoxes[i] = new JComboBox[CommonData.pfData[i].length];
                ProtocolDataPanel.this.boxCount += ProtocolDataPanel.this.pfBoxes[i].length;
            }
            ProtocolDataPanel.access$402(ProtocolDataPanel.this, new boolean[ProtocolDataPanel.this.boxCount]);
            Arrays.fill(ProtocolDataPanel.this.enableStates, true);
        }

        public void set() {
            if (!this.isActive) {
                return;
            }
            ProtocolDataPanel.this.doBoxEnableStates(EnableOps.RESTORE);
            int n = -1;
            for (int i = 0; i < this.pfButtons.length; ++i) {
                this.pfButtons[i].setEnabled(ProtocolDataPanel.this.pfValues[i] != null);
                if (!this.pfButtons[i].isSelected()) continue;
                n = i;
            }
            if (n < 0) {
                n = 0;
                this.pfButtons[0].setSelected(true);
            }
            ArrayList<JTextArea> areas = new ArrayList<JTextArea>();
            double[][] size = new double[][]{{ProtocolDataPanel.this.getWidth("0-0__"), -1.0}, null};
            ProtocolDataPanel.setTableLayout(size, CommonData.pfData[n], true);
            this.pfPanel.setLayout(new TableLayout(size));
            int bitPos = 0;
            int row = 1;
            int m = 0;
            ProtocolDataPanel.this.isSettingPF = true;
            for (String[] data : CommonData.pfData[n]) {
                int pos;
                DisplayArea label = new DisplayArea(data[1], areas);
                label.setFocusable(false);
                this.pfPanel.add((Component)label, "0, " + row + ", l, t");
                DisplayArea area = new DisplayArea(data[2], areas);
                area.setFocusable(false);
                this.pfPanel.add((Component)area, "1, " + row++);
                JComboBox<String> combo = new JComboBox<String>();
                ((ProtocolDataPanel)ProtocolDataPanel.this).pfBoxes[n][m++] = combo;
                combo.addActionListener(this);
                String text = data[3];
                while ((pos = text.indexOf("\n")) >= 0) {
                    combo.addItem(text.substring(0, pos));
                    text = text.substring(pos + 1);
                }
                combo.addItem(text.substring(0));
                this.pfPanel.add(combo, "1, " + row++);
                if (data.length > 4) {
                    area = new DisplayArea(data[4], areas);
                    area.setFocusable(false);
                    this.pfPanel.add((Component)area, "1, " + row++);
                }
                if (ProtocolDataPanel.this.pfValues[n] != null) {
                    int len = Integer.parseInt(data[0]);
                    int val = ProtocolDataPanel.this.pfValues[n] >> bitPos & (1 << len) - 1;
                    bitPos += len;
                    int i = 0;
                    while (true) {
                        if ((text = (String)combo.getModel().getElementAt(i)).startsWith("" + val + " =") || i == combo.getModel().getSize() - 1) {
                            combo.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                ++row;
            }
            ProtocolDataPanel.this.isSettingPF = false;
            this.pfPanel.validate();
            ProtocolDataPanel.this.doBoxEnableStates(EnableOps.SAVE);
            if (ProtocolDataPanel.this.mode == Mode.DISASM) {
                ProtocolDataPanel.this.doBoxEnableStates(EnableOps.DISABLE);
            }
            for (JTextArea area : areas) {
                Dimension d = area.getPreferredSize();
                d.width = 100;
                area.setPreferredSize(d);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PFMainPanel.this.pfScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }

        public void setPFData(Processor proc, Hex hex) {
            int i;
            int pfCount = ProtocolDataPanel.this.assemblerModel.getPfCount();
            short[] data = hex.getData();
            Arrays.fill((Object[])ProtocolDataPanel.this.basicValues, null);
            Arrays.fill((Object[])ProtocolDataPanel.this.pfValues, null);
            Arrays.fill((Object[])ProtocolDataPanel.this.pdValues, null);
            for (i = 0; i < proc.getStartOffset(); ++i) {
                ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[i] = data[i];
            }
            for (i = proc.getStartOffset(); i < 3; ++i) {
                ((ProtocolDataPanel)ProtocolDataPanel.this).basicValues[i] = data[i + 2];
            }
            for (i = 0; i < pfCount; ++i) {
                ((ProtocolDataPanel)ProtocolDataPanel.this).pfValues[i] = data[5 + i];
            }
            for (i = 0; i < ProtocolDataPanel.this.assemblerModel.getPdCount() && i < ProtocolDataPanel.this.pdValues.length; ++i) {
                ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[i] = data[5 + pfCount + i];
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n;
            if (!this.isActive) {
                return;
            }
            Object source = e.getSource();
            int m = -1;
            for (n = 0; n < this.pfButtons.length && !this.pfButtons[n].isSelected(); ++n) {
            }
            if (n < this.pfButtons.length) {
                m = Arrays.asList(ProtocolDataPanel.this.pfBoxes[n]).indexOf(source);
            }
            if (m >= 0 && !ProtocolDataPanel.this.isSettingPF) {
                int val;
                int bitStart = Integer.parseInt(CommonData.pfData[n][m][1].substring(0, 1));
                int bitCount = Integer.parseInt(CommonData.pfData[n][m][0]);
                int mask = ~((1 << bitCount) - 1 << bitStart);
                JComboBox combo = ProtocolDataPanel.this.pfBoxes[n][m];
                String text = (String)combo.getSelectedItem();
                if (Character.isDigit(text.charAt(0))) {
                    val = Integer.parseInt(text.substring(0, 1));
                } else {
                    for (val = 0; val < combo.getItemCount() - 1 && val == Integer.parseInt((text = (String)combo.getModel().getElementAt(val)).substring(0, 1)); ++val) {
                    }
                }
                ((ProtocolDataPanel)ProtocolDataPanel.this).pfValues[n] = (short)(ProtocolDataPanel.this.pfValues[n] & mask | val << bitStart);
                if (bitStart == 7) {
                    ProtocolDataPanel.this.isSettingPF = true;
                    if (val == 0) {
                        for (int i = n + 1; i < this.pfButtons.length; ++i) {
                            this.pfButtons[i].setEnabled(false);
                            ((ProtocolDataPanel)ProtocolDataPanel.this).pfValues[i] = null;
                        }
                    } else {
                        this.pfButtons[n + 1].setEnabled(true);
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pfValues[n + 1] = 0;
                    }
                    ProtocolDataPanel.this.isSettingPF = false;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            int n = 0;
            n = Arrays.asList(this.pfButtons).indexOf(source);
            if (n >= 0) {
                if (this.pfButtons[n].isSelected()) {
                    this.set();
                }
                return;
            }
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    public class PDMainPanel
    extends JPanel
    implements ActionListener {
        private JPanel pdHeaderPanel = null;
        private JPanel pdPanel = null;
        private JScrollPane pdScrollPane = null;
        private List<int[]> pdSizes = null;
        private boolean isActive = false;

        public PDMainPanel() {
            this.setLayout(new BorderLayout());
            this.pdPanel = new JPanel();
            this.pdScrollPane = new JScrollPane(this.pdPanel, 20, 31);
            this.pdScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.pdScrollPane, "Center");
            this.pdHeaderPanel = new JPanel(new BorderLayout());
            this.add((Component)this.pdHeaderPanel, "First");
            int n = 0;
            for (int i = 0; i < CommonData.pdData.length; ++i) {
                if (CommonData.pdData[i][0] == null) continue;
                n += Integer.parseInt(CommonData.pdData[i][0]);
            }
            ProtocolDataPanel.access$1102(ProtocolDataPanel.this, new Short[n]);
            ProtocolDataPanel.this.pdFields = new ArrayList();
            this.pdSizes = new ArrayList<int[]>();
        }

        public void set() {
            if (!this.isActive) {
                return;
            }
            ProtocolDataPanel.this.doBoxEnableStates(EnableOps.RESTORE);
            ArrayList<JTextArea> areas = new ArrayList<JTextArea>();
            double[][] size = new double[][]{{ProtocolDataPanel.this.getWidth("PD00/PD00__"), ProtocolDataPanel.this.getWidth("$"), ProtocolDataPanel.this.getWidth("FF_FF_"), ProtocolDataPanel.this.getWidth(" -> "), ProtocolDataPanel.this.getWidth("999999_"), -1.0}, null};
            ProtocolDataPanel.setTableLayout(size, CommonData.pdData, true);
            this.pdPanel.setLayout(new TableLayout(size));
            RMFormattedTextField tf = null;
            ProtocolDataPanel.this.pdFields.clear();
            this.pdSizes.clear();
            int pdNum = 0;
            int pdLastNum = 0;
            int row = 1;
            for (String[] data : CommonData.pdData) {
                int n;
                int n2 = n = data[0] == null ? -1 : Integer.parseInt(data[0]);
                n = n == -1 ? 0 : (n == 0 ? -1 : n);
                int type = Integer.parseInt(data[1]);
                int pdNdx = n > 0 ? pdNum : pdLastNum;
                String text = "";
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        text = text + "/";
                    }
                    text = text + String.format("PD%02X", pdNum + i);
                }
                if (n > 0) {
                    DisplayArea label = new DisplayArea(text, areas);
                    label.setFocusable(false);
                    this.pdPanel.add((Component)label, "0, " + row + ", l, t");
                }
                DisplayArea area = new DisplayArea(data[2], areas);
                area.setFocusable(false);
                if (n >= 0) {
                    this.pdPanel.add((Component)area, "1, " + row + ", 5, " + row);
                    JLabel label = new JLabel("$");
                    label.setFocusable(false);
                    this.pdPanel.add((Component)new JLabel("$"), "1, " + ++row);
                    tf = new RMFormattedTextField(new HexFormat(-1, type == 1 ? 1 : 2), (ActionListener)this);
                    ProtocolDataPanel.this.pdFields.add(tf);
                    this.pdPanel.add((Component)tf, "2, " + row);
                    for (int i = 3; i < data.length; ++i) {
                        label = new JLabel(" -> ", 0);
                        label.setFocusable(false);
                        this.pdPanel.add((Component)label, "3, " + row);
                        NumberFormat nf = NumberFormat.getInstance();
                        nf.setGroupingUsed(false);
                        nf.setParseIntegerOnly(type != 4);
                        tf = new RMFormattedTextField(new RMNumberFormatter(nf), (ActionListener)this);
                        ProtocolDataPanel.this.pdFields.add(tf);
                        this.pdPanel.add((Component)tf, "4, " + row);
                        label = new JLabel("  " + data[i]);
                        label.setFocusable(false);
                        this.pdPanel.add((Component)label, "5, " + row++);
                    }
                    int val = 0;
                    int index = this.pdSizes.size();
                    this.pdSizes.add(new int[]{pdNdx, type == 1 ? 1 : 2});
                    this.pdSizes.add(new int[]{pdNdx, 16 + type});
                    if (type == 4) {
                        this.pdSizes.add(new int[]{pdNdx, 36});
                    }
                    if (ProtocolDataPanel.this.pdValues[pdNdx] != null) {
                        if (type > 1 && ProtocolDataPanel.this.pdValues[pdNdx + 1] != null) {
                            val = ProtocolDataPanel.this.pdValues[pdNdx] * 256 + ProtocolDataPanel.this.pdValues[pdNdx + 1];
                            ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(index)).setValue(String.format("%04X", val));
                        } else {
                            ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(index)).setValue(String.format("%02X", ProtocolDataPanel.this.pdValues[pdNdx]));
                        }
                        ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(index)).update();
                    } else {
                        ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(index)).setValue("");
                    }
                    ++row;
                    if (n > 0) {
                        pdLastNum = pdNum;
                    }
                    pdNum += n;
                    continue;
                }
                this.pdHeaderPanel.removeAll();
                this.pdHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.pdHeaderPanel.add((Component)area, "Center");
            }
            this.validate();
            ProtocolDataPanel.this.doBoxEnableStates(EnableOps.SAVE);
            if (ProtocolDataPanel.this.mode == Mode.DISASM) {
                ProtocolDataPanel.this.doBoxEnableStates(EnableOps.DISABLE);
            }
            for (JTextArea area : areas) {
                Dimension d = area.getPreferredSize();
                d.width = 100;
                area.setPreferredSize(d);
                area.setMinimumSize(new Dimension(10, 10));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PDMainPanel.this.pdScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isActive) {
                // empty if block
            }
            Object source = e.getSource();
            int n = ProtocolDataPanel.this.pdFields.indexOf(source);
            if (n >= 0) {
                int index = this.pdSizes.get(n)[0];
                if (this.pdSizes.get(n)[1] >> 4 == 0) {
                    Hex hex = (Hex)((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(n)).getValue();
                    Arrays.fill((Object[])ProtocolDataPanel.this.pdValues, index, index + this.pdSizes.get(n)[1], null);
                    for (int i = 0; i < hex.length(); ++i) {
                        ((ProtocolDataPanel)ProtocolDataPanel.this).pdValues[index + i] = hex.getData()[i];
                    }
                    int p = 0;
                    while (this.pdSizes.get(p)[0] != index) {
                        ++p;
                    }
                    while (p < this.pdSizes.size() && this.pdSizes.get(p)[0] == index) {
                        if (this.pdSizes.get(p)[1] >> 4 == 0) {
                            Short val1 = ProtocolDataPanel.this.pdValues[index];
                            Short val2 = ProtocolDataPanel.this.pdValues[index + 1];
                            int type = this.pdSizes.get(p)[1];
                            if (p != n) {
                                ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p)).setValue(type == 2 && val2 != null ? String.format("%04X", val1 * 256 + val2) : (val1 != null ? String.format("%02X", val1) : ""));
                            }
                            hex = (Hex)((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p)).getValue();
                            type = this.pdSizes.get(p + 1)[1] & 0xF;
                            if (type == 1 && hex.length() == 1) {
                                ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p + 1)).setValue("" + hex.getData()[0]);
                            } else if (type == 4 && hex.length() >= 1) {
                                double m = ProtocolDataPanel.this.dataStyle == 0 ? 2.0 : 0.0;
                                double d = ProtocolDataPanel.this.dataStyle == 0 ? 8.0 : 4.0;
                                ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p + 1)).setValue("" + ((double)hex.getData()[0] + m) / d);
                                if (hex.length() > 1) {
                                    ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p + 2)).setValue("" + ((double)hex.getData()[1] + m) / d);
                                }
                            } else if (hex.length() == 2) {
                                int time = 2 * hex.get(0) + (type == 3 && ProtocolDataPanel.this.dataStyle == 0 ? 40 : 0);
                                ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p + 1)).setValue("" + time);
                            } else {
                                for (int i = 1; p + i < this.pdSizes.size() && this.pdSizes.get(p + i)[1] >> 4 == i; ++i) {
                                    ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(p + i)).setValue("");
                                }
                            }
                        }
                        ++p;
                    }
                } else {
                    int type = this.pdSizes.get(n)[1] & 0xF;
                    int pos = this.pdSizes.get(n)[1] >> 4;
                    Object obj = ((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(n)).getValue();
                    RMFormattedTextField pdField = (RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(n - pos);
                    if (obj == null) {
                        Hex hex = (Hex)pdField.getValue();
                        pdField.setValue(hex.subHex(0, Math.min(hex.length(), pos - 1)).toString());
                    } else if (type == 1) {
                        pdField.setValue(String.format("%02X", (Long)obj & 0xFFL));
                    } else if (type == 4) {
                        Hex hex = (Hex)((RMFormattedTextField)ProtocolDataPanel.this.pdFields.get(n - pos)).getValue();
                        double val = obj instanceof Long ? (double)((Long)obj).longValue() : (Double)obj;
                        val *= ProtocolDataPanel.this.dataStyle == 0 ? 8.0 : 4.0;
                        double d = ProtocolDataPanel.this.dataStyle == 0 ? 2.0 : 0.0;
                        hex = new Hex(hex, 0, Math.max(hex.length(), pos));
                        hex.set((short)((int)((val -= d) + 0.5) & 0xFF), pos - 1);
                        pdField.setValue(hex.toString());
                    } else {
                        long val = (Long)obj;
                        val -= type == 3 && ProtocolDataPanel.this.dataStyle == 0 ? 40L : 0L;
                        pdField.setValue(String.format("%04X", (val /= 2L) & 0xFFFFL));
                    }
                    pdField.update();
                }
            }
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    public class FunctionMainPanel
    extends JPanel {
        private JPanel fnHeaderPanel = null;
        private JPanel fnPanel = null;
        private JScrollPane fnScrollPane = null;
        private List<Integer> absUsed = null;
        private List<Integer> zeroUsed = null;
        private boolean isActive = false;

        public FunctionMainPanel() {
            this.setLayout(new BorderLayout());
            this.fnPanel = new JPanel();
            this.fnScrollPane = new JScrollPane(this.fnPanel, 20, 31);
            this.fnScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.fnScrollPane, "Center");
            this.fnHeaderPanel = new JPanel(new BorderLayout());
            this.add((Component)this.fnHeaderPanel, "First");
        }

        public void set() {
            if (!this.isActive) {
                return;
            }
            ArrayList<JTextArea> areas = new ArrayList<JTextArea>();
            int n = 0;
            for (String[] data : CommonData.fnData) {
                if (!ProtocolDataPanel.this.processor.getZeroAddresses().keySet().contains(data[0]) && !ProtocolDataPanel.this.processor.getAbsAddresses().keySet().contains(data[0]) && !data[0].equals("")) continue;
                ++n;
            }
            String[][] functions = new String[n][3];
            n = 0;
            for (String[] data : CommonData.fnData) {
                Integer address = ProtocolDataPanel.this.processor.getZeroAddresses().get(data[0]);
                if (data[0].equals("")) {
                    functions[n][0] = "0";
                } else if (address != null) {
                    functions[n][0] = String.format("%02X    ", address);
                } else {
                    address = ProtocolDataPanel.this.processor.getAbsAddresses().get(data[0]);
                    if (address == null) continue;
                    functions[n][0] = String.format("%04X", address);
                }
                functions[n][1] = data[0];
                functions[n++][2] = data[1];
            }
            Arrays.sort(functions, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    int n1 = Integer.parseInt(o1[0].trim(), 16);
                    int n2 = Integer.parseInt(o2[0].trim(), 16);
                    if ((FunctionMainPanel.this.zeroUsed.contains(n1) || FunctionMainPanel.this.absUsed.contains(n1)) && !FunctionMainPanel.this.zeroUsed.contains(n2) && !FunctionMainPanel.this.absUsed.contains(n2)) {
                        return -1;
                    }
                    if (!FunctionMainPanel.this.zeroUsed.contains(n1) && !FunctionMainPanel.this.absUsed.contains(n1) && (FunctionMainPanel.this.zeroUsed.contains(n2) || FunctionMainPanel.this.absUsed.contains(n2))) {
                        return 1;
                    }
                    return n1 - n2;
                }
            });
            double[][] size = new double[][]{{ProtocolDataPanel.this.getWidth("$FFFF_*_"), -1.0}, null};
            ProtocolDataPanel.setTableLayout(size, functions, true);
            this.fnPanel.setLayout(new TableLayout(size));
            int row = 1;
            for (String[] fn : functions) {
                String text = fn[0];
                n = Integer.parseInt(fn[0].trim(), 16);
                text = ProtocolDataPanel.this.dataStyle > 0 || n < 256 ? (ProtocolDataPanel.this.dataStyle == 0 ? "R" : "$") + text : text + "H";
                if (this.zeroUsed.contains(n) || this.absUsed.contains(n)) {
                    text = text + " * ";
                }
                DisplayArea label = new DisplayArea(text, areas);
                text = fn[1] + (fn[1].equals("") ? "" : "\n") + fn[2];
                DisplayArea area = new DisplayArea(text, areas);
                if (fn[1].equals("")) {
                    this.fnHeaderPanel.removeAll();
                    this.fnHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.fnHeaderPanel.add((Component)area, "Center");
                    continue;
                }
                this.fnPanel.add((Component)label, "0, " + row + ", l, t");
                this.fnPanel.add((Component)area, "1, " + row);
                row += 2;
            }
            this.validate();
            for (JTextArea area : areas) {
                Dimension d = area.getPreferredSize();
                d.width = 100;
                area.setPreferredSize(d);
                area.setMinimumSize(new Dimension(10, 10));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionMainPanel.this.fnScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
        }

        public void setAbsUsed(List<Integer> absUsed) {
            this.absUsed = absUsed;
        }

        public void setZeroUsed(List<Integer> zeroUsed) {
            this.zeroUsed = zeroUsed;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    private static class RMNumberFormatter
    extends NumberFormatter {
        RMNumberFormatter(NumberFormat nf) {
            super(nf);
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.setEditValid(true);
                return null;
            }
            return super.stringToValue(string);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "";
            }
            return super.valueToString(value);
        }
    }

    public static enum EnableOps {
        SAVE,
        RESTORE,
        DISABLE;

    }

    public static class DisplayArea
    extends JTextArea {
        public DisplayArea(String text, List<JTextArea> areas) {
            super(text);
            JLabel label = new JLabel();
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setFont(label.getFont());
            this.setBackground(label.getBackground());
            this.setEditable(false);
            if (areas != null) {
                areas.add(this);
            }
        }
    }
}

