/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CmdEditorNode;
import com.hifiremote.jp1.CmdParmEditorNode;
import com.hifiremote.jp1.DevParmEditorNode;
import com.hifiremote.jp1.FixedDataEditorNode;
import com.hifiremote.jp1.GeneralEditorNode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ProtocolEditor
extends JDialog
implements ActionListener,
PropertyChangeListener,
DocumentListener,
TreeSelectionListener {
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private ProtocolEditorPanel editorPanel = null;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ProtocolEditorNode selectedNode;
    private DefaultMutableTreeNode root;
    private GeneralEditorNode generalNode = null;
    private FixedDataEditorNode fixedDataNode = null;
    private CmdEditorNode cmdDataNode = null;
    private JButton viewButton;
    private JButton addButton;
    private JButton deleteButton;
    private JButton okButton;

    public static void main(String[] args) {
        try {
            System.setErr(new PrintStream(new FileOutputStream(new File("pedit.err"))));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        JFrame frame = new JFrame("Test");
        ProtocolEditor e = new ProtocolEditor(frame);
        e.setVisible(true);
        System.exit(0);
    }

    public ProtocolEditor(JFrame owner) {
        super(owner, "Protocol Editor", true);
        this.createGui(owner);
    }

    public ProtocolEditor(JDialog owner) {
        super(owner, "Protocol Editor", true);
        this.createGui(owner);
    }

    private void createGui(Component owner) {
        this.setLocationRelativeTo(owner);
        Container contentPane = this.getContentPane();
        this.root = new DefaultMutableTreeNode("Root", true);
        this.generalNode = new GeneralEditorNode();
        this.generalNode.addPropertyChangeListener("Code", this);
        this.root.add(this.generalNode);
        this.fixedDataNode = new FixedDataEditorNode(0);
        this.root.add(this.fixedDataNode);
        this.cmdDataNode = new CmdEditorNode(0);
        this.root.add(this.cmdDataNode);
        this.treeModel = new DefaultTreeModel(this.root, true);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.expandRow(1);
        this.tree.collapseRow(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        contentPane.add((Component)scrollPane, "West");
        this.cardLayout = new CardLayout(5, 5);
        this.cardPanel = new JPanel(this.cardLayout);
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            ProtocolEditorNode node = (ProtocolEditorNode)e.nextElement();
            ProtocolEditorPanel panel = node.getEditingPanel();
            this.cardPanel.add((Component)panel, panel.getTitle());
        }
        ProtocolEditorNode node = new DevParmEditorNode();
        node.addPropertyChangeListener("Name", this);
        ProtocolEditorPanel panel = node.getEditingPanel();
        this.cardPanel.add((Component)panel, panel.getTitle());
        node = (ProtocolEditorNode)node.getFirstChild();
        panel = node.getEditingPanel();
        this.cardPanel.add((Component)panel, panel.getTitle());
        node = new CmdParmEditorNode();
        panel = node.getEditingPanel();
        this.cardPanel.add((Component)panel, panel.getTitle());
        contentPane.add((Component)this.cardPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 5, 5));
        this.viewButton = new JButton("View");
        this.viewButton.setToolTipText("View the protocols.ini entry for this protocol.");
        this.viewButton.addActionListener(this);
        buttonPanel.add(this.viewButton);
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.addButton.setEnabled(false);
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        buttonPanel.add(this.deleteButton);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        contentPane.add((Component)buttonPanel, "South");
        this.tree.addSelectionRow(0);
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            int children = this.selectedNode.getChildCount();
            ProtocolEditorNode newNode = this.selectedNode.createChild();
            newNode.addPropertyChangeListener("Name", this);
            this.treeModel.insertNodeInto(newNode, this.selectedNode, children);
            ProtocolEditorPanel newPanel = newNode.getEditingPanel();
            this.cardPanel.add((Component)newPanel, newPanel.getTitle());
            Enumeration<TreeNode> en = newNode.children();
            while (en.hasMoreElements()) {
                ProtocolEditorNode child = (ProtocolEditorNode)en.nextElement();
                TreePath path = new TreePath(child.getPath());
                this.tree.expandPath(path);
                this.tree.scrollPathToVisible(path);
            }
            TreePath newPath = new TreePath(newNode.getPath());
            this.tree.setSelectionPath(newPath);
        } else if (source == this.viewButton) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Enumeration<TreeNode> children = this.root.children();
            while (children.hasMoreElements()) {
                ProtocolEditorNode node = (ProtocolEditorNode)children.nextElement();
                node.print(pw);
            }
            pw.flush();
            JTextArea ta = new JTextArea(sw.toString());
            new TextPopupMenu(ta);
            ta.setEditable(false);
            ta.setColumns(80);
            JOptionPane.showMessageDialog(this, new JScrollPane(ta), "Protocol.ini entry text", -1);
        } else if (source == this.deleteButton) {
            DefaultMutableTreeNode nodeToSelect = this.selectedNode.getNextSibling();
            if (nodeToSelect == null) {
                nodeToSelect = this.selectedNode.getPreviousSibling();
            }
            if (nodeToSelect == null) {
                nodeToSelect = (DefaultMutableTreeNode)this.selectedNode.getParent();
            }
            this.treeModel.removeNodeFromParent(this.selectedNode);
            this.selectedNode.removePropertyChangeListener("Name", this);
            this.tree.getSelectionModel().setSelectionPath(new TreePath(nodeToSelect.getPath()));
        } else if (source == this.okButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ProtocolEditorNode node = (ProtocolEditorNode)e.getSource();
        String propertyName = e.getPropertyName();
        System.err.println("PropertyChange for " + propertyName);
        if (propertyName.equals("Hex")) {
            this.enableButtons();
        } else if (propertyName.equals("Name")) {
            this.treeModel.nodeChanged(node);
            TreePath path = new TreePath(node.getPath());
            this.tree.collapsePath(path);
            this.tree.expandPath(path);
        } else if (propertyName.equals("Code")) {
            Hex newValue = (Hex)e.getNewValue();
            int sizes = newValue.getData()[2] & 0xFF;
            int fixedLength = sizes >> 4;
            this.fixedDataNode.setLength(fixedLength);
            int cmdLength = sizes & 0xF;
            this.cmdDataNode.setLength(cmdLength);
        }
    }

    public void documentChanged(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    public void enableButtons() {
        this.addButton.setEnabled(this.selectedNode.canAddChildren());
        this.deleteButton.setEnabled(this.selectedNode.canDelete());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selectedNode = (ProtocolEditorNode)this.tree.getLastSelectedPathComponent();
        this.enableButtons();
        this.editorPanel = this.selectedNode.getEditingPanel();
        this.editorPanel.update(this.selectedNode);
        this.cardLayout.show(this.cardPanel, this.editorPanel.getTitle());
        this.getContentPane().validate();
    }
}

