/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolFactory;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Value;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class ProtocolManager {
    private static ProtocolManager protocolManager = new ProtocolManager();
    private boolean loaded = false;
    private List<String> names = new ArrayList<String>();
    private Hashtable<String, List<Protocol>> byName = new Hashtable();
    private Hashtable<Hex, List<Protocol>> byPID = new Hashtable();
    private Hashtable<Hex, List<Protocol>> byAlternatePID = new Hashtable();
    private Hashtable<String, Hashtable<Hex, List<Protocol>>> byAltPIDRemote = new Hashtable();
    private HashMap<QualifiedID, HashMap<String, Hex>> codeMap = new HashMap();
    private LinkedHashMap<String, String> oldRefMap = new LinkedHashMap();
    private boolean extra = true;
    private boolean showSlingboxProtocols = false;
    private List<Protocol> extras = new ArrayList<Protocol>();
    private static Hashtable<Hex, Integer> manualSettingsIndex = new Hashtable();

    protected ProtocolManager() {
    }

    public static ProtocolManager getProtocolManager() {
        return protocolManager;
    }

    public void load(File f, PropertyFile properties) throws Exception {
        if (this.loaded) {
            return;
        }
        while (!f.canRead()) {
            JOptionPane.showMessageDialog(null, "Couldn't read " + f.getName() + "!", "Error", 0);
            RMFileChooser chooser = new RMFileChooser(f.getParentFile());
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Pick the file containing the protocol definitions");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                System.exit(-1);
                continue;
            }
            f = chooser.getSelectedFile();
        }
        System.err.println("Loading protocols from '" + f.getAbsolutePath() + "'");
        this.codeMap.clear();
        this.extra = false;
        this.showSlingboxProtocols = Boolean.parseBoolean(properties.getProperty("ShowSlingboxProtocols", "false"));
        System.err.println("Option to include Slingbox protocols is " + (this.showSlingboxProtocols ? "On" : "Off"));
        this.loadProtocolFile(f, false);
        File addonDir = RemoteMaster.getAddonDir();
        if (addonDir.exists() && addonDir.isDirectory()) {
            File[] files;
            for (File protFile : files = addonDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".prot");
                }
            })) {
                System.err.println("Loading add-on protocols from '" + protFile.getAbsolutePath() + "'");
                this.loadProtocolFile(protFile, true);
            }
        }
        this.oldRefMap.clear();
        for (List<Protocol> pList : this.byName.values()) {
            for (Protocol p : pList) {
                int cmdLen = p.getDefaultCmdLength();
                int devLen = p.getFixedDataLength();
                for (String proc : p.getCode().keySet()) {
                    Hex code;
                    if (Protocol.getCmdLengthFromCode(proc, code = p.getCode().get(proc)) == cmdLen && Protocol.getFixedDataLengthFromCode(proc, code) == devLen) continue;
                    String pvName = p.getVariantName();
                    Hex id = p.getID();
                    System.err.println("**** Warning: Inconsistent cmd or fixed data lengths for protocol with PID " + id + " and variantName " + (pvName.isEmpty() ? "null" : pvName));
                    break;
                }
                if (p.getOldRefList() == null) continue;
                String newRef = new QualifiedID(p.getID(), p.getVariantName()).toReference();
                for (String oldRef : p.getOldRefList()) {
                    Protocol q;
                    String qvName;
                    Iterator<Protocol> iterator;
                    if (this.oldRefMap.containsKey(oldRef)) {
                        System.err.println("**** Warning: multiple protocols with old reference " + oldRef);
                    }
                    QualifiedID qid = new QualifiedID(oldRef);
                    List<Protocol> qList = this.byPID.get(qid.pid);
                    if (qList != null && (iterator = qList.iterator()).hasNext() && (((qvName = (q = iterator.next()).getVariantName().trim()) == null || qvName.isEmpty()) && qid.variantName.isEmpty() || qvName != null && qvName.equalsIgnoreCase(qid.variantName))) {
                        System.err.println("**** Warning:  old reference " + oldRef + " is current reference of protocol " + q.getName());
                    }
                    this.oldRefMap.put(oldRef, newRef);
                }
            }
        }
        ManualProtocol manualProtocol = new ManualProtocol(new Hex("FF FF"), null);
        manualProtocol.setName(manualProtocol.getName());
        this.add(manualProtocol);
        this.extra = true;
        if (this.byName.size() < 2) {
            JOptionPane.showMessageDialog(null, "No protocols were loaded!", "Error", 0);
            System.exit(-1);
        }
        Object[] temp = new String[]{};
        temp = this.names.toArray(temp);
        Arrays.sort(temp);
        this.names = new ArrayList<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            this.names.add((String)temp[i]);
        }
        this.loaded = true;
    }

    private void loadProtocolFile(File f, boolean deleteConflicting) {
        Properties props = null;
        String name = null;
        Hex id = null;
        String type = null;
        String variant = null;
        boolean suppress = false;
        int lineNumber = 0;
        this.extra = false;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            LineNumberReader rdr = new LineNumberReader(new FileReader(f));
            rdr.setLineNumber(1);
            while (true) {
                String line;
                String rawLine = line = rdr.readLine();
                lineNumber = rdr.getLineNumber();
                if (line == null) break;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                suppress = line.startsWith("Code.") || line.startsWith("[") || line.startsWith("PID") || line.startsWith("VariantName");
                line = line.replaceAll("\\\\n", "\n");
                line = line.replaceAll("\\\\t", "\t");
                while (line.endsWith("\\")) {
                    String temp = rdr.readLine();
                    if (!suppress) {
                        pw.println(rawLine);
                        rawLine = temp;
                    }
                    temp = temp.trim();
                    temp = temp.replaceAll("\\\\n", "\n");
                    temp = temp.replaceAll("\\\\t", "\t");
                    line = line.substring(0, line.length() - 1) + temp;
                }
                if (line.charAt(0) == '[') {
                    String string = variant = props != null ? props.getProperty("VariantName", "") : "";
                    if (name != null && (this.showSlingboxProtocols || !variant.equalsIgnoreCase("slingbox"))) {
                        Protocol protocol = ProtocolFactory.createProtocol(name, id, type, props);
                        protocol.iniIntro = sw.toString();
                        pw.close();
                        if (protocol != null) {
                            this.addWithConflictCheck(protocol, deleteConflicting);
                        }
                    }
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    if (!suppress) {
                        pw.println(rawLine);
                    }
                    name = line.substring(1, line.length() - 1).trim();
                    props = new Properties();
                    id = null;
                    type = "Protocol";
                    continue;
                }
                if (!suppress) {
                    pw.println(rawLine);
                }
                StringTokenizer st = new StringTokenizer(line, "=", true);
                String parmName = st.nextToken().trim();
                String parmValue = null;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                parmValue = st.nextToken("");
                if (parmName.equals("PID")) {
                    id = new Hex(parmValue);
                    continue;
                }
                if (parmName.equals("Type")) {
                    type = parmValue;
                    continue;
                }
                props.setProperty(parmName, parmValue);
            }
            rdr.close();
        }
        catch (Exception e) {
            System.err.println("Error in reading protocol from file " + f.getName() + " at line " + lineNumber);
            return;
        }
        String string = variant = props != null ? props.getProperty("VariantName", "") : "";
        if (name != null && (this.showSlingboxProtocols || !variant.equalsIgnoreCase("slingbox"))) {
            Protocol protocol = ProtocolFactory.createProtocol(name, id, type, props);
            protocol.iniIntro = sw.toString();
            pw.close();
            if (protocol != null) {
                this.addWithConflictCheck(protocol, deleteConflicting);
            }
        }
    }

    private void addWithConflictCheck(Protocol protocol, boolean deleteConflicting) {
        String name = protocol.getName();
        String vn = protocol.getVariantName();
        if (deleteConflicting && this.findByName(name) != null) {
            Iterator<Protocol> ip = this.findByName(name).iterator();
            block0: while (ip.hasNext()) {
                Protocol p = ip.next();
                String pvn = p.getVariantName();
                if (vn == null && pvn != null || vn != null && !vn.equalsIgnoreCase(pvn)) continue;
                for (String codeName : protocol.getCode().keySet()) {
                    if (p.getCode().get(codeName) == null) continue;
                    ip.remove();
                    this.byPID.get(protocol.getID()).remove(p);
                    if (protocol.getAlternatePID() != null) {
                        this.byAlternatePID.get(protocol.getAlternatePID()).remove(p);
                    }
                    for (String signature : this.byAltPIDRemote.keySet()) {
                        Hex altPid = protocol.getRemoteAltPID().get(signature);
                        if (altPid == null) continue;
                        this.byAltPIDRemote.get(signature).get(altPid).remove(p);
                    }
                    continue block0;
                }
            }
        }
        this.add(protocol);
    }

    public void add(Protocol p) {
        String name = p.getName();
        List<Protocol> v = this.byName.get(name);
        if (v == null) {
            v = new ArrayList<Protocol>();
            this.byName.put(name, v);
            this.names.add(name);
        }
        v.add(p);
        Hex id = p.getID();
        String pvName = p.getVariantName();
        QualifiedID qid = this.codeMapKey(new QualifiedID(id, pvName));
        v = this.byPID.get(id);
        if (v == null) {
            v = new ArrayList<Protocol>();
            this.byPID.put(id, v);
        } else if (!this.loaded) {
            for (Protocol protocol : v) {
                String tryName = protocol.getVariantName();
                if ((pvName != null || tryName != null) && (pvName == null || !pvName.equals(tryName)) || this.testProtocolCode(qid, p)) continue;
                System.err.println("**** Warning: protocols with PID " + id + " and variantName " + (pvName.isEmpty() ? "null" : pvName) + " have conflicting code");
                break;
            }
        }
        v.add(p);
        if (!this.codeMap.containsKey(qid)) {
            this.codeMap.put(qid, new HashMap());
        }
        HashMap<String, Hex> cm = this.codeMap.get(qid);
        for (String proc : p.getCode().keySet()) {
            if (cm.containsKey(proc)) continue;
            cm.put(proc, p.getCode().get(proc));
        }
        if (p instanceof ManualProtocol) {
            int n = ((ManualProtocol)p).getNameIndex();
            Integer index = manualSettingsIndex.get(id);
            if (n > 0 && (index == null || n > index)) {
                manualSettingsIndex.put(id, n);
            }
        }
        if ((id = p.getAlternatePID()) != null) {
            v = this.byAlternatePID.get(id);
            if (v == null) {
                v = new ArrayList<Protocol>();
                this.byAlternatePID.put(id, v);
            }
            v.add(p);
        }
        if (this.extra) {
            this.extras.add(p);
        }
    }

    public void remove(Protocol p) {
        String name = p.getName();
        List<Protocol> vn = this.byName.get(name);
        Hex id = p.getID();
        List<Protocol> vp = this.byPID.get(id);
        if (vn == null || vp == null) {
            return;
        }
        if (vn.size() == 1) {
            this.names.remove(name);
            this.byName.remove(name);
        } else {
            vn.remove(p);
        }
        if (vp.size() == 1) {
            this.byPID.remove(id);
        } else {
            vp.remove(p);
        }
        if (p instanceof ManualProtocol) {
            int nameIndex = ((ManualProtocol)p).getNameIndex();
            Integer index = manualSettingsIndex.get(id);
            if (index != null && nameIndex == index) {
                vp = this.byPID.get(id);
                if (vp == null) {
                    manualSettingsIndex.remove(id);
                } else {
                    index = 0;
                    for (Protocol pp : vp) {
                        if (!(pp instanceof ManualProtocol) || (nameIndex = ((ManualProtocol)pp).getNameIndex()) <= index) continue;
                        index = nameIndex;
                    }
                    if (index == 0) {
                        manualSettingsIndex.remove(id);
                    } else {
                        manualSettingsIndex.put(id, index);
                    }
                }
            }
        }
        if ((id = p.getAlternatePID()) != null) {
            vp = this.byAlternatePID.get(id);
            if (vp != null && vp.size() == 1) {
                this.byAlternatePID.remove(id);
            } else if (vp != null) {
                vp.remove(p);
            }
        }
        Hashtable<String, List<Hex>> rp = p.getRemoteAltPIDs();
        for (String sig : rp.keySet()) {
            for (Hex hex : rp.get(sig)) {
                if (this.byAltPIDRemote.get(sig) == null || this.byAltPIDRemote.get(sig).get(hex) == null) continue;
                this.byAltPIDRemote.get(sig).get(hex).remove(p);
                if (this.byAltPIDRemote.get(sig).get(hex).size() == 0) {
                    this.byAltPIDRemote.get(sig).remove(hex);
                }
                if (this.byAltPIDRemote.get(sig).size() != 0) continue;
                this.byAltPIDRemote.remove(sig);
            }
        }
        if (this.extras.contains(p)) {
            this.extras.remove(p);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public LinkedHashMap<String, String> getOldRefMap() {
        return this.oldRefMap;
    }

    public List<Protocol> getProtocolsForRemote(Remote remote) {
        return this.getProtocolsForRemote(remote, true);
    }

    public List<Protocol> getProtocolsForRemote(Remote remote, boolean allowUpgrades) {
        ArrayList<Protocol> rc = new ArrayList<Protocol>();
        for (String name : this.names) {
            Protocol p = this.findProtocolForRemote(remote, name, allowUpgrades);
            if (p == null) continue;
            rc.add(p);
        }
        return rc;
    }

    public Hashtable<String, List<Protocol>> getByName() {
        return this.byName;
    }

    public Hashtable<Hex, List<Protocol>> getByPID() {
        return this.byPID;
    }

    public Hashtable<String, List<Protocol>> getByNameForRemote(Remote remote) {
        Hashtable<String, List<Protocol>> byNameForRemote = new Hashtable<String, List<Protocol>>();
        for (Protocol p : this.getProtocolsForRemote(remote)) {
            byNameForRemote.put(p.getName(), Arrays.asList(p));
        }
        return byNameForRemote;
    }

    public List<Protocol> findByName(String name) {
        List<Protocol> v = this.byName.get(name);
        return v;
    }

    public List<Protocol> findByPID(Hex id) {
        ArrayList<Protocol> rc = null;
        List<Protocol> list = this.byPID.get(id);
        if (list == null) {
            rc = new ArrayList<Protocol>(0);
        } else {
            rc = new ArrayList(list.size());
            rc.addAll(list);
        }
        return rc;
    }

    public List<Protocol> getBuiltinProtocolsForRemote(Remote remote, Hex pid) {
        ArrayList<Protocol> results = new ArrayList<Protocol>();
        for (Protocol protocol : this.findByPID(pid)) {
            if (!remote.supportsVariant(pid, protocol.getVariantName())) continue;
            results.add(protocol);
        }
        return results;
    }

    public List<Protocol> findByAlternatePID(Remote remote, Hex id) {
        return this.findByAlternatePID(remote, id, false);
    }

    public List<Protocol> findByAlternatePID(Remote remote, Hex id, boolean checkUserAltPIDs) {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        List<Protocol> l = this.byAlternatePID.get(id);
        if (l != null) {
            list.addAll(l);
        }
        if (checkUserAltPIDs && this.byAltPIDRemote.get(remote.getSignature()) != null && (l = this.byAltPIDRemote.get(remote.getSignature()).get(id)) != null) {
            list.addAll(l);
        }
        return list.size() == 0 ? null : list;
    }

    public void putAltPIDRemote(Hex id, Remote remote, Protocol p) {
        List<Protocol> list;
        Hashtable<Hex, List<Protocol>> table = this.byAltPIDRemote.get(remote.getSignature());
        if (table == null) {
            table = new Hashtable();
            this.byAltPIDRemote.put(remote.getSignature(), table);
        }
        if ((list = table.get(id)) == null) {
            list = new ArrayList<Protocol>();
            table.put(id, list);
        }
        if (!list.contains(p)) {
            list.add(p);
        }
    }

    public int countAltPIDRemoteEntries() {
        int n = 0;
        for (String sig : this.byAltPIDRemote.keySet()) {
            Hashtable<Hex, List<Protocol>> table = this.byAltPIDRemote.get(sig);
            for (Hex h : table.keySet()) {
                n += table.get(h).size();
            }
        }
        return n;
    }

    public void clearAltPIDRemoteEntries() {
        for (Hex h : this.byPID.keySet()) {
            for (Protocol p : this.byPID.get(h)) {
                p.getRemoteAltPIDs().clear();
            }
        }
        this.byAltPIDRemote.clear();
    }

    public void setAltPIDRemoteProperties(PropertyFile properties) {
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("RemoteAltPID")) continue;
            properties.remove(key);
        }
        int n = 1;
        for (String sig : this.byAltPIDRemote.keySet()) {
            HashSet<Protocol> prots = new HashSet<Protocol>();
            for (Hex id : this.byAltPIDRemote.get(sig).keySet()) {
                for (Protocol p : this.byAltPIDRemote.get(sig).get(id)) {
                    prots.add(p);
                }
            }
            for (Protocol p : prots) {
                String key = "RemoteAltPID." + n++;
                String val = sig + " [" + p.getName() + "] ";
                for (Hex id : p.getRemoteAltPIDs().get(sig)) {
                    val = val + id.toString() + " ";
                }
                val = val.substring(0, val.length() - 1);
                properties.setProperty(key, val);
            }
        }
    }

    public void loadAltPIDRemoteProperties(PropertyFile properties) {
        int n = 1;
        String value = null;
        while ((value = properties.getProperty("RemoteAltPID." + n++)) != null) {
            int pos = value.indexOf(" [");
            if (pos < 0) continue;
            String sig = value.substring(0, pos).trim();
            if ((pos = (value = value.substring(pos + 2)).indexOf("] ")) < 0) continue;
            String pName = value.substring(0, pos).trim();
            value = value.substring(pos + 2);
            List<Protocol> pList = this.byName.get(pName);
            if (pList == null) continue;
            Hex hex = new Hex(value);
            List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature(sig);
            if (remotes.size() == 0) continue;
            Remote remote = remotes.get(0);
            Iterator<Protocol> it = pList.iterator();
            while (it.hasNext()) {
                if (it.next().hasCode(remote)) continue;
                it.remove();
            }
            for (Protocol p : pList) {
                for (int i = 0; i < hex.length() / 2; ++i) {
                    p.putAlternatePID(remote, hex.subHex(2 * i, 2));
                }
            }
        }
    }

    public Protocol findProtocolForRemote(Remote remote, String name) {
        return this.findProtocolForRemote(remote, name, true);
    }

    public Protocol findProtocolForRemote(Remote remote, String name, boolean allowUpgrades) {
        Protocol protocol = null;
        Protocol tentative = null;
        List<Protocol> protocols = this.findByName(name);
        if (protocols == null) {
            return null;
        }
        for (Protocol p : protocols) {
            if (remote.supportsVariant(p.getID(), p.getVariantName())) {
                protocol = p;
                break;
            }
            if (tentative != null || !allowUpgrades || !p.hasCode(remote)) continue;
            tentative = p;
        }
        if (protocol == null) {
            protocol = tentative;
        }
        return protocol;
    }

    public Protocol findProtocolForRemote(Remote remote, Hex id, Hex fixedData) {
        List<Protocol> protocols = protocolManager.findByPID(id);
        for (Protocol p : protocols) {
            Value[] vals;
            Hex calculatedFixedData;
            if (!remote.supportsVariant(id, p.getVariantName()) || !(calculatedFixedData = p.getFixedData(vals = p.importFixedData(fixedData))).equals(fixedData)) continue;
            return p;
        }
        return null;
    }

    public Protocol findProtocolForRemote(Remote remote, Hex id) {
        return this.findProtocolForRemote(remote, id, true);
    }

    public Protocol findProtocolForRemote(Remote remote, Hex id, boolean allowUpgrades) {
        List<Protocol> protocols = this.findByPID(id);
        if (protocols == null || protocols.isEmpty()) {
            protocols = this.findByAlternatePID(remote, id);
        }
        if (protocols == null) {
            return null;
        }
        if (allowUpgrades) {
            for (Protocol p : protocols) {
                if (p.getCustomCode(remote.getProcessor()) == null || !p.getID(remote).equals(id)) continue;
                return p;
            }
        }
        for (Protocol p : protocols) {
            if (!remote.supportsVariant(id, p.getVariantName())) continue;
            return p;
        }
        return null;
    }

    public Protocol findProtocolByOldName(Remote remote, String name, Hex pid) {
        Protocol matchByName = null;
        List<Protocol> protocols = this.getProtocolsForRemote(remote);
        if (protocols == null) {
            return null;
        }
        for (Protocol p : protocols) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(p.getOldNames());
            names.add(p.getName());
            for (String oldName : names) {
                if (!name.equals(oldName)) continue;
                if (matchByName == null) {
                    matchByName = p;
                }
                if (!p.getID().equals(pid)) continue;
                return p;
            }
        }
        return matchByName;
    }

    public Protocol findProtocol(String name, Hex id, String variantName) {
        List<Protocol> protocols = this.findByPID(id);
        if (protocols == null) {
            return null;
        }
        for (Protocol p : protocols) {
            if (!p.getName().equals(name) || !p.getVariantName().equals(variantName)) continue;
            return p;
        }
        return null;
    }

    public Protocol createMissingProtocol(Hex pid, String variant, int fixedDataLength, int cmdLength) {
        System.err.println("Creating Protocol Manager entry for missing built-in protocol");
        List<Protocol> prots = this.findByPID(pid);
        String name = null;
        name = !prots.isEmpty() ? prots.get(0).getName() : "pid: " + pid;
        Properties props = new Properties();
        if (variant.length() > 0) {
            props.put("VariantName", variant);
        }
        Hex tempCode = new Hex(3);
        tempCode.getData()[2] = (short)(fixedDataLength << 4 | cmdLength);
        props.put("Code.MAXQ610", tempCode.toString());
        String notes = "This built-in protocol is missing from protocols.ini so although hex values for fixed data and function commands is correct, device parameters and OBC data are unreliable.";
        props.put("Notes", notes);
        Protocol p = ProtocolFactory.createProtocol(name, pid, "Protocol", props);
        p.code.clear();
        this.add(p);
        return p;
    }

    public Protocol findNearestProtocol(Remote remote, String name, Hex id, String variantName) {
        System.err.println("ProtocolManager.findNearestProtocol( " + remote + ", " + name + ", " + id + ", " + variantName + " )");
        Protocol near = null;
        Protocol derived = null;
        List<Protocol> protocols = this.findByPID(id);
        if (protocols == null || protocols.isEmpty()) {
            protocols = this.findByAlternatePID(remote, id);
        }
        if (protocols == null) {
            System.err.println("No protocol found");
            return null;
        }
        for (Protocol p : protocols) {
            if ((variantName == null || variantName.equals(p.getVariantName())) && remote.supportsVariant(id, p.getVariantName())) {
                if (p.getName().equals(name) || p.getOldNames().contains(name)) {
                    System.err.println("Found built-in protocol " + p);
                    return p;
                }
                if (derived == null && name.equals("pid: " + id.toString())) {
                    System.err.println("Recreating derived protocol from " + p);
                    Properties props = new Properties();
                    for (Processor pr : ProcessorManager.getProcessors()) {
                        Hex hCode = p.getCode(pr);
                        if (hCode == null) continue;
                        props.put("Code." + pr.getEquivalentName(), hCode.toString());
                    }
                    String variant = p.getVariantName();
                    if (variant != null && variant.length() > 0) {
                        props.put("VariantName", variant);
                    }
                    derived = ProtocolFactory.createProtocol("pid: " + id.toString(), id, "Protocol", props);
                }
            }
            if (!p.getName().equals(name) || !p.hasCode(remote) || near != null && (near.getVariantName().equals(variantName) || !p.getVariantName().equals(variantName))) continue;
            near = p;
        }
        if (derived != null) {
            ProtocolManager.getProtocolManager().add(derived);
            System.err.println("Using recreated protocol " + derived);
            return derived;
        }
        if (remote.supportsVariant(id, variantName)) {
            System.err.println("Protocol is built-in but missing from protocols.ini");
            return null;
        }
        if (near != null) {
            System.err.println("Found protocol " + near);
            return near;
        }
        protocols = this.findByName(name);
        if (protocols != null) {
            near = protocols.get(0);
        }
        if (near != null) {
            System.err.println("Found protocol " + near);
            return near;
        }
        near = this.findProtocolByOldName(remote, name, id);
        if (near != null) {
            System.err.println("Found protocol " + near);
            return near;
        }
        System.err.println("No protocol found");
        return null;
    }

    public QualifiedID getCurrentQID(Hex pid, String variantName) {
        QualifiedID qid = new QualifiedID(pid, variantName);
        String newRef = this.oldRefMap.get(qid.toReference());
        return newRef == null ? qid : new QualifiedID(newRef);
    }

    public Hex getCurrentPID(String name, Hex pid) {
        Hex temp = this.testProtocolList(this.byName.get(name), pid);
        if (temp != null) {
            return temp;
        }
        for (List<Protocol> pList : this.byName.values()) {
            for (Protocol p : pList) {
                if (!p.getOldNames().contains(name) || (temp = this.testProtocolList(pList, pid)) == null) continue;
                return temp;
            }
        }
        return pid;
    }

    private Hex testProtocolList(List<Protocol> pList, Hex pid) {
        Hex temp = null;
        if (pList == null) {
            return null;
        }
        for (Protocol p : pList) {
            if (p.getID().equals(pid)) {
                return pid;
            }
            List<String> oldRefs = p.getOldRefList();
            if (temp != null || oldRefs == null) continue;
            for (String ref : oldRefs) {
                QualifiedID qid = new QualifiedID(ref);
                if (!qid.pid.equals(pid)) continue;
                temp = p.getID();
            }
        }
        return temp;
    }

    private QualifiedID codeMapKey(QualifiedID qid) {
        for (QualifiedID q : this.codeMap.keySet()) {
            if (!q.equals(qid)) continue;
            return q;
        }
        return qid;
    }

    private boolean testProtocolCode(QualifiedID qid, Protocol p) {
        HashMap<String, Hex> cMap = this.codeMap.get(this.codeMapKey(qid));
        if (cMap == null) {
            return true;
        }
        HashMap<String, Hex> pMap = p.getCode();
        for (String proc : pMap.keySet()) {
            if (!cMap.containsKey(proc) || cMap.get(proc).equals(pMap.get(proc))) continue;
            return false;
        }
        return true;
    }

    public static int getManualSettingsIndex(Hex pid) {
        Integer index = manualSettingsIndex.get(pid);
        return index == null ? 0 : index;
    }

    public void reset(List<Integer> pids) {
        ArrayList<Protocol> extrasClone = new ArrayList<Protocol>(this.extras);
        for (Protocol protocol : extrasClone) {
            if (!pids.contains(protocol.getID().get(0))) continue;
            this.remove(protocol);
        }
        for (List list : this.byName.values()) {
            for (Protocol p : list) {
                if (!pids.contains(p.getID().get(0))) continue;
                p.customCode.clear();
            }
        }
    }

    public void reset() {
        ArrayList<Protocol> extrasClone = new ArrayList<Protocol>(this.extras);
        for (Protocol protocol : extrasClone) {
            this.remove(protocol);
        }
        for (List list : this.byName.values()) {
            for (Protocol p : list) {
                p.customCode.clear();
            }
        }
        manualSettingsIndex.clear();
    }

    public static class QualifiedID {
        public Hex pid = null;
        public String variantName = "";

        public QualifiedID(Hex pid, String variantName) {
            this.pid = pid;
            if (variantName == null || variantName.trim().isEmpty()) {
                return;
            }
            this.variantName = variantName.trim();
        }

        public QualifiedID(String reference) {
            this.variantName = "";
            if (reference == null) {
                this.pid = null;
                return;
            }
            int colon = reference.indexOf(58);
            if (colon != -1) {
                this.variantName = reference.substring(colon + 1).trim();
                reference = reference.substring(0, colon);
            }
            this.pid = new Hex(reference);
        }

        public String toReference() {
            if (this.pid == null) {
                return null;
            }
            String ref = this.pid.toString().replace(" ", "");
            if (this.variantName != null && !this.variantName.trim().isEmpty()) {
                ref = ref + ":" + this.variantName.trim();
            }
            return ref;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            QualifiedID q = (QualifiedID)obj;
            return q.pid.equals(this.pid) && q.variantName.equals(this.variantName);
        }
    }
}

