/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ProtocolUpgrade
extends Highlight {
    private int pid;
    private Hex code;
    private Protocol protocol = null;
    private boolean used = false;

    public ProtocolUpgrade(int pid, Hex code, String notes) {
        this.pid = pid;
        this.code = code;
        this.notes = notes;
    }

    public ProtocolUpgrade(Properties props) {
        this.pid = Integer.parseInt(props.getProperty("PID"));
        this.code = new Hex(props.getProperty("Code"));
    }

    @Override
    public void store(PropertyWriter pw) {
        pw.print("PID", Integer.toString(this.pid));
        pw.print("Code", this.code.toString());
    }

    public ManualProtocol getManualProtocol(Remote remote) {
        if (this.protocol instanceof ManualProtocol) {
            return (ManualProtocol)this.protocol;
        }
        short[] hex = new short[]{(short)(this.pid / 256), (short)(this.pid % 256)};
        List<Protocol> protocols = ProtocolManager.getProtocolManager().findByPID(new Hex(hex));
        if (protocols == null) {
            return null;
        }
        for (Protocol p : protocols) {
            if (!p.hasCode(remote) || !(p instanceof ManualProtocol)) continue;
            return (ManualProtocol)p;
        }
        return null;
    }

    public void setManualProtocol(Remote remote) {
        Processor proc = remote.getProcessor();
        int fixedDataLength = Protocol.getFixedDataLengthFromCode(proc.getEquivalentName(), this.code);
        int cmdLength = Protocol.getCmdLengthFromCode(proc.getEquivalentName(), this.code);
        this.setManualProtocol(remote, fixedDataLength, cmdLength);
    }

    public void setManualProtocol(Remote remote, int fixedDataLength, int cmdLength) {
        short[] hex = new short[]{(short)(this.pid / 256), (short)(this.pid % 256)};
        Hex pidHex = new Hex(hex);
        int cmdType = 0;
        if (cmdLength == 2) {
            cmdType = 2;
        }
        if (cmdLength > 2) {
            cmdType = cmdLength << 4;
        }
        ArrayList<Value> parms = new ArrayList<Value>();
        for (int i = 0; i < fixedDataLength; ++i) {
            parms.add(new Value(0));
        }
        ManualProtocol mp = new ManualProtocol(ManualProtocol.getDefaultName(pidHex), pidHex, cmdType, "MSB", 8, parms, new short[0], 8);
        mp.setCode(this.code, remote.getProcessor());
        ProtocolManager.getProtocolManager().add(mp);
        this.protocol = mp;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public int getPid() {
        return this.pid;
    }

    public void setCode(Hex hex) {
        this.code = hex;
    }

    public Hex getCode() {
        return this.code;
    }

    public void setNotes(String text) {
        this.notes = text;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean flag) {
        this.used = flag;
    }
}

