/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsDialog;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.ProtocolUpgradeTableModel;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;

public class ProtocolUpgradePanel
extends RMTablePanel<ProtocolUpgrade> {
    private RemoteConfiguration remoteConfig = null;
    private boolean useNewName = true;

    public ProtocolUpgradePanel() {
        super(new ProtocolUpgradeTableModel());
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        ((ProtocolUpgradeTableModel)this.model).set(remoteConfig);
        this.table.initColumns(this.model);
        this.remoteConfig = remoteConfig;
    }

    @Override
    public ProtocolUpgrade createRowObject(ProtocolUpgrade baseUpgrade) {
        Remote remote = this.remoteConfig.getRemote();
        ManualProtocol mp = null;
        boolean pidEditable = true;
        if (baseUpgrade == null && this.useNewName) {
            mp = new ManualProtocol(null, null);
        } else if (this.useNewName) {
            mp = new ManualProtocol(baseUpgrade.getManualProtocol(remote).getIniSection());
        } else {
            pidEditable = false;
            mp = baseUpgrade.getManualProtocol(remote);
        }
        ManualSettingsDialog d = new ManualSettingsDialog(this.remoteConfig.getOwner(), mp);
        ManualSettingsPanel dp = d.getManualSettingsPanel();
        dp.pid.setEditable(pidEditable);
        dp.pid.setEnabled(pidEditable);
        dp.remoteConfig = this.remoteConfig;
        if (remote != null) {
            dp.setSelectedCode(remote.getProcessor());
            d.setMessage(0);
        }
        d.setVisible(true);
        mp = d.getProtocol();
        if (mp != null) {
            if (this.useNewName) {
                mp.setName(ManualProtocol.getDefaultName(mp.getID()));
                ProtocolManager.getProtocolManager().add(mp);
            }
            return mp.getProtocolUpgrade(remote);
        }
        return null;
    }

    @Override
    protected ProtocolUpgrade newRowObject(ProtocolUpgrade baseUpgrade, int row, int modelRow, boolean select) {
        this.useNewName = true;
        return super.newRowObject(baseUpgrade, row, modelRow, select);
    }

    @Override
    protected void editRowObject(int row) {
        this.useNewName = false;
        super.editRowObject(row);
    }
}

