/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Color;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ProtocolUpgradeTableModel
extends JP1TableModel<ProtocolUpgrade> {
    private static final String[] colNames = new String[]{"#", "Name", "PID", "Protocol Code", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Manual Settings: 01CC (2)", "01CC", "00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F", "A resonable length note", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, Hex.class, String.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private SelectAllCellEditor noteEditor = new SelectAllCellEditor();
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.setData(remoteConfig.getProtocolUpgrades());
        }
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col == 0 || col == 2 || col == 5;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ProtocolUpgrade pu = this.remoteConfig.getProtocolUpgrades().get(row);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                ManualProtocol mp = pu.getManualProtocol(this.remoteConfig.getRemote());
                if (mp != null) {
                    return mp.getName();
                }
                return "<none>";
            }
            case 2: {
                int pid = pu.getPid();
                StringBuilder buff = new StringBuilder(4);
                buff.append('0');
                if (pid < 256) {
                    buff.append('0');
                }
                buff.append(Integer.toHexString(pid).toUpperCase());
                return buff.toString();
            }
            case 3: {
                return pu.getCode();
            }
            case 4: {
                return pu.getNotes();
            }
            case 5: {
                return pu.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ProtocolUpgrade pu = this.remoteConfig.getProtocolUpgrades().get(row);
        if (col == 4) {
            pu.setNotes((String)value);
            this.propertyChangeSupport.firePropertyChange("device", null, null);
        } else if (col == 5) {
            pu.setHighlight((Color)value);
            this.propertyChangeSupport.firePropertyChange("highlight", null, null);
        }
    }

    @Override
    public void removeRow(int row) {
        ProtocolUpgrade pu = this.remoteConfig.getProtocolUpgrades().get(row);
        ManualProtocol mp = pu.getManualProtocol(this.remoteConfig.getRemote());
        if (mp != null) {
            ProtocolManager.getProtocolManager().remove(mp);
        }
        super.removeRow(row);
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 5) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (col == 4) {
            return this.noteEditor;
        }
        if (col == 5) {
            return this.colorEditor;
        }
        return null;
    }
}

