/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class RDFReader {
    private static RDFReader currentReader = null;
    private String fileName;
    private int lineNumber = 0;
    private BufferedReader in = null;

    public RDFReader(File file) throws IOException {
        this.fileName = file.getName();
        this.in = new BufferedReader(new FileReader(file));
        currentReader = this;
    }

    public String readLine() throws IOException {
        String rc;
        while ((rc = this.in.readLine()) != null) {
            ++this.lineNumber;
            if ((rc = rc.trim()).length() != 0 && rc.charAt(0) == '#') continue;
            break;
        }
        return rc;
    }

    public static int parseNumber(String text) throws Exception {
        int rc = 0;
        try {
            boolean negate = false;
            if (text.charAt(0) == '-') {
                negate = true;
                text = text.substring(1);
            }
            rc = text.charAt(0) == '$' ? Integer.parseInt(text.substring(1), 16) : Integer.parseInt(text);
            if (negate) {
                rc = (short)(0 - rc);
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("Syntax error at line " + RDFReader.currentReader.lineNumber + " in " + RDFReader.currentReader.fileName, e);
        }
        return rc;
    }

    public static boolean parseFlag(String flag) {
        return flag.equalsIgnoreCase("Y") || flag.equalsIgnoreCase("Yes") || flag.equalsIgnoreCase("T") || flag.equalsIgnoreCase("True") || flag.equalsIgnoreCase("1");
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void close() throws IOException {
        this.in.close();
        currentReader = null;
    }
}

