/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SetupCodeEditor;
import com.hifiremote.jp1.SetupCodeRenderer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class RFSelectorTableModel
extends JP1TableModel<Remote.RFSelector> {
    private static final String[] colNames = new String[]{"#", "Selector", "IR Type", "<html>IR Setup<br>Code</html>", "RF Type", "<html>RF Setup<br>Code</html>"};
    private static String[] colPrototypeNames = new String[]{" 00 ", "Button____", "__VCR/DVD__", "Setup", "__VCR/DVD__", "Setup"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, DeviceType.class, SetupCode.class, DeviceType.class, SetupCode.class};
    private DeviceButton devBtn = null;
    private SetupCodeRenderer setupCodeRenderer = null;
    private DefaultCellEditor deviceTypeEditor = null;
    private JComboBox<DeviceType> deviceTypeBox = new JComboBox();
    private SetupCodeEditor setupCodeEditor = null;

    public RFSelectorTableModel() {
        this.deviceTypeEditor = new DefaultCellEditor(this.deviceTypeBox);
        this.deviceTypeEditor.setClickCountToStart(2);
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Remote.RFSelector rfSel = (Remote.RFSelector)this.getRow(row);
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return rfSel.btn;
            }
            case 2: {
                return rfSel.irDevType;
            }
            case 3: {
                return rfSel.irCode;
            }
            case 4: {
                return rfSel.rfDevType;
            }
            case 5: {
                return rfSel.rfCode;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Remote.RFSelector rfSel = (Remote.RFSelector)this.getRow(row);
        switch (col) {
            case 2: {
                rfSel.irDevType = (DeviceType)value;
                return;
            }
            case 3: {
                rfSel.irCode = value instanceof String ? new SetupCode((String)value, false) : (SetupCode)value;
                return;
            }
            case 4: {
                rfSel.rfDevType = (DeviceType)value;
                return;
            }
            case 5: {
                rfSel.rfCode = value instanceof String ? new SetupCode((String)value, false) : (SetupCode)value;
                return;
            }
        }
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        switch (col) {
            case 0: {
                return new RowNumberRenderer();
            }
            case 3: 
            case 5: {
                return this.setupCodeRenderer;
            }
        }
        return null;
    }

    public void set(RemoteConfiguration remoteConfig, DeviceButton devBtn) {
        this.devBtn = devBtn;
        Remote remote = remoteConfig.getRemote();
        this.setupCodeRenderer = new SetupCodeRenderer(remoteConfig);
        this.setupCodeEditor = new SetupCodeEditor(this.setupCodeRenderer);
        DefaultComboBoxModel<DeviceType> comboModel = new DefaultComboBoxModel<DeviceType>(remote.getAllDeviceTypes());
        this.deviceTypeBox.setModel(comboModel);
        if (devBtn == null || devBtn.getRfSelectors() == null) {
            this.setData(new Remote.RFSelector[0]);
        } else {
            this.setData(devBtn.getRfSelectors());
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 1;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        switch (col) {
            case 2: 
            case 4: {
                return this.deviceTypeEditor;
            }
            case 3: 
            case 5: {
                return this.setupCodeEditor;
            }
        }
        return null;
    }

    public DeviceButton getDevBtn() {
        return this.devBtn;
    }
}

