/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeTableModel;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.SettingsTableModel;
import com.hifiremote.jp1.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class RMColorRenderer
extends DefaultTableCellRenderer {
    private Component component;
    private boolean isSelected;
    private Color color;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.component = super.getTableCellRendererComponent(table, value, false, false, row, col);
        this.isSelected = isSelected;
        boolean editable = true;
        String usage = "";
        TableModel model = table.getModel();
        if (model instanceof TableSorter) {
            row = ((TableSorter)model).modelIndex(row);
            model = ((TableSorter)model).getTableModel();
        }
        if (model instanceof JP1TableModel) {
            Object item = ((JP1TableModel)model).getRow(row);
            int mem = 0;
            if (model instanceof DeviceButtonTableModel && ((DeviceButtonTableModel)model).getEffectiveColumn(col) == 14) {
                DeviceButton db = (DeviceButton)item;
                int ndx = db.getColorIndex();
                if (ndx < 0) {
                    ndx = -ndx;
                    usage = "" + ndx;
                    value = Remote.getColorByIndex(ndx);
                } else if (ndx == 0) {
                    usage = "0";
                    value = Remote.getColorByIndex(1);
                } else {
                    usage = "" + ndx;
                    int[] params = db.getColorParams();
                    if (params != null) {
                        int r = Remote.scaleColor(params[0]);
                        int g = Remote.scaleColor(params[1]);
                        int b = Remote.scaleColor(params[2]);
                        value = new Color(r, g, b);
                    } else {
                        value = Remote.getColorByIndex(ndx);
                    }
                }
            } else if (item instanceof Highlight) {
                mem = ((Highlight)item).getMemoryUsage();
                usage = Integer.toString(mem < 0 ? -mem : mem);
            }
            if (model instanceof DeviceUpgradeTableModel) {
                editable = ((DeviceUpgradeTableModel)model).isCellEditable(row, col);
                if (((DeviceUpgradeTableModel)model).getEffectiveColumn(col) == 11) {
                    usage = Integer.toString(((DeviceUpgrade)item).getProtocolMemoryUsage());
                }
            } else if (model instanceof SettingsTableModel) {
                usage = mem < 0 ? usage + (mem == -1 ? " bit" : " bits") : usage + (mem == 1 ? " byte" : " bytes");
            }
        }
        this.color = editable ? (Color)value : Color.WHITE;
        this.setText(editable ? usage : "n/a");
        this.setForeground(editable ? Color.BLACK : Color.GRAY);
        return this.component;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.component.getSize();
        if (this.isSelected) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(this.color);
            g.fillRect(2, 2, d.width - 4, d.height - 4);
        } else {
            g.setColor(this.color);
            g.fillRect(0, 0, d.width, d.height);
        }
        super.paint(g);
    }
}

