/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.util.Arrays;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Equation;
import org.harctoolbox.irp.EquationSolving;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.RecognizeData;

public class RMEquation {
    public EquationSolving leftHandSide;
    public BitwiseParameter rightHandSide;
    public RecognizeData recognizeData;
    public LinkedList<RMEquation> eqnQueue = new LinkedList();

    public static String removeParens(String str) {
        int count = 0;
        str = str.trim();
        while (!str.isEmpty() && str.charAt(0) == '(') {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '(') {
                    ++count;
                } else if (c == ')') {
                    --count;
                }
                if (count == 0 && i != str.length() - 1) {
                    return str;
                }
                if (count != 0) continue;
                str = str.substring(1, str.length() - 1).trim();
            }
        }
        return str;
    }

    public static Long getBitMask(Expression exp) {
        if (RMEquation.isNumeric(exp.toString())) {
            return Long.parseLong(exp.toString());
        }
        ParseTree pt = exp.getParseTree();
        Long shift = null;
        try {
            if (pt.getChildCount() == 3) {
                String op = RMEquation.removeParens(pt.getChild(1).getText());
                Expression exp0 = Expression.newExpression(RMEquation.removeParens(pt.getChild(0).getText()));
                Expression exp2 = Expression.newExpression(RMEquation.removeParens(pt.getChild(2).getText()));
                BitwiseParameter bw2 = exp2.toBitwiseParameter(new RecognizeData());
                if (op.equals("<<") && bw2 != null && bw2.getBitmask() != 0L) {
                    return RMEquation.getBitMask(exp0) << (int)bw2.getValue();
                }
                if (op.equals("*") && (shift = RMEquation.getPowerOfTwo(exp0.toString())) != null) {
                    return RMEquation.getBitMask(exp2) << (int)shift.longValue();
                }
                if (op.equals("*") && (shift = RMEquation.getPowerOfTwo(exp2.toString())) != null) {
                    return RMEquation.getBitMask(exp0) << (int)shift.longValue();
                }
                if (op.equals("|") || op.equals("^")) {
                    return RMEquation.getBitMask(exp0) | RMEquation.getBitMask(exp2);
                }
                if (op.equals("&")) {
                    return RMEquation.getBitMask(exp0) & RMEquation.getBitMask(exp2);
                }
                return -1L;
            }
            if (pt.getChildCount() == 1 && exp.toString().contains(":")) {
                FiniteBitField fbf = new FiniteBitField(exp.toString());
                long width = fbf.getWidth(new NameEngine());
                return (1L << (int)width) - 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public RMEquation(String leftString, BitwiseParameter rightHandSide, RecognizeData recognizeData) {
        this.leftHandSide = Expression.newExpression(RMEquation.removeParens(leftString));
        this.rightHandSide = rightHandSide;
        this.recognizeData = recognizeData;
    }

    public boolean isOk() {
        return this.leftHandSide != null && this.rightHandSide != null && this.rightHandSide.getBitmask() != 0L;
    }

    private boolean isFinished() {
        return this.leftHandSide instanceof Name;
    }

    public boolean solve() {
        boolean ok2 = true;
        while (this.isOk() && !this.isFinished()) {
            this.solveStep();
        }
        if (this.isOk() && !this.eqnQueue.isEmpty()) {
            ok2 = this.eqnQueue.pop().solve();
        }
        return this.isOk() && ok2;
    }

    public void solveStep() {
        Long shift = null;
        ParseTree pt = ((Expression)this.leftHandSide).getParseTree();
        if (pt.getChildCount() == 3) {
            Expression exp;
            BitwiseParameter bw;
            String op = pt.getChild(1).getText();
            Expression exp0 = Expression.newExpression(RMEquation.removeParens(pt.getChild(0).getText()));
            Expression exp2 = Expression.newExpression(RMEquation.removeParens(pt.getChild(2).getText()));
            if (op.equals("+") || op.equals("|")) {
                Long mask0 = RMEquation.getBitMask(exp0);
                Long mask2 = RMEquation.getBitMask(exp2);
                if (mask0 != 0L && mask2 != 0L && (mask0 & mask2) == 0L) {
                    this.leftHandSide = exp0;
                    BitwiseParameter secondRHS = new BitwiseParameter(this.rightHandSide);
                    this.eqnQueue.push(new RMEquation(exp2.toString(), secondRHS, this.recognizeData));
                    this.eqnQueue.peek().setEqnQueue(this.eqnQueue);
                    return;
                }
            }
            BitwiseParameter bw0 = exp0.toBitwiseParameter(this.recognizeData);
            BitwiseParameter bw2 = exp2.toBitwiseParameter(this.recognizeData);
            if (bw0 != null && bw0.getBitmask() != 0L && bw2 != null && bw2.getBitmask() != 0L && exp0.toBitwiseParameter(new RecognizeData()) == null) {
                bw0 = null;
            }
            BitwiseParameter bitwiseParameter = bw0 != null && bw0.getBitmask() != 0L ? bw0 : (bw = bw2 != null && bw2.getBitmask() != 0L ? bw2 : null);
            Expression expression = bw0 != null && bw0.getBitmask() != 0L ? exp2 : (exp = bw2 != null && bw2.getBitmask() != 0L ? exp0 : null);
            if (bw == null) {
                this.leftHandSide = null;
                return;
            }
            if (op.equals("&")) {
                long mask = bw.getValue();
                this.leftHandSide = exp;
                this.rightHandSide = this.rightHandSide.restrict(mask);
            } else if (op.equals("<<")) {
                if (bw == bw2) {
                    this.leftHandSide = exp;
                    shift = bw.getValue();
                    long val = this.rightHandSide.getValue() >> (int)shift.longValue();
                    long mask = this.rightHandSide.getBitmask() >> (int)shift.longValue();
                    this.rightHandSide = new BitwiseParameter(val, mask);
                } else {
                    this.leftHandSide = null;
                }
            } else if (op.equals("+")) {
                this.leftHandSide = exp;
                this.rightHandSide = new BitwiseParameter(this.rightHandSide.getValue() - bw.getValue());
            } else if (op.equals("-")) {
                this.leftHandSide = exp;
                this.rightHandSide = new BitwiseParameter(bw == bw0 ? bw.getValue() - this.rightHandSide.getValue() : bw.getValue() + this.rightHandSide.getValue());
            } else if (op.equals("^")) {
                this.leftHandSide = exp;
                this.rightHandSide = this.rightHandSide.xor(bw);
            } else if (op.equals("*") && (shift = RMEquation.getPowerOfTwo(exp0.toString())) != null) {
                this.leftHandSide = exp2;
                long val = this.rightHandSide.getValue() >> (int)shift.longValue();
                long mask = this.rightHandSide.getBitmask() >> (int)shift.longValue();
                this.rightHandSide = new BitwiseParameter(val, mask);
            } else if (op.equals("*") && (shift = RMEquation.getPowerOfTwo(exp2.toString())) != null) {
                this.leftHandSide = exp0;
                long val = this.rightHandSide.getValue() >> (int)shift.longValue();
                long mask = this.rightHandSide.getBitmask() >> (int)shift.longValue();
                this.rightHandSide = new BitwiseParameter(val, mask);
            } else if (op.contentEquals("/")) {
                this.leftHandSide = exp;
                this.rightHandSide = new BitwiseParameter(this.rightHandSide.getValue() * bw.getValue());
            } else {
                this.leftHandSide = null;
            }
        } else if (pt.getChildCount() == 1) {
            try {
                Equation eq = new Equation(this.leftHandSide, this.rightHandSide, this.recognizeData);
                if (!eq.solve()) {
                    this.leftHandSide = null;
                    return;
                }
                this.rightHandSide = eq.getValue();
                this.leftHandSide = this.rightHandSide.getBitmask() != 0L ? eq.getName() : null;
                this.recognizeData.add(this.leftHandSide.toString(), this.rightHandSide);
            }
            catch (NullPointerException | NameUnassignedException | ParameterInconsistencyException e) {
                this.leftHandSide = null;
            }
        } else {
            this.leftHandSide = null;
        }
    }

    public void setEqnQueue(LinkedList<RMEquation> eqnQueue) {
        this.eqnQueue = eqnQueue;
    }

    public String toString() {
        return this.leftHandSide.toString() + "=" + this.rightHandSide.toString();
    }

    private static Long getPowerOfTwo(String s) {
        int val = 0;
        try {
            val = Integer.parseInt(s.trim());
            long exponent = Arrays.asList(1, 2, 4, 8, 16, 32, 64, 128).indexOf(val);
            return exponent < 0L ? null : Long.valueOf(exponent);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static class ProtoEquation {
        public String leftString;
        public String rightString;

        public ProtoEquation(String leftString, String rightString) {
            this.leftString = leftString;
            this.rightString = rightString;
        }

        public String toString() {
            return this.leftString + "=" + this.rightString;
        }
    }
}

