/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.LibraryLoader;
import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityFunctionTableModel;
import com.hifiremote.jp1.ActivityGroupTableModel;
import com.hifiremote.jp1.ActivityPanel;
import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.AutoClockSet;
import com.hifiremote.jp1.BinAnalyzer;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ChoiceArea;
import com.hifiremote.jp1.CodeSelectorDialog;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceLabels;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.DeviceUpgradePanel;
import com.hifiremote.jp1.DigitMaps;
import com.hifiremote.jp1.DynamicURLClassLoader;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.FavScanPanel;
import com.hifiremote.jp1.FavoritesPanel;
import com.hifiremote.jp1.FixedData;
import com.hifiremote.jp1.GeneralPanel;
import com.hifiremote.jp1.GlobalPTPanel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.HtmlGenerator;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JP2Analyzer;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.KeyMovePanel;
import com.hifiremote.jp1.KeyMoveTableModel;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalPanel;
import com.hifiremote.jp1.MacroPanel;
import com.hifiremote.jp1.NoSetup;
import com.hifiremote.jp1.PortDialog;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProgressUpdater;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.ProtocolUpgradePanel;
import com.hifiremote.jp1.RMDirectoryChooser;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMListChooser;
import com.hifiremote.jp1.RMNewDialog;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.RawDataDialog;
import com.hifiremote.jp1.RawDataPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Scanner;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SegmentPanel;
import com.hifiremote.jp1.Setting;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SlingLearnParser;
import com.hifiremote.jp1.SoftDevices;
import com.hifiremote.jp1.SpecialFunctionPanel;
import com.hifiremote.jp1.TI2541Processor;
import com.hifiremote.jp1.TablePanel;
import com.hifiremote.jp1.TableSorter;
import com.hifiremote.jp1.TextFileViewer;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.TimedMacroPanel;
import com.hifiremote.jp1.UpdateChecker;
import com.hifiremote.jp1.UpgradeSourceSelector;
import com.hifiremote.jp1.WrapLayout;
import com.hifiremote.jp1.XSightFileDataPanel;
import com.hifiremote.jp1.extinstall.BTExtInstall;
import com.hifiremote.jp1.extinstall.ExtInstall;
import com.hifiremote.jp1.extinstall.RMExtInstall;
import com.hifiremote.jp1.extinstall.RMWavConverter;
import com.hifiremote.jp1.extinstall.RMWavPlayer;
import com.hifiremote.jp1.io.BLERemote;
import com.hifiremote.jp1.io.CommHID;
import com.hifiremote.jp1.io.CommHIDA;
import com.hifiremote.jp1.io.CommHIDB;
import com.hifiremote.jp1.io.IO;
import com.hifiremote.jp1.io.JP11USB;
import com.hifiremote.jp1.io.JP12Serial;
import com.hifiremote.jp1.io.JP1Parallel;
import com.hifiremote.jp1.io.JP1USB;
import com.hifiremote.jp1.io.JP2BT;
import com.hifiremote.jp1.io.JPS;
import com.hifiremote.jp1.rf.RfRemote;
import com.hifiremote.jp1.rf.RfTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class RMIRSetup
extends JP1Frame
implements ActionListener,
PropertyChangeListener,
HyperlinkListener,
ChangeListener {
    public static final int MAX_RDF_SYNC = 5;
    public static final int MIN_RDF_SYNC = 3;
    public static final Color AQUAMARINE = new Color(127, 255, 212);
    public static LanguageDescriptor defaultLanguage = new LanguageDescriptor("Current", null);
    public static LinkedHashMap<Integer, LanguageDescriptor> languages = null;
    public static int defaultToolTipTimeout = 5000;
    public static File rdfInfoFile = null;
    public static JCheckBoxMenuItem noUpgradeItem = null;
    public static JCheckBoxMenuItem disableActivitiesItem = null;
    public static JCheckBoxMenuItem disableUploadRestrictionsItem = null;
    public static JMenu overrideSetupValidation = null;
    public static JRadioButtonMenuItem validationOff = new JRadioButtonMenuItem("Off");
    public static JRadioButtonMenuItem validationWarn = new JRadioButtonMenuItem("Warn");
    public static JRadioButtonMenuItem validationEnforce = new JRadioButtonMenuItem("Enforce");
    public static JRadioButtonMenuItem validationDefault = new JRadioButtonMenuItem("Default");
    public static JRadioButtonMenuItem[] validations = new JRadioButtonMenuItem[]{validationDefault, validationOff, validationWarn, validationEnforce};
    public static JCheckBoxMenuItem forceUpgradeItem = null;
    public static JCheckBoxMenuItem forceFDRAUpgradeItem = null;
    public static RMCheckBoxMenuItem showXziteFileDataItem = null;
    public static RMCheckBoxMenuItem suppressTimingSummaryInfo = null;
    public static RMCheckBoxMenuItem suppressConfirmPrompts = null;
    public static RMCheckBoxMenuItem showSegmentEditorItem = null;
    public static JCheckBoxMenuItem findAllBTItem = null;
    public static JCheckBoxMenuItem findAllArduinoItem = null;
    private static File summaryFile = null;
    private static JCheckBoxMenuItem getSystemFilesItem = null;
    private static JMenuItem putSystemFileItem = null;
    private static JMenuItem saveFDRAfirmware = null;
    private static JMenuItem parseIRDBItem = null;
    private static JMenuItem xziteOpsItem = null;
    private static JMenuItem xziteRegItem = null;
    private static JMenuItem xziteReformatItem = null;
    private static JMenuItem verifyXZITEfilesItem = null;
    private static JMenuItem upgradeSourceItem = null;
    private static JMenu xziteOps = null;
    private static JMenu digitalOps = null;
    private static JMenuItem extractSSItem = null;
    private static JMenuItem analyzeMAXQprotocols = null;
    private static JMenuItem importIctAsLearned = null;
    private static JMenuItem openRmasterErr = null;
    private static String scaling = null;
    public File file = null;
    public Remote.SetupValidation validationOverride = null;
    protected RMAction highlightAction = null;
    protected JCheckBoxMenuItem highlightItem = null;
    private ArrayList<IO> interfaces = new ArrayList();
    private File dir = null;
    private File mergeDir = null;
    private RfTools rfTools = null;
    private RemoteConfiguration remoteConfig = null;
    private JToolBar toolBar = null;
    private RMAction newAction = null;
    private RMAction newUpgradeAction = null;
    private RMAction newProtocolAction = null;
    private RMAction codesAction = null;
    private RMAction openAction = null;
    private RMAction saveAction = null;
    private RMAction saveAsAction = null;
    private RMAction xziteReenableAction = null;
    private RMAction xziteHidapiAction = null;
    private RMAction xziteHid4JavaAction = null;
    private RMAction openRdfAction = null;
    private RMAction bluetoothAction = null;
    private RMAction rfAction = null;
    private RMAction finderAction = null;
    private RMAction downloadAction = null;
    private RMAction uploadAction = null;
    private JMenu exportToWavSubMenu = null;
    private JMenu recentFiles = null;
    private JMenuItem installExtenderItem = null;
    private JMenuItem importFromWavNewItem = null;
    private JMenuItem importFromWavMergeItem = null;
    private JMenuItem exportToWavImageItem = null;
    private JMenuItem exportToWavSettingsItem = null;
    private JMenuItem exportToWavMacrosEtcItem = null;
    private JMenuItem exportToWavTimedMacrosItem = null;
    private JMenuItem exportToWavUpgradesItem = null;
    private JMenuItem exportToWavLearnedItem = null;
    private JMenuItem exportToGirrItem = null;
    private JMenuItem createSummaryItem = null;
    private JMenuItem createSelectionItem = null;
    private JMenuItem viewSummaryItem = null;
    private JMenuItem saveSummaryItem = null;
    private JMenuItem createRDFInfoFileItem = null;
    private JMenuItem rdfPathItem = null;
    private JMenuItem mapPathItem = null;
    private JMenuItem addonPathItem = null;
    private JMenuItem setBaselineItem = null;
    private JMenuItem clearBaselineItem = null;
    private JMenuItem exitItem = null;
    private JMenuItem uploadWavItem = null;
    private JMenuItem cancelWavUploadItem = null;
    private JMenuItem downloadRawItem = null;
    private JMenuItem registerRfRemoteItem = null;
    private JMenuItem progressBarColors = null;
    private JMenuItem cleanUpperMemoryItem = null;
    private JMenuItem clearAltPIDHistory = null;
    private JMenuItem initializeTo00Item = null;
    private JMenuItem initializeToFFItem = null;
    private JMenuItem updateItem = null;
    private JMenuItem readmeItem = null;
    private JMenuItem rmpbReadmeItem = null;
    private JMenuItem tutorialItem = null;
    private JMenuItem homePageItem = null;
    private JMenuItem learnedSignalItem = null;
    private JMenuItem irpProtocolsItem = null;
    private JMenuItem wikiItem = null;
    private JMenuItem forumItem = null;
    private JCheckBoxMenuItem bluetoothItem = null;
    private JCheckBoxMenuItem finderItem = null;
    private JCheckBoxMenuItem verifyUploadItem = null;
    private JCheckBoxMenuItem noPortSearchItem = null;
    private JCheckBoxMenuItem enablePreserveSelection = null;
    private JCheckBoxMenuItem showSlingboxProtocols = null;
    private JCheckBoxMenuItem useSavedDataItem = null;
    private JRadioButtonMenuItem[] lookAndFeelItems = null;
    private JRadioButtonMenuItem irpTransmogrifierItem = null;
    private JRadioButtonMenuItem decodeIRItem = null;
    private JRadioButtonMenuItem defaultDelayItem = null;
    private JRadioButtonMenuItem specifiedDelayItem = null;
    private JRadioButton pbSelDefault;
    private JRadioButton pbSelBlue;
    private JRadioButton pbSelBlack;
    private JRadioButton pbSelWhite;
    private JRadioButton pbUnselDefault;
    private JRadioButton pbUnselBlue;
    private JRadioButton pbUnselBlack;
    private JRadioButton pbForeDefault;
    private JRadioButton pbForeAquamarine;
    private JRadioButton pbForeBlack;
    private JRadioButton pbForeBlue;
    private JRadioButton pbForeRed;
    private JRadioButton pbForeOrange;
    private JRadioButton pbForeGreen;
    private JToggleButton bluetoothButton = null;
    private JToggleButton finderButton = null;
    private JButton searchButton = null;
    private JButton registerButton = null;
    private JButton deregisterButton = null;
    private JButton pbOkButton = null;
    private JButton pbCancelButton = null;
    private Box box = null;
    private ButtonGroup btGroup = null;
    private LinkedHashMap<String, BLERemote> bleMap = new LinkedHashMap();
    private LinkedHashMap<JRadioButton, BLERemote> bleBtnMap = new LinkedHashMap();
    private LinkedHashMap<String, JRadioButtonMenuItem> ioButtonMap = null;
    private BatteryBar batteryBar = null;
    private JLabel batteryVoltage = null;
    private JProgressBar signalProgressBar = null;
    private boolean uploadable = false;
    private JP2BT btio = null;
    private Color pbSelectedColor = null;
    private Color pbUnselectedColor = null;
    private Color pbForegroundColor = null;
    private JDialog pbDialog = null;
    private int tooltipDelay = 0;
    private int tooltipDefaultDelay = 0;
    private JMenuItem aboutItem = null;
    private JTabbedPane tabbedPane = null;
    private RMPanel currentPanel = null;
    private GeneralPanel generalPanel = null;
    private KeyMovePanel keyMovePanel = null;
    private MacroPanel macroPanel = null;
    private GlobalPTPanel globalPTPanel = null;
    private SpecialFunctionPanel specialFunctionPanel = null;
    private TimedMacroPanel timedMacroPanel = null;
    private FavScanPanel favScanPanel = null;
    private FavoritesPanel favoritesPanel = null;
    private DeviceUpgradePanel devicePanel = null;
    private ProtocolUpgradePanel protocolPanel = null;
    private ActivityPanel activityPanel = null;
    private LearnedSignalPanel learnedPanel = null;
    private RawDataPanel rawDataPanel = null;
    private SegmentPanel segmentPanel = null;
    private XSightFileDataPanel xsightFileDataPanel = null;
    private JProgressBar advProgressBar = null;
    private JLabel advProgressLabel = null;
    private JProgressBar upgradeProgressBar = null;
    private JProgressBar devUpgradeProgressBar = null;
    private JPanel upgradeProgressPanel = null;
    private JProgressBar learnedProgressBar = null;
    private JPanel memoryStatus = null;
    private JPanel extraStatus = null;
    private JPanel bleStatus = null;
    private JPanel interfaceStatus = null;
    private JPanel warningStatus = null;
    private String interfaceText = null;
    private DeviceUpgradeEditor duEditor = null;
    private JProgressBar interfaceState = null;
    private boolean exitPrompt = false;
    private JPanel statusBar = null;
    private JScrollPane scroll = null;
    private boolean hasInvalidCodes = false;
    private CodeSelectorDialog codeSelectorDialog = null;
    private JDialog colorDialog = null;
    private ActionEvent lfEvent = null;
    private JColorChooser colorChooser = null;
    private TextFileViewer rdfViewer = null;
    private RMWavPlayer wavPlayer = null;
    private NoSetup noSetup = null;
    private List<AssemblerItem> clipBoardItems = new ArrayList<AssemblerItem>();
    private static int rfDataAddress = 0;
    private static File upgradeSource = null;
    private static LanguageDescriptor upgradeLanguage = defaultLanguage;
    private static int[] parsedWindowsVersion = null;
    public static final String[] irEndings = new String[]{".ir"};
    private static final String[] setupEndings = new String[]{".rmir"};
    private static final String[] setupImportEndings = new String[]{".ir"};
    private static final String[] simplesetEndings = new String[]{".bin"};
    private static final String[] slingEndings = new String[]{".xml"};
    private static final String[] infoFileEndings = new String[]{".csv"};
    public static final String[] snifferEndings = new String[]{".psd"};
    private static final String[] allEndings = new String[]{".rmir", ".ir", ".rmdu", ".rmpb", ".txt", ".xml", ".bin", ".psd", ".girr", ".ict"};
    private static final String[] allAdminEndings = new String[]{".rmir", ".ir", ".rmdu", ".rmpb", ".txt", ".xml", ".bin", ".psd", ".girr", ".ict", ".ctl", ".hexin"};
    private static final String[] allMergeEndings = new String[]{".hex", ".ir", ".txt"};
    private static final String[] extenderEndings = new String[]{".hex"};
    private static final String[] modemEndings = new String[]{".wav"};
    private static final String[] summaryEndings = new String[]{".html"};
    private static final String[] adminSpecialEndings = new String[]{".ctl", ".hexin"};
    private static final String[] otherMergeEndings = new String[]{".ir", ".txt"};
    private boolean changed = false;

    public static File getSummaryFile() {
        return summaryFile;
    }

    public JDialog getColorDialog() {
        return this.colorDialog;
    }

    public JColorChooser getColorChooser() {
        return this.colorChooser;
    }

    public static File getJreExecutable() {
        String jreDirectory = System.getProperty("java.home");
        File javaExe = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            javaExe = new File(jreDirectory, "bin/javaw.exe");
        } else {
            javaExe = new File(jreDirectory, "bin/javaw");
            if (!javaExe.exists()) {
                javaExe = new File(jreDirectory, "bin/java");
            }
        }
        if (!javaExe.exists()) {
            return null;
        }
        return javaExe;
    }

    private static List<String> getCmdList() {
        ArrayList<String> cmdList = new ArrayList<String>();
        try {
            String[] cmdBase;
            File javaExe = RMIRSetup.getJreExecutable();
            if (javaExe == null) {
                System.err.println("Unable to find java executable");
                return null;
            }
            String classPath = System.getProperty("java.class.path");
            String propertiesName = properties.getFile().getCanonicalPath();
            for (String s : cmdBase = new String[]{javaExe.getCanonicalPath(), "-cp", classPath, "com.hifiremote.jp1.RemoteMaster", "-home", RemoteMaster.getWorkDir().getAbsolutePath(), "-properties", propertiesName}) {
                cmdList.add(s);
            }
            return cmdList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void runKM(String filename) {
        try {
            Runtime r = Runtime.getRuntime();
            List<String> cmdList = RMIRSetup.getCmdList();
            if (cmdList == null) {
                return;
            }
            cmdList.add("-rm");
            if (scaling != null) {
                cmdList.add("-scaling");
                cmdList.add(scaling);
            }
            if (filename != null && !filename.isEmpty()) {
                cmdList.add(filename);
            }
            String[] cmdArray = cmdList.toArray(new String[0]);
            r.exec(cmdArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runPB(String filename) {
        try {
            Runtime r = Runtime.getRuntime();
            List<String> cmdList = RMIRSetup.getCmdList();
            if (cmdList == null) {
                return;
            }
            cmdList.add("-pb");
            if (scaling != null) {
                cmdList.add("-scaling");
                cmdList.add(scaling);
            }
            if (filename != null && !filename.isEmpty()) {
                cmdList.add(filename);
            }
            String[] cmdArray = cmdList.toArray(new String[0]);
            r.exec(cmdArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public short[] getInitializationData(int value) {
        short[] data = null;
        String title = "Initialize EEPROM Area";
        String message = "This will fill your remote's EEPROM with $" + Hex.asString(value) + "\n\nDoing so will likely cause the remote to stop working until you\nperform a hard reset.  Are you sure you want to do this?\n(Make sure your current configuration is saved before proceeding.)";
        if (NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message, title, 0, 2) == 0) {
            data = new short[this.remoteConfig.getRemote().getEepromSize()];
            Arrays.fill(data, 0, data.length, (short)value);
        }
        return data;
    }

    private Highlight getTableRow(JP1Table table, int row) {
        if (row == -1) {
            return null;
        }
        Object obj = this.currentPanel instanceof RMTablePanel ? ((RMTablePanel)this.currentPanel).getRowObject(row) : ((JP1TableModel)table.getModel()).getRow(row);
        if (obj instanceof Highlight) {
            return (Highlight)obj;
        }
        return null;
    }

    private Color getInitialHighlight(JP1Table table, int colorCol) {
        Color color;
        block5: {
            int[] rows;
            color = null;
            if (table == null || (rows = table.getSelectedRows()).length <= 0 || this.getTableRow(table, rows[0]) == null) break block5;
            if (this.currentPanel == this.devicePanel && colorCol == 1) {
                for (int i : rows) {
                    DeviceUpgrade du = (DeviceUpgrade)this.devicePanel.getRowObject(i);
                    if (!du.needsProtocolCode()) continue;
                    if (color == null) {
                        color = du.getProtocolHighlight();
                        continue;
                    }
                    if (du.getProtocolHighlight().equals(color)) continue;
                    return Color.WHITE;
                }
            } else {
                color = this.getTableRow(table, rows[0]).getHighlight();
                for (int i : rows) {
                    if (this.getTableRow(table, i).getHighlight().equals(color)) continue;
                    return Color.WHITE;
                }
            }
        }
        return color;
    }

    public RMIRSetup(File workDir, PropertyFile prefs, String scaling) throws Exception {
        super("RMIR", prefs);
        RemoteMaster.frame = this;
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        RMIRSetup.scaling = scaling;
        summaryFile = RemoteMaster.getWritableFile(workDir, "summary.html");
        LearnedSignal.getTmDecoder();
        File defaultDir = new File(workDir, "SetupFiles");
        this.dir = properties.getFileProperty("IRPath", defaultDir);
        defaultToolTipTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.bleStatus = new JPanel(new FlowLayout(0, 5, 0));
        this.createMenus();
        this.createToolbar();
        this.setDefaultCloseOperation(2);
        RMIRSetup.setDefaultLookAndFeelDecorated(true);
        ProtocolManager.getProtocolManager().loadAltPIDRemoteProperties(properties);
        final Preview preview = new Preview();
        preview.setBorder(BorderFactory.createLineBorder(preview.getBackground()));
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(preview);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColorSelectionModel model = (ColorSelectionModel)evt.getSource();
                preview.sample.setBackground(model.getSelectedColor());
            }
        });
        this.colorDialog = JColorChooser.createDialog(this, "Highlight Color", true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                preview.result = RMIRSetup.this.colorChooser.getColor();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                preview.result = null;
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent event) {
                boolean doDispose = true;
                try {
                    System.err.println("RMIRSetup.windowClosing() entered");
                    if (RMIRSetup.this.btio != null) {
                        if (RMIRSetup.this.btio.isScanning()) {
                            RMIRSetup.this.btio.discoverUEI(false, false);
                            RMIRSetup.this.setInterfaceState(null);
                        }
                        RMIRSetup.this.btio.setDisconnecting(false);
                        RMIRSetup.this.disconnectBLE();
                    }
                    boolean quit = false;
                    if (RMIRSetup.this.interfaceText != null) {
                        String title = "Request to exit";
                        String message = "A \"" + RMIRSetup.this.interfaceText + "\" task is in progress.  You risk corrupting it if you exit\nbefore it completes.  Are you sure you wish to continue?";
                        boolean bl = quit = NegativeDefaultButtonJOptionPane.showConfirmDialog(RMIRSetup.this, message, title, 0, 2) == 1;
                    }
                    if (!RMIRSetup.this.promptToSave(true) || RMIRSetup.this.exitPrompt || quit) {
                        System.err.println("RMIRSetup.windowClosing() exited");
                        doDispose = false;
                        return;
                    }
                    if (RMIRSetup.this.rfTools != null) {
                        RMIRSetup.this.rfTools.dispatchEvent(new WindowEvent(RMIRSetup.this, 201));
                    }
                    RMIRSetup.this.downloadAction = null;
                    RMIRSetup.this.uploadAction = null;
                    for (int i = 0; i < RMIRSetup.this.recentFiles.getItemCount(); ++i) {
                        JMenuItem item = RMIRSetup.this.recentFiles.getItem(i);
                        JP1Frame.properties.setProperty("RecentIRs." + i, item.getActionCommand());
                    }
                    JP1Frame.properties.remove("Primacy");
                    ProtocolManager.getProtocolManager().setAltPIDRemoteProperties(JP1Frame.properties);
                    int state = RMIRSetup.this.getExtendedState();
                    if (state != 0) {
                        RMIRSetup.this.setExtendedState(0);
                    }
                    Rectangle bounds = RMIRSetup.this.getBounds();
                    JP1Frame.properties.setProperty("RMBounds", "" + bounds.x + ',' + bounds.y + ',' + bounds.width + ',' + bounds.height);
                    JP1Frame.properties.save();
                    if (RMIRSetup.this.generalPanel.getDeviceUpgradeEditor() != null) {
                        RMIRSetup.this.generalPanel.getDeviceUpgradeEditor().dispose();
                    }
                    if (RMIRSetup.this.keyMovePanel.getDeviceUpgradeEditor() != null) {
                        RMIRSetup.this.keyMovePanel.getDeviceUpgradeEditor().dispose();
                    }
                    if (RMIRSetup.this.devicePanel.getDeviceUpgradeEditor() != null) {
                        RMIRSetup.this.devicePanel.getDeviceUpgradeEditor().dispose();
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace(System.err);
                }
                finally {
                    if (doDispose) {
                        RMIRSetup.this.dispose();
                        if (RemoteManager.getRemoteManager().isFilesSet()) {
                            System.exit(128);
                        }
                    }
                }
            }
        });
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                DeviceUpgradeEditor editor = RMIRSetup.this.devicePanel.getDeviceUpgradeEditor();
                if (e.getNewState() == 0 && editor != null && editor.getState() == 1) {
                    editor.setExtendedState(0);
                    editor.toFront();
                } else if (e.getNewState() == 1 && editor != null) {
                    editor.setExtendedState(1);
                }
            }
        });
        Container mainPanel = this.getContentPane();
        mainPanel.add((Component)this.toolBar, "First");
        this.setPBSelectedColors();
        if (this.pbUnselectedColor != null) {
            UIManager.put("ProgressBar.selectionBackground", new ColorUIResource(this.pbUnselectedColor));
        }
        if (this.pbSelectedColor != null) {
            UIManager.put("ProgressBar.selectionForeground", new ColorUIResource(this.pbSelectedColor));
        }
        if (this.pbForegroundColor != null) {
            UIManager.put("ProgressBar.foreground", new ColorUIResource(this.pbForegroundColor));
        }
        this.tabbedPane = new JTabbedPane();
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.generalPanel = new GeneralPanel();
        this.tabbedPane.addTab("General", this.generalPanel);
        this.generalPanel.addRMPropertyChangeListener(this);
        this.keyMovePanel = new KeyMovePanel();
        this.keyMovePanel.addRMPropertyChangeListener(this);
        this.macroPanel = new MacroPanel();
        this.macroPanel.addRMPropertyChangeListener(this);
        this.globalPTPanel = new GlobalPTPanel();
        this.globalPTPanel.addRMPropertyChangeListener(this);
        this.specialFunctionPanel = new SpecialFunctionPanel();
        this.specialFunctionPanel.addRMPropertyChangeListener(this);
        this.timedMacroPanel = new TimedMacroPanel();
        this.timedMacroPanel.addRMPropertyChangeListener(this);
        this.favScanPanel = new FavScanPanel();
        this.favScanPanel.addRMPropertyChangeListener(this);
        this.favoritesPanel = new FavoritesPanel();
        this.favoritesPanel.addRMPropertyChangeListener(this);
        this.devicePanel = new DeviceUpgradePanel();
        this.devicePanel.addRMPropertyChangeListener(this);
        this.protocolPanel = new ProtocolUpgradePanel();
        this.protocolPanel.addRMPropertyChangeListener(this);
        this.activityPanel = new ActivityPanel();
        this.activityPanel.addRMPropertyChangeListener(this);
        this.learnedPanel = new LearnedSignalPanel();
        this.learnedPanel.addRMPropertyChangeListener(this);
        this.rawDataPanel = new RawDataPanel();
        this.tabbedPane.addTab("Raw Data", this.rawDataPanel);
        this.rawDataPanel.addRMPropertyChangeListener(this);
        this.segmentPanel = new SegmentPanel();
        this.segmentPanel.addRMPropertyChangeListener(this);
        this.xsightFileDataPanel = new XSightFileDataPanel();
        this.tabbedPane.addChangeListener(this);
        this.statusBar = new JPanel(new CardLayout());
        mainPanel.add((Component)this.statusBar, "South");
        this.memoryStatus = new JPanel(new WrapLayout(1));
        this.extraStatus = new JPanel(new WrapLayout(0));
        this.interfaceStatus = new JPanel();
        this.warningStatus = new JPanel();
        JLabel warningMessage = new JLabel("DO NOT EDIT THIS MAIN WINDOW WHILE THE DEVICE EDITOR IS OPEN");
        Font font = warningMessage.getFont().deriveFont(1);
        warningMessage.setFont(font);
        this.warningStatus.add(warningMessage);
        this.interfaceState = new JProgressBar();
        this.interfaceStatus.add(this.interfaceState);
        this.interfaceState.setIndeterminate(true);
        this.interfaceState.setStringPainted(true);
        this.interfaceState.setString("");
        Dimension d = this.interfaceState.getPreferredSize();
        d.width *= 3;
        this.interfaceState.setPreferredSize(d);
        this.statusBar.add((Component)this.memoryStatus, "MEMORY");
        this.statusBar.add((Component)this.interfaceStatus, "INTERFACE");
        this.statusBar.add((Component)this.warningStatus, "WARNING");
        ((CardLayout)this.statusBar.getLayout()).first(this.statusBar);
        this.advProgressLabel = new JLabel("Move/Macro:");
        this.memoryStatus.add(this.advProgressLabel);
        this.advProgressBar = new JProgressBar();
        this.advProgressBar.setStringPainted(true);
        this.advProgressBar.setString("N/A");
        this.memoryStatus.add(this.advProgressBar);
        this.extraStatus.add(Box.createHorizontalStrut(1));
        JSeparator sep = new JSeparator(1);
        d = sep.getPreferredSize();
        d.height = this.advProgressBar.getPreferredSize().height;
        sep.setPreferredSize(d);
        this.extraStatus.add(sep);
        this.interfaceStatus.add(Box.createVerticalStrut(d.height));
        this.bleStatus.add(Box.createHorizontalStrut(5));
        sep = new JSeparator(1);
        sep.setPreferredSize(d);
        this.bleStatus.add(sep);
        this.bleStatus.add(Box.createHorizontalStrut(5));
        this.bleStatus.add(new JLabel("Battery:"));
        this.batteryBar = new BatteryBar();
        int sizeUnit = d.height / 2;
        this.batteryBar.setPreferredSize(new Dimension(6 * sizeUnit - 2, sizeUnit));
        this.bleStatus.add(this.batteryBar);
        this.batteryVoltage = new JLabel();
        this.bleStatus.add(this.batteryVoltage);
        this.bleStatus.add(Box.createHorizontalStrut(5));
        sep = new JSeparator(1);
        sep.setPreferredSize(d);
        this.bleStatus.add(sep);
        this.bleStatus.add(Box.createHorizontalStrut(5));
        this.bleStatus.add(new JLabel("Signal:"));
        this.signalProgressBar = new JProgressBar();
        this.signalProgressBar.setStringPainted(true);
        this.signalProgressBar.setPreferredSize(this.advProgressBar.getPreferredSize());
        this.signalProgressBar.setFont(this.advProgressBar.getFont());
        this.signalProgressBar.setMinimum(-91);
        this.signalProgressBar.setMaximum(-38);
        if (this.pbForegroundColor != null) {
            this.signalProgressBar.setForeground(this.pbForegroundColor);
        }
        this.bleStatus.add(this.signalProgressBar);
        this.bleStatus.setVisible(false);
        this.memoryStatus.add(this.bleStatus);
        this.extraStatus.add(new JLabel("Upgrade:"));
        this.upgradeProgressBar = new JProgressBar();
        this.upgradeProgressBar.setStringPainted(true);
        this.upgradeProgressBar.setString("N/A");
        this.upgradeProgressPanel = new JPanel();
        this.upgradeProgressPanel.setPreferredSize(this.advProgressBar.getPreferredSize());
        this.upgradeProgressPanel.setLayout(new BorderLayout());
        this.devUpgradeProgressBar = new JProgressBar();
        this.devUpgradeProgressBar.setStringPainted(true);
        this.devUpgradeProgressBar.setString("N/A");
        this.devUpgradeProgressBar.setVisible(false);
        this.upgradeProgressPanel.add((Component)this.upgradeProgressBar, "North");
        this.upgradeProgressPanel.add((Component)this.devUpgradeProgressBar, "South");
        this.extraStatus.add(this.upgradeProgressPanel);
        this.extraStatus.add(Box.createHorizontalStrut(5));
        sep = new JSeparator(1);
        sep.setPreferredSize(d);
        this.extraStatus.add(sep);
        this.extraStatus.add(new JLabel("Learned:"));
        this.learnedProgressBar = new JProgressBar();
        this.learnedProgressBar.setStringPainted(true);
        this.learnedProgressBar.setString("N/A");
        this.extraStatus.add(this.learnedProgressBar);
        this.memoryStatus.add(this.extraStatus);
        languages = new LinkedHashMap();
        languages.put(0, new LanguageDescriptor("None", 0));
        languages.put(9, new LanguageDescriptor("Danish", 9));
        String temp = properties.getProperty("RMBounds");
        if (temp != null) {
            Rectangle bounds = new Rectangle();
            StringTokenizer st = new StringTokenizer(temp, ",");
            bounds.x = Integer.parseInt(st.nextToken());
            bounds.y = Integer.parseInt(st.nextToken());
            bounds.width = Integer.parseInt(st.nextToken());
            bounds.height = Integer.parseInt(st.nextToken());
            this.setBounds(bounds);
        } else {
            this.pack();
        }
        this.currentPanel = this.generalPanel;
        this.setVisible(true);
    }

    public static LanguageDescriptor getLanguage(int code) {
        return languages.get(code);
    }

    public boolean useSavedData() {
        return this.useSavedDataItem.isSelected();
    }

    public static boolean getSystemFiles() {
        return getSystemFilesItem.isSelected();
    }

    public static String getSystemZipName(Remote remote) {
        String sig = remote.getSignature();
        return "Sys" + sig.substring(3) + ".zip";
    }

    public static ZipFile getSystemZipFile(Remote remote) {
        ZipFile zipfile = null;
        try {
            String zipName = RMIRSetup.getSystemZipName(remote);
            File inputDir = new File(RemoteMaster.getWorkDir(), "XSight");
            File file = new File(inputDir, zipName);
            if (file.exists()) {
                zipfile = new ZipFile(new File(inputDir, zipName));
            }
        }
        catch (Exception e) {
            return null;
        }
        return zipfile;
    }

    public static void setSystemFilesItems(RMIRSetup rm, Remote remote) {
        if (remote != null && remote.isSSD()) {
            xziteOps.setVisible(RemoteMaster.getRmirSys().exists());
            digitalOps.setVisible(false);
            extractSSItem.setVisible(false);
            ZipFile zipfile = RMIRSetup.getSystemZipFile(remote);
            parseIRDBItem.setEnabled(zipfile != null && zipfile.getEntry("irdb.bin") != null);
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (remote != null && remote.isFDRA()) {
            xziteOps.setVisible(false);
            digitalOps.setVisible(RemoteMaster.getRmirSys().exists());
            upgradeSourceItem.setVisible(RemoteMaster.admin || !remote.getSignature().equals("USB0007"));
            extractSSItem.setVisible(false);
            return;
        }
        xziteOps.setVisible(false);
        digitalOps.setVisible(false);
        extractSSItem.setVisible(RemoteMaster.admin && (remote != null && remote.usesSimpleset() || rm.binLoaded() != null));
        extractSSItem.setEnabled(RemoteMaster.admin && rm.binLoaded() != null);
    }

    public static byte[] readBinary(File file) {
        byte[] data = null;
        try {
            int length = (int)file.length();
            if (length == 0) {
                System.err.println("File " + file.getAbsolutePath() + " empty or not found");
                return null;
            }
            FileInputStream in = new FileInputStream(file);
            data = RMIRSetup.readBinary(in, length);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            System.err.println(ex);
            return null;
        }
        return data;
    }

    public static byte[] readBinary(InputStream in, int length) {
        return RMIRSetup.readBinary(in, length, false);
    }

    public static byte[] readBinary(InputStream in, int length, boolean quiet) {
        if (in == null || length == 0) {
            return null;
        }
        int totalBytesRead = 0;
        byte[] data = new byte[length];
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(in);
            while (totalBytesRead < length) {
                int bytesRemaining = data.length - totalBytesRead;
                int bytesRead = ((InputStream)input).read(data, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            ((InputStream)input).close();
            if (totalBytesRead != length) {
                System.err.println("File read error: file length = " + length + ", bytes read = " + totalBytesRead);
                return null;
            }
            if (!quiet) {
                System.err.println("Bytes read from file: " + totalBytesRead);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
        return data;
    }

    public static ImageIcon createIcon(String imageName) {
        String imgLocation = "toolbarButtonGraphics/general/" + imageName + ".gif";
        URL imageURL = DynamicURLClassLoader.getInstance().getResource(imgLocation);
        if (imageURL == null) {
            imgLocation = "toolbarButtonGraphics/media/" + imageName + ".gif";
            imageURL = DynamicURLClassLoader.getInstance().getResource(imgLocation);
        }
        if (imageURL == null) {
            System.err.println("Resource not found: " + imgLocation);
            return null;
        }
        return new ImageIcon(imageURL);
    }

    private void createMenus() {
        LinkedHashMap<IO, String> ioTooltips;
        JMenu menu;
        JMenuBar menuBar;
        block32: {
            String propName;
            String temp;
            menuBar = new JMenuBar();
            this.setJMenuBar(menuBar);
            menu = new JMenu("File");
            menu.setMnemonic(70);
            menuBar.add(menu);
            JMenu newMenu = new JMenu("New");
            newMenu.setMnemonic(78);
            menu.add(newMenu);
            this.newAction = new RMAction("Remote Image...", "NEW", RMIRSetup.createIcon("RMNew24"), "Create new file", 82);
            newMenu.add(this.newAction).setIcon(null);
            this.newUpgradeAction = new RMAction("Device Upgrade", "NEWDEVICE", null, "Create new Device Upgrade", 68);
            newMenu.add(this.newUpgradeAction);
            this.newProtocolAction = new RMAction("Protocol", "NEWPROTOCOL", null, "Create new Protocol", 80);
            newMenu.add(this.newProtocolAction);
            this.openAction = new RMAction("Open...", "OPEN", RMIRSetup.createIcon("RMOpen24"), "Open a file", 79);
            menu.add(this.openAction).setIcon(null);
            this.saveAction = new RMAction("Save", "SAVE", RMIRSetup.createIcon("Save24"), "Save to file", 83);
            this.saveAction.setEnabled(false);
            menu.add(this.saveAction).setIcon(null);
            this.saveAsAction = new RMAction("Save as...", "SAVEAS", RMIRSetup.createIcon("SaveAs24"), "Save to a different file", 86);
            this.saveAsAction.setEnabled(false);
            JMenuItem menuItem = menu.add(this.saveAsAction);
            menuItem.setDisplayedMnemonicIndex(2);
            menuItem.setIcon(null);
            menu.addSeparator();
            this.installExtenderItem = new JMenuItem("Install Extender...");
            this.installExtenderItem.setMnemonic(73);
            this.installExtenderItem.addActionListener(this);
            this.installExtenderItem.setEnabled(false);
            menu.add(this.installExtenderItem);
            JMenu importFromWavSubMenu = new JMenu("Import from Wav");
            importFromWavSubMenu.setMnemonic(77);
            importFromWavSubMenu.setToolTipText("Load into RMIR a .wav file created for modem upgrade.");
            menu.add(importFromWavSubMenu);
            this.importFromWavNewItem = new JMenuItem("New Image...");
            this.importFromWavNewItem.setMnemonic(78);
            this.importFromWavNewItem.addActionListener(this);
            importFromWavSubMenu.add(this.importFromWavNewItem);
            this.importFromWavMergeItem = new JMenuItem("Merge with Current...");
            this.importFromWavMergeItem.setMnemonic(77);
            this.importFromWavMergeItem.addActionListener(this);
            this.importFromWavMergeItem.setEnabled(false);
            importFromWavSubMenu.add(this.importFromWavMergeItem);
            this.exportToWavSubMenu = new JMenu("Export to Wav");
            this.exportToWavSubMenu.setMnemonic(69);
            this.exportToWavSubMenu.setToolTipText(JTableX.getHtmlToolTip("Export the whole or part of the current setup of a modem-enabled remote<br>as a .wav file for modem upgrade.  The item &quot;Upload using Wav&quot; on the<br>Remote menu may be used to play the file for uploading to the remote."));
            this.exportToWavSubMenu.setEnabled(false);
            menu.add(this.exportToWavSubMenu);
            this.exportToWavImageItem = new JMenuItem("Entire Image...");
            this.exportToWavImageItem.setMnemonic(69);
            this.exportToWavImageItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavImageItem);
            this.exportToWavSettingsItem = new JMenuItem("Settings...");
            this.exportToWavSettingsItem.setMnemonic(83);
            this.exportToWavSettingsItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavSettingsItem);
            this.exportToWavMacrosEtcItem = new JMenuItem("KeyMoves, Macros, Fav Lists...");
            this.exportToWavMacrosEtcItem.setMnemonic(75);
            this.exportToWavMacrosEtcItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavMacrosEtcItem);
            this.exportToWavTimedMacrosItem = new JMenuItem("Timed Macros...");
            this.exportToWavTimedMacrosItem.setMnemonic(84);
            this.exportToWavTimedMacrosItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavTimedMacrosItem);
            this.exportToWavUpgradesItem = new JMenuItem("Upgrades...");
            this.exportToWavUpgradesItem.setMnemonic(85);
            this.exportToWavUpgradesItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavUpgradesItem);
            this.exportToWavLearnedItem = new JMenuItem("Learned Signals...");
            this.exportToWavLearnedItem.setMnemonic(76);
            this.exportToWavLearnedItem.addActionListener(this);
            this.exportToWavSubMenu.add(this.exportToWavLearnedItem);
            this.exportToGirrItem = new JMenuItem("Export remote as Girr file");
            this.exportToGirrItem.setMnemonic(71);
            this.exportToGirrItem.setToolTipText("Export the upgrades of the remote as a single Girr file");
            this.exportToGirrItem.addActionListener(this);
            this.exportToGirrItem.setEnabled(false);
            menu.add(this.exportToGirrItem);
            menu.addSeparator();
            JMenu menuSetDirectory = new JMenu("Set Directory");
            menuSetDirectory.setMnemonic(68);
            menu.add(menuSetDirectory);
            this.rdfPathItem = new JMenuItem("RDF Path...");
            this.rdfPathItem.setMnemonic(82);
            this.rdfPathItem.addActionListener(this);
            menuSetDirectory.add(this.rdfPathItem);
            this.mapPathItem = new JMenuItem("Image Path...");
            this.mapPathItem.setMnemonic(73);
            this.mapPathItem.addActionListener(this);
            menuSetDirectory.add(this.mapPathItem);
            this.addonPathItem = new JMenuItem("AddOns Path...");
            this.addonPathItem.setMnemonic(65);
            this.addonPathItem.addActionListener(this);
            menuSetDirectory.add(this.addonPathItem);
            menu.addSeparator();
            JMenu menuSummary = new JMenu("Summary");
            menuSummary.setMnemonic(89);
            menu.add(menuSummary);
            this.createSummaryItem = new JMenuItem("Create full summary");
            this.createSummaryItem.setMnemonic(70);
            this.createSummaryItem.addActionListener(this);
            this.createSummaryItem.setToolTipText(JTableX.getHtmlToolTip("Opens a printable summary of the current setup in the default web<br>browser, showing all RMIR tables in tabular form."));
            this.createSummaryItem.setEnabled(false);
            menuSummary.add(this.createSummaryItem);
            this.createSelectionItem = new JMenuItem("Create summary selection...");
            this.createSelectionItem.setMnemonic(83);
            this.createSelectionItem.addActionListener(this);
            this.createSelectionItem.setToolTipText(JTableX.getHtmlToolTip("Opens a printable summary of the current setup in the default web<br>browser, showing a selection of RMIR tables in tabular form."));
            this.createSelectionItem.setEnabled(false);
            menuSummary.add(this.createSelectionItem);
            this.viewSummaryItem = new JMenuItem("View last summary");
            this.viewSummaryItem.setMnemonic(86);
            this.viewSummaryItem.addActionListener(this);
            this.viewSummaryItem.setToolTipText("Opens the most recently created summary in the default web browser.");
            menuSummary.add(this.viewSummaryItem);
            this.saveSummaryItem = new JMenuItem("Save last summary...");
            this.saveSummaryItem.setMnemonic(76);
            this.saveSummaryItem.addActionListener(this);
            this.saveSummaryItem.setToolTipText(JTableX.getHtmlToolTip("Opens a dialog to save the most recently created summary as an HTML<br>file, whether or not that summary is still open in the browser."));
            menuSummary.add(this.saveSummaryItem);
            menuSummary.addSeparator();
            this.createRDFInfoFileItem = new JMenuItem("Create RDF Info File");
            this.createRDFInfoFileItem.setMnemonic(73);
            this.createRDFInfoFileItem.addActionListener(this);
            this.createRDFInfoFileItem.setToolTipText("Creates a CSV file of information from all RDFs");
            menuSummary.add(this.createRDFInfoFileItem);
            menu.addSeparator();
            this.recentFiles = new JMenu("Recent");
            menu.add(this.recentFiles);
            this.recentFiles.setEnabled(false);
            for (int i = 0; i < 10 && (temp = properties.getProperty(propName = "RecentIRs." + i)) != null; ++i) {
                properties.remove(propName);
                File f = new File(temp);
                if (!f.canRead()) continue;
                JMenuItem item = new JMenuItem(temp);
                item.setActionCommand(temp);
                item.addActionListener(this);
                this.recentFiles.add(item);
            }
            if (this.recentFiles.getItemCount() > 0) {
                this.recentFiles.setEnabled(true);
            }
            menu.addSeparator();
            this.exitItem = new JMenuItem("Exit", 88);
            this.exitItem.addActionListener(this);
            menu.add(this.exitItem);
            menu = new JMenu("Remote");
            menu.setMnemonic(82);
            menuBar.add(menu);
            ioTooltips = new LinkedHashMap<IO, String>();
            this.noPortSearchItem = new JCheckBoxMenuItem("No port search");
            this.noPortSearchItem.setSelected(Boolean.parseBoolean(properties.getProperty("noPortSearch", "false")));
            File userDir = RemoteMaster.getWorkDir();
            try {
                JP12Serial jp12Serial = new JP12Serial(userDir);
                this.interfaces.add(jp12Serial);
                JP11USB.setJP12Serial(jp12Serial);
                int option = Boolean.parseBoolean(properties.getProperty("FindAllArduino", "false")) ? 1 : 0;
                jp12Serial.setOption(option);
                ioTooltips.put(jp12Serial, JTableX.getHtmlToolTip("The interface for use with a standard USB-to-serial cable, which is one that<br>has pin 2 of the six-pin connector connected to the RTS signal.  This supports<br>JP1.2 and all later remotes.  JP1 and JP1.1 ones are supported with specific adapters.<br>It is also the interface to be used with legacy transistor-based serial port interfaces."));
                System.err.println("    JP12Serial version " + jp12Serial.getInterfaceVersion());
            }
            catch (LinkageError le) {
                System.err.println("Unable to create JP12Serial object: " + le.getMessage());
            }
            try {
                CommHID commHID = RemoteMaster.useCommHIDB ? new CommHIDB(userDir) : new CommHIDA(userDir);
                this.interfaces.add(commHID);
                ioTooltips.put(commHID, "The interface for XSight/Nevo remotes, used with a USB cable.");
                System.err.println("    CommHID version " + commHID.getInterfaceVersion());
            }
            catch (LinkageError le) {
                System.err.println("Unable to create CommHID object: " + le.getMessage());
            }
            try {
                JP2BT jp2bt = new JP2BT(userDir);
                this.interfaces.add(jp2bt);
                ioTooltips.put(jp2bt, JTableX.getHtmlToolTip("The interface for connection by Bluetooth to supporting remotes.<br>Not supported by Auto-detect, this interface must be selected explicitly."));
                System.err.println("    JP2BT version " + jp2bt.getInterfaceVersion());
            }
            catch (LinkageError le) {
                System.err.println("Unable to create JP2BT object: " + le.getMessage());
            }
            try {
                JP1USB jp1usb = new JP1USB(userDir);
                this.interfaces.add(jp1usb);
                ioTooltips.put(jp1usb, JTableX.getHtmlToolTip("The interface for connecting to JP1 remotes through a legacy<br>USB-to-serial interface cable with a Delcom chip."));
                System.err.println("    JP1USB version " + jp1usb.getInterfaceVersion());
            }
            catch (LinkageError le) {
                System.err.println("Unable to create JP1USB object: " + le.getMessage());
            }
            if (JP11USB.jp12serial != null) {
                try {
                    JP11USB jp11usb = new JP11USB(userDir);
                    this.interfaces.add(jp11usb);
                    ioTooltips.put(jp11usb, JTableX.getHtmlToolTip("This interface is for use with USB-to-serial cables that have pin 2 connected<br>to the DTR signal.  Like a standard cable that has pin 2 connected to RTS, this<br>supports JP1.2 and all later remotes.  If it also has pin 5 connected to RTS<br>then it supports JP1.1 as well as JP1.2 and later remotes.<br><br>As these are specialized cables, this interface is not supported by Auto-detect,<br>it must be selected explicitly."));
                    System.err.println("    JP11USB version " + jp11usb.getInterfaceVersion());
                }
                catch (LinkageError le) {
                    System.err.println("Unable to create JP11USB object: " + le.getMessage());
                }
            }
            try {
                JPS jps = new JPS(userDir);
                this.interfaces.add(jps);
                ioTooltips.put(jps, JTableX.getHtmlToolTip("The interface for connecting to SimpleSet remotes, used with a USB cable.<br>Can also be used to edit an existing simpleset.bin file by selecting the<br>\"Other\" option and entering the full path to that file, including the filename."));
                System.err.println("    JPS version " + jps.getInterfaceVersion());
            }
            catch (LinkageError le) {
                System.err.println("Unable to create JPS object: " + le.getMessage());
            }
            try {
                JP1Parallel jp1Parallel = new JP1Parallel(userDir);
                ioTooltips.put(jp1Parallel, JTableX.getHtmlToolTip("The interface for connecting to JP1 remotes through a legacy<br>parallel port."));
                this.interfaces.add(jp1Parallel);
                System.err.println("    JP1Parallel version " + jp1Parallel.getInterfaceVersion());
                if (!System.getProperty("os.name").startsWith("Windows")) break block32;
                double parallelVer = 0.0;
                try {
                    parallelVer = Double.parseDouble(jp1Parallel.getInterfaceVersion());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (parallelVer > 0.1) {
                    boolean isInpOutDriverOpen = jp1Parallel.testIsInpOutDriverOpen();
                    System.err.println("    JP1Parallel InpOutDriver is " + (isInpOutDriverOpen ? "open" : "not open"));
                    if (!isInpOutDriverOpen) {
                        System.err.println("    *** To use the parallel port interface, RMIR must be run once as adminstrator.\n    This enables it to install the InpOut driver, a once-only task needed for\n    the interface to access the port.");
                    }
                }
            }
            catch (LinkageError le) {
                System.err.println("Unable to create JP1Parallel object: " + le.getMessage());
            }
        }
        ActionListener interfaceListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                if (command.equals("autodetect")) {
                    JP1Frame.properties.remove("Interface");
                    JP1Frame.properties.remove("Port");
                    RMIRSetup.this.bluetoothItem.setVisible(false);
                    RMIRSetup.this.finderItem.setVisible(false);
                    RMIRSetup.this.uploadAction.setEnabled(RMIRSetup.this.uploadable);
                    RMIRSetup.this.recreateToolbar();
                    return;
                }
                for (IO io : RMIRSetup.this.interfaces) {
                    String[] availablePorts;
                    String title;
                    String message;
                    if (!io.getInterfaceName().equals(command)) continue;
                    if (command.equals("JP11USB") && NegativeDefaultButtonJOptionPane.showConfirmDialog(RMIRSetup.this, message = "The JP11USB interface supports USB-to-serial cables whose 6-pin connector has the\nfollowing pin assignments:  pin 1 not connected, pin 2 = DTR, pin 3 = GND, pin 4 = TXD,\npin 5 either RTS or not connected, pin 6 = RXD.  If pin 5 = RTS then this supports JP1.1\nand all later remotes.  If pin 5 is not connected then it does not support JP1.1 but\nstill supports JP1.2 and all later remotes.\n\nJP1.1 remotes are also supported by suitable transistor-based interfaces, but for these\nyou should select JP1.X Serial, not JP11USB. If you have a USB-to-serial cable for which\nonly one of RTS and DTR is available, you may use this with JP1.1 remotes by connecting\nboth pins 3 and 5 to GND.  Then if pin 2 = RTS select JP1.X Serial, if pin 2 = DTR then\nuse JP11USB (this interface).\n\nDo you wish to continue?", title = "JP11USB Interface", 0, 1) != 0) {
                        String ioName = JP1Frame.properties.getProperty("Interface");
                        if (ioName == null) {
                            ioName = "autodetect";
                        }
                        ((JRadioButtonMenuItem)RMIRSetup.this.ioButtonMap.get(ioName)).setSelected(true);
                        return;
                    }
                    String defaultPort = null;
                    if (command.equals(JP1Frame.properties.getProperty("Interface"))) {
                        defaultPort = JP1Frame.properties.getProperty("Port");
                    }
                    boolean noSearch = RMIRSetup.this.noPortSearchItem.isSelected();
                    boolean localInterface = Arrays.asList("CommHID", "JPS", "JP2BT").contains(command);
                    String[] stringArray = availablePorts = noSearch && !localInterface ? new String[]{} : io.getPortNames();
                    if (command.equals("JP2BT") && defaultPort == null) {
                        defaultPort = availablePorts[0];
                    }
                    PortDialog d = new PortDialog(RMIRSetup.this, availablePorts, defaultPort);
                    if (command.equals("JPS") && defaultPort == null && ((JPS)io).isOpen()) {
                        d.setOtherPort(((JPS)io).getFilePath());
                    }
                    d.getAutodetect().setVisible(localInterface || !noSearch && !command.equals("JP2BT"));
                    d.setVisible(true);
                    if (d.getUserAction() == 0) {
                        String port = d.getPort();
                        JP1Frame.properties.setProperty("Interface", io.getInterfaceName());
                        if (port == null || port.equals("Auto-detect")) {
                            JP1Frame.properties.remove("Port");
                        } else {
                            JP1Frame.properties.setProperty("Port", port);
                        }
                        RMIRSetup.this.uploadAction.setEnabled(RMIRSetup.this.uploadable && RMIRSetup.this.allowUpload());
                        RMIRSetup.this.recreateToolbar();
                        break;
                    }
                    String ioName = JP1Frame.properties.getProperty("Interface");
                    if (ioName == null) {
                        ioName = "autodetect";
                    }
                    ((JRadioButtonMenuItem)RMIRSetup.this.ioButtonMap.get(ioName)).setSelected(true);
                    break;
                }
            }
        };
        if (!this.interfaces.isEmpty()) {
            this.ioButtonMap = new LinkedHashMap();
            JMenu subMenu = new JMenu("Interface");
            subMenu.setToolTipText("Select auto-detect or a specific interface type.");
            menu.add(subMenu);
            subMenu.setMnemonic(73);
            ButtonGroup group = new ButtonGroup();
            String preferredInterface = properties.getProperty("Interface");
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("Auto-detect");
            item.setToolTipText("Searches through all interface types other than JP2BT and JP11USB.");
            item.setActionCommand("autodetect");
            item.setSelected(preferredInterface == null);
            item.setVisible(!this.noPortSearchItem.isSelected());
            this.ioButtonMap.put("autodetect", item);
            subMenu.add(item);
            group.add(item);
            item.setMnemonic(65);
            item.addActionListener(interfaceListener);
            ListIterator<IO> it = this.interfaces.listIterator();
            while (it.hasNext()) {
                IO io = it.next();
                try {
                    String ioName = io.getInterfaceName();
                    String tooltip = (String)ioTooltips.get(io);
                    item = new JRadioButtonMenuItem(ioName + "...");
                    if (tooltip != null) {
                        item.setToolTipText(tooltip);
                    }
                    item.setActionCommand(ioName);
                    item.setSelected(ioName.equals(preferredInterface));
                    this.ioButtonMap.put(ioName, item);
                    subMenu.add(item);
                    group.add(item);
                    item.addActionListener(interfaceListener);
                }
                catch (UnsatisfiedLinkError ule) {
                    it.remove();
                    String className = io.getClass().getName();
                    int dot = className.lastIndexOf(46);
                    if (dot != -1) {
                        className = className.substring(dot + 1);
                    }
                    JOptionPane.showMessageDialog(this, "An incompatible version of the " + className + " driver was detected.  You will not be able to download or upload using that driver.", "Incompatible Driver", 0);
                    ule.printStackTrace(System.err);
                }
            }
        }
        this.bluetoothAction = new RMAction("Connect by Bluetooth", "BLUETOOTH", RMIRSetup.createIcon("RMBTOn24"), "Connect to the remote by Bluetooth", 66);
        this.bluetoothAction.putValue("SwingSelectedKey", true);
        this.bluetoothItem = new JCheckBoxMenuItem();
        this.bluetoothItem.setAction(this.bluetoothAction);
        this.bluetoothItem.setIcon(null);
        this.bluetoothItem.setSelected(false);
        menu.add(this.bluetoothItem);
        this.bluetoothButton = new JToggleButton();
        this.bluetoothButton.setAction(this.bluetoothAction);
        this.bluetoothButton.setHideActionText(true);
        this.bluetoothButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.finderAction = new RMAction("Find remote", "FINDER", RMIRSetup.createIcon("Volume24"), "Sound the remote's finder", 70);
        this.finderAction.putValue("SwingSelectedKey", true);
        this.finderItem = new JCheckBoxMenuItem();
        this.finderItem.setAction(this.finderAction);
        this.finderItem.setIcon(null);
        this.finderItem.setSelected(false);
        menu.add(this.finderItem);
        this.finderButton = new JToggleButton();
        this.finderButton.setAction(this.finderAction);
        this.finderButton.setHideActionText(true);
        this.finderButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.downloadAction = new RMAction("Download from Remote", "DOWNLOAD", RMIRSetup.createIcon("Import24"), "Download from the attached remote", 68);
        this.downloadAction.setEnabled(!this.interfaces.isEmpty());
        menu.add(this.downloadAction).setIcon(null);
        this.uploadAction = new RMAction("Upload to Remote", "UPLOAD", RMIRSetup.createIcon("Export24"), "Upload to the attached remote", 85);
        this.uploadable = false;
        this.uploadAction.setEnabled(false);
        menu.add(this.uploadAction).setIcon(null);
        this.rfAction = new RMAction("Open RF Tools", "RFTOOLS", RMIRSetup.createIcon("RMRF24"), "Open RF Tools", 82);
        this.rfAction.putValue("SwingSelectedKey", true);
        menu.add(this.rfAction).setIcon(null);
        this.registerRfRemoteItem = new JMenuItem("Register as RF Remote", 82);
        this.registerRfRemoteItem.setEnabled(false);
        this.registerRfRemoteItem.addActionListener(this);
        this.registerRfRemoteItem.setToolTipText("Register current remote as a RF Remote for use with RF Tools");
        menu.add(this.registerRfRemoteItem);
        this.openRdfAction = new RMAction("Open RDF...", "OPENRDF", RMIRSetup.createIcon("RMOpenRDF24"), "Open RDF to view or edit", null);
        this.openRdfAction.setEnabled(false);
        this.codesAction = new RMAction("Code Selector...", "OPENCODES", RMIRSetup.createIcon("RMCodes24"), "Open Code Selector", null);
        this.codesAction.setEnabled(false);
        this.highlightAction = new RMAction("Highlight...", "HIGHLIGHT", RMIRSetup.createIcon("RMHighlight24"), "Select highlight color", null);
        this.highlightAction.setEnabled(false);
        menu.addSeparator();
        this.downloadRawItem = new JMenuItem("Raw download", 82);
        this.downloadRawItem.setEnabled(!this.interfaces.isEmpty());
        this.downloadRawItem.addActionListener(this);
        menu.add(this.downloadRawItem);
        this.uploadWavItem = new JMenuItem("Upload using Wav...", 87);
        this.uploadWavItem.setToolTipText(JTableX.getHtmlToolTip("Play a .wav file for uploading to a remote with modem upgrade<br>capability.  See the Wiki on the JP1 website for guidance.  You<br>can use the item &quot;Export to Wav&quot; on the File menu to<br>create a .wav file from an existing setup for such a remote."));
        this.uploadWavItem.addActionListener(this);
        menu.add(this.uploadWavItem);
        this.cancelWavUploadItem = new JMenuItem("Cancel Wav Upload", 67);
        this.cancelWavUploadItem.setToolTipText("Cancel the playback of a .wav file during a modem upgrade.");
        this.cancelWavUploadItem.addActionListener(this);
        this.cancelWavUploadItem.setEnabled(false);
        menu.add(this.cancelWavUploadItem);
        menu.addSeparator();
        this.verifyUploadItem = new JCheckBoxMenuItem("Verify after upload");
        this.verifyUploadItem.setMnemonic(86);
        this.verifyUploadItem.setSelected(Boolean.parseBoolean(properties.getProperty("verifyUpload", "true")));
        this.verifyUploadItem.addActionListener(this);
        menu.add(this.verifyUploadItem);
        this.noPortSearchItem.setToolTipText("When selected, interface type and external port must be specified explicitly.");
        this.noPortSearchItem.setMnemonic(78);
        this.noPortSearchItem.addActionListener(this);
        menu.add(this.noPortSearchItem);
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuBar.add(menu);
        JMenu subMenu = new JMenu("Look and Feel");
        subMenu.setMnemonic(76);
        menu.add(subMenu);
        KeyMapMaster.createFunctionNamesMenus(menu);
        boolean useDecodeIR = LearnedSignal.hasDecodeIR() && Boolean.parseBoolean(RMIRSetup.getProperties().getProperty("UseDecodeIR", "false"));
        System.err.println("Using " + (useDecodeIR ? "DecodeIR" : "IrpTransmogrifier") + " as decoder of learned signals");
        JMenu irSubMenu = new JMenu("Set IR Decoder");
        ButtonGroup group = new ButtonGroup();
        this.irpTransmogrifierItem = new JRadioButtonMenuItem("IrpTransmogrifier");
        this.irpTransmogrifierItem.addActionListener(this);
        this.irpTransmogrifierItem.setSelected(!useDecodeIR);
        this.irpTransmogrifierItem.setMnemonic(73);
        group.add(this.irpTransmogrifierItem);
        irSubMenu.add(this.irpTransmogrifierItem);
        this.decodeIRItem = new JRadioButtonMenuItem("DecodeIR");
        this.decodeIRItem.addActionListener(this);
        this.decodeIRItem.setEnabled(LearnedSignal.hasDecodeIR());
        this.decodeIRItem.setSelected(useDecodeIR);
        this.decodeIRItem.setMnemonic(68);
        group.add(this.decodeIRItem);
        irSubMenu.add(this.decodeIRItem);
        menu.add(irSubMenu);
        this.highlightItem = new JCheckBoxMenuItem("Highlighting");
        this.highlightItem.setMnemonic(72);
        this.highlightItem.setSelected(Boolean.parseBoolean(properties.getProperty("highlighting", "false")));
        this.highlightItem.addActionListener(this);
        menu.add(this.highlightItem);
        this.enablePreserveSelection = new JCheckBoxMenuItem("Allow Preserve Control");
        this.enablePreserveSelection.setMnemonic(65);
        this.enablePreserveSelection.setSelected(Boolean.parseBoolean(properties.getProperty("enablePreserveSelection", "false")));
        this.enablePreserveSelection.addActionListener(this);
        this.enablePreserveSelection.setToolTipText(JTableX.getHtmlToolTip("Allow control of which function data is preserved when changing the protocol used in a device upgrade.<br>Do not use this unless you know what you are doing and why."));
        menu.add(this.enablePreserveSelection);
        this.showSlingboxProtocols = new JCheckBoxMenuItem("Show Slingbox protocols");
        this.showSlingboxProtocols.setMnemonic(88);
        this.showSlingboxProtocols.setSelected(Boolean.parseBoolean(properties.getProperty("ShowSlingboxProtocols", "false")));
        this.showSlingboxProtocols.addActionListener(this);
        this.showSlingboxProtocols.setToolTipText(JTableX.getHtmlToolTip("Include the no-repeat protocols that are specific to Slingbox usage.<br>Note that a change to this option only takes effect when RM or RMIR<br>is next opened."));
        menu.add(this.showSlingboxProtocols);
        JMenu tooltipSubMenu = new JMenu("Set Tooltip Delay");
        tooltipSubMenu.setMnemonic(84);
        tooltipSubMenu.setToolTipText(JTableX.getHtmlToolTip("Set the delay between mouse pointer entering an object and the tooltip (help message)<br>appearing.  This delay does not apply to cells in tables, where tooltips are primarily used<br>to show the full content when it does not fit into the cell concerned."));
        menu.add(tooltipSubMenu);
        ToolTipManager tm = ToolTipManager.sharedInstance();
        this.tooltipDefaultDelay = tm.getInitialDelay();
        String temp = properties.getProperty("TooltipDelay");
        this.tooltipDelay = temp != null ? Integer.parseInt(temp) : this.tooltipDefaultDelay;
        tm.setInitialDelay(this.tooltipDelay);
        group = new ButtonGroup();
        this.defaultDelayItem = new JRadioButtonMenuItem("Default delay");
        this.defaultDelayItem.setSelected(temp == null);
        this.defaultDelayItem.addActionListener(this);
        tooltipSubMenu.add(this.defaultDelayItem);
        group.add(this.defaultDelayItem);
        this.specifiedDelayItem = new JRadioButtonMenuItem("Specified delay...");
        this.specifiedDelayItem.setSelected(temp != null);
        this.specifiedDelayItem.addActionListener(this);
        tooltipSubMenu.add(this.specifiedDelayItem);
        group.add(this.specifiedDelayItem);
        this.progressBarColors = new JMenuItem("Set Progress Bar Colors...");
        this.progressBarColors.addActionListener(this);
        this.pbSelDefault = new JRadioButton("Default");
        this.pbSelBlue = new JRadioButton("Blue");
        this.pbSelBlack = new JRadioButton("Black");
        this.pbSelWhite = new JRadioButton("White");
        this.pbUnselDefault = new JRadioButton("Default");
        this.pbUnselBlue = new JRadioButton("Blue");
        this.pbUnselBlack = new JRadioButton("Black");
        this.pbForeDefault = new JRadioButton("Default");
        this.pbForeAquamarine = new JRadioButton("Aquamarine");
        this.pbForeBlack = new JRadioButton("Black");
        this.pbForeBlue = new JRadioButton("Blue");
        this.pbForeRed = new JRadioButton("Red");
        this.pbForeOrange = new JRadioButton("Orange");
        this.pbForeGreen = new JRadioButton("Green");
        this.pbSelDefault.setSelected(true);
        this.pbUnselDefault.setSelected(true);
        this.pbForeDefault.setSelected(true);
        group = new ButtonGroup();
        group.add(this.pbSelDefault);
        group.add(this.pbSelBlue);
        group.add(this.pbSelBlack);
        group.add(this.pbSelWhite);
        group = new ButtonGroup();
        group.add(this.pbUnselDefault);
        group.add(this.pbUnselBlue);
        group.add(this.pbUnselBlack);
        group = new ButtonGroup();
        group.add(this.pbForeDefault);
        group.add(this.pbForeAquamarine);
        group.add(this.pbForeBlack);
        group.add(this.pbForeBlue);
        group.add(this.pbForeRed);
        group.add(this.pbForeOrange);
        group.add(this.pbForeGreen);
        menu.add(this.progressBarColors);
        noUpgradeItem = new JCheckBoxMenuItem("No XSight Firmware Upgrade");
        noUpgradeItem.setSelected(Boolean.parseBoolean(properties.getProperty("NoUpgrade", "false")));
        noUpgradeItem.addActionListener(this);
        noUpgradeItem.setToolTipText(JTableX.getHtmlToolTip("Selecting this option will stop download of an XSight<br>Touch-style or Nevo remote offering to upgrade the remote,<br>even if an upgrade is available."));
        menu.add(noUpgradeItem);
        this.appendAdvancedOptions(menu);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RMIRSetup.this.lfEvent = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String title = "Look and Feel";
                            String message = "Due to a bug in Java, you may find it necessary to close and then re-open RMIR\nfor it to work properly after a change of Look and Feel.  Moreover, you may need\nto use the menu item File > Exit to close it.  To abort the change press Cancel,\notherwise press OK to continue.";
                            if (JOptionPane.showConfirmDialog(RMIRSetup.this, message, title, 2, 1) == 2) {
                                String lf = UIManager.getLookAndFeel().getName();
                                for (JRadioButtonMenuItem item : RMIRSetup.this.lookAndFeelItems) {
                                    if (!item.getText().equals(lf)) continue;
                                    item.setSelected(true);
                                    break;
                                }
                                return;
                            }
                            JRadioButtonMenuItem item = (JRadioButtonMenuItem)RMIRSetup.this.lfEvent.getSource();
                            String lf = item.getActionCommand();
                            UIManager.setLookAndFeel(lf);
                            JP1TableModel.normalBGColor = UIManager.getColor("Table.background");
                            JP1TableModel.normalFGColor = UIManager.getColor("Table.foreground");
                            RemoteMaster.defaultPBForegroundColor = UIManager.getColor("ProgressBar.foreground");
                            SwingUtilities.updateComponentTreeUI(RMIRSetup.this);
                            JP1Frame.properties.setProperty("LookAndFeel", lf);
                        }
                        catch (Exception x) {
                            x.printStackTrace(System.err);
                        }
                    }
                });
            }
        };
        group = new ButtonGroup();
        String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelItems = new JRadioButtonMenuItem[info.length];
        for (int i = 0; i < info.length; ++i) {
            JRadioButtonMenuItem[] item = new JRadioButtonMenuItem(info[i].getName());
            this.lookAndFeelItems[i] = item;
            item.setMnemonic(item.getText().charAt(0));
            item.setActionCommand(info[i].getClassName());
            group.add((AbstractButton)item);
            subMenu.add((JMenuItem)item);
            if (item.getActionCommand().equals(lookAndFeel)) {
                item.setSelected(true);
            }
            item.addActionListener(al);
        }
        menu = new JMenu("Advanced");
        menu.setMnemonic(65);
        menuBar.add(menu);
        this.cleanUpperMemoryItem = new JMenuItem("Blast Upper Memory...", 66);
        this.cleanUpperMemoryItem.setEnabled(false);
        this.cleanUpperMemoryItem.addActionListener(this);
        menu.add(this.cleanUpperMemoryItem);
        this.clearAltPIDHistory = new JMenuItem("Clear Alt PID History...", 72);
        this.clearAltPIDHistory.addActionListener(this);
        menu.add(this.clearAltPIDHistory);
        menu.addSeparator();
        this.initializeTo00Item = new JMenuItem("Initialize to $00", 48);
        this.initializeTo00Item.setEnabled(false);
        this.initializeTo00Item.addActionListener(this);
        menu.add(this.initializeTo00Item);
        this.initializeToFFItem = new JMenuItem("Initialize to $FF", 70);
        this.initializeToFFItem.setEnabled(false);
        this.initializeToFFItem.addActionListener(this);
        menu.add(this.initializeToFFItem);
        menu.addSeparator();
        this.useSavedDataItem = new JCheckBoxMenuItem("Preserve original data");
        this.useSavedDataItem.setMnemonic(80);
        this.useSavedDataItem.setSelected(false);
        this.useSavedDataItem.addActionListener(this);
        this.useSavedDataItem.setToolTipText(JTableX.getHtmlToolTip("When selected, the Raw Data tab displays the data as downloaded from the remote<br>or loaded from a file, free from any changes made to it by RMIR.  An upload to the<br>remote also uploads this unmodified data."));
        menu.add(this.useSavedDataItem);
        this.setBaselineItem = new JMenuItem("Set baseline", 83);
        this.setBaselineItem.addActionListener(this);
        this.setBaselineItem.setEnabled(false);
        this.setBaselineItem.setToolTipText(JTableX.getHtmlToolTip("Sets baseline to either normal or original data, depending on whether or not<br>\"Preserve original data\" is selected.  When a baseline is set, the Raw Data tab<br>highlights differences between current and baseline data in RED."));
        menu.add(this.setBaselineItem);
        this.clearBaselineItem = new JMenuItem("Clear baseline", 67);
        this.clearBaselineItem.addActionListener(this);
        this.clearBaselineItem.setEnabled(false);
        this.clearBaselineItem.setToolTipText("Clears the baseline so that the Raw Data tab no longer highlights differences from it");
        menu.add(this.clearBaselineItem);
        menu.addSeparator();
        disableActivitiesItem = new JCheckBoxMenuItem("Disable Activities");
        disableActivitiesItem.setToolTipText(JTableX.getHtmlToolTip("Disables Activities for this remote, making the Activity buttons be normal<br>buttons that can hold key moves and macros.  The selection state of this<br>item need only be changed when it is required to re-enable or re-disable<br>Activities, as it is set on download or on file load to that used in the<br>setup concerned."));
        disableActivitiesItem.addActionListener(this);
        disableActivitiesItem.setVisible(false);
        disableActivitiesItem.setSelected(false);
        menu.add(disableActivitiesItem);
        disableUploadRestrictionsItem = new JCheckBoxMenuItem("Disable Upload Restrictions...");
        disableUploadRestrictionsItem.setMnemonic(68);
        disableUploadRestrictionsItem.setToolTipText(JTableX.getHtmlToolTip("Allows creation and upload of macros and special functions that violate<br>constraints built in to RMIR.  It is intended only for testing constructions<br>that it is suspected RMIR excludes in error.  Select this option to display<br>more details.  You can then cancel or continue as you wish."));
        disableUploadRestrictionsItem.addActionListener(this);
        disableUploadRestrictionsItem.setSelected(false);
        menu.add(disableUploadRestrictionsItem);
        overrideSetupValidation = new JMenu("Override Setup Validation");
        overrideSetupValidation.setMnemonic(79);
        overrideSetupValidation.setToolTipText(JTableX.getHtmlToolTip("This overrides the SetupValidation entry in the RDF for all remotes.<br/>There are four choices, Default, Off, Warn and Enforce.  Default turns<br/>the override off, returning the setting to that of the RDF.  The other<br/>three values are the possible values in the RDF but will apply to all<br/>remotes regardless of the RDF entry."));
        menu.add(overrideSetupValidation);
        group = new ButtonGroup();
        String valText = properties.getProperty("Validation", "Default");
        for (JRadioButtonMenuItem item : validations) {
            group.add(item);
            item.addActionListener(this);
            overrideSetupValidation.add(item);
            if (!item.getText().equals(valText)) continue;
            item.setSelected(true);
            int index = -1;
            index = Arrays.asList("Default", "Off", "Warn", "Enforce").indexOf(valText);
            if (index < 0) continue;
            this.validationOverride = index == 0 ? null : Remote.SetupValidation.values()[index - 1];
        }
        xziteRegItem = new JMenuItem("Show XSight registry key", 82);
        xziteRegItem.setToolTipText(JTableX.getHtmlToolTip("Displays the path to the registry key for Enhanced Power<br>Management for the last connected XSight remote, with<br>instructions on how to disable or enable this setting."));
        xziteRegItem.addActionListener(this);
        xziteRegItem.setVisible(false);
        menu.add(xziteRegItem);
        this.xziteReenableAction = new RMAction("Re-enable Enhanced Power Management", "REENABLE", null, "<html>Re-enable Enhanced Power Management for a remote.  This action is only enabled after a<br>download from the XSight/Nevo remote concerned and once re-enabled, RMIR will not work<br>with that remote until Enhanced Power Management is disabled again.</html>", 69);
        this.xziteReenableAction.setEnabled(false);
        String libFolder = LibraryLoader.getLibraryFolderName();
        this.xziteHidapiAction = new RMAction("hidapi", "SETHIDAPI", null, null, 65);
        this.xziteHidapiAction.putValue("SwingSelectedKey", !RemoteMaster.useCommHIDB);
        this.xziteHidapiAction.setEnabled(!libFolder.equals("Linux-arm"));
        this.xziteHid4JavaAction = new RMAction("hid4java", "SETHID4JAVA", null, null, 74);
        this.xziteHid4JavaAction.putValue("SwingSelectedKey", RemoteMaster.useCommHIDB);
        this.xziteHid4JavaAction.setEnabled(!libFolder.equals("Mac OS X-i386"));
        xziteOps = new JMenu("XSight operations");
        xziteOps.setMnemonic(88);
        menu.add(xziteOps);
        xziteOps.setVisible(false);
        xziteOpsItem = new JMenuItem("List/Remove/Save XSight files...", 76);
        xziteOpsItem.setToolTipText(JTableX.getHtmlToolTip("Lists all files in the XSight file system and gives<br>option to remove or save to PC selected items one<br>at a time."));
        xziteOpsItem.addActionListener(this);
        xziteOpsItem.setVisible(RemoteMaster.admin);
        xziteOps.add(xziteOpsItem);
        verifyXZITEfilesItem = new JMenuItem("Verify XSight system files", 86);
        verifyXZITEfilesItem.setToolTipText(JTableX.getHtmlToolTip("Validates the content of all XSight system files<br>and returns a description of any discrepancies"));
        verifyXZITEfilesItem.addActionListener(this);
        xziteOps.add(verifyXZITEfilesItem);
        putSystemFileItem = new JMenuItem("Upload XSight system file...", 85);
        putSystemFileItem.setToolTipText(JTableX.getHtmlToolTip("Uploads system files to the remote one at a time, selected from<br>the files of the latest available firmware version.  Note that<br>this option is only available if the MCU firmware is already<br>the latest version.  This option is intended to provide a means<br>to restore accidentally corrupted or deleted files."));
        putSystemFileItem.addActionListener(this);
        xziteOps.add(putSystemFileItem);
        xziteReformatItem = new JMenuItem("Format and rebuild XSight file system...", 82);
        xziteReformatItem.setToolTipText(JTableX.getHtmlToolTip("Formats the file system of the remote and restores the system files.<br>The MCU firmware is not affected.  The remote is left in a factory<br>reset state."));
        xziteReformatItem.addActionListener(this);
        xziteOps.add(xziteReformatItem);
        xziteOps.addSeparator();
        xziteOps.add(new JMenuItem(this.xziteReenableAction));
        showXziteFileDataItem = new RMCheckBoxMenuItem("Show XSight user file data", "ShowXSightFiles", false);
        showXziteFileDataItem.addActionListener(this);
        xziteOps.add(showXziteFileDataItem);
        forceUpgradeItem = new JCheckBoxMenuItem("Force XSight Firmware Upgrade");
        forceUpgradeItem.setMnemonic(70);
        forceUpgradeItem.setSelected(false);
        forceUpgradeItem.setToolTipText(JTableX.getHtmlToolTip("Selecting this option will force download of an XSight<br>Touch-style or Nevo remote to offer to upgrade the remote,<br>even if the current firmware is up-to-date."));
        xziteOps.add(forceUpgradeItem);
        getSystemFilesItem = new JCheckBoxMenuItem("Get XSight system files");
        getSystemFilesItem.setMnemonic(71);
        getSystemFilesItem.setToolTipText(JTableX.getHtmlToolTip("When checked, a download from the remote also copies<br>the system files of the remote to a zip file in the XSight<br>subfolder of the installation folder, creating this subfolder<br>if it does not exist.  The name of the zip file is Sys followed<br>by the USB PID of the remote."));
        getSystemFilesItem.setSelected(false);
        getSystemFilesItem.setVisible(RemoteMaster.admin);
        getSystemFilesItem.addActionListener(this);
        xziteOps.add(getSystemFilesItem);
        parseIRDBItem = new JMenuItem("Extract from irdb.bin", 69);
        parseIRDBItem.setToolTipText(JTableX.getHtmlToolTip("Extracts data for an RDF from the copy of the irdb.bin<br>system file in the zip file for this remote created by<br>the \"Get XSight system files\" option."));
        parseIRDBItem.addActionListener(this);
        parseIRDBItem.setVisible(RemoteMaster.admin);
        xziteOps.add(parseIRDBItem);
        JMenu hidSubMenu = new JMenu("Select HID interface");
        hidSubMenu.setMnemonic(72);
        group = new ButtonGroup();
        JRadioButtonMenuItem hidapiItem = new JRadioButtonMenuItem(this.xziteHidapiAction);
        group.add(hidapiItem);
        hidSubMenu.add(hidapiItem);
        JRadioButtonMenuItem hid4javaItem = new JRadioButtonMenuItem(this.xziteHid4JavaAction);
        group.add(hid4javaItem);
        hidSubMenu.add(hid4javaItem);
        xziteOps.add(hidSubMenu);
        digitalOps = new JMenu("XSight operations");
        digitalOps.setMnemonic(88);
        menu.add(digitalOps);
        digitalOps.setVisible(false);
        digitalOps.add(new JMenuItem(this.xziteReenableAction));
        forceFDRAUpgradeItem = new JCheckBoxMenuItem("Force XSight Firmware Upgrade");
        forceFDRAUpgradeItem.setMnemonic(70);
        forceFDRAUpgradeItem.setSelected(false);
        forceFDRAUpgradeItem.setToolTipText(JTableX.getHtmlToolTip("Selecting this option will force download of any XSight<br>or Nevo remote to offer to upgrade the remote, even if<br>the current firmware is up-to-date."));
        digitalOps.add(forceFDRAUpgradeItem);
        saveFDRAfirmware = new JMenuItem("Save FDRA firmware", 83);
        saveFDRAfirmware.setToolTipText(JTableX.getHtmlToolTip("Saves the firmware of XSight FDRA remote to a file in the XSight<br>subfolder of the installation folder, creating this subfolder<br>if it does not exist. The file name is Sys followed by the USB<br>PID of the remote, an underscore then the firmware version as<br>a 6-digit integer.  Further digits after a decimal point give<br>the version of the additional language support."));
        saveFDRAfirmware.addActionListener(this);
        saveFDRAfirmware.setVisible(RemoteMaster.admin);
        digitalOps.add(saveFDRAfirmware);
        upgradeSourceItem = new JMenuItem("Set upgrade source file...", 85);
        upgradeSourceItem.setToolTipText(RemoteMaster.admin ? JTableX.getHtmlToolTip("Sets the source for XSight firmware upgrades for the<br>current remote, giving a choice between the system-supplied<br>upgrades and restoring firmware previously saved with the<br>\"Save FDRA firmware\" option.  Includes the ability to<br>install optional additional language support.") : JTableX.getHtmlToolTip("Sets the source for XSight firmware upgrades for the<br>current remote, giving in particular the ability to<br>install optional additional language support."));
        upgradeSourceItem.addActionListener(this);
        upgradeSourceItem.setVisible(RemoteMaster.admin);
        digitalOps.add(upgradeSourceItem);
        hidSubMenu = new JMenu("Select HID interface");
        hidSubMenu.setMnemonic(72);
        group = new ButtonGroup();
        hidapiItem = new JRadioButtonMenuItem(this.xziteHidapiAction);
        group.add(hidapiItem);
        hidSubMenu.add(hidapiItem);
        hid4javaItem = new JRadioButtonMenuItem(this.xziteHid4JavaAction);
        group.add(hid4javaItem);
        hidSubMenu.add(hid4javaItem);
        digitalOps.add(hidSubMenu);
        extractSSItem = new JMenuItem("Extract from simpleset binary", 69);
        extractSSItem.setToolTipText(JTableX.getHtmlToolTip("Extracts data for an RDF from the currently loaded<br>simpleset .bin file."));
        extractSSItem.setVisible(false);
        extractSSItem.addActionListener(this);
        menu.add(extractSSItem);
        analyzeMAXQprotocols = new JMenuItem("Analyze MAXQ protocols", 65);
        analyzeMAXQprotocols.setVisible(RemoteMaster.admin);
        analyzeMAXQprotocols.addActionListener(this);
        menu.add(analyzeMAXQprotocols);
        importIctAsLearned = new JMenuItem("Import Ict as Learned", 76);
        importIctAsLearned.setToolTipText(JTableX.getHtmlToolTip("Imports an IRScope .ict file as Learned Signals into a special model remote named \"Learned Signal<br/>Importer\" to enable Timing Analysis to be performed on those signals.  This is primarily intended for<br/>signals that fail to decode, to assist in the identification of previously unknown protocols."));
        importIctAsLearned.addActionListener(this);
        menu.add(importIctAsLearned);
        if (RMIRSetup.desktopUsable()) {
            menu.addSeparator();
            openRmasterErr = new JMenuItem("Display the errors file rmaster.err", 69);
            openRmasterErr.setToolTipText(JTableX.getHtmlToolTip("Opens a popup window showing the current content of the error file, in general <code>rmaster.err</code>.<br><b>Note:</b> will not update!"));
            openRmasterErr.addActionListener(this);
            menu.add(openRmasterErr);
        }
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        if (RMIRSetup.desktopUsable()) {
            this.readmeItem = new JMenuItem("Readme", 82);
            this.readmeItem.addActionListener(this);
            menu.add(this.readmeItem);
            this.tutorialItem = new JMenuItem("Tutorial", 84);
            this.tutorialItem.addActionListener(this);
            menu.add(this.tutorialItem);
            this.rmpbReadmeItem = new JMenuItem("Using RMPB", 85);
            this.rmpbReadmeItem.addActionListener(this);
            menu.add(this.rmpbReadmeItem);
            this.irpProtocolsItem = new JMenuItem("IrpTransmogrifier Protocols", 80);
            this.irpProtocolsItem.setToolTipText(JTableX.getHtmlToolTip("Documentation of protocols identified when IrpTransmogrifier<br/>is set in the Options menu as IR Decoder."));
            this.irpProtocolsItem.addActionListener(this);
            menu.add(this.irpProtocolsItem);
            this.learnedSignalItem = new JMenuItem("Interpreting Decoded IR Signals", 73);
            this.learnedSignalItem.setToolTipText(JTableX.getHtmlToolTip("Documentation of protocols identified when DecodeIR<br/>is set in the Options menu as IR Decoder."));
            this.learnedSignalItem.addActionListener(this);
            menu.add(this.learnedSignalItem);
            menu.addSeparator();
            this.homePageItem = new JMenuItem("Home Page", 72);
            this.homePageItem.addActionListener(this);
            menu.add(this.homePageItem);
            this.wikiItem = new JMenuItem("Wiki", 87);
            this.wikiItem.addActionListener(this);
            menu.add(this.wikiItem);
            this.forumItem = new JMenuItem("Forums", 70);
            this.forumItem.addActionListener(this);
            menu.add(this.forumItem);
            menu.addSeparator();
        }
        this.updateItem = new JMenuItem("Check for updates", 67);
        this.updateItem.addActionListener(this);
        menu.add(this.updateItem);
        this.aboutItem = new JMenuItem("About...", 65);
        this.aboutItem.addActionListener(this);
        menu.add(this.aboutItem);
    }

    private void appendAdvancedOptions(JMenu menu) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block10: {
                    try {
                        JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                        String command = item.getActionCommand();
                        if (command.equals("LearnedSignalTimingAnalysis")) {
                            if (!item.isSelected()) {
                                JP1Frame.properties.remove(command);
                            } else {
                                JP1Frame.properties.setProperty(command, Boolean.toString(item.isSelected()));
                            }
                        }
                        RMIRSetup.this.refreshTabbedPanes(command.equals("ShowSegments"));
                        if (command.equals("NonModalDeviceEditor")) {
                            RMIRSetup.this.setNonModalWarning(item.isSelected(), null);
                            break block10;
                        }
                        if (command.equals("HideNECDefaultSubs")) {
                            if (RMIRSetup.this.learnedPanel != null) {
                                RMIRSetup.this.learnedPanel.refresh();
                                RMIRSetup.this.learnedPanel.getModel().fireTableDataChanged();
                            }
                            break block10;
                        }
                        if (command.equals("SuppressDeletePrompts")) {
                            TablePanel.suppressDeletePrompts = item.isSelected();
                            RMTablePanel.suppressDeletePrompts = item.isSelected();
                            break block10;
                        }
                        if (!command.equals("FindAllArduino")) break block10;
                        for (IO io : RMIRSetup.this.interfaces) {
                            if (!io.getInterfaceName().equals("JP1.X Serial")) continue;
                            ((JP12Serial)io).setOption(item.isSelected() ? 1 : 0);
                            break;
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace(System.err);
                    }
                }
            }
        };
        JMenu advancedSubMenu = new JMenu("Advanced");
        advancedSubMenu.setMnemonic(68);
        menu.addSeparator();
        menu.add(advancedSubMenu);
        RMCheckBoxMenuItem item = new RMCheckBoxMenuItem("Show Segment Editor", "ShowSegments", false);
        item.addActionListener(listener);
        advancedSubMenu.add(item);
        showSegmentEditorItem = item;
        item = new RMCheckBoxMenuItem("Use non-modal Device Editor", "NonModalDeviceEditor", false);
        item.addActionListener(listener);
        advancedSubMenu.add(item);
        item = new RMCheckBoxMenuItem("Same sig = same remote", "SameSigSameRemote", false);
        advancedSubMenu.add(item);
        item = new RMCheckBoxMenuItem("Suppress NEC default subdevices", "HideNECDefaultSubs", true);
        item.addActionListener(listener);
        advancedSubMenu.add(item);
        item.setToolTipText(JTableX.getHtmlToolTip("In Learned Signals with a protocol name starting \"NEC\", suppress display of the subdevice value<br/>when it is the default value (the complement of the device code).  This option is selected by default<br/>but can be deselected if there are circumstances in which it is desirable to see the default explicitly."));
        item = new RMCheckBoxMenuItem("Chop Ict imports at 200ms", "ChopIctImports", true);
        item.setToolTipText(JTableX.getHtmlToolTip("When an IRScope .ict file is imported, it is separated into distinct signals that are named by<br/>the Note fields entered in IRScope.  When Chop Ict is selected, gaps of more than 200ms are also<br/>treated as signal separators, following the behaviour of IRScope.  The decoder acts recursively<br/>on each separated signal and may further separate the signal into multiple decodes, as in a macro.<br/>In some instances the chopping may split a signal incorrectly and result in decode failures or errors.<br/>This option is provided to enable the chopping action to be deselected in such cases."));
        advancedSubMenu.add(item);
        item = new RMCheckBoxMenuItem("Ignore final 1 on dev parm names", "IgnoreFinal1", false);
        item.setToolTipText(JTableX.getHtmlToolTip("When changing protocol in a device upgrade, ignore a final 1 in device parameter names, so that<br/>for example \"Device1\" or \"Device 1\" will match \"Device\"."));
        advancedSubMenu.add(item);
        findAllBTItem = new JCheckBoxMenuItem("Find all Bluetooth");
        findAllBTItem.setToolTipText(JTableX.getHtmlToolTip("When using the Bluetooth BLED112 dongle, selecting this item makes Search on the Remote chooser<br/>dialog report all Bluetooth devices found, not just UEI remotes.  This is for diagnostic purposes only.<br/>It is cleared each time RMIR starts."));
        advancedSubMenu.add(findAllBTItem);
        findAllArduinoItem = new RMCheckBoxMenuItem("Find all Arduino", "FindAllArduino", false);
        findAllArduinoItem.setToolTipText(JTableX.getHtmlToolTip("Arduino boards used as JP1 EEPROM interfaces may not be identified by RMIR unless this option<br/>is selected. When selected, remotes other than JP1 EEPROM ones will still be identified but it will<br/>take about 2 seconds longer to do so than when this option is not selected. The setting of this option<br/>persists through RMIR sessions until actively changed."));
        findAllArduinoItem.addActionListener(listener);
        advancedSubMenu.add(findAllArduinoItem);
        advancedSubMenu.addSeparator();
        item = new RMCheckBoxMenuItem("Learned Signal Timing Analysis", "LearnedSignalTimingAnalysis", false);
        item.addActionListener(listener);
        advancedSubMenu.add(item);
        properties.remove("LearnUpgradeConversion");
        JMenu suppressSubMenu = new JMenu("Suppress Messages");
        suppressSubMenu.setMnemonic(83);
        menu.add(suppressSubMenu);
        item = new RMCheckBoxMenuItem("Key Move Detach/Delete", "SuppressKeyMovePrompts", false);
        suppressSubMenu.add(item);
        item = new RMCheckBoxMenuItem("All table deletes", "SuppressDeletePrompts", false);
        TablePanel.suppressDeletePrompts = item.isSelected();
        RMTablePanel.suppressDeletePrompts = item.isSelected();
        item.addActionListener(listener);
        suppressSubMenu.add(item);
        item = new RMCheckBoxMenuItem("Confirmation prompts", "SuppressConfirmPrompts", false);
        item.setToolTipText(JTableX.getHtmlToolTip("This suppresses messages asking if you want to continue, and also some information<br/>messages requiring no response"));
        suppressSubMenu.add(item);
        suppressConfirmPrompts = item;
        item = new RMCheckBoxMenuItem("Import options", "SuppressImportOptions", true);
        item.setToolTipText(JTableX.getHtmlToolTip("When a device upgrade is created by importing an ict or Girr file or by conversion<br/>of learned signals, there may be more than one protocol consistent with the signals.<br/>When this option is checked, the choice is made by an RMIR algorithm, when unchecked<br/>the user is given a list to choose from.  This is checked by default."));
        suppressSubMenu.add(item);
        item = new RMCheckBoxMenuItem("Timing summary info", "SuppressTimingSummaryInfo", false);
        suppressSubMenu.add(item);
        suppressTimingSummaryInfo = item;
    }

    private void createToolbar() {
        this.toolBar.add(this.newAction);
        this.toolBar.add(this.openAction);
        this.toolBar.add(this.saveAction);
        this.toolBar.add(this.saveAsAction);
        this.toolBar.addSeparator();
        String selectedInterface = properties.getProperty("Interface");
        if (selectedInterface != null && selectedInterface.equals("JP2BT")) {
            this.toolBar.add(this.bluetoothButton);
            this.bluetoothButton.setBorder(this.bluetoothButton.isSelected() ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
            if (this.btio != null && this.btio.getBleRemote() != null && this.btio.getBleRemote().hasFinder) {
                this.toolBar.add(Box.createHorizontalStrut(5));
                this.toolBar.add(this.finderButton);
                this.finderButton.setBorder(this.finderButton.isSelected() ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
                this.finderItem.setVisible(true);
            } else {
                this.finderItem.setVisible(false);
            }
            this.bluetoothItem.setVisible(true);
        } else {
            this.bluetoothItem.setVisible(false);
            this.finderItem.setVisible(false);
        }
        this.toolBar.add(this.downloadAction);
        this.toolBar.add(this.uploadAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.openRdfAction);
        this.toolBar.add(this.codesAction);
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            this.toolBar.add(this.highlightAction);
        }
        this.toolBar.addSeparator();
        this.toolBar.add(this.rfAction);
        if (selectedInterface != null && selectedInterface.equals("JP2BT")) {
            this.downloadRawItem.setEnabled(this.bluetoothButton.isSelected());
            this.downloadAction.setEnabled(this.bluetoothButton.isSelected());
            this.uploadAction.setEnabled(this.uploadable && this.allowUpload());
        } else {
            this.disconnectBLE();
            this.downloadRawItem.setEnabled(!this.interfaces.isEmpty());
            this.downloadAction.setEnabled(!this.interfaces.isEmpty());
            this.uploadAction.setEnabled(this.uploadable);
            this.bleStatus.setVisible(false);
        }
    }

    public void recreateToolbar() {
        this.highlightItem.setEnabled(this.remoteConfig != null && !this.remoteConfig.getRemote().isSSD());
        Container mainPanel = this.getContentPane();
        mainPanel.remove(this.toolBar);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.createToolbar();
        mainPanel.add((Component)this.toolBar, "First");
        mainPanel.validate();
    }

    public boolean allowUpload() {
        String temp = properties.getProperty("Interface");
        return temp != null && temp.equals("JP2BT") ? this.btio != null && this.btio.getBleRemote() != null && this.btio.getBleRemote().supportsUpload && this.btio.isConnected() : true;
    }

    public RMFileChooser getFileChooser() {
        RMFileChooser chooser = new RMFileChooser(this.dir);
        EndingFileFilter irFilter = new EndingFileFilter("All supported files", RemoteMaster.admin ? allAdminEndings : allEndings);
        chooser.addChoosableFileFilter(irFilter);
        chooser.addChoosableFileFilter(new EndingFileFilter("RMIR files (*.rmir)", setupEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("IR files (*.ir)", setupImportEndings));
        if (RemoteMaster.admin) {
            chooser.addChoosableFileFilter(new EndingFileFilter("Remote Binary files (*.bin)", simplesetEndings));
        }
        chooser.addChoosableFileFilter(new EndingFileFilter("Device Upgrades (*.rmdu, *txt)", RemoteMaster.upgradeEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("Upgrade imports (*.girr, *.ict)", RemoteMaster.upgradeImportEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("Protocol files (*.rmpb)", RemoteMaster.protocolEndings));
        if (!RemoteMaster.admin) {
            chooser.addChoosableFileFilter(new EndingFileFilter("Simpleset files (*.bin)", simplesetEndings));
        }
        chooser.addChoosableFileFilter(new EndingFileFilter("Sling Learned Signals (*.xml)", slingEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("RF Packet Sniffer files (*.psd)", snifferEndings));
        chooser.setFileFilter(irFilter);
        return chooser;
    }

    public RMFileChooser getExtenderFileChooser() {
        RMFileChooser chooser = new RMFileChooser(this.mergeDir == null ? this.dir : this.mergeDir);
        EndingFileFilter irFilter = new EndingFileFilter("Extender merge files (*.hex)", extenderEndings);
        chooser.setDialogTitle("Select the file to merge");
        chooser.addChoosableFileFilter(irFilter);
        chooser.addChoosableFileFilter(new EndingFileFilter("Other merge files (*.ir, *.txt)", otherMergeEndings));
        chooser.addChoosableFileFilter(new EndingFileFilter("All merge files", allMergeEndings));
        chooser.setFileFilter(irFilter);
        return chooser;
    }

    public RMFileChooser getWavFileChooser(WavOp wavOp) {
        RMFileChooser chooser = new RMFileChooser(this.dir);
        EndingFileFilter wavFilter = new EndingFileFilter("Modem files (*.wav)", modemEndings);
        chooser.setDialogTitle("Select the sound file to " + (wavOp == WavOp.PLAY ? "play" : "import"));
        chooser.addChoosableFileFilter(wavFilter);
        chooser.setFileFilter(wavFilter);
        return chooser;
    }

    public RMFileChooser getFileSaveChooser(boolean validConfiguration) {
        RMFileChooser chooser = new RMFileChooser(this.dir);
        chooser.setAcceptAllFileFilterUsed(false);
        EndingFileFilter rmirFilter = new EndingFileFilter("RM Remote Image (*.rmir)", setupEndings);
        EndingFileFilter binFilter = new EndingFileFilter("Simpleset file (*.bin)", simplesetEndings);
        EndingFileFilter useFilter = rmirFilter;
        chooser.addChoosableFileFilter(rmirFilter);
        if (validConfiguration) {
            chooser.addChoosableFileFilter(new EndingFileFilter("IR file (*.ir)", setupImportEndings));
        }
        if (this.binLoaded() != null) {
            chooser.addChoosableFileFilter(binFilter);
            if (this.file != null && this.file.getName().toLowerCase().endsWith(simplesetEndings[0])) {
                useFilter = binFilter;
            }
        }
        chooser.setFileFilter(useFilter);
        return chooser;
    }

    public RMFileChooser getFileSaveChooser(EndingFileFilter filter) {
        RMFileChooser chooser = new RMFileChooser(this.dir);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        return chooser;
    }

    private File getRDFPathChoice() {
        File result = null;
        File dir = properties.getFileProperty("RDFPath");
        RMDirectoryChooser chooser = new RMDirectoryChooser(dir, ".rdf", "RDF");
        ChoiceArea area = new ChoiceArea(chooser);
        chooser.setAccessory(area);
        chooser.setDialogTitle("Select RDF Directory");
        if (chooser.showDialog(this, "OK") == 0 && (result = chooser.getSelectedFile()).equals(dir)) {
            result = null;
        }
        chooser.removePropertyChangeListener(area);
        return result;
    }

    private File getMapPathChoice() {
        File result = null;
        File dir = properties.getFileProperty("ImagePath");
        RMDirectoryChooser chooser = new RMDirectoryChooser(dir, ".map", "Map and Image");
        ChoiceArea area = new ChoiceArea(chooser);
        chooser.setAccessory(area);
        chooser.setDialogTitle("Select Map and Image Directory");
        if (chooser.showDialog(this, "OK") == 0 && (result = chooser.getSelectedFile()).equals(dir)) {
            result = null;
        }
        chooser.removePropertyChangeListener(area);
        return result;
    }

    private File getAddonPathChoice() {
        File result = null;
        File defaultDir = new File(RemoteMaster.getWorkDir(), "AddOns");
        File dir = properties.getFileProperty("AddonPath", defaultDir);
        RMDirectoryChooser chooser = new RMDirectoryChooser(dir, null, null);
        chooser.setDialogTitle("Select AddOns Directory");
        if (chooser.showDialog(this, "OK") == 0 && (result = chooser.getSelectedFile()).equals(dir)) {
            result = null;
        }
        if (result != null && result.equals(defaultDir)) {
            properties.remove("AddonPath");
            result = null;
        } else if (result != null) {
            properties.setProperty("AddonPath", result);
        }
        return result;
    }

    public JPS binLoaded() {
        for (IO io : this.interfaces) {
            if (!io.getInterfaceName().equals("JPS")) continue;
            JPS jps = (JPS)io;
            if (jps.isOpen()) {
                return jps;
            }
            return null;
        }
        return null;
    }

    public void openFile() throws Exception {
        this.openFile(null);
    }

    public void openFile(File file) throws Exception {
        this.openFile(file, null);
    }

    public void openFile(File file, WavOp wavOp) throws Exception {
        if (!(wavOp != null && wavOp == WavOp.PLAY || this.promptToSave())) {
            return;
        }
        while (file == null) {
            RMFileChooser chooser = wavOp == null ? this.getFileChooser() : this.getWavFileChooser(wavOp);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                file = chooser.getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
                    continue;
                }
                if (!file.isDirectory()) continue;
                JOptionPane.showMessageDialog(this, file.getName() + " is a directory.", "File doesn't exist.", 0);
                continue;
            }
            return;
        }
        System.err.println();
        System.err.println("Opening " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        String filename = file.getName();
        this.dir = file.getParentFile();
        properties.setProperty("IRPath", this.dir);
        if (RemoteMaster.hasEnding(filename, setupEndings, setupImportEndings, simplesetEndings)) {
            this.updateRecentFiles(file);
        }
        if (RemoteMaster.hasEnding(filename, RemoteMaster.upgradeEndings, RemoteMaster.upgradeImportEndings)) {
            RMIRSetup.runKM(file.getCanonicalPath());
            return;
        }
        if (RemoteMaster.hasEnding(filename, new String[][]{RemoteMaster.protocolEndings})) {
            RMIRSetup.runPB(file.getCanonicalPath());
            return;
        }
        if (RemoteMaster.hasEnding(filename, new String[][]{slingEndings})) {
            List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature("XMLLEARN");
            if (remotes.isEmpty()) {
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The RDF for XML Slingbox Learns was not found.  Please place it in the RDF folder and try again.", "Missing RDF File", 0);
                return;
            }
            Remote remote = remotes.get(0);
            remote.load();
            this.clearAllInterfaces();
            this.remoteConfig = new RemoteConfiguration(remote, this);
            this.recreateToolbar();
            this.remoteConfig.initializeSetup(0);
            this.remoteConfig.updateImage();
            this.remoteConfig.setDateIndicator();
            this.remoteConfig.setSavedData();
            SlingLearnParser.parse(file, this.remoteConfig);
            this.remoteConfig.updateImage();
            this.update();
            this.saveAction.setEnabled(false);
            this.saveAsAction.setEnabled(true);
            this.uploadable = !this.interfaces.isEmpty();
            this.uploadAction.setEnabled(this.uploadable);
            this.openRdfAction.setEnabled(true);
            this.installExtenderItem.setEnabled(true);
            this.cleanUpperMemoryItem.setEnabled(true);
            this.initializeTo00Item.setEnabled(!this.interfaces.isEmpty());
            this.initializeToFFItem.setEnabled(!this.interfaces.isEmpty());
            this.setBaselineItem.setEnabled(true);
            return;
        }
        if (RemoteMaster.hasEnding(filename, new String[][]{simplesetEndings})) {
            if (RemoteMaster.admin) {
                BinAnalyzer binAnalyzer = new BinAnalyzer(file, this, false);
                if (binAnalyzer.isReplacement) {
                    binAnalyzer = null;
                    this.noSetup = new NoSetup(file, this);
                    this.noSetup.getRDFInfo();
                }
                return;
            }
            ProtocolManager.getProtocolManager().reset();
            System.err.println("Starting Simpleset load");
            this.setInterfaceState("LOADING SIMPLESET...");
            this.file = file;
            new DownloadTask(file).execute();
            return;
        }
        if (wavOp != null && RemoteMaster.hasEnding(filename, new String[][]{modemEndings})) {
            if (wavOp == WavOp.PLAY) {
                this.wavPlayer = new RMWavPlayer();
                this.wavPlayer.open(file);
                int duration = this.wavPlayer.getDuration();
                String durStr = duration >= 600 ? "" + duration / 600 + "min " : "";
                int secStr = duration % 600;
                durStr = durStr + secStr / 10 + "." + secStr % 10 + "sec";
                String title = "Modem upload";
                String message = "The duration of this audio file for modem upload is " + durStr + ".  Before\ncontinuing, you need to set your remote ready to receive the upgrade.\nSee the guide \"Modem Upgrade Procedure\" in the Wiki of the JP1 website\nfor information on how to do this.\n\nDo you wish to continue?";
                if (JOptionPane.showConfirmDialog(this, message, title, 0, 1) != 0) {
                    return;
                }
                this.uploadWavItem.setEnabled(false);
                this.cancelWavUploadItem.setEnabled(true);
                TimingTask timer = new TimingTask("PLAYING WAV (" + durStr + "):", duration);
                this.wavPlayer.setTimer(timer);
                this.wavPlayer.play();
            } else {
                new LoadTask(file, wavOp).execute();
            }
            return;
        }
        if (RemoteMaster.hasEnding(filename, new String[][]{snifferEndings})) {
            if (this.rfTools == null) {
                this.rfTools = new RfTools(this);
            }
            this.rfTools.openPSDfile(file);
            return;
        }
        if (RemoteMaster.admin && RemoteMaster.hasEnding(filename, new String[][]{adminSpecialEndings})) {
            int dot = filename.lastIndexOf(".");
            String outname = filename.substring(0, dot) + ".out";
            File outFile = new File(this.dir, outname);
            if (outFile.exists()) {
                outFile.delete();
            }
            outFile.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            if (filename.endsWith(".ctl")) {
                String title = "Control file updater";
                String message = "Enter the hexadecimal offset to be applied to line numbers:";
                String offsetStr = JOptionPane.showInputDialog(this, message, title, 3);
                int offset = Integer.parseInt(offsetStr, 16);
                while (line != null) {
                    if (line.length() > 5) {
                        try {
                            String num = line.substring(2, 6);
                            int val = Integer.parseInt(num, 16);
                            line = line.substring(0, 2) + String.format("%04x", val += offset) + line.substring(6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    out.write(line + System.lineSeparator());
                    line = in.readLine();
                }
            } else if (filename.endsWith(".hexin")) {
                TI2541Processor p = new TI2541Processor("TI2541");
                ArrayList<Integer> list = new ArrayList<Integer>();
                while (line != null) {
                    short[] data = new Hex(line).getData();
                    for (int i = 0; i < data.length; i += 2) {
                        list.add(((Processor)p).getInt(data, i));
                    }
                    line = in.readLine();
                }
                Collections.sort(list);
                for (int i = 0; i < list.size(); ++i) {
                    out.write(String.format("%04X, ", list.get(i)));
                    if ((i + 1) % 10 != 0) continue;
                    out.write(System.lineSeparator());
                }
            }
            out.flush();
            out.close();
            in.close();
            return;
        }
        ProtocolManager.getProtocolManager().reset();
        this.saveAction.setEnabled(RemoteMaster.hasEnding(filename, new String[][]{setupEndings}));
        this.saveAsAction.setEnabled(true);
        this.openRdfAction.setEnabled(true);
        this.installExtenderItem.setEnabled(true);
        this.cleanUpperMemoryItem.setEnabled(true);
        this.initializeTo00Item.setEnabled(!this.interfaces.isEmpty());
        this.initializeToFFItem.setEnabled(!this.interfaces.isEmpty());
        this.setBaselineItem.setEnabled(true);
        this.uploadable = !this.interfaces.isEmpty();
        this.uploadAction.setEnabled(this.uploadable && this.allowUpload());
        this.resetSegmentPanel();
        this.setInterfaceState("LOADING...");
        new LoadTask(file).execute();
    }

    public void resetConfig(Remote remote, RMWavConverter converter) {
        if (remote != null) {
            ProtocolManager.getProtocolManager().reset();
            this.clearAllInterfaces();
            this.remoteConfig = new RemoteConfiguration(remote, this);
            this.recreateToolbar();
            this.remoteConfig.initializeSetup(0);
            this.remoteConfig.updateImage();
        }
        if (converter != null) {
            converter.mergeData(this.remoteConfig.getData());
            try {
                this.remoteConfig.importIR(null, true);
            }
            catch (IOException e) {
                System.err.println("Unable to parse imported data");
            }
            this.remoteConfig.updateImage();
        }
        this.remoteConfig.setDateIndicator();
        this.remoteConfig.setSavedData();
        this.update();
        this.saveAction.setEnabled(false);
        this.saveAsAction.setEnabled(true);
        this.openRdfAction.setEnabled(true);
        this.installExtenderItem.setEnabled(true);
        this.cleanUpperMemoryItem.setEnabled(true);
        this.initializeTo00Item.setEnabled(!this.interfaces.isEmpty());
        this.initializeToFFItem.setEnabled(!this.interfaces.isEmpty());
        this.uploadable = !this.interfaces.isEmpty();
        this.uploadAction.setEnabled(this.uploadable && this.allowUpload());
    }

    private void installExtender() throws Exception {
        if (!this.promptToSave()) {
            return;
        }
        String version = ExtInstall.class.getPackage().getImplementationVersion();
        System.err.print("Starting Java ExtInstall");
        if (version != null) {
            System.err.println(", version " + version);
        } else {
            System.err.println();
        }
        File file = null;
        while (file == null) {
            RMFileChooser chooser = this.getExtenderFileChooser();
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                file = chooser.getSelectedFile();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
                    continue;
                }
                if (!file.isDirectory()) continue;
                JOptionPane.showMessageDialog(this, file.getName() + " is a directory.", "File doesn't exist.", 0);
                continue;
            }
            System.err.println("ExtInstall cancelled by user.");
            return;
        }
        System.err.println("Merge file is " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        String interfaceName = properties.getProperty("Interface");
        if (interfaceName != null && interfaceName.equals("JP2BT")) {
            if (this.btio != null) {
                new InstallTask(file, this.btio).execute();
                return;
            }
            String message = "The JP2BT interface is not connected to a remote.";
            JOptionPane.showMessageDialog(this, message, "Extender Install", 0);
            return;
        }
        this.mergeDir = file.getParentFile();
        String[] oldDevBtnNotes = this.remoteConfig.getDeviceButtonNotes();
        List<DeviceUpgrade> oldDevUpgrades = this.remoteConfig.getDeviceUpgrades();
        List<ProtocolUpgrade> oldProtUpgrades = this.remoteConfig.getProtocolUpgrades();
        RMExtInstall installer = new RMExtInstall(file.getAbsolutePath(), this.remoteConfig);
        installer.install();
        if (this.binLoaded() != null || RMExtInstall.remoteConfig == null) {
            return;
        }
        if (this.remoteConfig != RMExtInstall.remoteConfig) {
            boolean found;
            this.remoteConfig = RMExtInstall.remoteConfig;
            this.recreateToolbar();
            String[] newDevBtnNotes = this.remoteConfig.getDeviceButtonNotes();
            Remote newRemote = this.remoteConfig.getRemote();
            List<DeviceUpgrade> newDevUpgrades = this.remoteConfig.getDeviceUpgrades();
            List<ProtocolUpgrade> newProtUpgrades = this.remoteConfig.getProtocolUpgrades();
            for (int i = 0; i < Math.min(oldDevBtnNotes.length, newDevBtnNotes.length); ++i) {
                newDevBtnNotes[i] = oldDevBtnNotes[i];
            }
            System.err.println("Restoring .rmir data lost in conversion to .ir format.");
            int devCount = 0;
            int protCount = 0;
            int index = installer.isExtenderMerge() ? installer.getDevUpgradeCodes().size() : 0;
            for (DeviceUpgrade duOld : oldDevUpgrades) {
                int codeOld = duOld.getHexSetupCodeValue();
                if (installer.getDevUpgradeCodes().contains(codeOld)) continue;
                found = false;
                while (index < newDevUpgrades.size()) {
                    DeviceUpgrade duNew = newDevUpgrades.get(index);
                    if (duNew.getHexSetupCodeValue() == codeOld) {
                        duOld.protocol = duNew.protocol;
                        duOld.setNewRemote(newRemote);
                        newDevUpgrades.set(index, duOld);
                        ++devCount;
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) continue;
                System.err.println("Error restoring device upgrades: failed at setup code = " + codeOld + ".");
            }
            System.err.println("Restored " + devCount + " device upgrades.");
            index = installer.isExtenderMerge() ? installer.getProtUpgradeIDs().size() : 0;
            for (ProtocolUpgrade puOld : oldProtUpgrades) {
                int pidOld = puOld.getPid();
                if (installer.getProtUpgradeIDs().contains(pidOld)) continue;
                found = false;
                while (index < newProtUpgrades.size()) {
                    ProtocolUpgrade puNew = newProtUpgrades.get(index);
                    if (puNew.getPid() == pidOld) {
                        if (!puNew.isUsed()) {
                            newProtUpgrades.set(index, puOld);
                            ++protCount;
                        }
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) continue;
                System.err.println("Error restoring protocol upgrades: failed at PID = " + pidOld + ".");
            }
            System.err.println("Restored " + protCount + " protocol upgrades.");
            Iterator<ProtocolUpgrade> it = newProtUpgrades.iterator();
            while (it.hasNext()) {
                ProtocolUpgrade pu = it.next();
                if (pu.isUsed()) {
                    it.remove();
                    continue;
                }
                if (!installer.getProtUpgradeIDs().contains(pu.getPid())) continue;
                pu.setManualProtocol(newRemote);
            }
            this.remoteConfig.setDeviceUpgrades(newDevUpgrades);
            this.remoteConfig.setProtocolUpgrades(newProtUpgrades);
        }
        this.remoteConfig.updateImage();
        this.update();
        this.saveAction.setEnabled(false);
        System.err.println("ExtInstall merge completed.");
    }

    private void updateRecentFiles(File file) throws IOException {
        JMenuItem item = null;
        String path = file.getCanonicalPath();
        for (int i = 0; i < this.recentFiles.getItemCount(); ++i) {
            File temp = new File(this.recentFiles.getItem(i).getText());
            if (!temp.getCanonicalPath().equals(path)) continue;
            item = this.recentFiles.getItem(i);
            this.recentFiles.remove(i);
            break;
        }
        if (item == null) {
            item = new JMenuItem(path);
            item.setActionCommand(path);
            item.addActionListener(this);
        }
        this.recentFiles.insert(item, 0);
        while (this.recentFiles.getItemCount() > 10) {
            this.recentFiles.remove(10);
        }
        this.recentFiles.setEnabled(true);
        this.dir = file.getParentFile();
        properties.setProperty("IRPath", this.dir);
    }

    public void save(File file, boolean forSaveAs) throws IOException {
        if (file == null) {
            this.saveAs();
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = "File Save Error";
            String message = "The file\n" + file.getCanonicalPath() + "\nis read-only.  Please use \"Save As...\" to save to a different file.";
            JOptionPane.showMessageDialog(this, message, title, 0);
            return;
        }
        String ext = file.getName().toLowerCase();
        int dot = ext.lastIndexOf(46);
        if ((ext = ext.substring(dot)).equals(".bin")) {
            boolean validConfiguration = this.updateUsage();
            if (!validConfiguration) {
                String title = "Invalid Configuration";
                String message = "This configuration is not valid.  It cannot be saved as\ncopying it to the remote could cause the remote to crash.";
                JOptionPane.showMessageDialog(this, message, title, 2);
                return;
            }
            if (!this.allowSave(this.remoteConfig.getSetupValidation())) {
                return;
            }
            this.remoteConfig.saveAltPIDs();
            System.err.println("Saving Simpleset");
            this.setInterfaceState("SAVING SIMPLESET...");
            this.changed = false;
            new UploadTask(file, this.useSavedData() ? this.remoteConfig.getSavedData() : this.remoteConfig.getData(), false, forSaveAs).execute();
        } else {
            String title;
            String message;
            boolean validConfiguration = this.updateUsage();
            if (!this.allowSave(Remote.SetupValidation.WARN)) {
                return;
            }
            if (!validConfiguration && NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message = "This configuration is not valid, but it can be saved and then\nre-loaded to give again this same invalid configuration.\n\nDo you wish to continue?", title = "Invalid Configuration", 0, 2) == 1) {
                return;
            }
            this.setInterfaceState("SAVING...");
            new SaveTask(file, forSaveAs ? Use.SAVEAS : Use.SAVING).execute();
        }
    }

    public void saveAs() throws IOException {
        this.saveAs(null, null, 0);
    }

    public void saveAs(WavOp wavOp, int wavIndex) throws IOException {
        this.saveAs(null, wavOp, wavIndex);
    }

    private void saveAs(File sourceFile, WavOp wavOp, int wavIndex) throws IOException {
        boolean validConfiguration;
        boolean bl = validConfiguration = sourceFile == null ? this.updateUsage() : true;
        if (sourceFile == null && !validConfiguration) {
            String title = "Invalid Configuration";
            String message = "This configuration is not valid.  It can be saved as a .rmir file\nwhich can be re-loaded to give again this same invalid configuration,\nbut it cannot be saved as a .ir or .wav file as it could cause the\nremote to crash if it were uploaded to it by another application.";
            JOptionPane.showMessageDialog(this, message, title, 2);
            if (wavOp != null) {
                return;
            }
        }
        EndingFileFilter filter = wavOp != null ? new EndingFileFilter("Modem files (*.wav)", modemEndings) : (sourceFile != null ? new EndingFileFilter("Summary files (*.html)", summaryEndings) : null);
        RMFileChooser chooser = filter == null ? this.getFileSaveChooser(validConfiguration) : this.getFileSaveChooser(filter);
        chooser.addPropertyChangeListener(this);
        File oldFile = this.file;
        if (sourceFile == null && wavOp == null && oldFile != null) {
            String name = oldFile.getAbsolutePath();
            if (name.toLowerCase().endsWith(".ir") || name.toLowerCase().endsWith(".txt")) {
                int dot = name.lastIndexOf(46);
                name = name.substring(0, dot) + ".rmir";
                oldFile = new File(name);
            }
            chooser.setSelectedFile(oldFile);
        }
        int returnVal = -1;
        try {
            returnVal = chooser.showSaveDialog(this);
        }
        catch (HeadlessException dot) {
            // empty catch block
        }
        if (returnVal == 0) {
            String ending = ((EndingFileFilter)chooser.getFileFilter()).getEndings()[0];
            String name = chooser.getSelectedFile().getAbsolutePath();
            if (!name.toLowerCase().endsWith(ending)) {
                name = name + ending;
            }
            File newFile = new File(name);
            int rc = 0;
            if (newFile.exists()) {
                rc = JOptionPane.showConfirmDialog(this, newFile.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
            }
            if (rc != 0) {
                return;
            }
            if (newFile.exists() && !newFile.canWrite()) {
                String title = "File Save Error";
                String message = "The file\n" + newFile.getCanonicalPath() + "\nis read-only.  Please save to a different file.";
                JOptionPane.showMessageDialog(this, message, title, 0);
                return;
            }
            this.dir = newFile.getParentFile();
            properties.setProperty("IRPath", this.dir);
            if (ending.equals(irEndings[0])) {
                this.remoteConfig.saveAltPIDs();
                this.setInterfaceState("EXPORTING...");
                new SaveTask(newFile, Use.EXPORT).execute();
            } else if (ending.equals(simplesetEndings[0])) {
                this.save(newFile, true);
            } else if (ending.equals(modemEndings[0])) {
                Remote remote = this.remoteConfig.getRemote();
                AddressRange settingsAddress = new AddressRange(0, remote.getAdvancedCodeAddress().getStart() - 1);
                settingsAddress.setFreeStart(settingsAddress.getEnd() + 1);
                AddressRange entireAddress = new AddressRange(0, remote.getEepromSize() - 1);
                entireAddress.setFreeStart(entireAddress.getEnd() + 1);
                AddressRange[] ranges = new AddressRange[]{entireAddress, settingsAddress, remote.getAdvancedCodeAddress(), remote.getTimedMacroAddress(), remote.getUpgradeAddress(), remote.getLearnedAddress()};
                new SaveTask(newFile, Use.EXPORT, ranges[wavIndex]).execute();
            } else if (ending.equals(summaryEndings[0])) {
                if (sourceFile != null) {
                    Files.copy(sourceFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                this.setInterfaceState("SAVING...");
                new SaveTask(newFile, Use.SAVEAS).execute();
            }
        }
    }

    private void setTitleFile(File file) {
        if (file == null || this.remoteConfig == null) {
            this.setTitle("RMIR");
        } else {
            this.setTitle("RMIR: " + file.getName() + " - " + this.remoteConfig.getRemote().getName());
        }
    }

    public ArrayList<IO> getInterfaces() {
        return this.interfaces;
    }

    public IO getOpenInterface(File file, Use use, ProgressUpdater progressUpdater) {
        String title;
        String tempName;
        String interfaceName = properties.getProperty("Interface");
        System.err.println("Interface Name = " + (interfaceName == null ? "NULL" : interfaceName));
        String portName = properties.getProperty("Port");
        System.err.println("Port Name = " + (portName == null ? "NULL" : portName));
        IO ioOut = null;
        if (interfaceName != null && (use == Use.DOWNLOAD || use == Use.UPLOAD || use == Use.RAWDOWNLOAD || use == Use.CONNECT)) {
            for (IO temp : this.interfaces) {
                tempName = temp.getInterfaceName();
                System.err.println("Testing interface: " + (tempName == null ? "NULL" : tempName));
                if (!tempName.equals(interfaceName)) continue;
                String item = use == Use.CONNECT ? "BLE interface" : "remote";
                System.err.println("Interface matched.  Trying to open " + item);
                ioOut = this.testInterface(temp, portName, file, use, progressUpdater);
                if (ioOut != null) {
                    System.err.println("Opened interface type " + Integer.toHexString(ioOut.getInterfaceType()).toUpperCase());
                } else {
                    System.err.println("Failed to open");
                }
                break;
            }
        } else {
            for (IO temp : this.interfaces) {
                String message;
                if (temp instanceof JP2BT || temp instanceof JP11USB || temp instanceof JP1Parallel && System.getProperty("os.name").equals("Linux") && NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message = "Auto-detect has not been able to find a remote with any other interface, so is about to try the\nLinux parallel port driver, which is unsafe.  It may cause RMIR to crash.  It uses \"bitbanging\"\nwhich is incompatible with modern operating systems and so can only be run with root privileges.\nIt is not supported.  Use it at your own risk.\n\nTo use it without getting this message every time, select it explicitly with the Interface item\non the Remote menu rather than using Auto-detect.\n\nDo you wish to continue?", title = "Linux Parallel Port Interface", 0, 2) != 0) continue;
                tempName = temp.getInterfaceName();
                System.err.println("Testing interface: " + (tempName == null ? "NULL" : tempName));
                ioOut = this.testInterface(temp, null, file, use, progressUpdater);
                if (ioOut == null) continue;
                System.err.println("Opened interface type " + Integer.toHexString(ioOut.getInterfaceType()).toUpperCase());
                break;
            }
        }
        if (ioOut != null) {
            ioOut.setUse(use);
        }
        CommHID.lastRegistryKey = null;
        xziteRegItem.setVisible(false);
        this.xziteReenableAction.setEnabled(false);
        if (RMIRSetup.ioNeedsPowerManagementCheck(ioOut)) {
            CommHID ioHID = (CommHID)ioOut;
            int enabled = ioHID.getEnhancedPowerManagementStatus();
            if (enabled >= 0) {
                xziteRegItem.setVisible(true);
                this.xziteReenableAction.setEnabled(true);
            }
            if (enabled < 0) {
                System.err.println("Enhanced Power Management is not supported");
            } else if (enabled > 0) {
                System.err.println("Attempting to disable Enhanced Power Management");
                title = "Enhanced Power Management";
                CommHID.Response response = CommHID.setEnhancedPowerManagementEnabled(false);
                if (response == null) {
                    String message = "Attempt to disable Enhanced Power Management failed.";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    ioOut = null;
                } else if (response.error != null) {
                    System.err.println(response.error);
                    String message = "Uploading or downloading from this remote requires Enhanced Power Management to\nbe disabled in the Windows Registry.  The change is persistent so this only needs\nto be done once.  For RMIR to make this change, it must be run as adminstrator.\nTo do this, right-click an RMIR shortcut, select \"Run as administrator\" and then\ndo a download from the remote.  The change will be made automatically.\n\nIf you would prefer to use the Registry Editor to make this change, open the\nmenu item \"Show XSight registry key\" on the Advanced menu for instructions.";
                    JOptionPane.showMessageDialog(this, message, title, 1);
                    ioOut = null;
                } else {
                    System.err.println(response.output);
                    ioHID.closeRemote();
                    System.err.println("Requesting disconnection and reconnection");
                    String message = "Enhanced Power Management has been disabled for this remote.\nFor this to take effect, now please disconnect the remote from\nthe PC, then reconnect it, before pressing OK.";
                    JOptionPane.showMessageDialog(this, message, title, 1);
                    String commPortName = ioHID.openRemote(portName);
                    ioOut = commPortName == null || commPortName.isEmpty() ? null : ioHID;
                }
            }
        }
        return ioOut;
    }

    private IO testInterface(IO ioIn, String portName, File file, Use use, ProgressUpdater progressUpdater) {
        JPS jps;
        String ioName = ioIn.getInterfaceName();
        if (file != null && !ioName.equals("JPS")) {
            return null;
        }
        if (ioName.equals("JP2BT")) {
            if (use == Use.DOWNLOAD || use == Use.UPLOAD) {
                if (this.btio != null) {
                    System.err.println("JP2BT interface is already open");
                }
            } else if (use == Use.CONNECT) {
                JP2BT iobt = (JP2BT)ioIn;
                iobt.setBleInterface(portName);
                String portResult = iobt.connectBLE(portName);
                String bleStack = iobt.getBleStack();
                if (portResult == null) {
                    System.err.println("Failed to connect to BLE interface on port " + portName);
                    portName = "";
                } else if (bleStack == null) {
                    System.err.println("Connected BLE interface but no supported BLE stack found");
                    portName = "";
                } else if (bleStack.equals("Microsoft") && !RMIRSetup.testWindowsVersion("10.0.0")) {
                    System.err.println("Connected BLE interface but Microsoft BLE stack needs Windows 10");
                    portName = "";
                } else {
                    System.err.println("Connected BLE interface on port " + portName);
                    System.err.println("BLE stack is " + bleStack);
                }
            }
        }
        if (ioName.equals("JPS") && (jps = (JPS)ioIn).isOpen() && (use == Use.SAVING || use == Use.SAVEAS)) {
            portName = jps.getFilePath();
            System.err.println("Already open on Port " + portName);
            if (use == Use.SAVEAS) {
                portName = file.getAbsolutePath();
                System.err.println("Changing Port to " + portName);
                jps.setFilePath(portName);
            }
            return ioIn;
        }
        ioIn.setProgressUpdater(progressUpdater);
        if (use != Use.CONNECT) {
            portName = ioIn.openRemote(portName != null ? portName : (file != null ? file.getAbsolutePath() : null));
        }
        if (portName == null) {
            portName = "";
        }
        System.err.println("Port Name = " + (portName.isEmpty() ? "NULL" : portName));
        if (!portName.isEmpty()) {
            System.err.println("Opened on Port " + portName);
            return ioIn;
        }
        ioIn.setProgressUpdater(null);
        return null;
    }

    public static boolean ioNeedsPowerManagementCheck(IO io) {
        return io != null && io.getInterfaceName().equals("CommHID") && System.getProperty("os.name").startsWith("Windows") && Float.parseFloat(System.getProperty("os.version")) >= 6.3f;
    }

    public boolean usesNonModalDeviceEditor() {
        return Boolean.parseBoolean(properties.getProperty("NonModalDeviceEditor", "false"));
    }

    public boolean sameSigSameRemote() {
        return Boolean.parseBoolean(properties.getProperty("SameSigSameRemote", "false"));
    }

    public void setNonModalWarning(boolean warn, DeviceUpgradeEditor duEditor) {
        if (duEditor != null) {
            this.duEditor = warn ? duEditor : null;
        } else if (this.duEditor != null && !warn) {
            if (this.duEditor.getState() == 1) {
                this.duEditor.setExtendedState(0);
            }
            this.duEditor.toFront();
            this.duEditor = null;
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        this.setInterfaceState(this.interfaceText);
    }

    public void setInterfaceState(String state) {
        this.setInterfaceState(state, null);
    }

    private void setInterfaceState(String state, Integer progress) {
        this.interfaceText = state;
        if (this.duEditor != null) {
            ((CardLayout)this.statusBar.getLayout()).show(this.statusBar, "WARNING");
        } else if (state != null) {
            if (progress != null) {
                if (this.interfaceState.isIndeterminate()) {
                    this.interfaceState.setIndeterminate(false);
                }
                this.interfaceState.setValue(progress);
                state = state + " " + progress + "%";
            } else if (!this.interfaceState.isIndeterminate()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RMIRSetup.this.interfaceState.setIndeterminate(true);
                        RMIRSetup.this.interfaceState.setValue(0);
                    }
                });
            }
            this.interfaceState.setString(state);
            ((CardLayout)this.statusBar.getLayout()).show(this.statusBar, "INTERFACE");
        } else {
            ((CardLayout)this.statusBar.getLayout()).show(this.statusBar, "MEMORY");
        }
    }

    public void clearAllInterfaces() {
        for (IO io : this.interfaces) {
            io.clear();
        }
    }

    public static String getIOsignature(IO io, int baseAddress) {
        String sig = null;
        if (io.getInterfaceType() > 0) {
            sig = io.getRemoteSignature();
        } else {
            short[] sigData = new short[10];
            int count = io.readRemote(baseAddress, sigData);
            System.err.println("Read first " + count + " bytes: " + Hex.toString(sigData));
            sig = Hex.getRemoteSignature(sigData);
        }
        if (sig != null) {
            while (sig.endsWith("_")) {
                sig = sig.substring(0, sig.length() - 1);
            }
        }
        return sig;
    }

    public static short[] getIcInfo(IO io) {
        byte[] buffer = new byte[10];
        if (!io.getIcInfo(buffer, buffer.length) || buffer[2] != 0) {
            return null;
        }
        Hex data = new Hex(buffer);
        int infoSize = data.get(0);
        return data.subHex(3, infoSize - 2).getData();
    }

    public static short[] getSigData(String sigString, IO io) {
        int addrLen;
        byte[] jp2info = new byte[]{};
        short[] sigData = null;
        int n = addrLen = (io.getInterfaceType() & 0x100) == 256 ? 4 : 2;
        if (sigString.length() > 8) {
            int i;
            int infoLen = (2 * addrLen + 2) * 3;
            jp2info = new byte[infoLen];
            if (!io.getJP2info(jp2info, infoLen)) {
                jp2info = null;
            }
            sigData = new short[sigString.length() + (jp2info != null ? jp2info.length : 0)];
            int index = 0;
            for (i = 0; i < sigString.length(); ++i) {
                sigData[index++] = (short)sigString.charAt(i);
            }
            if (jp2info != null) {
                for (i = 0; i < jp2info.length; ++i) {
                    sigData[index++] = (short)(jp2info[i] & 0xFF);
                }
            }
        } else {
            int infoLen = 0;
            jp2info = new byte[6];
            if (!io.getJP2info(jp2info, 6)) {
                jp2info = null;
            }
            if (jp2info != null) {
                infoLen = ((jp2info[4] & 0xFF) << 8) + (jp2info[5] & 0xFF);
            }
            if (infoLen == 512) {
                jp2info = new byte[43];
                if (!io.getJP2info(jp2info, 43)) {
                    jp2info = null;
                }
                int blockCount = jp2info[42] & 0xFF;
                infoLen = 43 + blockCount * addrLen;
            }
            jp2info = new byte[infoLen];
            if (infoLen == 0 || !io.getJP2info(jp2info, infoLen)) {
                jp2info = null;
            }
            if (jp2info != null) {
                sigData = new short[infoLen];
                for (int i = 0; i < infoLen; ++i) {
                    sigData[i] = (short)(jp2info[i] & 0xFF);
                }
                io.setEraseSize(jp2info[40] << 8 | jp2info[41]);
            }
        }
        return sigData;
    }

    public static int getRfDataAddress() {
        return rfDataAddress;
    }

    public static short[] getRFData(IO io) {
        if ((io.getInterfaceType() & 0xFFF7) == 5377) {
            short[] buffer;
            int startAddress = io.getRemoteEepromAddress() + io.getRemoteEepromSize() + 256;
            if (io.readRemote(startAddress, buffer = new short[512]) != 512) {
                return null;
            }
            for (int n = 0; n < 512; n += 128) {
                if (buffer[n + 2] != 1) continue;
                rfDataAddress = startAddress + n;
                return Arrays.copyOfRange(buffer, n, n + 128);
            }
        }
        return null;
    }

    public List<SummarySection> getSummarySections(JTabbedPane pane, int index) {
        if (index < 0 || index >= pane.getTabCount()) {
            return null;
        }
        Remote remote = this.remoteConfig.getRemote();
        ArrayList<SummarySection> list = new ArrayList<SummarySection>();
        SummarySection ss = new SummarySection();
        Component c = pane.getComponentAt(index);
        if (c == null) {
            return null;
        }
        if (c instanceof RMTablePanel) {
            ss.model = ((RMTablePanel)c).getModel();
            ss.title = pane.getTitleAt(index);
            ss.sorter = ((RMTablePanel)c).getSorter();
            ss.table = ((RMTablePanel)c).getTable();
            list.add(ss);
            return list;
        }
        if (c instanceof GeneralPanel) {
            ss.model = ((GeneralPanel)c).getDeviceButtonTableModel();
            ss.title = "Device Buttons";
            list.add(ss);
            if (this.remoteConfig != null && remote.hasSettings()) {
                ss = new SummarySection();
                ss.model = ((GeneralPanel)c).getSettingModel();
                ss.title = "Other Settings";
                list.add(ss);
            }
            return list;
        }
        if (c instanceof FavoritesPanel) {
            FavoritesPanel fp = (FavoritesPanel)c;
            ss.model = fp.getFavModel();
            ss.title = "Favorites Macros";
            list.add(ss);
            ss = new SummarySection();
            ss.model = fp.getActivityGroupModel();
            ss.title = "Favorites Group Assignments";
            list.add(ss);
            return list;
        }
        if (c instanceof ActivityPanel) {
            ActivityPanel ap = (ActivityPanel)c;
            List<Activity> aList = ap.getActivityList();
            ActivityFunctionTableModel aftm = ap.getActivityFunctionModel();
            ActivityGroupTableModel agtm = ap.getActivityGroupModel();
            for (Activity activity : aList) {
                if (!remote.hasActivityAlgorithm()) {
                    ss = new SummarySection();
                    ss.model = aftm;
                    ss.subtitle = activity.getName();
                    ss.activity = activity;
                    list.add(ss);
                }
                ss = new SummarySection();
                ss.model = agtm;
                ss.activity = activity;
                list.add(ss);
            }
            if (list.size() > 0) {
                ((SummarySection)list.get((int)0)).title = "Activities";
            }
            return list;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block199: {
            this.finishEditing();
            List<JMenuItem> exportToWavList = Arrays.asList(this.exportToWavImageItem, this.exportToWavSettingsItem, this.exportToWavMacrosEtcItem, this.exportToWavTimedMacrosItem, this.exportToWavUpgradesItem, this.exportToWavLearnedItem);
            int wavIndex = -1;
            int validationIndex = -1;
            try {
                Object source = e.getSource();
                if (source == this.installExtenderItem) {
                    this.installExtender();
                    break block199;
                }
                if (source == this.importFromWavNewItem || source == this.importFromWavMergeItem) {
                    this.openFile(null, source == this.importFromWavNewItem ? WavOp.NEW : WavOp.MERGE);
                    break block199;
                }
                wavIndex = exportToWavList.indexOf(source);
                if (wavIndex >= 0) {
                    this.saveAs(WavOp.SAVE, wavIndex);
                    break block199;
                }
                if (source == this.uploadWavItem) {
                    this.openFile(null, WavOp.PLAY);
                    break block199;
                }
                if (source == this.cancelWavUploadItem) {
                    if (this.wavPlayer != null) {
                        this.wavPlayer.close();
                    }
                    break block199;
                }
                if (source == this.createSummaryItem || source == this.createSelectionItem) {
                    ArrayList<SummarySection> ssList = new ArrayList<SummarySection>();
                    for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                        if (this.getSummarySections(this.tabbedPane, i) == null) continue;
                        ssList.addAll(this.getSummarySections(this.tabbedPane, i));
                    }
                    if (source == this.createSelectionItem) {
                        JPanel panel = new JPanel(new BorderLayout());
                        Box box = Box.createVerticalBox();
                        JScrollPane scroll = new JScrollPane(box);
                        scroll.getViewport().setPreferredSize(new Dimension(0, 0));
                        scroll.setBorder(BorderFactory.createTitledBorder("Select tables for summary: "));
                        panel.add((Component)scroll, "Center");
                        JLabel lbl = new JLabel("Text");
                        int height = lbl.getPreferredSize().height;
                        panel.add(Box.createVerticalStrut(12 * height), "Before");
                        LinkedHashMap<JCheckBox, SummarySection> checkMap = new LinkedHashMap<JCheckBox, SummarySection>();
                        for (SummarySection ss : ssList) {
                            JCheckBox chk = new JCheckBox(ss.title);
                            checkMap.put(chk, ss);
                            box.add(chk);
                        }
                        Object[] options = new String[]{"Create", "Cancel"};
                        int result = JOptionPane.showOptionDialog(null, panel, "Summary selector", 2, -1, null, options, options[0]);
                        if (result != 0) {
                            return;
                        }
                        ssList.clear();
                        for (JCheckBox chk : checkMap.keySet()) {
                            if (!chk.isSelected()) continue;
                            ssList.add((SummarySection)checkMap.get(chk));
                        }
                        if (ssList.isEmpty()) {
                            return;
                        }
                    }
                    HtmlGenerator htmlGen = new HtmlGenerator(this.remoteConfig);
                    if (RMIRSetup.desktopUsable() && htmlGen.makeHtml(ssList)) {
                        RMIRSetup.browse(summaryFile.toURI());
                    }
                    break block199;
                }
                if (source == this.viewSummaryItem) {
                    if (!summaryFile.exists()) {
                        String message = "There is no summary available to view.";
                        String title = "View Summary";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                    } else if (RMIRSetup.desktopUsable()) {
                        RMIRSetup.browse(summaryFile.toURI());
                    }
                    break block199;
                }
                if (source == this.saveSummaryItem) {
                    if (!summaryFile.exists()) {
                        String message = "There is no summary available to save.";
                        String title = "Save Summary";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                    } else {
                        this.saveAs(summaryFile, null, 0);
                    }
                    break block199;
                }
                if (source == this.createRDFInfoFileItem) {
                    this.createRDFInfoFile();
                    break block199;
                }
                if (source == this.exitItem) {
                    this.dispatchEvent(new WindowEvent(this, 201));
                    break block199;
                }
                if (source == this.downloadRawItem) {
                    if (!this.promptToSave()) {
                        return;
                    }
                    RawDataDialog dlg = new RawDataDialog(this);
                    dlg.setVisible(true);
                    break block199;
                }
                if (source == this.verifyUploadItem) {
                    properties.setProperty("verifyUpload", Boolean.toString(this.verifyUploadItem.isSelected()));
                    break block199;
                }
                if (source == this.noPortSearchItem) {
                    properties.setProperty("noPortSearch", Boolean.toString(this.noPortSearchItem.isSelected()));
                    this.ioButtonMap.get("autodetect").setVisible(!this.noPortSearchItem.isSelected());
                    break block199;
                }
                if (source == this.highlightItem) {
                    properties.setProperty("highlighting", Boolean.toString(this.highlightItem.isSelected()));
                    if (this.currentPanel instanceof RMTablePanel) {
                        RMTablePanel panel = (RMTablePanel)this.currentPanel;
                        panel.getModel().fireTableStructureChanged();
                    } else if (this.currentPanel == this.generalPanel) {
                        this.generalPanel.getDeviceButtonTableModel().fireTableStructureChanged();
                        this.generalPanel.getSettingModel().fireTableStructureChanged();
                    }
                    this.currentPanel.set(this.remoteConfig);
                    this.recreateToolbar();
                    break block199;
                }
                if (source == this.enablePreserveSelection) {
                    properties.setProperty("enablePreserveSelection", Boolean.toString(this.enablePreserveSelection.isSelected()));
                    break block199;
                }
                if (source == this.showSlingboxProtocols) {
                    if (!this.showSlingboxProtocols.isSelected()) {
                        properties.remove("ShowSlingboxProtocols");
                    } else {
                        properties.setProperty("ShowSlingboxProtocols", Boolean.toString(this.showSlingboxProtocols.isSelected()));
                    }
                    break block199;
                }
                if (source == this.defaultDelayItem) {
                    properties.remove("TooltipDelay");
                    this.tooltipDelay = this.tooltipDefaultDelay;
                    ToolTipManager.sharedInstance().setInitialDelay(this.tooltipDefaultDelay);
                    break block199;
                }
                if (source == this.specifiedDelayItem) {
                    int val = 0;
                    do {
                        String ret;
                        if ((ret = (String)JOptionPane.showInputDialog(this, "Specify tooltip delay in milliseconds:", "Tooltip Delay", -1, null, null, "" + this.tooltipDelay)) == null) {
                            val = -1;
                            break;
                        }
                        try {
                            val = Integer.parseInt(ret);
                        }
                        catch (NumberFormatException numberFormatException) {
                            val = -1;
                        }
                        if (val >= 0) continue;
                        JOptionPane.showMessageDialog(this, "You must enter a valid non-negative integer", "Tooltip Delay", 0);
                    } while (val < 0);
                    if (val >= 0) {
                        this.tooltipDelay = val;
                        ToolTipManager.sharedInstance().setInitialDelay(this.tooltipDelay);
                        properties.setProperty("TooltipDelay", "" + this.tooltipDelay);
                    }
                    break block199;
                }
                if (source == noUpgradeItem) {
                    if (!noUpgradeItem.isSelected()) {
                        properties.remove("NoUpgrade");
                    } else {
                        properties.setProperty("NoUpgrade", Boolean.toString(noUpgradeItem.isSelected()));
                    }
                } else if (source == this.cleanUpperMemoryItem) {
                    int i;
                    String title = "Clean Upper Memory";
                    String message = "";
                    message = this.remoteConfig.hasSegments() ? message + "Please " : message + "Do you want to retain all data in the first $100 (i.e. 256) bytes of memory?\n\nIf you answer No then the memory will be set as if your present setup was\ninstalled on a reset state created in accordance with the RDF alone.  This\nis the cleanest option but most RDFs at present do not create a true factory\nreset state.\n\nIf you answer Yes then any data in the first $100 bytes not set by the RDF\nwill be retained.  This should include any data set by a factory reset that\nis missing from the RDF, but it may also include other data that could be\nusefully cleaned.\n\nPlease also ";
                    int n = NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message = message + "be aware that blasting the memory will destroy most extenders, as\nthey place at least part of their code in the memory that will be cleared.\nPress Cancel to exit without blasting the memory.", title, this.remoteConfig.hasSegments() ? 2 : 1, 3);
                    if (n == 2) {
                        return;
                    }
                    if (n == 0) {
                        Remote remote = this.remoteConfig.getRemote();
                        short[] data = this.remoteConfig.getData();
                        Arrays.fill(data, remote.getUsageRange().getFreeStart(), data.length, (short)255);
                        this.remoteConfig.updateCheckSums();
                        this.update();
                        return;
                    }
                    Remote remote = this.remoteConfig.getRemote();
                    DeviceButton[] devBtns = remote.getDeviceButtons();
                    int[] devBtnData = new int[2 * devBtns.length];
                    DeviceLabels devLabels = remote.getDeviceLabels();
                    String[] devLabelText = new String[2 * devBtns.length];
                    SoftDevices softDevices = remote.getSoftDevices();
                    int[] softSequence = new int[devBtns.length + 1];
                    Setting[] settings = remote.getSettings();
                    int[] settingValues = new int[settings.length];
                    short[] data = this.remoteConfig.getData();
                    for (i = 0; i < devBtns.length; ++i) {
                        devBtnData[2 * i] = devBtns[i].getDeviceSlot(data);
                        devBtnData[2 * i + 1] = devBtns[i].getDeviceGroup(data);
                        if (devLabels != null) {
                            devLabelText[2 * i] = devLabels.getText(data, i);
                            devLabelText[2 * i + 1] = devLabels.getDefaultText(data, i);
                        }
                        if (softDevices == null) continue;
                        softSequence[i] = softDevices.getSequenceIndex(i, data);
                    }
                    if (softDevices != null) {
                        softSequence[devBtns.length] = softDevices.getFilledSlotCount(data);
                    }
                    for (i = 0; i < settings.length; ++i) {
                        settingValues[i] = settings[i].getValue();
                    }
                    remote.setFixedData(remote.getRawFixedData());
                    this.remoteConfig.initializeSetup(n == 0 ? 256 : 0);
                    for (i = 0; i < devBtns.length; ++i) {
                        devBtns[i].setDeviceSlot(devBtnData[2 * i], data);
                        devBtns[i].setDeviceGroup((short)devBtnData[2 * i + 1], data);
                        if (devLabels != null) {
                            devLabels.setText(devLabelText[2 * i], i, data);
                            devLabels.setDefaultText(devLabelText[2 * i + 1], i, data);
                        }
                        if (softDevices == null) continue;
                        softDevices.setSequenceIndex(softSequence[i], i, data);
                    }
                    if (softDevices != null) {
                        softDevices.setFilledSlotCount(softSequence[devBtns.length], data);
                    }
                    for (i = 0; i < settings.length; ++i) {
                        settings[i].setValue(settingValues[i]);
                    }
                    if (n == 1) {
                        this.remoteConfig.setDateIndicator();
                    }
                    this.remoteConfig.updateImage();
                    this.update();
                } else if (source == this.clearAltPIDHistory) {
                    ProtocolManager pm = ProtocolManager.getProtocolManager();
                    int count = pm.countAltPIDRemoteEntries();
                    String string = "Clear Alt PID History";
                    String message = "The Alt PID History is used only to help a protocol to be recognised when other means\nfail, such as in a download from a remote when it has been uploaded with an Alternate\nPID instead of the standard one for that protocol.  There is seldom any need to clear\nthis history unless its size is becoming excessive.\n\nIt currently has " + count;
                    message = message + (count == 1 ? " entry." : " entries.");
                    int ans = JOptionPane.showConfirmDialog(this, message = message + "\n\nAre you sure you want to clear this history?", string, 0, 3);
                    if (ans == 0) {
                        pm.clearAltPIDRemoteEntries();
                        message = "Cleared!";
                        JOptionPane.showMessageDialog(this, message, string, 1);
                    }
                } else if (source == this.initializeTo00Item) {
                    short[] data = this.getInitializationData(0);
                    if (data != null) {
                        System.err.println("Starting upload to initialize to FF");
                        this.setInterfaceState("INITIALIZING TO 00...");
                        new UploadTask(data, false).execute();
                    }
                } else if (source == this.initializeToFFItem) {
                    short[] data = this.getInitializationData(255);
                    if (data != null) {
                        System.err.println("Starting upload to initialize to FF");
                        this.setInterfaceState("INITIALIZING TO FF...");
                        new UploadTask(data, false).execute();
                    }
                } else if (source == this.useSavedDataItem) {
                    if (this.currentPanel == this.rawDataPanel) {
                        this.rawDataPanel.set(this.remoteConfig);
                    } else if (this.currentPanel == this.segmentPanel) {
                        this.segmentPanel.set(this.remoteConfig);
                    } else if (this.currentPanel == this.xsightFileDataPanel) {
                        this.xsightFileDataPanel.set(this.remoteConfig);
                    }
                } else if (source == putSystemFileItem) {
                    this.setInterfaceState("GETTING FILE LIST...");
                    new XziteFileTask("Upload").execute();
                } else if (source == verifyXZITEfilesItem) {
                    this.setInterfaceState("VERIFYING...");
                    new XziteFileTask("Verify").execute();
                } else if (source == xziteOpsItem) {
                    this.setInterfaceState("GETTING FILE LIST...");
                    new XziteFileTask("Delete/Save").execute();
                } else if (source == xziteReformatItem) {
                    String message = "<html>Are you sure you want to format the file system of the remote<br>and reinstall the system files?  This operation will leave the<br>remote in factory reset state, all setup data having been deleted.<br>If you continue, be aware that during the rebuild phase it is normal<br>for the progress indicator to stay at 15% for an extended period.<br><br>Make sure you have saved any setup that you want to reload after<br>the rebuild.<br><br>Do you want to continue?</html>";
                    String title = "Reformat XSight";
                    int n = NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message, title, 0, 3);
                    if (n != 0) {
                        return;
                    }
                    this.setInterfaceState("FORMATTING...");
                    new XziteFileTask("Reformat").execute();
                } else if (source == saveFDRAfirmware) {
                    this.setInterfaceState("SAVING FIRMWARE...");
                    new XziteFileTask("FdraFirmware").execute();
                } else if (source == upgradeSourceItem) {
                    Remote remote = this.remoteConfig != null ? this.remoteConfig.getRemote() : null;
                    UpgradeSourceSelector selector = new UpgradeSourceSelector(this, remote, upgradeSource, upgradeLanguage);
                    selector.setVisible(true);
                    upgradeSource = selector.getSource();
                    upgradeLanguage = selector.getSelectedLanguage();
                } else if (source == this.setBaselineItem) {
                    this.remoteConfig.setBaselineData();
                    this.clearBaselineItem.setEnabled(true);
                    if (this.currentPanel == this.rawDataPanel) {
                        this.rawDataPanel.set(this.remoteConfig);
                    }
                } else if (source == this.clearBaselineItem) {
                    this.remoteConfig.clearBaselineData();
                    this.clearBaselineItem.setEnabled(false);
                    if (this.currentPanel == this.rawDataPanel) {
                        this.rawDataPanel.set(this.remoteConfig);
                    }
                } else if (source == this.progressBarColors) {
                    this.pbDialog = new JDialog((Frame)this, "Set Progress Bar Colors");
                    JPanel panel = new JPanel(new BorderLayout());
                    this.box = Box.createVerticalBox();
                    this.box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.GRAY)));
                    panel.add((Component)this.box, "Center");
                    JPanel buttonPanel = new JPanel(new FlowLayout(1));
                    buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.GRAY)));
                    this.pbOkButton = new JButton("OK");
                    this.pbOkButton.addActionListener(this);
                    this.pbCancelButton = new JButton("Cancel");
                    this.pbCancelButton.addActionListener(this);
                    buttonPanel.add(this.pbOkButton);
                    buttonPanel.add(Box.createHorizontalStrut(10));
                    buttonPanel.add(this.pbCancelButton);
                    panel.add((Component)buttonPanel, "Last");
                    this.pbDialog.add(panel);
                    String string = "<html>Each setting has a Default option giving a color that will depend on<br/>the current look-and-feel.  The specific color options will apply to<br/>all look-and-feels.";
                    this.box.add(Box.createVerticalStrut(5));
                    String selString = "Select the color for text on highlighted background:";
                    this.box.add(new JLabel(string));
                    this.box.add(Box.createVerticalStrut(5));
                    this.box.add(new JLabel(selString));
                    this.box.add(this.pbSelDefault);
                    this.box.add(this.pbSelBlue);
                    this.box.add(this.pbSelBlack);
                    this.box.add(this.pbSelWhite);
                    this.box.add(Box.createVerticalStrut(5));
                    String unselString = "Select the color for text on plain background:";
                    this.box.add(new JLabel(unselString));
                    this.box.add(this.pbUnselDefault);
                    this.box.add(this.pbUnselBlue);
                    this.box.add(this.pbUnselBlack);
                    this.box.add(Box.createVerticalStrut(5));
                    String foreString = "<html>Some look-and-feels do not support the above settings.  These may support<br/>the following one, which selects a text color used on both backgrounds.<br/>Note, however, that for look-and-feels that DO support the above settings,<br/>this color is used as the highlight color.  You may, of course, use this<br/>to change the highlight color in this case if you so wish.</html>";
                    this.box.add(new JLabel(foreString));
                    this.box.add(this.pbForeDefault);
                    this.box.add(this.pbForeAquamarine);
                    this.box.add(this.pbForeBlack);
                    this.box.add(this.pbForeBlue);
                    this.box.add(this.pbForeRed);
                    this.box.add(this.pbForeOrange);
                    this.box.add(this.pbForeGreen);
                    this.pbDialog.pack();
                    this.pbDialog.setLocationRelativeTo(this);
                    this.pbDialog.setVisible(true);
                } else if (source == this.pbOkButton) {
                    this.storePBSelectedColors();
                    this.setPBSelectedColors();
                    this.pbDialog.setVisible(false);
                    this.pbDialog = null;
                    String message = "The color changes you have made will take effect\nwhen RMIR is next restarted.";
                    String title = "Progress Bar Text Colors";
                    JOptionPane.showMessageDialog(this, message, title, 1, null);
                } else if (source == this.pbCancelButton) {
                    this.setPBSelectedColors();
                    this.pbDialog.setVisible(false);
                    this.pbDialog = null;
                } else if (source == disableActivitiesItem) {
                    this.refreshTabbedPanes(true);
                    this.propertyChange(new PropertyChangeEvent(this, "activityState", null, disableActivitiesItem.isSelected()));
                } else if (source == disableUploadRestrictionsItem) {
                    int reply = 0;
                    if (disableUploadRestrictionsItem.isSelected()) {
                        reply = 1;
                        String message = "This option is for testing configurations which it is suspected RMIR may exclude\nin error.  It allows creation of macros and special functions with bound buttons\nthat are otherwise unavailable and disables clash highlighting so that all data\nis included in an upload.  If this option is subsequently deselected while the\nsetup contains such normally excluded entries, those entries will get a distinctive\nlight purple highlighting, changing to dark purple when selected.  They are then\nexcluded from an upload but will be included in a saved .rmir file.\n\nThis option is not persistent, it is deselected on every restart of RMIR.\n\nDo you wish to continue?";
                        String string = "Disable Upload Restrictions";
                        reply = NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message, string, 0, 1);
                        if (reply != 0) {
                            disableUploadRestrictionsItem.setSelected(false);
                        }
                    }
                    if (reply == 0 && this.remoteConfig != null) {
                        this.remoteConfig.updateImage();
                        this.refreshTabbedPanes(false);
                        this.currentPanel.repaint();
                    }
                } else if (source == xziteRegItem) {
                    String title = "Editing the Windows Registry for XSight/Nevo remotes";
                    String message = "Enhanced Power Management must be disabled for an XSight/Nevo remote used with RMIR.\nTo change this setting with the Registry Editor (regedit.exe), open it and navigate to the\nfollowing registry key:\n\n" + CommHID.displayRegistryKey() + "\n\nwhere you need to edit the value of \"EnhancedPowerManagementEnabled\" by right-clicking\nit and selecting Modify.  Set it to 0 to disable it or 1 to enable it.  After this change, you\nneed to disconnect the remote from the PC and then reconnect it.\n\nIf you are wanting to re-enable this setting, it can also be done with RMIR with the item\n\"Re-enable Enhanced Power Management\" on the \"XSight operations\" submenu.";
                    JOptionPane.showMessageDialog(null, message, title, 1);
                } else if (source == parseIRDBItem) {
                    this.extractIrdb();
                    RMIRSetup.setSystemFilesItems(this, this.remoteConfig.getRemote());
                } else if (source == getSystemFilesItem) {
                    if (getSystemFilesItem.isSelected()) {
                        String title = "System files";
                        String message = "<html>The system files will be saved to a zip package in an<br>XSight subfolder of the RMIR installation folder on the<br>next download.  This subfolder will be created if it does<br>not exist.</html>";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                    }
                } else if (source == extractSSItem) {
                    this.extractSS();
                } else if (source == analyzeMAXQprotocols) {
                    JP2Analyzer maxq = new JP2Analyzer();
                    maxq.analyze();
                } else if (source == this.rdfPathItem) {
                    File path = this.getRDFPathChoice();
                    if (path == null) {
                        return;
                    }
                    int opt = 1;
                    if (this.remoteConfig != null) {
                        String string = "Do you want to apply this directory change immediately?\n\nYes = the present setup will be reinterpreted with an RDF from the new directory;\nNo = the change will take place when you next open a remote, even within this session;\nCancel = the change will be cancelled.\n\nNote that if you answer Yes, the setup will still have been loaded with the old RDF.\nYou can achieve a similar result by answering No, using File/Save As to save the setup\nwith the old RDF and then opening the saved file, which will open with the new RDF.\nThe best choice between these two methods can depend on how different the RDFs are,\nand what you are trying to achieve.";
                        String title = "Change of RDF Directory";
                        opt = JOptionPane.showConfirmDialog(this, string, title, 1, 3);
                    }
                    if (opt == 2) {
                        return;
                    }
                    properties.setProperty("RDFPath", path);
                    RemoteManager remoteManager = RemoteManager.getRemoteManager();
                    remoteManager.reset();
                    remoteManager.loadRemotes(properties);
                    if (opt == 1) {
                        return;
                    }
                    String rmTitle = this.getTitle();
                    this.remoteConfig.setSavedData();
                    Remote oldRemote = this.remoteConfig.getRemote();
                    Setting[] oldSettings = oldRemote.getSettings();
                    int[] settingValues = new int[oldSettings.length];
                    for (int i = 0; i < oldSettings.length; ++i) {
                        settingValues[i] = oldSettings[i].getValue();
                    }
                    Remote newRemote = RemoteManager.getRemoteManager().findRemoteByName(oldRemote.getName());
                    this.remoteConfig.setRemote(newRemote);
                    for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                        du.setRemote(newRemote);
                    }
                    Setting[] newSettings = newRemote.getSettings();
                    for (int i = 0; i < Math.min(oldSettings.length, newSettings.length); ++i) {
                        newSettings[i].setValue(settingValues[i]);
                    }
                    SetupCode.setMax(newRemote);
                    this.remoteConfig.updateImage();
                    RemoteConfiguration.resetDialogs();
                    this.update();
                    int index = rmTitle.lastIndexOf(oldRemote.getName());
                    this.setTitle(rmTitle.substring(0, index) + newRemote.getName());
                } else if (source == this.mapPathItem) {
                    File path = this.getMapPathChoice();
                    if (path == null) {
                        return;
                    }
                    int opt = 1;
                    if (this.remoteConfig != null) {
                        String string = "Do you want to apply this directory change immediately?\n\nYes = a map and image from the new directory will be used in the present setup;\nNo = the change will take place when you next open a remote, even within this session;\nCancel = the change will be cancelled.";
                        String title = "Change of Map and Image Directory";
                        opt = JOptionPane.showConfirmDialog(this, string, title, 1, 3);
                    }
                    if (opt == 2) {
                        return;
                    }
                    properties.setProperty("ImagePath", path);
                    if (this.remoteConfig == null) {
                        return;
                    }
                    Remote remote = this.remoteConfig.getRemote();
                    remote.resetImageMaps(path);
                } else if (source == this.addonPathItem) {
                    File path = this.getAddonPathChoice();
                    if (path != null) {
                        String message = "The default path for Add-ons is the AddOns subfolder of the \nRMIR installation folder.  You have changed it to:\n\n" + path.getAbsolutePath() + "\n\nThis change will take place when you next open RMIR.";
                        String string = "Change of Add-ons Directory";
                        JOptionPane.showMessageDialog(this, message, string, 1);
                    }
                } else if (source == this.registerRfRemoteItem) {
                    String title = "Registration of RF Remote";
                    String message = null;
                    LinkedHashMap<String, Integer> linkedHashMap = RfTools.getIndexMap();
                    for (int index : linkedHashMap.values()) {
                        if (properties.getProperty("RfRemote." + index + ".extAddr") != null) continue;
                        String name = properties.getProperty("RfRemote." + index + ".name");
                        message = "Registration is a two-step process.  The first step creates a provisional\nregistration that needs to be completed by loading into RF Tools a .psd\nPacket Sniffer file that captures a pairing request from the remote.\n\nThere can be at most one registration in a provisional state and currently\nthere is one, named " + name + ".  That one needs to be completed, or deleted\nwith RF Tools, before you can register another.";
                        JOptionPane.showMessageDialog(this, message, title, 2);
                        return;
                    }
                    message = "This remote has RF support and is currently paired with an RF device.\nTo use this remote with RF Tools, the remote and its pairing needs to be\nregistered in RMIR as an RF Remote.  This is a two-step process.\n\nThe first step is to enter a name for it in the box below and press OK.\nThis creates a provisional registration.  The second step is to load into\nRF Tools a .psd Packet Sniffer file that captures a pairing request from\nthe remote.  The two steps need not be performed in the same RMIR session.";
                    String reply = "";
                    while (reply != null && reply.trim().isEmpty()) {
                        reply = JOptionPane.showInputDialog(this, message, title, -1);
                    }
                    if (reply == null) {
                        message = "Registration aborted.";
                        JOptionPane.showMessageDialog(this, message, title, 2);
                        return;
                    }
                    String name = reply.trim();
                    if (linkedHashMap.get(name) != null) {
                        message = "There is already a registration with name " + name + ".  Please try again,\neither with a different name or after deleting the existing registration\nwith RF Tools.";
                        JOptionPane.showMessageDialog(this, message, title, 0);
                        return;
                    }
                    Remote remote = this.remoteConfig.getRemote();
                    RfRemote rfRemote = new RfRemote();
                    rfRemote.name = reply.trim();
                    List<RfRemote.Pairing> pairings = rfRemote.pairings;
                    int rfCodeCount = remote.getRfSetupCodes().size();
                    if (this.remoteConfig.getSegments().get(32) == null && this.remoteConfig.getRfData() != null) {
                        Hex table = new Hex(this.remoteConfig.getRfData());
                        pairings.add(new RfRemote.Pairing(table));
                    } else {
                        for (Segment seg : this.remoteConfig.getSegments().get(32)) {
                            short nvid = seg.getHex().getData()[1];
                            short pairRef = seg.getHex().getData()[2];
                            if (nvid < 36 || nvid >= 36 + rfCodeCount || pairRef == 255) continue;
                            pairings.add(new RfRemote.Pairing(seg.getHex().subHex(2)));
                        }
                    }
                    if (this.remoteConfig.getSegments().get(43) != null) {
                        Hex segData = this.remoteConfig.getSegments().get(43).get(0).getHex();
                        rfRemote.vendorID = new Hex(2);
                        rfRemote.vendorID.getData()[0] = segData.subHex(2, 2).getData()[1];
                        rfRemote.vendorID.getData()[1] = segData.subHex(2, 2).getData()[0];
                        rfRemote.vendorString = segData.subHex(4, 7);
                        rfRemote.userString = segData.subHex(11, 15);
                    }
                    rfRemote.changed = true;
                    if (this.rfTools == null) {
                        this.rfTools = new RfTools(this);
                    }
                    this.rfTools.updateRegistration(rfRemote);
                    message = "RF Remote named " + rfRemote.name + " has been provisionally registered.\n\nTo complete the registration, load into RF Tools a .psd Packet Sniffer file\nthat captures a pairing request from the remote.  RMIR preserves the provisional\nregistration, so you can exit and do this in a later session if you wish.";
                    JOptionPane.showMessageDialog(this, message, title, 1);
                } else if (source == this.updateItem) {
                    UpdateChecker.checkUpdateAvailable(this);
                } else if (source == importIctAsLearned) {
                    DeviceUpgradeConverter.importIctAsLearned(this);
                } else if (source == openRmasterErr) {
                    JP1Frame.browse(RemoteMaster.getErrorsFile().toURI());
                } else if (source == this.aboutItem) {
                    StringBuilder sb = new StringBuilder(1000);
                    sb.append("<html><b>RM Setup Editor (RMIR) ");
                    sb.append(RemoteMaster.getDisplayVersion());
                    sb.append(RemoteMaster.admin ? " (admin mode)" : "");
                    sb.append("</b>");
                    sb.append("<p>Written originally by Greg&nbsp;Bush with help from ");
                    sb.append("John&nbsp;S&nbsp;Fine, Nils&nbsp;Ekberg, Jon&nbsp;Armstrong, Robert&nbsp;Crowe, ");
                    sb.append("Mark&nbsp;Pauker, Mark&nbsp;Pierson and Mike&nbsp;England.</p>");
                    sb.append("<p>Subsequently developed by Graham Dixon with help from Ross&nbsp;Day, ");
                    sb.append("Marcin&nbsp;Jaworski, Bengt&nbsp;Martensson and Dave&nbsp;Reed.</p>");
                    sb.append("<p>Incorporates IrpTransmogrifier by Bengt&nbsp;Martensson.</p>");
                    sb.append("<p>RDFs loaded from <b>");
                    sb.append(properties.getProperty("RDFPath"));
                    sb.append("</b></p>");
                    sb.append("</p><p>Images and Maps loaded from <b>");
                    sb.append(properties.getProperty("ImagePath"));
                    sb.append("</b></p>");
                    sb.append("<p>Girr version ");
                    sb.append("2.2.14");
                    sb.append("<br/>");
                    if ("2.2.14".contains("SNAPSHOT")) {
                        sb.append("Girr commit id: " + RemoteMaster.getGirrCommitId());
                        sb.append("<br/>");
                    }
                    sb.append("IrpTransmogrifier version ");
                    sb.append("1.2.14");
                    sb.append("<br/>");
                    if ("1.2.14".contains("SNAPSHOT")) {
                        sb.append("IrpTransmogrifier commit id: " + RemoteMaster.getIrpTransmogrifierCommitId());
                        sb.append("<br/>");
                    }
                    sb.append("IrpProtocols version ");
                    sb.append(LearnedSignal.getTmDatabase().getConfigFileVersion());
                    sb.append("<br/>");
                    if (LearnedSignal.hasDecodeIR()) {
                        sb.append("DecodeIR version ");
                        sb.append(LearnedSignal.getDecodeIRVersion());
                        sb.append("</p>");
                    } else {
                        sb.append("<p><b>DecodeIR is not available!</b></p>");
                    }
                    if (!this.interfaces.isEmpty()) {
                        sb.append("<p>Interfaces:<ul>");
                        for (IO iO : this.interfaces) {
                            sb.append("<li>");
                            sb.append(iO.getInterfaceName());
                            sb.append(" version ");
                            sb.append(iO.getInterfaceVersion());
                            sb.append("</li>");
                        }
                        sb.append("</ul></p>");
                    }
                    String[] propertyNames = new String[]{"java.version", "java.vendor", "os.name", "os.arch"};
                    sb.append("<p>System Properties:<ul>");
                    for (String name : propertyNames) {
                        sb.append("<li>");
                        sb.append(name);
                        sb.append(" = \"");
                        sb.append(System.getProperty(name));
                        sb.append("\"</li>");
                    }
                    sb.append("</ul>");
                    sb.append("<p>Libraries loaded from ");
                    sb.append(LibraryLoader.getLibraryFolder());
                    sb.append("</p></html>");
                    JEditorPane jEditorPane = new JEditorPane("text/html", sb.toString());
                    jEditorPane.addHyperlinkListener(this);
                    jEditorPane.setEditable(false);
                    jEditorPane.setBackground(this.getContentPane().getBackground());
                    new TextPopupMenu(jEditorPane);
                    this.scroll = new JScrollPane(jEditorPane);
                    Dimension d = jEditorPane.getPreferredSize();
                    d.height = d.height * 4 / 5;
                    d.width = d.width * 1 / 2;
                    this.scroll.setPreferredSize(d);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RMIRSetup.this.scroll.getVerticalScrollBar().setValue(0);
                            RMIRSetup.this.scroll.getHorizontalScrollBar().setValue(0);
                        }
                    });
                    JOptionPane.showMessageDialog(this, this.scroll, "About RMIR", 1, null);
                } else if (source == this.readmeItem) {
                    File readme = new File(RemoteMaster.getWorkDir(), "Readme.html");
                    RMIRSetup.browse(readme.toURI());
                } else if (source == this.tutorialItem) {
                    URL url = new URL("http://www.hifi-remote.com/wiki/index.php?title=JP1_-_Just_How_Easy_Is_It%3F_-_RM-IR_Version");
                    RMIRSetup.browse(url);
                } else if (source == this.rmpbReadmeItem) {
                    File rmpbReadme = new File(RemoteMaster.getWorkDir(), "RMPB_Readme.html");
                    RMIRSetup.browse(rmpbReadme.toURI());
                } else if (source == this.learnedSignalItem) {
                    File file = new File(RemoteMaster.getWorkDir(), "DecodeIR.html");
                    RMIRSetup.browse(file.toURI());
                } else if (source == this.irpProtocolsItem) {
                    File file = new File(RemoteMaster.getWorkDir(), "RMProtocols.html");
                    RMIRSetup.browse(file.toURI());
                } else if (source == this.homePageItem) {
                    URL url = new URL("https://controlremote.sourceforge.io/");
                    RMIRSetup.browse(url.toURI());
                } else if (source == this.wikiItem) {
                    URL url = new URL("http://www.hifi-remote.com/wiki/index.php?title=Main_Page");
                    RMIRSetup.browse(url.toURI());
                } else if (source == this.forumItem) {
                    URL url = new URL("http://www.hifi-remote.com/forums/");
                    RMIRSetup.browse(url);
                } else if (source == this.irpTransmogrifierItem) {
                    System.err.println("Setting IrpTransmogrifier as decoder for Learned Signals");
                    if (this.irpTransmogrifierItem.isSelected()) {
                        properties.remove("UseDecodeIR");
                    }
                    if (this.learnedPanel != null) {
                        this.learnedPanel.refresh();
                        this.learnedPanel.getModel().fireTableDataChanged();
                    }
                } else if (source == this.decodeIRItem) {
                    System.err.println("Setting DecodeIR as decoder for Learned Signals");
                    if (this.decodeIRItem.isSelected()) {
                        properties.setProperty("UseDecodeIR", "true");
                    }
                    if (this.learnedPanel != null) {
                        this.learnedPanel.refresh();
                        this.learnedPanel.getModel().fireTableDataChanged();
                    }
                } else if (source == this.exportToGirrItem) {
                    this.remoteConfig.exportToGirrFile();
                } else if (source == showXziteFileDataItem) {
                    this.refreshTabbedPanes(true);
                } else {
                    validationIndex = Arrays.asList(validations).indexOf(source);
                    if (validationIndex >= 0) {
                        JRadioButtonMenuItem item = (JRadioButtonMenuItem)source;
                        if (item.isSelected()) {
                            if (validationIndex == 0) {
                                properties.remove("Validation");
                                this.validationOverride = null;
                            } else {
                                properties.setProperty("Validation", item.getText());
                                this.validationOverride = Remote.SetupValidation.values()[validationIndex - 1];
                            }
                            if (this.generalPanel != null) {
                                this.generalPanel.setWarning();
                            }
                        }
                    } else {
                        JMenuItem item = (JMenuItem)source;
                        File file = new File(item.getActionCommand());
                        this.recentFiles.remove(item);
                        if (file.canRead()) {
                            this.openFile(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private void createRDFInfoFile() throws IOException {
        RMFileChooser chooser = this.getFileSaveChooser(new EndingFileFilter("CSV file (*.csv)", infoFileEndings));
        chooser.setDialogTitle("Select RDF Info file");
        String rdfInfoPath = properties.getProperty("rdfInfoFile");
        if (rdfInfoPath != null) {
            rdfInfoFile = new File(rdfInfoPath);
        }
        if (rdfInfoFile != null) {
            chooser.setSelectedFile(rdfInfoFile);
        }
        int returnVal = -1;
        try {
            returnVal = chooser.showSaveDialog(this);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (returnVal == 0) {
            String ending = ((EndingFileFilter)chooser.getFileFilter()).getEndings()[0];
            String name = chooser.getSelectedFile().getAbsolutePath();
            if (!name.toLowerCase().endsWith(ending)) {
                name = name + ending;
            }
            if ((rdfInfoFile = new File(name)).exists() && JOptionPane.showConfirmDialog(this, name + " already exists.  Do you want to replace it?", "Replace existing file?", 0) != 0) {
                JOptionPane.showMessageDialog(this, "File creation cancelled by user", "RDF Info File", 1);
                return;
            }
        } else {
            return;
        }
        properties.setProperty("rdfInfoFile", rdfInfoFile.getAbsolutePath());
        ArrayList<Remote> allRemotes = new ArrayList<Remote>();
        allRemotes.addAll(RemoteManager.getRemoteManager().getRemotes());
        Collections.sort(allRemotes);
        ArrayList<Object> extenderNames = new ArrayList<Object>();
        ArrayList<Remote> unextendedRemotes = new ArrayList<Remote>();
        for (Remote rm : allRemotes) {
            String rmName = rm.getName();
            if (rmName.toUpperCase().contains("EXTENDER") || rmName.toUpperCase().contains(" EXT ")) {
                extenderNames.add(rmName);
                continue;
            }
            if (rmName.equals("Learned Signal Importer")) continue;
            unextendedRemotes.add(rm);
        }
        ArrayList<String> extendedRemoteNames = new ArrayList<String>();
        boolean isPrelimLoad = Remote.prelimLoad;
        Remote.prelimLoad = true;
        for (String string : extenderNames) {
            int ndx = string.toUpperCase().indexOf("EXT");
            String str = string.substring(0, ndx).trim();
            for (Remote rm : unextendedRemotes) {
                String rmName = rm.getName();
                if (!rmName.startsWith(str) || extendedRemoteNames.contains(rmName)) continue;
                extendedRemoteNames.add(rmName);
            }
        }
        FileWriter fw = new FileWriter(rdfInfoFile);
        PrintWriter printWriter = new PrintWriter(fw);
        printWriter.println("Name,Processor,Interface,Signature,Extender?");
        for (Remote rm : unextendedRemotes) {
            String hasExtender = extendedRemoteNames.contains(rm.getName()) ? "Y" : "N";
            try {
                rm.load();
                printWriter.println(rm.getName() + "," + rm.getProcessorDescription() + "," + rm.getInterfaceType() + "," + rm.getSignature() + "," + hasExtender);
            }
            catch (Exception ex) {
                System.err.println("Exception in RDF " + rm.getName());
            }
        }
        Remote.prelimLoad = isPrelimLoad;
        printWriter.close();
        fw.close();
        JOptionPane.showMessageDialog(this, "File created: " + rdfInfoFile.getAbsolutePath(), "RDF Info File", 1);
    }

    public void update() {
        if (this.remoteConfig == null) {
            this.setTitle("RMIR");
            this.importFromWavMergeItem.setEnabled(false);
            this.exportToWavSubMenu.setEnabled(false);
            this.exportToGirrItem.setEnabled(false);
            this.createSummaryItem.setEnabled(false);
            this.createSelectionItem.setEnabled(false);
            return;
        }
        this.setTitle("RMIR - " + this.remoteConfig.getRemote().getName());
        this.importFromWavMergeItem.setEnabled(this.remoteConfig.getRemote().supportWaveUpgrade());
        this.exportToWavSubMenu.setEnabled(this.remoteConfig.getRemote().supportWaveUpgrade());
        this.exportToGirrItem.setEnabled(true);
        this.createSummaryItem.setEnabled(true);
        this.createSelectionItem.setEnabled(true);
        this.resetTabbedPanes();
        this.generalPanel.set(this.remoteConfig);
        this.keyMovePanel.set(this.remoteConfig);
        this.macroPanel.set(this.remoteConfig);
        this.globalPTPanel.set(this.remoteConfig);
        this.specialFunctionPanel.set(this.remoteConfig);
        this.timedMacroPanel.set(this.remoteConfig);
        this.favScanPanel.set(this.remoteConfig);
        this.favoritesPanel.set(this.remoteConfig);
        this.devicePanel.set(this.remoteConfig);
        this.protocolPanel.set(this.remoteConfig);
        this.activityPanel.set(this.remoteConfig);
        this.segmentPanel.set(this.remoteConfig);
        this.learnedPanel.set(this.remoteConfig);
        this.xsightFileDataPanel.set(this.remoteConfig);
        Remote remote = this.remoteConfig.getRemote();
        this.codesAction.setEnabled(remote.getSetupCodes().size() > 0);
        if (this.codeSelectorDialog != null) {
            if (this.codeSelectorDialog.isDisplayable()) {
                this.codeSelectorDialog.dispose();
            }
            this.codeSelectorDialog = null;
        }
        if (this.rdfViewer != null) {
            if (this.rdfViewer.isDisplayable()) {
                this.rdfViewer.dispose();
            }
            this.rdfViewer = null;
        }
        this.exportToWavUpgradesItem.setVisible(remote.getUpgradeAddress() != null);
        this.exportToWavTimedMacrosItem.setVisible(remote.getTimedMacroAddress() != null);
        this.exportToWavLearnedItem.setVisible(remote.getLearnedAddress() != null);
        this.updateUsage();
        this.rawDataPanel.set(this.remoteConfig);
    }

    private void resetTabbedPanes() {
        Remote remote = this.remoteConfig.getRemote();
        int index = this.checkTabbedPane("Key Moves", this.keyMovePanel, remote.hasKeyMoveSupport(), 1);
        index = this.checkTabbedPane("Macros", this.macroPanel, remote.getMacroSupport() > 0, index);
        index = this.checkTabbedPane("Global Punchthru", this.globalPTPanel, remote.hasGlobalPunchthruSupport(), index);
        index = this.checkTabbedPane("Special Functions", this.specialFunctionPanel, !remote.getSpecialProtocols().isEmpty(), index);
        index = this.checkTabbedPane("Timed Macros", this.timedMacroPanel, remote.hasTimedMacroSupport(), index);
        index = this.checkTabbedPane("Fav/Scan", this.favScanPanel, remote.hasFavKey() && !remote.hasFavorites() && !remote.isSSD(), index);
        index = this.checkTabbedPane("Favorites", this.favoritesPanel, remote.hasFavorites(), index);
        index = this.checkTabbedPane("Devices", this.devicePanel, !remote.isIctImporter(), index);
        index = this.checkTabbedPane("Protocols", this.protocolPanel, remote.hasFreeProtocols(), index);
        index = this.checkTabbedPane("Activities", this.activityPanel, remote.hasActivitySupport(), index);
        index = this.checkTabbedPane("Learned Signals", this.learnedPanel, remote.hasLearnedSupport() && this.learnedPanel != null, index);
        index = this.checkTabbedPane("Segments", this.segmentPanel, showSegmentEditorItem.isSelected() && remote.getSegmentTypes() != null && !remote.isSSD(), index);
        index = this.checkTabbedPane("XSight File Data", this.xsightFileDataPanel, showXziteFileDataItem.isSelected() && remote.isSSD(), index);
    }

    protected void refreshTabbedPanes(boolean reset) {
        if (reset) {
            this.resetTabbedPanes();
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ((RMPanel)this.tabbedPane.getComponentAt(i)).refresh();
        }
    }

    private int checkTabbedPane(String name, Component c, boolean test, int index) {
        return this.checkTabbedPane(name, c, test, index, null, true);
    }

    private int checkTabbedPane(String name, Component c, boolean test, int index, String tooltip, boolean enabled) {
        if (c == null) {
            return index;
        }
        int tabIndex = this.getTabIndex(c);
        if (test) {
            if (tabIndex < 0) {
                this.tabbedPane.insertTab(name, null, c, tooltip, index);
                this.tabbedPane.setEnabledAt(index, enabled);
            }
            ++index;
        } else if (tabIndex > 0) {
            this.tabbedPane.remove(index);
        }
        return index;
    }

    private boolean updateUsage(JProgressBar bar, AddressRange range) {
        if (this.pbForegroundColor == null) {
            this.pbForegroundColor = RemoteMaster.defaultPBForegroundColor;
        }
        if (range != null) {
            int used = range.getFreeStart() - range.getStart() + range.getEnd() - range.getFreeEnd();
            int available = range.getSize();
            bar.setMinimum(0);
            bar.setMaximum(available);
            bar.setValue(used);
            bar.setString(Integer.toString(available - used) + " free");
            if (range == this.remoteConfig.getRemote().getDeviceUpgradeAddress() || range.getFreeEnd() == range.getEnd()) {
                if (this.pbForegroundColor != null) {
                    bar.setForeground(this.pbForegroundColor);
                }
            } else {
                bar.setForeground(Color.YELLOW);
            }
            return available >= used;
        }
        bar.setMinimum(0);
        bar.setMaximum(0);
        bar.setValue(0);
        bar.setString("N/A");
        if (this.pbForegroundColor != null) {
            bar.setForeground(this.pbForegroundColor);
        }
        return true;
    }

    private void updateBleStatus() {
        BLERemote rem = this.btio.getBleRemote();
        this.batteryBar.setBars(rem.batteryBars);
        this.batteryVoltage.setText(String.format("(%4.2fv)", rem.batteryVoltage));
        int sigValue = rem.signalStrength == 1 ? this.signalProgressBar.getMinimum() : rem.signalStrength;
        String sigString = rem.signalStrength == 1 ? "N/A" : rem.signalStrength + "dBm";
        this.signalProgressBar.setValue(sigValue);
        this.signalProgressBar.setString(sigString);
    }

    private boolean updateUsage() {
        AddressRange range;
        boolean valid = true;
        Remote remote = this.remoteConfig.getRemote();
        Dimension d = this.advProgressBar.getPreferredSize();
        Font font = this.advProgressBar.getFont();
        this.bleStatus.setVisible(this.btio != null);
        if (this.remoteConfig.hasSegments()) {
            this.extraStatus.setVisible(false);
            this.advProgressLabel.setText("Memory usage:");
        } else if (remote.getDeviceUpgradeAddress() == null) {
            this.upgradeProgressBar.setVisible(false);
            this.upgradeProgressBar.setPreferredSize(d);
            this.upgradeProgressBar.setFont(font);
            this.upgradeProgressBar.setVisible(true);
            this.devUpgradeProgressBar.setVisible(false);
            this.extraStatus.setVisible(true);
            this.advProgressLabel.setText("Move/Macro:");
        } else {
            d.height /= 2;
            Font font2 = font.deriveFont((float)font.getSize() * 0.75f);
            this.upgradeProgressBar.setVisible(false);
            this.upgradeProgressBar.setPreferredSize(d);
            this.upgradeProgressBar.setFont(font2);
            this.upgradeProgressBar.setVisible(true);
            this.devUpgradeProgressBar.setVisible(false);
            this.devUpgradeProgressBar.setPreferredSize(d);
            this.devUpgradeProgressBar.setFont(font2);
            this.devUpgradeProgressBar.setVisible(true);
            this.extraStatus.setVisible(true);
            this.advProgressLabel.setText("Move/Macro:");
        }
        if (this.btio != null && this.btio.getBleRemote() != null) {
            this.updateBleStatus();
        }
        String title = "Available Space Exceeded";
        String message = "";
        AddressRange addressRange = range = this.remoteConfig.hasSegments() ? remote.getUsageRange() : remote.getAdvancedCodeAddress();
        if (!this.updateUsage(this.advProgressBar, range)) {
            valid = false;
            message = range.getFreeEnd() == range.getEnd() ? "The defined advanced codes (keymoves, macros, special functions etc.) use more space than is available.  Please remove some." : "There is insufficient space in the advanced codes section for both the defined\nadvanced codes (keymoves, macros, special functions etc.) and the device\nupgrades that have overflowed from their own section.  Please remove some entries.";
            this.showErrorMessage(message, title);
        }
        if (!this.updateUsage(this.timedMacroPanel.timedMacroProgressBar, remote.getTimedMacroAddress())) {
            valid = false;
            message = "The defined timed macros use more space than is available.  Please remove some.";
            this.showErrorMessage(message, title);
        }
        if (!this.updateUsage(this.upgradeProgressBar, remote.getUpgradeAddress())) {
            valid = false;
            message = "The defined device upgrades use more space than is available. Please remove some.";
            this.showErrorMessage(message, title);
        }
        if (!this.updateUsage(this.devUpgradeProgressBar, remote.getDeviceUpgradeAddress())) {
            valid = false;
            message = "The defined button-dependent device upgrades use more space than is available. Please remove some.";
            this.showErrorMessage(message, title);
        }
        if (!this.updateUsage(this.learnedProgressBar, range = remote.getLearnedAddress())) {
            valid = false;
            message = range.getFreeEnd() == range.getEnd() ? "The defined learned signals use more space than is available.  Please remove some." : "There is insufficient space in the learned signals section for both the defined\nlearned signals and the device upgrades that have overflowed from their own\nsection.  Please remove some entries.";
            this.showErrorMessage(message, title);
        }
        if (this.btio != null && this.btio.getBleRemote() != null) {
            this.batteryBar.setBars(this.btio.getBleRemote().batteryBars);
        }
        return valid;
    }

    private void showErrorMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private void showHIDMessage(String name) {
        String title = "HID Interface";
        String message = "The change of HID Interface to \"" + name + "\" will take effect\nthe next time you open RMIR.";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public static boolean fileFilterChangeEvent(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (!(source instanceof RMFileChooser)) {
            return false;
        }
        RMFileChooser chooser = (RMFileChooser)source;
        String prop = event.getPropertyName();
        if (prop != "fileFilterChanged") {
            return true;
        }
        BasicFileChooserUI bui = (BasicFileChooserUI)chooser.getUI();
        String name = bui.getFileName();
        String currentDir = bui.getDirectoryName();
        FileFilter[] filters = chooser.getChoosableFileFilters();
        String ending = ((EndingFileFilter)chooser.getFileFilter()).getEndings()[0];
        boolean hasExtension = false;
        if (!name.toLowerCase().endsWith(ending)) {
            for (FileFilter filter : filters) {
                String end = ((EndingFileFilter)filter).getEndings()[0];
                if (!name.toLowerCase().endsWith(end)) continue;
                hasExtension = true;
                break;
            }
            if (hasExtension) {
                int dot = name.lastIndexOf(46);
                name = name.substring(0, dot);
            }
            name = name + ending;
        }
        File newFile = new File(currentDir, name);
        chooser.setSelectedFile(newFile);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (RMIRSetup.fileFilterChangeEvent(event)) {
            return;
        }
        if (event.getPropertyName().equals("activityState")) {
            this.remoteConfig.updateImage();
            this.segmentPanel.set(this.remoteConfig);
            this.rawDataPanel.set(this.remoteConfig);
            if (!((Boolean)event.getNewValue()).booleanValue()) {
                ActivityFunctionTableModel model = this.activityPanel.getActivityFunctionModel();
                for (Button b : this.remoteConfig.getActivities().keySet()) {
                    Button selector = this.remoteConfig.getActivities().get(b).getSelector();
                    model.set(b, this.remoteConfig);
                    model.setValueAt(selector.getKeyCode(), 0, 1);
                }
            }
            return;
        }
        if (this.currentPanel == this.keyMovePanel) {
            ((KeyMoveTableModel)this.keyMovePanel.getModel()).resetKeyMoves();
            this.keyMovePanel.repaint();
        }
        if (this.currentPanel == this.activityPanel && event.getPropertyName().equals("tabs")) {
            this.activityPanel.set(this.remoteConfig);
        }
        if (this.currentPanel == this.generalPanel && this.generalPanel.getCreateUpgradesButton().isVisible()) {
            this.generalPanel.getCreateUpgradesButton().setEnabled(this.remoteConfig.getCreatableMissingCodes() != null);
        }
        this.remoteConfig.updateImage();
        this.updateUsage();
        this.hasInvalidCodes = this.generalPanel.setWarning();
        if (!event.getPropertyName().equals("highlight")) {
            this.changed = true;
        }
        if (this.currentPanel == this.generalPanel && this.remoteConfig.hasSegments() && this.remoteConfig.getRemote().hasSettings()) {
            this.generalPanel.repaint();
        }
        if (this.currentPanel == this.macroPanel && this.remoteConfig.hasSegments() && (event.getPropertyName().equals("order") || event.getPropertyName().equals("data"))) {
            this.macroPanel.repaint();
        }
        if (this.currentPanel == this.specialFunctionPanel && this.remoteConfig.hasSegments() && (event.getPropertyName().equals("order") || event.getPropertyName().equals("data"))) {
            this.specialFunctionPanel.repaint();
        }
        if (this.currentPanel == this.learnedPanel && this.remoteConfig.hasSegments() && (event.getPropertyName().equals("order") || event.getPropertyName().equals("data"))) {
            this.learnedPanel.repaint();
        }
    }

    private boolean allowSave(Remote.SetupValidation setupValidation) {
        if (!this.hasInvalidCodes) {
            return true;
        }
        Remote remote = this.remoteConfig.getRemote();
        String title = "Setup configuration";
        if (setupValidation == Remote.SetupValidation.WARN) {
            String message = "The current setup contains invalid device codes";
            if (remote.usesEZRC()) {
                message = message + "\nor devices without a matching device upgrade";
            }
            return NegativeDefaultButtonJOptionPane.showConfirmDialog(this, message = message + ".\n\nAre you sure you wish to continue?", title, 0, 3) == 0;
        }
        if (setupValidation == Remote.SetupValidation.ENFORCE) {
            String message = "The current setup contains invalid device codes\nwhich would cause this remote to malfunction.\nPlease correct these codes and try again.";
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
        return false;
    }

    public static boolean isValidUpgradeSource(File f, Remote remote) {
        String prefix;
        if (remote == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        if (!name.startsWith(prefix = "Sys" + remote.getSignature().substring(3) + "_") || !name.endsWith(".bin")) {
            return false;
        }
        String body = name.substring(8, name.length() - 4);
        return body.matches("\\d{6}(\\.\\d+)??");
    }

    public List<AssemblerItem> getClipBoardItems() {
        return this.clipBoardItems;
    }

    public static File getUpgradeSource() {
        return upgradeSource;
    }

    public static void clearUpgradeSource() {
        upgradeSource = null;
    }

    public static LanguageDescriptor getUpgradeLanguage() {
        return upgradeLanguage;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.finishEditing();
        RMPanel newPanel = (RMPanel)this.tabbedPane.getSelectedComponent();
        if (newPanel != this.currentPanel) {
            newPanel.set(this.remoteConfig);
            this.currentPanel = newPanel;
            this.highlightAction.setEnabled(false);
        }
        if (this.codeSelectorDialog != null) {
            this.codeSelectorDialog.enableAssign(this.currentPanel == this.generalPanel);
        }
    }

    private int getTabIndex(Component c) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getComponentAt(i).equals(c)) continue;
            return i;
        }
        return -1;
    }

    public RemoteConfiguration getRemoteConfiguration() {
        return this.remoteConfig;
    }

    public GeneralPanel getGeneralPanel() {
        return this.generalPanel;
    }

    public KeyMovePanel getKeyMovePanel() {
        return this.keyMovePanel;
    }

    public DeviceUpgradePanel getDeviceUpgradePanel() {
        return this.devicePanel;
    }

    public FavoritesPanel getFavoritesPanel() {
        return this.favoritesPanel;
    }

    public ActivityPanel getActivityPanel() {
        return this.activityPanel;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean promptToSave() throws IOException {
        return this.promptToSave(false);
    }

    public boolean promptToSave(boolean doExit) throws IOException {
        if (suppressConfirmPrompts.isSelected() || !this.changed) {
            return true;
        }
        int rc = JOptionPane.showConfirmDialog(this, "The data has changed.  Do you want to save\nthe current configuration before proceeding?", "Save upgrade?", 1);
        if (rc == 2 || rc == -1) {
            return false;
        }
        if (rc == 1) {
            return true;
        }
        this.exitPrompt = doExit;
        if (this.saveAction.isEnabled()) {
            this.save(this.file, false);
        } else {
            this.saveAs();
        }
        return true;
    }

    private void finishEditing() {
        if (this.currentPanel instanceof RMTablePanel) {
            RMTablePanel panel = (RMTablePanel)this.currentPanel;
            panel.finishEditing();
        } else if (this.currentPanel == this.generalPanel) {
            this.generalPanel.finishEditing();
        } else if (this.currentPanel == this.activityPanel) {
            this.activityPanel.finishEditing();
        }
    }

    private void extractSS() {
        int numBytes;
        int n;
        int numBytes2;
        JPS io = this.binLoaded();
        if (io == null) {
            return;
        }
        Scanner s = io.getScanner();
        if (s == null) {
            String title = "Parsing error";
            String message = "Unable to interpret settings data.  Extraction failed.";
            JOptionPane.showMessageDialog(this, message, title, 1);
            return;
        }
        LinkedHashMap<Integer, List<Integer>> setups = new LinkedHashMap<Integer, List<Integer>>();
        LinkedHashMap<Integer, Integer> pidLenBytes = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> mapNumBytes = new LinkedHashMap<Integer, Integer>();
        ArrayList<Integer> prots = new ArrayList<Integer>();
        ArrayList<Integer> maps = new ArrayList<Integer>();
        short[] bufSetup = new short[4 * s.getSetupCodeCount()];
        short[] bufType = new short[2 * s.getSetupTypeCount() + 2];
        short[] bufExec = new short[4 * s.getExecutorCount()];
        short[] bufNum = new short[10 * s.getNumberTableSize()];
        io.readRemote(s.getSetupCodeIndexAddress() + 2, bufSetup);
        io.readRemote(s.getSetupTypeIndexAddress(), bufType);
        io.readRemote(s.getExecutorIndexAddress() + 2, bufExec);
        io.readRemote(s.getNumberTableAddress(), bufNum);
        for (int i = 0; i < s.getExecutorCount(); ++i) {
            int pid = bufExec[2 * i] | bufExec[2 * i + 1] << 8;
            prots.add(pid);
            int n2 = 2 * (s.getExecutorCount() + i);
            int protAddress = (bufExec[n2] | bufExec[n2 + 1] << 8) + s.getIndexTablesOffset();
            short[] buf2 = new short[2];
            if (io.readRemote(protAddress + 2, buf2) != 2) continue;
            pidLenBytes.put(pid, Integer.valueOf(buf2[0]));
        }
        int type = -1;
        int typeLimit = (bufType[2 * type + 2] | bufType[2 * type + 3] << 8) * 2;
        int mask = s.setupCodeIncludesType() ? 4095 : 65535;
        for (int i = 0; i < s.getSetupCodeCount(); ++i) {
            int codeAddress = s.getSetupCodeIndexAddress() + 2 + 2 * i;
            if (codeAddress == typeLimit) {
                typeLimit = (bufType[2 * ++type + 2] | bufType[2 * type + 3] << 8) * 2;
            }
            int setupCode = bufSetup[2 * i] | bufSetup[2 * i + 1] << 8;
            ArrayList<Integer> codeList = (ArrayList<Integer>)setups.get(type);
            if (codeList == null) {
                codeList = new ArrayList<Integer>();
                setups.put(type, codeList);
            }
            codeList.add(setupCode & mask);
            int n3 = 2 * (s.getSetupCodeCount() + i);
            int setupAddress = (bufSetup[n3] | bufSetup[n3 + 1] << 8) + s.getIndexTablesOffset();
            short[] buf = new short[4];
            io.readRemote(setupAddress, buf);
            int pid = buf[0] << 8 | buf[1];
            short map = buf[2];
            if (map <= 0 || pidLenBytes.get(pid) == null) continue;
            mapNumBytes.put(map - 1, pidLenBytes.get(pid) & 0xF);
        }
        for (n = 0; n < bufNum.length / 10; n += numBytes2) {
            numBytes2 = mapNumBytes.get(n) != null ? (Integer)mapNumBytes.get(n) : 1;
            short[] digitKeyCodes = Arrays.copyOfRange(bufNum, 10 * n, 10 * (n + numBytes2));
            int m = DigitMaps.findDigitMapNumber(digitKeyCodes);
            for (int j = 0; j < numBytes2; ++j) {
                maps.add(m >= 0 ? m + j : -1);
            }
        }
        System.err.println();
        System.err.println("DATA EXTRACT FOR RDF FOR SIGNATURE " + io.getRemoteSignature() + ":");
        System.err.println(String.format("EepromSize=$%04X", io.getRemoteEepromSize()));
        System.err.println(String.format("BaseAddress=$%04X", io.getRemoteEepromAddress()));
        this.printExtract(setups, pidLenBytes, prots, maps);
        System.err.println("Raw number table data:");
        for (n = 0; n < bufNum.length / 10; n += numBytes) {
            numBytes = mapNumBytes.get(n) != null ? (Integer)mapNumBytes.get(n) : 1;
            for (int i = 0; i < 10 * numBytes; ++i) {
                System.err.print(String.format("%02x ", bufNum[10 * n + i]));
            }
            System.err.println();
        }
        System.err.println();
        String title = "Extract for RDF";
        String message = "Extract data, including [Protocols] and [SetupCodes] sections\nfor the RDF, have been output to rmaster.err";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    private void extractIrdb() {
        Remote remote = this.remoteConfig.getRemote();
        ZipFile zipfile = RMIRSetup.getSystemZipFile(remote);
        ZipEntry entry = null;
        byte[] data = null;
        if (zipfile != null && (entry = zipfile.getEntry("irdb.bin")) != null) {
            try {
                data = RMIRSetup.readBinary(zipfile.getInputStream(entry), (int)entry.getSize());
                zipfile.close();
            }
            catch (Exception e) {
                entry = null;
            }
        }
        if (entry == null) {
            String title = "Extract irdb.bin";
            String message = "File irdb.bin not found so extract process has been aborted";
            JOptionPane.showMessageDialog(this, message, title, 1);
            return;
        }
        int pos = 0;
        LinkedHashMap<Integer, List<Integer>> setups = new LinkedHashMap<Integer, List<Integer>>();
        LinkedHashMap<Integer, Integer> pidLenBytes = new LinkedHashMap<Integer, Integer>();
        ArrayList<Integer> prots = new ArrayList<Integer>();
        ArrayList<Integer> distinctTags = new ArrayList<Integer>();
        String name = this.file.getName();
        ArrayList<String> tagNames = new ArrayList<String>();
        System.err.println(name + " tags:");
        int itemsLength = (data[pos + 14] & 0xFF) + 256 * (data[pos + 15] & 0xFF);
        pos += 16;
        int itemCount = data[pos++] & 0xFF;
        int itemsEnd = pos + itemsLength;
        for (int i = 0; i < itemCount; ++i) {
            char ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = (char)(data[pos++] & 0xFF)) != '\u0000') {
                sb.append(ch);
            }
            String tag = Integer.toHexString(i);
            if (tag.length() == 1) {
                tag = "0" + tag;
            }
            String tagName = sb.toString();
            tagNames.add(tagName);
            System.err.println("  " + tag + "  " + tagName);
        }
        if (pos != itemsEnd) {
            System.err.println("Parsing error in " + name);
            return;
        }
        ArrayList<Integer> tags = new ArrayList<Integer>();
        int devLen = 0;
        int cmdLen = 0;
        int pid = -1;
        while (true) {
            int tag;
            if (((tag = data[pos++] & 0xFF) & 0x80) == 0) {
                tags.add(0, tag);
                if (!distinctTags.contains(tag)) {
                    distinctTags.add(tag);
                }
                if (tag == 11) {
                    byte type = data[pos + 1];
                    char[] chs = new char[4];
                    for (int i = 2; i < 6; ++i) {
                        chs[i - 2] = (char)data[pos + i];
                    }
                    int val = Integer.parseInt(new String(chs));
                    ArrayList<Integer> list = (ArrayList<Integer>)setups.get(type);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        setups.put(Integer.valueOf(type), list);
                    }
                    if (!list.contains(val)) {
                        list.add(val);
                    }
                } else if (tag == 13) {
                    devLen = data[pos];
                } else if (tag == 17) {
                    pid = (data[pos + 1] & 0xFF) + 256 * (data[pos + 2] & 0xFF);
                    if (!prots.contains(pid)) {
                        prots.add(pid);
                    }
                } else if (tag == 16) {
                    if (cmdLen == 0) {
                        cmdLen = data[pos] - 1;
                    } else if (cmdLen != data[pos] - 1) {
                        System.err.println("Inconsistent cmdLen in pid = " + Integer.toHexString(pid));
                    }
                }
                int len = data[pos++] & 0xFF;
                pos += len;
                continue;
            }
            int last = (Integer)tags.remove(0);
            if (tag != (last | 0x80)) {
                System.err.println("XCF file nesting error at " + Integer.toHexString(pos - 1));
                return;
            }
            if (tag == 139) {
                Integer oldVal;
                int val = 65535;
                if (devLen < 16 && cmdLen < 16) {
                    val = cmdLen | devLen << 4;
                }
                if ((oldVal = (Integer)pidLenBytes.get(pid)) == null) {
                    pidLenBytes.put(pid, val);
                } else if (oldVal != val) {
                    System.err.println("Inconsistent occurrences of pid " + Integer.toHexString(pid));
                }
                devLen = 0;
                cmdLen = 0;
                pid = -1;
            }
            if (tags.isEmpty()) break;
        }
        System.err.println("irdb parsing terminating at position " + Integer.toHexString(pos));
        Collections.sort(distinctTags);
        System.err.println();
        System.err.print("Distinct tags: ");
        Iterator tag = distinctTags.iterator();
        while (tag.hasNext()) {
            int tag2 = (Integer)tag.next();
            System.err.print(String.format("%02X ", tag2));
        }
        System.err.println();
        System.err.println();
        this.printExtract(setups, pidLenBytes, prots, null);
        String title = "Extract irdb.bin";
        String message = "Extract data, including [Protocols] and [SetupCodes] sections for the\nRDF for " + remote.getName() + " have been output to rmaster.err";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    private void printExtract(LinkedHashMap<Integer, List<Integer>> setups, LinkedHashMap<Integer, Integer> pidLenBytes, List<Integer> prots, List<Integer> maps) {
        Remote remote = this.remoteConfig.getRemote();
        System.err.println("RDF data for " + remote.getName() + " follows:");
        System.err.println();
        System.err.println("[SetupCodes]");
        ArrayList<Integer> types = new ArrayList<Integer>(setups.keySet());
        Collections.sort(types);
        Collections.sort(prots);
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            List<Integer> list = setups.get(type);
            Collections.sort(list);
            if (type < 16) {
                System.err.print(type);
            } else {
                System.err.print((char)type);
            }
            System.err.print(" = ");
            int i = -1;
            for (int val : list) {
                if (++i > 0) {
                    System.err.print(", ");
                    if (i % 10 == 0) {
                        System.err.println();
                        System.err.print("    ");
                    }
                }
                System.err.print(new SetupCode(val));
            }
            System.err.println();
        }
        if (maps != null) {
            System.err.println();
            System.err.println("[DigitMaps]");
            int i = -1;
            for (int m : maps) {
                if (++i > 0 && i % 16 == 0) {
                    System.err.println();
                }
                if (m >= 0) {
                    System.err.print(String.format("%03d ", m));
                    continue;
                }
                System.err.print("??? ");
            }
            System.err.println();
        }
        System.err.println();
        System.err.println("[Protocols]");
        int i = -1;
        for (int p : prots) {
            if (++i > 0) {
                System.err.print(", ");
                if (i % 10 == 0) {
                    System.err.println();
                }
            }
            System.err.print(String.format("%04X", p));
        }
        System.err.println();
        System.err.println();
        i = -1;
        System.err.println("Dev/Cmd lengths by protocol");
        for (int p : prots) {
            if (++i > 0) {
                System.err.print("; ");
                if (i % 8 == 0) {
                    System.err.println();
                }
            }
            System.err.print(String.format("%04X %02X", p, pidLenBytes.get(p)));
        }
        System.err.println();
        System.err.println();
    }

    public void resetSegmentPanel() {
        if (this.segmentPanel != null) {
            this.segmentPanel.resetLastSorted();
        }
    }

    private int getRegisteredRemotes() {
        String propName;
        String temp;
        this.bleMap.clear();
        int n = 0;
        while ((temp = properties.getProperty(propName = "RegisteredBTRemotes." + n)) != null) {
            int namePos = temp.indexOf("Name=");
            int ueiNamePos = temp.indexOf("UEIName=");
            int addrPos = temp.indexOf("Address=");
            if (namePos >= 0 && ueiNamePos >= namePos + 5 && addrPos > ueiNamePos + 8) {
                String name = temp.substring(namePos + 5, ueiNamePos);
                String ueiName = temp.substring(ueiNamePos + 8, addrPos);
                String address = temp.substring(addrPos + 8);
                BLERemote dev = new BLERemote(name, ueiName, address);
                dev.regIndex = n;
                this.bleMap.put(address, dev);
            }
            ++n;
        }
        return n - 1;
    }

    public void disconnectBLE() {
        boolean forced = false;
        if (this.btio != null) {
            if (!this.btio.isDisconnecting()) {
                this.btio.disconnectUEI();
            } else {
                forced = true;
            }
            this.btio.disconnectBLE();
            this.btio = null;
        }
        this.bluetoothButton.setSelected(false);
        String selectedInterface = properties.getProperty("Interface");
        if (selectedInterface != null && selectedInterface.equals("JP2BT")) {
            this.recreateToolbar();
            if (forced) {
                String message = "Connection terminated by the connected remote.";
                JOptionPane.showMessageDialog(this, message, "Disconnection", 1);
            }
        }
    }

    public void setRfTools(RfTools rfTools) {
        this.rfTools = rfTools;
    }

    public void setRfRegistrationEnabled(boolean enable) {
        this.registerRfRemoteItem.setEnabled(enable);
    }

    private static int[] parseVersion(String version) {
        int[] parsedVersion = new int[3];
        StringTokenizer st = new StringTokenizer(version.trim(), ". ");
        for (int i = 0; i < 3; ++i) {
            if (!st.hasMoreTokens()) {
                return null;
            }
            parsedVersion[i] = Integer.parseInt(st.nextToken());
        }
        return parsedVersion;
    }

    public static boolean testWindowsVersion(String base) {
        String line = "";
        String fullVersion = "";
        int[] parsedBase = null;
        String SEARCH_TERM = "OS Version:";
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            return false;
        }
        if (parsedWindowsVersion == null) {
            try {
                Runtime rt = Runtime.getRuntime();
                Process pr = rt.exec("SYSTEMINFO");
                BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = in.readLine()) != null) {
                    if (!line.contains("OS Version:")) continue;
                    fullVersion = line.substring(line.lastIndexOf("OS Version:") + "OS Version:".length(), line.length() - 1);
                    break;
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                return false;
            }
            parsedWindowsVersion = RMIRSetup.parseVersion(fullVersion.trim());
        }
        parsedBase = RMIRSetup.parseVersion(base);
        if (parsedWindowsVersion == null || parsedBase == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (parsedWindowsVersion[i] < parsedBase[i]) {
                return false;
            }
            if (parsedWindowsVersion[i] <= parsedBase[i]) continue;
            return true;
        }
        return true;
    }

    public RMAction getSaveAsAction() {
        return this.saveAsAction;
    }

    public LearnedSignalPanel getLearnedPanel() {
        return this.learnedPanel;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void storePBSelectedColors() {
        JRadioButton[] buttons = new JRadioButton[]{this.pbSelBlue, this.pbSelBlack, this.pbSelWhite};
        if (this.pbSelDefault.isSelected()) {
            properties.remove("PBSelectedColor");
        } else {
            for (JRadioButton b : buttons) {
                if (!b.isSelected()) continue;
                properties.setProperty("PBSelectedColor", b.getText());
            }
        }
        buttons = new JRadioButton[]{this.pbUnselBlue, this.pbUnselBlack};
        if (this.pbUnselDefault.isSelected()) {
            properties.remove("PBUnselectedColor");
        } else {
            for (JRadioButton b : buttons) {
                if (!b.isSelected()) continue;
                properties.setProperty("PBUnselectedColor", b.getText());
            }
        }
        buttons = new JRadioButton[]{this.pbForeAquamarine, this.pbForeBlack, this.pbForeBlue, this.pbForeRed, this.pbForeOrange, this.pbForeGreen};
        if (this.pbForeDefault.isSelected()) {
            properties.remove("PBForeColor");
        } else {
            for (JRadioButton b : buttons) {
                if (!b.isSelected()) continue;
                properties.setProperty("PBForeColor", b.getText());
            }
        }
    }

    public static Color getColor(String colorName) {
        if (colorName.equals("DEFAULT")) {
            return null;
        }
        if (colorName.equals("AQUAMARINE")) {
            return AQUAMARINE;
        }
        try {
            Field field = Class.forName("java.awt.Color").getField(colorName);
            return (Color)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setPBSelectedColors() {
        int i;
        String selString = properties.getProperty("PBSelectedColor", "Default");
        String unselString = properties.getProperty("PBUnselectedColor", "Default");
        String foreString = properties.getProperty("PBForeColor", "Default");
        this.pbSelectedColor = RMIRSetup.getColor(selString.toUpperCase());
        this.pbUnselectedColor = RMIRSetup.getColor(unselString.toUpperCase());
        this.pbForegroundColor = RMIRSetup.getColor(foreString.toUpperCase());
        String[] colorStrings = new String[]{"Default", "Blue", "Black", "White"};
        JRadioButton[] selButtons = new JRadioButton[]{this.pbSelDefault, this.pbSelBlue, this.pbSelBlack, this.pbSelWhite};
        JRadioButton[] unselButtons = new JRadioButton[]{this.pbUnselDefault, this.pbUnselBlue, this.pbUnselBlack};
        for (i = 0; i < selButtons.length; ++i) {
            if (!colorStrings[i].equals(selString)) continue;
            selButtons[i].setSelected(true);
            break;
        }
        for (i = 0; i < unselButtons.length; ++i) {
            if (!colorStrings[i].equals(unselString)) continue;
            unselButtons[i].setSelected(true);
            break;
        }
        colorStrings = new String[]{"Default", "Aquamarine", "Black", "Blue", "Red", "Orange", "Green"};
        JRadioButton[] foreButtons = new JRadioButton[]{this.pbForeDefault, this.pbForeAquamarine, this.pbForeBlack, this.pbForeBlue, this.pbForeRed, this.pbForeOrange, this.pbForeGreen};
        for (int i2 = 0; i2 < foreButtons.length; ++i2) {
            if (!colorStrings[i2].equals(foreString)) continue;
            foreButtons[i2].setSelected(true);
            break;
        }
    }

    public Remote filterRemotes(List<Remote> remotes, String signature, int dataSize, short[] data, short[] sigData, boolean allowMismatch) {
        Remote remote = null;
        Iterator<Remote> it = remotes.iterator();
        while (it.hasNext()) {
            Remote r = it.next();
            int pageSize = r.getProcessor().getPageSize();
            if (r.getEepromSize() == dataSize || (r.isSSD() || data == null) && r.getEepromSize() > dataSize || r.isJP2style() && dataSize % pageSize == 0 && r.getEepromSize() < dataSize && dataSize - r.getEepromSize() < pageSize) continue;
            it.remove();
        }
        if (remotes == null || remotes.isEmpty()) {
            RDFMessage rdfMessage = new RDFMessage("No remote found with signature starting " + signature + " and EEPROM size " + (data == null ? "at least " : "") + (dataSize + 1023 >> 10) + "k.");
            rdfMessage.showReason();
            return null;
        }
        if (remotes.size() == 1 && allowMismatch) {
            remote = remotes.get(0);
        } else {
            Object[] choices = new Remote[]{};
            choices = FixedData.filter(remotes, data, sigData);
            if (choices.length == 0) {
                if (allowMismatch) {
                    choices = remotes.toArray(choices);
                } else {
                    return null;
                }
            }
            if (choices.length == 1) {
                remote = choices[0];
            } else {
                String message = "The file you are loading is for a remote with signature " + (data == null ? "starting " : "") + "\"" + signature + "\".\nThere are multiple remotes with that signature.  Please choose the best match from the list below:";
                remote = (Remote)JOptionPane.showInputDialog(null, message, "Unknown Remote", 0, null, choices, choices[0]);
            }
        }
        Remote newRemote = new Remote(remote, remote.getNameIndex());
        RemoteManager.getRemoteManager().replaceRemote(remote, newRemote);
        return newRemote;
    }

    protected class RMAction
    extends AbstractAction {
        public RMAction(String text, String action, ImageIcon icon, String description, Integer mnemonic) {
            super(text, icon);
            this.putValue("ActionCommandKey", action);
            this.putValue("ShortDescription", description);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            RMIRSetup.this.finishEditing();
            try {
                String command = event.getActionCommand();
                if (command.equals("NEW")) {
                    String title = "File > New";
                    String message = "The menu option File > New is primarily intended for creating setups for remotes\nthat you do not have, such as for sending to another person to test.  If you have the\nremote, it is strongly recommended that you start a new setup by doing a factory reset\n(981 command) and downloading it.  Although the ideal situation would be for\nFile > New to create a factory reset state, for many remotes there are hidden settings\nthat are not visible in RMIR whose initial values are not correctly set by File > New.\nThese may adversely affect the operation of the remote when a setup created this way\nis uploaded.\n\nDo you wish to continue?";
                    if (!suppressConfirmPrompts.isSelected() && JOptionPane.showConfirmDialog(RMIRSetup.this, message, title, 0, 2) == 1) {
                        return;
                    }
                    if (!RMIRSetup.this.promptToSave()) {
                        return;
                    }
                    Remote remote = RMNewDialog.showDialog(RMIRSetup.this);
                    if (remote == null) {
                        return;
                    }
                    if (remote.isLoaded()) {
                        remote.needsLayoutWarning();
                    }
                    remote.load();
                    if (remote.isSSD()) {
                        title = "New Remote Image";
                        message = "RMIR cannot create a new remote image for this remote.";
                        JOptionPane.showMessageDialog(RMIRSetup.this, message, title, 1);
                        return;
                    }
                    RMIRSetup.this.resetConfig(remote, null);
                } else if (command.equals("NEWDEVICE")) {
                    System.err.println("RMIR opening new RMDU instance");
                    RMIRSetup.runKM("");
                } else if (command.equals("NEWPROTOCOL")) {
                    System.err.println("RMIR opening new RMPB instance");
                    RMIRSetup.runPB("");
                } else if (command.equals("OPEN")) {
                    RMIRSetup.this.openFile();
                } else if (command.equals("SAVE")) {
                    RMIRSetup.this.save(RMIRSetup.this.file, false);
                } else if (command.equals("SAVEAS")) {
                    if (!RMIRSetup.this.allowSave(Remote.SetupValidation.WARN)) {
                        return;
                    }
                    RMIRSetup.this.saveAs();
                } else if (command.equals("DOWNLOAD")) {
                    if (!RMIRSetup.this.promptToSave()) {
                        return;
                    }
                    System.err.println("Starting normal download");
                    RMIRSetup.this.setInterfaceState("DOWNLOADING...");
                    new DownloadTask().execute();
                    boolean title = false;
                } else if (command.equals("UPLOAD")) {
                    boolean validConfiguration = RMIRSetup.this.updateUsage();
                    if (!validConfiguration) {
                        String title = "Invalid Configuration";
                        String message = "This configuration is not valid.  It cannot be uploaded as it\ncould cause the remote to crash.";
                        JOptionPane.showMessageDialog(RMIRSetup.this, message, title, 2);
                        return;
                    }
                    if (!RMIRSetup.this.allowSave(RMIRSetup.this.remoteConfig.getSetupValidation())) {
                        return;
                    }
                    RMIRSetup.this.remoteConfig.saveAltPIDs();
                    System.err.println("Starting upload");
                    RMIRSetup.this.setInterfaceState("UPLOADING...");
                    new UploadTask(RMIRSetup.this.useSavedData() ? RMIRSetup.this.remoteConfig.getSavedData() : RMIRSetup.this.remoteConfig.getData(), true).execute();
                } else if (command.equals("OPENRDF")) {
                    String title = "View/Edit RDF";
                    RMIRSetup.this.rdfViewer = TextFileViewer.showFile(RMIRSetup.this, RMIRSetup.this.remoteConfig.getRemote(), title, false);
                } else if (command.equals("OPENCODES")) {
                    Remote remote = RMIRSetup.this.remoteConfig.getRemote();
                    remote.setExtract();
                    if (remote.getSetupCodes().isEmpty()) {
                        remote.setExtractData();
                    } else {
                        remote.setExtractSetupCodes(null);
                    }
                    JP1Table deviceButtonTable = RMIRSetup.this.generalPanel.getDeviceButtonTable();
                    if (deviceButtonTable.getCellEditor() != null) {
                        deviceButtonTable.getCellEditor().stopCellEditing();
                    }
                    RMIRSetup.this.codeSelectorDialog = CodeSelectorDialog.showDialog(RMIRSetup.this, false);
                    RMIRSetup.this.codeSelectorDialog.enableAssign(RMIRSetup.this.currentPanel == RMIRSetup.this.generalPanel);
                } else if (command.equals("HIGHLIGHT")) {
                    JP1Table table = null;
                    JP1TableModel model = null;
                    TableSorter sorter = null;
                    if (RMIRSetup.this.currentPanel instanceof RMTablePanel) {
                        RMTablePanel panel = (RMTablePanel)RMIRSetup.this.currentPanel;
                        table = panel.table;
                        model = panel.model;
                        sorter = panel.sorter;
                    } else if (RMIRSetup.this.currentPanel == RMIRSetup.this.generalPanel) {
                        table = RMIRSetup.this.generalPanel.getActiveTable();
                        model = (JP1TableModel)table.getModel();
                    } else if (RMIRSetup.this.currentPanel == RMIRSetup.this.activityPanel) {
                        table = RMIRSetup.this.activityPanel.getActiveTable();
                        model = (JP1TableModel)table.getModel();
                    } else if (RMIRSetup.this.currentPanel == RMIRSetup.this.favoritesPanel) {
                        table = RMIRSetup.this.favoritesPanel.getActiveTable();
                        model = (JP1TableModel)table.getModel();
                    }
                    Color color = RMIRSetup.this.getInitialHighlight(table, 0);
                    Preview preview = (Preview)RMIRSetup.this.colorChooser.getPreviewPanel();
                    preview.reset(RMIRSetup.this.currentPanel == RMIRSetup.this.devicePanel && RMIRSetup.this.getInitialHighlight(table, 1) == null);
                    preview.selectors.setVisible(RMIRSetup.this.currentPanel == RMIRSetup.this.devicePanel);
                    RMIRSetup.this.colorChooser.setColor(color);
                    RMIRSetup.this.colorDialog.pack();
                    RMIRSetup.this.colorDialog.setVisible(true);
                    color = preview.result;
                    if (table != null && color != null) {
                        for (int i : table.getSelectedRows()) {
                            if (RMIRSetup.this.currentPanel == RMIRSetup.this.keyMovePanel) {
                                model.setValueAt(color, sorter.modelIndex(i), 9);
                                continue;
                            }
                            if (RMIRSetup.this.currentPanel == RMIRSetup.this.devicePanel && preview.colorCol == 1) {
                                DeviceUpgrade du = (DeviceUpgrade)RMIRSetup.this.devicePanel.getRowObject(i);
                                if (!du.needsProtocolCode()) continue;
                                model.setValueAt(color, sorter.modelIndex(i), model.getColumnCount() - 1);
                                continue;
                            }
                            Highlight rowObject = RMIRSetup.this.getTableRow(table, i);
                            rowObject.setHighlight(color);
                        }
                        model.fireTableDataChanged();
                        model.propertyChangeSupport.firePropertyChange("data", null, null);
                        RMIRSetup.this.highlightAction.setEnabled(false);
                    }
                } else if (command.equals("BLUETOOTH")) {
                    if (RMIRSetup.this.bluetoothButton.isSelected()) {
                        BLERemote selectedRemote = null;
                        RMIRSetup.this.bleBtnMap.clear();
                        RMIRSetup.this.getRegisteredRemotes();
                        JPanel panel = new JPanel(new BorderLayout());
                        JLabel lbl = new JLabel("Text");
                        int height = lbl.getPreferredSize().height;
                        String info = "Select a remote and press Connect to connect.  To find other remotes,\npress Search.  To find a remote new to RMIR, then press and hold its\nDevices and Activity buttons until the LED starts to flash.\n\nTo register a remote with RMIR with a user-friendly name, or to change\nthe name of a registered remote, select it and press Register.  To\nderegister a registered remote, select it and press Deregister.  To\ncheck if a registered remote is available, press Search.  Registered\nremotes will then be disabled and only re-enabled if found.";
                        JTextArea infoArea = new JTextArea(info);
                        infoArea.setFont(lbl.getFont());
                        infoArea.setBackground(lbl.getBackground());
                        infoArea.setEditable(false);
                        infoArea.setBorder(BorderFactory.createEmptyBorder(0, 2, 10, 2));
                        panel.add((Component)infoArea, "First");
                        panel.add(Box.createVerticalStrut(10 * height), "Before");
                        RMIRSetup.this.box = Box.createVerticalBox();
                        RMIRSetup.this.btGroup = new ButtonGroup();
                        String lastRemote = JP1Frame.properties.getProperty("LastBLERemote");
                        for (String addr : RMIRSetup.this.bleMap.keySet()) {
                            JRadioButton btn = new JRadioButton(((BLERemote)((RMIRSetup)RMIRSetup.this).bleMap.get((Object)addr)).name);
                            RMIRSetup.this.btGroup.add(btn);
                            if (lastRemote != null && addr.equals(lastRemote)) {
                                btn.setSelected(true);
                            }
                            RMIRSetup.this.bleBtnMap.put(btn, (BLERemote)RMIRSetup.this.bleMap.get(addr));
                            RMIRSetup.this.box.add(btn);
                        }
                        JScrollPane scroll = new JScrollPane(RMIRSetup.this.box);
                        Border btBorder = BorderFactory.createLineBorder(Color.GRAY);
                        scroll.getViewport().setPreferredSize(new Dimension(0, 0));
                        scroll.setBorder(BorderFactory.createTitledBorder(btBorder, "Select remote: "));
                        panel.add((Component)scroll, "Center");
                        RMIRSetup.this.searchButton = new JButton("Search");
                        RMIRSetup.this.registerButton = new JButton("Register");
                        RMIRSetup.this.deregisterButton = new JButton("Deregister");
                        JPanel btnPanel = new JPanel(new BorderLayout());
                        JPanel regPanel = new JPanel(new FlowLayout());
                        regPanel.add(RMIRSetup.this.searchButton);
                        btnPanel.add((Component)regPanel, "Before");
                        regPanel = new JPanel(new FlowLayout());
                        regPanel.add(RMIRSetup.this.registerButton);
                        regPanel.add(RMIRSetup.this.deregisterButton);
                        btnPanel.add((Component)regPanel, "After");
                        btnPanel.setBorder(BorderFactory.createTitledBorder(btBorder, "Actions: "));
                        panel.add((Component)btnPanel, "Last");
                        RMIRSetup.this.searchButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (RMIRSetup.this.btio == null || !RMIRSetup.this.btio.isScanning()) {
                                    for (JRadioButton btn : RMIRSetup.this.bleBtnMap.keySet()) {
                                        btn.setEnabled(false);
                                    }
                                    new ConnectTask(null, Use.SEARCH).execute();
                                }
                            }
                        });
                        ActionListener regListener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String name = null;
                                BLERemote r = null;
                                JRadioButton rBtn = null;
                                int regCount = 0;
                                for (JRadioButton btn : RMIRSetup.this.bleBtnMap.keySet()) {
                                    if (btn.isSelected()) {
                                        rBtn = btn;
                                        r = (BLERemote)RMIRSetup.this.bleBtnMap.get(btn);
                                        name = r.name;
                                    }
                                    if (((BLERemote)((RMIRSetup)RMIRSetup.this).bleBtnMap.get((Object)btn)).regIndex < 0) continue;
                                    ++regCount;
                                }
                                if (name == null) {
                                    return;
                                }
                                Object source = e.getSource();
                                if (source == RMIRSetup.this.registerButton) {
                                    String message = "Enter user-friendly name for this remote:";
                                    String result = JOptionPane.showInputDialog(null, message, name);
                                    if (result != null) {
                                        r.name = result;
                                        if (r.regIndex < 0) {
                                            r.regIndex = regCount;
                                        }
                                        String propName = "RegisteredBTRemotes." + r.regIndex;
                                        String propValue = "Name=" + r.name + "UEIName=" + r.ueiName + "Address=" + r.address;
                                        JP1Frame.properties.setProperty(propName, propValue);
                                        rBtn.setText(r.name);
                                    }
                                } else if (source == RMIRSetup.this.deregisterButton) {
                                    int ndx = r.regIndex;
                                    r.regIndex = -1;
                                    r.name = r.ueiName + " " + r.address.substring(9);
                                    rBtn.setText(r.name);
                                    for (int n = ndx; n < regCount - 1; ++n) {
                                        String propName = "RegisteredBTRemotes." + (n + 1);
                                        String propValue = JP1Frame.properties.getProperty(propName);
                                        propName = "RegisteredBTRemotes." + n;
                                        JP1Frame.properties.setProperty(propName, propValue);
                                    }
                                    String propName = "RegisteredBTRemotes." + (regCount - 1);
                                    JP1Frame.properties.remove(propName);
                                }
                            }
                        };
                        RMIRSetup.this.registerButton.addActionListener(regListener);
                        RMIRSetup.this.deregisterButton.addActionListener(regListener);
                        Object[] options = new String[]{"Connect", "Close"};
                        int result = JOptionPane.showOptionDialog(null, panel, "Remote chooser", 2, -1, null, options, options[0]);
                        if (RMIRSetup.this.btio != null && RMIRSetup.this.btio.isScanning()) {
                            RMIRSetup.this.btio.discoverUEI(false, false);
                            RMIRSetup.this.setInterfaceState(null);
                            RMIRSetup.this.searchButton.setEnabled(true);
                        }
                        if (RMIRSetup.this.btio != null) {
                            RMIRSetup.this.btio.setDisconnecting(false);
                        }
                        if (result == 0) {
                            for (JRadioButton btn : RMIRSetup.this.bleBtnMap.keySet()) {
                                if (!btn.isSelected()) continue;
                                selectedRemote = (BLERemote)RMIRSetup.this.bleBtnMap.get(btn);
                                break;
                            }
                            if (selectedRemote != null) {
                                JP1Frame.properties.setProperty("LastBLERemote", selectedRemote.address);
                                new ConnectTask(selectedRemote, Use.CONNECT).execute();
                            } else {
                                RMIRSetup.this.disconnectBLE();
                            }
                        } else {
                            RMIRSetup.this.disconnectBLE();
                        }
                    } else {
                        RMIRSetup.this.disconnectBLE();
                    }
                } else if (command.equals("FINDER")) {
                    if (RMIRSetup.this.finderButton.isSelected()) {
                        RMIRSetup.this.btio.finderOn(true);
                        RMIRSetup.this.finderButton.setBorder(BorderFactory.createLoweredBevelBorder());
                    } else {
                        RMIRSetup.this.btio.finderOn(false);
                        RMIRSetup.this.finderButton.setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                } else if (command.equals("RFTOOLS")) {
                    if (RMIRSetup.this.rfTools == null) {
                        RMIRSetup.this.rfTools = new RfTools(RMIRSetup.this);
                    }
                } else if (command.equals("REENABLE")) {
                    if (CommHID.lastRegistryKey == null) {
                        return;
                    }
                    String message = "An XSight/Nevo remote needs Enhanced Power Management disabled if it is to be used\nwith RMIR.  If you re-enable it for the current remote, you will no longer be able to use it\nwith RMIR until you disable it again.  If you really want to re-enable it, you must be running\nRMIR as administrator.  If you are not doing so, please press No and exit RMIR.  Then\nright-click an RMIR shortcut and select \"Run as administrator\".  Download the remote\nagain and return to this link.\n\nAre you sure you wish to continue?";
                    String title = "Re-enable Enhanced Power Management";
                    int reply = NegativeDefaultButtonJOptionPane.showConfirmDialog(RMIRSetup.this, message, title, 0, 3);
                    if (reply == 0) {
                        CommHID.Response response = CommHID.setEnhancedPowerManagementEnabled(true);
                        int msgType = 0;
                        if (response == null) {
                            message = "Re-enabling Enhanced Power Management failed.";
                        } else if (response.error != null) {
                            message = response.error + "\nYou need to be running RMIR as administrator to change this registry setting.";
                        } else {
                            message = response.output + "\nEnhanced Power Management has been re-enabled for this remote.  You will not be\nable to use it with RMIR until you disable this setting again.  Please note that\nif you attempt a download while still running as administrator, the setting will\nbe automatically disabled.  Run RMIR in standard mode to prevent this happening.";
                            msgType = 1;
                        }
                        JOptionPane.showMessageDialog(RMIRSetup.this, message, title, msgType);
                    }
                } else if (command.equals("SETHIDAPI")) {
                    System.err.println("Setting hidapi as HID interface");
                    if (((Boolean)RMIRSetup.this.xziteHidapiAction.getValue("SwingSelectedKey")).booleanValue()) {
                        if (RemoteMaster.useCommHIDBDefault) {
                            JP1Frame.properties.setProperty("HIDInterface", "hidapi");
                        } else {
                            JP1Frame.properties.remove("HIDInterface");
                        }
                    }
                    if (RemoteMaster.useCommHIDB) {
                        RMIRSetup.this.showHIDMessage("hidapi");
                        RemoteMaster.useCommHIDB = false;
                    }
                } else if (command.equals("SETHID4JAVA")) {
                    System.err.println("Setting hid4java as HID interface");
                    if (((Boolean)RMIRSetup.this.xziteHid4JavaAction.getValue("SwingSelectedKey")).booleanValue()) {
                        if (RemoteMaster.useCommHIDBDefault) {
                            JP1Frame.properties.remove("HIDInterface");
                        } else {
                            JP1Frame.properties.setProperty("HIDInterface", "hid4java");
                        }
                    }
                    if (!RemoteMaster.useCommHIDB) {
                        RMIRSetup.this.showHIDMessage("hid4java");
                        RemoteMaster.useCommHIDB = true;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            boolean x = false;
        }
    }

    public static class NegativeDefaultButtonJOptionPane {
        public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
            String defaultOption;
            ArrayList<String> options = new ArrayList<String>();
            switch (optionType) {
                case 2: {
                    options.add(UIManager.getString("OptionPane.okButtonText"));
                    options.add(UIManager.getString("OptionPane.cancelButtonText"));
                    defaultOption = UIManager.getString("OptionPane.cancelButtonText");
                    break;
                }
                case 0: {
                    options.add(UIManager.getString("OptionPane.yesButtonText"));
                    options.add(UIManager.getString("OptionPane.noButtonText"));
                    defaultOption = UIManager.getString("OptionPane.noButtonText");
                    break;
                }
                case 1: {
                    options.add(UIManager.getString("OptionPane.yesButtonText"));
                    options.add(UIManager.getString("OptionPane.noButtonText"));
                    options.add(UIManager.getString("OptionPane.cancelButtonText"));
                    defaultOption = UIManager.getString("OptionPane.cancelButtonText");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown optionType " + optionType);
                }
            }
            return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, null, options.toArray(), defaultOption);
        }
    }

    public static class BatteryBar
    extends JLabel {
        private int bars = 0;

        public BatteryBar() {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }

        public void setBars(int bars) {
            this.bars = bars;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            int barWidth = (d.width + 2) / 3 - 2;
            for (int i = 0; i < this.bars; ++i) {
                g.setColor(Color.GRAY);
                g.fillRect((barWidth + 2) * i, 0, barWidth, d.height);
            }
        }
    }

    public class Preview
    extends JPanel {
        private JPanel sample = new JPanel();
        private Color result = null;
        private JPanel selectors = new JPanel(new GridLayout(2, 1));
        private int colorCol = 0;
        private JRadioButton devices = new JRadioButton("Device");
        private JRadioButton protocols = new JRadioButton("Protocol");

        Preview() {
            this.sample.setPreferredSize(new Dimension(90, 30));
            this.sample.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            JPanel p = new JPanel();
            p.add(this.sample);
            this.add(p);
            this.add(Box.createHorizontalStrut(20));
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.devices);
            grp.add(this.protocols);
            this.devices.setSelected(true);
            this.devices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Preview.this.colorCol != 0) {
                        Color color = RMIRSetup.this.getInitialHighlight(((RMIRSetup)RMIRSetup.this).devicePanel.table, 0);
                        RMIRSetup.this.colorChooser.setColor(color);
                        Preview.this.sample.setBackground(color);
                        Preview.this.colorCol = 0;
                    }
                }
            });
            this.protocols.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Preview.this.colorCol != 1) {
                        Color color = RMIRSetup.this.getInitialHighlight(((RMIRSetup)RMIRSetup.this).devicePanel.table, 1);
                        RMIRSetup.this.colorChooser.setColor(color);
                        Preview.this.sample.setBackground(color);
                        Preview.this.colorCol = 1;
                    }
                }
            });
            this.selectors.add(this.devices);
            this.selectors.add(this.protocols);
            this.add(this.selectors);
        }

        public void reset(boolean disableProtocol) {
            this.colorCol = 0;
            this.devices.setSelected(true);
            this.protocols.setEnabled(!disableProtocol);
        }

        public Color getColor() {
            return this.result;
        }

        public JPanel getSelectors() {
            return this.selectors;
        }
    }

    public static class LanguageDescriptor {
        public String name = null;
        public Integer code = null;

        public LanguageDescriptor(String name, Integer code) {
            this.name = name;
            this.code = code;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class RMCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        boolean defaultState = false;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RMCheckBoxMenuItem item = (RMCheckBoxMenuItem)e.getSource();
                    if (item.isSelected() == item.isDefaultState()) {
                        JP1Frame.properties.remove(item.getActionCommand());
                    } else {
                        JP1Frame.properties.setProperty(item.getActionCommand(), Boolean.toString(item.isSelected()));
                    }
                }
                catch (Exception x) {
                    x.printStackTrace(System.err);
                }
            }
        };

        public RMCheckBoxMenuItem(String s, String command, boolean defaultState) {
            super(s);
            this.defaultState = defaultState;
            this.setActionCommand(command);
            this.setSelected(Boolean.parseBoolean(JP1Frame.properties.getProperty(command, Boolean.toString(defaultState))));
            this.addActionListener(this.al);
        }

        public boolean isDefaultState() {
            return this.defaultState;
        }
    }

    public static enum WavOp {
        NEW,
        MERGE,
        SAVE,
        PLAY;

    }

    private class DownloadTask
    extends SwingWorker<RemoteConfiguration, Void>
    implements ProgressUpdater {
        private File file = null;
        private Use use = null;
        private IO io = null;

        public DownloadTask() {
            this.file = null;
            this.use = Use.DOWNLOAD;
        }

        public DownloadTask(File file) {
            this.file = file;
            this.use = Use.READING;
        }

        @Override
        public void updateProgress(int value) {
            if (value < 0) {
                RMIRSetup.this.setInterfaceState("DOWNLOADING...");
            } else {
                String name = this.io != null ? this.io.getProgressName() : null;
                RMIRSetup.this.setInterfaceState(name != null ? name : "PREPARING:", value);
            }
        }

        @Override
        protected RemoteConfiguration doInBackground() throws Exception {
            RMIRSetup.this.clearAllInterfaces();
            IO io = RMIRSetup.this.getOpenInterface(this.file, this.use, this);
            if (io == null) {
                RMIRSetup.this.setInterfaceState(null);
                JOptionPane.showMessageDialog(RMIRSetup.this, "No remotes found!");
                return null;
            }
            System.err.println("Interface opened successfully");
            this.io = io;
            int baseAddress = io.getRemoteEepromAddress();
            System.err.println("Base address read from remote = $" + Integer.toHexString(baseAddress).toUpperCase());
            String sigString = RMIRSetup.getIOsignature(io, baseAddress);
            String sig = null;
            String sig2 = null;
            Remote remote = null;
            List<Remote> remotes = null;
            RemoteManager rm = RemoteManager.getRemoteManager();
            sig = sigString.length() > 8 ? sigString.substring(0, 6) : sigString;
            short[] icinfo = RMIRSetup.getIcInfo(io);
            short[] sigData = RMIRSetup.getSigData(sigString, io);
            short[] rfData = RMIRSetup.getRFData(io);
            if (RMIRSetup.this.remoteConfig != null && RMIRSetup.this.remoteConfig.getRemote() != null && (sig2 = RMIRSetup.this.remoteConfig.getRemote().getSignature()).length() <= sig.length() && sig2.equals(sig.substring(0, sig2.length()))) {
                remotes = rm.findRemoteBySignature(sig2);
                sig = sig2;
                if (remotes.size() == 1) {
                    remote = remotes.get(0);
                } else if (RMIRSetup.this.sameSigSameRemote()) {
                    for (Remote r : remotes) {
                        if (RMIRSetup.this.remoteConfig.getRemote().compareTo(r) != 0) continue;
                        remote = r;
                        break;
                    }
                }
            }
            if (remote == null) {
                System.err.println("Searching for RDF");
                if (remotes == null) {
                    int minLength = sig.startsWith("USB") ? 7 : 4;
                    for (int i = sig.length(); i >= minLength && (remotes = rm.findRemoteBySignature(sig2 = sig.substring(0, i))).isEmpty(); --i) {
                    }
                    sig = sig2;
                    System.err.println("Final signature sought = " + sig);
                }
                if (remotes == null || remotes.isEmpty()) {
                    System.err.println("No matching RDF found");
                    RDFMessage rdfMessage = new RDFMessage("No RDF matches signature starting " + sig + ".");
                    rdfMessage.showReason();
                    io.closeRemote();
                    RMIRSetup.this.setInterfaceState(null);
                    return null;
                }
                if (remotes.size() == 1) {
                    remote = (Remote)remotes.get(0);
                } else {
                    Object[] choices;
                    int maxFixedData = 0;
                    for (Remote r : remotes) {
                        r.load();
                        for (FixedData fixedData : r.getRawFixedData()) {
                            if (fixedData.getLocation() != FixedData.Location.E2) continue;
                            maxFixedData = Math.max(maxFixedData, fixedData.getAddress() + fixedData.getData().length);
                        }
                    }
                    int eepromSize = io.getRemoteEepromSize();
                    if (eepromSize > 0 && maxFixedData > eepromSize) {
                        maxFixedData = eepromSize;
                    }
                    short[] buffer = new short[maxFixedData];
                    if (maxFixedData > 0) {
                        io.readRemote(baseAddress, buffer);
                    }
                    if ((choices = FixedData.filter(remotes, buffer, sigData)).length == 0) {
                        choices = remotes.toArray(choices);
                    }
                    if (choices.length == 1) {
                        remote = choices[0];
                    } else {
                        String message = "Please pick the best match to your remote from the following list:";
                        Object rc = JOptionPane.showInputDialog(null, message, "Ambiguous Remote", 0, null, choices, choices[0]);
                        if (rc == null) {
                            io.closeRemote();
                            RMIRSetup.this.setInterfaceState(null);
                            return null;
                        }
                        remote = (Remote)rc;
                    }
                }
                System.err.println("Remote identified as: " + remote.getName());
            }
            Remote newRemote = new Remote(remote, remote.getNameIndex());
            RemoteManager.getRemoteManager().replaceRemote(remote, newRemote);
            remote = newRemote;
            remote.load();
            int rdfBaseAddress = remote.getBaseAddress();
            RemoteConfiguration rc = new RemoteConfiguration(remote, RMIRSetup.this);
            RMIRSetup.this.recreateToolbar();
            if (baseAddress != rdfBaseAddress) {
                System.err.println("Base address read from RDF = $" + Integer.toHexString(rdfBaseAddress).toUpperCase());
                System.err.println("Download aborting as base address in RDF differs from that read from remote");
                return null;
            }
            int count = io.readRemote(remote.getBaseAddress(), rc.getData());
            System.err.println("Number of bytes read  = $" + Integer.toHexString(count).toUpperCase());
            io.closeRemote();
            System.err.println("Ending normal download");
            if (count != rc.getData().length) {
                System.err.println("Download aborting due to incomplete read");
                return null;
            }
            if (icinfo != null) {
                rc.setIcInfo(icinfo);
            }
            if (sigData != null) {
                rc.setSigData(sigData);
            }
            if (rfData != null) {
                rc.setRfData(rfData);
                rc.setRfDataAddress(rfDataAddress);
            }
            rc.parseData();
            rc.setSavedData();
            rc.updateImage();
            return rc;
        }

        @Override
        public void done() {
            block6: {
                try {
                    RemoteConfiguration rc = (RemoteConfiguration)this.get();
                    if (rc != null) {
                        RMIRSetup.this.remoteConfig = rc;
                        if (rc.getRemote().isFDRA() && rc.getLanguageIndex() == 9) {
                            rc.setIsSetToDanish(true);
                        }
                        break block6;
                    }
                    RMIRSetup.this.setInterfaceState(null);
                    String title = this.file != null ? "File load" : "Download";
                    String message = title + " aborted.";
                    JOptionPane.showMessageDialog(RMIRSetup.this, message, "Download", 2);
                    return;
                }
                catch (InterruptedException rc) {
                }
                catch (ExecutionException e) {
                    String why = null;
                    Throwable cause = e.getCause();
                    why = cause != null ? cause.getMessage() : e.getMessage();
                    System.err.println("Download error: " + why);
                    RMIRSetup.this.setInterfaceState(null);
                    String message = "<html>Error downloading from remote.<br><br>This may well be the result of a bug in the RMIR software.  To help us, please<br>do a raw download as follows.  Close RMIR, re-open it and click on &quot;Raw download&quot;<br>on the Remote menu.  Click the Download button on the window that then opens.  <br>When the dowload finishes, click Save.  Accept the default filename that is offered.<br>Then post the resulting file in the JP1 Software forum for the experts to examine.</html><br>";
                    JOptionPane.showMessageDialog(RMIRSetup.this, message, "Task error", 0);
                    e.printStackTrace();
                }
            }
            RMIRSetup.this.saveAction.setEnabled(this.file != null);
            RMIRSetup.this.saveAsAction.setEnabled(true);
            RMIRSetup.this.openRdfAction.setEnabled(true);
            RMIRSetup.this.installExtenderItem.setEnabled(this.file == null || RemoteMaster.admin);
            RMIRSetup.this.cleanUpperMemoryItem.setEnabled(true);
            RMIRSetup.this.initializeTo00Item.setEnabled(true);
            RMIRSetup.this.initializeToFFItem.setEnabled(true);
            RMIRSetup.this.setBaselineItem.setEnabled(true);
            RMIRSetup.this.uploadable = true;
            RMIRSetup.this.uploadAction.setEnabled(RMIRSetup.this.allowUpload());
            RMIRSetup.this.resetSegmentPanel();
            RMIRSetup.this.update();
            RMIRSetup.this.changed = RMIRSetup.this.remoteConfig != null ? !Hex.equals(RMIRSetup.this.remoteConfig.getSavedData(), RMIRSetup.this.remoteConfig.getData()) : false;
            if (this.file != null) {
                RMIRSetup.this.setTitleFile(this.file);
            }
            RMIRSetup.this.setInterfaceState(null);
        }
    }

    public class TimingTask
    extends WriteTask
    implements ProgressUpdater {
        String name;
        int duration;
        boolean cancelled;

        public TimingTask(String name, int duration) {
            this.name = null;
            this.duration = 0;
            this.cancelled = false;
            this.name = name;
            this.duration = duration + 1;
        }

        @Override
        protected Void doInBackground() throws Exception {
            long start;
            long current = start = Calendar.getInstance().getTimeInMillis();
            int progress = 0;
            do {
                this.updateProgress(progress);
                Thread.sleep(200L);
                current = Calendar.getInstance().getTimeInMillis();
                progress = Math.min((int)((current - start) / (long)this.duration), 100);
            } while (!this.cancelled);
            return null;
        }

        @Override
        public void done() {
            super.done();
            RMIRSetup.this.setInterfaceState(null);
            RMIRSetup.this.uploadWavItem.setEnabled(true);
            RMIRSetup.this.cancelWavUploadItem.setEnabled(false);
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        @Override
        public void updateProgress(int value) {
            RMIRSetup.this.setInterfaceState(this.name, value);
        }
    }

    private class LoadTask
    extends SwingWorker<RemoteConfiguration, Void>
    implements ProgressUpdater {
        private File loadFile;
        private WavOp wavOp = null;
        private RMWavConverter converter = null;

        public LoadTask(File file) {
            this.loadFile = file;
        }

        public LoadTask(File file, WavOp wavOp) {
            this.loadFile = file;
            this.wavOp = wavOp;
            if (wavOp != null) {
                this.converter = new RMWavConverter(RMIRSetup.this, wavOp == WavOp.MERGE ? RMIRSetup.this.remoteConfig : null);
                this.converter.setProgressUpdater(this);
            }
        }

        @Override
        protected RemoteConfiguration doInBackground() throws Exception {
            String title;
            String message;
            boolean mismatch;
            if (this.wavOp == null) {
                return new RemoteConfiguration(this.loadFile, RMIRSetup.this);
            }
            this.converter.importWav(this.loadFile);
            String importedSig = this.converter.getImportedSignature();
            String currentSig = RMIRSetup.this.remoteConfig == null ? null : RMIRSetup.this.remoteConfig.getRemote().getSignature();
            boolean bl = mismatch = importedSig != null && currentSig != null && !importedSig.substring(0, 4).equals(currentSig.substring(0, 4));
            if (this.wavOp == WavOp.MERGE && mismatch && JOptionPane.showConfirmDialog(RMIRSetup.this, message = "The imported data includes a signature that differs from that of\nthe current setup and so cannot be merged into it.  Do you want\ninstead to create a new image from the imported data?", title = "Inconsistent merge", 0, 3) != 0) {
                return RMIRSetup.this.remoteConfig;
            }
            RMIRSetup.this.resetConfig(this.wavOp == WavOp.MERGE && !mismatch ? null : this.converter.getRemote(), this.converter);
            return RMIRSetup.this.remoteConfig;
        }

        @Override
        public void done() {
            try {
                RemoteConfiguration rc = (RemoteConfiguration)this.get();
                if (rc != null) {
                    if (rc.isReplacement && rc.getNoSetup() == null) {
                        RMIRSetup.this.remoteConfig = null;
                        Remote remote = rc.getRemote();
                        String title = "Replacement Remote error";
                        String message = "Remote \"" + remote.getName() + "\"\nwith signature " + remote.getSignature() + " is a Replacement Remote that is\nnot yet fully supported.  RMPB.sys needs to be updated.";
                        RMIRSetup.this.setInterfaceState(null);
                        JOptionPane.showMessageDialog(rc.getOwner(), message, title, 0);
                        return;
                    }
                    RMIRSetup.this.remoteConfig = rc;
                }
            }
            catch (InterruptedException rc) {
            }
            catch (ExecutionException e) {
                String why = null;
                Throwable cause = e.getCause();
                why = cause != null ? cause.getMessage() : e.getMessage();
                System.err.println("Error setting new RemoteConfiguration: " + why);
                RMIRSetup.this.setInterfaceState(null);
                JOptionPane.showMessageDialog(RMIRSetup.this, "Error loading file " + this.loadFile.getName(), "Task error", 0);
                e.printStackTrace();
            }
            RMIRSetup.this.recreateToolbar();
            RMIRSetup.this.update();
            RMIRSetup.this.changed = RMIRSetup.this.remoteConfig != null ? !Hex.equals(RMIRSetup.this.remoteConfig.getSavedData(), RMIRSetup.this.remoteConfig.getData()) : false;
            RMIRSetup.this.setTitleFile(this.loadFile);
            RMIRSetup.this.setInterfaceState(null);
            RMIRSetup.this.file = this.loadFile;
            if (RMIRSetup.this.remoteConfig != null && RMIRSetup.this.currentPanel != null) {
                RMIRSetup.this.currentPanel.set(RMIRSetup.this.remoteConfig);
            }
        }

        @Override
        public void updateProgress(int value) {
            if (value < 0) {
                RMIRSetup.this.setInterfaceState("DOWNLOADING...");
            } else {
                String name = this.converter != null ? this.converter.getProgressName() : null;
                RMIRSetup.this.setInterfaceState(name != null ? name : "PREPARING:", value);
            }
        }
    }

    private class InstallTask
    extends WriteTask
    implements ProgressUpdater {
        private File file;
        private JP2BT btio;

        public InstallTask(File file, JP2BT btio) {
            this.file = null;
            this.btio = null;
            this.file = file;
            this.btio = btio;
        }

        @Override
        protected Void doInBackground() throws Exception {
            BTExtInstall installer = new BTExtInstall(this.file, this.btio, this);
            installer.install();
            return null;
        }

        @Override
        public void done() {
            super.done();
            RMIRSetup.this.setInterfaceState(null);
            if (!this.ok) {
                return;
            }
        }

        @Override
        public void updateProgress(int value) {
            RMIRSetup.this.setInterfaceState("INSTALLING:", value);
        }
    }

    private class UploadTask
    extends WriteTask
    implements ProgressUpdater {
        private short[] data;
        private boolean allowClockSet;
        private File file;
        private Use use;
        private IO io;

        private UploadTask(short[] data, boolean allowClockSet) {
            this.file = null;
            this.use = null;
            this.io = null;
            this.data = data;
            this.allowClockSet = allowClockSet;
            this.file = null;
            this.use = Use.UPLOAD;
        }

        private UploadTask(File file, short[] data, boolean allowClockSet, boolean forSaveAs) {
            this.file = null;
            this.use = null;
            this.io = null;
            this.data = data;
            this.allowClockSet = allowClockSet;
            this.file = file;
            this.use = forSaveAs ? Use.SAVEAS : Use.SAVING;
        }

        @Override
        protected Void doInBackground() throws Exception {
            int rc;
            String title;
            String message;
            int result;
            Remote remote = RMIRSetup.this.remoteConfig.getRemote();
            if (remote.isFDRA() && !RMIRSetup.this.remoteConfig.isSetToDanish() && RMIRSetup.this.remoteConfig.getLanguageIndex() == 9 && (result = NegativeDefaultButtonJOptionPane.showConfirmDialog(RMIRSetup.this, message = "The language of this setup is set to Danish.  Uploading it will cause your remote\nto crash if it does not have Danish installed as an Additional Language.  You can\ninstall it with RMIR by selecting the menu item\n\"Advanced > XSight operations > Set upgrade source file\"\nand selecting Danish as the additional language support required.  Then do a download\nfrom the remote and accept the offer of performing an upgrade.\n\nDo you wish to continue?", title = "Additional Language support", 0, 2)) != 0) {
                RMIRSetup.this.setInterfaceState(null);
                return null;
            }
            this.resetInterfaceState();
            IO io = RMIRSetup.this.getOpenInterface(this.file, this.use, this);
            if (io == null) {
                JOptionPane.showMessageDialog(RMIRSetup.this, "No remotes found!");
                RMIRSetup.this.setInterfaceState(null);
                return null;
            }
            System.err.println("Interface opened successfully");
            this.io = io;
            int eepromSize = remote.getEepromSize();
            int extraSize = 0;
            short[] extraData = null;
            if (this.use == Use.UPLOAD) {
                int rc2;
                int baseAddress = io.getRemoteEepromAddress();
                System.err.println("Base address = $" + Integer.toHexString(baseAddress).toUpperCase());
                String sig = RMIRSetup.getIOsignature(io, baseAddress);
                if (sig.length() > 8) {
                    sig = sig.substring(0, 6);
                }
                String rSig = remote.getSignature();
                String message2 = null;
                if (sig.length() < rSig.length() || !rSig.equals(sig.substring(0, rSig.length()))) {
                    message2 = "The signature of the attached remote does not match the signature you are trying to upload.  The image\nyou are trying to upload may not be compatible with attached remote, and uploading it may damage the\nremote.  Copying the contents of one remote to another is only safe when the remotes are identical.\n\nThis message will be displayed when installing an extender in your remote, which is the only time it is\nsafe to upload to a remote when the signatures do not match.\n\nHow would you like to proceed?";
                } else if (!suppressConfirmPrompts.isSelected()) {
                    message2 = "An upload overwrites the entire memory area for setup data in the remote and cannot\nbe undone.  Are you sure that you want to do this?";
                }
                Object[] options = new Object[]{"Upload to the remote", "Cancel the upload"};
                if (message2 != null && ((rc2 = JOptionPane.showOptionDialog(RMIRSetup.this, message2, "Upload Confirmation", -1, 2, null, options, options[1])) == 1 || rc2 == -1)) {
                    io.closeRemote();
                    RMIRSetup.this.setInterfaceState(null);
                    return null;
                }
                int pageSize = remote.getProcessor().getPageSize();
                short[] extraRemote = null;
                if (remote.isJP2style() && eepromSize % pageSize != 0) {
                    extraSize = pageSize - eepromSize % pageSize;
                    extraRemote = new short[extraSize];
                    io.readRemote(baseAddress + eepromSize, extraRemote);
                    extraData = Arrays.copyOfRange(this.data, eepromSize, eepromSize + extraSize);
                    System.err.println("Remote/Data extra bytes: " + new Hex(extraRemote) + " / " + new Hex(extraData));
                    System.arraycopy(extraRemote, 0, this.data, eepromSize, extraSize);
                }
            }
            AutoClockSet autoClockSet = remote.getAutoClockSet();
            if (this.allowClockSet && autoClockSet != null) {
                autoClockSet.saveTimeBytes(this.data);
                autoClockSet.setTimeBytes(this.data);
                RMIRSetup.this.remoteConfig.updateCheckSums();
            }
            if ((rc = io.writeRemote(remote.getBaseAddress(), this.data)) != this.data.length) {
                io.closeRemote();
                System.err.println("Data writing phase failed, bytes written = " + rc + "instead of " + this.data.length + ".");
                JOptionPane.showMessageDialog(RMIRSetup.this, "writeRemote returned " + rc);
                RMIRSetup.this.setInterfaceState(null);
                if (extraData != null) {
                    System.arraycopy(extraData, 0, this.data, eepromSize, extraSize);
                }
                return null;
            }
            System.err.println("Data writing phase succeeded, bytes written = " + rc + ".");
            if (RMIRSetup.this.verifyUploadItem.isSelected()) {
                System.err.println("Upload verification phase starting.");
                if (io.getInterfaceType() == 262 || (io.getInterfaceType() & 0xFFF7) == 2049) {
                    io.closeRemote();
                    io = RMIRSetup.this.getOpenInterface(null, Use.READING, this);
                }
                short[] readBack = new short[this.data.length];
                rc = io.readRemote(remote.getBaseAddress(), readBack);
                io.closeRemote();
                if (rc != this.data.length) {
                    System.err.println("Upload verify failed: read back " + rc + " bytes, but expected " + this.data.length + ".");
                    JOptionPane.showMessageDialog(RMIRSetup.this, "Upload verify failed: read back " + rc + " bytes, but expected " + this.data.length);
                } else if (!Hex.equals(this.data, readBack)) {
                    System.err.println("Upload verify failed: data read back doesn't match data written.");
                    JOptionPane.showMessageDialog(RMIRSetup.this, "Upload verify failed: data read back doesn't match data written.");
                } else {
                    System.err.println("Upload verification succeeded.");
                }
            } else {
                io.closeRemote();
                JOptionPane.showMessageDialog(RMIRSetup.this, "Upload complete!");
            }
            if (extraData != null) {
                System.arraycopy(extraData, 0, this.data, eepromSize, extraSize);
            }
            if (this.allowClockSet && autoClockSet != null) {
                autoClockSet.restoreTimeBytes(this.data);
                RMIRSetup.this.remoteConfig.updateCheckSums();
            }
            System.err.println("Ending upload");
            RMIRSetup.this.setInterfaceState(null);
            if (this.use == Use.SAVEAS) {
                RMIRSetup.this.file = this.file;
                RMIRSetup.this.setTitleFile(this.file);
                RMIRSetup.this.updateRecentFiles(this.file);
                RMIRSetup.this.saveAction.setEnabled(true);
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            if (!this.ok) {
                String message = this.file != null ? "Error saving Simpleset file " + this.file.getName() : "Error uploading to remote";
                JOptionPane.showMessageDialog(RMIRSetup.this, message, "Task error", 0);
            }
            if (RMIRSetup.this.exitPrompt) {
                RMIRSetup.this.exitPrompt = false;
                RMIRSetup.this.dispatchEvent(new WindowEvent(RMIRSetup.this, 201));
            }
        }

        @Override
        public void updateProgress(int value) {
            if (value < 0) {
                RMIRSetup.this.setInterfaceState("UPLOADING...");
            } else {
                String name = this.io != null ? this.io.getProgressName() : null;
                RMIRSetup.this.setInterfaceState(name != null ? name : "PREPARING:", value);
            }
        }
    }

    private class SaveTask
    extends WriteTask
    implements ProgressUpdater {
        private File file;
        private Use use;
        private RMWavConverter converter;
        private AddressRange range;

        public SaveTask(File file, Use use) {
            this.file = null;
            this.use = null;
            this.converter = null;
            this.range = null;
            this.file = file;
            this.use = use;
        }

        public SaveTask(File file, Use use, AddressRange range) {
            this.file = null;
            this.use = null;
            this.converter = null;
            this.range = null;
            this.file = file;
            this.use = use;
            this.converter = new RMWavConverter(RMIRSetup.this, RMIRSetup.this.remoteConfig);
            this.converter.setProgressUpdater(this);
            this.range = range;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.resetInterfaceState();
            if (this.use == Use.EXPORT && this.range == null) {
                RMIRSetup.this.remoteConfig.exportIR(this.file);
                if (RMIRSetup.this.exitPrompt) {
                    RMIRSetup.this.changed = false;
                }
                RMIRSetup.this.updateRecentFiles(this.file);
            } else if (this.use == Use.EXPORT) {
                this.converter.exportWav(this.file, this.range);
            } else {
                RMIRSetup.this.remoteConfig.save(this.file);
                RMIRSetup.this.changed = false;
                if (this.use == Use.SAVEAS && RMIRSetup.this.binLoaded() == null) {
                    RMIRSetup.this.file = this.file;
                    RMIRSetup.this.setTitleFile(this.file);
                    RMIRSetup.this.updateRecentFiles(this.file);
                    RMIRSetup.this.saveAction.setEnabled(true);
                }
            }
            RMIRSetup.this.setInterfaceState(null);
            return null;
        }

        @Override
        public void done() {
            super.done();
            RMIRSetup.this.setInterfaceState(null);
            if (!this.ok) {
                JOptionPane.showMessageDialog(RMIRSetup.this, "Error saving file " + this.file.getName(), "Task error", 0);
            }
            if (RMIRSetup.this.exitPrompt) {
                RMIRSetup.this.exitPrompt = false;
                RMIRSetup.this.dispatchEvent(new WindowEvent(RMIRSetup.this, 201));
            }
        }

        @Override
        public void updateProgress(int value) {
            if (value < 0) {
                RMIRSetup.this.setInterfaceState("DOWNLOADING...");
            } else {
                String name = this.converter != null ? this.converter.getProgressName() : null;
                RMIRSetup.this.setInterfaceState(name != null ? name : "PREPARING:", value);
            }
        }
    }

    public static enum Use {
        DOWNLOAD,
        READING,
        UPLOAD,
        SAVING,
        SAVEAS,
        EXPORT,
        RAWDOWNLOAD,
        CONNECT,
        SEARCH;

    }

    public static class SummarySection {
        public JP1TableModel<?> model = null;
        public String title = null;
        public Activity activity = null;
        public String subtitle = null;
        public TableSorter sorter = null;
        public JP1Table table = null;
    }

    private class XziteFileTask
    extends SwingWorker<Void, Void>
    implements ProgressUpdater {
        private String op = null;
        private IO io = null;

        public XziteFileTask(String op) {
            this.op = op;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Void doInBackground() throws Exception {
            String message;
            String title;
            IO io = RMIRSetup.this.getOpenInterface(null, Use.UPLOAD, this);
            if (io == null) {
                JOptionPane.showMessageDialog(RMIRSetup.this, "No remotes found!");
                RMIRSetup.this.setInterfaceState(null);
                return null;
            }
            System.err.println("Interface opened successfully");
            this.io = io;
            if (!(io instanceof CommHID)) {
                JOptionPane.showMessageDialog(RMIRSetup.this, "Not an XSight remote!");
                RMIRSetup.this.setInterfaceState(null);
                return null;
            }
            CommHID ioHID = (CommHID)io;
            if (!this.op.equals("Delete/Save") && !this.op.equals("FdraFirmware")) {
                File sysFile = RemoteMaster.getRmirSys();
                title = "XSight operation";
                message = null;
                if (forceUpgradeItem.isSelected() && this.op.equals("Reformat")) {
                    message = "You have checked the \"Force XSight Firmware Upgrade\" menu\nitem so the reformat and system file restore process will\nbe performed without checking that the MCU firmware is the\nlatest version.  If it is not the latest version then this\nprocess may corrupt the remote.\n\nAre you sure you wish to continue?";
                    int reply = JOptionPane.showConfirmDialog(RMIRSetup.this, message, title, 0, 2);
                    if (reply != 0) {
                        RMIRSetup.this.setInterfaceState(null);
                        return null;
                    }
                    message = null;
                } else if (ioHID.setFileData(sysFile)) {
                    Hex upgVersion = ioHID.getUpgradeData().get((Object)"MCUFIRMWARE").version;
                    Hex remoteVersion = new Hex(4);
                    ioHID.getXZITEVersion(remoteVersion);
                    if (!upgVersion.equals(remoteVersion)) {
                        message = "You do not have the latest firmware.  You need to\nupgrade to the latest version before you can use\nthis option.";
                    }
                } else {
                    message = "Unable to verify the firmware verion of your remote.\nThis option is only available for the latest firmware.";
                }
                if (message != null) {
                    JOptionPane.showMessageDialog(RMIRSetup.this, message, title, 1);
                    RMIRSetup.this.setInterfaceState(null);
                    return null;
                }
            }
            if (this.op.equals("Upload")) {
                RMListChooser.showDialog(RMIRSetup.this, ioHID, true);
            } else if (this.op.equals("Delete/Save")) {
                RMListChooser.showDialog(RMIRSetup.this, ioHID, false);
            } else if (this.op.equals("Reformat")) {
                ioHID.reformatXZITE();
                ioHID.closeRemote();
            } else if (this.op.equals("Verify")) {
                List<String> comments = ioHID.verifyXZITEfiles();
                ioHID.closeRemote();
                System.err.println("Verification of system files:");
                StringBuilder sb = new StringBuilder();
                int n = 0;
                for (String s : comments) {
                    if (n++ > 0) {
                        sb.append('\n');
                    }
                    sb.append(s);
                    System.err.println("  " + s);
                }
                String title2 = "System file verification";
                JOptionPane.showMessageDialog(null, sb.toString(), title2, 1);
            } else if (this.op.equals("FdraFirmware")) {
                String name = ioHID.saveFDRAfirmware();
                ioHID.closeRemote();
                title = "Save FDRA Firmware";
                message = name != null ? "The firmware of the remote has been saved to a file named " + name + "\n in the XSight subfolder of the RMIR installation folder.\n\nThe \"Set upgrade source file...\" item may be used to select this\nfile for reinstalling into the remote." : "The Save FDRA Firmware operation failed.";
                JOptionPane.showMessageDialog(RMIRSetup.this, message, title, 1);
            }
            RMIRSetup.this.setInterfaceState(null);
            return null;
        }

        @Override
        public void updateProgress(int value) {
            String name = this.io != null ? this.io.getProgressName() : null;
            RMIRSetup.this.setInterfaceState(name != null ? name : "PREPARING:", value);
        }
    }

    public class RDFMessage {
        private String reason = null;
        private JButton developmentButton = null;
        private JButton archiveButton = null;
        ActionListener rdfAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == RDFMessage.this.developmentButton) {
                        URL url = new URL("http://www.hifi-remote.com/forums/dload.php?action=category&cat_id=44");
                        JP1Frame.browse(url.toURI());
                    } else if (source == RDFMessage.this.archiveButton) {
                        URL url = new URL("http://www.hifi-remote.com/forums/dload.php?action=category&cat_id=180");
                        JP1Frame.browse(url.toURI());
                    }
                }
                catch (Exception x) {
                    x.printStackTrace(System.err);
                }
            }
        };

        public RDFMessage(String reason) {
            this.reason = reason;
        }

        public void showReason() {
            JPanel panel = new JPanel(new BorderLayout());
            String info = this.reason + "\n\nThis distribution contains only RDFs believed to be stable and tested.  RDFs\nstill under development are in the RDFs-Development folder and\nolder ones that are incomplete or untested are in the RDFs-Archive folder.\nTo open either or both folders in your web browser, press the corresponding\nbutton below.  You may find something to help you in those folders.";
            ProtocolDataPanel.DisplayArea infoArea = new ProtocolDataPanel.DisplayArea(info, null);
            infoArea.setLineWrap(false);
            infoArea.setBorder(BorderFactory.createEmptyBorder(0, 2, 10, 2));
            panel.add((Component)infoArea, "First");
            this.developmentButton = new JButton("Development");
            this.developmentButton.addActionListener(this.rdfAl);
            this.archiveButton = new JButton("Archive");
            this.archiveButton.addActionListener(this.rdfAl);
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.add(this.developmentButton);
            buttonPanel.add(Box.createHorizontalStrut(10));
            buttonPanel.add(this.archiveButton);
            Border buttonBorder = BorderFactory.createLineBorder(Color.GRAY);
            buttonPanel.setBorder(BorderFactory.createTitledBorder(buttonBorder, "Open RDF Folder: "));
            panel.add((Component)buttonPanel, "Last");
            JOptionPane.showMessageDialog(null, panel, "Unknown Remote", -1);
        }
    }

    private class ConnectTask
    extends WriteTask
    implements ProgressUpdater {
        private BLERemote bleRemote;
        private Use use;

        public ConnectTask(BLERemote bleRemote, Use use) {
            this.bleRemote = null;
            this.use = null;
            this.bleRemote = bleRemote;
            this.use = use;
            ((WriteTask)this).use = use;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (RMIRSetup.this.btio == null) {
                if (this.use == Use.CONNECT) {
                    RMIRSetup.this.setInterfaceState("CONNECTING:", 5);
                }
                RMIRSetup.this.btio = (JP2BT)RMIRSetup.this.getOpenInterface(null, Use.CONNECT, this);
                RMIRSetup.this.btio.setOwner(RMIRSetup.this);
            }
            if (RMIRSetup.this.btio == null) {
                String message = "Failed to open BLE interface on port " + JP1Frame.properties.getProperty("Port");
                JOptionPane.showMessageDialog(null, message, "Connection error", -1);
                RMIRSetup.this.bluetoothButton.setSelected(false);
                RMIRSetup.this.setInterfaceState(null);
            } else {
                RMIRSetup.this.btio.setDisconnecting(false);
                RMIRSetup.this.btio.setProgressUpdater(this);
                System.err.println("Progress updater set");
                if (this.use == Use.CONNECT && this.bleRemote != null) {
                    RMIRSetup.this.btio.setBleRemote(this.bleRemote);
                    try {
                        if (RMIRSetup.this.btio.connectUEI()) {
                            System.err.println("Connection complete");
                            RMIRSetup.this.bluetoothButton.setBorder(BorderFactory.createLoweredBevelBorder());
                            RMIRSetup.this.downloadAction.setEnabled(true);
                            RMIRSetup.this.installExtenderItem.setEnabled(true);
                            RMIRSetup.this.extraStatus.setVisible(false);
                            RMIRSetup.this.advProgressLabel.setText("Memory usage:");
                            RMIRSetup.this.bleStatus.setVisible(true);
                            RMIRSetup.this.updateBleStatus();
                            RMIRSetup.this.recreateToolbar();
                        } else {
                            RMIRSetup.this.disconnectBLE();
                            System.err.println("Connection failed to complete");
                            String message = "Attempt to connect to remote " + this.bleRemote.name + " failed";
                            JOptionPane.showMessageDialog(null, message, "Connection error", 0);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    RMIRSetup.this.setInterfaceState(null);
                } else if (this.use == Use.SEARCH && this.bleRemote == null) {
                    RMIRSetup.this.setInterfaceState("SEARCHING...");
                    RMIRSetup.this.btio.discoverUEI(true, findAllBTItem.isSelected());
                    RMIRSetup.this.searchButton.setEnabled(false);
                    String lastRemote = JP1Frame.properties.getProperty("LastBLERemote");
                    int listStart = 0;
                    long waitStart = Calendar.getInstance().getTimeInMillis();
                    while (RMIRSetup.this.btio != null && RMIRSetup.this.btio.isScanning() && Calendar.getInstance().getTimeInMillis() - waitStart < 900000L) {
                        int size = RMIRSetup.this.btio.getListSize();
                        if (size > listStart) {
                            System.err.println("Size now = " + size);
                            for (int i = listStart; i < size; ++i) {
                                String addr = RMIRSetup.this.btio.getListItem(i);
                                if (!RMIRSetup.this.bleMap.containsKey(addr)) {
                                    String ueiName = RMIRSetup.this.btio.getItemName(i);
                                    BLERemote dev = new BLERemote(ueiName + " " + addr.substring(9), ueiName, addr);
                                    dev.found = true;
                                    dev.rssi = RMIRSetup.this.btio.getRssi(i);
                                    System.err.println("Create remote: " + dev.toString());
                                    RMIRSetup.this.bleMap.put(addr, dev);
                                    continue;
                                }
                                ((BLERemote)((RMIRSetup)RMIRSetup.this).bleMap.get((Object)addr)).found = true;
                            }
                            listStart = size;
                        }
                        for (JRadioButton btn : RMIRSetup.this.bleBtnMap.keySet()) {
                            BLERemote rem = (BLERemote)RMIRSetup.this.bleBtnMap.get(btn);
                            if (!rem.found || btn.isEnabled()) continue;
                            btn.setEnabled(true);
                        }
                        if (RMIRSetup.this.bleMap.size() > RMIRSetup.this.bleBtnMap.size()) {
                            for (BLERemote dev : RMIRSetup.this.bleMap.values()) {
                                if (RMIRSetup.this.bleBtnMap.values().contains(dev)) continue;
                                JRadioButton rb = new JRadioButton(dev.name);
                                if (lastRemote != null && lastRemote.equals(dev.address)) {
                                    rb.setSelected(true);
                                }
                                RMIRSetup.this.bleBtnMap.put(rb, dev);
                                RMIRSetup.this.btGroup.add(rb);
                                RMIRSetup.this.box.add(rb);
                                RMIRSetup.this.changed = true;
                            }
                            RMIRSetup.this.box.revalidate();
                        }
                        Thread.sleep(200L);
                    }
                    RMIRSetup.this.searchButton.setEnabled(true);
                    if (RMIRSetup.this.btio != null) {
                        RMIRSetup.this.btio.discoverUEI(false, false);
                    }
                    RMIRSetup.this.setInterfaceState(null);
                }
            }
            return null;
        }

        @Override
        public void done() {
            super.done();
            RMIRSetup.this.setInterfaceState(null);
            if (this.use == Use.CONNECT && RMIRSetup.this.btio != null && RMIRSetup.this.btio.getBleRemote() != null && !((RMIRSetup)RMIRSetup.this).btio.getBleRemote().supportsUpload) {
                String title = "Connection";
                String message = "Please note that this remote needs an extender in order to\nsupport uploading via its Bluetooth interface.";
                JOptionPane.showMessageDialog(RMIRSetup.this, message, title, 1);
            }
            if (!this.ok) {
                RMIRSetup.this.bluetoothButton.setSelected(false);
                RMIRSetup.this.uploadable = false;
                RMIRSetup.this.uploadAction.setEnabled(false);
                RMIRSetup.this.downloadAction.setEnabled(false);
                if (this.why.equals("Can't initialize jni4net Bridge") || this.why.contains("0x80131515")) {
                    String taskName = this.use == Use.SEARCH ? "Search" : (this.use == Use.CONNECT ? "Connect" : "Unknown");
                    System.err.println(taskName + " error: " + this.why);
                    this.showUnblockMessage();
                    return;
                }
                JOptionPane.showMessageDialog(RMIRSetup.this, "Error connecting to remote " + this.bleRemote.name, "Task error", 0);
                return;
            }
        }

        @Override
        public void updateProgress(int value) {
            RMIRSetup.this.setInterfaceState("CONNECTING:", value);
        }

        private void showUnblockMessage() {
            String title = "Blocked Bluetooth DLLs";
            String msg = "The DLL files needed to use native Windows 10 Bluetooth support appear to be blocked.\nThis can happen as a result of the methods used to download and extract RMIR.  You need\nto unblock all DLLs in the rmirwin10ble subfolder of your RMIR installation folder.\nTo do so, right-click each file and select Properties.  You should see a Security message\nwith a checkbox labelled \"Unblock\".  Check this box and press \"OK\".  Repeat this for\neach of the DLLs in the folder, close RMIR if still open, then try again.";
            JOptionPane.showMessageDialog(RMIRSetup.this, msg, title, 0);
        }
    }

    private class WriteTask
    extends SwingWorker<Void, Void> {
        private String text = null;
        protected boolean ok = true;
        protected String why = null;
        protected Use use = null;

        public WriteTask() {
            this.text = null;
        }

        public WriteTask(String text) {
            this.text = text;
        }

        @Override
        protected Void doInBackground() throws Exception {
            RMIRSetup.this.setInterfaceState(this.text);
            return null;
        }

        @Override
        public void done() {
            this.ok = true;
            try {
                this.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                this.ok = false;
                Throwable cause = e.getCause();
                this.why = cause != null ? cause.getMessage() : e.getMessage();
                if (Use.SEARCH == this.use || Use.CONNECT == this.use) {
                    return;
                }
                System.err.println("Error in write task: " + this.why);
                e.printStackTrace();
            }
        }

        public void resetInterfaceState() {
            if (RMIRSetup.this.exitPrompt && RMIRSetup.this.interfaceText != null) {
                new WriteTask(RMIRSetup.this.interfaceText.substring(0, RMIRSetup.this.interfaceText.length() - 3) + " AND EXIT").execute();
            }
        }
    }
}

