/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.io.CommHID;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RMListChooser
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static RMListChooser dialog = null;
    private static String entry = null;
    private static Remote remote = null;
    private JList<String> list = null;
    private DefaultListModel<String> model = new DefaultListModel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JPanel opPanel = null;
    private JLabel statusLabel = null;
    private CommHID io = null;
    private JFileChooser fileChooser = null;
    private JRadioButton noneButton = null;
    private JRadioButton deleteButton = null;
    private JRadioButton saveButton = null;

    private RMListChooser(Component c, CommHID io, boolean write) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("File Selector");
        this.setModal(true);
        this.io = io;
        this.setModel(write);
        String fwVersion = io.getXZITEVersion(null);
        String heading = "Remote = " + remote.getName() + ".\nFirmware version = ";
        heading = heading + (fwVersion != null ? fwVersion : "Unknown") + "\n\n";
        heading = heading + (write ? "Select the firmware file to upload to the remote:" : "Files are listed together with their length in bytes.\nSelect the file to delete from the remote or save to the PC:");
        this.list = new JList<String>(this.model);
        int rowHeight = this.list.getFontMetrics(this.list.getFont()).getHeight() + 2;
        this.list.setVisibleRowCount(15);
        this.list.setSelectionMode(0);
        this.list.setPreferredSize(new Dimension(400, rowHeight * (this.model.getSize() + 1)));
        this.list.addListSelectionListener(this);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel selectPanel = new JPanel(new BorderLayout());
        selectPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)selectPanel, "Center");
        JScrollPane view = new JScrollPane(this.list);
        view.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        view.setBackground(Color.WHITE);
        selectPanel.add((Component)view, "Center");
        JPanel infoPanel = new JPanel(new FlowLayout(0));
        contentPane.add((Component)infoPanel, "First");
        JLabel label = new JLabel();
        JTextArea area = new JTextArea(heading);
        area.setBackground(label.getBackground());
        area.setFont(label.getFont());
        area.setEditable(false);
        infoPanel.add(area);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)bottomPanel, "Last");
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 2));
        JPanel statusPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)statusPanel, "Last");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        statusPanel.add((Component)buttonPanel, "After");
        this.statusLabel = new JLabel();
        this.statusLabel.setText("DELETING...");
        this.statusLabel.setForeground(Color.RED);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.statusLabel.setVisible(false);
        statusPanel.add((Component)this.statusLabel, "Before");
        if (!write) {
            this.opPanel = this.setOpPanel();
            bottomPanel.add((Component)this.opPanel, "Center");
        }
        this.okButton.addActionListener(this);
        this.okButton.setText(write ? "Upload" : "Execute");
        this.okButton.setEnabled(false);
        buttonPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setText("Close");
        buttonPanel.add(this.cancelButton);
    }

    private void setModel(boolean write) {
        block3: {
            block2: {
                this.model.clear();
                if (!write) break block2;
                File sysFile = RemoteMaster.getRmirSys();
                if (!this.io.setFileData(sysFile)) break block3;
                LinkedHashMap<String, CommHID.FileData> upgradeData = this.io.getUpgradeData();
                for (String name : CommHID.xziteSysNames) {
                    if (name.indexOf(46) <= 0 || !upgradeData.keySet().contains(name.toUpperCase())) continue;
                    this.model.addElement(name);
                }
                break block3;
            }
            LinkedHashMap<String, Integer> map = this.io.getXZITEfileList();
            for (String name : map.keySet()) {
                this.model.addElement(name + "  " + map.get(name));
            }
        }
    }

    public static void showDialog(RMIRSetup owner, CommHID io, boolean write) {
        RemoteConfiguration config = owner.getRemoteConfiguration();
        remote = config != null ? config.getRemote() : null;
        dialog = new RMListChooser((Component)owner, io, write);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        owner.setInterfaceState(null);
        dialog.setVisible(true);
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private JPanel setOpPanel() {
        this.noneButton = new JRadioButton("None");
        this.deleteButton = new JRadioButton("Delete");
        this.saveButton = new JRadioButton("Save");
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.noneButton);
        grp.add(this.deleteButton);
        grp.add(this.saveButton);
        this.noneButton.setSelected(true);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this.noneButton);
        panel.add(this.deleteButton);
        panel.add(this.saveButton);
        panel.setBorder(BorderFactory.createTitledBorder(" Operation to perform: "));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            if (this.statusLabel.isVisible()) {
                return;
            }
            entry = this.list.getSelectedValue();
            if (entry != null && entry.indexOf(32) > 0) {
                entry = entry.substring(0, entry.indexOf(32));
            }
            if (!(this.opPanel != null && this.noneButton.isSelected() || entry != null)) {
                String title = "File selector";
                String message = "You have not selected a file!";
                JOptionPane.showMessageDialog(this, message, title, 1);
                return;
            }
            if (this.opPanel == null) {
                this.statusLabel.setText("UPLOADING " + entry + "...");
                this.statusLabel.setVisible(true);
                new UploadTask().execute();
                return;
            }
            if (this.opPanel != null && this.deleteButton.isSelected()) {
                this.statusLabel.setText("DELETING " + entry + "...");
                this.statusLabel.setVisible(true);
                new DeleteTask().execute();
                return;
            }
            if (this.opPanel != null && this.saveButton.isSelected()) {
                if (this.fileChooser == null) {
                    this.fileChooser = new JFileChooser(RemoteMaster.getWorkDir());
                }
                this.fileChooser.setSelectedFile(new File(entry));
                int rval = this.fileChooser.showSaveDialog(this);
                if (rval == 0) {
                    this.statusLabel.setText("SAVING " + entry + "...");
                    this.statusLabel.setVisible(true);
                    File file = this.fileChooser.getSelectedFile();
                    new SaveTask(file).execute();
                }
                return;
            }
        } else if (source == this.cancelButton) {
            if (!this.statusLabel.isVisible()) {
                this.io.closeRemote();
            }
            entry = null;
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.okButton.setEnabled(this.list.getSelectedValue() != null);
    }

    private class UploadTask
    extends SwingWorker<Void, Void> {
        private UploadTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            ArrayList<String> names = new ArrayList<String>();
            names.add(entry);
            File sysFile = RemoteMaster.getRmirSys();
            boolean result = RMListChooser.this.io.writeSystemFiles(sysFile, names, 0);
            if (!result) {
                String title = "Upload request";
                String message = "Attempt to upload file " + entry + " failed.";
                JOptionPane.showMessageDialog(RMListChooser.this, message, title, 0);
            }
            RMListChooser.this.statusLabel.setVisible(false);
            return null;
        }
    }

    private class DeleteTask
    extends SwingWorker<Void, Void> {
        private DeleteTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            ArrayList<String> names = new ArrayList<String>();
            names.add(entry);
            boolean result = RMListChooser.this.io.deleteSystemFiles(names);
            if (!result) {
                String title = "Delete request";
                String message = "Attempt to delete file " + entry + " failed.";
                JOptionPane.showMessageDialog(RMListChooser.this, message, title, 0);
            }
            RMListChooser.this.setModel(false);
            RMListChooser.this.statusLabel.setVisible(false);
            return null;
        }
    }

    private class SaveTask
    extends SwingWorker<Void, Void> {
        File file = null;

        public SaveTask(File file) {
            this.file = file;
        }

        @Override
        protected Void doInBackground() throws Exception {
            byte[] data = RMListChooser.this.io.readSystemFile(entry);
            try {
                FileOutputStream output = new FileOutputStream(this.file, false);
                output.write(data, 0, data.length);
                output.flush();
                output.close();
            }
            catch (Exception e) {
                String title = "Save request";
                String message = "Attempt to save file " + entry + " failed.";
                JOptionPane.showMessageDialog(RMListChooser.this, message, title, 0);
            }
            RMListChooser.this.statusLabel.setVisible(false);
            return null;
        }
    }
}

