/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.TextFileViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RMNewDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final Comparator<Remote> BY_SIGNATURE = new Comparator<Remote>(){

        @Override
        public int compare(Remote o1, Remote o2) {
            return o1.getSignature().compareToIgnoreCase(o2.getSignature());
        }
    };
    public static final DefaultListCellRenderer DESCRIPTION = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Remote remote = (Remote)value;
            String text = remote.getName() + " (" + remote.getSignature() + ")";
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    };
    public static final DefaultListCellRenderer SIGNATURE = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Remote remote = (Remote)value;
            String text = remote.getSignature() + " (" + remote.getName() + ")";
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    };
    private JList remotesList = null;
    private JButton okButton = new JButton("OK");
    private JButton imageOkButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JButton infoButton = new JButton("Information");
    private JButton imageButton = new JButton("Image");
    private JButton rdfButton = new JButton(" RDF ");
    private JRadioButton descriptionButton = new JRadioButton("Description");
    private JRadioButton signatureButton = new JRadioButton("Signature");
    private JCheckBox extenderCheck = new JCheckBox("Exclude extenders", true);
    private DefaultListModel remotesModel = new DefaultListModel();
    private ArrayList<Remote> remotesArray = new ArrayList();
    private JDialog imageDialog = null;
    private static RMNewDialog dialog = null;
    private static Remote remote = null;

    private RMNewDialog(Component c) {
        super((JFrame)SwingUtilities.getRoot(c));
        this.setTitle("Select Remote Type");
        this.setModal(true);
        Collection<Remote> rm = RemoteManager.getRemoteManager().getRemotes();
        this.remotesArray.addAll(rm);
        this.remotesList = new JList(this.remotesModel);
        this.remotesList.setVisibleRowCount(20);
        this.remotesList.setSelectionMode(0);
        this.remotesList.addListSelectionListener(this);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel selectPanel = new JPanel(new BorderLayout());
        selectPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        contentPane.add((Component)selectPanel, "Center");
        selectPanel.add((Component)new JScrollPane(this.remotesList), "Center");
        JPanel auxPanel = new JPanel(new BorderLayout());
        selectPanel.add((Component)auxPanel, "Last");
        JPanel infoPanel = new JPanel(new FlowLayout(1));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        auxPanel.add((Component)infoPanel, "First");
        JPanel sortPanel = new JPanel(new FlowLayout(1));
        auxPanel.add((Component)sortPanel, "Last");
        this.infoButton.addActionListener(this);
        this.imageButton.addActionListener(this);
        this.rdfButton.addActionListener(this);
        infoPanel.add(new JLabel("View:  "));
        infoPanel.add(this.infoButton);
        infoPanel.add(this.imageButton);
        infoPanel.add(this.rdfButton);
        this.infoButton.setEnabled(false);
        this.imageButton.setEnabled(false);
        this.rdfButton.setEnabled(false);
        this.descriptionButton.addActionListener(this);
        this.signatureButton.addActionListener(this);
        this.extenderCheck.addActionListener(this);
        sortPanel.add(new JLabel("Sort by:  "));
        sortPanel.add(this.descriptionButton);
        sortPanel.add(this.signatureButton);
        sortPanel.add(new JLabel("        "));
        sortPanel.add(this.extenderCheck);
        ButtonGroup sortButtons = new ButtonGroup();
        sortButtons.add(this.descriptionButton);
        sortButtons.add(this.signatureButton);
        this.descriptionButton.setSelected(true);
        this.sortRemotes(DESCRIPTION);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        contentPane.add((Component)buttonPanel, "Last");
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
    }

    private void sortRemotes(DefaultListCellRenderer renderer) {
        if (renderer == DESCRIPTION) {
            Collections.sort(this.remotesArray);
        } else if (renderer == SIGNATURE) {
            Collections.sort(this.remotesArray, BY_SIGNATURE);
        }
        this.remotesModel.clear();
        for (Remote remote : this.remotesArray) {
            if (this.extenderCheck.isSelected() && (remote.getName().toUpperCase().contains("EXTENDER") || remote.getName().toUpperCase().contains(" EXT "))) continue;
            this.remotesModel.addElement(remote);
        }
        this.remotesList.setCellRenderer(renderer);
    }

    public static Remote showDialog(RMIRSetup owner) {
        dialog = new RMNewDialog((Component)owner);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        return remote;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            remote = (Remote)this.remotesList.getSelectedValue();
            if (remote == null) {
                String title = "Select Remote";
                String message = "You have not selected a remote!";
                JOptionPane.showMessageDialog(this, message, title, 1);
                return;
            }
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            remote = null;
            this.setVisible(false);
        } else if (source == this.descriptionButton) {
            this.sortRemotes(DESCRIPTION);
        } else if (source == this.signatureButton) {
            this.sortRemotes(SIGNATURE);
        } else if (source == this.extenderCheck) {
            this.sortRemotes(this.descriptionButton.isSelected() ? DESCRIPTION : SIGNATURE);
        } else if (source == this.infoButton) {
            Remote rm = (Remote)this.remotesList.getSelectedValue();
            rm.load();
            String title = "Information on Selected Remote";
            String message = "Name:  " + rm.getName() + "\nProcessor:  " + rm.getProcessorDescription() + "\nInterface:  " + rm.getInterfaceType() + "\nUses RDF for:  " + rm.getRdfName() + "\nSpecial Identification:  " + rm.getRdfIdentification();
            JOptionPane.showMessageDialog(this, message, title, 1);
        } else if (source == this.imageButton) {
            Remote rm = (Remote)this.remotesList.getSelectedValue();
            Remote.prelimLoad = true;
            rm.load();
            Remote.prelimLoad = false;
            ImageIcon image = rm.getImage();
            if (image == null) {
                String title = "Missing image";
                String message = "There is no image available for the selected remote";
                JOptionPane.showMessageDialog(this, message, title, 0);
                return;
            }
            this.imageDialog = new JDialog(this);
            this.imageDialog.setDefaultCloseOperation(2);
            this.imageDialog.setTitle("Image of Selected Remote");
            this.imageDialog.setModal(true);
            JComponent contentPane = (JComponent)this.imageDialog.getContentPane();
            JPanel header = new JPanel(new FlowLayout(1));
            header.add(new JLabel(rm.getName()));
            contentPane.add((Component)header, "First");
            JPanel footer = new JPanel(new FlowLayout(1));
            footer.add(this.imageOkButton);
            contentPane.add((Component)footer, "Last");
            this.imageOkButton.addActionListener(this);
            JLabel imageLabel = new JLabel(rm.getImage());
            imageLabel.setSize(rm.getWidth(), rm.getHeight());
            contentPane.add((Component)imageLabel, "Center");
            this.imageDialog.pack();
            this.imageDialog.setLocationRelativeTo(this);
            this.imageDialog.setVisible(true);
        } else if (source == this.imageOkButton) {
            this.imageDialog.dispose();
        } else if (source == this.rdfButton) {
            Remote remote = (Remote)this.remotesList.getSelectedValue();
            Remote.prelimLoad = true;
            remote.load();
            Remote.prelimLoad = false;
            String title = "RDF of Selected Remote";
            TextFileViewer.showFile(this, remote, title, false);
            Collection<Remote> rm = RemoteManager.getRemoteManager().getRemotes();
            this.remotesArray.clear();
            this.remotesArray.addAll(rm);
            this.sortRemotes(this.descriptionButton.isSelected() ? DESCRIPTION : SIGNATURE);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selected = this.remotesList.getSelectedIndex();
        this.infoButton.setEnabled(selected >= 0);
        this.imageButton.setEnabled(selected >= 0);
        this.rdfButton.setEnabled(selected >= 0);
    }
}

