/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.S3C80Processor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RMPBOutputPanel
extends JPanel {
    private ManualSettingsPanel msp = null;
    private JTextArea rmpbText = new JTextArea();
    private JTextArea pbText = new JTextArea();

    public RMPBOutputPanel(ManualSettingsPanel msp) {
        this.msp = msp;
        BoxLayout bl = new BoxLayout(this, 1);
        this.setLayout(bl);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add(box);
        JLabel rmpbLabel = new JLabel("Output formatted as protocols.ini entry");
        rmpbLabel.setAlignmentY(1.0f);
        box.add(rmpbLabel);
        this.rmpbText = new JTextArea(10, 40);
        this.rmpbText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rmpbText.setEditable(false);
        this.rmpbText.setLineWrap(true);
        this.rmpbText.setWrapStyleWord(true);
        this.rmpbText.setBackground(rmpbLabel.getBackground());
        JScrollPane scroll = new JScrollPane(this.rmpbText);
        this.add(scroll);
        this.add(Box.createVerticalStrut(20));
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add(box);
        JLabel pbLabel = new JLabel("Output formatted in PB style");
        pbLabel.setAlignmentY(1.0f);
        box.add(pbLabel);
        this.pbText = new JTextArea(10, 40);
        this.pbText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pbText.setEditable(false);
        this.pbText.setLineWrap(true);
        this.pbText.setWrapStyleWord(true);
        this.pbText.setBackground(rmpbLabel.getBackground());
        scroll = new JScrollPane(this.pbText);
        this.add(scroll);
    }

    public void updatePBOutput() {
        int firstRow = -1;
        String text = null;
        StringBuilder sbPB = new StringBuilder();
        StringBuilder sbRMPB = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sbRMPB.append("[" + this.msp.getProtocolName().getText().trim() + "]" + ls);
        sbRMPB.append("PID=" + this.msp.getPid().getText().trim() + ls);
        String variant = this.msp.getVariantName().getText().trim();
        if (!variant.equals("")) {
            sbRMPB.append("VariantName=" + variant + ls);
        }
        String intro = this.msp.getDeviceText().getText().replaceFirst("\\s++$", "").replaceAll("\\r", "").replaceAll("\\n", ls);
        sbRMPB.append(intro + ls);
        int row = 0;
        while (true) {
            this.msp.getTablePanel();
            if (row >= ManualCodePanel.getProcs().length) break;
            this.msp.getTablePanel();
            Processor proc = ManualCodePanel.getProcs()[row];
            text = this.getPBOutput(proc);
            if (text != null) {
                if (firstRow < 0) {
                    firstRow = row;
                } else {
                    sbPB.append(ls + ls);
                }
                sbPB.append(text);
                sbRMPB.append("Code." + proc.getEquivalentName() + "=");
                sbRMPB.append(this.msp.getProtocol().getCode(proc).toRawString() + ls);
            }
            ++row;
        }
        this.pbText.setText(sbPB.toString());
        this.rmpbText.setText(sbRMPB.toString());
    }

    public String getPBOutput(Processor proc) {
        String procName = proc.getFullName();
        Hex code = this.msp.getProtocol().getCode(proc);
        if (code == null || code.length() == 0) {
            return null;
        }
        if (proc instanceof S3C80Processor) {
            boolean isNew = ((S3C80Processor)proc).testCode(code) == S3C80Processor.CodeType.NEW;
            procName = isNew ? "S3C8+" : "S3C8";
        } else if (procName.equals("740")) {
            procName = "P8/740";
        }
        String ls = System.getProperty("line.separator");
        StringBuilder buff = new StringBuilder(300);
        buff.append("Upgrade protocol 0 = ");
        buff.append(this.msp.getPid().getText().trim());
        buff.append(" (");
        buff.append(procName);
        buff.append(")");
        buff.append(' ');
        buff.append(this.msp.getProtocolName().getText().trim());
        String variant = this.msp.getVariantName().getText().trim();
        if (!variant.equals("")) {
            buff.append(':' + variant);
        }
        buff.append(" (RMPB ");
        buff.append(RemoteMaster.getDisplayVersion());
        buff.append(')');
        try {
            BufferedReader rdr = new BufferedReader(new StringReader(code.toString(16)));
            String line = null;
            while ((line = rdr.readLine()) != null) {
                buff.append(ls);
                buff.append(line);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        buff.append(ls + "End");
        return buff.toString();
    }

    public JTextArea getPbText() {
        return this.pbText;
    }

    public JTextArea getRmpbText() {
        return this.rmpbText;
    }

    public void reset() {
        this.pbText.setText("");
        this.rmpbText.setText("");
    }
}

