/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;

public abstract class RMPanel
extends JPanel {
    public RMPanel() {
        super(new BorderLayout());
    }

    public abstract void set(RemoteConfiguration var1);

    protected void refresh() {
    }

    public abstract void addRMPropertyChangeListener(PropertyChangeListener var1);

    public static void setButtonKeys(Component cpt, JButton delButton, JButton newButton, JButton cloneButton) {
        cpt.addKeyListener(new ButtonKeyAdapter(delButton, newButton, cloneButton));
        if (newButton == null) {
            if (delButton != null) {
                delButton.setFocusable(false);
            }
            if (cloneButton != null) {
                cloneButton.setFocusable(false);
            }
            cpt.addFocusListener(new ButtonFocusAdapter(cpt, delButton, cloneButton));
        }
    }

    public static void setButtonKeys(Component cpt, JButton delButton) {
        RMPanel.setButtonKeys(cpt, delButton, null, null);
    }

    private static class ButtonKeyAdapter
    extends KeyAdapter {
        private JButton delButton = null;
        private JButton newButton = null;
        private JButton cloneButton = null;

        public ButtonKeyAdapter(JButton delButton, JButton newButton, JButton cloneButton) {
            this.delButton = delButton;
            this.newButton = newButton;
            this.cloneButton = cloneButton;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                if (this.delButton != null && this.delButton.isVisible() && this.delButton.isEnabled()) {
                    this.delButton.doClick();
                }
                e.consume();
            } else if (e.getKeyCode() == 155) {
                if (this.newButton != null && this.newButton.isVisible() && this.newButton.isEnabled()) {
                    this.newButton.doClick();
                }
                e.consume();
            } else if (e.getKeyCode() == 68 && (e.getModifiers() & 2) != 0) {
                if (this.cloneButton != null && this.cloneButton.isVisible() && this.cloneButton.isEnabled()) {
                    this.cloneButton.doClick();
                }
                e.consume();
            }
        }
    }

    private static class ButtonFocusAdapter
    implements FocusListener {
        private Component cpt = null;
        private JButton delButton = null;
        private JButton cloneButton = null;

        public ButtonFocusAdapter(Component cpt, JButton delButton, JButton cloneButton) {
            this.cpt = cpt;
            this.delButton = delButton;
            this.cloneButton = cloneButton;
        }

        @Override
        public void focusGained(FocusEvent e) {
            boolean selected = false;
            if (this.cpt instanceof JP1Table) {
                selected = ((JP1Table)this.cpt).getSelectedRow() >= 0;
            } else if (this.cpt instanceof JList) {
                selected = ((JList)this.cpt).getSelectedIndex() >= 0;
            } else if (this.cpt instanceof JTableX) {
                return;
            }
            if (this.delButton != null) {
                this.delButton.setEnabled(selected);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(selected);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.delButton != null) {
                this.delButton.setEnabled(false);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(false);
            }
        }
    }
}

