/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP2Analyzer;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualEditorPanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.UpdateChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RMProtocolBuilder
extends JP1Frame
implements ActionListener,
ChangeListener {
    public static ListCellRenderer<? super Protocol> protListRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = null;
            if (value instanceof Protocol) {
                Protocol p = (Protocol)value;
                text = p.getID() != null ? p.getID().toString() : "<unset>";
                String varName = p.getVariantName();
                if (varName != null && !varName.trim().isEmpty()) {
                    text = text + " (" + varName + ")";
                }
            }
            return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    };
    private static RMProtocolBuilder me = null;
    private boolean exitPrompt = false;
    private JMenuItem exitItem = null;
    private JRadioButtonMenuItem[] lookAndFeelItems = null;
    private ActionEvent lfEvent = null;
    private JTabbedPane tabbedPane = null;
    private JTextArea deviceText = null;
    private JComboBox<String> protNames = new JComboBox();
    private JComboBox<Protocol> protList = new JComboBox();
    private ProtocolManager protocolManager = ProtocolManager.getProtocolManager();
    private ManualSettingsPanel manualSettingsPanel = null;
    private JComboBox<Processor> procBox = new JComboBox();
    private JMenu recentFileMenu = null;
    private JMenuItem rmpbReadmeItem = null;
    private JMenuItem homePageItem = null;
    private JMenuItem forumItem = null;
    private JMenuItem wikiItem = null;
    private JMenuItem aboutItem = null;
    private JMenuItem updateItem = null;
    private JMenuItem allMAXQItem = null;
    private JMenuItem allTI2541Item = null;
    private JToolBar toolBar = null;
    private PBAction newAction = null;
    private PBAction openAction = null;
    private PBAction saveAction = null;
    private PBAction saveAsAction = null;
    private PBAction importAction = null;
    private PBAction exportAction = null;
    private Clipboard clipboard = null;
    private PBAction copyToClipboardAction = null;
    private PBAction pasteFromClipboardAction = null;
    private static final String[] anyEndings = new String[]{".txt", ".rmpb"};
    private static final String[] pbEndings = new String[]{".txt"};

    public RMProtocolBuilder(PropertyFile properties) {
        super("RM Protocol Builder (RMPB)", properties);
        RemoteMaster.frame = this;
        System.err.println("RMProtocolBuilder opening");
        me = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent event) {
                boolean doDispose = true;
                try {
                    System.err.println("RMProtocolBuilder.windowClosing() entered");
                    if (!RMProtocolBuilder.this.promptToSave()) {
                        System.err.println("RMProtocolBuilder.windowClosing() exited");
                        doDispose = false;
                        return;
                    }
                    System.err.println("RMProtocolBuilder.windowClosing() continuing");
                    RMProtocolBuilder.this.savePreferences();
                    me = null;
                }
                catch (Exception e) {
                    System.err.println("RMProtocolBuilder.windowClosing() caught an exception!");
                    e.printStackTrace(System.err);
                }
                finally {
                    if (doDispose) {
                        RMProtocolBuilder.this.dispose();
                    }
                }
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.createMenus();
        this.createToolbar();
        this.add((Component)this.toolBar, "First");
        preferences.load(this.recentFileMenu, "RecentProtocols", this);
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ManualProtocol mp = new ManualProtocol(null, null);
        ManualEditorPanel editorPanel = new ManualEditorPanel(this);
        this.add((Component)editorPanel, "Center");
        this.manualSettingsPanel = editorPanel.getManualSettingsPanel();
        this.manualSettingsPanel.setLoadInProgress(true);
        this.manualSettingsPanel.setProtocol(mp, true);
        this.manualSettingsPanel.getProtocolName().setText(null);
        this.manualSettingsPanel.getAssemblerPanel().setRmpbSaveAsAction(this.saveAsAction);
        this.tabbedPane = editorPanel.getTabbedPane();
        this.deviceText = this.manualSettingsPanel.getDeviceText();
        this.tabbedPane.addTab("Output Data", this.manualSettingsPanel.getOutputPanel());
        String note = "Code imported from protocols.ini with the Import button on the toolbar (or the Protocol > Import... menu item) is initially shown in GRAY.  To complete the import process, select the entries you wish to import for analysis or editing and press the \"Import Hex\" button.  Code in BLACK is already imported for such use.\n\nThe form of any import to the assembler is determined by the settings of the \"Use predefined constants\" check boxes.\n\nAll entries can be edited or created directly as hex data by double-clicking.";
        this.manualSettingsPanel.getTablePanel().getNoteArea().setText(note);
        this.procBox = this.manualSettingsPanel.getProcBox();
        this.protNames.addActionListener(this);
        this.protList.setRenderer(protListRenderer);
        String[] names = this.protocolManager.getNames().toArray(new String[0]);
        this.protNames.setModel(new DefaultComboBoxModel<String>(names));
        List<Protocol> list = this.protocolManager.getByName().get(names[0]);
        if (list != null && list.size() > 0) {
            this.protList.setModel(new DefaultComboBoxModel<Protocol>(list.toArray(new Protocol[0])));
        }
        this.pack();
        Rectangle bounds = preferences.getPBBounds();
        this.procBox.setSelectedIndex(0);
        this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.ASM);
        this.tabbedPane.addChangeListener(this);
        this.manualSettingsPanel.setLoadInProgress(false);
        if (bounds != null) {
            this.setBounds(bounds);
        }
        this.setVisible(true);
    }

    private void createMenus() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        this.newAction = new PBAction("New", "NEW", RMIRSetup.createIcon("RMNew24"), "Create new protocol", 78);
        menu.add(this.newAction).setIcon(null);
        this.openAction = new PBAction("Open...", "OPEN", RMIRSetup.createIcon("RMOpen24"), "Open a file", 79);
        menu.add(this.openAction).setIcon(null);
        this.saveAction = new PBAction("Save", "SAVE", RMIRSetup.createIcon("Save24"), "Save to file", 83);
        this.saveAction.setEnabled(false);
        menu.add(this.saveAction).setIcon(null);
        this.saveAsAction = new PBAction("Save as...", "SAVEAS", RMIRSetup.createIcon("SaveAs24"), "Save to a different file", 65);
        this.saveAsAction.setEnabled(false);
        JMenuItem menuItem = menu.add(this.saveAsAction);
        menuItem.setDisplayedMnemonicIndex(5);
        menuItem.setIcon(null);
        menu.addSeparator();
        this.recentFileMenu = new JMenu("Recent");
        this.recentFileMenu.setMnemonic(82);
        this.recentFileMenu.setEnabled(false);
        menu.add(this.recentFileMenu);
        menu.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setMnemonic(88);
        this.exitItem.addActionListener(this);
        menu.add(this.exitItem);
        menu = new JMenu("Protocol");
        menu.setMnemonic(80);
        menuBar.add(menu);
        this.importAction = new PBAction("Import...", "IMPORT", RMIRSetup.createIcon("Import24"), "Import from protocols.ini", 73);
        menu.add(this.importAction).setIcon(null);
        this.exportAction = new PBAction("Export...", "EXPORT", RMIRSetup.createIcon("Export24"), "Export as protocols.ini add-on", 69);
        menu.add(this.exportAction).setIcon(null);
        menu.addSeparator();
        this.copyToClipboardAction = new PBAction("Copy to clipboard", "COPYTOCLIPBOARD", RMIRSetup.createIcon("Copy24"), "Copy to clipboard in PB-style format", 68);
        menu.add(this.copyToClipboardAction).setIcon(null);
        this.pasteFromClipboardAction = new PBAction("Paste from clipboard...", "PASTEFROMCLIPBOARD", RMIRSetup.createIcon("Paste24"), "Paste from clipboard in PB-style format", 80);
        menu.add(this.pasteFromClipboardAction).setIcon(null);
        menu.addSeparator();
        JMenu analysesSubMenu = new JMenu("Analyze to file...");
        analysesSubMenu.setMnemonic(65);
        analysesSubMenu.setToolTipText(JTableX.getHtmlToolTip(">Output to text file an analysis of all executors in protocols.ini<br>for a chosen JP2/JP3 processor"));
        menu.add(analysesSubMenu);
        this.allMAXQItem = new JMenuItem("All MAXQ protocols");
        this.allMAXQItem.setMnemonic(77);
        this.allMAXQItem.setToolTipText("Analyze to MAXQAnalyses.txt all MAXQ executors in protocols.ini");
        this.allMAXQItem.addActionListener(this);
        analysesSubMenu.add(this.allMAXQItem);
        this.allTI2541Item = new JMenuItem("All TI2541 protocols");
        this.allTI2541Item.setMnemonic(84);
        this.allTI2541Item.setToolTipText("Analyze to TI2541Analyses.txt all TI2541 executors in protocols.ini");
        this.allTI2541Item.addActionListener(this);
        analysesSubMenu.add(this.allTI2541Item);
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuBar.add(menu);
        JMenu submenu = new JMenu("Look and Feel");
        submenu.setMnemonic(76);
        menu.add(submenu);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RMProtocolBuilder.this.lfEvent = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String title = "Look and Feel";
                            String message = "Due to a bug in Java, you may find it necessary to close and then re-open RMIR\nfor it to work properly after a change of Look and Feel.  Moreover, you may need\nto use the menu item File > Exit to close it.  To abort the change press Cancel,\notherwise press OK to continue.";
                            if (JOptionPane.showConfirmDialog(RMProtocolBuilder.this, message, title, 2, 1) == 2) {
                                String lf = UIManager.getLookAndFeel().getName();
                                for (JRadioButtonMenuItem item : RMProtocolBuilder.this.lookAndFeelItems) {
                                    if (!item.getText().equals(lf)) continue;
                                    item.setSelected(true);
                                    break;
                                }
                                return;
                            }
                            JRadioButtonMenuItem item = (JRadioButtonMenuItem)RMProtocolBuilder.this.lfEvent.getSource();
                            String lf = item.getActionCommand();
                            UIManager.setLookAndFeel(lf);
                            JP1Frame.preferences.setLookAndFeel(lf);
                            SwingUtilities.updateComponentTreeUI(me);
                            JP1Frame.preferences.setLookAndFeel(lf);
                        }
                        catch (Exception x) {
                            x.printStackTrace(System.err);
                        }
                    }
                });
            }
        };
        ButtonGroup group = new ButtonGroup();
        String lookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelItems = new JRadioButtonMenuItem[info.length];
        for (int i = 0; i < info.length; ++i) {
            JRadioButtonMenuItem item;
            this.lookAndFeelItems[i] = item = new JRadioButtonMenuItem(info[i].getName());
            item.setMnemonic(item.getText().charAt(0));
            item.setActionCommand(info[i].getClassName());
            group.add(item);
            submenu.add(item);
            if (item.getActionCommand().equals(lookAndFeel)) {
                item.setSelected(true);
            }
            item.addActionListener(al);
        }
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        if (RMProtocolBuilder.desktopUsable()) {
            this.rmpbReadmeItem = new JMenuItem("Using RMPB", 85);
            this.rmpbReadmeItem.addActionListener(this);
            menu.add(this.rmpbReadmeItem);
            menu.addSeparator();
            this.homePageItem = new JMenuItem("Home Page", 72);
            this.homePageItem.addActionListener(this);
            menu.add(this.homePageItem);
            this.forumItem = new JMenuItem("Forums", 70);
            this.forumItem.addActionListener(this);
            menu.add(this.forumItem);
            this.wikiItem = new JMenuItem("Wiki", 87);
            this.wikiItem.addActionListener(this);
            menu.add(this.wikiItem);
            menu.addSeparator();
        }
        this.updateItem = new JMenuItem("Check for updates", 67);
        this.updateItem.addActionListener(this);
        menu.add(this.updateItem);
        this.aboutItem = new JMenuItem("About...");
        this.aboutItem.setMnemonic(65);
        this.aboutItem.addActionListener(this);
        menu.add(this.aboutItem);
    }

    private void createToolbar() {
        this.toolBar.add(this.newAction);
        this.toolBar.add(this.openAction);
        this.toolBar.add(this.saveAction);
        this.toolBar.add(this.saveAsAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.importAction);
        this.toolBar.add(this.exportAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.copyToClipboardAction);
        this.toolBar.add(this.pasteFromClipboardAction);
    }

    public ManualSettingsPanel getManualSettingsPanel() {
        return this.manualSettingsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.exitItem) {
                this.dispatchEvent(new WindowEvent(this, 201));
            } else if (source == this.protNames) {
                String name = (String)this.protNames.getSelectedItem();
                List<Protocol> list = this.protocolManager.getByName().get(name);
                if (list != null && list.size() > 0) {
                    this.protList.setModel(new DefaultComboBoxModel<Protocol>(list.toArray(new Protocol[0])));
                } else {
                    this.protList.setModel(new DefaultComboBoxModel());
                }
            } else if (source == this.rmpbReadmeItem) {
                File rmpbReadme = new File(RemoteMaster.getWorkDir(), "RMPB_Readme.html");
                RMProtocolBuilder.browse(rmpbReadme.toURI());
            } else if (source == this.homePageItem) {
                URL url = new URL("https://controlremote.sourceforge.io/");
                RMProtocolBuilder.browse(url);
            } else if (source == this.forumItem) {
                URL url = new URL("http://www.hifi-remote.com/forums/");
                RMProtocolBuilder.browse(url);
            } else if (source == this.wikiItem) {
                URL url = new URL("http://www.hifi-remote.com/wiki/index.php?title=Main_Page");
                RMProtocolBuilder.browse(url);
            } else if (source == this.updateItem) {
                UpdateChecker.checkUpdateAvailable(this);
            } else if (source == this.aboutItem) {
                String text = "<html><b>RM Protocol Builder (RMPB), " + RemoteMaster.getDisplayVersion() + "</b><p>Get the latest version at <a href=\"https://controlremote.sourceforge.io\">https://controlremote.sourceforge.io</a></p><p>Java version " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "</p><p>Home directory is <b>" + RemoteMaster.getWorkDir() + "</b></p><p>Add-Ons directory is <b>" + RemoteMaster.getAddonDir() + "</b></p><p>This application within the overall RemoteMaster program was written primarily by Graham&nbsp;Dixon, loosely based on the Excel-based Protocol Builder program by John Fine, Mark Pierson and others that is currently maintained by Mike England.</p><p>RemoteMaster itself was written originally by Greg&nbsp;Bush with help from John&nbsp;S&nbsp;Fine, Nils&nbsp;Ekberg, Jon&nbsp;Armstrong, Robert&nbsp;Crowe, Mark&nbsp;Pauker, Mark&nbsp;Pierson and Mike&nbsp;England</p><p>Subsequently developed by Graham Dixon with help from Ross&nbsp;Day, Marcin&nbsp;Jaworski, Bengt&nbsp;Martensson and Dave&nbsp;Reed</p></html>";
                JEditorPane pane = new JEditorPane("text/html", text);
                pane.addHyperlinkListener(this);
                pane.setEditable(false);
                pane.setBackground(this.getContentPane().getBackground());
                new TextPopupMenu(pane);
                final JScrollPane scroll = new JScrollPane(pane);
                Dimension d = pane.getPreferredSize();
                d.height = d.height * 3 / 2;
                d.width = d.width * 1 / 3;
                scroll.setPreferredSize(d);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                        scroll.getHorizontalScrollBar().setValue(0);
                    }
                });
                JOptionPane.showMessageDialog(this, scroll, "About RMPB", 1);
            } else if (source == this.allMAXQItem) {
                Processor p = ProcessorManager.getProcessor("MAXQ610");
                JP2Analyzer jp2 = new JP2Analyzer();
                jp2.analyze(p, "MAXQanalyses.txt");
                String message = "<html>Analysis of all MAXQ protocols has been written to the file \"MAXQanalyses.txt\"<br>in the RMIR installation folder.</html>";
                JOptionPane.showMessageDialog(this, message, "Analysis complete", -1);
            } else if (source == this.allTI2541Item) {
                Processor p = ProcessorManager.getProcessor("TI2541");
                JP2Analyzer jp2 = new JP2Analyzer();
                jp2.analyze(p, "TI2541analyses.txt");
                String message = "<html>Analysis of all TI2541 protocols has been written to the file \"TI2541analyses.txt\"<br>in the RMIR installation folder.</html>";
                JOptionPane.showMessageDialog(this, message, "Analysis complete", -1);
            } else {
                JMenuItem item = (JMenuItem)source;
                File f = new File(item.getText());
                try {
                    this.loadProtocol(f);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void saveAs() {
        File f = this.manualSettingsPanel.saveAs();
        this.saveAction.setEnabled(f != null);
        try {
            if (f != null) {
                this.setTitle("RMPB: " + f.getCanonicalPath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static File getProtocolFile(Component parent, boolean rmpbOnly) {
        File path = preferences.getProtocolPath();
        File file = null;
        RMFileChooser chooser = new RMFileChooser(path);
        try {
            chooser.setAcceptAllFileFilterUsed(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        EndingFileFilter filter = null;
        if (rmpbOnly) {
            filter = new EndingFileFilter("RMPB files (*.rmpb)", RemoteMaster.protocolEndings);
            chooser.addChoosableFileFilter(filter);
        } else {
            filter = new EndingFileFilter("All protocol files", anyEndings);
            chooser.addChoosableFileFilter(filter);
            chooser.addChoosableFileFilter(new EndingFileFilter("RMPB files (*.rmpb)", RemoteMaster.protocolEndings));
            chooser.addChoosableFileFilter(new EndingFileFilter("Excel PB files (*.txt)", pbEndings));
        }
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            if (!file.exists()) {
                JOptionPane.showMessageDialog(parent, file.getName() + " doesn't exist.", "File doesn't exist.", 0);
            } else if (file.isDirectory()) {
                JOptionPane.showMessageDialog(parent, file.getName() + " is a directory.", "File doesn't exist.", 0);
            } else {
                preferences.setProtocolPath(file.getParentFile());
            }
        }
        return file;
    }

    public void loadProtocol(File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        System.err.println("Opening " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        if (!this.promptToSave()) {
            return;
        }
        boolean isRMPB = file.getName().toLowerCase().endsWith(".rmpb");
        boolean isTxt = file.getName().toLowerCase().endsWith(".txt");
        this.reset();
        if (isRMPB) {
            this.manualSettingsPanel.loadRMPB(file, false, -1);
            this.saveAction.setEnabled(true);
        } else if (isTxt) {
            this.manualSettingsPanel.loadPB(file);
        }
        this.saveAsAction.setEnabled(true);
        if (isRMPB || isTxt) {
            this.updateRecentFiles(file);
            this.setTitle("RMPB: " + file.getCanonicalPath());
        } else {
            this.setTitle("RMPB");
        }
        preferences.setProtocolPath(file.getParentFile());
    }

    private void updateRecentFiles(File file) throws IOException {
        boolean isRMPB = file.getName().toLowerCase().endsWith(".rmpb");
        boolean isTxt = file.getName().toLowerCase().endsWith(".txt");
        if (isRMPB || isTxt) {
            JMenuItem item;
            int i;
            for (i = this.recentFileMenu.getItemCount() - 1; i >= 0; --i) {
                item = this.recentFileMenu.getItem(i);
                File f = new File(item.getText());
                if (!f.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                this.recentFileMenu.remove(i);
            }
            i = this.recentFileMenu.getItemCount();
            while (i > 9) {
                this.recentFileMenu.remove(--i);
            }
            item = new JMenuItem(file.getAbsolutePath());
            item.addActionListener(this);
            this.recentFileMenu.add((Component)item, 0);
            this.recentFileMenu.setEnabled(true);
        }
    }

    private void savePreferences() throws Exception {
        int state = this.getExtendedState();
        if (state != 0) {
            this.setExtendedState(0);
        }
        preferences.setPBBounds(this.getBounds());
        preferences.save(this.recentFileMenu, "RecentProtocols");
    }

    private void reset() {
        this.manualSettingsPanel.reset(true);
        this.saveAction.setEnabled(false);
        this.saveAsAction.setEnabled(false);
    }

    public boolean promptToSave() throws IOException {
        return this.promptToSave(false);
    }

    public boolean promptToSave(boolean doExit) {
        if (!this.manualSettingsPanel.isChanged()) {
            return true;
        }
        int rc = JOptionPane.showConfirmDialog(this, "The data has changed.  Do you want to save\nthe current protocol before proceeding?", "Save protocol?", 1);
        if (rc == 2 || rc == -1) {
            return false;
        }
        if (rc == 1) {
            return true;
        }
        this.exitPrompt = doExit;
        if (this.saveAction.isEnabled()) {
            this.manualSettingsPanel.saveRMPB();
        } else {
            this.saveAs();
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int indexAsm = this.tabbedPane.indexOfTab("Assembler");
        int indexDisasm = this.tabbedPane.indexOfTab("Disassembler");
        int indexOutput = this.tabbedPane.indexOfTab("Output Data");
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index == indexAsm && indexDisasm >= 0) {
            this.tabbedPane.setComponentAt(indexDisasm, null);
            this.tabbedPane.setComponentAt(indexAsm, this.manualSettingsPanel);
            this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.ASM);
            this.manualSettingsPanel.getAssemblerPanel().optionsPanel.setVisible(false);
        } else if (index == indexDisasm && indexAsm >= 0) {
            this.tabbedPane.setComponentAt(indexAsm, null);
            this.tabbedPane.setComponentAt(indexDisasm, this.manualSettingsPanel);
            this.manualSettingsPanel.setMode(ProtocolDataPanel.Mode.DISASM);
            this.manualSettingsPanel.getAssemblerPanel().optionsPanel.setVisible(true);
        } else if (index == indexOutput) {
            this.manualSettingsPanel.getOutputPanel().updatePBOutput();
        }
    }

    public class PBAction
    extends AbstractAction {
        public PBAction(String text, String action, ImageIcon icon, String description, Integer mnemonic) {
            super(text, icon);
            this.putValue("ActionCommandKey", action);
            this.putValue("ShortDescription", description);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String command = event.getActionCommand();
                if (command.equals("NEW")) {
                    if (!RMProtocolBuilder.this.promptToSave()) {
                        return;
                    }
                    RMProtocolBuilder.this.reset();
                } else if (command.equals("IMPORT")) {
                    if (!RMProtocolBuilder.this.promptToSave()) {
                        return;
                    }
                    Box box = Box.createVerticalBox();
                    JPanel panel = new JPanel(new FlowLayout(0));
                    panel.add(new JLabel("Select name:"));
                    box.add(panel);
                    box.add(RMProtocolBuilder.this.protNames);
                    panel = new JPanel(new FlowLayout(0));
                    panel.add(new JLabel("Select by PID & variant name:"));
                    box.add(panel);
                    box.add(RMProtocolBuilder.this.protList);
                    String title = "Import Protocol";
                    int result = JOptionPane.showConfirmDialog(RMProtocolBuilder.this, box, title, 2, -1);
                    if (result == 0) {
                        RMProtocolBuilder.this.manualSettingsPanel.setLoadInProgress(true);
                        Protocol protocol = (Protocol)RMProtocolBuilder.this.protList.getSelectedItem();
                        ManualProtocol mp = protocol.convertToManual(null, null, null);
                        mp.setName(protocol.getName());
                        mp.setVariantName(protocol.getVariantName());
                        Processor proc = null;
                        for (Processor pr : ManualCodePanel.getProcs()) {
                            if (protocol.getCode().get(pr.getEquivalentName()) == null) continue;
                            proc = pr;
                            break;
                        }
                        RMProtocolBuilder.this.reset();
                        RMProtocolBuilder.this.manualSettingsPanel.setDisplayProtocol(protocol);
                        RMProtocolBuilder.this.manualSettingsPanel.setProtocol(mp, true);
                        RMProtocolBuilder.this.deviceText.setText(RMProtocolBuilder.this.manualSettingsPanel.getProtocolText(true, false));
                        int ndx = RMProtocolBuilder.this.tabbedPane.indexOfTab("Hex Code");
                        RMProtocolBuilder.this.tabbedPane.setSelectedIndex(ndx);
                        RMProtocolBuilder.this.manualSettingsPanel.setLoadInProgress(false);
                    }
                } else if (command.equals("EXPORT")) {
                    RMProtocolBuilder.this.manualSettingsPanel.getOutputPanel().updatePBOutput();
                    RMProtocolBuilder.this.manualSettingsPanel.writeProtFile(RMProtocolBuilder.this.manualSettingsPanel.getOutputPanel().getRmpbText().getText());
                } else if (command.equals("OPEN")) {
                    File file = RMProtocolBuilder.getProtocolFile(RMProtocolBuilder.this, false);
                    try {
                        RMProtocolBuilder.this.loadProtocol(file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else if (command.equals("SAVE")) {
                    RMProtocolBuilder.this.manualSettingsPanel.saveRMPB();
                } else if (command.equals("SAVEAS")) {
                    RMProtocolBuilder.this.saveAs();
                } else if (command.equals("COPYTOCLIPBOARD")) {
                    RMProtocolBuilder.this.manualSettingsPanel.getOutputPanel().updatePBOutput();
                    String text = RMProtocolBuilder.this.manualSettingsPanel.getOutputPanel().getPbText().getText();
                    StringSelection data = new StringSelection(text);
                    RMProtocolBuilder.this.clipboard.setContents(data, data);
                } else if (command.equals("PASTEFROMCLIPBOARD")) {
                    RMProtocolBuilder.this.manualSettingsPanel.importFromClipboard();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

