/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.RMSetter;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RMSetterDialog<T>
extends JDialog {
    private String title = null;
    private T value = null;
    private SetterDialog<?> dialog = null;
    private ButtonEnabler buttonEnabler = null;

    public <C extends JComponent> T showDialog(Component locationComp, RemoteConfiguration remoteConfig, Class<C> panelClass, T value) {
        if (this.dialog == null || remoteConfig != this.dialog.getRemoteConfig()) {
            this.dialog = new SetterDialog(locationComp, panelClass, remoteConfig);
        }
        this.dialog.setValue(value);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(locationComp);
        this.dialog.setVisible(true);
        return this.value;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void setButtonEnabler(ButtonEnabler buttonEnabler) {
        this.buttonEnabler = buttonEnabler;
    }

    private class SetterDialog<C extends JComponent>
    extends JDialog
    implements ActionListener {
        private C mainPanel;
        private RemoteConfiguration remoteConfig;

        private SetterDialog(Component c, Class<C> panelClass, RemoteConfiguration remoteConfig) {
            super((JFrame)SwingUtilities.getRoot(c));
            this.setTitle(RMSetterDialog.this.title);
            this.setModal(true);
            this.remoteConfig = remoteConfig;
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this);
            JButton setButton = new JButton("Set");
            setButton.setActionCommand("Set");
            setButton.addActionListener(this);
            this.getRootPane().setDefaultButton(setButton);
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().registerKeyboardAction(this, stroke, 2);
            JPanel buttonPanel = new JPanel(new FlowLayout(4));
            buttonPanel.add(setButton);
            buttonPanel.add(cancelButton);
            Container contentPane = this.getContentPane();
            this.mainPanel = null;
            try {
                this.mainPanel = (JComponent)panelClass.newInstance();
                if (this.mainPanel instanceof MacroDefinitionBox) {
                    MacroDefinitionBox macroBox = (MacroDefinitionBox)this.mainPanel;
                    macroBox.setButtonEnabler(RMSetterDialog.this.buttonEnabler);
                }
                ((RMSetter)this.mainPanel).setRemoteConfiguration(remoteConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contentPane.add((Component)this.mainPanel, "Center");
            contentPane.add((Component)buttonPanel, "Last");
            this.pack();
        }

        public RemoteConfiguration getRemoteConfig() {
            return this.remoteConfig;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("Set".equals(e.getActionCommand())) {
                RMSetterDialog.this.value = ((RMSetter)this.mainPanel).getValue();
                if (RMSetterDialog.this.value == null) {
                    return;
                }
            } else {
                RMSetterDialog.this.value = null;
            }
            this.setVisible(false);
        }

        public void setValue(T value) {
            ((RMSetter)this.mainPanel).setValue(value);
            if (this.mainPanel instanceof MacroDefinitionBox) {
                MacroDefinitionBox macroBox = (MacroDefinitionBox)this.mainPanel;
                macroBox.enableButtons();
            }
        }
    }
}

