/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.RMSetterDialog;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class RMSetterEditor<T, C extends JComponent>
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    private JButton button = null;
    private RemoteConfiguration remoteConfig = null;
    private String title = null;
    private T value = null;
    private Class<C> panelClass = null;
    private ButtonEnabler buttonEnabler = null;
    private JTable table = null;
    protected static final String EDIT = "edit";

    public RMSetterEditor(Class<C> panelClass) {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.panelClass = panelClass;
        this.button = new JButton();
        this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.button.setHorizontalAlignment(10);
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    public void setRemoteConfiguration(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            return null;
        }
        this.value = value;
        this.table = table;
        if (this.panelClass == MacroDefinitionBox.class) {
            if (value instanceof Hex) {
                this.button.setText(Macro.getValueString((Hex)value, this.remoteConfig));
            } else {
                this.button.setText(Macro.getValueString((List)value));
            }
        } else {
            this.button.setText(this.value.toString());
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            RMSetterDialog<T> dialog = new RMSetterDialog<T>();
            dialog.setTitle(this.title);
            dialog.setButtonEnabler(this.buttonEnabler);
            Object result = dialog.showDialog(this.button, this.remoteConfig, this.panelClass, this.value);
            if (result != null && !result.toString().equals(this.value.toString())) {
                this.value = result;
                this.fireEditingStopped();
                int row = this.table.getSelectedRow();
                int col = this.table.getSelectedColumn();
                if (row >= 0 && col >= 0) {
                    this.table.clearSelection();
                    this.table.setRowSelectionInterval(row, row);
                    this.table.setColumnSelectionInterval(col, col);
                }
            } else {
                this.fireEditingCanceled();
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setButtonEnabler(ButtonEnabler buttonEnabler) {
        this.buttonEnabler = buttonEnabler;
    }
}

