/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.TableSorter;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;

public abstract class RMTablePanel<E>
extends RMPanel
implements ActionListener,
ListSelectionListener {
    protected JP1Table table = null;
    protected JP1TableModel<E> model = null;
    protected TableSorter sorter = null;
    protected JPanel buttonPanel = null;
    protected JPanel footerPanel = null;
    protected JButton editButton = null;
    protected JButton newButton = null;
    protected JButton importButton = null;
    protected JButton builtInButton = null;
    protected JButton exportButton = null;
    protected JButton cloneButton = null;
    protected JButton deleteButton = null;
    protected JButton deleteAllButton = null;
    protected JButton upButton = null;
    protected JButton downButton = null;
    protected JButton editProtocolButton = null;
    protected int popupRow = 0;
    protected JPopupMenu popup = null;
    protected JMenuItem editItem = null;
    protected JMenuItem newItem = null;
    protected JMenuItem importItem = null;
    protected JMenuItem builtInItem = null;
    protected JMenuItem exportItem = null;
    protected JMenuItem cloneItem = null;
    protected JMenuItem deleteItem = null;
    protected JMenuItem editProtocolItem = null;
    private JMenuItem copyItem = null;
    public MouseListener openEditor = null;
    public static boolean suppressDeletePrompts = false;

    public RMTablePanel(JP1TableModel<E> model) {
        this(model, "Center");
    }

    public RMTablePanel(JP1TableModel<E> tableModel, String location) {
        this.model = tableModel;
        this.sorter = new TableSorter(this.model);
        this.table = new JP1Table(this.sorter);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(true);
        this.sorter.setTableHeader(header);
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setCellSelectionEnabled(true);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setToolTipText("Click to sort in ascending order, or shift-click to sort in descending order.");
        this.openEditor = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int row = RMTablePanel.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (!RMTablePanel.this.table.isCellEditable(row, RMTablePanel.this.table.columnAtPoint(e.getPoint()))) {
                    ToolTipManager tt = ToolTipManager.sharedInstance();
                    int delay = tt.getDismissDelay();
                    tt.setDismissDelay(RMIRSetup.defaultToolTipTimeout);
                    RMTablePanel.this.editRowObject(row);
                    tt.setDismissDelay(delay);
                }
            }
        };
        this.table.addMouseListener(this.openEditor);
        this.popup = new JPopupMenu();
        this.editItem = new JMenuItem("Edit");
        this.editItem.setEnabled(false);
        this.editItem.addActionListener(this);
        this.popup.add(this.editItem);
        this.newItem = new JMenuItem("New");
        this.newItem.addActionListener(this);
        this.popup.add(this.newItem);
        this.importItem = new JMenuItem("Import from .girr or .ict file");
        this.importItem.addActionListener(this);
        this.importItem.setVisible(false);
        this.popup.add(this.importItem);
        this.builtInItem = new JMenuItem("Import built-in setup");
        this.builtInItem.addActionListener(this);
        this.builtInItem.setVisible(false);
        this.popup.add(this.builtInItem);
        this.exportItem = new JMenuItem("Export to .girr or .ict file");
        this.exportItem.addActionListener(this);
        this.exportItem.setVisible(false);
        this.popup.add(this.exportItem);
        this.cloneItem = new JMenuItem("Clone");
        this.cloneItem.addActionListener(this);
        this.cloneItem.setEnabled(false);
        this.popup.add(this.cloneItem);
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.addActionListener(this);
        this.deleteItem.setEnabled(false);
        this.popup.add(this.deleteItem);
        this.editProtocolItem = new JMenuItem("Edit Protocol");
        this.editProtocolItem.addActionListener(this);
        this.editProtocolItem.setEnabled(false);
        this.editProtocolItem.setVisible(false);
        this.popup.add(this.editProtocolItem);
        this.popup.add(new JSeparator());
        this.copyItem = new JMenuItem("Copy");
        this.copyItem.setToolTipText("Copy the selected text to the clipboard");
        this.copyItem.setEnabled(false);
        this.copyItem.addActionListener(this);
        this.popup.add(this.copyItem);
        MouseAdapter mh = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RMTablePanel.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RMTablePanel.this.showPopup(e);
            }
        };
        this.table.addMouseListener(mh);
        this.table.setLongToolTipTimeout();
        this.table.initColumns(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        Dimension d = this.table.getPreferredScrollableViewportSize();
        d.width = this.table.getPreferredSize().width;
        this.table.setPreferredScrollableViewportSize(d);
        this.add((Component)scrollPane, location);
        this.footerPanel = new JPanel(new BorderLayout());
        this.add((Component)this.footerPanel, "Last");
        this.buttonPanel = new JPanel(new WrapLayout(1));
        this.footerPanel.add((Component)this.buttonPanel, "Last");
        this.editButton = new JButton("Edit");
        this.editButton.addActionListener(this);
        this.editButton.setToolTipText("Edit the selected item.");
        this.editButton.setEnabled(false);
        this.buttonPanel.add(this.editButton);
        this.newButton = new JButton("New");
        this.newButton.addActionListener(this);
        this.newButton.setToolTipText(JTableX.getHtmlToolTip("Add a new item.&nbsp&nbsp&nbsp  Key: INS<br>(For INS key, table must have the focus and not be empty.)"));
        this.buttonPanel.add(this.newButton);
        this.importButton = new JButton("Import");
        this.importButton.addActionListener(this);
        this.importButton.setVisible(false);
        this.buttonPanel.add(this.importButton);
        this.builtInButton = new JButton("Import built-in setup");
        this.builtInButton.addActionListener(this);
        this.builtInButton.setVisible(false);
        this.builtInButton.setEnabled(false);
        this.buttonPanel.add(this.builtInButton);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        this.exportButton.setVisible(false);
        this.exportButton.setEnabled(false);
        this.buttonPanel.add(this.exportButton);
        this.cloneButton = new JButton("Clone");
        this.cloneButton.addActionListener(this);
        this.cloneButton.setToolTipText(JTableX.getHtmlToolTip("Add a copy of the selected item.&nbsp&nbsp&nbsp  Key: Ctrl/D<br>(For Ctrl/D, table must have the focus.)"));
        this.cloneButton.setEnabled(false);
        this.buttonPanel.add(this.cloneButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setToolTipText(JTableX.getHtmlToolTip("Delete the selected item.&nbsp&nbsp&nbsp  Key: DEL<br>(For DEL key, table must have the focus.)"));
        this.deleteButton.setEnabled(false);
        this.buttonPanel.add(this.deleteButton);
        this.deleteAllButton = new JButton("Delete All");
        this.deleteAllButton.addActionListener(this);
        this.deleteAllButton.setToolTipText("Delete all items");
        this.deleteAllButton.setVisible(false);
        this.deleteAllButton.setEnabled(false);
        this.buttonPanel.add(this.deleteAllButton);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.upButton.setToolTipText("Move the selected item up in the list.");
        this.upButton.setEnabled(false);
        this.buttonPanel.add(this.upButton);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        this.downButton.setToolTipText("Move the selected item down in the list.");
        this.downButton.setEnabled(false);
        this.buttonPanel.add(this.downButton);
        this.editProtocolButton = new JButton("Edit Protocol");
        this.editProtocolButton.addActionListener(this);
        this.editProtocolButton.setToolTipText("Edit the protocol of this device upgrade.");
        this.editProtocolButton.setEnabled(false);
        this.editProtocolButton.setVisible(false);
        this.buttonPanel.add(this.editProtocolButton);
        RMTablePanel.setButtonKeys(this.table, this.deleteButton, this.newButton, this.cloneButton);
    }

    protected boolean showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.finishEditing();
            this.popupRow = this.table.rowAtPoint(e.getPoint());
            this.popup.show(this.table, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    @Override
    public void setFont(Font aFont) {
        super.setFont(aFont);
        if (this.table == null || aFont == null) {
            return;
        }
        this.table.setRowHeight(aFont.getSize() + 2);
        this.table.initColumns(this.model);
    }

    protected void finishEditing() {
        TableCellEditor editor;
        int editRow = this.table.getEditingRow();
        if (editRow != -1 && !(editor = this.table.getCellEditor(editRow, this.table.getEditingColumn())).stopCellEditing()) {
            editor.cancelCellEditing();
        }
    }

    protected abstract E createRowObject(E var1);

    protected E getRowObject(int row) {
        if (row != -1) {
            return this.model.getRow(this.sorter.modelIndex(row));
        }
        return null;
    }

    protected boolean canDelete(Object o) {
        return true;
    }

    protected void doNotDelete(Object o) {
    }

    protected void editRowObject(int row) {
        E o = this.createRowObject(this.getRowObject(row));
        if (o != null) {
            this.model.setRow(this.sorter.modelIndex(row), o);
        }
    }

    protected void editRowProtocol(int row) {
    }

    protected E newRowObject(E baseObject, int row, int modelRow, boolean select) {
        E o = this.createRowObject(baseObject);
        if (o == null) {
            return null;
        }
        if (row == -1) {
            this.model.addRow(o);
            row = this.model.getRowCount();
        } else {
            this.model.insertRow(modelRow, o);
        }
        if (select) {
            this.table.setRowSelectionInterval(row, row);
        }
        return o;
    }

    protected void deleteRow(int row, boolean select) {
        int colFirst = this.table.getSelectedColumn();
        int colCount = this.table.getSelectedColumnCount();
        int modelRow = -1;
        if (row != -1) {
            modelRow = this.sorter.modelIndex(row);
        }
        if (!this.canDelete(this.model.getRow(this.sorter.modelIndex(row)))) {
            this.deleteButton.setEnabled(false);
            this.deleteItem.setEnabled(false);
            this.doNotDelete(this.model.getRow(modelRow));
        } else {
            int rowToSelect = row;
            if (rowToSelect == this.sorter.getRowCount() - 1) {
                --rowToSelect;
            }
            this.model.removeRow(modelRow);
            if (select && rowToSelect > -1 && colFirst > -1) {
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
                this.table.setColumnSelectionInterval(colFirst, colFirst + colCount - 1);
            }
        }
    }

    public void importFromFile() {
    }

    public void importBuiltIn() {
    }

    public void exportToFile(E exportObject) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.finishEditing();
        int row = 0;
        boolean select = false;
        Object source = e.getSource();
        if (source.getClass() == JButton.class) {
            row = this.table.getSelectedRow();
            if (row != -1) {
                select = true;
            }
        } else {
            row = this.popupRow;
            if (this.table.isRowSelected(row)) {
                select = true;
            }
        }
        int modelRow = -1;
        if (row != -1) {
            modelRow = this.sorter.modelIndex(row);
        }
        if (source == this.editButton || source == this.editItem) {
            this.editRowObject(row);
        } else if (source == this.newButton || source == this.newItem) {
            this.newRowObject(null, row, modelRow, select);
        } else if (source == this.importButton || source == this.importItem) {
            this.importFromFile();
        } else if (source == this.builtInButton || source == this.builtInItem) {
            this.importBuiltIn();
        } else if (source == this.exportButton || source == this.exportItem) {
            this.exportToFile(this.getRowObject(row));
        } else if (source == this.cloneButton || source == this.cloneItem) {
            this.newRowObject(this.getRowObject(row), row, modelRow, select);
        } else if (source == this.editProtocolButton || source == this.editProtocolItem) {
            this.editRowProtocol(modelRow);
        } else if (source == this.deleteButton || source == this.deleteItem || source == this.deleteAllButton) {
            int count = source == this.deleteButton ? this.table.getSelectedRowCount() : (source == this.deleteAllButton ? this.table.getRowCount() : 1);
            String message = "<html>Are you sure you want to delete " + (source == this.deleteAllButton ? "all the entr" : "the selected entr") + (source == this.deleteAllButton || count > 1 ? "ies?" : "y?") + "<br><br>To suppress this message in future, select the menu item<br>Options/Suppress Messages/All table deletes.</html>";
            String title = "Confirm Deletion";
            if (suppressDeletePrompts || JOptionPane.showConfirmDialog(this, message, title, 0, 3) == 0) {
                int top = source == this.deleteAllButton ? 0 : row;
                for (int n = top + count - 1; n >= top; --n) {
                    this.deleteRow(n, select);
                }
            }
        } else if (source == this.upButton || source == this.downButton) {
            int to;
            int sel = 0;
            int from = row;
            if (source == this.upButton) {
                from = row - 1;
                to = row;
                sel = from;
            } else {
                from = row;
                sel = to = row + 1;
            }
            this.model.moveRow(this.sorter.modelIndex(from), this.sorter.modelIndex(to));
            if (select) {
                this.table.setRowSelectionInterval(sel, sel);
            }
        } else if (source == this.copyItem) {
            int[] rows = this.table.getSelectedRows();
            int[] cols = this.table.getSelectedColumns();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            boolean firstRow = true;
            StringBuilder buff = new StringBuilder(200);
            for (int tableRow : rows) {
                if (firstRow) {
                    firstRow = false;
                } else {
                    buff.append("\n");
                }
                modelRow = this.table.convertRowIndexToModel(tableRow);
                boolean firstCol = true;
                for (int tableCol : cols) {
                    if (firstCol) {
                        firstCol = false;
                    } else {
                        buff.append("\t");
                    }
                    int modelCol = this.table.convertColumnIndexToModel(tableCol);
                    Object value = this.sorter.getValueAt(modelRow, modelCol);
                    if (value == null) continue;
                    DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)this.table.getColumnModel().getColumn(tableCol).getCellRenderer();
                    if (cellRenderer != null) {
                        cellRenderer.getTableCellRendererComponent(this.table, value, false, false, modelRow, modelCol);
                        value = cellRenderer.getText();
                    }
                    buff.append(value.toString());
                }
            }
            StringSelection data = new StringSelection(buff.toString());
            clipboard.setContents(data, data);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
            if (rm == null) {
                return;
            }
            rm.highlightAction.setEnabled(this.table.getSelectedRowCount() > 0);
            if (this.table.getSelectedRowCount() == 1) {
                int row = this.table.getSelectedRow();
                boolean selected = row != -1;
                this.editButton.setEnabled(selected);
                this.editItem.setEnabled(selected);
                this.cloneButton.setEnabled(selected);
                this.cloneItem.setEnabled(selected);
                if (this.editProtocolButton.isVisible()) {
                    this.editProtocolButton.setEnabled(selected);
                }
                if (this.editProtocolItem.isVisible()) {
                    this.editProtocolItem.setEnabled(selected);
                }
                if (this.exportButton.isVisible()) {
                    this.exportButton.setEnabled(selected);
                }
                if (this.exportItem.isVisible()) {
                    this.exportItem.setEnabled(selected);
                }
                boolean deleteAllowed = selected && this.canDelete(this.model.getRow(this.sorter.modelIndex(row)));
                this.deleteItem.setEnabled(deleteAllowed);
                this.upButton.setEnabled(row > 0);
                this.downButton.setEnabled(selected && row < this.sorter.getRowCount() - 1);
            } else {
                this.editButton.setEnabled(false);
                this.editItem.setEnabled(false);
                this.cloneButton.setEnabled(false);
                this.cloneItem.setEnabled(false);
                this.cloneButton.setEnabled(false);
                this.deleteItem.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                if (this.editProtocolButton.isVisible()) {
                    this.editProtocolButton.setEnabled(false);
                }
                if (this.editProtocolItem.isVisible()) {
                    this.editProtocolItem.setEnabled(false);
                }
                if (this.exportButton.isVisible()) {
                    this.exportButton.setEnabled(false);
                }
                if (this.exportItem.isVisible()) {
                    this.exportItem.setEnabled(false);
                }
            }
            this.copyItem.setEnabled(this.table.getSelectedRowCount() > 0);
            int[] rows = this.table.getSelectedRows();
            boolean deleteAllowed = true;
            for (int row : rows) {
                if (this.canDelete(this.model.getRow(this.sorter.modelIndex(row)))) continue;
                deleteAllowed = false;
                break;
            }
            this.deleteButton.setEnabled(rows.length > 0 && deleteAllowed);
            if (this.deleteAllButton.isVisible()) {
                deleteAllowed = true;
                for (int row = 0; row < this.table.getRowCount(); ++row) {
                    if (this.canDelete(this.model.getRow(this.sorter.modelIndex(row)))) continue;
                    deleteAllowed = false;
                    break;
                }
                this.deleteAllButton.setEnabled(this.table.getRowCount() > 0 && deleteAllowed);
            }
        }
    }

    public void commit() {
        this.finishEditing();
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener listener) {
        if (this.model != null && listener != null) {
            this.model.addPropertyChangeListener(listener);
        }
    }

    public JP1TableModel<E> getModel() {
        return this.model;
    }

    public TableSorter getSorter() {
        return this.sorter;
    }

    public JP1Table getTable() {
        return this.table;
    }
}

