/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RMSetter;
import com.hifiremote.jp1.RMTime;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.DateFormatter;

public class RMTimePanel
extends JPanel
implements RMSetter<RMTime> {
    private JFormattedTextField timeField = new TimeField(new DateFormatter(RMTime.timeFormat));

    public RMTimePanel() {
        this.add(this.timeField);
        this.setBorder(BorderFactory.createTitledBorder("Time Setting"));
    }

    @Override
    public void setValue(RMTime time) {
        this.timeField.setValue(time.get());
    }

    @Override
    public RMTime getValue() {
        if (!this.timeField.isEditValid()) {
            this.showWarning("The time you have specified is not valid.  It should be\na 24-hour clock value of the form \"hh:mm\".");
            return null;
        }
        try {
            this.timeField.commitEdit();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new RMTime((Date)this.timeField.getValue());
    }

    @Override
    public void setRemoteConfiguration(RemoteConfiguration config) {
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Invalid Format", 0);
    }

    public class TimeField
    extends JFormattedTextField {
        public TimeField(DateFormatter df) {
            super(df);
            this.setColumns(6);
            this.setFocusLostBehavior(3);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.selectAll();
            }
        }
    }
}

