/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RawDataTableModel;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.UnsignedByte;
import com.hifiremote.jp1.UnsignedByteRenderer;
import com.hifiremote.jp1.Xor16CheckSum;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.io.IO;
import com.hifiremote.jp1.io.JPS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;

public class RawDataDialog
extends JDialog
implements ActionListener {
    RawDataTableModel model = null;
    UnsignedByteRenderer byteRenderer = new UnsignedByteRenderer();
    private RMIRSetup owner = null;
    private String signature = null;
    private short[] icinfo = null;
    private short[] sigData = null;
    private short[] rfData = null;
    private int rfDataAddress = 0;
    private short[] buffer = null;
    private int sigAddress = -1;
    private int baseAddress = 0;
    private int interfaceType = 0;
    private int eepromSize = 0;
    private int eraseSize = 0;
    private int segStart = 0;
    private boolean hasSegments = false;
    private boolean hasBlockFormat = false;
    private boolean hasRFSupport = false;
    private List<Integer> segmentTypes = null;
    private List<Integer> deviceTypes = null;
    private List<Integer> deviceButtons = null;
    private int dataEnd = 0;
    private String checkSumType = null;
    private String checkSumRounding = "";
    private JButton downloadButton = new JButton("Download");
    private JButton saveButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private JLabel downloadLabel = new JLabel();

    public RawDataDialog(RMIRSetup RMIRSetup2) {
        super(RMIRSetup2, "Download Raw", true);
        this.owner = RMIRSetup2;
        this.setLocationRelativeTo(RMIRSetup2);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.model = new RawDataTableModel();
        JP1Table table = new JP1Table(this.model);
        table.initColumns(this.model);
        table.setGridColor(Color.lightGray);
        table.getTableHeader().setResizingAllowed(false);
        table.setDefaultRenderer(UnsignedByte.class, this.byteRenderer);
        JScrollPane scrollPane = new JScrollPane(table, 22, 30);
        Dimension d = table.getPreferredScrollableViewportSize();
        d.width = table.getPreferredSize().width;
        table.setPreferredScrollableViewportSize(d);
        this.add((Component)scrollPane, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        statusPanel.add((Component)buttonPanel, "After");
        this.downloadLabel.setText("DOWNLOADING...");
        this.downloadLabel.setForeground(Color.RED);
        this.downloadLabel.setFont(this.downloadLabel.getFont().deriveFont(1));
        this.downloadLabel.setVisible(false);
        statusPanel.add((Component)this.downloadLabel, "Before");
        this.downloadButton.addActionListener(this);
        buttonPanel.add(this.downloadButton);
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        buttonPanel.add(this.saveButton);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.add((Component)statusPanel, "Last");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    public short[] getDataToShow(short[] data, IO io) {
        if (io.remoteUsesSSD()) {
            int end = data[2] + (data[3] << 8) + ((data[1] & 0xF0) << 12);
            end = end + 1023 & 0xFFFFFC00;
            return Arrays.copyOf(data, end);
        }
        return data;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.model != null && l != null) {
            this.model.addPropertyChangeListener(l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.downloadButton) {
            System.err.println("Starting raw download");
            this.downloadLabel.setText("DOWNLOADING...");
            this.downloadLabel.setVisible(true);
            new RawDownloadTask().execute();
        } else if (source == this.saveButton) {
            int start = this.signature.startsWith("USB") ? 3 : 0;
            int end = Math.min(start + 4, this.signature.length());
            RMFileChooser chooser = this.owner.getFileSaveChooser(new EndingFileFilter("IR file (*.ir)", RMIRSetup.irEndings));
            String ending = RMIRSetup.irEndings[0];
            File rawFile = new File(this.signature.substring(start, end) + ending);
            chooser.setSelectedFile(rawFile);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                String name = chooser.getSelectedFile().getAbsolutePath();
                if (!name.toLowerCase().endsWith(ending)) {
                    name = name + ending;
                }
                rawFile = new File(name);
                int rc = 0;
                if (rawFile.exists()) {
                    rc = JOptionPane.showConfirmDialog(this, rawFile.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
                }
                if (rc != 0) {
                    this.downloadLabel.setVisible(false);
                    return;
                }
                System.err.println("Starting to save raw download");
                this.downloadLabel.setText("SAVING...");
                this.downloadLabel.setVisible(true);
                new SaveDownloadTask(rawFile).execute();
            }
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private int getDataEnd() {
        int pos = this.segStart = this.hasBlockFormat ? 20 : 2;
        int segLength = Hex.get(this.buffer, pos);
        this.segmentTypes = new ArrayList<Integer>();
        this.deviceTypes = new ArrayList<Integer>();
        this.deviceButtons = new ArrayList<Integer>();
        while (segLength != 65535 && segLength != 0) {
            if (pos + segLength > this.eepromSize) {
                return -1;
            }
            short segType = this.buffer[pos + 2];
            if (!this.segmentTypes.contains(segType)) {
                this.segmentTypes.add(Integer.valueOf(segType));
                if (segType == 32 && this.buffer[pos + 5] != 0) {
                    this.hasRFSupport = true;
                }
            }
            if (segType == 0) {
                short devBtn = this.buffer[pos + 4];
                short devType = this.buffer[pos + 6];
                if (!this.deviceButtons.contains(devBtn)) {
                    this.deviceButtons.add(Integer.valueOf(devBtn));
                }
                if (devType != 255 && !this.deviceTypes.contains(devType)) {
                    this.deviceTypes.add(Integer.valueOf(devType));
                }
            }
            segLength = Hex.get(this.buffer, pos += segLength);
        }
        Collections.sort(this.segmentTypes);
        Collections.sort(this.deviceTypes);
        return pos;
    }

    private String getProcessor() {
        if (this.signature.startsWith("2")) {
            if ((this.interfaceType & 0x300) == 0) {
                return "MAXQ610";
            }
            if ((this.interfaceType & 0x300) == 256) {
                return "MAXQ612";
            }
            if ((this.interfaceType & 0x300) == 768) {
                return "MAXQ622";
            }
            return "Unknown";
        }
        if (this.signature.startsWith("3")) {
            return "S3F80";
        }
        if (this.signature.startsWith("60")) {
            return this.eraseSize == 1024 ? "TI2533" : (this.hasRFSupport ? "TI2530" : "TI2541");
        }
        if (this.signature.startsWith("68")) {
            if ((this.interfaceType & 0x100) == 256) {
                return "GP565";
            }
            return "GP541";
        }
        if (this.interfaceType == 262) {
            return "MAXQ622";
        }
        if (this.interfaceType == 6) {
            return "HCS08";
        }
        return "Unknown";
    }

    static /* synthetic */ short[] access$302(RawDataDialog x0, short[] x1) {
        x0.icinfo = x1;
        return x1;
    }

    static /* synthetic */ short[] access$002(RawDataDialog x0, short[] x1) {
        x0.sigData = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1502(RawDataDialog x0, short[] x1) {
        x0.rfData = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1102(RawDataDialog x0, short[] x1) {
        x0.buffer = x1;
        return x1;
    }

    private class RawDownloadTask
    extends SwingWorker<Void, Void> {
        private RawDownloadTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            String sigString;
            IO io = RawDataDialog.this.owner.getOpenInterface(null, RMIRSetup.Use.RAWDOWNLOAD, null);
            if (io == null) {
                JOptionPane.showMessageDialog(RawDataDialog.this.owner, "No remotes found!");
                RawDataDialog.this.downloadLabel.setVisible(false);
                return null;
            }
            System.err.println("Interface opened successfully");
            RawDataDialog.this.baseAddress = io.getRemoteEepromAddress();
            RawDataDialog.this.interfaceType = io.getInterfaceType();
            System.err.println("Base address = $" + Integer.toHexString(RawDataDialog.this.baseAddress).toUpperCase());
            System.err.println("Interface type = $" + Integer.toHexString(RawDataDialog.this.interfaceType).toUpperCase());
            if (io instanceof JPS) {
                RawDataDialog.this.sigAddress = ((JPS)io).getSigAddress();
            }
            if ((sigString = RMIRSetup.getIOsignature(io, RawDataDialog.this.baseAddress)) == null || sigString.length() < 4) {
                String title = "Raw download failure";
                String message = "Unable to read the signature of the remote.  Download terminating.\nMake sure you have the latest driver installed for your interface cable.";
                JOptionPane.showMessageDialog(RawDataDialog.this.owner, message, title, 0);
                RawDataDialog.this.downloadLabel.setVisible(false);
                return null;
            }
            if (sigString.length() > 8) {
                RawDataDialog.this.signature = sigString.substring(0, 6);
            } else {
                RawDataDialog.this.signature = sigString;
            }
            System.err.println("Remote signature = " + RawDataDialog.this.signature);
            RawDataDialog.access$302(RawDataDialog.this, RMIRSetup.getIcInfo(io));
            RawDataDialog.access$002(RawDataDialog.this, RMIRSetup.getSigData(sigString, io));
            RawDataDialog.access$1502(RawDataDialog.this, RMIRSetup.getRFData(io));
            RawDataDialog.this.eepromSize = io.getRemoteEepromSize();
            int buffSize = RawDataDialog.this.eepromSize;
            System.err.println("Initial buffer size  = $" + Integer.toHexString(buffSize).toUpperCase());
            if (buffSize <= 0) {
                if (RawDataDialog.this.buffer == null) {
                    Object[] choices = new String[]{"1K", "2K", "4K", "8K"};
                    String choice = (String)JOptionPane.showInputDialog(RawDataDialog.this.owner, "Select the number of bytes to download from the remote.", "Raw Download Size", 3, null, choices, choices[1]);
                    if (choice == null) {
                        RawDataDialog.this.downloadLabel.setVisible(false);
                        return null;
                    }
                    buffSize = Integer.parseInt(choice.substring(0, 1)) * 1024;
                } else {
                    buffSize = RawDataDialog.this.buffer.length;
                }
                RawDataDialog.this.eepromSize = buffSize;
            }
            if (buffSize % 16 != 0) {
                buffSize = (buffSize / 16 + 1) * 16;
            }
            RawDataDialog.this.eraseSize = io.getEraseSize();
            if (RawDataDialog.this.eraseSize > 0 && buffSize % RawDataDialog.this.eraseSize != 0) {
                buffSize = (buffSize / RawDataDialog.this.eraseSize + 1) * RawDataDialog.this.eraseSize;
            }
            System.err.println("Final buffer size  = $" + Integer.toHexString(buffSize).toUpperCase());
            RawDataDialog.access$1102(RawDataDialog.this, new short[buffSize]);
            RawDataDialog.this.byteRenderer.setEepromSize(RawDataDialog.this.eepromSize);
            int count = io.readRemote(RawDataDialog.this.baseAddress, RawDataDialog.this.buffer);
            System.err.println("Number of bytes read  = $" + Integer.toHexString(count).toUpperCase());
            io.closeRemote();
            System.err.println("Ending raw download");
            RawDataDialog.access$1102(RawDataDialog.this, RawDataDialog.this.getDataToShow(RawDataDialog.this.buffer, io));
            RawDataDialog.this.model.set(RawDataDialog.this.buffer, RawDataDialog.this.baseAddress);
            RawDataDialog.this.saveButton.setEnabled(true);
            RawDataDialog.this.downloadLabel.setVisible(false);
            RMIRSetup.setSystemFilesItems(RawDataDialog.this.owner, null);
            return null;
        }
    }

    private class SaveDownloadTask
    extends SwingWorker<Void, Void> {
        private File rawFile = null;

        public SaveDownloadTask(File rawFile) {
            this.rawFile = rawFile;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                Object range;
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(this.rawFile)));
                boolean sigDataTest = RawDataDialog.this.sigData == null ? true : (RawDataDialog.this.sigData[2] | RawDataDialog.this.sigData[3]) != 0 || RawDataDialog.this.sigData[0] + RawDataDialog.this.sigData[1] == 255;
                int typeTest = RawDataDialog.this.interfaceType & 0xFFF7;
                if (typeTest == 1 || typeTest == 6 || typeTest > 7) {
                    if (RawDataDialog.this.sigAddress < 0) {
                        RawDataDialog.this.sigAddress = 0;
                        if (RawDataDialog.this.icinfo != null) {
                            for (int i = 2; i < RawDataDialog.this.icinfo.length; ++i) {
                                RawDataDialog.this.sigAddress = (RawDataDialog.this.sigAddress << 8) + RawDataDialog.this.icinfo[i];
                            }
                        } else {
                            RawDataDialog.this.sigAddress = 0;
                        }
                    }
                    pw.println("[Signature]");
                    short[] sd = RawDataDialog.this.sigData;
                    if (sd == null || RawDataDialog.this.signature.startsWith("USB") || !sigDataTest) {
                        sd = new short[RawDataDialog.this.signature.length()];
                        for (int i = 0; i < RawDataDialog.this.signature.length(); ++i) {
                            sd[i] = (short)RawDataDialog.this.signature.charAt(i);
                        }
                    }
                    Hex.print(pw, sd, RawDataDialog.this.sigAddress);
                    pw.println();
                    pw.println("[Buffer]");
                    RawDataDialog.this.hasSegments = RawDataDialog.this.interfaceType != 513;
                    if (RawDataDialog.this.hasSegments) {
                        RawDataDialog.this.hasBlockFormat = (RawDataDialog.this.interfaceType & 0x300) == 768 || (RawDataDialog.this.interfaceType & 0x400) == 1024 || (RawDataDialog.this.interfaceType & 0xFF) == 6;
                        RawDataDialog.this.dataEnd = RawDataDialog.this.getDataEnd();
                        if (RawDataDialog.this.dataEnd < 0) {
                            JOptionPane.showMessageDialog(RawDataDialog.this.owner, "Error: Unable to save raw download");
                            RawDataDialog.this.downloadLabel.setVisible(false);
                            pw.close();
                            return null;
                        }
                        int actualCheckSum = Hex.get(RawDataDialog.this.buffer, 0);
                        range = new AddressRange(2, RawDataDialog.this.dataEnd - 1);
                        ((AddressRange)range).setRoundTo(4);
                        CheckSum cs = new Xor16CheckSum(0, (AddressRange)range, false);
                        int calcCheckSum = cs.getCheckSum(RawDataDialog.this.buffer);
                        if (actualCheckSum == calcCheckSum || actualCheckSum == (~calcCheckSum & 0xFFFF)) {
                            RawDataDialog.this.checkSumType = "XOR16";
                            if ((RawDataDialog.this.dataEnd + 1 & 2) == 2) {
                                RawDataDialog.this.checkSumRounding = actualCheckSum == calcCheckSum ? "/4" : "/2";
                            } else {
                                RawDataDialog.this.checkSumRounding = "";
                            }
                        } else {
                            ((AddressRange)range).setRoundTo(1);
                            cs = new XorCheckSum(0, (AddressRange)range, false);
                            calcCheckSum = cs.getCheckSum(RawDataDialog.this.buffer);
                            if (actualCheckSum == calcCheckSum || actualCheckSum == (~calcCheckSum & 0xFFFF)) {
                                RawDataDialog.this.checkSumType = "XOR";
                                if ((RawDataDialog.this.dataEnd & 1) == 1) {
                                    RawDataDialog.this.checkSumRounding = actualCheckSum == calcCheckSum ? "" : "/2";
                                }
                            }
                        }
                    }
                }
                Hex.print(pw, RawDataDialog.this.buffer, RawDataDialog.this.baseAddress);
                if (RawDataDialog.this.icinfo != null) {
                    pw.println();
                    pw.println("[Info]");
                    pw.println(Hex.toString(RawDataDialog.this.icinfo));
                }
                if (RawDataDialog.this.sigData != null && (RawDataDialog.this.signature.startsWith("USB") || !sigDataTest)) {
                    pw.println();
                    pw.println("[SigBlock]");
                    Hex.print(pw, RawDataDialog.this.sigData, RawDataDialog.this.sigAddress);
                }
                if (RawDataDialog.this.rfData != null) {
                    pw.println();
                    pw.println("[RFData]");
                    Hex.print(pw, RawDataDialog.this.rfData, RMIRSetup.getRfDataAddress());
                }
                if (RawDataDialog.this.eepromSize > 0) {
                    pw.println();
                    pw.println("[Notes]");
                    pw.println("0=Raw download created with RMIR " + RemoteMaster.getDisplayVersion() + ", interface type $" + Integer.toHexString(RawDataDialog.this.interfaceType) + ".");
                    if (RawDataDialog.this.hasSegments) {
                        pw.println();
                        pw.println("[RDF Data]");
                        pw.println("Here is initial data towards an RDF, which should be named");
                        pw.println("\"" + RawDataDialog.this.signature + " (TempName).rdf\" with a suitable choice for TempName.");
                        pw.println("This has been extracted from downloaded data of length $" + String.format("%04X.", RawDataDialog.this.dataEnd));
                        pw.println();
                        pw.println("[General]");
                        pw.println("Name=TempName");
                        pw.println("EepromSize=$" + Integer.toHexString(RawDataDialog.this.eepromSize).toUpperCase());
                        String procName = RawDataDialog.this.getProcessor();
                        if (procName.equals("S3F80") || procName.equals("HCS08")) {
                            pw.println("Processor=" + procName);
                        } else {
                            pw.println("Processor=S3C80");
                            pw.println("Processor+=" + procName);
                        }
                        pw.println("BaseAddr=$" + Integer.toHexString(RawDataDialog.this.baseAddress).toUpperCase());
                        pw.print("SegmentTypes=");
                        boolean first = true;
                        range = RawDataDialog.this.segmentTypes.iterator();
                        while (range.hasNext()) {
                            int type = (Integer)range.next();
                            pw.print((first ? "" : " ") + "$" + String.format("%02X", type));
                            first = false;
                        }
                        pw.println();
                        pw.println("BlockFormat=" + (RawDataDialog.this.hasBlockFormat ? "Y" : "N"));
                        pw.println("RDFSync=5");
                        if (RawDataDialog.this.checkSumType != null) {
                            pw.println();
                            pw.println("[Checksums]");
                            pw.print((RawDataDialog.this.checkSumType.equals("XOR") ? "^" : "*") + "$0000:$0002..$");
                            pw.println(String.format("%04X", RawDataDialog.this.eepromSize - 1) + RawDataDialog.this.checkSumRounding);
                        }
                        pw.println();
                        pw.println("[DeviceTypes]");
                        int n = 0;
                        Iterator type = RawDataDialog.this.deviceTypes.iterator();
                        while (type.hasNext()) {
                            int type2 = (Integer)type.next();
                            pw.println((char)(65 + n) + " =" + n + "," + type2);
                            ++n;
                        }
                        if (RawDataDialog.this.deviceTypes.size() > 1) {
                            pw.println();
                            pw.println("#The aliases here must all be assigned to exactly one device type");
                            pw.println("[DeviceTypeAliases]");
                            pw.println("A = TV");
                            pw.println("B = SAT,DVD,Laserdisc,DAT,VCR,CD,Tuner,Home Auto,Misc Audio,Phono,Amp,Tape,Cable,Video Acc");
                            for (int i = 2; i < RawDataDialog.this.deviceTypes.size(); ++i) {
                                pw.println((char)(65 + i) + " =");
                            }
                        }
                        pw.println();
                        pw.println("[DeviceButtons]");
                        n = 1;
                        Iterator iterator = RawDataDialog.this.deviceButtons.iterator();
                        while (iterator.hasNext()) {
                            int btn = (Integer)iterator.next();
                            pw.println("Dev" + n++ + " = $" + String.format("%02X 0", btn));
                        }
                    }
                }
                pw.close();
            }
            catch (IOException ioe) {
                RawDataDialog.this.downloadLabel.setVisible(false);
                JOptionPane.showMessageDialog(RawDataDialog.this.owner, "Error writing to " + this.rawFile);
            }
            RawDataDialog.this.downloadLabel.setVisible(false);
            return null;
        }
    }
}

