/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.RawDataTableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.UnsignedByte;
import com.hifiremote.jp1.UnsignedByteRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class RawDataPanel
extends RMPanel {
    RemoteConfiguration remoteConfig = null;
    RawDataTableModel model = null;
    UnsignedByteRenderer byteRenderer = new UnsignedByteRenderer();
    JLabel signatureLabel = new JLabel();
    JLabel regionLabel = new JLabel();
    JLabel languageLabel = new JLabel();
    JLabel processorLabel = new JLabel();
    JLabel interfaceLabel = new JLabel();
    JLabel versionLabel1 = new JLabel("");
    JLabel versionLabel2 = new JLabel("");
    JLabel infoLabel1 = new JLabel("Values in black: RMIR data displayed");
    JLabel infoLabel2 = new JLabel("Values in blue: Original data displayed");
    Component strut1 = Box.createVerticalStrut(5);
    Component strut2 = Box.createVerticalStrut(5);
    Box infoBox = null;
    JPanel choicePanel = null;
    JRadioButton normalBtn = null;
    JRadioButton baseBtn = null;
    private Color[] highlight = null;
    private HashMap<Integer, Integer> settingAddresses = null;

    public RawDataPanel() {
        this.model = new RawDataTableModel();
        JP1Table table = new JP1Table(this.model){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                int offset = 16 * row + col - 1;
                boolean showTip = false;
                if (col != 0 && RawDataPanel.this.settingAddresses.containsKey(offset)) {
                    tip = "Highlighted bits: ";
                    int end = RawDataPanel.this.highlight.length - 1;
                    for (int i = 0; i < 8; ++i) {
                        if (RawDataPanel.this.highlight[end - 8 * (Integer)RawDataPanel.this.settingAddresses.get(offset) - i].equals(Color.WHITE)) continue;
                        tip = tip + i;
                        showTip = true;
                    }
                }
                return showTip ? tip : null;
            }
        };
        table.initColumns(this.model);
        table.setGridColor(Color.lightGray);
        table.getTableHeader().setResizingAllowed(false);
        table.setDefaultRenderer(UnsignedByte.class, this.byteRenderer);
        JScrollPane scrollPane = new JScrollPane(table, 22, 30);
        Dimension d = table.getPreferredScrollableViewportSize();
        d.width = table.getPreferredSize().width;
        table.setPreferredScrollableViewportSize(d);
        this.add((Component)scrollPane, "West");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 5, 5));
        this.infoBox = Box.createVerticalBox();
        this.infoBox.setAlignmentX(0.0f);
        this.infoBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        panel.add((Component)this.infoBox, "First");
        this.add((Component)panel, "Center");
        JPanel p = new JPanel(new BorderLayout());
        panel.add((Component)p, "Before");
        this.infoBox.add(this.signatureLabel);
        this.infoBox.add(this.strut1);
        this.infoBox.add(this.regionLabel);
        this.infoBox.add(this.strut2);
        this.infoBox.add(this.languageLabel);
        this.infoBox.add(Box.createVerticalStrut(5));
        this.infoBox.add(this.processorLabel);
        this.infoBox.add(Box.createVerticalStrut(5));
        this.infoBox.add(this.interfaceLabel);
        this.infoBox.add(Box.createVerticalStrut(5));
        this.infoBox.add(this.versionLabel1);
        this.infoBox.add(Box.createVerticalStrut(5));
        this.infoBox.add(this.versionLabel2);
        Font boldFont = new JLabel().getFont().deriveFont(1);
        this.infoLabel1.setFont(boldFont);
        this.infoLabel2.setFont(boldFont);
        this.infoLabel2.setForeground(Color.BLUE);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RawDataPanel.this.set(RawDataPanel.this.remoteConfig);
            }
        };
        this.normalBtn = new JRadioButton("Normal data");
        this.normalBtn.setSelected(true);
        this.normalBtn.addActionListener(al);
        this.baseBtn = new JRadioButton("Baseline data");
        this.baseBtn.setSelected(false);
        this.baseBtn.addActionListener(al);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.normalBtn);
        bg.add(this.baseBtn);
        this.choicePanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.choicePanel.setBorder(BorderFactory.createTitledBorder(" Display "));
        this.choicePanel.add(this.normalBtn);
        this.choicePanel.add(this.baseBtn);
        this.choicePanel.setVisible(false);
        p.add((Component)this.choicePanel, "First");
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            String text;
            Remote remote = remoteConfig.getRemote();
            RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
            short[] dataToShow = rm.useSavedData() ? remoteConfig.getSavedData() : (this.baseBtn.isSelected() ? remoteConfig.getBaselineData() : remoteConfig.getData());
            int dataEnd = remoteConfig.getDataEnd(dataToShow);
            if (dataEnd != dataToShow.length) {
                dataToShow = Arrays.copyOf(dataToShow, remoteConfig.getDataEnd(dataToShow));
            }
            this.model.set(dataToShow, remote.getBaseAddress());
            this.byteRenderer.setRemoteConfig(remoteConfig);
            this.highlight = remoteConfig.getHighlight();
            this.settingAddresses = remoteConfig.hasSegments() ? remoteConfig.getSettingMap() : remote.getSettingAddresses();
            String sig = remoteConfig.getSigString();
            if (sig == null) {
                sig = remote.getSignature();
            }
            this.signatureLabel.setText("Signature:  " + sig);
            String region = remoteConfig.getRegionDisplayName();
            if (region != null) {
                this.strut1.setVisible(true);
                this.regionLabel.setVisible(true);
                this.regionLabel.setText("Region:  " + region);
            } else {
                this.strut1.setVisible(false);
                this.regionLabel.setVisible(false);
            }
            String language = remoteConfig.getLanguageDisplayName();
            if (language != null) {
                this.strut2.setVisible(true);
                this.languageLabel.setVisible(true);
                this.languageLabel.setText("Language:  " + language);
            } else {
                this.strut2.setVisible(false);
                this.languageLabel.setVisible(false);
            }
            this.processorLabel.setText("Processor:  " + remote.getProcessorDescription());
            this.interfaceLabel.setText("Interface:  " + remoteConfig.getInterfaceType());
            this.versionLabel1.setText("");
            this.versionLabel2.setText("");
            int n = 1;
            if (remote.getExtenderVersionParm() != null) {
                this.versionLabel1.setText("Extender version:  " + remote.getExtenderVersionParm().getExtenderVersion(remoteConfig));
                ++n;
            }
            if ((text = remote.getFirmwareSignature()) != null && !text.equals(sig)) {
                JLabel lbl = n == 1 ? this.versionLabel1 : this.versionLabel2;
                lbl.setText("Firmware signature: " + text);
            }
            if (remoteConfig.getOwner().useSavedData()) {
                if (!Arrays.asList(this.infoBox.getComponents()).contains(this.infoLabel1)) {
                    this.infoBox.add(Box.createVerticalStrut(5), 0);
                    this.infoBox.add((Component)this.infoLabel2, 0);
                    this.infoBox.add((Component)this.infoLabel1, 0);
                    this.validate();
                }
            } else if (Arrays.asList(this.infoBox.getComponents()).contains(this.infoLabel1)) {
                this.infoBox.remove(0);
                this.infoBox.remove(0);
                this.infoBox.remove(0);
                this.validate();
            }
            this.choicePanel.setVisible(!rm.useSavedData() && remoteConfig.getBaselineData() != null);
        }
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener l) {
        if (this.model != null && l != null) {
            this.model.addPropertyChangeListener(l);
        }
    }
}

