/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.UnsignedByte;
import javax.swing.table.TableCellRenderer;

public class RawDataTableModel
extends JP1TableModel<short[]> {
    private static final String[] colNames = new String[]{"    ", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F"};
    private short[] data = null;
    private int baseAddress = 0;

    public void set(short[] data, int baseAddress) {
        this.data = data;
        this.baseAddress = baseAddress;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length / 16;
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    private int getOffset(int row, int col) {
        return row * 16 + col - 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int base = row * 16;
        if (col == 0) {
            return new Integer(base + this.baseAddress);
        }
        if (this.data == null) {
            return null;
        }
        return new UnsignedByte((short)(this.data[this.getOffset(row, col)] & 0xFF));
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[this.getOffset((int)row, (int)col)] = ((UnsignedByte)value).getValue();
        this.propertyChangeSupport.firePropertyChange("data", null, null);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return Integer.class;
        }
        return UnsignedByte.class;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        if (col == 0) {
            return "00000: ";
        }
        return " CC ";
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return true;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer(true);
        }
        return null;
    }
}

