/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.DefaultFormatter;

public class RegexFormatter
extends DefaultFormatter {
    private Pattern pattern;
    private Matcher matcher;

    public RegexFormatter() {
    }

    public RegexFormatter(String textPattern) throws PatternSyntaxException {
        this();
        this.setPattern(textPattern);
    }

    public RegexFormatter(Pattern pattern) {
        this();
        this.setPattern(pattern);
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String textPattern) throws PatternSyntaxException {
        this.setPattern(Pattern.compile(textPattern));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    protected Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches()) {
                this.setMatcher(matcher);
                return super.stringToValue(text);
            }
            throw new ParseException("Pattern did not match", 0);
        }
        return text;
    }
}

