/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.AddCheckSum;
import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.AutoClockSet;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.ButtonShape;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.DSMSpecialProtocol;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceLabels;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.EncrypterDecrypter;
import com.hifiremote.jp1.ExtenderVersionParm;
import com.hifiremote.jp1.FavKey;
import com.hifiremote.jp1.FixedData;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ImageMap;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveEFC;
import com.hifiremote.jp1.KeyMoveEFC5;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.KeyMoveLong;
import com.hifiremote.jp1.LineTokenizer;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroCodingType;
import com.hifiremote.jp1.MultiMacro;
import com.hifiremote.jp1.OEMDevice;
import com.hifiremote.jp1.PauseParameters;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Setting;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SoftDevices;
import com.hifiremote.jp1.SoftHomeTheater;
import com.hifiremote.jp1.SpecialProtocol;
import com.hifiremote.jp1.StatusBit;
import com.hifiremote.jp1.Xor16CheckSum;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.io.CommHID;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class Remote
implements Comparable<Remote> {
    private int height;
    private int width;
    private HashMap<Integer, HashMap<Integer, Integer>> setupCodes = new HashMap();
    private HashMap<Integer, HashMap<Integer, Integer>> rfSetupCodes = null;
    private File file = null;
    private String signature = null;
    private String firmwareSignature = null;
    private int sigAddress = 2;
    private String[] names = new String[1];
    private int nameIndex = 0;
    private boolean loaded = false;
    private int baseAddress = 0;
    private List<String> extract = null;
    private int eepromSize;
    private int deviceCodeOffset;
    private int maxBuiltInCode = 0;
    private int learnedFormat = -1;
    private int internalDeviceCode = 0;
    private String notes = null;
    private FavKey favKey = null;
    private OEMDevice oemDevice = null;
    private int oemControl = 0;
    private boolean upgradeBug = false;
    private AddressRange advancedCodeAddress = null;
    private AddressRange usageRange = null;
    private AddressRange favScanAddress = null;
    private int macroSupport = 1;
    private boolean hasDeviceTypeImageMaps = false;
    private boolean keyMoveSupport = true;
    private boolean multiMacroSupport = false;
    private boolean globalPunchthruSupport = false;
    private boolean hasRfProtocol = false;
    public boolean ledColor = false;
    private Integer[] ledParams = null;
    private String[] ledSettings = null;
    private boolean deviceSelection = true;
    private boolean deviceSelectionMessage = false;
    private AddressRange upgradeAddress = null;
    private AddressRange deviceUpgradeAddress = null;
    private AddressRange timedMacroAddress = null;
    private boolean timedMacroWarning = false;
    private AddressRange learnedAddress = null;
    private Processor processor = null;
    private int RAMAddress = 0;
    private AutoClockSet autoClockSet = null;
    private ExtenderVersionParm extenderVersionParm = null;
    private List<String> oemSignatures = null;
    private int RDFSync;
    private int punchThruBase;
    private int scanBase = 0;
    private StatusBit sleepStatusBit = null;
    private StatusBit vptStatusBit = null;
    private CheckSum[] checkSums = new CheckSum[0];
    private Setting[] settings = new Setting[0];
    private HashMap<Integer, Integer> settingAddresses = new HashMap();
    private HashMap<Integer, Integer> settingMasks = new HashMap();
    private List<Integer> settingBytes = new ArrayList<Integer>();
    private FixedData[] fixedData = new FixedData[0];
    private FixedData[] rawFixedData = new FixedData[0];
    private String punchThru = "VTC";
    private FixedData[] autoSet = new FixedData[0];
    private DeviceButton[] deviceButtons = new DeviceButton[0];
    private int seqShift = 4;
    private LinkedHashMap<String, DeviceType> deviceTypes = new LinkedHashMap();
    private Hashtable<Integer, DeviceType> devicesByType = new Hashtable();
    private List<DeviceType> deviceTypeList = new ArrayList<DeviceType>();
    private Hashtable<String, DeviceType> deviceTypeAliases = new Hashtable();
    private String[] deviceTypeAliasNames = null;
    private List<Button> buttons = new ArrayList<Button>();
    private Hashtable<Integer, Button> buttonsByKeyCode = new Hashtable();
    private Hashtable<String, Button> buttonsByName = new Hashtable();
    private Hashtable<String, Button> buttonsByStandardName = new Hashtable();
    private String realTimeMacroKeyData = null;
    private Button[] normalMacroButtons = null;
    private Button[] realTimeMacroButtons = null;
    private Button[] controlledMacroButtons = null;
    private Button[] multiMacroButtons = null;
    private Button[] upgradeButtons = new Button[0];
    private Button[] baseUpgradeButtons = new Button[0];
    private Button[] macroButtons = new Button[0];
    private Button[] learnButtons = new Button[0];
    private List<Button> functionButtons = new ArrayList<Button>();
    private List<Button> distinctButtons = new ArrayList<Button>();
    private List<ButtonShape> phantomShapes = new ArrayList<ButtonShape>();
    private short[] digitMaps = new short[0];
    private List<Integer> segmentTypes = null;
    private ButtonMap[] buttonMaps = new ButtonMap[0];
    private LinkedHashMap<String, List<Button>> buttonGroups = null;
    private List<Button> systemButtons = null;
    private Button[][] activityButtonGroups = null;
    private KeyButtonGroup[] keyButtonGroups = null;
    private Activity.Control[] activityControl = new Activity.Control[0];
    private boolean omitDigitMapByte = false;
    private boolean zeroDigitMapByte = false;
    private boolean globalSpecialFunctions = false;
    private Hashtable<Hex, List<String>> protocolVariantNames = new Hashtable();
    private List<Protocol> protocols = null;
    private ImageMap[] imageMaps = new ImageMap[0];
    private String[] imageMapNames = new String[0];
    private HashMap<Integer, HashMap<Integer, Integer>> extractSetupCodes = null;
    private DeviceType[] extractDeviceTypes = null;
    private String extractSignature = null;
    private int mapIndex = 0;
    private int shiftMask = 128;
    private boolean shiftEnabled = true;
    private int xShiftMask = 192;
    private boolean xShiftEnabled = false;
    private String shiftLabel = "Shift";
    private String xShiftLabel = "XShift";
    private int defaultRestrictions = 0;
    private AdvancedCode.Format advCodeFormat = AdvancedCode.Format.HEX;
    private AdvancedCode.BindFormat advCodeBindFormat = AdvancedCode.BindFormat.NORMAL;
    private int efcDigits = 3;
    private int[] devCombAddress = null;
    private int protocolVectorOffset = 0;
    private int protocolDataOffset = 0;
    private EncrypterDecrypter encdec = null;
    private boolean supportsBinaryUpgrades = false;
    private Integer maxProtocolLength = null;
    private Integer maxUpgradeLength = null;
    private Integer maxCombinedUpgradeLength = null;
    private short sectionTerminator = 0;
    private int activityMapIndex = 0;
    private int rdfVersionAddress = 0;
    private List<Button> rdfRealTimeMacroButtons = null;
    private BlockFormat blockFormat = BlockFormat.DEFAULT;
    private boolean flaggedDSM = false;
    public List<SpecialProtocol> specialProtocols = new ArrayList<SpecialProtocol>();
    private boolean twoBytePID = false;
    private boolean twoByteSetupCode = false;
    private boolean learnedDevBtnSwapped = false;
    private static Hashtable<String, Integer> restrictionTable = null;
    private DeviceLabels labels = null;
    private SoftDevices softDevices = null;
    private SoftHomeTheater softHomeTheater = null;
    private MacroCodingType macroCodingType = new MacroCodingType();
    private int startReadOnlySettings = Integer.MAX_VALUE;
    private Hashtable<String, PauseParameters> pauseParameters = new Hashtable();
    private short[] powerButtons = new short[0];
    private int realTimeCodeBase = 0;
    private boolean waveUpgrade = false;
    private boolean forceEvenStarts = false;
    private int forceModulus = 1;
    private boolean masterPowerSupport = false;
    private SetupValidation setupValidation = SetupValidation.OFF;
    private int keyMoveCode = 0;
    private int macroCode = 16;
    private int deviceIndexMask = 15;
    private int sequenceNumberMask = 112;
    private int maxMultiMacros = 3;
    private String rdfName = "Not Specified";
    private String rdfIdentification = "None";
    public static final String[] userFilenames = new String[]{"home.xcf", "system.xcf", "devices.xcf", "activities.xcf", "profiles.xcf", "favorites.xcf", "macros.xcf", "snstest.xcf", "usericons.pkg", "SysIcons.pkg"};
    public static Hex colorHex = null;
    public static boolean prelimLoad = false;
    private static final String colorData = "28 28 28 28 00 00 00 28 00 00 00 28 28 28 00 00 28 28 28 00 28 1E 1E 1E 14 14 14 14 00 00 14 14 00 00 14 00 14 00 14 00 14 14 00 00 14 28 05 00 16 00 00 1A 07 07 1C 05 05 22 03 09 28 0F 0B 28 14 0D 20 0E 0E 26 14 14 24 17 13 27 14 11 28 19 13 28 0A 00 28 16 00 28 1A 00 28 22 00 1D 15 02 22 1A 05 25 24 1B 1E 1D 11 26 24 16 18 20 08 0D 11 07 11 16 05 12 1D 00 13 27 00 14 28 00 1B 28 07 02 13 00 00 10 00 00 14 00 05 16 05 08 20 08 17 25 17 18 27 18 16 1D 16 00 27 18 00 28 14 07 16 0E 10 20 1B 09 1C 12 05 1C 1B 07 0C 0C 00 14 14 00 16 16 23 28 28 00 20 21 0A 23 21 0B 20 21 1B 25 25 14 28 21 1C 23 24 0F 1B 19 0B 14 1C 10 17 25 00 1E 28 05 17 28 1B 22 24 15 20 25 15 20 27 04 04 12 00 00 16 00 00 20 0A 10 23 16 07 23 0C 00 14 0B 0A 16 11 0E 20 13 10 25 17 12 22 16 00 16 17 00 21 18 08 20 1D 0D 21 22 1E 22 23 19 23 25 14 25 22 12 21 1F 03 15 22 12 17 28 03 17 28 10 1C 28 1E 20 27 25 22 26 26 18 16 0B 03 1D 16 16 12 14 17 1C 1F 23 24 24 27 28 27 26 26 27 28";

    public Remote(Remote aRemote, int index) {
        this();
        this.file = aRemote.file;
        this.signature = aRemote.signature;
        this.supportsBinaryUpgrades = aRemote.supportsBinaryUpgrades;
        this.names = aRemote.names;
        this.realTimeCodeBase = aRemote.realTimeCodeBase;
        this.nameIndex = index;
    }

    public Remote() {
        RemoteConfiguration.KeySpec.remote = this;
    }

    public Remote(File rdf) {
        this();
        this.file = rdf;
        String rdfName = rdf.getName();
        StringTokenizer st = new StringTokenizer(rdfName);
        this.signature = st.nextToken();
        this.supportsBinaryUpgrades = this.signature.startsWith("BIN");
        int openParen = rdfName.indexOf(40);
        int closeParen = rdfName.lastIndexOf(41);
        String name = rdfName.substring(openParen + 1, closeParen);
        st = new StringTokenizer(name, " -", true);
        String prefix = "";
        String postfix = "";
        String[] middles = null;
        boolean foundUnderscore = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() > 3 && token.indexOf(95) != -1) {
                foundUnderscore = true;
                StringTokenizer st2 = new StringTokenizer(token, "_");
                middles = new String[st2.countTokens()];
                for (int i = 0; i < middles.length; ++i) {
                    middles[i] = st2.nextToken();
                }
                continue;
            }
            token = token.replace('_', '/');
            if (foundUnderscore) {
                postfix = postfix + token;
                continue;
            }
            prefix = prefix + token;
        }
        if (middles == null) {
            this.names[0] = prefix;
        } else {
            this.names = new String[middles.length];
            for (int i = 0; i < middles.length; ++i) {
                this.names[i] = middles[i].length() < middles[0].length() ? middles[i] + postfix : prefix + middles[i] + postfix;
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        try {
            if (this.loaded) {
                SetupCode.setMax(this);
                KeyMove.setSetupCodeIndex(this.segmentTypes == null ? 0 : 1);
                KeyMove.setCmdIndex(this.segmentTypes == null ? 2 : 3);
                return;
            }
            this.loaded = true;
            this.settingAddresses.clear();
            this.settingMasks.clear();
            this.settingBytes.clear();
            RDFReader rdr = new RDFReader(this.file);
            String line = rdr.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = rdr.readLine();
                    continue;
                }
                if (line.charAt(0) == '[') {
                    StringTokenizer st = new StringTokenizer(line, "[]");
                    if ((line = st.nextToken()).equals("General") || line.equals("General+")) {
                        line = this.parseGeneralSection(rdr);
                        continue;
                    }
                    if (line.equals("Extender")) {
                        line = this.parseExtender(rdr);
                        continue;
                    }
                    if ((line.equals("SpecialProtocols") || line.equals("SpecialProtocols+")) && this.specialProtocols.isEmpty()) {
                        line = this.parseSpecialProtocols(rdr);
                        continue;
                    }
                    if (line.equals("Checksums")) {
                        line = this.parseCheckSums(rdr);
                        continue;
                    }
                    if (line.equals("Settings") || line.equals("Settings+")) {
                        line = this.parseSettings(rdr);
                        continue;
                    }
                    if ((line.equals("FixedData") || line.equals("FixedData+")) && this.fixedData.length == 0) {
                        this.fixedData = FixedData.parse(rdr);
                        this.rawFixedData = this.fixedData;
                        line = "";
                        continue;
                    }
                    if (line.equals("AutoSet")) {
                        this.autoSet = FixedData.parse(rdr);
                        line = "";
                        continue;
                    }
                    if ((line.equals("DeviceButtons") || line.equals("DeviceButtons+")) && this.deviceButtons.length == 0) {
                        line = this.parseDeviceButtons(rdr);
                        continue;
                    }
                    if (line.equals("DigitMaps")) {
                        line = this.parseDigitMaps(rdr);
                        continue;
                    }
                    if ((line.equals("DeviceTypes") || line.equals("DeviceTypes+")) && this.deviceTypeList.isEmpty()) {
                        line = this.parseDeviceTypes(rdr);
                        continue;
                    }
                    if (line.equals("DeviceAbbreviations")) {
                        line = this.parseDeviceAbbreviations(rdr);
                        continue;
                    }
                    if (line.equals("DeviceTypeAliases")) {
                        line = this.parseDeviceTypeAliases(rdr);
                        continue;
                    }
                    if (line.equals("DeviceTypeImageMaps")) {
                        line = this.parseDeviceTypeImageMaps(rdr);
                        continue;
                    }
                    if (line.equals("Buttons")) {
                        line = this.parseButtons(rdr);
                        continue;
                    }
                    if (line.equals("MultiMacros")) {
                        line = this.parseMultiMacros(rdr);
                        continue;
                    }
                    if (line.equals("ButtonMaps")) {
                        line = this.parseButtonMaps(rdr);
                        continue;
                    }
                    if (line.equals("Protocols")) {
                        line = this.parseProtocols(rdr);
                        continue;
                    }
                    if (line.equals("SetupCodes") || line.equals("SetupCodes+")) {
                        line = this.parseSetupCodes(rdr);
                        continue;
                    }
                    if (line.equals("ActivityControl")) {
                        line = this.parseActivityControl(rdr);
                        continue;
                    }
                    line = rdr.readLine();
                    continue;
                }
                line = rdr.readLine();
            }
            rdr.close();
            if (this.specialProtocols.size() > 0) {
                int maxSerial = 0;
                for (SpecialProtocol sp : this.specialProtocols) {
                    if (!sp.isInternal() || maxSerial >= sp.getInternalSerial()) continue;
                    maxSerial = sp.getInternalSerial();
                }
                if (maxSerial > 0) {
                    int serialMask = maxSerial < 2 ? 1 : (maxSerial < 4 ? 3 : (maxSerial < 8 ? 7 : 15));
                    int dbMask = 0;
                    for (DeviceButton db : this.deviceButtons) {
                        dbMask |= db.getButtonIndex();
                    }
                    if ((dbMask & serialMask << 4) == 0) {
                        this.seqShift = 4;
                    } else if ((dbMask & serialMask << 3) == 0) {
                        this.seqShift = 3;
                    } else {
                        String title = "Special Function Error";
                        String message = "Error in RDF.  This remote cannot support an internal Special Function\nwith a serial value " + maxSerial;
                        JOptionPane.showMessageDialog(null, message, title, 2);
                    }
                }
            }
            if (this.buttonMaps.length == 0) {
                System.err.println("ERROR: " + this.file.getName() + " does not specify any ButtonMaps!");
                this.buttonMaps = new ButtonMap[1];
                this.buttonMaps[0] = new ButtonMap(0, new short[0][0]);
            }
            for (int i = 0; i < this.buttonMaps.length; ++i) {
                this.buttonMaps[i].setButtons(this);
            }
            for (DeviceType type : this.deviceTypes.values()) {
                int map = type.getMap();
                if (map == -1) {
                    System.err.println("ERROR:" + this.file.getName() + ": DeviceType " + type.getName() + " doesn't have a map.");
                }
                if (map >= this.buttonMaps.length) {
                    if (!prelimLoad) {
                        System.err.println("ERROR:" + this.file.getName() + ": DeviceType " + type.getName() + " uses an undefined map index.");
                    }
                    map = this.buttonMaps.length - 1;
                }
                if (map == -1 || this.buttonMaps.length <= 0) continue;
                type.setButtonMap(this.buttonMaps[map]);
            }
            if (this.deviceTypeAliasNames == null) {
                Setting[] v = new ArrayList();
                DeviceType vcrType = null;
                boolean hasPVRalias = false;
                for (DeviceType type : this.deviceTypes.values()) {
                    String typeName = type.getName();
                    if (typeName.startsWith("VCR")) {
                        vcrType = type;
                    }
                    if (typeName.equals("PVR")) {
                        hasPVRalias = true;
                    }
                    this.deviceTypeAliases.put(typeName, type);
                    v.add(typeName);
                }
                if (!hasPVRalias && vcrType != null) {
                    v.add("PVR");
                    this.deviceTypeAliases.put("PVR", vcrType);
                }
                this.deviceTypeAliasNames = new String[0];
                this.deviceTypeAliasNames = v.toArray(this.deviceTypeAliasNames);
                Arrays.sort(this.deviceTypeAliasNames);
            }
            if (this.settings != null) {
                for (Setting setting : this.settings) {
                    setting.optionsFromButtonGroup(this);
                }
            }
            if (this.usesEZRC() && this.favKey != null) {
                Button fav = this.getButton(this.getFavKey().getKeyCode());
                this.favKey.setActivity(new Activity(fav, this));
            }
            ButtonMap longestMap = null;
            for (DeviceType type : this.deviceTypes.values()) {
                ButtonMap thisMap = type.getButtonMap();
                if (longestMap != null && longestMap.size() >= thisMap.size()) continue;
                longestMap = thisMap;
            }
            Collections.sort(this.buttons, longestMap.mapSort);
            if (this.activityButtonGroups != null) {
                for (int i = 0; i < this.activityButtonGroups.length; ++i) {
                    if (this.activityButtonGroups[i] == null) continue;
                    Arrays.sort(this.activityButtonGroups[i], longestMap.mapSort);
                }
            }
            if (this.systemButtons != null) {
                Collections.sort(this.systemButtons, longestMap.mapSort);
            }
            ArrayList<Button> keyMoveBindableButtons = new ArrayList<Button>();
            ArrayList<Button> baseKeyMoveBindableButtons = new ArrayList<Button>();
            ArrayList<Button> macroBindableButtons = new ArrayList<Button>();
            ArrayList<Button> normalMacroBindableButtons = new ArrayList<Button>();
            ArrayList<Button> realTimeMacroBindableButtons = new ArrayList<Button>();
            ArrayList<Button> controlledMacroBindableButtons = new ArrayList<Button>();
            ArrayList<Button> multiMacroBindableButtons = new ArrayList<Button>();
            ArrayList<Button> learnBindableButtons = new ArrayList<Button>();
            if (this.realTimeMacroKeyData != null) {
                Hex realTimeMacroKeyCodes = new Hex(this.realTimeMacroKeyData);
                this.rdfRealTimeMacroButtons = new ArrayList<Button>();
                for (Object keyCode : (Iterator<DeviceType>)realTimeMacroKeyCodes.getData()) {
                    this.rdfRealTimeMacroButtons.add(this.getButton((int)keyCode));
                }
            }
            int index = 0;
            while (index < longestMap.size()) {
                Button b;
                if (((b = longestMap.get(index++)).allowsKeyMove() || b.allowsShiftedKeyMove() || b.allowsXShiftedKeyMove()) && !keyMoveBindableButtons.contains(b)) {
                    keyMoveBindableButtons.add(b);
                }
                if (b.getIsShifted() && b.getBaseButton() != null && b.getName().equals(this.getShiftLabel() + '-' + b.getBaseButton().getName()) || b.getIsXShifted() && b.getBaseButton() != null && b.getName().equals(this.getXShiftLabel() + '-' + b.getBaseButton().getName())) {
                    b = b.getBaseButton();
                }
                if (!this.distinctButtons.contains(b)) {
                    this.distinctButtons.add(b);
                }
                if ((b.allowsKeyMove() || b.allowsShiftedKeyMove() || b.allowsXShiftedKeyMove()) && !baseKeyMoveBindableButtons.contains(b)) {
                    baseKeyMoveBindableButtons.add(b);
                }
                if ((b.allowsMacro() || b.allowsShiftedMacro() || b.allowsXShiftedMacro()) && !macroBindableButtons.contains(b)) {
                    macroBindableButtons.add(b);
                    if (b.getMultiMacro() == null || this.segmentTypes != null) {
                        normalMacroBindableButtons.add(b);
                    }
                    if (b.getMultiMacro() != null && this.macroSupport != 3) {
                        multiMacroBindableButtons.add(b);
                    }
                    if (this.macroSupport == 2) {
                        if (b.allowsControlledMacro()) {
                            controlledMacroBindableButtons.add(b);
                        } else {
                            realTimeMacroBindableButtons.add(b);
                        }
                    } else if (this.macroSupport == 3) {
                        if (b.getMultiMacro() == null) {
                            realTimeMacroBindableButtons.add(b);
                        }
                        if (!this.rdfRealTimeMacroButtons.contains(b)) {
                            multiMacroBindableButtons.add(b);
                        }
                    } else if (this.realTimeMacroKeyData != null) {
                        if (this.realTimeMacroKeyData.equals("All")) {
                            realTimeMacroBindableButtons.addAll(normalMacroBindableButtons);
                        } else {
                            realTimeMacroBindableButtons.addAll(this.rdfRealTimeMacroButtons);
                        }
                    }
                }
                if (!b.allowsLearnedSignal() && !b.allowsShiftedLearnedSignal() && !b.allowsXShiftedLearnedSignal() || learnBindableButtons.contains(b)) continue;
                learnBindableButtons.add(b);
            }
            for (Button b : this.buttons) {
                if ((b.allowsKeyMove() || b.allowsShiftedKeyMove() || b.allowsXShiftedKeyMove()) && !keyMoveBindableButtons.contains(b)) {
                    keyMoveBindableButtons.add(b);
                }
                if (b.getIsShifted() && b.getBaseButton() != null && b.getName().equals(this.getShiftLabel() + '-' + b.getBaseButton().getName()) || b.getIsXShifted() && b.getBaseButton() != null && b.getName().equals(this.getXShiftLabel() + '-' + b.getBaseButton().getName())) {
                    b = b.getBaseButton();
                }
                if (!this.distinctButtons.contains(b)) {
                    this.distinctButtons.add(b);
                }
                if ((b.allowsKeyMove() || b.allowsShiftedKeyMove() || b.allowsXShiftedKeyMove()) && !baseKeyMoveBindableButtons.contains(b)) {
                    baseKeyMoveBindableButtons.add(b);
                }
                if ((b.allowsMacro() || b.allowsShiftedMacro() || b.allowsXShiftedMacro()) && !macroBindableButtons.contains(b)) {
                    macroBindableButtons.add(b);
                    if (b.getMultiMacro() == null || this.segmentTypes != null) {
                        normalMacroBindableButtons.add(b);
                    }
                    if (b.getMultiMacro() != null && this.macroSupport != 3) {
                        multiMacroBindableButtons.add(b);
                    }
                    if (this.macroSupport == 2) {
                        if (b.allowsControlledMacro()) {
                            controlledMacroBindableButtons.add(b);
                        } else {
                            realTimeMacroBindableButtons.add(b);
                        }
                    } else if (this.macroSupport == 3) {
                        if (b.getMultiMacro() == null) {
                            realTimeMacroBindableButtons.add(b);
                        }
                        if (!this.rdfRealTimeMacroButtons.contains(b)) {
                            multiMacroBindableButtons.add(b);
                        }
                    } else if (this.realTimeMacroKeyData != null) {
                        if (this.realTimeMacroKeyData.equals("All")) {
                            realTimeMacroBindableButtons.addAll(normalMacroBindableButtons);
                        } else {
                            realTimeMacroBindableButtons.addAll(this.rdfRealTimeMacroButtons);
                        }
                    }
                }
                if (!b.allowsLearnedSignal() && !b.allowsShiftedLearnedSignal() && !b.allowsXShiftedLearnedSignal() || learnBindableButtons.contains(b)) continue;
                learnBindableButtons.add(b);
            }
            this.baseUpgradeButtons = baseKeyMoveBindableButtons.toArray(this.baseUpgradeButtons);
            this.upgradeButtons = keyMoveBindableButtons.toArray(this.upgradeButtons);
            this.macroButtons = macroBindableButtons.toArray(this.macroButtons);
            this.normalMacroButtons = normalMacroBindableButtons.toArray(new Button[0]);
            if (controlledMacroBindableButtons.size() > 0) {
                this.controlledMacroButtons = controlledMacroBindableButtons.toArray(new Button[0]);
            }
            if (multiMacroBindableButtons.size() > 0) {
                this.multiMacroButtons = multiMacroBindableButtons.toArray(new Button[0]);
            }
            this.learnButtons = learnBindableButtons.toArray(this.learnButtons);
            if (this.realTimeMacroButtons == null && realTimeMacroBindableButtons.size() > 0) {
                this.realTimeMacroButtons = realTimeMacroBindableButtons.toArray(new Button[0]);
            } else if (this.realTimeMacroButtons == null && this.usesEZRC()) {
                this.realTimeMacroButtons = this.macroButtons;
                this.normalMacroButtons = null;
            }
            if (!this.needsLayoutWarning() && !this.hasDeviceTypeImageMaps) {
                this.imageMaps[this.mapIndex].parse(this);
            }
            for (DeviceType type : this.deviceTypes.values()) {
                ImageMap[][] maps = type.getImageMaps();
                if (maps.length <= 0) continue;
                ImageMap[] a = maps[this.mapIndex];
                for (int i = 0; i < a.length; ++i) {
                    a[i].parse(this);
                }
            }
            this.setPhantomShapes();
            this.loaded = true;
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), fnfe.getMessage(), "Remote Load Error", 0);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            pw.close();
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), sw.toString(), "Remote Load Error", 0);
            System.err.println(sw.toString());
        }
    }

    public boolean needsLayoutWarning() {
        if (this.hasDeviceTypeImageMaps) {
            return false;
        }
        boolean warn = false;
        if (this.imageMaps.length > this.mapIndex) {
            ImageMap map = this.imageMaps[this.mapIndex];
            if (map == null || map.getMapFile() == null || !map.getMapFile().exists()) {
                warn = true;
                if (!prelimLoad) {
                    String message = map == null || map.getMapFile() == null ? "No map file specified in RDF.\n" : "Map file " + map.getMapFile().getName() + " does not exist.\n";
                    message = message + "A default button layout will be used.";
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, "Remote Load Error", 2);
                }
            }
        } else {
            warn = true;
        }
        return warn;
    }

    private String parseActivityControl(RDFReader rdr) throws Exception {
        String line;
        List<Button> activityBtns = this.buttonGroups.get("Activity");
        ArrayList<DeviceButton> ctrlBtns = new ArrayList<DeviceButton>();
        String control = null;
        int activityIndex = -1;
        int groupIndex = -1;
        if (activityBtns == null || this.activityButtonGroups == null) {
            return "";
        }
        while ((line = rdr.readLine()) != null && line.length() != 0 && line.charAt(0) != '[') {
            StringTokenizer st = new StringTokenizer(line, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                ctrlBtns.clear();
                int pos = token.indexOf(61);
                if (pos != -1) {
                    if (this.activityControl == null || this.activityControl.length == 0) {
                        this.activityControl = new Activity.Control[activityBtns.size()];
                        for (int i = 0; i < this.activityControl.length; ++i) {
                            Activity.Control ac = new Activity.Control();
                            ac.devices = new DeviceButton[this.activityButtonGroups.length][];
                            ac.overrides = new DeviceButton[this.activityButtonGroups.length];
                            this.activityControl[i] = ac;
                        }
                    }
                    control = token.substring(pos + 1);
                    token = token.substring(0, pos).trim();
                    activityIndex = activityBtns.indexOf(this.getButton(token));
                } else {
                    control = token;
                }
                String override = null;
                pos = control.indexOf("::");
                if (pos != -1) {
                    override = control.substring(pos + 2).trim();
                    control = control.substring(0, pos);
                }
                if ((pos = control.indexOf(":")) != -1) {
                    StringTokenizer st2;
                    String group = control.substring(0, pos).trim();
                    control = control.substring(pos + 1);
                    if (group.toLowerCase().startsWith("group")) {
                        Button btn;
                        DeviceButton dev;
                        groupIndex = Integer.parseInt(group.substring(5));
                        st2 = new StringTokenizer(control, "+");
                        while (st2.hasMoreTokens()) {
                            token = st2.nextToken().trim();
                            Button btn2 = this.getButton(token);
                            if (btn2 == null) continue;
                            dev = this.getDeviceButton(btn2.getKeyCode());
                            ctrlBtns.add(dev);
                        }
                        this.activityControl[activityIndex].devices[groupIndex] = new DeviceButton[ctrlBtns.size()];
                        for (int i = 0; i < ctrlBtns.size(); ++i) {
                            this.activityControl[activityIndex].devices[groupIndex][i] = (DeviceButton)ctrlBtns.get(i);
                        }
                        if (override == null || (btn = this.getButton(override)) == null) continue;
                        this.activityControl[activityIndex].overrides[groupIndex] = dev = this.getDeviceButton(btn.getKeyCode());
                        continue;
                    }
                    if (group.equalsIgnoreCase("maps")) {
                        st2 = new StringTokenizer(control, "+");
                        ArrayList<Integer> mapList = new ArrayList<Integer>();
                        while (st2.hasMoreTokens()) {
                            try {
                                token = st2.nextToken().trim();
                                int map = RDFReader.parseNumber(token);
                                mapList.add(map);
                            }
                            catch (Exception ex) {
                                mapList.add(0);
                                System.err.println("RDF error in [ActivityControl]: " + token + " is not an integer");
                            }
                        }
                        this.activityControl[activityIndex].maps = mapList.toArray(new Integer[0]);
                        continue;
                    }
                    this.activityControl = new Activity.Control[0];
                    return line;
                }
                this.activityControl = new Activity.Control[0];
                return line;
            }
        }
        return line;
    }

    private void setPhantomShapes() {
        double radius = 8.0;
        double gap = 6.0;
        double diameter = 2.0 * radius;
        double x = gap;
        ArrayList<ImageMap> maps = new ArrayList<ImageMap>();
        if (this.imageMaps.length > 0 && this.imageMaps[this.mapIndex] != null && this.imageMaps[this.mapIndex].getMapFile() != null && this.imageMaps[this.mapIndex].getMapFile().exists()) {
            maps.add(this.imageMaps[this.mapIndex]);
        }
        for (DeviceType type : this.deviceTypes.values()) {
            if (type.getImageMaps().length == 0) continue;
            ImageMap[] devMaps = type.getImageMaps()[this.mapIndex];
            for (int i = 0; i < devMaps.length; ++i) {
                maps.add(devMaps[i]);
            }
        }
        for (ImageMap map : maps) {
            ImageIcon icon = new ImageIcon(map.getImageFile().getAbsolutePath());
            int h = icon.getIconHeight();
            int w = icon.getIconWidth();
            if (h > this.height) {
                this.height = h;
            }
            if (w <= this.width) continue;
            this.width = w;
        }
        double y = (double)this.height + gap;
        if (this.width == 0) {
            this.width = (int)(6.0 * diameter + 5.0 * gap);
        }
        for (int i = 0; i < this.upgradeButtons.length; ++i) {
            Button b = this.upgradeButtons[i];
            if (this.isSSD() && this.isSoftButton(b) && b.getKeyCode() > 54 || b.getHasShape() || b.getIsShifted() || b.getIsXShifted()) continue;
            if (x + diameter + gap > (double)this.width) {
                x = gap;
                y += gap + diameter;
            }
            Ellipse2D.Double shape = new Ellipse2D.Double(x, y, diameter, diameter);
            x += diameter + gap;
            ButtonShape buttonShape = new ButtonShape(shape, b);
            this.phantomShapes.add(buttonShape);
            b.setHasShape(true);
        }
        this.height = (int)(y + gap + diameter);
        for (ImageMap map : maps) {
            map.getShapes().addAll(this.phantomShapes);
        }
        if (!(maps.size() != 0 || this.imageMaps[this.mapIndex].getMapFile() != null && this.imageMaps[this.mapIndex].getMapFile().exists())) {
            this.imageMaps[this.mapIndex].getShapes().addAll(this.phantomShapes);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getSignature() {
        return this.signature;
    }

    public List<String> getExtract() {
        return this.extract;
    }

    public void setExtractData() {
        if (this.extract == null || this.extractSetupCodes != null) {
            return;
        }
        this.extractSetupCodes = new HashMap();
        ArrayList<DeviceType> extractDeviceTypeList = new ArrayList<DeviceType>();
        for (String line : this.extract) {
            StringTokenizer st = new StringTokenizer(line, ",");
            if (!st.hasMoreTokens() || !st.nextToken().startsWith(this.extractSignature)) continue;
            String modeStr = st.nextToken();
            int mode = Integer.parseInt(modeStr);
            DeviceType type = this.getDeviceTypeByIndex(mode);
            if (!extractDeviceTypeList.contains(type)) {
                extractDeviceTypeList.add(type);
            }
            Integer setupCode = Integer.parseInt(st.nextToken()) + this.deviceCodeOffset;
            if (this.extractSetupCodes.get(mode) == null) {
                this.extractSetupCodes.put(mode, new HashMap());
            }
            this.extractSetupCodes.get(mode).put(setupCode, setupCode);
        }
        this.extractDeviceTypes = extractDeviceTypeList.toArray(new DeviceType[0]);
    }

    public void setExtract() {
        if (this.extract != null) {
            return;
        }
        this.extractSignature = this.oemSignatures != null && !this.oemSignatures.isEmpty() ? this.oemSignatures.get(0) : (this.firmwareSignature != null ? this.firmwareSignature : this.signature);
        File extracts = new File(RemoteMaster.getWorkDir(), "Extracts");
        if (extracts.exists() && extracts.isDirectory()) {
            for (File f : extracts.listFiles()) {
                char delim;
                String name = f.getName();
                if (!name.startsWith(this.signature) || !name.endsWith(".csv") || Character.digit(delim = name.charAt(this.signature.length()), 10) >= 0) continue;
                ArrayList<String> csvLines = new ArrayList<String>();
                try {
                    BufferedReader rdr = new BufferedReader(new FileReader(f));
                    String line = null;
                    while ((line = rdr.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, ",");
                        if (!st.hasMoreTokens() || !st.nextToken().startsWith(this.signature)) continue;
                        csvLines.add(line);
                    }
                    rdr.close();
                }
                catch (Exception e) {
                    System.err.println("Unable to read file " + name);
                    return;
                }
                if (csvLines.isEmpty()) continue;
                this.extract = csvLines;
                return;
            }
        }
        this.extract = CommHID.getCSVlines(this);
    }

    public boolean isSSD() {
        this.load();
        return this.signature.startsWith("USB") && this.processor.getName().equals("S3F80");
    }

    public boolean isFDRA() {
        this.load();
        List<String> pids = Arrays.asList("8008", "8009", "8010", "8011", "0007");
        return this.signature.startsWith("USB") && pids.contains(this.signature.substring(3));
    }

    public boolean hasProfiles() {
        return this.isSSD();
    }

    public int getSigAddress() {
        return this.sigAddress;
    }

    public String getName() {
        return this.names[this.nameIndex].trim().replaceAll("\\s+", " ");
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public int getNameCount() {
        return this.names.length;
    }

    public int getBaseAddress() {
        this.load();
        return this.baseAddress;
    }

    public int getEepromSize() {
        this.load();
        return this.eepromSize;
    }

    public int getDeviceCodeOffset() {
        return this.deviceCodeOffset;
    }

    public int getMaxBuiltInCode() {
        return this.maxBuiltInCode;
    }

    public DeviceType[] getDeviceTypes() {
        int maxNum = 0;
        for (DeviceType type : this.deviceTypeList) {
            maxNum = Math.max(maxNum, type.getNumber());
        }
        DeviceType[] types = new DeviceType[maxNum + 1];
        ArrayList<DeviceType> list = new ArrayList<DeviceType>();
        for (DeviceType type : this.deviceTypeList) {
            int num = type.getNumber();
            if (types[num] != null) continue;
            types[num] = type;
            list.add(type);
        }
        for (DeviceType type : types) {
            if (type != null) continue;
            return list.toArray(new DeviceType[0]);
        }
        return types;
    }

    public DeviceType[] getAllDeviceTypes() {
        ArrayList<DeviceType> tempList = new ArrayList<DeviceType>();
        DeviceType d = null;
        for (DeviceType deviceType : this.deviceTypeList) {
            d = this.devicesByType.get(deviceType.get_Type());
            if (tempList.contains(d)) continue;
            tempList.add(d);
        }
        DeviceType[] types = tempList.toArray(new DeviceType[0]);
        return types;
    }

    public DeviceType getDeviceType(String typeName) {
        DeviceType devType = this.deviceTypes.get(typeName);
        if (devType == null) {
            for (Map.Entry<String, DeviceType> entry : this.deviceTypes.entrySet()) {
                String name = entry.getKey();
                int slash = name.indexOf(47);
                if (slash == -1 || !typeName.equals(name.substring(0, slash)) && !typeName.equals(name.substring(slash + 1))) continue;
                devType = entry.getValue();
                break;
            }
        }
        return devType;
    }

    public DeviceType getDeviceTypeByAliasName(String aliasName) {
        DeviceType type = this.deviceTypeAliases.get(aliasName);
        if (type != null) {
            return type;
        }
        return this.getDeviceType(aliasName);
    }

    public DeviceType getDeviceTypeByIndex(int index) {
        for (DeviceType type : this.deviceTypes.values()) {
            if (type.getNumber() != index) continue;
            return type;
        }
        return null;
    }

    public DeviceType getDeviceTypeByIndexAndGroup(int index, int group) {
        if (group == -1) {
            return this.getDeviceTypeByIndex(index);
        }
        int fullType = index | group << 8;
        return this.devicesByType.get(fullType);
    }

    public String getDeviceTypeAlias(DeviceType type) {
        String tentative = null;
        for (String alias : this.deviceTypeAliasNames) {
            if (this.getDeviceTypeByAliasName(alias) != type) continue;
            String typeName = type.getName();
            if (typeName.equals(alias)) {
                return alias;
            }
            if (!typeName.contains(alias) && !alias.contains(typeName) || tentative != null) continue;
            tentative = alias;
        }
        if (tentative != null) {
            return tentative;
        }
        for (String alias : this.deviceTypeAliasNames) {
            if (this.getDeviceTypeByAliasName(alias) != type) continue;
            tentative = alias;
            break;
        }
        return tentative;
    }

    public List<DeviceType> getDeviceTypeList() {
        return this.deviceTypeList;
    }

    public DeviceButton[] getDeviceButtons() {
        this.load();
        return this.deviceButtons;
    }

    public DeviceButton getDeviceButton(int index) {
        if (index == -1) {
            return DeviceButton.noButton;
        }
        this.load();
        for (DeviceButton devBtn : this.deviceButtons) {
            if (devBtn.getButtonIndex() != index) continue;
            return devBtn;
        }
        return null;
    }

    public List<Button> getButtons() {
        this.load();
        return this.buttons;
    }

    public LinkedHashMap<String, List<Button>> getButtonGroups() {
        return this.buttonGroups;
    }

    public Button[][] getActivityButtonGroups() {
        return this.activityButtonGroups;
    }

    public KeyButtonGroup[] getKeyButtonGroups() {
        return this.keyButtonGroups;
    }

    public Button[] getUpgradeButtons() {
        this.load();
        return this.upgradeButtons;
    }

    public Button[] getBaseUpgradeButtons() {
        return this.baseUpgradeButtons;
    }

    public Button[] getMacroButtons() {
        this.load();
        return this.macroButtons;
    }

    public Button[] getMacroButtons(Macro.MacroClass macroClass, boolean all) {
        this.load();
        if (all) {
            return this.macroButtons;
        }
        if (macroClass == Macro.MacroClass.NORMAL) {
            return this.normalMacroButtons;
        }
        if (macroClass == Macro.MacroClass.CONTROLLED) {
            return this.controlledMacroButtons;
        }
        if (macroClass == Macro.MacroClass.REALTIME) {
            return this.realTimeMacroButtons;
        }
        if (macroClass == Macro.MacroClass.MULTI) {
            return this.multiMacroButtons;
        }
        return this.macroButtons;
    }

    public Button[] getLearnButtons() {
        this.load();
        return this.learnButtons;
    }

    public List<Button> getFunctionButtons() {
        return this.functionButtons;
    }

    public List<Button> getDistinctButtons() {
        return this.distinctButtons;
    }

    public List<Integer> getSegmentTypes() {
        if (!this.loaded) {
            this.load();
        }
        return this.segmentTypes;
    }

    public Activity.Control[] getActivityControl() {
        return this.activityControl;
    }

    public List<ButtonShape> getPhantomShapes() {
        this.load();
        return this.phantomShapes;
    }

    public Processor getProcessor() {
        this.load();
        return this.processor;
    }

    public int getE2FormatOffset() {
        if (this.blockFormat == BlockFormat.DEFAULT) {
            if (this.processor.getName().equals("MAXQ622") || this.checkSums.length > 0 && this.checkSums[0] instanceof Xor16CheckSum) {
                return 6;
            }
            return -1;
        }
        return this.blockFormat == BlockFormat.YES ? 6 : -1;
    }

    public int getRAMAddress() {
        this.load();
        return this.RAMAddress;
    }

    public short[] getDigitMaps() {
        this.load();
        return this.digitMaps;
    }

    public boolean getOmitDigitMapByte() {
        this.load();
        return this.omitDigitMapByte;
    }

    public boolean getZeroDigitMapByte() {
        this.load();
        return this.zeroDigitMapByte;
    }

    public boolean hasGlobalSpecialFunctions() {
        this.load();
        return this.globalSpecialFunctions;
    }

    public ImageMap[] getImageMaps(DeviceType type) {
        this.load();
        ImageMap[][] maps = type.getImageMaps();
        if (maps != null && maps.length != 0) {
            return maps[this.mapIndex];
        }
        ImageMap[] rc = new ImageMap[]{this.imageMaps[this.mapIndex]};
        return rc;
    }

    public AdvancedCode.Format getAdvCodeFormat() {
        this.load();
        return this.advCodeFormat;
    }

    public AdvancedCode.BindFormat getAdvCodeBindFormat() {
        this.load();
        return this.advCodeBindFormat;
    }

    public boolean supportsKeyCodeKeyMoves() {
        return this.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG;
    }

    public int getEFCDigits() {
        this.load();
        return this.efcDigits;
    }

    public void check(AddressRange addressRange, String name) throws IllegalArgumentException {
        int bound = addressRange.getStart();
        if (bound >= this.eepromSize) {
            throw new IllegalArgumentException("RDF Error: " + name + " starts at $" + Integer.toString(bound, 16) + ", beyond the eepromSize of $" + Integer.toString(this.eepromSize, 16));
        }
        bound = addressRange.getEnd();
        if (bound >= this.eepromSize) {
            throw new IllegalArgumentException("RDF Error: " + name + " ends at $" + Integer.toString(bound, 16) + ", beyond the eepromSize of $" + Integer.toString(this.eepromSize, 16));
        }
    }

    private String parseGeneralSection(RDFReader rdr) throws Exception {
        String processorName = this.processor == null ? "S3C80" : this.processor.getName();
        String processorVersion = null;
        String line = null;
        String parm = null;
        String value = null;
        String rawValue = null;
        if (this.processor == null) {
            colorHex = null;
            this.realTimeCodeBase = 113;
        }
        boolean hasForceEvenStartsEntry = false;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            int pos = line.indexOf("=");
            if (pos < 0) {
                System.err.println("Invalid entry in RDF [General] section, no equals sign:");
                System.err.println("  " + line);
                continue;
            }
            parm = line.substring(0, pos).trim();
            rawValue = line.substring(pos + 1);
            value = rawValue.trim();
            if (parm.equals("Name")) {
                this.rdfName = value;
            } else if (parm.equals("Identification")) {
                this.rdfIdentification = value;
            } else if (parm.equals("BaseAddr")) {
                this.baseAddress = RDFReader.parseNumber(value);
                if (this.baseAddress > 0) {
                    this.sigAddress = this.baseAddress;
                }
            } else if (parm.equals("EepromSize")) {
                this.eepromSize = RDFReader.parseNumber(value);
                this.usageRange = new AddressRange(0, this.eepromSize - 1);
            } else if (parm.equals("DevCodeOffset")) {
                this.deviceCodeOffset = RDFReader.parseNumber(value);
            } else if (parm.equals("FavKey")) {
                this.favKey = new FavKey();
                this.favKey.parse(value, this);
            } else if (parm.equals("OEMDevice")) {
                this.oemDevice = new OEMDevice();
                this.oemDevice.parse(value, this);
            } else if (parm.equals("OEMControl")) {
                this.oemControl = RDFReader.parseNumber(value);
            } else if (parm.equals("UpgradeBug")) {
                this.upgradeBug = RDFReader.parseNumber(value) != 0;
            } else if (parm.equals("AdvCodeAddr")) {
                this.advancedCodeAddress = new AddressRange(value, this);
                this.check(this.advancedCodeAddress, "AdvCodeAddr");
            } else if (parm.equals("KeyMoveSupport")) {
                this.keyMoveSupport = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("InternalDeviceCode")) {
                this.internalDeviceCode = RDFReader.parseNumber(value);
            } else if (parm.equals("DeviceSelection")) {
                if (value.equals("2")) {
                    this.deviceSelectionMessage = true;
                    this.deviceSelection = true;
                } else {
                    this.deviceSelection = RDFReader.parseFlag(value);
                    this.deviceSelectionMessage = !this.deviceSelection;
                }
            } else if (parm.equalsIgnoreCase("LEDColor")) {
                String temp;
                int paren = value.indexOf("(");
                String string = temp = paren >= 0 ? value.substring(paren).trim() : null;
                if (paren >= 0) {
                    value = value.substring(0, paren).trim();
                }
                StringTokenizer st = new StringTokenizer(value, ", \t");
                ArrayList<Integer> paramList = new ArrayList<Integer>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    int n = 1;
                    try {
                        n = RDFReader.parseNumber(token);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    paramList.add(n);
                }
                if (temp != null) {
                    temp = temp.substring(1, temp.length() - 1);
                    ArrayList<String> strList = new ArrayList<String>();
                    st = new StringTokenizer(temp, ",\t");
                    while (st.hasMoreTokens()) {
                        strList.add(st.nextToken().trim());
                    }
                    this.ledSettings = strList.toArray(new String[0]);
                }
                this.ledParams = paramList.toArray(new Integer[0]);
                this.ledColor = true;
                colorHex = new Hex(colorData);
            } else if (parm.equals("MacroSupport")) {
                this.macroSupport = 1;
                if (!RDFReader.parseFlag(value)) {
                    try {
                        this.macroSupport = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        this.macroSupport = 0;
                    }
                }
            } else if (parm.equals("RealTimeMacroData")) {
                Hex realTimeCodes;
                StringTokenizer st = new StringTokenizer(value, ",");
                this.realTimeMacroKeyData = st.nextToken().trim();
                if (st.hasMoreTokens() && (realTimeCodes = new Hex(st.nextToken())).length() > 1) {
                    this.realTimeCodeBase = realTimeCodes.getData()[0];
                }
            } else if (parm.equalsIgnoreCase("ForceEvenStarts")) {
                String modString;
                this.forceModulus = 2;
                hasForceEvenStartsEntry = true;
                int valLen = value.length();
                if (valLen > 1 && (modString = value.substring(valLen - 1)).matches("\\d")) {
                    this.forceModulus = RDFReader.parseNumber(modString);
                    value = value.substring(0, valLen - 1).trim();
                }
                this.forceEvenStarts = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("MasterPowerSupport")) {
                this.masterPowerSupport = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("PunchThru")) {
                this.punchThru = value.equalsIgnoreCase("none") ? "" : value;
            } else if (parm.equals("UpgradeAddr")) {
                this.upgradeAddress = new AddressRange(value, this);
                this.check(this.upgradeAddress, "UpgradeAddr");
            } else if (parm.equals("DevUpgradeAddr")) {
                this.deviceUpgradeAddress = new AddressRange(value, this);
                this.check(this.deviceUpgradeAddress, "DevUpgradeAddr");
            } else if (parm.equals("TimedMacroAddr")) {
                this.timedMacroAddress = new AddressRange(value, this);
                this.check(this.timedMacroAddress, "TimedMacroAddr");
            } else if (parm.equals("TimedMacroWarning")) {
                this.timedMacroWarning = RDFReader.parseNumber(value) != 0;
            } else if (parm.equals("LearnedAddr")) {
                this.learnedAddress = new AddressRange(value, this);
                this.check(this.learnedAddress, "LearnedAddr");
            } else if (parm.equals("LearnedFormat")) {
                this.learnedFormat = RDFReader.parseNumber(value);
            } else if (parm.equalsIgnoreCase("SegmentTypes")) {
                StringTokenizer st = new StringTokenizer(value, ", ");
                this.segmentTypes = new ArrayList<Integer>();
                while (st.hasMoreTokens()) {
                    this.segmentTypes.add(RDFReader.parseNumber(st.nextToken().trim()));
                }
            } else if (parm.equals("Processor") || parm.equals("Processor+")) {
                processorName = value;
                if (processorName.equals("6805") && processorVersion == null) {
                    processorVersion = "C9";
                }
            } else if (parm.equals("ProcessorVersion")) {
                processorVersion = value;
            } else if (parm.equalsIgnoreCase("RAMAddr")) {
                this.RAMAddress = RDFReader.parseNumber(value);
            } else if ((parm.equals("TimeAddr") || parm.equals("TimeAddr+")) && this.autoClockSet == null) {
                this.autoClockSet = new AutoClockSet();
                this.autoClockSet.parse(value, this);
            } else if (parm.equals("RDFSync")) {
                this.RDFSync = RDFReader.parseNumber(value);
            } else if (parm.equals("PunchThruBase")) {
                this.punchThruBase = RDFReader.parseNumber(value);
            } else if (parm.equals("ScanBase")) {
                this.scanBase = RDFReader.parseNumber(value);
            } else if (parm.equals("SleepStatusBit")) {
                this.sleepStatusBit = new StatusBit();
                this.sleepStatusBit.parse(value, this);
            } else if (parm.equals("VPTStatusBit")) {
                this.vptStatusBit = new StatusBit();
                this.vptStatusBit.parse(value, this);
            } else if (parm.equals("OmitDigitMapByte")) {
                this.omitDigitMapByte = RDFReader.parseFlag(value);
            } else if (parm.equals("ZeroDigitMapByte")) {
                this.zeroDigitMapByte = RDFReader.parseFlag(value);
            } else if (parm.equals("GlobalSpecialFunctions")) {
                this.globalSpecialFunctions = RDFReader.parseFlag(value);
            } else if (parm.equals("ImageMap")) {
                PropertyFile properties = JP1Frame.getProperties();
                File imageDir = properties.getFileProperty("ImagePath");
                if (imageDir == null) {
                    imageDir = new File(properties.getFile().getParentFile(), "Images");
                }
                if (!imageDir.exists()) {
                    JOptionPane.showMessageDialog(null, "Images folder not found!", "Error", 0);
                    RMFileChooser chooser = new RMFileChooser(imageDir.getParentFile());
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle("Choose the directory containing the remote images and maps");
                    if (chooser.showOpenDialog(null) != 0) {
                        System.exit(-1);
                    }
                    imageDir = chooser.getSelectedFile();
                    properties.setProperty("ImagePath", imageDir);
                }
                String mapList = value;
                StringTokenizer mapTokenizer = new StringTokenizer(mapList, ",");
                int mapCount = mapTokenizer.countTokens();
                this.imageMaps = new ImageMap[mapCount];
                this.imageMapNames = new String[mapCount];
                for (int m = 0; m < mapCount; ++m) {
                    this.imageMapNames[m] = mapTokenizer.nextToken();
                    this.imageMaps[m] = new ImageMap(new File(imageDir, this.imageMapNames[m]));
                }
                this.mapIndex = this.nameIndex >= mapCount ? mapCount - 1 : this.nameIndex;
            } else if (parm.equals("DefaultRestrictions")) {
                this.defaultRestrictions = this.parseRestrictions(value, null);
            } else if (parm.equals("Shift")) {
                StringTokenizer st = new StringTokenizer(value, "=,");
                this.shiftMask = RDFReader.parseNumber(st.nextToken());
                boolean bl = this.shiftEnabled = this.shiftMask != 0;
                if (st.hasMoreTokens()) {
                    this.shiftLabel = st.nextToken().trim();
                }
            } else if (parm.equals("XShift")) {
                StringTokenizer st = new StringTokenizer(value, "=,");
                this.xShiftMask = RDFReader.parseNumber(st.nextToken());
                boolean bl = this.xShiftEnabled = this.xShiftMask != 0;
                if (st.hasMoreTokens()) {
                    this.xShiftLabel = st.nextToken().trim();
                }
            } else if (parm.equals("AdvCodeFormat")) {
                this.advCodeFormat = AdvancedCode.Format.valueOf(value.toUpperCase());
            } else if (parm.equals("AdvCodeBindFormat")) {
                this.advCodeBindFormat = AdvancedCode.BindFormat.valueOf(value.toUpperCase());
            } else if (parm.equals("EFCDigits")) {
                this.efcDigits = RDFReader.parseNumber(value);
            } else if (parm.equals("DevComb")) {
                this.devCombAddress = new int[7];
                for (int i = 0; i < 7; ++i) {
                    this.devCombAddress[i] = -1;
                }
                List<String> addrs = LineTokenizer.tokenize(value, ",");
                int i = 0;
                for (String addr : addrs) {
                    if (addr != null) {
                        this.devCombAddress[i] = RDFReader.parseNumber(addr);
                    }
                    ++i;
                }
            } else if (parm.equals("ProtocolVectorOffset")) {
                this.protocolVectorOffset = RDFReader.parseNumber(value);
            } else if (parm.equals("ProtocolDataOffset")) {
                this.protocolDataOffset = RDFReader.parseNumber(value);
            } else if (parm.equals("EncDec")) {
                this.encdec = EncrypterDecrypter.createInstance(value);
            } else if (parm.equals("MaxUpgradeLength")) {
                this.maxUpgradeLength = new Integer(RDFReader.parseNumber(value));
            } else if (parm.equals("MaxProtocolLength")) {
                this.maxProtocolLength = new Integer(RDFReader.parseNumber(value));
            } else if (parm.equals("MaxCombinedUpgradeLength")) {
                this.maxCombinedUpgradeLength = new Integer(RDFReader.parseNumber(value));
            } else if (parm.equals("SectionTerminator")) {
                this.sectionTerminator = (short)RDFReader.parseNumber(value);
            } else if (parm.equalsIgnoreCase("2BytePid")) {
                this.twoBytePID = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("16BitSetupCode")) {
                this.twoByteSetupCode = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("LearnedDevBtnSwapped")) {
                this.learnedDevBtnSwapped = RDFReader.parseFlag(value);
            } else if ((parm.equalsIgnoreCase("Labels") || parm.equalsIgnoreCase("Labels+")) && this.labels == null) {
                this.labels = new DeviceLabels();
                this.labels.parse(value, this);
            } else if (parm.equalsIgnoreCase("SoftDev")) {
                this.softDevices = new SoftDevices();
                this.softDevices.parse(value, this);
                if (!this.softDevices.inUse()) {
                    this.softDevices = null;
                }
            } else if (parm.equalsIgnoreCase("SoftHT")) {
                this.softHomeTheater = new SoftHomeTheater();
                this.softHomeTheater.parse(value, this);
                if (!this.softHomeTheater.inUse()) {
                    this.softHomeTheater = null;
                }
            } else if (parm.equalsIgnoreCase("MacroCodingType")) {
                this.macroCodingType = new MacroCodingType();
                this.macroCodingType.parse(value, this);
            } else if (parm.equalsIgnoreCase("StartReadOnlySettings")) {
                this.startReadOnlySettings = RDFReader.parseNumber(value);
            } else if (parm.equalsIgnoreCase("PauseParams")) {
                PauseParameters parms = new PauseParameters();
                parms.parse(value, this);
                this.pauseParameters.put(parms.getUserName(), parms);
            } else if (parm.equalsIgnoreCase("PowerButtons")) {
                StringTokenizer st = new StringTokenizer(value, ", ");
                int len = st.countTokens();
                this.powerButtons = new short[len];
                int i = 0;
                while (st.hasMoreElements()) {
                    this.powerButtons[i++] = (short)RDFReader.parseNumber(st.nextToken());
                }
            } else if (parm.equalsIgnoreCase("WavUpgrade")) {
                this.waveUpgrade = RDFReader.parseFlag(value);
            } else if (parm.equalsIgnoreCase("SetupValidation")) {
                this.setupValidation = SetupValidation.valueOf(value.toUpperCase());
            } else if (parm.equalsIgnoreCase("AdvCodeTypes")) {
                this.parseAdvCodeTypes(value, rdr);
            } else if ((parm.equalsIgnoreCase("ExtenderVersionAddr") || parm.equalsIgnoreCase("ExtenderVersionAddr+")) && this.extenderVersionParm == null) {
                this.extenderVersionParm = new ExtenderVersionParm();
                this.extenderVersionParm.parse(value, this);
                if (!this.extenderVersionParm.displayExtenderVersion()) {
                    this.extenderVersionParm = null;
                }
            } else if (parm.equalsIgnoreCase("RDFVersionAddr")) {
                this.rdfVersionAddress = RDFReader.parseNumber(value);
            } else if (parm.equalsIgnoreCase("ActivityMapIndex")) {
                this.activityMapIndex = RDFReader.parseNumber(value);
            } else if (parm.equalsIgnoreCase("Notes")) {
                this.notes = this.parseNotes(rdr, rawValue);
            } else if (parm.equalsIgnoreCase("BlockFormat")) {
                boolean bf = RDFReader.parseFlag(value);
                this.blockFormat = bf ? BlockFormat.YES : BlockFormat.NO;
            } else if (parm.equalsIgnoreCase("FirmwareSignature")) {
                this.firmwareSignature = value;
            }
            if (this.softDevices == null) {
                this.softHomeTheater = null;
            }
            if (!this.macroCodingType.hasTimedMacros()) continue;
            this.timedMacroAddress = null;
        }
        this.processor = ProcessorManager.getProcessor(processorName, processorVersion);
        if (this.processor == null) {
            this.processor = ProcessorManager.getProcessor("S3C80");
        }
        if (RMIRSetup.disableActivitiesItem != null) {
            RMIRSetup.disableActivitiesItem.setVisible(this.segmentTypes != null && !this.hasMasterPowerSupport() && this.segmentTypes.contains(205));
        }
        if (this.segmentTypes != null) {
            if (this.macroSupport < 2) {
                boolean hasMacroSegments = this.segmentTypes.contains(1) || this.segmentTypes.contains(2) || this.segmentTypes.contains(3) || this.isSSD();
                this.macroSupport = hasMacroSegments ? 1 : 0;
            }
            this.keyMoveSupport = this.segmentTypes.contains(7) || this.segmentTypes.contains(8);
            this.globalPunchthruSupport = this.segmentTypes.contains(25);
            this.twoBytePID = true;
            this.advCodeBindFormat = AdvancedCode.BindFormat.LONG;
            this.efcDigits = 5;
        }
        if (!processorName.equals("S3C80") || this.RAMAddress != 65280) {
            this.RAMAddress = this.processor.getRAMAddress();
        }
        if (this.processor.getEquivalentName().equals("MAXQ610") && !hasForceEvenStartsEntry) {
            this.forceEvenStarts = true;
            this.forceModulus = 2;
        } else if (this.processor.getEquivalentName().equals("TI2541") && !hasForceEvenStartsEntry) {
            this.forceEvenStarts = true;
            int n = this.forceModulus = processorName.equals("GP541") || processorName.equals("GP565") ? 2 : 4;
        }
        if (this.imageMaps.length == 0) {
            this.imageMaps = new ImageMap[]{new ImageMap(null)};
            this.imageMapNames = new String[0];
            this.mapIndex = 0;
        }
        return line;
    }

    public void resetImageMaps(File path) throws Exception {
        for (int m = 0; m < this.imageMaps.length; ++m) {
            ImageMap imageMap = this.imageMaps[m] = m < this.imageMapNames.length ? new ImageMap(new File(path, this.imageMapNames[m])) : null;
            if (this.imageMaps[m] == null) continue;
            this.imageMaps[m].parse(this);
        }
    }

    public AutoClockSet getAutoClockSet() {
        return this.autoClockSet;
    }

    public int[] getDevCombAddresses() {
        this.load();
        return this.devCombAddress;
    }

    private int parseRestrictions(String str, List<String> groupNames) {
        int rc = 0;
        if (restrictionTable == null) {
            restrictionTable = new Hashtable(46);
            restrictionTable.put("MoveBind", new Integer(Button.MOVE_BIND));
            restrictionTable.put("ShiftMoveBind", new Integer(Button.SHIFT_MOVE_BIND));
            restrictionTable.put("XShiftMoveBind", new Integer(Button.XSHIFT_MOVE_BIND));
            restrictionTable.put("AllMoveBind", new Integer(Button.ALL_MOVE_BIND));
            restrictionTable.put("MacroBind", new Integer(Button.MACRO_BIND));
            restrictionTable.put("ShiftMacroBind", new Integer(Button.SHIFT_MACRO_BIND));
            restrictionTable.put("XShiftMacroBind", new Integer(Button.XSHIFT_MACRO_BIND));
            restrictionTable.put("AllMacroBind", new Integer(Button.ALL_MACRO_BIND));
            restrictionTable.put("LearnBind", new Integer(Button.LEARN_BIND));
            restrictionTable.put("ShiftLearnBind", new Integer(Button.SHIFT_LEARN_BIND));
            restrictionTable.put("XShiftLearnBind", new Integer(Button.XSHIFT_LEARN_BIND));
            restrictionTable.put("AllLearnBind", new Integer(Button.ALL_LEARN_BIND));
            restrictionTable.put("MacroData", new Integer(Button.MACRO_DATA));
            restrictionTable.put("ShiftMacroData", new Integer(Button.SHIFT_MACRO_DATA));
            restrictionTable.put("XShiftMacroData", new Integer(Button.XSHIFT_MACRO_DATA));
            restrictionTable.put("AllMacroData", new Integer(Button.ALL_MACRO_DATA));
            restrictionTable.put("TMacroData", new Integer(Button.TMACRO_DATA));
            restrictionTable.put("ShiftTMacroData", new Integer(Button.SHIFT_TMACRO_DATA));
            restrictionTable.put("XShiftMacroData", new Integer(Button.XSHIFT_TMACRO_DATA));
            restrictionTable.put("AllTMacroData", new Integer(Button.ALL_TMACRO_DATA));
            restrictionTable.put("FavData", new Integer(Button.FAV_DATA));
            restrictionTable.put("ShiftFavData", new Integer(Button.SHIFT_FAV_DATA));
            restrictionTable.put("XShiftFavData", new Integer(Button.XSHIFT_FAV_DATA));
            restrictionTable.put("AllFavData", new Integer(Button.ALL_FAV_DATA));
            restrictionTable.put("PwrMacroData", new Integer(Button.PWRMACRO_DATA));
            restrictionTable.put("ShiftPwrMacroData", new Integer(Button.SHIFT_PWRMACRO_DATA));
            restrictionTable.put("XShiftPwrMacroData", new Integer(Button.XSHIFT_PWRMACRO_DATA));
            restrictionTable.put("AllPwrMacroData", new Integer(Button.ALL_PWRMACRO_DATA));
            restrictionTable.put("ControlledMacroBind", new Integer(Button.CONTROLLED_MACRO_BIND));
            restrictionTable.put("Bind", new Integer(Button.BIND));
            restrictionTable.put("ShiftBind", new Integer(Button.SHIFT_BIND));
            restrictionTable.put("XShiftBind", new Integer(Button.XSHIFT_BIND));
            restrictionTable.put("Data", new Integer(Button.DATA));
            restrictionTable.put("ShiftData", new Integer(Button.SHIFT_DATA));
            restrictionTable.put("XShiftData", new Integer(Button.XSHIFT_DATA));
            restrictionTable.put("AllBind", new Integer(Button.ALL_BIND));
            restrictionTable.put("AllData", new Integer(Button.ALL_DATA));
            restrictionTable.put("Shift", new Integer(Button.SHIFT));
            restrictionTable.put("XShift", new Integer(Button.XSHIFT));
            restrictionTable.put("All", new Integer(Button.ALL));
        }
        StringTokenizer st = new StringTokenizer(str, "+-", true);
        boolean isAdd = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("+")) {
                isAdd = true;
                continue;
            }
            if (token.equals("-")) {
                isAdd = false;
                continue;
            }
            if (isAdd && token.toUpperCase().startsWith("GROUP")) {
                groupNames.add(token.substring(5));
                continue;
            }
            Integer value = restrictionTable.get(token);
            if (value == null) continue;
            if (isAdd) {
                rc |= value.intValue();
                continue;
            }
            rc &= ~value.intValue();
        }
        return rc;
    }

    private String parseSpecialProtocols(RDFReader rdr) throws Exception {
        String line;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            String value;
            StringTokenizer st = new StringTokenizer(line, "=");
            String name = st.nextToken().trim();
            SpecialProtocol sp = SpecialProtocol.create(name, value = st.nextToken().trim(), this);
            if (sp instanceof DSMSpecialProtocol && (sp.getInternalSerial() & 4) == 4) {
                this.flaggedDSM = true;
            }
            this.specialProtocols.add(sp);
        }
        return line;
    }

    private String parseCheckSums(RDFReader rdr) throws Exception {
        String line;
        ArrayList<AddCheckSum> work = new ArrayList<AddCheckSum>();
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            char ch;
            int pos = 0;
            boolean comp = false;
            if ((ch = line.charAt(pos++)) == '~') {
                comp = true;
                ch = line.charAt(pos++);
            }
            line = line.substring(pos);
            StringTokenizer st = new StringTokenizer(line, ":");
            int addr = RDFReader.parseNumber(st.nextToken());
            AddressRange range = new AddressRange();
            range.parse(st.nextToken(), this);
            this.check(range, "CheckSums");
            CheckSum sum = null;
            sum = ch == '+' ? new AddCheckSum(addr, range, comp) : (ch == '*' ? new Xor16CheckSum(addr, range, comp) : new XorCheckSum(addr, range, comp));
            work.add((AddCheckSum)sum);
        }
        this.checkSums = work.toArray(this.checkSums);
        return line;
    }

    public CheckSum[] getCheckSums() {
        return this.checkSums;
    }

    private String parseSettings(RDFReader rdr) throws Exception {
        String line;
        ArrayList<Setting> work = new ArrayList<Setting>();
        work.addAll(Arrays.asList(this.settings));
        int index = this.settingBytes.size();
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, "=");
            String title = st.nextToken();
            String value = st.nextToken().trim();
            int pos = value.indexOf(" ");
            String init = null;
            int segmentType = -1;
            if (pos > 0 && !(init = value.substring(0, pos)).contains(".") && !init.startsWith("(")) {
                segmentType = RDFReader.parseNumber(init);
                value = value.substring(pos).trim();
            }
            int byteAddress = 0;
            int bitNumber = 0;
            int numberOfBits = 0;
            int initialValue = 0;
            boolean inverted = false;
            st = new StringTokenizer(value, ".= \t");
            if (!this.isSSD()) {
                byteAddress = RDFReader.parseNumber(st.nextToken());
                bitNumber = RDFReader.parseNumber(st.nextToken());
                numberOfBits = RDFReader.parseNumber(st.nextToken());
                initialValue = RDFReader.parseNumber(st.nextToken());
                inverted = RDFReader.parseNumber(st.nextToken()) != 0;
            }
            ArrayList<String> options = null;
            String sectionName = null;
            if (st.hasMoreTokens()) {
                String token = st.nextToken(",;)").trim();
                if (token.charAt(0) == '(') {
                    options = new ArrayList<String>();
                    options.add(token.substring(1));
                    while (st.hasMoreTokens()) {
                        options.add(st.nextToken());
                    }
                } else {
                    sectionName = token.trim();
                }
            }
            Object[] optionsList = null;
            if (options != null) {
                optionsList = options.toArray(new String[0]);
            }
            if (this.segmentTypes != null && segmentType >= 0) {
                byteAddress += 256 * (segmentType + 1);
            }
            Setting setting = new Setting(title, byteAddress, bitNumber, numberOfBits, initialValue, inverted, optionsList, sectionName);
            work.add(setting);
            if (!this.settingAddresses.containsKey(byteAddress)) {
                this.settingBytes.add(byteAddress);
                this.settingAddresses.put(byteAddress, index++);
                int[] masks = setting.getMasks();
                for (int i = 0; i < masks.length; ++i) {
                    this.settingMasks.put(byteAddress + i, masks[i]);
                }
                continue;
            }
            if (setting.getMasks().length != 1) continue;
            int mask = this.settingMasks.get(byteAddress);
            this.settingMasks.put(byteAddress, mask &= setting.getMasks()[0]);
        }
        this.settings = work.toArray(this.settings);
        return line;
    }

    public Setting[] getSettings() {
        return this.settings;
    }

    public Setting getSetting(String title) {
        for (Setting setting : this.settings) {
            if (!setting.getTitle().trim().equals(title.trim())) continue;
            return setting;
        }
        return null;
    }

    public Object[] getSection(String name) {
        if (name.equals("DeviceButtons")) {
            return this.getDeviceButtons();
        }
        if (name.equals("DeviceTypes")) {
            return this.getDeviceTypes();
        }
        return null;
    }

    private String parseDeviceButtons(RDFReader rdr) throws Exception {
        String line;
        ArrayList<DeviceButton> work = new ArrayList<DeviceButton>();
        int index = 0;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            ArrayList<Integer> ptDefList;
            boolean rf;
            int typeAddr;
            int lowAddr;
            int hiAddr;
            String name;
            int defaultSetupCode;
            block13: {
                StringTokenizer st;
                block12: {
                    st = new StringTokenizer(line, ",");
                    defaultSetupCode = 0;
                    line = st.nextToken();
                    if (st.hasMoreTokens()) {
                        defaultSetupCode = RDFReader.parseNumber(st.nextToken().trim());
                    }
                    st = new StringTokenizer(line, "= \t");
                    name = st.nextToken();
                    hiAddr = 0;
                    lowAddr = 0;
                    typeAddr = 0;
                    rf = false;
                    ptDefList = new ArrayList<Integer>();
                    if (this.segmentTypes != null) break block12;
                    hiAddr = RDFReader.parseNumber(st.nextToken());
                    lowAddr = RDFReader.parseNumber(st.nextToken());
                    if (!st.hasMoreTokens()) break block13;
                    typeAddr = RDFReader.parseNumber(st.nextToken());
                    break block13;
                }
                String token = st.nextToken();
                int starNdx = token.indexOf(42);
                if (starNdx >= 0) {
                    rf = true;
                    token = token.substring(0, starNdx);
                }
                index = RDFReader.parseNumber(token);
                while (st.hasMoreTokens()) {
                    try {
                        token = st.nextToken();
                        if (!token.startsWith("$")) break;
                        int val = RDFReader.parseNumber(token);
                        ptDefList.add(val);
                    }
                    catch (Exception ex) {
                        // empty catch block
                        break;
                    }
                }
            }
            DeviceButton db = new DeviceButton(name, hiAddr, lowAddr, typeAddr, defaultSetupCode, index, this.deviceCodeOffset);
            db.setRf(rf);
            if (ptDefList.size() > 0) {
                short[] ptDefaults = new short[ptDefList.size()];
                for (int i = 0; i < ptDefList.size(); ++i) {
                    ptDefaults[i] = (short)((Integer)ptDefList.get(i) & 0xFF);
                }
                db.setPTdefaults(ptDefaults);
            }
            if (this.usesEZRC()) {
                db.setButtonGeneralFunctionMap(new HashMap<Button, GeneralFunction>());
            }
            if (this.isSSD()) {
                db.icon = new GeneralFunction.RMIcon(5);
                db.setSerial(index - 80);
            }
            work.add(db);
            ++index;
        }
        this.deviceButtons = work.toArray(this.deviceButtons);
        if (this.ledParams != null) {
            for (int i = 0; i < this.deviceButtons.length && i < this.ledParams.length; ++i) {
                this.deviceButtons[i].setColorIndex(Math.abs(this.ledParams[i]));
                this.deviceButtons[i].setColorEditable(this.ledParams[i] < 0);
            }
        }
        return line;
    }

    private String parseDeviceAbbreviations(RDFReader rdr) throws Exception {
        String line;
        while ((line = rdr.readLine()) != null && line.length() != 0 && line.charAt(0) != '[') {
            StringTokenizer st = new StringTokenizer(line, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int equal = token.indexOf(61);
                if (equal == -1) continue;
                String devName = token.substring(0, equal);
                String abbreviation = token.substring(equal + 1);
                DeviceType devType = this.getDeviceType(devName);
                if (devType == null) continue;
                devType.setAbbreviation(abbreviation);
            }
        }
        return line;
    }

    private String parseDigitMaps(RDFReader rdr) throws Exception {
        String line;
        ArrayList<Integer> work = new ArrayList<Integer>();
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, ",; \t");
            while (st.hasMoreTokens()) {
                work.add(new Integer(RDFReader.parseNumber(st.nextToken())));
            }
        }
        this.digitMaps = new short[work.size()];
        int i = 0;
        for (Integer v : work) {
            this.digitMaps[i++] = v.shortValue();
        }
        return line;
    }

    private String parseDeviceTypes(RDFReader rdr) throws Exception {
        String line;
        int type = 0;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, "=, \t");
            String name = st.nextToken();
            int map = 0;
            if (st.hasMoreTokens()) {
                map = RDFReader.parseNumber(st.nextToken());
                if (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    try {
                        type = RDFReader.parseNumber(token);
                    }
                    catch (Exception e) {
                        type = token.charAt(0);
                    }
                }
            }
            DeviceType devType = new DeviceType(name, map, type);
            this.deviceTypes.put(name, devType);
            this.devicesByType.put(type, devType);
            this.deviceTypeList.add(devType);
            type += 257;
        }
        for (SpecialProtocol sp : this.specialProtocols) {
            sp.checkSpecialProtocol(this);
        }
        return line;
    }

    private String parseDeviceTypeAliases(RDFReader rdr) throws Exception {
        String line;
        ArrayList<String> v = new ArrayList<String>();
        DeviceType vcrType = null;
        boolean hasPVRalias = false;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, "=,");
            String typeName = st.nextToken().trim();
            DeviceType type = this.getDeviceType(typeName);
            while (st.hasMoreTokens()) {
                String aliasName = st.nextToken().trim();
                if (aliasName.equals("VCR")) {
                    vcrType = type;
                }
                if (aliasName.equals("PVR")) {
                    hasPVRalias = true;
                }
                this.deviceTypeAliases.put(aliasName, type);
                v.add(aliasName);
            }
        }
        if (!hasPVRalias && vcrType != null) {
            v.add("PVR");
            this.deviceTypeAliases.put("PVR", vcrType);
        }
        this.deviceTypeAliasNames = new String[0];
        this.deviceTypeAliasNames = v.toArray(this.deviceTypeAliasNames);
        return line;
    }

    public String[] getDeviceTypeAliasNames() {
        this.load();
        return this.deviceTypeAliasNames;
    }

    private String parseDeviceTypeImageMaps(RDFReader rdr) throws Exception {
        String line;
        DeviceType type = null;
        ArrayList outer = new ArrayList();
        ArrayList<ImageMap> inner = null;
        boolean nested = false;
        PropertyFile properties = JP1Frame.getProperties();
        File imageDir = properties.getFileProperty("ImagePath");
        if (imageDir == null) {
            imageDir = new File(properties.getFile().getParentFile(), "Images");
        }
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, "=, \t");
            String typeName = st.nextToken();
            type = this.getDeviceType(typeName);
            while (st.hasMoreTokens()) {
                int closeParen;
                String token = st.nextToken();
                if (token.charAt(0) == '(') {
                    nested = true;
                    token = token.substring(1);
                    inner = new ArrayList();
                    outer.add(inner);
                }
                if (!nested) {
                    inner = new ArrayList<ImageMap>();
                    outer.add(inner);
                }
                if ((closeParen = token.indexOf(41)) != -1) {
                    nested = false;
                    token = token.substring(0, closeParen);
                }
                inner.add(new ImageMap(new File(imageDir, token)));
            }
            ImageMap[][] outerb = new ImageMap[outer.size()][];
            int o = 0;
            for (List list : outer) {
                ImageMap[] innerb = new ImageMap[list.size()];
                outerb[o++] = innerb;
                int i = 0;
                for (ImageMap map : list) {
                    innerb[i++] = map;
                }
                list.clear();
            }
            this.hasDeviceTypeImageMaps = !outer.isEmpty();
            outer.clear();
            type.setImageMaps(outerb);
        }
        return line;
    }

    private String parseButtons(RDFReader rdr) throws Exception {
        String line;
        short keycode = 1;
        int restrictions = this.defaultRestrictions;
        ArrayList<String> groupNames = new ArrayList<String>();
        while ((line = rdr.readLine()) != null && line.length() != 0 && line.charAt(0) != '[') {
            StringTokenizer st = new StringTokenizer(line, ",");
            while (st.hasMoreTokens()) {
                int end;
                char ch;
                int doubleColon;
                String token = st.nextToken().trim();
                int equal = token.indexOf(61);
                if (equal != -1) {
                    groupNames = new ArrayList();
                    String keycodeStr = token.substring(equal + 1);
                    token = token.substring(0, equal);
                    int pos = keycodeStr.indexOf(58);
                    if (pos != -1) {
                        String restrictStr = keycodeStr.substring(pos + 1);
                        restrictions = this.parseRestrictions(restrictStr, groupNames);
                        keycodeStr = keycodeStr.substring(0, pos);
                    } else {
                        restrictions = this.defaultRestrictions;
                    }
                    keycode = (short)RDFReader.parseNumber(keycodeStr.trim());
                }
                if ((doubleColon = token.indexOf("::")) != -1) {
                    token = token.substring(doubleColon + 2);
                }
                int colon = token.indexOf(58);
                String name = token;
                if (colon != -1) {
                    name = token.substring(colon + 1);
                    ch = (token = token.substring(0, colon)).charAt(0);
                    if (ch == '\'' || ch == '\"') {
                        end = token.lastIndexOf(ch);
                        token = token.substring(1, end);
                    }
                }
                if ((ch = name.charAt(0)) == '\'' || ch == '\"') {
                    end = name.lastIndexOf(ch);
                    name = name.substring(1, end);
                }
                Button b = new Button(token, name, keycode, this);
                b.setRestrictions(b.getRestrictions() | restrictions);
                if (groupNames.size() > 0) {
                    if (this.buttonGroups == null) {
                        this.buttonGroups = new LinkedHashMap();
                    }
                    for (String groupName : groupNames) {
                        List<Button> group = this.buttonGroups.get(groupName);
                        if (group == null) {
                            group = new ArrayList<Button>();
                            this.buttonGroups.put(groupName, group);
                        }
                        group.add(b);
                    }
                    if (this.hasActivityAlgorithm()) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(null);
                        this.buttonGroups.put("Activity", list);
                    }
                }
                keycode = (short)(keycode + 1);
                this.addButton(b);
            }
        }
        if (this.buttonGroups != null) {
            List<Button> list;
            int i = 0;
            ArrayList<Button[]> groupList = new ArrayList<Button[]>();
            while ((list = this.buttonGroups.get("" + i++)) != null) {
                groupList.add(list.toArray(new Button[0]));
            }
            this.activityButtonGroups = new Button[groupList.size()][];
            for (i = 0; i < groupList.size(); ++i) {
                this.activityButtonGroups[i] = (Button[])groupList.get(i);
            }
            ArrayList<KeyButtonGroup> keyGroups = new ArrayList<KeyButtonGroup>();
            for (String name : this.buttonGroups.keySet()) {
                if (!name.startsWith("key")) continue;
                KeyButtonGroup kbg = new KeyButtonGroup(name.substring(3), this.buttonGroups.get(name));
                keyGroups.add(kbg);
            }
            this.keyButtonGroups = keyGroups.toArray(new KeyButtonGroup[0]);
            if (this.buttonGroups.get("System") != null) {
                this.systemButtons = new ArrayList<Button>();
                for (Button b : this.buttons) {
                    if (!this.buttonGroups.get("System").contains(b)) continue;
                    this.systemButtons.add(b);
                }
            }
        }
        if (this.isSSD() && this.favKey != null) {
            this.favKey.setProfiles(new ArrayList<Activity>());
        }
        return line;
    }

    public Button getButton(int keyCode) {
        if (keyCode == 0) {
            return Button.noButton;
        }
        this.load();
        return this.buttonsByKeyCode.get(new Integer(keyCode));
    }

    public Button getBaseButton(int keyCode) {
        return this.getButtonSplit((int)keyCode).base;
    }

    public ButtonSplit getButtonSplit(int keyCode) {
        Button btn = this.getButton(keyCode);
        if (btn != null && btn != Button.noButton) {
            return new ButtonSplit(btn, 0);
        }
        int baseCode = keyCode & 0x3F;
        if (baseCode != 0) {
            btn = this.getButton(baseCode);
            if (btn != null && this.shiftEnabled && (baseCode | this.shiftMask) == keyCode) {
                return new ButtonSplit(btn, 1);
            }
            if (btn != null && this.xShiftEnabled && (baseCode | this.xShiftMask) == keyCode) {
                return new ButtonSplit(btn, 2);
            }
        }
        if ((baseCode = keyCode & ~this.shiftMask) != 0 && (btn = this.getButton(baseCode)) != null && this.shiftEnabled && (baseCode | this.shiftMask) == keyCode) {
            return new ButtonSplit(btn, 1);
        }
        baseCode = keyCode & ~this.xShiftMask;
        if (baseCode != 0 && (btn = this.getButton(baseCode)) != null && this.xShiftEnabled && (baseCode | this.xShiftMask) == keyCode) {
            return new ButtonSplit(btn, 2);
        }
        return new ButtonSplit(null, 0);
    }

    public String getButtonName(int keyCode) {
        DeviceButton db;
        if (this.usesEZRC() && (db = this.getDeviceButton(keyCode)) != null) {
            return db.getName();
        }
        ButtonSplit split = this.getButtonSplit(keyCode);
        Button b = split.base;
        if (b != null) {
            switch (split.state) {
                case 0: {
                    return b.getName();
                }
                case 1: {
                    return b.getShiftedName();
                }
                case 2: {
                    return b.getXShiftedName();
                }
            }
        }
        if (b == null) {
            Button baseButton;
            String name;
            if (!prelimLoad) {
                System.err.println("ERROR: Unknown keycode $" + Integer.toHexString(keyCode & 0xFF) + ", Creating button!");
            }
            if ((b = new Button(name = "button" + Integer.toHexString(keyCode & 0xFF).toUpperCase(), name, (short)keyCode, this)).getIsShifted()) {
                Button baseButton2 = this.getButton(keyCode & 0x3F);
                if (baseButton2 != null) {
                    b.setBaseButton(baseButton2);
                    baseButton2.setShiftedButton(b);
                }
            } else if (b.getIsXShifted() && (baseButton = this.getButton(keyCode & 0x3F)) != null) {
                b.setBaseButton(baseButton);
                baseButton.setXShiftedButton(b);
            }
            this.addButton(b);
        }
        return b.getName();
    }

    public Button getButton(String name) {
        this.load();
        return this.buttonsByName.get(name.toLowerCase());
    }

    public Button getButtonByStandardName(String name) {
        this.load();
        return this.buttonsByStandardName.get(name.toLowerCase());
    }

    public List<Button> getSystemButtons() {
        return this.systemButtons;
    }

    public void addButton(Button b) {
        short keycode = b.getKeyCode();
        int unshiftedCode = keycode & 0x3F;
        if (b.getIsShifted()) {
            Button c = this.getButton(unshiftedCode);
            if (c != null) {
                c.setShiftedButton(b);
                b.setBaseButton(c);
                if (b.getName() == null) {
                    String name = this.shiftLabel + '-' + c.getName();
                    b.setName(name);
                    b.setStandardName(name);
                }
            }
        } else if (b.getIsXShifted()) {
            Button c = this.getButton(unshiftedCode);
            if (c != null) {
                c.setXShiftedButton(b);
                b.setBaseButton(c);
                if (b.getName() == null) {
                    String name = this.xShiftLabel + '-' + c.getName();
                    b.setName(name);
                    b.setStandardName(name);
                }
            }
        } else {
            int shiftedCode = keycode + this.shiftMask;
            Button c = this.getButton(shiftedCode);
            if (c != null) {
                c.setBaseButton(b);
                b.setShiftedButton(c);
            }
            if (this.xShiftEnabled && (c = this.getButton(shiftedCode = keycode + this.xShiftMask)) != null) {
                c.setBaseButton(b);
                b.setXShiftedButton(c);
            }
        }
        if (b.getName() == null) {
            String name = "unknown" + Integer.toHexString(keycode);
            b.setName(name);
            b.setStandardName(name);
        }
        this.buttons.add(b);
        this.buttonsByName.put(b.getName().toLowerCase(), b);
        this.buttonsByStandardName.put(b.getStandardName().toLowerCase(), b);
        this.buttonsByKeyCode.put(new Integer(keycode), b);
    }

    private String parseMultiMacros(RDFReader rdr) throws Exception {
        String line;
        if (this.sequenceNumberMask == 0) {
            this.sequenceNumberMask = 112;
        }
        if (this.maxMultiMacros == 0) {
            this.maxMultiMacros = this.advCodeBindFormat == AdvancedCode.BindFormat.NORMAL ? 3 : 5;
        }
        this.multiMacroSupport = true;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            MultiMacro multiMacro = new MultiMacro();
            multiMacro.parse(line, this);
        }
        return line;
    }

    public List<Button> getRdfRealTimeMacroButtons() {
        return this.rdfRealTimeMacroButtons;
    }

    public Button findByStandardName(Button b) {
        this.load();
        return this.buttonsByStandardName.get(b.getStandardName().toLowerCase());
    }

    private String parseButtonMaps(RDFReader rdr) throws Exception {
        String line;
        ArrayList<ButtonMap> work = new ArrayList<ButtonMap>();
        int name = -1;
        ArrayList outer = new ArrayList();
        ArrayList<Integer> inner = null;
        boolean nested = false;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st = new StringTokenizer(line, "=, \t");
            if (line.indexOf(61) != -1) {
                if (name != -1) {
                    short[][] outerb = new short[outer.size()][];
                    int o = 0;
                    for (List list : outer) {
                        short[] innerb = new short[list.size()];
                        outerb[o++] = innerb;
                        int i = 0;
                        for (Integer v : list) {
                            innerb[i++] = v.shortValue();
                        }
                        list.clear();
                    }
                    outer.clear();
                    work.add(new ButtonMap(name, outerb));
                }
                name = RDFReader.parseNumber(st.nextToken());
            }
            while (st.hasMoreTokens()) {
                int closeParen;
                String token = st.nextToken();
                if (token.charAt(0) == '(') {
                    nested = true;
                    token = token.substring(1);
                    inner = new ArrayList();
                    outer.add(inner);
                }
                if (!nested) {
                    inner = new ArrayList<Integer>();
                    outer.add(inner);
                }
                if ((closeParen = token.indexOf(41)) != -1) {
                    nested = false;
                    token = token.substring(0, closeParen);
                }
                if (token.isEmpty()) continue;
                inner.add(new Integer(RDFReader.parseNumber(token)));
            }
        }
        short[][] outerb = new short[outer.size()][];
        int o = 0;
        for (List list : outer) {
            short[] sArray = new short[list.size()];
            outerb[o++] = sArray;
            int i = 0;
            for (Integer v : list) {
                sArray[i++] = v.shortValue();
            }
            list.clear();
        }
        outer.clear();
        work.add(new ButtonMap(name, outerb));
        this.buttonMaps = work.toArray(this.buttonMaps);
        return line;
    }

    private String parseNotes(RDFReader rdr, String line) throws Exception {
        line = line.replaceAll("\\s+$", "");
        boolean more = line.endsWith("\\");
        StringBuilder sb = new StringBuilder();
        while (more) {
            sb.append(line.substring(0, line.length() - 1));
            line = rdr.readLine();
            if (line == null || (line = line.trim()).length() == 0) break;
            more = line.endsWith("\\");
        }
        sb.append(line);
        return sb.toString().replaceAll("\\\\n", "\n");
    }

    private String parseProtocols(RDFReader rdr) throws Exception {
        String line;
        while ((line = rdr.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.charAt(0) == '[') break;
            StringTokenizer st = new StringTokenizer(line, ",");
            while (st.hasMoreTokens()) {
                List<String> v;
                String token = st.nextToken().trim();
                ProtocolManager pm = ProtocolManager.getProtocolManager();
                String ref = pm.getOldRefMap().get(token);
                if (ref != null) {
                    token = ref;
                }
                ProtocolManager.QualifiedID qid = new ProtocolManager.QualifiedID(token);
                String variantName = qid.variantName;
                Hex pid = qid.pid;
                int pidValue = pid.get(0);
                if (pidValue >= 3000 && pidValue <= 3049) {
                    this.hasRfProtocol = true;
                }
                if ((v = this.protocolVariantNames.get(pid)) == null) {
                    v = new ArrayList<String>();
                    this.protocolVariantNames.put(pid, v);
                }
                v.add(variantName);
            }
        }
        return line;
    }

    private String parseExtender(RDFReader rdr) throws Exception {
        String line;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            StringTokenizer st;
            String name;
            if (this.oemSignatures == null) {
                this.oemSignatures = new ArrayList<String>();
            }
            if (!(name = (st = new StringTokenizer(line, "=, \t")).nextToken().trim()).equalsIgnoreCase("OEMSignature")) continue;
            while (st.hasMoreTokens()) {
                this.oemSignatures.add(st.nextToken());
            }
        }
        return line;
    }

    public int getHeight() {
        this.load();
        return this.height;
    }

    public int getWidth() {
        this.load();
        return this.width;
    }

    public boolean supportsVariant(Hex pid, String variantName) {
        this.load();
        List<String> v = this.protocolVariantNames.get(pid);
        if (v == null || v.isEmpty()) {
            return false;
        }
        return v.contains(variantName);
    }

    public List<String> getSupportedVariantNames(Hex pid) {
        this.load();
        return this.protocolVariantNames.get(pid);
    }

    public void setProtocols(List<Protocol> protocols) {
        this.load();
        this.protocols = protocols;
    }

    public List<Protocol> getProtocols() {
        this.load();
        return this.protocols;
    }

    private String parseSetupCodes(RDFReader rdr) throws IOException {
        String line = null;
        HashMap<Integer, Integer> map = null;
        while ((line = rdr.readLine()) != null && line.length() != 0) {
            String token;
            StringTokenizer st;
            int pos = line.indexOf(61);
            int devTypeIndex = 0;
            if (pos != -1) {
                st = new StringTokenizer(line, "=");
                token = st.nextToken().trim();
                try {
                    devTypeIndex = Integer.parseInt(token);
                }
                catch (Exception e) {
                    devTypeIndex = token.charAt(0);
                }
                map = this.setupCodes.get(devTypeIndex);
                if (map == null) {
                    map = new HashMap();
                    this.setupCodes.put(devTypeIndex, map);
                }
                line = st.nextToken().trim();
            }
            st = new StringTokenizer(line, " ,");
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                int rf = token.indexOf(42);
                if (rf >= 0) {
                    token = token.substring(0, rf);
                }
                Integer code = new Integer(token);
                code = code + this.deviceCodeOffset;
                this.maxBuiltInCode = Math.max(code, this.maxBuiltInCode);
                if (rf < 0) {
                    map.put(code, code);
                    continue;
                }
                if (this.rfSetupCodes == null) {
                    this.rfSetupCodes = new HashMap();
                }
                if (this.rfSetupCodes.get(devTypeIndex) == null) {
                    this.rfSetupCodes.put(devTypeIndex, new HashMap());
                }
                this.rfSetupCodes.get(devTypeIndex).put(code, code);
            }
        }
        return line;
    }

    public HashMap<Integer, HashMap<Integer, Integer>> getSetupCodes() {
        return this.setupCodes;
    }

    public HashMap<Integer, HashMap<Integer, Integer>> getRfSetupCodes() {
        return this.rfSetupCodes;
    }

    public HashMap<Integer, HashMap<Integer, Integer>> getExtractSetupCodes() {
        return this.extractSetupCodes;
    }

    public String getExtractSignature() {
        return this.extractSignature;
    }

    public void setExtractSetupCodes(HashMap<Integer, HashMap<Integer, Integer>> extractSetupCodes) {
        this.extractSetupCodes = extractSetupCodes;
    }

    public DeviceType[] getExtractDeviceTypes() {
        return this.extractDeviceTypes;
    }

    public boolean hasSetupCode(int deviceTypeIndex, int setupCode) {
        if (this.setupCodes.size() == 0 && !this.segmentTypes.contains(27)) {
            return true;
        }
        HashMap<Integer, Integer> map = this.setupCodes.get(deviceTypeIndex);
        if (map == null) {
            return false;
        }
        return map.containsKey(setupCode);
    }

    public boolean hasSetupCode(DeviceType deviceType, int setupCode) {
        return this.hasSetupCode(deviceType.getNumber(), setupCode);
    }

    public boolean hasRfSetupCode(int deviceTypeIndex, int setupCode) {
        if (this.rfSetupCodes == null) {
            return false;
        }
        HashMap<Integer, Integer> map = this.rfSetupCodes.get(deviceTypeIndex);
        if (map == null) {
            return false;
        }
        return map.containsKey(setupCode);
    }

    public boolean hasRfSetupCode(DeviceType deviceType, int setupCode) {
        return this.hasRfSetupCode(deviceType.getNumber(), setupCode);
    }

    public EncrypterDecrypter getEncrypterDecrypter() {
        this.load();
        return this.encdec;
    }

    public KeyMove createKeyMoveKey(int keyCode, int deviceIndex, int deviceType, int setupCode, int movedKeyCode, String notes) {
        KeyMoveKey keyMove = null;
        keyMove = new KeyMoveKey(keyCode, deviceIndex, deviceType, setupCode, movedKeyCode, notes);
        return keyMove;
    }

    public KeyMove createKeyMove(int keyCode, int deviceIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        KeyMove keyMove = null;
        keyMove = this.advCodeFormat == AdvancedCode.Format.HEX ? (this.advCodeBindFormat == AdvancedCode.BindFormat.LONG && cmd.length() == 1 ? new KeyMoveLong(keyCode, deviceIndex, deviceType, setupCode, cmd, notes) : new KeyMove(keyCode, deviceIndex, deviceType, setupCode, cmd, notes)) : (this.efcDigits == 3 && cmd.length() == 1 ? new KeyMoveEFC(keyCode, deviceIndex, deviceType, setupCode, EFC.parseHex(cmd), notes) : (cmd.length() < 3 ? new KeyMoveEFC5(keyCode, deviceIndex, deviceType, setupCode, EFC5.parseHex(cmd), notes) : null));
        if (keyMove != null) {
            keyMove.setMemoryUsage(keyMove.getSize(this));
        }
        return keyMove;
    }

    public KeyMove createKeyMove(int keyCode, int deviceIndex, int deviceType, int setupCode, int efc, String notes) {
        KeyMove keyMove = null;
        keyMove = this.advCodeFormat == AdvancedCode.Format.HEX ? (this.efcDigits == 3 ? new KeyMove(keyCode, deviceIndex, deviceType, setupCode, EFC.toHex(efc), notes) : new KeyMove(keyCode, deviceIndex, deviceType, setupCode, EFC5.toHex(efc), notes)) : (this.efcDigits == 3 ? new KeyMoveEFC(keyCode, deviceIndex, deviceType, setupCode, efc, notes) : new KeyMoveEFC5(keyCode, deviceIndex, deviceType, setupCode, efc, notes));
        return keyMove;
    }

    public String getInterfaceType() {
        String name = this.getProcessor().getName();
        if (name.equals("HCS08")) {
            return this.segmentTypes == null ? "JP1.2" : "JPUSB";
        }
        if (name.equals("S3F80") || name.equals("S3F80P5X")) {
            return this.isSSD() ? "JPUSB" : (this.segmentTypes == null ? "JP1.3" : (this.getE2FormatOffset() > 0 ? "JP1.4N" : "JP1.4"));
        }
        if (name.equals("SST")) {
            return "JP1.1";
        }
        if (name.equals("MAXQ610")) {
            return this.getE2FormatOffset() > 0 ? "JP2N" : "JP2";
        }
        if (name.equals("MAXQ612")) {
            return "JP3";
        }
        if (name.equals("MAXQ622")) {
            return this.usesSimpleset() ? "JPS" : "JPUSB";
        }
        if (name.equals("TI2541") || name.equals("TI2530") || name.equals("TI2533")) {
            return "JP3.1";
        }
        if (name.equals("GP541")) {
            return "JP2.2";
        }
        if (name.equals("GP565")) {
            return "JP3.2";
        }
        return "JP1";
    }

    public String getProcessorDescription() {
        String name = this.getProcessor().getName();
        if (name.equals("S3C80")) {
            if (this.RAMAddress == 65280) {
                return "Samsung S3C8+";
            }
            return "Samsung S3C8";
        }
        if (name.equals("S3F80")) {
            return "Samsung S3F8";
        }
        if (name.equals("S3F80P5X")) {
            return "Samsung S3F80P5X";
        }
        if (name.equals("HCS08")) {
            return "Freescale HCS08";
        }
        if (name.equals("6805")) {
            if (this.getProcessor().getVersion().equals("RC16/18")) {
                return "Motorola 6805RC16/18";
            }
            return "Motorola 6805C9";
        }
        if (name.equals("SST")) {
            return "SST SST65";
        }
        if (name.equals("740")) {
            return "Mitsubishi P8/740";
        }
        if (name.equals("MAXQ610")) {
            return "Maxim MAXQ610";
        }
        if (name.equals("MAXQ612")) {
            return "Maxim MAXQ612";
        }
        if (name.equals("MAXQ622")) {
            return "Maxim MAXQ622";
        }
        if (name.equals("TI2541")) {
            return "Texas Instruments CC2541 F256";
        }
        if (name.equals("TI2530")) {
            return "Texas Instruments CC2530 F128";
        }
        if (name.equals("TI2533")) {
            return "Texas Instruments CC2533 F96";
        }
        if (name.equals("GP541")) {
            return "GreenPeak GP541";
        }
        if (name.equals("GP565")) {
            return "Qorvo GP565";
        }
        return "<Unknown>";
    }

    public Integer getMaxUpgradeLength() {
        return this.maxUpgradeLength;
    }

    public Integer getMaxProtocolLength() {
        return this.maxProtocolLength;
    }

    public Integer getMaxCombinedUpgradeLength() {
        return this.maxCombinedUpgradeLength;
    }

    @Override
    public int compareTo(Remote o) {
        return this.names[this.nameIndex].compareTo(o.names[o.nameIndex]);
    }

    public int getShiftMask() {
        return this.shiftMask;
    }

    public boolean getShiftEnabled() {
        return this.shiftEnabled;
    }

    public int getXShiftMask() {
        return this.xShiftMask;
    }

    public boolean getXShiftEnabled() {
        return this.xShiftEnabled;
    }

    public void setXShiftEnabled(boolean flag) {
        this.xShiftEnabled = flag;
    }

    public String getShiftLabel() {
        return this.shiftLabel;
    }

    public String getXShiftLabel() {
        return this.xShiftLabel;
    }

    public int getProtocolVectorOffset() {
        return this.protocolVectorOffset;
    }

    public int getProtocolDataOffset() {
        return this.protocolDataOffset;
    }

    public int getSeqShift() {
        return this.seqShift;
    }

    public boolean getSupportsBinaryUpgrades() {
        return this.supportsBinaryUpgrades;
    }

    public int getSoftHomeTheaterType() {
        if (this.softHomeTheater == null) {
            return -1;
        }
        return this.deviceTypeList.get(this.softHomeTheater.getDeviceType()).getNumber();
    }

    public int getSoftHomeTheaterCode() {
        if (this.softHomeTheater == null) {
            return -1;
        }
        return this.softHomeTheater.getDeviceCode();
    }

    public String getNotes() {
        return this.notes;
    }

    public boolean hasFavKey() {
        if (this.favKey == null) {
            return false;
        }
        return this.favKey.getDeviceButtonAddress() != 0 || this.advCodeBindFormat == AdvancedCode.BindFormat.LONG;
    }

    public boolean hasFavorites() {
        return this.favKey != null && (this.segmentTypes != null && this.segmentTypes.contains(29) || this.isSSD());
    }

    public int getInternalDeviceCode() {
        return this.internalDeviceCode;
    }

    public FavKey getFavKey() {
        return this.favKey;
    }

    public boolean hasTimedMacroSupport() {
        return this.timedMacroAddress != null || this.macroCodingType.hasTimedMacros();
    }

    public boolean hasLearnedSupport() {
        return this.learnedAddress != null || this.segmentTypes != null && this.segmentTypes.contains(9) || this.isSSD();
    }

    public boolean hasFreeProtocols() {
        return this.segmentTypes == null || this.segmentTypes.contains(15);
    }

    public boolean hasActivitySupport() {
        return this.segmentTypes != null && (this.segmentTypes.contains(219) || this.segmentTypes.contains(233) || this.segmentTypes.contains(27) || this.segmentTypes.contains(205) || this.segmentTypes.contains(30) || this.hasActivityAlgorithm() || this.usesSimpleset() || this.isSSD()) && !RMIRSetup.disableActivitiesItem.isSelected();
    }

    public boolean hasActivityAlgorithm() {
        return this.segmentTypes != null && this.segmentTypes.contains(47);
    }

    public boolean hasActivityInitialMacro() {
        return this.segmentTypes != null && (this.segmentTypes.contains(30) || this.isSSD());
    }

    public boolean hasRf4ceSupport() {
        return this.hasRfProtocol;
    }

    public boolean hasSettings() {
        if (this.segmentTypes == null || this.isSSD() && this.settings.length > 0) {
            return true;
        }
        for (Setting s : this.settings) {
            int segmentType = (s.getByteAddress() >> 8) - 1;
            if (segmentType < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isIctImporter() {
        return this.signature.equals("200000");
    }

    public boolean hasUpgradeBug() {
        return this.upgradeBug;
    }

    public AddressRange getAdvancedCodeAddress() {
        return this.advancedCodeAddress;
    }

    public AddressRange getUsageRange() {
        return this.usageRange;
    }

    public AddressRange getFavScanAddress() {
        return this.favScanAddress;
    }

    public void setFavScanAddress(AddressRange favScanAddress) {
        this.favScanAddress = favScanAddress;
    }

    public int getMacroSupport() {
        return this.macroSupport;
    }

    public boolean hasGlobalPunchthruSupport() {
        return this.globalPunchthruSupport;
    }

    public boolean hasKeyMoveSupport() {
        return this.keyMoveSupport;
    }

    public boolean hasMultiMacroSupport() {
        return this.multiMacroSupport;
    }

    public Integer[] getLedParams() {
        return this.ledParams;
    }

    public String[] getLedSettings() {
        return this.ledSettings;
    }

    public boolean hasDeviceSelection() {
        return this.deviceSelection;
    }

    public boolean needsDeviceSelectionMessage() {
        return this.deviceSelectionMessage;
    }

    public boolean usesLedColor() {
        return this.ledColor;
    }

    public AddressRange getUpgradeAddress() {
        return this.upgradeAddress;
    }

    public AddressRange getDeviceUpgradeAddress() {
        return this.deviceUpgradeAddress;
    }

    public int hasDeviceDependentUpgrades() {
        return this.deviceUpgradeAddress != null ? 2 : (this.usesEZRC() ? 1 : 0);
    }

    public AddressRange getLearnedAddress() {
        return this.learnedAddress;
    }

    public int getLearnedFormat() {
        if (this.learnedFormat >= 0) {
            return this.learnedFormat;
        }
        String procName = this.getProcessor().getEquivalentName();
        return procName.equals("MAXQ610") ? 1 : (procName.equals("TI2541") ? 2 : (this.segmentTypes != null ? 4 : 0));
    }

    public AddressRange getTimedMacroAddress() {
        return this.timedMacroAddress;
    }

    public boolean hasTimedMacroWarning() {
        return this.timedMacroWarning;
    }

    public boolean hasActivityControl() {
        return this.activityControl != null && this.activityControl.length > 0;
    }

    public ImageIcon getImage() {
        if (this.imageMaps == null || this.mapIndex >= this.imageMaps.length) {
            return null;
        }
        ImageMap map = this.imageMaps[this.mapIndex];
        if (map == null || map.getImageFile() == null) {
            return null;
        }
        return new ImageIcon(map.getImageFile().getAbsolutePath());
    }

    public ExtenderVersionParm getExtenderVersionParm() {
        return this.extenderVersionParm;
    }

    public List<String> getOemSignatures() {
        return this.oemSignatures;
    }

    public String getFirmwareSignature() {
        return this.firmwareSignature;
    }

    public HashMap<Integer, Integer> getSettingAddresses() {
        return this.settingAddresses;
    }

    public HashMap<Integer, Integer> getSettingMasks() {
        return this.settingMasks;
    }

    public List<Integer> getSettingBytes() {
        return this.settingBytes;
    }

    public int getRdfVersionAddress() {
        return this.rdfVersionAddress;
    }

    public boolean hasFlaggedDSM() {
        return this.flaggedDSM;
    }

    public short getSectionTerminator() {
        return this.sectionTerminator;
    }

    public List<SpecialProtocol> getSpecialProtocols() {
        return this.specialProtocols;
    }

    public boolean usesTwoBytePID() {
        return this.twoBytePID;
    }

    public boolean usesTwoByteSetupCode() {
        return this.twoByteSetupCode;
    }

    public boolean usesEZRC() {
        return this.signature.startsWith("USB");
    }

    public boolean usesSimpleset() {
        return this.processor.getName().equals("MAXQ622") && !this.signature.startsWith("USB");
    }

    public boolean isJP2style() {
        return this.getSegmentTypes() != null && !this.usesEZRC() && !this.usesSimpleset();
    }

    public boolean usesIcons() {
        return this.isSSD();
    }

    public boolean getLearnedDevBtnSwapped() {
        return this.learnedDevBtnSwapped;
    }

    public DeviceLabels getDeviceLabels() {
        return this.labels;
    }

    public SoftDevices getSoftDevices() {
        return this.softDevices;
    }

    public SoftHomeTheater getSoftHomeTheater() {
        return this.softHomeTheater;
    }

    public MacroCodingType getMacroCodingType() {
        return this.macroCodingType;
    }

    public int getStartReadOnlySettings() {
        return this.startReadOnlySettings;
    }

    public Hashtable<String, PauseParameters> getPauseParameters() {
        return this.pauseParameters;
    }

    public short[] getPowerButtons() {
        return this.powerButtons;
    }

    public int getRealTimeCodeBase() {
        return this.realTimeCodeBase;
    }

    public boolean supportWaveUpgrade() {
        this.load();
        return this.waveUpgrade;
    }

    public boolean doForceEvenStarts() {
        return this.forceEvenStarts;
    }

    public int getForceModulus() {
        return this.forceModulus;
    }

    public boolean isSoftButton(Button btn) {
        return this.buttonGroups.get("Soft") != null && this.buttonGroups.get("Soft").contains(btn) || this.buttonGroups.get("User") != null && this.buttonGroups.get("User").contains(btn);
    }

    public boolean hasMasterPowerSupport() {
        return this.masterPowerSupport;
    }

    public String getPunchThru() {
        return this.punchThru;
    }

    public FixedData[] getFixedData() {
        return this.fixedData;
    }

    public FixedData[] getRawFixedData() {
        return this.rawFixedData;
    }

    public void setFixedData(FixedData[] fixedData) {
        this.fixedData = fixedData;
    }

    public FixedData[] getAutoSet() {
        return this.autoSet;
    }

    public SetupValidation getRDFSetupValidation() {
        return this.setupValidation;
    }

    public int getKeyMoveCode() {
        return this.keyMoveCode;
    }

    public int getMacroCode() {
        return this.macroCode;
    }

    public int getDeviceIndexMask() {
        return this.deviceIndexMask;
    }

    public int getSequenceNumberMask() {
        return this.sequenceNumberMask;
    }

    public int getMaxMultiMacros() {
        return this.maxMultiMacros;
    }

    public String getRdfName() {
        return this.rdfName;
    }

    public String getRdfIdentification() {
        return this.rdfIdentification;
    }

    private void parseAdvCodeTypes(String text, RDFReader rdr) throws Exception {
        Iterator<String> iterator = LineTokenizer.tokenize(text, ",").iterator();
        String code = null;
        if (iterator.hasNext() && (code = iterator.next()) != null) {
            this.keyMoveCode = RDFReader.parseNumber(code);
            this.keyMoveSupport = true;
        } else {
            this.keyMoveSupport = false;
        }
        if (iterator.hasNext() && (code = iterator.next()) != null) {
            this.macroSupport = 1;
            Iterator<String> subIterator = LineTokenizer.tokenize(code, ":").iterator();
            if (iterator.hasNext() && subIterator.next() != null) {
                this.macroCode = RDFReader.parseNumber(code);
            }
            if (iterator.hasNext() && subIterator.next() != null) {
                this.deviceIndexMask = RDFReader.parseNumber(code);
            }
            if (iterator.hasNext() && subIterator.next() != null) {
                this.sequenceNumberMask = RDFReader.parseNumber(code);
            }
            if (iterator.hasNext() && subIterator.next() != null) {
                this.sequenceNumberMask = RDFReader.parseNumber(code);
            }
        } else {
            this.macroSupport = 0;
        }
    }

    public void setDeviceComboBox(JComboBox deviceBox) {
        DeviceButton[] allDB = this.getDeviceButtons();
        ArrayList<DeviceButton> dbList = new ArrayList<DeviceButton>();
        for (DeviceButton db : allDB) {
            if (db.getUpgrade() == null) continue;
            dbList.add(db);
        }
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(dbList.toArray());
        deviceBox.setModel(comboModel);
        if (dbList.size() > 0) {
            deviceBox.setSelectedIndex(0);
        }
    }

    public List<Short> getActivityOrder() {
        return this.buttonMaps[this.activityMapIndex].getKeyCodeSingleList();
    }

    public void correctType04Macro(Macro macro) {
        short[] data = macro.getData().getData();
        int len = data.length;
        ArrayList<DeviceButton> devs = new ArrayList<DeviceButton>();
        DeviceButton db = null;
        for (int i = 0; i < len / 2; ++i) {
            db = this.getDeviceButton(data[2 * i]);
            if (db == null) continue;
            devs.add(db);
        }
        Hex hex = new Hex(2 * this.deviceButtons.length);
        for (int i = 0; i < this.deviceButtons.length; ++i) {
            db = this.deviceButtons[i];
            hex.set((short)(devs.contains(db) ? db.getButtonIndex() : 255), 2 * i);
            hex.set(this.getButtonByStandardName("Power").getKeyCode(), 2 * i + 1);
        }
        macro.setData(hex);
    }

    public static int scaleColor(int val) {
        double top = 40.0;
        double frac = (double)val * top / 40.0;
        frac = Math.log1p(frac);
        return (int)Math.round(255.0 * frac / Math.log1p(top));
    }

    public static Color getColorByIndex(int ndx) {
        int r = Remote.scaleColor(colorHex.getData()[3 * --ndx]);
        int g = Remote.scaleColor(colorHex.getData()[3 * ndx + 1]);
        int b = Remote.scaleColor(colorHex.getData()[3 * ndx + 2]);
        return new Color(r, g, b);
    }

    public class KeyButtonGroup {
        public String name;
        public ButtonShape shape;
        public List<Button> buttons;

        public KeyButtonGroup(String name, List<Button> buttons) {
            this.name = name;
            this.buttons = buttons;
        }

        public void setButtonShape() {
            if (this.shape != null || this.buttons == null) {
                return;
            }
            ImageMap map = Remote.this.getImageMaps(Remote.this.getDeviceTypes()[0])[0];
            List<ButtonShape> shapes = map.getShapes();
            for (ButtonShape bs : shapes) {
                if (!this.buttons.contains(bs.getButton()) || Remote.this.getPhantomShapes().contains(bs)) continue;
                this.shape = bs;
                return;
            }
        }
    }

    public static enum BlockFormat {
        NO,
        YES,
        DEFAULT;

    }

    public static enum SetupValidation {
        OFF,
        WARN,
        ENFORCE;

    }

    public static class ButtonSplit {
        public Button base;
        public int state;

        public ButtonSplit(Button base, int state) {
            this.base = base;
            this.state = state;
        }
    }

    public static class RFSelector {
        public Button btn = null;
        public DeviceType irDevType = null;
        public SetupCode irCode = null;
        public DeviceType rfDevType = null;
        public SetupCode rfCode = null;
    }
}

