/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.ButtonShape;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.DSMFunction;
import com.hifiremote.jp1.DependentUpgradeComparator;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.FavKey;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.FavScanDialog;
import com.hifiremote.jp1.FixedData;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.GlobalPT;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexReader;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.IniSection;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveEFC5;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.KeyMoveLong;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDialog;
import com.hifiremote.jp1.LearnedSignalTimingSummaryDialog;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDialog;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.MultiMacro;
import com.hifiremote.jp1.NoSetup;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.Property;
import com.hifiremote.jp1.PropertyReader;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMListChooser;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Scanner;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.Setting;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SoftDevices;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocol;
import com.hifiremote.jp1.SpecialProtocolFunction;
import com.hifiremote.jp1.TimedMacro;
import com.hifiremote.jp1.TimedMacroDialog;
import com.hifiremote.jp1.io.CommHID;
import com.hifiremote.jp1.io.IO;
import com.hifiremote.jp1.io.JPS;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.harctoolbox.girr.RemoteSet;

public class RemoteConfiguration {
    public static final int Vect00Address = 131072;
    private Remote remote = null;
    private Segment internalSegment = null;
    private short[] data = null;
    private List<SSDFileInfo> ssdFileData = null;
    private short[] icinfo = null;
    private short[] sigData = null;
    private short[] rfData = null;
    private int rfDataAddress = 0;
    private String eepromFormatVersion = null;
    private Color[] highlight = null;
    private short[] savedData = null;
    private short[] baselineData = null;
    private List<SSDFileInfo> savedSSDFileData = null;
    private LinkedHashMap<Integer, List<Segment>> segments = new LinkedHashMap();
    private LinkedHashMap<Integer, List<Segment>> segmentBackups = null;
    private LinkedHashMap<String, SSDFile> ssdFiles = new LinkedHashMap();
    private LinkedHashMap<Integer, String> deviceCategories = null;
    private LinkedHashMap<Integer, List<String>> categoryBrands = null;
    private LinkedHashMap<Integer, Integer> codeLocations = null;
    private LinkedHashMap<Integer, Hex> nib = null;
    private LinkedHashMap<Integer, Integer> nibSizes = null;
    private LinkedHashMap<Button, Activity> activities = null;
    private List<Integer> segmentLoadOrder = new ArrayList<Integer>();
    private HashMap<Integer, Integer> settingMap = new HashMap();
    private List<KeyMove> keymoves = new ArrayList<KeyMove>();
    private List<KeyMove> upgradeKeyMoves = new ArrayList<KeyMove>();
    private List<Macro> macros = new ArrayList<Macro>();
    private List<TimedMacro> timedMacros = new ArrayList<TimedMacro>();
    private List<GlobalPT> globalPTs = new ArrayList<GlobalPT>();
    private List<FavScan> favScans = new ArrayList<FavScan>();
    private List<DeviceUpgrade> devices = new ArrayList<DeviceUpgrade>();
    private List<DeviceButton> deviceButtonList = null;
    private List<ProtocolUpgrade> protocols = new ArrayList<ProtocolUpgrade>();
    private List<LearnedSignal> learned = new ArrayList<LearnedSignal>();
    private List<SpecialProtocolFunction> specialFunctions = new ArrayList<SpecialProtocolFunction>();
    private List<KeyMove> specialFunctionKeyMoves = new ArrayList<KeyMove>();
    private List<Macro> specialFunctionMacros = new ArrayList<Macro>();
    private List<Integer> gidList = null;
    private HashMap<Button, Macro> activityMacros = null;
    private HashMap<String, List<Integer>> gidRegister = null;
    private NoSetup noSetup = null;
    private NoSetup savedNoSetup = null;
    private Hex activitySetupAddresses = null;
    private int[] activitySerials = null;
    public boolean isReplacement = false;
    private String language = null;
    private String languageFilename = null;
    private boolean isSetToDanish = false;
    private String region = null;
    private String regionFilename = null;
    private Hex directv_rf = null;
    private String notes = null;
    private String[] deviceButtonNotes = null;
    private DeviceButton favKeyDevButton = null;
    public ProtocolUpgrade protocolUpgradeUsed = null;
    private RMIRSetup owner = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> userIcons = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> savedUserIcons = null;
    private LinkedHashMap<Integer, GeneralFunction.RMIcon> sysIcons = null;
    private List<String> tagList = null;
    public static Comparator<Macro> MacroSorter = new Comparator<Macro>(){

        @Override
        public int compare(Macro m1, Macro m2) {
            return new Integer(m1.getSerial()).compareTo(new Integer(m2.getSerial()));
        }
    };
    public static final int[] encryptionKey = new int[]{53, 52, 110, 100, 115, 102, 106, 107, 104, 97, 107, 108, 102, 100, 106, 107, 108, 52, 101, 55, 57, 56, 9, 52, 32, 46, 34, 126, 108, 102, 10, 106, 104, 102, 107, 104, 103, 56, 55, 52, 57, 56, 104, 116, 81, 81, 52, 50, 50, 57, 51, 1, 55, 57};
    public static final String[][] nibSizeData = new String[][]{{"6", "4"}, {"21", "1"}, {"24", "39"}, {"25", "4"}, {"26", "1"}};
    public static final String[][] languageCodes = new String[][]{{"English", "en"}, {"French", "fr"}, {"German", "ge"}, {"Spanish", "sp"}, {"Italian", "it"}, {"Norwegian", "no"}, {"Swedish", "se"}, {"Dutch", "nl"}, {"Finnish", "fi"}, {"Danish", "dk"}};
    public static final String[][] regionNames = new String[][]{{"North America", "NAmerica"}, {"Europe", "Europe"}, {"Latin America", "Latin"}, {"MidEast Africa", "MidEast"}, {"Asia", "Asia"}, {"Pacific", "Pacific"}};

    public RemoteConfiguration(File file, RMIRSetup rm) throws IOException {
        this.owner = rm;
        rm.clearAllInterfaces();
        BufferedReader in = new BufferedReader(new FileReader(file));
        PropertyReader pr = new PropertyReader(in);
        RMIRSetup.disableActivitiesItem.setSelected(false);
        if (file.getName().toLowerCase().endsWith(".rmir")) {
            this.parse(pr);
        } else {
            this.importIR(pr, true);
        }
        in.close();
        this.updateImage();
        RMIRSetup.setSystemFilesItems(rm, this.remote);
    }

    public RemoteConfiguration(String str, RMIRSetup rm, Remote remote) throws IOException {
        this.owner = rm;
        rm.clearAllInterfaces();
        this.remote = remote;
        RMIRSetup.disableActivitiesItem.setSelected(false);
        BufferedReader in = new BufferedReader(new StringReader(str));
        PropertyReader pr = new PropertyReader(in);
        this.importIR(pr, false);
        in.close();
        RMIRSetup.setSystemFilesItems(rm, remote);
    }

    public void createActivities() {
        this.activities = new LinkedHashMap();
        LinkedHashMap<String, List<Button>> buttonGroups = this.remote.getButtonGroups();
        List<Button> activityBtns = null;
        if (buttonGroups != null) {
            activityBtns = buttonGroups.get("Activity");
        }
        if (activityBtns == null) {
            return;
        }
        for (Button btn : activityBtns) {
            Setting setting;
            Activity activity = new Activity(btn, this.remote);
            if (!this.remote.usesEZRC()) {
                activity.setActive(true);
            }
            if ((setting = this.remote.getSetting("AudioHelp")) != null) {
                activity.setAudioHelp(setting.getInitialValue());
            }
            if ((setting = this.remote.getSetting("VideoHelp")) != null) {
                activity.setVideoHelp(setting.getInitialValue());
            }
            this.activities.put(btn, activity);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void parse(PropertyReader pr) throws IOException {
        LinkedList<Property> queue = new LinkedList<Property>();
        IniSection section = pr.nextSection(queue);
        ProtocolManager.getProtocolManager().reset();
        if (section == null) {
            throw new IOException("The file is empty.");
        }
        if (!"General".equals(section.getName())) {
            throw new IOException("Doesn't start with a [General] section/");
        }
        Remote.prelimLoad = true;
        this.remote = RemoteManager.getRemoteManager().findRemoteByName(section.getProperty("Remote.name"));
        Remote.prelimLoad = false;
        Remote newRemote = new Remote(this.remote, this.remote.getNameIndex());
        RemoteManager.getRemoteManager().replaceRemote(this.remote, newRemote);
        this.remote = newRemote;
        String prop = section.getProperty("Info");
        if (prop != null) {
            this.icinfo = Hex.parseHex(prop);
        }
        if ((prop = section.getProperty("Remote.sigData")) != null) {
            this.sigData = Hex.parseHex(prop);
        }
        SetupCode.setMax(this.remote);
        this.notes = section.getProperty("Notes");
        this.deviceButtonNotes = new String[this.remote.getDeviceButtons().length];
        this.loadBuffer(pr);
        while (queue.size() > 0 && ((Property)queue.peek()).value.length() > 0) {
            queue.remove();
        }
        PropertyReader pr2 = new PropertyReader(queue);
        this.loadBuffer(pr2);
        int e2FormatOffset = this.remote.getE2FormatOffset();
        if (e2FormatOffset >= 0) {
            short n;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 20 - e2FormatOffset && (n = this.data[e2FormatOffset + i]) != 255; ++i) {
                sb.append((char)n);
            }
            String e2f = sb.toString();
            this.eepromFormatVersion = e2f.isEmpty() ? null : e2f;
        }
        LinkedHashMap<GeneralFunction, Integer> iconrefMap = null;
        if (this.remote.usesEZRC()) {
            this.gidList = new ArrayList<Integer>();
            this.gidRegister = new HashMap();
        }
        if (this.remote.isSSD()) {
            this.ssdFileData = new ArrayList<SSDFileInfo>();
            this.savedSSDFileData = new ArrayList<SSDFileInfo>();
            this.loadFiles(false);
            iconrefMap = new LinkedHashMap<GeneralFunction, Integer>();
        } else if (this.hasSegments()) {
            this.loadSegments(false);
        }
        if (this.remote.hasActivitySupport()) {
            this.activityMacros = new HashMap();
        }
        int favWidth = 0;
        Button favFinalKey = null;
        while ((section = pr.nextSection()) != null) {
            String sectionName = section.getName();
            if (sectionName.equals("DeviceButtonNotes")) {
                Highlight[] buttons = this.remote.getDeviceButtons();
                for (int i = 0; i < this.deviceButtonNotes.length; ++i) {
                    Highlight button = buttons[i];
                    String note = section.getProperty(button.getName());
                    if (note == null || note.equals("")) continue;
                    this.deviceButtonNotes[i] = note;
                }
                continue;
            }
            if (sectionName.equals("Settings")) {
                for (Highlight setting : this.remote.getSettings()) {
                    String s = section.getProperty(((Setting)setting).getTitle());
                    if (s == null) continue;
                    ((Setting)setting).setValue(Integer.parseInt(s));
                }
                continue;
            }
            if (sectionName.equals("DeviceUpgrade")) {
                DeviceUpgrade upgrade = new DeviceUpgrade();
                upgrade.setRemoteConfig(this);
                upgrade.load(section, true, this.remote, iconrefMap);
                this.devices.add(upgrade);
                if (!this.remote.usesEZRC()) continue;
                if (upgrade.getSelectorMap() == null) {
                    upgrade.setRemote(this.remote);
                }
                upgrade.classifyButtons();
                continue;
            }
            if (sectionName.equals("FavData")) {
                String temp;
                FavKey favKey = this.remote.getFavKey();
                Button favBtn = favKey != null ? this.remote.getButton(favKey.getKeyCode()) : null;
                Activity activity = null;
                if (favBtn != null && (activity = this.remote.getFavKey().getActivity()) != null) {
                    ActivityGroup.parse(section, activity);
                    activity.set(this.remote);
                    activity.setActive(true);
                }
                if ((temp = section.getProperty("Pause")) != null && favKey != null) {
                    favKey.setFavPause(Integer.parseInt(temp));
                }
                if ((temp = section.getProperty("FavWidth")) != null) {
                    favWidth = Integer.parseInt(temp);
                }
                if ((temp = section.getProperty("FinalKey")) == null || (favFinalKey = this.remote.getButton(Integer.parseInt(temp))) == null || favFinalKey.getKeyCode() != 255) continue;
                favFinalKey = null;
                continue;
            }
            if (sectionName.equals("DeviceButton")) {
                String s;
                String temp = section.getProperty("DeviceIndex");
                if (temp == null) continue;
                int deviceIndex = Integer.parseInt(temp);
                DeviceButton db = this.remote.getDeviceButton(deviceIndex);
                ArrayList<Remote.RFSelector> list = new ArrayList<Remote.RFSelector>();
                int i = 0;
                while ((s = section.getProperty("Selector." + i++)) != null) {
                    Remote.RFSelector rfSel = new Remote.RFSelector();
                    StringTokenizer st = new StringTokenizer(s, "|");
                    int j = 0;
                    while (st.hasMoreTokens()) {
                        String t = st.nextToken();
                        switch (j++) {
                            case 0: {
                                int keyCode = Integer.parseInt(t);
                                rfSel.btn = this.remote.getButton(keyCode);
                                break;
                            }
                            case 1: {
                                rfSel.irDevType = this.remote.getDeviceType(t);
                                break;
                            }
                            case 2: {
                                rfSel.irCode = new SetupCode(Integer.parseInt(t));
                                break;
                            }
                            case 3: {
                                rfSel.rfDevType = this.remote.getDeviceType(t);
                                break;
                            }
                            case 4: {
                                rfSel.rfCode = new SetupCode(Integer.parseInt(t));
                            }
                        }
                    }
                    list.add(rfSel);
                }
                db.setRfSelectors(list.toArray(new Remote.RFSelector[0]));
                continue;
            }
            try {
                Object o;
                Constructor<?> ct;
                String className = sectionName.equals("Profile") ? "Activity" : sectionName;
                Class<?> c = Class.forName("com.hifiremote.jp1." + className);
                try {
                    ct = c.getConstructor(Properties.class);
                    o = ct.newInstance(section);
                }
                catch (Exception e) {
                    ct = c.getConstructor(Properties.class, Remote.class);
                    o = ct.newInstance(section, this.remote);
                }
                if (o instanceof SpecialProtocolFunction) {
                    SpecialProtocolFunction spf = (SpecialProtocolFunction)o;
                    if (spf instanceof DSMFunction && spf.getMacro() != null) {
                        Macro macro = spf.getMacro();
                        Button button = this.remote.getBaseButton(macro.getKeyCode());
                        if (spf.getMacro().getItems() != null) {
                            if (macro.getData() != null) {
                                macro.setItems(macro.getData(), this.remote);
                                macro.setData(null);
                            }
                            macro.setMacroClass(Macro.MacroClass.REALTIME);
                        } else if (macro.getMacroClass() == Macro.MacroClass.UNDETERMINED && button != null && (button.getMultiMacro() != null || button.isLegacyMulti())) {
                            macro.setMacroClass(Macro.MacroClass.MULTI);
                        }
                    }
                    this.specialFunctions.add((SpecialProtocolFunction)o);
                } else if (o instanceof KeyMove) {
                    this.keymoves.add((KeyMove)o);
                } else if (sectionName.equals("Macro")) {
                    Macro macro = (Macro)o;
                    int dbi = macro.getDeviceButtonIndex();
                    if (this.remote.getSegmentTypes() != null && dbi == -1) {
                        dbi = 0;
                    }
                    Button button = this.remote.usesEZRC() || this.remote.getSegmentTypes() != null && this.remote.getSegmentTypes().contains(205) && this.remote.hasMasterPowerSupport() ? this.remote.getButton(macro.getKeyCode()) : this.remote.getButton(dbi);
                    if (this.activityMacros != null && !this.remote.hasActivityAlgorithm() && this.remote.getButtonGroups().get("Activity").contains(button)) {
                        this.activityMacros.put(button, macro);
                        if (this.remote.getSegmentTypes().contains(4)) {
                            macro.setMacroClass(Macro.MacroClass.ACTIVITYPOWER);
                        } else if (this.remote.getSegmentTypes().contains(205)) {
                            macro.setMacroClass(Macro.MacroClass.MASTERPOWER);
                        }
                        if (this.remote.isSSD()) {
                            this.macros.add(macro);
                            macro.setActivity(this.activities.get(button));
                        }
                    } else {
                        button = this.remote.getButton(macro.getKeyCode());
                        if (macro.getMacroClass() == Macro.MacroClass.UNDETERMINED && button != null && (button.getMultiMacro() != null || button.isLegacyMulti())) {
                            macro.setMacroClass(Macro.MacroClass.MULTI);
                        }
                        this.setMacro(macro);
                    }
                } else if (sectionName.equals("TimedMacro")) {
                    this.timedMacros.add((TimedMacro)o);
                } else if (sectionName.equals("GlobalPT")) {
                    this.globalPTs.add((GlobalPT)o);
                } else if (sectionName.equals("FavScan")) {
                    FavScan favScan = (FavScan)o;
                    this.favKeyDevButton = favScan.getDeviceButtonFromIndex(this.remote);
                    if (this.remote.getAdvCodeBindFormat() != AdvancedCode.BindFormat.NORMAL) {
                        favScan.setDeviceButton(this.favKeyDevButton);
                    }
                    if (this.remote.isSSD()) {
                        favScan.icon = new GeneralFunction.RMIcon(6);
                        if (this.favKeyDevButton != null && this.favKeyDevButton.getFavoriteWidth() == 0) {
                            String channel = favScan.getChannel();
                            int width = channel.indexOf(46) >= 0 ? channel.indexOf(46) : channel.length();
                            this.favKeyDevButton.setFavoritewidth(width);
                        }
                    }
                    this.favScans.add(favScan);
                } else if (sectionName.equals("ProtocolUpgrade")) {
                    this.protocols.add((ProtocolUpgrade)o);
                } else if (sectionName.equals("Activity")) {
                    Activity activity = (Activity)o;
                    activity.setRemoteConfig(this);
                    if (activity.getActivityGroups() != null) {
                        if (this.noSetup == null) {
                            this.noSetup = this.getNoSetup();
                        }
                        if (this.noSetup != null) {
                            this.activitySerials = new int[4];
                            for (Object group : activity.getActivityGroups()) {
                                int n = ((ActivityGroup)group).getIndex();
                                if (n == 0) {
                                    this.activitySerials[0] = ((ActivityGroup)group).getDeviceIndex();
                                }
                                this.activitySerials[n + 1] = ((ActivityGroup)group).getDeviceIndex();
                            }
                            this.resetDeviceUpgrades();
                        }
                        for (Object group : activity.getActivityGroups()) {
                            if (((ActivityGroup)group).getTargetKeyCode() <= 0) continue;
                            ((ActivityGroup)group).setTarget(((ActivityGroup)group).getDevice().getUpgrade().getMacroMap().get(((ActivityGroup)group).getTargetKeyCode()));
                        }
                    }
                    if (this.activities == null) {
                        this.activities = new LinkedHashMap();
                    }
                    this.activities.put(activity.getButton(), activity);
                } else if (sectionName.equals("Profile") && this.remote.getFavKey() != null) {
                    Activity activity = (Activity)o;
                    activity.set(this.remote);
                    if (this.remote.getFavKey().getProfiles() == null) {
                        this.remote.getFavKey().setProfiles(new ArrayList<Activity>());
                    }
                    this.remote.getFavKey().getProfiles().add(activity);
                } else if (sectionName.equals("LearnedSignal")) {
                    LearnedSignal ls = (LearnedSignal)o;
                    this.learned.add(ls);
                    if (this.remote.usesEZRC()) {
                        DeviceButton db = this.remote.getDeviceButton(ls.getDeviceButtonIndex());
                        Button btn = this.remote.getButton(ls.getKeyCode());
                        DeviceUpgrade du = null;
                        if (db != null && (du = db.getUpgrade()) != null && btn != null) {
                            du.getLearnedMap().put(ls.getKeyCode(), ls);
                            if (ls.getUserItems() == null) {
                                ls.addReference(db, btn);
                            }
                        }
                    }
                } else if (sectionName.equals("ManualProtocol")) {
                    ManualProtocol mp = (ManualProtocol)o;
                    ProtocolManager.getProtocolManager().add(mp);
                    this.protocols.get(this.protocols.size() - 1).setProtocol(mp);
                }
                String temp = null;
                if (iconrefMap == null || !(o instanceof GeneralFunction) || (temp = section.getProperty("Iconref")) == null) continue;
                iconrefMap.put((GeneralFunction)o, Integer.parseInt(temp));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Unable to create instance of " + sectionName);
            }
        }
        if (iconrefMap != null) {
            this.setIcons(iconrefMap);
        }
        if (this.remote.usesEZRC()) {
            for (DeviceButton db : this.remote.getDeviceButtons()) {
                if (db.getUpgrade() == null) continue;
                db.getUpgrade().setRemote(this.remote);
            }
            if (favWidth > 0) {
                this.favKeyDevButton.setFavoritewidth(favWidth);
            }
            if (favFinalKey != null) {
                this.favKeyDevButton.setFavFinalKey(favFinalKey);
            }
            if (this.deviceButtonList == null) {
                this.deviceButtonList = new ArrayList<DeviceButton>();
            }
        }
        if (this.activityMacros != null) {
            for (Button btn : this.activityMacros.keySet()) {
                Activity activity = this.activities.get(btn);
                Macro macro = this.activityMacros.get(btn);
                activity.setMacro(macro);
                macro.setActivity(activity);
                if (activity.getSelector() == null) {
                    activity.setSelector(this.remote.getButton(macro.getKeyCode()));
                }
                if (macro.getUserItems() != null && !macro.getUserItems().isEmpty()) {
                    int ui = macro.getUserItems().remove(0);
                    macro.setDeviceButtonIndex(ui >> 16);
                    macro.setKeyCode(ui & 0xFFFF);
                }
                if (macro.getItems() == null || macro.getItems().size() <= 0) continue;
                macro.addReference(macro.getItems().get((int)0).db, btn);
            }
        }
        if (this.remote.usesEZRC()) {
            for (Macro macro : this.getAllMacros(true)) {
                for (KeySpec ks : macro.getItems()) {
                    if (macro.isSystemMacro() && ks.btn != null) {
                        ks.fn = ks.db.getUpgrade().getFunction(ks.btn, 0);
                        if (ks.fn != null) {
                            ks.btn = null;
                        }
                    }
                    if (ks.irSerial >= 0) {
                        Function f = null;
                        f = ks.db.getUpgrade().getFunctionMap().get(ks.irSerial);
                        if (f != null) {
                            ks.fn = f;
                            if (this.remote.getSystemButtons() != null) {
                                Button b = this.remote.getSystemButtons().get(ks.irSerial);
                                ks.fn.addReference(ks.db, b);
                            }
                            ks.irSerial = -1;
                        }
                    }
                    if (!macro.isSystemMacro() || ks.btn == null) continue;
                    ks.fn = ks.db.getUpgrade().getGeneralFunction(ks.btn.getKeyCode(), false);
                    ks.btn = null;
                }
                if (macro.getUsers() != null) {
                    for (GeneralFunction.User u : macro.getUsers()) {
                        macro.addReference(u.db, u.button);
                    }
                }
                if (macro.getAssists() == null) continue;
                Activity.Assister.setFunctions(macro.getAssists(), this.remote);
            }
        }
        this.convertKeyMoves();
    }

    /*
     * WARNING - void declaration
     */
    private Property loadBuffer(PropertyReader pr) throws IOException {
        int i;
        String signature = null;
        Remote currentRemote = null;
        if (this.owner.getRemoteConfiguration() != null) {
            currentRemote = this.owner.getRemoteConfiguration().getRemote();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        int dataSize = 0;
        int baseAddr = 0;
        Property property = pr.nextProperty();
        block2: while (property != null && !property.name.equals("[RDF Data]") && !property.name.equals("[Notes]")) {
            if (property.name.length() == 0) {
                property = pr.nextProperty();
                continue;
            }
            if (property.name.equals("[Info]")) {
                property = pr.nextProperty();
                try {
                    this.icinfo = new Hex(property.name).getData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                property = pr.nextProperty();
                continue;
            }
            if (property.name.equals("[Signature]") || property.name.equals("[SigBlock]")) {
                Object data;
                int sigDataLen = 0;
                values.clear();
                property = pr.nextProperty();
                while (property != null && property.value.length() > 0) {
                    data = Hex.parseHex(property.value);
                    sigDataLen += ((short[])data).length;
                    values.add(data);
                    property = pr.nextProperty();
                }
                this.sigData = new short[Math.min(sigDataLen, 160)];
                sigDataLen = 0;
                data = values.iterator();
                while (data.hasNext()) {
                    short[] sArray = (short[])data.next();
                    if (sigDataLen > this.sigData.length) break;
                    System.arraycopy(sArray, 0, this.sigData, sigDataLen, Math.min(sArray.length, this.sigData.length - sigDataLen));
                    sigDataLen += sArray.length;
                }
                if (signature == null && this.sigData.length > 3) {
                    int sigbase = (this.sigData[2] | this.sigData[3]) == 0 ? 6 : 0;
                    int n = sigDataLen <= 8 ? sigDataLen : 6;
                    char[] sig = new char[n];
                    for (i = 0; i < n; ++i) {
                        sig[i] = (char)this.sigData[sigbase + i];
                    }
                    signature = new String(sig);
                }
                if (sigDataLen > 8) continue;
                this.sigData = null;
                continue;
            }
            if (property.name.equals("[RFData]")) {
                values.clear();
                property = pr.nextProperty();
                this.rfDataAddress = Integer.parseInt(property.name, 16);
                while (property != null && property.value.length() > 0) {
                    short[] data = Hex.parseHex(property.value);
                    values.add(data);
                    property = pr.nextProperty();
                }
                this.rfData = new short[128];
                int dataLen = 0;
                for (short[] sArray : values) {
                    if (dataLen > this.rfData.length) continue block2;
                    System.arraycopy(sArray, 0, this.rfData, dataLen, Math.min(sArray.length, this.rfData.length - dataLen));
                    dataLen += sArray.length;
                }
                continue;
            }
            if (property.name.equals("[Buffer]") || property.value.length() > 0) {
                if (property.value.length() == 0) {
                    property = pr.nextProperty();
                }
                baseAddr = Integer.parseInt(property.name, 16);
                ArrayList<Integer> offsets = new ArrayList<Integer>();
                values.clear();
                while (property != null && property.value.length() > 0) {
                    offsets.add(Integer.parseInt(property.name, 16) - baseAddr);
                    values.add(Hex.parseHex(property.value));
                    property = pr.nextProperty();
                }
                for (int i2 = 0; i2 < offsets.size(); ++i2) {
                    dataSize = Math.max(dataSize, (Integer)offsets.get(i2) + ((short[])values.get(i2)).length);
                }
                this.data = new short[dataSize];
                for (int i2 = 0; i2 < offsets.size(); ++i2) {
                    System.arraycopy(values.get(i2), 0, this.data, (Integer)offsets.get(i2), ((short[])values.get(i2)).length);
                }
                if (!pr.setsQueue()) continue;
                break;
            }
            property = pr.nextProperty();
            while (property != null && property.value.length() > 0) {
                property = pr.nextProperty();
            }
        }
        if (pr.getQueue() != null) {
            return null;
        }
        if (this.remote == null) {
            void var10_25;
            List<Remote> list;
            if (signature == null) {
                signature = Hex.getRemoteSignature(this.data);
            }
            String signature2 = null;
            RemoteManager rm = RemoteManager.getRemoteManager();
            Object var10_24 = null;
            int minLength = signature.startsWith("USB") ? 7 : 4;
            for (i = signature.length(); i >= minLength && (list = rm.findRemoteBySignature(signature2 = signature.substring(0, i))).isEmpty(); --i) {
            }
            signature = signature2;
            Remote.prelimLoad = true;
            if (this.owner.sameSigSameRemote() && currentRemote != null && currentRemote.getSignature().equals(signature)) {
                for (Remote r : var10_25) {
                    if (currentRemote.compareTo(r) != 0) continue;
                    this.remote = r;
                    break;
                }
            } else {
                this.remote = this.owner.filterRemotes((List<Remote>)var10_25, signature, dataSize, this.data, this.sigData, true);
            }
            Remote.prelimLoad = false;
            if (this.remote == null) {
                throw new IllegalArgumentException("No matching remote selected for signature " + signature);
            }
        }
        if (this.remote.isSSD() && dataSize < this.remote.getEepromSize()) {
            this.data = Arrays.copyOf(this.data, this.remote.getEepromSize());
            Arrays.fill(this.data, dataSize, this.remote.getEepromSize(), (short)255);
            dataSize = this.remote.getEepromSize();
        }
        this.remote.load();
        this.remote.setFixedData(this.remote.getRawFixedData());
        this.createActivities();
        this.highlight = new Color[dataSize + 8 * this.remote.getSettingAddresses().size()];
        for (int i3 = 0; i3 < this.highlight.length; ++i3) {
            this.highlight[i3] = Color.WHITE;
        }
        SetupCode.setMax(this.remote);
        System.err.println("Remote is " + this.remote);
        if (baseAddr != this.remote.getBaseAddress()) {
            System.err.println(String.format("Base address of image (%04X) differs from that in RDF (%04X) but continuing execution.", baseAddr, this.remote.getBaseAddress()));
        }
        this.deviceButtonNotes = new String[this.remote.getDeviceButtons().length];
        if (this.remote.hasFavKey()) {
            if (this.remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL || this.remote.getFavKey().isSegregated()) {
                int buttonIndex = this.data[this.remote.getFavKey().getDeviceButtonAddress()] & 0xF;
                this.favKeyDevButton = buttonIndex == 15 ? DeviceButton.noButton : this.remote.getDeviceButtons()[buttonIndex];
            } else if (!this.remote.usesEZRC()) {
                this.favKeyDevButton = DeviceButton.noButton;
            }
        }
        this.setSavedData();
        return property;
    }

    public boolean hasSegments() {
        return this.remote.getSegmentTypes() != null;
    }

    public LinkedHashMap<Integer, List<Segment>> getSegments() {
        return this.segments;
    }

    public LinkedHashMap<Button, Activity> getActivities() {
        return this.activities;
    }

    public int[] getActivitySerials() {
        return this.activitySerials;
    }

    public List<String> getBXMLtagnames(String name, short[] data, int pos) {
        ArrayList<String> tagNames = new ArrayList<String>();
        if (name != null) {
            System.err.println(name + " tags:");
        }
        int itemsLength = data[pos + 14] + 256 * data[pos + 15];
        pos += 16;
        int itemCount = data[pos++];
        int itemsEnd = pos + itemsLength;
        for (int i = 0; i < itemCount; ++i) {
            char ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = (char)data[pos++]) != '\u0000') {
                sb.append(ch);
            }
            String tag = Integer.toHexString(i);
            if (tag.length() == 1) {
                tag = "0" + tag;
            }
            String tagName = sb.toString();
            tagNames.add(tagName);
            if (name == null) continue;
            System.err.println("  " + tag + "  " + tagName);
        }
        if (pos != itemsEnd) {
            System.err.println("Parsing error in " + name);
            return null;
        }
        return tagNames;
    }

    private void loadFiles(boolean decode) {
        int pos = 4;
        int index = -1;
        int status = this.data[0] + ((this.data[1] & 0xF) << 8);
        int end = this.data[2] + (this.data[3] << 8) + ((this.data[1] & 0xF0) << 12);
        this.ssdFiles.clear();
        this.userIcons = new LinkedHashMap();
        this.savedUserIcons = new LinkedHashMap();
        this.sysIcons = new LinkedHashMap();
        for (DeviceButton db : this.remote.getDeviceButtons()) {
            db.setSegment(null);
        }
        Items items = new Items();
        while (pos < end) {
            SSDFileInfo info;
            while (index < 12 && (status & 1 << ++index) == 0) {
            }
            if (index == 12) break;
            String name = Remote.userFilenames[index];
            SSDFile file = new SSDFile();
            if (name.endsWith(".xcf")) {
                Hex hex;
                int start;
                info = new SSDFileInfo();
                info.index = index;
                info.fileStart = pos;
                List<String> tagNames = this.getBXMLtagnames(name, this.data, pos);
                if (tagNames == null) break;
                this.savedSSDFileData.add(info);
                file.prefix = Hex.subHex(this.data, pos, 8);
                file.tagNames = tagNames;
                int itemsLength = this.data[pos + 14] + 256 * this.data[pos + 15];
                info.xcfStart = start = pos + itemsLength + 17;
                info.fileEnd = pos = this.parseXCFFile(items, index, this.data, start, tagNames, decode);
                file.hex = hex = new Hex(this.data, start, pos - start);
                this.ssdFiles.put(name, file);
                System.err.println(name + " hex = " + hex);
                System.err.print("Saved File " + name + ": bxmlStart=" + Integer.toHexString(info.fileStart) + "  xcfStart=" + Integer.toHexString(info.xcfStart) + "\n\n");
                continue;
            }
            if (!name.endsWith(".pkg")) continue;
            info = new SSDFileInfo();
            info.fileStart = pos;
            this.savedSSDFileData.add(info);
            info.index = index;
            int numIcons = this.data[pos + 12] + 256 * this.data[pos + 13];
            int numEntries = this.data[pos + 14] + 256 * this.data[pos + 15];
            int fileStart = pos;
            int startIndex = (pos += 16) + 28 * numIcons;
            int iconEnd = 16 + 28 * numIcons + numEntries;
            for (int i = 0; i < numEntries; ++i) {
                int excess;
                short j = this.data[startIndex + i];
                if (j == 0) continue;
                int k = pos + 28 * (j - 1);
                GeneralFunction.RMIcon icon = new GeneralFunction.RMIcon();
                icon.ref = i;
                icon.intro = new Hex(this.data, pos, 8);
                int width = this.data[k + 8] + 256 * this.data[k + 9];
                int height = this.data[k + 10] + 256 * this.data[k + 11];
                icon.type = this.data[k + 15];
                int start = this.data[k + 16] + 256 * this.data[k + 17] + 65536 * this.data[k + 18];
                int start2 = this.data[k + 20] + 256 * this.data[k + 21] + 65536 * this.data[k + 22];
                int n = excess = start2 == 0 ? 256 : 512;
                if (start != iconEnd) {
                    System.err.println("Icon at index " + (j - 1) + " has start listed as " + Integer.toHexString(start) + " but calculated as " + Integer.toHexString(iconEnd));
                    start = iconEnd;
                }
                int baseSize = this.data[k + 24] + 256 * this.data[k + 25] - excess;
                int pixSize = height * width;
                int byteWidth = baseSize / pixSize;
                int dataSize = pixSize * byteWidth;
                int lineWidth = width * byteWidth;
                if (baseSize != dataSize) {
                    System.err.println("Icon at index " + (j - 1) + " has size error");
                }
                Hex hex1 = new Hex(this.data, fileStart + start, dataSize);
                Hex hex2 = null;
                iconEnd = start += dataSize;
                if (start2 == start) {
                    hex2 = new Hex(this.data, fileStart + start, pixSize);
                    iconEnd = start + pixSize;
                }
                if (start2 != start && start2 != 0) {
                    System.err.println("Icon at index " + (j - 1) + " has unexpected transparency data");
                }
                BufferedImage image = new BufferedImage(width, height, 2);
                for (int m = 0; m < hex1.length(); m += lineWidth) {
                    for (int n2 = m; n2 < m + lineWidth; n2 += byteWidth) {
                        int val = 0;
                        for (int p = 0; p < byteWidth; ++p) {
                            val += hex1.getData()[n2 + p] << 8 * p;
                        }
                        int alpha = hex2 != null ? hex2.getData()[n2 / byteWidth] : 255;
                        int row = m / lineWidth;
                        int col = (n2 - m) / byteWidth;
                        int rgb = 0;
                        if (byteWidth == 2) {
                            double rf = (double)(val >> 11) / 31.0;
                            double gf = (double)(val >> 5 & 0x3F) / 63.0;
                            double bf = (double)(val & 0x1F) / 31.0;
                            int r = (int)(rf * 255.0 + 0.5);
                            int g = (int)(gf * 255.0 + 0.5);
                            int b = (int)(bf * 255.0 + 0.5);
                            rgb = alpha << 24 | r << 16 | g << 8 | b;
                        } else if (byteWidth == 1) {
                            rgb = alpha << 24 | val << 16 | val << 8 | val;
                        }
                        image.setRGB(col, row, rgb);
                    }
                }
                icon.image = new ImageIcon(image);
                if (index == 8) {
                    this.userIcons.put(i, icon);
                    this.savedUserIcons.put(i, new GeneralFunction.RMIcon(icon));
                    continue;
                }
                if (index != 9) continue;
                this.sysIcons.put(i, icon);
            }
            if (index == 9) {
                Hex hex;
                file.hex = hex = new Hex(this.data, fileStart, iconEnd);
                this.ssdFiles.put(name, file);
            }
            info.fileEnd = pos = fileStart + iconEnd;
        }
        this.setIcons(items.iconrefMap);
        if (this.deviceButtonList == null) {
            this.deviceButtonList = new ArrayList<DeviceButton>();
        }
    }

    private void setIcons(LinkedHashMap<GeneralFunction, Integer> iconrefMap) {
        for (GeneralFunction gf : iconrefMap.keySet()) {
            Integer iconref = iconrefMap.get(gf);
            GeneralFunction.RMIcon icon = this.sysIcons.get(iconref);
            if (icon == null) {
                icon = this.userIcons.get(iconref);
            }
            if (icon != null) {
                gf.icon = icon;
                continue;
            }
            if (gf.icon == null) continue;
            gf.icon.ref = iconref;
        }
    }

    public String getString8(short[] data, int pos) {
        int len = data[pos++];
        char[] ch = new char[len];
        for (int i = 0; i < len; ++i) {
            ch[i] = (char)data[pos++];
        }
        return new String(ch);
    }

    public String getString16(short[] data, int pos, int len) {
        char[] ch = new char[len / 2];
        for (int i = 0; i < len; i += 2) {
            ch[i / 2] = (char)(data[pos + i] + 256 * data[pos + i + 1]);
        }
        return new String(ch);
    }

    public String getChannel(short[] data, int pos, int width) {
        int len = 2 * data[pos++];
        int dot = -1;
        String channel = "";
        for (int i = 0; i < len; ++i) {
            int n = data[pos + i / 2] >> (i % 2 << 2) & 0xF;
            char ch = (char)(n + 48);
            if (n >= 10) {
                dot = i;
                ch = '.';
            }
            channel = ch + channel;
        }
        int chStart = len - (width + dot + 1);
        return channel.substring(chStart);
    }

    private boolean decodeRegion(Items items, String tag, short[] data, int pos, boolean start) {
        if (start) {
            if (tag.equals("device")) {
                int len = data[pos++] - 1;
                items.category = data[pos++];
                this.deviceCategories.put(items.category, this.getString16(data, pos, len));
            } else if (tag.equals("region")) {
                this.region = this.getString8(data, pos);
            } else if (tag.equals("brand")) {
                String brand = this.getString8(data, pos);
                List<String> brands = this.categoryBrands.get(items.category);
                if (brands == null) {
                    brands = new ArrayList<String>();
                    this.categoryBrands.put(items.category, brands);
                }
                items.brandIndex = brands.size();
                brands.add(brand);
            } else {
                if (tag.equals("codesets")) {
                    items.codeset_base = pos - 1;
                    return false;
                }
                if (tag.equals("codeset_offset")) {
                    int len = data[pos++];
                    int address = 0;
                    for (int i = 0; i < len; ++i) {
                        address <<= 8;
                        address |= data[pos++];
                    }
                    address += items.codeset_base + 1;
                    len = items.irdb[address++];
                    short type = items.irdb[address++];
                    int code = 0;
                    for (int i = 0; i < len - 1; ++i) {
                        code *= 10;
                        code += items.irdb[address++] & 0xF;
                    }
                    items.codes.add(code |= type << 16);
                }
            }
        } else if (tag.equals("brand")) {
            int len = items.codes.size();
            for (int i = 0; i < len; ++i) {
                int location = items.category << 24 | items.brandIndex << 16 | i + 1 << 8 | len;
                this.codeLocations.put(items.codes.get(i), location);
            }
            items.codes.clear();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean decodeItem(Items items, int fileIndex, String tag, short[] data, int pos, boolean start, boolean dbOnly) {
        block219: {
            block224: {
                block223: {
                    block222: {
                        block221: {
                            block220: {
                                block218: {
                                    KeySpec ks;
                                    int size;
                                    Function f;
                                    int serial;
                                    char[] ch;
                                    if (fileIndex < 0) {
                                        return this.decodeRegion(items, tag, data, pos, start);
                                    }
                                    if (fileIndex < 1 || fileIndex > 6 || fileIndex > 2 && dbOnly) {
                                        return true;
                                    }
                                    int ndx = 0;
                                    if (!start) break block218;
                                    if (tag.equals("device")) {
                                        void var12_72;
                                        short len = data[pos++];
                                        int dev = 80 + data[pos++];
                                        ch = new char[len / 2];
                                        boolean bl = false;
                                        while (var12_72 < len - 1) {
                                            ch[var12_72 / 2] = (char)(data[pos + var12_72] + 256 * data[pos + var12_72 + 1]);
                                            var12_72 += 2;
                                        }
                                        String string = new String(ch);
                                        items.db = this.remote.getDeviceButton(dev);
                                        items.dbList.add(items.db);
                                        items.db.setName(string);
                                        new Segment(0, 255, new Hex(15), items.db);
                                    } else {
                                        ndx = Arrays.asList("brand", "model", "remotemodel").indexOf(tag);
                                        if (ndx >= 0) {
                                            short len = data[pos];
                                            Segment seg = items.db.getSegment();
                                            int oldLen = seg.getHex().length();
                                            Hex hex = new Hex(seg.getHex(), 0, oldLen + len);
                                            for (int i = 0; i < len + 1; ++i) {
                                                hex.getData()[oldLen - 3 + ndx + i] = (short)(data[pos++] & 0xFF);
                                            }
                                            seg.setHex(hex);
                                        } else if (tag.equals("volumemaster")) {
                                            items.db.setVpt(2);
                                        } else if (tag.equals("volumelock")) {
                                            if (items.db.getVpt() != 2) {
                                                items.db.setVpt(1);
                                            }
                                        } else if (tag.equals("iconref")) {
                                            ++pos;
                                            if (fileIndex == 2) {
                                                if (items.key != null) {
                                                    items.key.iconref = data[pos++];
                                                } else {
                                                    items.iconrefMap.put(items.db, Integer.valueOf(data[pos++]));
                                                }
                                            } else if (fileIndex == 3 || fileIndex == 4) {
                                                if (items.key != null && items.activity.getButton() != items.key.btn) {
                                                    items.key.iconref = data[pos++];
                                                } else {
                                                    items.iconrefMap.put(items.activity, Integer.valueOf(data[pos++]));
                                                }
                                            } else if (fileIndex == 5) {
                                                items.iconrefMap.put(items.fav, Integer.valueOf(data[pos++]));
                                            }
                                        } else if (tag.equals("favoritewidth")) {
                                            int n = ++pos;
                                            ++pos;
                                            items.db.setFavoritewidth(data[n]);
                                        } else if (tag.equals("enterkey")) {
                                            int n = ++pos;
                                            ++pos;
                                            Button favFinalKey = this.remote.getButton(data[n]);
                                            if (favFinalKey == null || favFinalKey != null && favFinalKey.getKeyCode() == 255) {
                                                favFinalKey = Button.noButton;
                                            }
                                            if (favFinalKey != null && favFinalKey != Button.noButton) {
                                                items.db.setFavFinalKey(favFinalKey);
                                            }
                                        } else if (tag.equals("codeset")) {
                                            short len = data[pos++];
                                            short[] segData = items.db.getSegment().getHex().getData();
                                            short typeIndex = data[pos++];
                                            items.db.setDeviceTypeIndex(typeIndex, segData);
                                            char[] cArray = new char[len - 1];
                                            for (int i = 0; i < len - 1; ++i) {
                                                cArray[i] = (char)data[pos++];
                                            }
                                            String str = new String(cArray);
                                            int code = -1;
                                            try {
                                                code = Integer.parseInt(str);
                                            }
                                            catch (NumberFormatException e) {
                                                items.db.setConstructed(true);
                                                System.err.println("Malformed setup code " + str + " at " + Integer.toHexString(pos - 4));
                                            }
                                            items.setupCode = code;
                                            items.db.setSetupCode((short)items.setupCode, segData);
                                        } else if (tag.equals("keydef") || tag.equals("irdef")) {
                                            items.key = new Key();
                                        } else if (tag.equals("language")) {
                                            items.lastTag = "language";
                                            this.language = this.getString8(data, pos);
                                        } else if (tag.equals("region")) {
                                            items.lastTag = "region";
                                            this.region = this.getString8(data, pos);
                                        } else if (tag.equals("directv_rf")) {
                                            short len = data[pos++];
                                            this.directv_rf = new Hex(data, pos, (int)len);
                                        } else if (tag.equals("filename")) {
                                            Setting s;
                                            int i;
                                            String name = this.getString8(data, pos);
                                            if (items.lastTag.equals("language")) {
                                                this.languageFilename = name;
                                                String languageCode = name.substring(5);
                                                for (i = 0; i < languageCodes.length; ++i) {
                                                    String[] stringArray = languageCodes[i];
                                                    if (!stringArray[1].equals(languageCode)) continue;
                                                    this.language = stringArray[0];
                                                    s = this.remote.getSetting("Language");
                                                    if (s == null) continue;
                                                    s.setValue(i);
                                                }
                                            } else if (items.lastTag.equals("region")) {
                                                this.regionFilename = name;
                                                String regionName = name.substring(0, this.regionFilename.length() - 4);
                                                for (i = 0; i < regionNames.length; ++i) {
                                                    String[] stringArray = regionNames[i];
                                                    if (!stringArray[1].equalsIgnoreCase(regionName)) continue;
                                                    this.region = stringArray[0];
                                                    s = this.remote.getSetting("Region");
                                                    if (s == null) continue;
                                                    s.setValue(i);
                                                }
                                            }
                                            items.lastTag = null;
                                        }
                                    }
                                    if (dbOnly) {
                                        return true;
                                    }
                                    if (tag.equals("favorites")) {
                                        items.activity = this.remote.getFavKey() != null ? this.remote.getFavKey().getActivity() : null;
                                    } else if (tag.equals("activity")) {
                                        void var12_81;
                                        short len = data[pos++];
                                        int keyCode = 240 + data[pos++];
                                        ch = new char[len / 2];
                                        boolean bl = false;
                                        while (var12_81 < len - 1) {
                                            ch[var12_81 / 2] = (char)(data[pos + var12_81] + 256 * data[pos + var12_81 + 1]);
                                            var12_81 += 2;
                                        }
                                        String string = new String(ch);
                                        Button btn = this.remote.getButton(keyCode);
                                        items.key = new Key();
                                        items.key.btn = btn;
                                        items.key.keycode = keyCode;
                                        items.activity = this.activities.get(btn);
                                        items.activity.setActive(true);
                                        items.activity.setSelector(btn);
                                        items.activity.setName(string);
                                        items.activity.getAssists().clear();
                                        items.activity.icon = new GeneralFunction.RMIcon(5);
                                        items.activities.add(items.activity);
                                    } else if (tag.equals("profile")) {
                                        void var12_84;
                                        short len = data[pos++];
                                        short profileIndex = data[pos++];
                                        ch = new char[len / 2];
                                        boolean bl = false;
                                        while (var12_84 < len - 1) {
                                            ch[var12_84 / 2] = (char)(data[pos + var12_84] + 256 * data[pos + var12_84 + 1]);
                                            var12_84 += 2;
                                        }
                                        String string = new String(ch);
                                        items.activity = this.remote.getFavKey().createProfile(string, profileIndex, this.remote);
                                    } else if (tag.equals("favorite")) {
                                        void var12_87;
                                        short len = data[pos++];
                                        serial = data[pos++];
                                        ch = new char[len / 2];
                                        boolean bl = false;
                                        while (var12_87 < len - 1) {
                                            ch[var12_87 / 2] = (char)(data[pos + var12_87] + 256 * data[pos + var12_87 + 1]);
                                            var12_87 += 2;
                                        }
                                        String string = new String(ch);
                                        items.fav = new FavScan(this.remote.getFavKey().getKeyCode(), null, null);
                                        items.fav.icon = new GeneralFunction.RMIcon(6);
                                        items.fav.setSerial(serial);
                                        items.fav.setName(string);
                                        items.fav.setProfileIndices(new ArrayList<Integer>());
                                        this.favScans.add(items.fav);
                                    } else if (tag.equals("profileindex")) {
                                        int n = ++pos;
                                        ++pos;
                                        items.fav.getProfileIndices().add(Integer.valueOf(data[n]));
                                    } else if (tag.equals("deviceid")) {
                                        int n = ++pos;
                                        ++pos;
                                        items.fav.setDeviceButton(this.remote.getDeviceButton(data[n] + 80));
                                    } else if (tag.equals("channelnumber")) {
                                        String channel = this.getChannel(data, pos, items.fav.getDeviceButton().getFavoriteWidth());
                                        items.fav.setChannel(channel);
                                    } else if (tag.equals("codeset")) {
                                        short[] segData = items.db.getSegment().getHex().getData();
                                        int typeIndex = items.db.getDeviceTypeIndex(segData);
                                        items.upgrade = new DeviceUpgrade(new String[0]);
                                        items.upgrade.setRemote(this.remote);
                                        items.upgrade.setButtonIndependent(false);
                                        items.upgrade.setButtonRestriction(items.db);
                                        items.upgrade.setRemoteConfig(this);
                                        items.db.setUpgrade(items.upgrade);
                                        items.alias = this.remote.getDeviceTypeAlias(this.remote.getDeviceTypeByIndex(typeIndex));
                                        this.devices.add(items.upgrade);
                                        items.keys = new ArrayList<Key>();
                                    } else if (tag.equals("prefix")) {
                                        short len = data[pos++];
                                        items.fixedData = new Hex(len);
                                        items.upgrade.setSizeDevBytes(len);
                                        System.arraycopy(data, pos, items.fixedData.getData(), 0, len);
                                    } else if (tag.equals("executor")) {
                                        short len = data[pos++];
                                        items.pid = new Hex(2);
                                        if (len == 2) {
                                            items.pid.set(data[pos++], 1);
                                            items.pid.set(data[pos++], 0);
                                        }
                                    } else if (tag.equals("keydef")) {
                                        items.keys.add(items.key);
                                        int n = ++pos;
                                        ++pos;
                                        items.key.keycode = data[n];
                                        if (items.softPageIndex != null) {
                                            items.key.keycode += 6 * items.softPageIndex;
                                        }
                                        items.key.btn = this.remote.getButton(items.key.keycode);
                                    } else if (tag.equals("keygid")) {
                                        short len;
                                        if ((len = data[pos++]) == 2) {
                                            items.key.keygid = data[pos] + 256 * data[pos + 1];
                                        }
                                    } else if (tag.equals("keyflags")) {
                                        int n = ++pos;
                                        ++pos;
                                        items.key.keyflags = data[n];
                                    } else if (tag.equals("irdata")) {
                                        short len = data[pos++];
                                        items.key.irdata = new Hex(len);
                                        System.arraycopy(data, pos, items.key.irdata.getData(), 0, len);
                                        int currentSize = items.upgrade.getSizeCmdBytes();
                                        if (currentSize == 0) {
                                            items.upgrade.setSizeCmdBytes(len);
                                        } else if (!items.upgrade.isInconsistent() && currentSize != len) {
                                            items.upgrade.setInconsistent(true);
                                        }
                                    } else if (tag.equals("learnedkey")) {
                                        Hex header = Hex.subHex(data, pos += 2, 7);
                                        System.err.println("Learned header: " + items.db.getName() + "/" + items.key.bname + ": " + header);
                                        pos += 7;
                                        short len = data[pos++];
                                        Hex hex = Hex.subHex(data, pos, len);
                                        LearnedSignal learnedSignal = items.upgrade.getNewLearnedSignal(items.key.keycode, items.db.getButtonIndex(), 0, hex, null);
                                        learnedSignal.setHeader(header);
                                        items.key.ls = learnedSignal;
                                        this.learned.add(learnedSignal);
                                        items.key.inLS = true;
                                    } else if (tag.equals("name8")) {
                                        String name = this.getString8(data, pos);
                                        if (items.key.inLS) {
                                            items.key.lname = name;
                                        } else {
                                            items.key.bname = name;
                                            if (items.db != null) {
                                                items.db.getGeneralFunction(items.key.btn).setName(name);
                                            }
                                        }
                                    } else if (tag.equals("macroref")) {
                                        int ref = data[++pos] + 256 * data[pos + 1];
                                        pos += 2;
                                        items.key.macroref = ref;
                                        Macro macro = items.macroMap.get(ref);
                                        if (macro != null && items.db != null) {
                                            macro.addReference(items.db, this.remote.getButton(items.key.keycode));
                                        } else {
                                            macro = new Macro(items.key.keycode, null, null);
                                            macro.setSerial(ref);
                                            macro.setMacroClass(Macro.MacroClass.REALTIME);
                                            macro.setItems(new ArrayList<KeySpec>());
                                            items.macroMap.put(ref, macro);
                                            if (items.db != null) {
                                                macro.setDeviceButtonIndex(items.db.getButtonIndex());
                                                macro.addReference(items.db, this.remote.getButton(items.key.keycode));
                                            } else if (items.activity != null) {
                                                macro.setAssists(new LinkedHashMap<Integer, List<Activity.Assister>>());
                                                for (int i = 0; i < 3; ++i) {
                                                    macro.getAssists().put(i, new ArrayList());
                                                }
                                                items.activity.setMacro(macro);
                                                macro.setDeviceButtonIndex(items.key.keycode);
                                                macro.setActivity(items.activity);
                                            }
                                        }
                                    } else if (tag.equals("objcode")) {
                                        short len = data[pos++];
                                        items.pCode = new Hex(len);
                                        System.arraycopy(data, pos, items.pCode.getData(), 0, len);
                                        RemoteConfiguration.decryptObjcode(items.pCode);
                                    } else if (tag.equals("irdef")) {
                                        items.keys.add(items.key);
                                        items.key.irserial = data[++pos] + 256 * data[pos + 1];
                                    } else if (tag.equals("macro")) {
                                        int ref = data[++pos] + 256 * data[pos + 1];
                                        items.macro = items.macroMap.get(ref);
                                        for (Activity activity : this.activities.values()) {
                                            if (!activity.isActive() || activity.getMacro() == null || activity.getMacro().getSerial() != ref) continue;
                                            items.activity = activity;
                                            items.macro = activity.getMacro();
                                        }
                                        if (items.macro == null) {
                                            System.err.println("Macro with reference 0x" + Integer.toHexString(ref) + " is unassigned");
                                            Macro macro = new Macro(0, null, null);
                                            macro.setSerial(ref);
                                            macro.setMacroClass(Macro.MacroClass.REALTIME);
                                            items.macroMap.put(ref, macro);
                                            items.macro = macro;
                                            items.unreferencedMacros.add(macro);
                                        }
                                        this.macros.add(items.macro);
                                        items.macro.setItems(new ArrayList<KeySpec>());
                                    } else if (tag.equals("issystemmacro")) {
                                        int n = ++pos;
                                        ++pos;
                                        items.macro.setSystemMacro(data[n] == 1);
                                    } else if (tag.equals("name16")) {
                                        int len = data[pos++];
                                        char[] ch3 = new char[len / 2];
                                        for (int i = 0; i < len; i += 2) {
                                            ch3[i / 2] = (char)(data[pos + i] + 256 * data[pos + i + 1]);
                                        }
                                        items.macro.setName(new String(ch3).trim());
                                    } else if (tag.equals("sendhardkey")) {
                                        int n = ++pos;
                                        DeviceButton db = this.remote.getDeviceButton(80 + data[n]);
                                        int n2 = ++pos;
                                        ++pos;
                                        Button b = this.remote.getButton(data[n2]);
                                        items.macro.getItems().add(new KeySpec(db, b));
                                    } else if (tag.equals("sendsoftkey")) {
                                        int n = ++pos;
                                        DeviceButton db = this.remote.getDeviceButton(80 + data[n]);
                                        int n3 = ++pos;
                                        short softIndex = data[n3];
                                        int n4 = ++pos;
                                        ++pos;
                                        Button b = this.remote.getButton(data[n4] + 6 * softIndex);
                                        items.macro.getItems().add(new KeySpec(db, b));
                                    } else if (tag.equals("sendir")) {
                                        int n = ++pos;
                                        DeviceButton db = this.remote.getDeviceButton(80 + data[n]);
                                        serial = data[++pos] + 256 * data[pos + 1];
                                        if (db.getUpgrade() != null) {
                                            f = db.getUpgrade().getFunctionMap().get(serial);
                                            items.macro.getItems().add(new KeySpec(db, f));
                                        } else {
                                            System.err.println("Macro serial " + items.macro.serial + " has sendir on unset device $" + Integer.toHexString(db.getButtonIndex()));
                                        }
                                    } else if (tag.equals("duration")) {
                                        int duration = (data[++pos] + 256 * data[pos + 1]) / 100;
                                        size = items.macro.getItems().size();
                                        if (size > 0) {
                                            ks = items.macro.getItems().get(size - 1);
                                            ks.duration = duration;
                                        }
                                    } else if (tag.equals("delay")) {
                                        ++pos;
                                        if (fileIndex == 5) {
                                            this.remote.getFavKey().setFavPause(data[pos++]);
                                        } else {
                                            int delay = data[pos++];
                                            size = items.macro.getItems().size();
                                            if (size > 0) {
                                                ks = items.macro.getItems().get(items.macro.getItems().size() - 1);
                                                ks.delay = delay;
                                            }
                                        }
                                    } else if (tag.equals("assistant")) {
                                        if (items.macro != null) {
                                            items.macro.setAssists(new LinkedHashMap<Integer, List<Activity.Assister>>());
                                            for (int i = 0; i < 3; ++i) {
                                                items.macro.getAssists().put(i, new ArrayList());
                                            }
                                        }
                                    } else if (tag.equals("pictureinputs")) {
                                        items.assisters = items.macro.getAssists().get(0);
                                    } else if (tag.equals("audioinputs")) {
                                        items.assisters = items.macro.getAssists().get(1);
                                    } else if (tag.equals("powerkeys")) {
                                        items.assisters = items.macro.getAssists().get(2);
                                    } else if (tag.equals("hardkey")) {
                                        int n = ++pos;
                                        DeviceButton dev = this.remote.getDeviceButton(80 + data[n]);
                                        int n5 = ++pos;
                                        ++pos;
                                        Button btn = this.remote.getButton(data[n5]);
                                        if (dev != null && btn != null) {
                                            items.assisters.add(new Activity.Assister(dev, btn));
                                        }
                                    } else if (tag.equals("softkey")) {
                                        int n = ++pos;
                                        DeviceButton dev = this.remote.getDeviceButton(80 + data[n]);
                                        int n6 = ++pos;
                                        short softpage = data[n6];
                                        int n7 = ++pos;
                                        ++pos;
                                        Button btn = this.remote.getButton(data[n7] + 6 * softpage);
                                        if (dev != null && btn != null) {
                                            items.assisters.add(new Activity.Assister(dev, btn));
                                        }
                                    } else if (tag.equals("irref")) {
                                        int n = ++pos;
                                        DeviceButton dev = this.remote.getDeviceButton(80 + data[n]);
                                        int ref = data[++pos] + 256 * data[pos + 1];
                                        if (dev.getUpgrade() != null) {
                                            f = dev.getUpgrade().getFunctionMap().get(ref);
                                            if (dev != null && f != null) {
                                                items.assisters.add(new Activity.Assister(dev, f));
                                            }
                                        }
                                    } else if (tag.equals("punchthrumap")) {
                                        items.map = new LinkedHashMap();
                                    } else if (tag.equals("punchthruspec")) {
                                        Button button;
                                        items.key = new Key();
                                        int offset = items.softPageIndex == null ? 0 : 6 * items.softPageIndex;
                                        int n = ++pos;
                                        DeviceButton dev = this.remote.getDeviceButton(data[n] | 0x50);
                                        int n8 = ++pos;
                                        Button target = this.remote.getButton(data[n8] + offset);
                                        int n9 = ++pos;
                                        ++pos;
                                        items.key.btn = button = this.remote.getButton(data[n9] + offset);
                                        items.key.keycode = button.getKeyCode();
                                        if (dev != null && target != null && button != null) {
                                            items.map.put(button, new KeySpec(dev, target));
                                        }
                                    } else if (tag.equals("softpage")) {
                                        int n = ++pos;
                                        ++pos;
                                        items.softPageIndex = data[n];
                                    }
                                    break block219;
                                }
                                if (tag.equals("devices")) {
                                    this.deviceButtonList = new ArrayList<DeviceButton>();
                                    this.deviceButtonList.addAll(items.dbList);
                                } else if (tag.equals("favorites")) {
                                    Activity.Assister.setFunctions(items.activity.getAssists(), this.remote);
                                    items.activity = null;
                                } else if (tag.equals("device")) {
                                    items.db = null;
                                    items.key = null;
                                } else if (tag.equals("favorite")) {
                                    items.fav = null;
                                    items.key = null;
                                } else if (tag.equals("activity")) {
                                    Activity.Assister.setFunctions(items.activity.getAssists(), this.remote);
                                    for (ActivityGroup activityGroup : items.activity.getActivityGroups()) {
                                        if (activityGroup.getTargetKeyCode() <= 0) continue;
                                        activityGroup.setTarget(activityGroup.getDevice().getUpgrade().getMacroMap().get(activityGroup.getTargetKeyCode()));
                                    }
                                    items.activity = null;
                                    items.key = null;
                                } else if (tag.equals("profile")) {
                                    Activity.Assister.setFunctions(items.activity.getAssists(), this.remote);
                                    items.activity = null;
                                    items.key = null;
                                }
                                if (dbOnly) {
                                    return true;
                                }
                                if (!tag.equals("codeset")) break block220;
                                try {
                                    if (!items.db.isConstructed()) {
                                        if (items.fixedData == null) {
                                            items.fixedData = new Hex(0);
                                        }
                                        Hex hex = new Hex(items.pid, 0, items.fixedData.length() + 3);
                                        hex.put(items.fixedData, 3);
                                        hex.set((short)1, 2);
                                        System.err.println();
                                        System.err.println("Setup code=" + items.alias + "/" + items.setupCode);
                                        items.upgrade.importRawUpgrade(hex, this.remote, items.alias, items.pid, items.pCode);
                                    } else {
                                        items.upgrade.protocol = null;
                                    }
                                    items.upgrade.setSetupCode(items.setupCode);
                                    for (Key key : items.keys) {
                                        Function f1;
                                        void var12_97;
                                        if (key.keygid == null && key.ls == null && key.macroref == null) continue;
                                        String name = key.bname;
                                        if (name == null && (key.ls == null || key.ls.getName() == null)) {
                                            name = "__missing" + items.missingIndex++;
                                        }
                                        if (key.ls != null && key.ls.getName() == null) {
                                            key.ls.setName(name);
                                        }
                                        if (key.btn != null && key.iconref != null) {
                                            GeneralFunction generalFunction = items.db.getGeneralFunction(key.btn);
                                            items.iconrefMap.put(generalFunction, key.iconref);
                                        }
                                        if (key.keygid == null && key.macroref == null) continue;
                                        Object var12_94 = null;
                                        if (key.keygid != null) {
                                            Function function = items.upgrade.getKeyGidMap().get(key.keygid);
                                            if (key.keygid == 0 || function != null && !key.irdata.equals(function.getHex())) {
                                                int newGID = items.upgrade.getGidForName(key.bname);
                                                key.keygid = newGID;
                                            }
                                            Function function2 = new Function(name);
                                            function2.setUpgrade(items.upgrade);
                                            function2.setKeyflags(key.keyflags);
                                            function2.setHex(key.irdata);
                                            function2.setGid(key.keygid);
                                            items.upgrade.getKeyGidMap().put(key.keygid, function2);
                                            items.upgrade.getFunctions().add(function2);
                                            this.addGid(name, key.keygid);
                                        }
                                        if (key.irserial >= 0) {
                                            var12_97.setSerial(key.irserial);
                                            items.upgrade.getFunctionMap().put(key.irserial, (Function)var12_97);
                                        }
                                        if (key.btn != null && ((f1 = items.upgrade.getAssignments().getAssignment(key.btn)) == null || f1.getGid() != key.keygid)) {
                                            items.upgrade.getAssignments().assign(key.btn, (Function)var12_97);
                                        }
                                        if (var12_97 == null) continue;
                                        System.err.println("Upg=" + var12_97.upgrade + " Fn=" + var12_97.name + " Serial=" + var12_97.getSerial() + " Btn" + key.btn + " Data=" + var12_97.getData());
                                    }
                                }
                                catch (ParseException pe) {
                                    pe.printStackTrace(System.err);
                                }
                                items.missingIndex = 0;
                                items.upgrade = null;
                                items.keys = null;
                                items.pCode = null;
                                break block219;
                            }
                            if (!tag.equals("keydef")) break block221;
                            String fname = items.key.bname;
                            String lname = items.key.lname;
                            if (fname != null && lname != null && !fname.equals(lname)) {
                                items.key.ls.setName(lname);
                            } else if (fname != null && items.key.ls != null) {
                                items.key.ls.setName(fname);
                            }
                            items.key = null;
                            break block219;
                        }
                        if (!tag.equals("macro")) break block222;
                        if (items.macro.getActivity() != null && items.macro.getItems() != null && items.macro.getItems().size() > 0) {
                            Button b = items.macro.getActivity().getSelector();
                            DeviceButton db = null;
                            String s = "";
                            for (KeySpec ks : items.macro.getItems()) {
                                if (ks.db.getUpgrade() == null) {
                                    if (s.isEmpty()) {
                                        s = "The following items have been deleted from Activity Macro \"" + items.macro.getName() + "\"\nas the Device is undefined:\n";
                                    }
                                    s = s + ks.toString();
                                    continue;
                                }
                                if (db != null) continue;
                                db = ks.db;
                            }
                            if (db != null) {
                                items.macro.addReference(db, b);
                            }
                            if (!s.isEmpty()) {
                                JOptionPane.showMessageDialog(null, s, "Activity Error", 0);
                            }
                        }
                        items.macro = null;
                        items.activity = null;
                        items.assisters = null;
                        break block219;
                    }
                    if (!tag.equals("learnedkey")) break block223;
                    items.key.inLS = false;
                    break block219;
                }
                if (!tag.equals("macros")) break block224;
                Iterator<Highlight> it = this.macros.iterator();
                while (it.hasNext()) {
                    KeySpec ks;
                    Macro macro;
                    block226: {
                        block225: {
                            macro = it.next();
                            ks = null;
                            if (items.unreferencedMacros.contains(macro)) break block225;
                            if (!macro.isSystemMacro()) break block226;
                            if (macro.getItems().size() == 0) break block225;
                            ks = macro.getItems().get(0);
                            if (ks.btn != null || ks.fn != null) break block226;
                        }
                        it.remove();
                        if (ks == null) continue;
                        System.err.println("Deleting null system macro: Serial=" + macro.getSerial() + ", Name=" + macro.getName() + ", device=" + ks.db);
                        continue;
                    }
                    for (GeneralFunction.User u : macro.getUsers()) {
                        u.db.getUpgrade().getMacroMap().put(Integer.valueOf(u.button.getKeyCode()), macro);
                    }
                    if (macro.isSystemMacro()) {
                        void var12_103;
                        GeneralFunction generalFunction = ks.fn;
                        if (generalFunction == null) {
                            GeneralFunction generalFunction2 = ks.db.getUpgrade().getGeneralFunction(ks.btn.getKeyCode(), false);
                            if (generalFunction2 != null) {
                                ks.fn = generalFunction2;
                                ks.btn = null;
                            } else {
                                System.err.println("Unknown function in system macro: Serial=" + macro.getSerial() + ", Name=" + macro.getName() + ", device=" + ks.db + ", button=" + ks.btn);
                            }
                        }
                        if (var12_103 == null) continue;
                        var12_103.getUsers().addAll(macro.getUsers());
                        continue;
                    }
                    for (KeySpec k : macro.getItems()) {
                        if (k.btn != null || k.fn == null) continue;
                        k.btn = k.getButton();
                        if (k.btn == null) continue;
                        k.fn = null;
                    }
                }
                break block219;
            }
            if (tag.equals("activities")) {
                for (Activity a : this.activities.values()) {
                    if (items.activities.contains(a)) continue;
                    items.activities.add(a);
                }
                this.activities.clear();
                for (Activity a : items.activities) {
                    this.activities.put(a.getButton(), a);
                }
            } else if (tag.equals("punchthrumap")) {
                for (Iterator<Highlight> iterator : items.activity.getActivityGroups()) {
                    Button[] buttonGroup = ((ActivityGroup)((Object)iterator)).getButtonGroup();
                    if (buttonGroup == null || buttonGroup.length <= 0) continue;
                    Button btn = buttonGroup[0];
                    KeySpec ks = items.map.get(btn);
                    ((ActivityGroup)((Object)iterator)).setDevice(ks != null ? ks.db : null);
                    if (ks == null || ks.btn == null || ks.btn == btn) continue;
                    ((ActivityGroup)((Object)iterator)).setTargetKeyCode(ks.btn.getKeyCode());
                }
                items.map = null;
            } else if (tag.equals("punchthruspec")) {
                KeySpec ks = items.map.get(items.key.btn);
                if (ks == null || ks.db == null) {
                    System.err.println("Missing keyspec or device in punchthruspec");
                }
                DeviceUpgrade upg = ks.db.getUpgrade();
                Function f = null;
                if (upg == null) {
                    System.err.println("Malformed punchthruspec");
                } else {
                    f = upg.getAssignments().getAssignment(items.key.btn);
                    if (f == null && items.key.bname != null) {
                        f = new Function(items.key.bname);
                        f.setUpgrade(upg);
                        upg.getAssignments().assign(items.key.btn, f);
                    }
                }
            } else if (tag.equals("softpage")) {
                items.softPageIndex = null;
            }
        }
        return true;
    }

    private int parseXCFFile(Items items, int fileIndex, short[] data, int fileStart, List<String> tagNames, boolean decode) {
        int pos = fileStart;
        ArrayList<Integer> tags = new ArrayList<Integer>();
        boolean more = true;
        while (more) {
            short tag;
            if (((tag = data[pos++]) & 0x80) == 0) {
                if (fileIndex == 0 && tag > 1 && tags.size() == 3) {
                    tags.remove(0);
                }
                tags.add(0, Integer.valueOf(tag));
                more = this.decodeItem(items, fileIndex, tagNames.get(tag), data, pos, true, !decode);
                short len = data[pos++];
                pos += len;
                continue;
            }
            int last = (Integer)tags.remove(0);
            if (tag != (last | 0x80)) {
                System.err.println("XCF file nesting error at " + Integer.toHexString(pos - 1));
                break;
            }
            more = this.decodeItem(items, fileIndex, tagNames.get(tag & 0x7F), data, pos, false, !decode);
            if (!tags.isEmpty()) continue;
            break;
        }
        return pos;
    }

    private void simplifyXCFFile(SSDFile file) {
        int pos = 0;
        ArrayList<Integer> tags = new ArrayList<Integer>();
        short[] filedata = file.hex.getData();
        this.tagList = new ArrayList<String>();
        while (pos < filedata.length) {
            short tag;
            if (((tag = filedata[pos++]) & 0x80) == 0) {
                tags.add(0, Integer.valueOf(tag));
                String tagName = file.tagNames.get(tag);
                filedata[pos - 1] = this.getTag(tagName);
                pos += pos < filedata.length ? filedata[pos] + 1 : 0;
                continue;
            }
            int last = (Integer)tags.remove(0);
            if (tag != (last | 0x80)) {
                System.err.println("XCF file nesting error at " + Integer.toHexString(pos - 1));
                break;
            }
            String tagName = file.tagNames.get(tag & 0x7F);
            filedata[pos - 1] = (short)(this.getTag(tagName) | 0x80);
            if (!tags.isEmpty()) continue;
            break;
        }
        file.tagNames.clear();
        file.tagNames.addAll(this.tagList);
        file.prefix = new Hex("ezrc    ", 8);
    }

    public static void decryptObjcode(Hex code) {
        for (int i = 0; i < code.length(); ++i) {
            short[] sArray = code.getData();
            int n = i;
            sArray[n] = (short)(sArray[n] ^ (short)encryptionKey[i % 54]);
        }
    }

    public static Hex encryptObjcode(Hex code) {
        Hex hex = new Hex(code);
        for (int i = 0; i < hex.length(); ++i) {
            short[] sArray = hex.getData();
            int n = i;
            sArray[n] = (short)(sArray[n] ^ (short)encryptionKey[i % 54]);
        }
        return hex;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void loadSegments(boolean decode) {
        pos = this.remote.getE2FormatOffset() >= 0 ? 20 : 2;
        segLength = 0;
        segType = 0;
        this.segmentLoadOrder.addAll(this.remote.getSegmentTypes());
        this.segmentBackups = null;
        while (pos < this.remote.getEepromSize() && (segLength = Hex.get(this.data, pos)) <= this.remote.getEepromSize() - pos && segLength >= 4) {
            segType = this.data[pos + 2];
            segFlags = this.data[pos + 3];
            segData = new Hex(this.data, pos + 4, segLength - 4);
            if (segFlags == 255 && (segType == 27 || segType == 205 && segLength > 18)) {
                this.isReplacement = true;
            }
            pos += segLength;
            if (!this.segmentLoadOrder.contains(segType)) {
                this.segmentLoadOrder.add(segType);
            }
            if ((segFlags & 128) == 0 || segType == 221 && !this.remote.getSegmentTypes().contains(221)) {
                if (segFlags != 95) continue;
                if (this.segmentBackups == null) {
                    this.segmentBackups = new LinkedHashMap<K, V>();
                }
                if ((list = this.segmentBackups.get(segType)) == null) {
                    list = new ArrayList<Segment>();
                }
                list.add(new Segment(segType, segFlags, segData));
                this.segmentBackups.put(segType, list);
                continue;
            }
            list = this.segments.get(segType);
            if (list == null) {
                list = new ArrayList<Segment>();
            }
            list.add(new Segment(segType, segFlags, segData));
            this.segments.put(segType, list);
        }
        this.remote.getCheckSums()[0].getAddressRange().setEnd(pos - 1);
        internalList = null;
        internalList = this.segments.get(27);
        if (internalList != null) {
            this.internalSegment = null;
            for (Segment segment : internalList) {
                if (segment.getFlags() == 255) {
                    this.internalSegment = segment;
                    break;
                }
                if (segment.getFlags() != 223) continue;
                this.internalSegment = segment;
            }
            if (this.internalSegment == null) {
                return;
            }
            if (this.internalSegment.getFlags() == 223) {
                seg = new Segment(27, 255, new Hex(this.internalSegment.getHex()));
                internalList.add(seg);
                this.internalSegment = seg;
            }
            this.deviceButtonNotes = Arrays.copyOf(this.deviceButtonNotes, this.remote.getDeviceButtons().length + 1);
        }
        this.setDeviceButtonSegments();
        if (this.remote.usesLedColor() && this.segments.get(46) != null && this.segments.get(46).size() > 0) {
            streamingData = this.segments.get(46).get(0);
            hex = streamingData.getHex();
            db = null;
            for (DeviceButton test : this.remote.getDeviceButtons()) {
                if (!test.isColorEditable()) continue;
                db = test;
                break;
            }
            if (db != null) {
                params = new int[3];
                for (i = 0; i < 3; ++i) {
                    params[i] = hex.getData()[i + 2];
                }
                db.setColorIndex(hex.getData()[5]);
                db.setColorParams(params);
            }
        }
        if (this.remote.getMacroSupport() == 3 && this.segments.get(2) != null) {
            for (Segment segment : this.segments.get(2)) {
                keyCode = segment.getHex().getData()[1];
                btn = this.remote.getBaseButton(keyCode);
                btn.setLegacyMulti(true);
            }
        }
        if (this.remote.hasRf4ceSupport() && this.remote.getRfSetupCodes() != null) {
            this.nib = new LinkedHashMap<K, V>();
            this.setNibSizes();
            if (this.segments.get(32) != null) {
                for (Object seg : this.segments.get(32)) {
                    nvid = seg.getHex().getData()[1];
                    this.nib.put(Integer.valueOf(nvid), seg.getHex().subHex(2, this.nibSizes.get(nvid)));
                }
            }
            if (this.segments.get(39) != null) {
                for (Object seg : this.segments.get(39)) {
                    nvid = seg.getHex().getData()[1];
                    this.nib.put(Integer.valueOf(nvid), seg.getHex().subHex(2, this.nibSizes.get(nvid)));
                }
            }
        }
        RMIRSetup.disableActivitiesItem.setSelected(this.remote.getSegmentTypes().contains(205) != false && this.remote.hasMasterPowerSupport() == false && this.segments.get(205) == null);
        if (!decode) {
            return;
        }
        macroTypes = new ArrayList<Integer>();
        macroTypes.add(1);
        if (this.remote.getSegmentTypes().contains(3)) {
            macroTypes.add(3);
        }
        if (this.remote.getSegmentTypes().contains(205) && !this.remote.hasActivityControl() && !this.remote.getSetupCodes().isEmpty()) {
            macroTypes.add(205);
        }
        seg = macroTypes.iterator();
        while (seg.hasNext()) {
            macroType = (Integer)seg.next();
            segType = macroType;
            macroList = this.segments.get(segType);
            if (macroList == null) continue;
            for (Segment segment : macroList) {
                block156: {
                    hex = segment.getHex();
                    deviceIndex = hex.getData()[0];
                    devBtn = this.remote.getButton(deviceIndex);
                    keyCode = hex.getData()[1];
                    btn = this.remote.getButton(keyCode);
                    count = Math.min(hex.getData()[2], hex.length() - 3);
                    data = hex.subHex(3, count);
                    macro = new Macro(keyCode, segType == 1 || segType == 205 ? data : null, deviceIndex, 0, null);
                    macro.setMacroClass(segType == 1 ? Macro.MacroClass.NORMAL : (segType == 205 ? Macro.MacroClass.MASTERPOWER : null));
                    macro.setSegmentFlags(segment.getFlags());
                    segment.setObject(macro);
                    if (segType != 3) break block156;
                    codeSize = this.remote.getMacroSupport();
                    if (codeSize > 2 || codeSize == 2 && !this.remote.getBaseButton(keyCode).allowsControlledMacro()) {
                        codeSize = 1;
                    }
                    macro.setItems(hex.subHex(3, 2 * count * codeSize), this.remote);
                    macro.setMacroClass(codeSize == 1 ? Macro.MacroClass.REALTIME : Macro.MacroClass.CONTROLLED);
                    if (!this.remote.usesEZRC()) break block156;
                    db = this.remote.getDeviceButton(deviceIndex);
                    macro.addReference(db, btn);
                    ks = null;
                    if (macro.getItems() == null || macro.getItems().size() != 1) ** GOTO lbl-1000
                    ks = macro.getItems().get(0);
                    if (ks.duration == 0 && ks.delay == 3) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    macro.setSystemMacro(v0);
                    if (hex.length() > 3 + 2 * count) {
                        len = hex.getData()[3 + 2 * count];
                        if (hex.length() > 5 + 2 * count + len) {
                            macro.setName(hex.subString(4 + 2 * count, len));
                            macro.setSerial((short)hex.get(4 + 2 * count + len));
                        }
                    }
                }
                if (segType == 1 && devBtn != null && this.activities != null && this.activities.get(devBtn) != null) {
                    this.activities.get(devBtn).setMacro(macro);
                    continue;
                }
                if (segType == 205 && btn != null && this.activities != null && this.activities.get(btn) != null) {
                    if (macro.getDeviceButtonIndex() == 0) {
                        macro.setDeviceButtonIndex(-1);
                    }
                    a = this.activities.get(btn);
                    a.setMacro(macro);
                    a.setSegment(segment);
                    macro.setActivity(a);
                    a.setActive(true);
                    continue;
                }
                this.setMacro(macro);
            }
        }
        multiMacroList = this.segments.get(2);
        if (multiMacroList != null) {
            for (Object segment : multiMacroList) {
                hex = segment.getHex();
                deviceIndex = hex.getData()[0];
                keyCode = hex.getData()[1];
                pos = 3;
                for (i = 0; pos < hex.length() && i < hex.getData()[2]; pos += length + 1, ++i) {
                    length = hex.getData()[pos];
                    keyCodes = hex.subHex(pos + 1, Math.min(length, hex.length() - pos - 1));
                    macro = new Macro(keyCode, keyCodes, deviceIndex, i + 1, null);
                    macro.setSegmentFlags(segment.getFlags());
                    macro.setMacroClass(Macro.MacroClass.MULTI);
                    segment.setObject(macro);
                    this.setMacro(macro);
                }
            }
        }
        if ((activityMacroList = this.segments.get(4)) != null) {
            for (Segment segment : activityMacroList) {
                hex = segment.getHex();
                deviceIndex = hex.getData()[1];
                keyCode = hex.getData()[3];
                btn = this.remote.getButton(deviceIndex);
                count = Math.min(hex.getData()[4], hex.length() - 5);
                data = hex.subHex(5, count);
                macro = new Macro(keyCode, data, deviceIndex, 0, null);
                macro.setMacroClass(Macro.MacroClass.ACTIVITYPOWER);
                macro.setSegmentFlags(segment.getFlags());
                segment.setObject(macro);
                if (btn == null || this.activities == null || this.activities.get(btn) == null) continue;
                a = this.activities.get(btn);
                a.setMacro(macro);
                macro.setActivity(a);
                a.setActive(true);
            }
        }
        if ((keyMoveKeyList = this.segments.get(7)) != null) {
            for (Segment segment : keyMoveKeyList) {
                hex = segment.getHex();
                deviceButtonIndex = hex.getData()[0];
                keyMove = new KeyMoveKey((int)hex.getData()[1], (int)deviceButtonIndex, (int)hex.getData()[2], hex.get(3), hex.getData()[5], null);
                keyMove.setSegmentFlags(segment.getFlags());
                segment.setObject(keyMove);
                this.keymoves.add(keyMove);
            }
        }
        if ((keyMoveEFCList = this.segments.get(8)) != null) {
            for (Object segment : keyMoveEFCList) {
                hex = segment.getHex();
                deviceButtonIndex = hex.getData()[0];
                if (this.remote.getAdvCodeFormat() == AdvancedCode.Format.EFC) {
                    keyMove = new KeyMoveEFC5((int)hex.getData()[1], (int)deviceButtonIndex, (int)hex.getData()[2], hex.get(3), (hex.getData()[5] << 16) + hex.get(6), null);
                    keyMove.setSegmentFlags(segment.getFlags());
                    segment.setObject(keyMove);
                    this.keymoves.add(keyMove);
                    continue;
                }
                keyMove = new KeyMove(hex.getData()[1], deviceButtonIndex, hex.getData()[2], hex.get(3), hex.subHex(6, 2), null);
                keyMove.setSegmentFlags(segment.getFlags());
                segment.setObject(keyMove);
                this.keymoves.add(keyMove);
            }
        }
        if ((softButtonNamesList = this.segments.get(10)) != null) {
            for (Segment segment : softButtonNamesList) {
                nameMap = this.parseNameSegment(segment);
                devBtn = this.remote.getDeviceButton(segment.getHex().getData()[0]);
                if (devBtn == null) continue;
                for (Integer key : nameMap.keySet()) {
                    btn = this.remote.getButton(key);
                    if (btn == null) continue;
                    devBtn.getGeneralFunction(btn).setName(nameMap.get(key));
                }
            }
        }
        hardButtonNamesList = null;
        if (this.remote.usesEZRC() && !this.remote.isSSD()) {
            hardButtonNamesList = this.segments.get(32);
        }
        if (hardButtonNamesList != null) {
            for (Segment segment : hardButtonNamesList) {
                nameMap = this.parseNameSegment(segment);
                devBtn = this.remote.getDeviceButton(segment.getHex().getData()[0]);
                if (devBtn == null) continue;
                for (Integer key : nameMap.keySet()) {
                    btn = this.remote.getButton(key);
                    if (btn == null) continue;
                    devBtn.getGeneralFunction(btn).setName(nameMap.get(key));
                }
            }
        }
        if ((learnedList = this.segments.get(9)) != null) {
            for (Segment segment : learnedList) {
                hex = segment.getHex();
                segData = hex.getData();
                deviceButtonIndex = this.remote.hasDeviceSelection() != false ? segData[0] : 0;
                format = this.remote.getLearnedFormat();
                len = format == 0 || format == 4 ? segData.length - 2 : (format == 3 ? segData[3] - 3 : segData[2] - 1);
                ls = new LearnedSignal(hex.getData()[1], deviceButtonIndex, format, hex.subHex(format == 0 || format == 4 ? 2 : (format == 3 ? 7 : 4), len), null);
                ls.setSegmentFlags(segment.getFlags());
                if (this.remote.usesEZRC()) {
                    btn = this.remote.getButton(ls.getKeyCode());
                    db = this.remote.getDeviceButton(ls.getDeviceButtonIndex());
                    ls.addReference(db, btn);
                    name = null;
                    name = db.getGeneralFunction(btn).getName();
                    ls.setName(name == null ? btn.getName() : name);
                }
                this.learned.add(ls);
            }
        }
        if ((protocolList = this.segments.get(15)) != null) {
            for (Segment segment : protocolList) {
                hex = segment.getHex();
                pid = hex.get(2);
                code = hex.subHex(4);
                this.protocols.add(new ProtocolUpgrade(pid, code, null));
            }
        }
        if ((upgradeList = this.segments.get(upgType = this.remote.getSegmentTypes().contains(14) != false ? 14 : 16)) != null) {
            for (Segment segment : upgradeList) {
                hex = segment.getHex();
                if (upgType == 14) {
                    newHex = new Hex(hex.subHex(0, 2), 0, hex.length() + 2);
                    newHex.put(hex.subHex(2), 4);
                    hex = newHex;
                }
                dev = hex.getData()[0];
                protocolOffset = hex.get(2);
                devType = this.remote.getDeviceTypeByIndex(hex.getData()[4]);
                setupCode = hex.get(5);
                pidHex = hex.subHex(9, 2);
                limit = protocolOffset == 0 ? hex.length() : Math.min(hex.length(), protocolOffset + 4);
                deviceHex = hex.subHex(9, limit - 9);
                protocolCode = null;
                if (protocolOffset > 0 && protocolOffset < hex.length() - 4) {
                    protocolCode = hex.subHex(protocolOffset + 4);
                    if (protocolCode.length() < 4) {
                        protocolCode = null;
                    } else if (this.remote.usesEZRC() || (protocolCode.getData()[3] & 64) > 0 && (!this.remote.getProcessor().getEquivalentName().equals("MAXQ610") || (protocolCode.getData()[3] & 128) != 0 || (protocolCode.getData()[4] & 128) == 0)) {
                        RemoteConfiguration.decryptObjcode(protocolCode);
                    }
                } else {
                    this.protocolUpgradeUsed = this.getProtocol(pidHex.get(0));
                    if (this.protocolUpgradeUsed != null) {
                        protocolCode = this.protocolUpgradeUsed.getCode();
                    }
                }
                alias = this.remote.getDeviceTypeAlias(devType);
                if (alias == null) {
                    message = String.format("No device type alias found for device upgrade %1$s/%2$04d.  The device upgrade could not be imported and was discarded.", new Object[]{devType, setupCode});
                    JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                    continue;
                }
                upgrade = new DeviceUpgrade();
                try {
                    if (this.remote.hasDeviceDependentUpgrades() > 0 && dev != 0 && (devBtn = this.remote.getDeviceButton(dev)) != null) {
                        upgrade.setButtonIndependent(false);
                        upgrade.setButtonRestriction(devBtn);
                        devBtn.setUpgrade(upgrade);
                    }
                    upgrade.setRemoteConfig(this);
                    upgrade.setSizeCmdBytes(hex.getData()[7]);
                    upgrade.setSizeDevBytes(hex.getData()[8]);
                    System.err.println();
                    System.err.println("Setup code=" + alias + "/" + setupCode);
                    upgrade.importRawUpgrade(deviceHex, this.remote, alias, new Hex(pidHex), protocolCode);
                    upgrade.setSetupCode(setupCode);
                    upgrade.setSegmentFlags(segment.getFlags());
                    if (this.protocolUpgradeUsed != null) {
                        this.protocolUpgradeUsed.setUsed(true);
                    }
                }
                catch (ParseException pe) {
                    pe.printStackTrace(System.err);
                    upgrade = null;
                }
                segment.setObject(upgrade);
                this.devices.add(upgrade);
                if (!this.remote.usesEZRC()) continue;
                upgrade.setRemote(this.remote);
                upgrade.classifyButtons();
            }
        }
        if ((globalPTList = this.segments.get(25)) != null) {
            for (Segment segment : globalPTList) {
                hex = segment.getHex();
                segData = hex.getData();
                deviceButtonIndex = segData[0];
                numBtns = segData[2];
                numDev = segData[3];
                activeBtnCodes = hex.subHex(4, numBtns);
                activeDevCodes = hex.subHex(4 + numBtns, numDev);
                globalPT = new GlobalPT(deviceButtonIndex, activeBtnCodes, activeDevCodes, null);
                globalPT.setSegmentFlags(segment.getFlags());
                segment.setObject(globalPT);
                this.globalPTs.add(globalPT);
            }
        }
        if (this.remote.isFDRA() && this.segments.get(29) != null && this.segments.get(29).size() > 0) {
            favDefinitions = this.segments.get(29).get(0);
            hex = favDefinitions.getHex();
            deviceIndex = hex.getData()[0];
            keyCode = hex.getData()[1];
            this.remote.getFavKey().setFavPause(hex.getData()[3]);
            favFinalKey = this.remote.getButton(hex.getData()[4]);
            if (favFinalKey != null && favFinalKey.getKeyCode() == 255) {
                favFinalKey = null;
            }
            skip = favFinalKey == null ? 0 : 1;
            numFavs = hex.getData()[6];
            j = 0;
            favDevice = this.remote.getDeviceButton(deviceIndex);
            if (favDevice != null) {
                this.favKeyDevButton = favDevice;
                favDevice.setFavoritewidth(hex.getData()[2]);
                if (favFinalKey != null) {
                    favDevice.setFavFinalKey(favFinalKey);
                }
            }
            for (i = 0; i < numFavs; ++i) {
                count = hex.getData()[7 + j];
                data = hex.subHex(8 + j, count - skip).getData();
                j += 1 + count;
                val = "";
                for (k = 0; k < data.length; ++k) {
                    b = this.remote.getButton(data[k]);
                    bName = b.getStandardName();
                    if (bName.equals("+100")) {
                        bName = ".";
                    }
                    val = val + bName.substring(0, 1);
                }
                favScan = new FavScan(keyCode, null, null);
                favScan.setDeviceButton(favDevice);
                favScan.setChannel(val);
                favScan.setSegmentFlags(favDefinitions.getFlags());
                this.favScans.add(favScan);
            }
            ++j;
            for (i = 0; i < numFavs; ++i) {
                count = hex.getData()[7 + j];
                this.favScans.get(i).setName(hex.subString(8 + j, count));
                j += 1 + count;
            }
        }
        if (this.segments.get(30) != null && this.segments.get(30).size() > 0) {
            activityDefinitions = this.segments.get(30).get(0);
            hex = activityDefinitions.getHex();
            numActivities = hex.getData()[2];
            j = 0;
            for (i = 0; i < numActivities; ++i) {
                deviceIndex = hex.getData()[3 + i];
                btn = this.remote.getButton(deviceIndex);
                activity = this.activities.get(btn);
                activity.setActive(true);
                activity.setSelector(btn);
                count = hex.getData()[3 + numActivities + j];
                macro = activity.getMacro();
                macro.setItems(hex.subHex(4 + numActivities + j, 2 * count), this.remote);
                if (macro.getItems().size() > 0) {
                    macro.addReference(macro.getItems().get((int)0).db, btn);
                }
                activity.setSegmentFlags(activityDefinitions.getFlags());
                activity.setSegment(activityDefinitions);
                macro.setActivity(activity);
                j += 1 + 2 * count;
            }
            ++j;
            for (i = 0; i < numActivities; ++i) {
                deviceIndex = hex.getData()[3 + i];
                btn = this.remote.getButton(deviceIndex);
                activity = this.activities.get(btn);
                count = hex.getData()[3 + numActivities + j];
                activity.setName(hex.subString(4 + numActivities + j, count));
                j += 1 + count;
            }
            for (Activity activity : this.activities.values()) {
                activity.getMacro().setSegmentFlags(activityDefinitions.getFlags());
                activity.getMacro().setSegment(activityDefinitions);
                activity.getMacro().setName(activity.getName());
            }
        }
        if ((rfSelectorList = this.segments.get(45)) != null) {
            for (Segment segment : rfSelectorList) {
                hex = segment.getHex();
                db = this.remote.getDeviceButton(hex.getData()[0]);
                count = hex.getData()[2];
                rfSelectors = new Remote.RFSelector[count];
                for (i = 0; i < count; ++i) {
                    rfSel = new Remote.RFSelector();
                    rfSel.btn = this.remote.getButton(hex.getData()[3 + i]);
                    rfSel.irDevType = this.remote.getDeviceTypeByIndex(hex.getData()[3 + count + 3 * i]);
                    rfSel.irCode = new SetupCode(hex.get(4 + count + 3 * i));
                    rfSel.rfDevType = this.remote.getDeviceTypeByIndex(hex.getData()[3 + 4 * count + 3 * i]);
                    rfSel.rfCode = new SetupCode(hex.get(4 + 4 * count + 3 * i));
                    rfSelectors[i] = rfSel;
                }
                db.setRfSelectors(rfSelectors);
            }
        }
        if ((activityAssists = this.segments.get(31)) != null) {
            for (Segment segment : activityAssists) {
                hex = segment.getHex();
                btn = this.remote.getButton(hex.getData()[0]);
                activity = this.activities.get(btn);
                if (activity == null) continue;
                activity.setHelpSegmentFlags(segment.getFlags());
                activity.setHelpSegment(segment);
                j = 2;
                for (i = 0; i < 3; ++i) {
                    count = hex.getData()[j++];
                    if (count == 0) continue;
                    assists = activity.getMacro().getAssists().get(i);
                    for (k = 0; k < count; ++k) {
                        btn = this.remote.getButton(hex.getData()[j + k]);
                        dev = this.remote.getDeviceButton(hex.getData()[j + k + count]);
                        if (btn == null || dev == null) continue;
                        assists.add(new Activity.Assister(dev, btn));
                    }
                    j += 2 * count + 1;
                    for (k = 0; k < count; ++k) {
                        j += hex.getData()[j] + 1;
                    }
                }
            }
        }
        if ((activityAssignments = this.segments.get(11)) != null) {
            for (Segment segment : activityAssignments) {
                hex = segment.getHex();
                btn = this.remote.getButton(hex.getData()[0]);
                activity = this.activities.get(btn);
                if (activity == null) continue;
                groups = activity.getActivityGroups();
                count = hex.getData()[2];
                map = new LinkedHashMap<Button, DeviceButton>();
                for (i = 0; i < count; ++i) {
                    btn = this.remote.getButton(hex.getData()[3 + i]);
                    dev = this.remote.getDeviceButton(hex.getData()[3 + i + count]);
                    map.put(btn, dev);
                }
                for (ActivityGroup group : groups) {
                    group.setSegment(segment);
                    group.setSegmentFlags(segment.getFlags());
                    buttonGroup = group.getButtonGroup();
                    if (buttonGroup == null || buttonGroup.length <= 0) continue;
                    btn = buttonGroup[0];
                    db = (DeviceButton)map.get(btn);
                    group.setDevice(db != null ? db : DeviceButton.noButton);
                }
            }
        }
        if ((activityAssignments = this.segments.get(219)) != null) {
            for (Segment segment : activityAssignments) {
                hex = segment.getHex();
                btn = this.remote.getButton(hex.getData()[1]);
                activity = this.activities.get(btn);
                tabIndex = this.remote.getButtonGroups().get("Activity").indexOf(btn);
                activity.setSegmentFlags(segment.getFlags());
                activity.setActive(true);
                groups = activity.getActivityGroups();
                if (this.remote.hasActivityControl()) {
                    val = hex.getData()[2];
                    if (val == 255) {
                        activity.setSelector(null);
                        for (ActivityGroup group : groups) {
                            group.setDevice(DeviceButton.noButton);
                        }
                    } else {
                        activity.setSelector(this.remote.getButton(val));
                        val = hex.getData()[3];
                        devBtns = this.remote.getDeviceButtons();
                        for (i = 0; i < devBtns.length; ++i) {
                            if ((val >> i & 1) != 1) continue;
                            devBtn = devBtns[i];
                            for (j = 0; j < groups.length; ++j) {
                                list = Arrays.asList(this.remote.getActivityControl()[tabIndex].devices[j]);
                                if (!list.contains(devBtn) || groups[j].getDevice() != null && list.indexOf(devBtn) <= list.indexOf(groups[j].getDevice())) continue;
                                groups[j].setDevice(devBtn);
                            }
                        }
                    }
                } else {
                    for (i = 0; i < Math.min(groups.length, hex.length() - 2); ++i) {
                        index = hex.getData()[i + 2];
                        groups[i].setDevice(index == 255 ? DeviceButton.noButton : this.remote.getDeviceButton(hex.getData()[i + 2]));
                    }
                }
                segment.setObject(activity);
            }
        }
        if ((activityAssignments = this.segments.get(233)) == null && (this.remote.getSegmentTypes().contains(205) || this.remote.getSegmentTypes().contains(27))) {
            this.noSetup = this.getNoSetup();
            if (this.remote.hasActivityControl()) {
                for (i = 0; i < this.remote.getActivityControl().length; ++i) {
                    list = this.segments.get(205 + i);
                    if (list == null || list.size() == 0) continue;
                    if (activityAssignments == null) {
                        activityAssignments = new ArrayList<Segment>();
                    }
                    activityAssignments.add(list.get(0));
                }
            } else if (this.noSetup != null && (this.segments.get(205) != null && this.segments.get(205).size() > 0 || this.segments.get(27) != null && this.segments.get(27).size() > 0)) {
                activitySetup = null;
                offset = 0;
                if (this.segments.keySet().contains(205)) {
                    activitySetup = this.segments.get(205).get(0);
                    offset = 12;
                } else {
                    activitySetup = this.segments.get(27).get(0);
                    offset = 3;
                }
                hex = activitySetup.getHex();
                this.activitySetupAddresses = hex.subHex(offset, 8);
                this.activitySerials = new int[4];
                for (i = 0; i < 4; ++i) {
                    this.activitySerials[i] = this.noSetup.getSerial(i == 0 ? 0 : 1, this.activitySetupAddresses.subHex(2 * i, 2));
                }
                this.resetDeviceUpgrades();
            }
        }
        if (activityAssignments != null && activityAssignments.size() > 0 && this.remote.hasActivityControl()) {
            activityBtns = this.remote.getButtonGroups().get("Activity");
            for (i = 0; i < activityBtns.size(); ++i) {
                segment = activityAssignments.get(0);
                indexPos = i + 4;
                offset = 1;
                if (segment.get_Type() != 233) {
                    indexPos = 2;
                    offset = 0;
                    segment = null;
                    for (Segment seg : activityAssignments) {
                        if (seg.get_Type() != 205 + i) continue;
                        segment = seg;
                        break;
                    }
                    if (segment == null) continue;
                }
                hex = segment.getHex();
                activity = this.activities.get(activityBtns.get(i));
                activity.setActive(true);
                activity.setSegmentFlags(segment.getFlags());
                control = this.remote.getActivityControl()[i];
                for (ActivityGroup group : groups = activity.getActivityGroups()) {
                    group.setDevice(DeviceButton.noButton);
                }
                index = hex.getData()[indexPos] + offset;
                if (index > control.maps.length) {
                    activity.setSelector(null);
                } else {
                    selectorName = "" + index;
                    activity.setSelector(this.remote.getButton(selectorName));
                }
                if ((index &= 127) > control.maps.length) continue;
                val = control.maps[index - 1];
                devBtns = this.remote.getDeviceButtons();
                for (k = 0; k < devBtns.length; ++k) {
                    if ((val >> k & 1) != 1) continue;
                    devBtn = devBtns[k];
                    for (j = 0; j < groups.length; ++j) {
                        list = Arrays.asList(control.devices[j]);
                        if (!list.contains(devBtn) || groups[j].getDevice() != null && list.indexOf(devBtn) <= list.indexOf(groups[j].getDevice())) continue;
                        groups[j].setDevice(devBtn);
                    }
                }
            }
        }
        if ((activitySettings = this.segments.get(220)) != null) {
            for (Segment segment : activitySettings) {
                hex = segment.getHex();
                btn = this.remote.getButton(hex.getData()[1]);
                activity = this.activities.get(btn);
                activity.setHelpSegmentFlags(segment.getFlags());
                sa = this.remote.getSetting("AudioHelp");
                if (sa != null) {
                    sa.decode(hex.getData(), this.remote);
                    activity.setAudioHelp(sa.getValue());
                }
                if ((sv = this.remote.getSetting("VideoHelp")) != null) {
                    sv.decode(hex.getData(), this.remote);
                    activity.setVideoHelp(sv.getValue());
                }
                if (sa == null && sv == null) continue;
                activity.setHelpSegment(segment);
            }
        }
        if (this.remote.usesEZRC()) {
            v1 = allowEmpty = this.remote.getSoftDevices() != null && this.remote.getSoftDevices().getAllowEmptyButtonSettings() != false;
            if (!this.remote.isSSD() && !allowEmpty) {
                missing = new ArrayList<DeviceButton>();
                missingCodes = new ArrayList<Integer>();
                for (DeviceButton db : this.remote.getDeviceButtons()) {
                    if (db.isConstructed()) {
                        du = new DeviceUpgrade(new String[0]);
                        db.setUpgrade(du);
                        du.setButtonIndependent(false);
                        du.setButtonRestriction(db);
                        du.setSetupCode(-1);
                        du.setRemoteConfig(this);
                        du.setRemote(this.remote);
                        du.classifyButtons();
                        this.devices.add(du);
                        continue;
                    }
                    if (db.getUpgrade() != null || db.getSegment() == null || (setupCode = db.getDeviceTypeIndex(dbData = db.getSegment().getHex().getData()) << 12 | db.getSetupCode(dbData)) == -1 || missingCodes.contains(setupCode)) continue;
                    missing.add(db);
                    missingCodes.add(setupCode);
                }
                hid = null;
                for (IO temp : this.owner.getInterfaces()) {
                    tempName = temp.getInterfaceName();
                    if (!tempName.equals("CommHID")) continue;
                    v2 = hid = temp.openRemote("UPG").equals("UPG") != false ? temp : null;
                    if (hid == null || hid.readRemote(131072, buffer = new short[48], 48) != 48) break;
                    irAddress = buffer[24] << 24 | buffer[25] << 16 | buffer[26] << 8 | buffer[27];
                    textAddress = buffer[36] << 24 | buffer[37] << 16 | buffer[38] << 8 | buffer[39];
                    if (hid.readRemote(irAddress + 20, buffer, 48) != 48) break;
                    setupLookupOffset = buffer[2] << 8 | buffer[3];
                    setupIndexOffset = (buffer[4] << 8 | buffer[5]) - setupLookupOffset;
                    protLookupOffset = (buffer[8] << 8 | buffer[9]) - setupLookupOffset;
                    protIndexOffset = (buffer[10] << 8 | buffer[11]) - setupLookupOffset;
                    categoryAddress = (buffer[16] << 8 | buffer[17]) + irAddress;
                    this.setDeviceCategories(hid, textAddress, categoryAddress);
                    size = 2 * protIndexOffset - protLookupOffset - 2;
                    buffer = new short[size];
                    if (hid.readRemote(irAddress + setupLookupOffset, buffer, size) != size) break;
                    setupCount = buffer[0] | buffer[1] << 8;
                    protCount = buffer[protLookupOffset] | buffer[protLookupOffset + 1] << 8;
                    for (i = 0; i < setupCount; ++i) {
                        setupCode = buffer[2 * i + 2] | buffer[2 * i + 3] << 8;
                        if (!missingCodes.contains(setupCode)) continue;
                        setupAddress = buffer[setupIndexOffset + 2 * i] | buffer[setupIndexOffset + 2 * i + 1] << 8;
                        numFixed = -1;
                        numVar = -1;
                        buf = new short[512];
                        if (hid.readRemote(irAddress + setupAddress & 0xFFFFFE, buf, 512) != 512) continue;
                        setupOdd = setupAddress & 1;
                        for (j = 0; j < protCount; ++j) {
                            if (buf[setupOdd] != buffer[protLookupOffset + 2 * j + 3] || buf[setupOdd + 1] != buffer[protLookupOffset + 2 * j + 2]) continue;
                            protAddress = buffer[protIndexOffset + 2 * j] | buffer[protIndexOffset + 2 * j + 1] << 8;
                            protOdd = protAddress & 1;
                            buf2 = new short[2];
                            if (hid.readRemote(irAddress + protAddress + 2 & 0xFFFFFE, buf2, 2) != 2) break;
                            numFixed = buf2[protOdd] >> 4;
                            numVar = buf2[protOdd] & 15;
                            break;
                        }
                        if (numFixed < 0) continue;
                        setupLength = 3 + numFixed;
                        mapbyte = buf[setupOdd + 3];
                        setupLength += (10 * (mapbyte >> 7 & 1) + 3 * (mapbyte >> 6 & 1) + 2 * (mapbyte >> 5 & 1)) * numVar;
                        mapbyte &= 31;
                        j = 0;
                        while (j < 32) {
                            ++setupLength;
                            for (k = 1; k < 8; ++k) {
                                setupLength += (mapbyte >> k & 1) * numVar;
                            }
                            if ((mapbyte & 1) == 1) break;
                            mapbyte = buf[setupOdd + 3 + ++j];
                        }
                        setupHex = new Hex(buf, setupOdd, setupLength);
                        pidHex = new Hex(buf, setupOdd, 2);
                        for (DeviceButton db : missing) {
                            sc = db.getDeviceTypeIndex(dbData = db.getSegment().getHex().getData()) << 12 | db.getSetupCode(dbData);
                            if (sc != setupCode) continue;
                            devType = this.remote.getDeviceTypeByIndex(dbData[2]);
                            alias = this.remote.getDeviceTypeAlias(devType);
                            if (alias == null) {
                                message = String.format("No device type alias found for device upgrade %1$s/%2$04d.  The device upgrade could not be imported and was discarded.", new Object[]{devType, setupCode});
                                JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                                continue;
                            }
                            du = new DeviceUpgrade(new String[0]);
                            try {
                                du.setButtonIndependent(false);
                                du.setButtonRestriction(db);
                                du.setRemoteConfig(this);
                                du.setSizeCmdBytes(numVar);
                                du.setSizeDevBytes(numFixed);
                                du.importRawUpgrade(setupHex, this.remote, alias, new Hex(pidHex), null);
                                du.setSetupCode(setupCode & 4095);
                                du.setSegmentFlags(255);
                                du.setRemote(this.remote);
                                for (Button b : this.remote.getButtons()) {
                                    f = du.getAssignments().getAssignment(b);
                                    if (f == null) continue;
                                    gid = null;
                                    name = db.getGeneralFunction(b).getName();
                                    if (name == null) {
                                        name = b.getName();
                                    }
                                    f.setName(name);
                                    gid = du.getGidForName(name);
                                    f.setGid(gid);
                                }
                                du.classifyButtons();
                                protocol = du.getProtocol();
                                if (protocol.getDefaultCmdLength() != numVar || protocol.getFixedDataLength() != numFixed) {
                                    title = "Protocol Variant Error";
                                    message = "Error in RDF.  Wrong variant specified for PID = " + protocol.getID().toString() + ".  Number of fixed/command bytes\nshould be " + numFixed + "/" + numVar + ", for specified variant it is " + protocol.getDefaultCmdLength() + "/" + protocol.getFixedDataLength() + ".";
                                    JOptionPane.showMessageDialog(null, message, title, 2);
                                }
                            }
                            catch (ParseException pe) {
                                pe.printStackTrace(System.err);
                                du = null;
                            }
                            if (du == null) continue;
                            db.setUpgrade(du);
                            this.devices.add(du);
                        }
                    }
                }
                if (hid != null) {
                    hid.closeRemote();
                }
            }
            for (Macro macro : this.getAllMacros(true)) {
                for (KeySpec ks : macro.getItems()) {
                    if (ks.irSerial < 0) continue;
                    ks.fn = ks.db.getUpgrade().getFunctionMap().get(ks.irSerial);
                    if (this.remote.getSystemButtons() != null) {
                        b = this.remote.getSystemButtons().get(ks.irSerial);
                        ks.fn.addReference(ks.db, b);
                    }
                    ks.irSerial = -1;
                }
            }
            for (DeviceButton db : this.remote.getDeviceButtons()) {
                if (db.getUpgrade() == null) continue;
                db.getUpgrade().classifyButtons();
            }
            for (LearnedSignal ls : this.learned) {
                for (GeneralFunction.User u : ls.getUsers()) {
                    u.db.getUpgrade().getLearnedMap().put(Integer.valueOf(u.button.getKeyCode()), ls);
                }
            }
            for (Macro m : this.getAllMacros(false)) {
                for (GeneralFunction.User u : m.getUsers()) {
                    u.db.getUpgrade().getMacroMap().put(Integer.valueOf(u.button.getKeyCode()), m);
                }
            }
        }
        pos = 0;
    }

    public void resetDeviceUpgrades() {
        ArrayList<Integer> distinctSerials = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (distinctSerials.contains(this.activitySerials[i])) continue;
            distinctSerials.add(this.activitySerials[i]);
        }
        Activity a = (Activity)this.activities.values().toArray()[0];
        for (ActivityGroup group : a.getActivityGroups()) {
            group.setDeviceIndex(this.activitySerials[group.getIndex() + 1]);
        }
        ListIterator<DeviceUpgrade> li = this.devices.listIterator();
        while (li.hasNext()) {
            if (!li.next().isInternal()) continue;
            li.remove();
        }
        try {
            DeviceButton[] deviceButtonArray = distinctSerials.iterator();
            while (deviceButtonArray.hasNext()) {
                int serial = (Integer)deviceButtonArray.next();
                Hex duHex = this.noSetup.getSetup(1, serial);
                DeviceUpgrade du = new DeviceUpgrade();
                du.setUsesSerial(true);
                Hex pid = duHex.subHex(0, 2);
                String alias = this.remote.getDeviceTypeAlias(this.remote.getDeviceTypeByIndex(0));
                du.importRawUpgrade(duHex, this.remote, alias, pid, null);
                du.setSetupCode(serial);
                du.setInternal(true);
                this.devices.add(du);
            }
            for (DeviceButton db : this.remote.getDeviceButtons()) {
                if (!this.isReplacement) continue;
                try {
                    NoSetup noSetup = this.getNoSetup();
                    if (noSetup == null) continue;
                    db.setUpgrade(null);
                    Segment seg = db.getSegment();
                    short devType = seg.getHex().getData()[2];
                    int setupCode = seg.getHex().get(3);
                    if (setupCode == 65535) continue;
                    Hex rawUpgrade = noSetup.createRawUpgrade(devType, setupCode);
                    Hex pid = rawUpgrade.subHex(0, 2);
                    String alias = this.remote.getDeviceTypeAlias(this.remote.getDeviceTypeByIndex(devType));
                    DeviceUpgrade upgrade = new DeviceUpgrade();
                    upgrade.setSelectedSetupCode(String.format("%04d", setupCode));
                    upgrade.setSelectedDeviceIndex(devType);
                    upgrade.importRawUpgrade(rawUpgrade, this.remote, alias, pid, null);
                    upgrade.setSetupCode(setupCode);
                    upgrade.setInternal(true);
                    db.setUpgrade(upgrade);
                    this.devices.add(upgrade);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Integer> getCreatableMissingCodes() {
        if (!this.remote.usesSimpleset()) {
            return null;
        }
        JPS io = this.owner.binLoaded();
        if (io == null || io.getScanner() == null) {
            return null;
        }
        ArrayList<Integer> missingCodes = new ArrayList<Integer>();
        ArrayList<Integer> upgradeCodes = new ArrayList<Integer>();
        for (DeviceUpgrade du : this.devices) {
            int setupCode;
            if (du.getSetupCode() == -1 || upgradeCodes.contains(setupCode = du.getDeviceType().getNumber() << 16 | du.getSetupCode())) continue;
            upgradeCodes.add(setupCode);
        }
        for (DeviceButton db : this.remote.getDeviceButtons()) {
            short[] dbData;
            int setupCode;
            if (db.getSegment() == null || (setupCode = db.getDeviceTypeIndex(dbData = db.getSegment().getHex().getData()) << 16 | db.getSetupCode(dbData)) == -1 || upgradeCodes.contains(setupCode) || missingCodes.contains(setupCode)) continue;
            missingCodes.add(setupCode);
        }
        return missingCodes.isEmpty() ? null : missingCodes;
    }

    public void createMissingUpgrades() {
        List<Integer> missingCodes = this.getCreatableMissingCodes();
        if (missingCodes == null) {
            return;
        }
        JPS io = this.owner.binLoaded();
        Scanner s = io.getScanner();
        short[] bufSetup = new short[4 * s.getSetupCodeCount()];
        short[] bufExec = new short[4 * s.getExecutorCount()];
        short[] bufType = new short[2 * s.getSetupTypeCount() + 2];
        short[] bufNum = new short[10 * s.getNumberTableSize()];
        io.readRemote(s.getSetupCodeIndexAddress() + 2, bufSetup);
        io.readRemote(s.getExecutorIndexAddress() + 2, bufExec);
        io.readRemote(s.getSetupTypeIndexAddress(), bufType);
        io.readRemote(s.getNumberTableAddress(), bufNum);
        int type = -1;
        int typeLimit = (bufType[2 * type + 2] | bufType[2 * type + 3] << 8) * 2;
        int mask = s.setupCodeIncludesType() ? 4095 : 65535;
        for (int i = 0; i < s.getSetupCodeCount(); ++i) {
            int srcPos;
            boolean hasDigits;
            int codeAddress = s.getSetupCodeIndexAddress() + 2 + 2 * i;
            if (codeAddress == typeLimit) {
                typeLimit = (bufType[2 * ++type + 2] | bufType[2 * type + 3] << 8) * 2;
            }
            int setupCode = bufSetup[2 * i] | bufSetup[2 * i + 1] << 8;
            if (!missingCodes.contains(setupCode = setupCode & mask | type << 16)) continue;
            DeviceType devType = this.remote.getDeviceTypeByIndex(type);
            String alias = this.remote.getDeviceTypeAlias(devType);
            if (alias == null) {
                String message = String.format("No device type alias found for device upgrade %1$s/%2$04d.  The device upgrade could not be created.", devType, setupCode & mask);
                JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                continue;
            }
            int n = 2 * (s.getSetupCodeCount() + i);
            int setupAddress = (bufSetup[n] | bufSetup[n + 1] << 8) + s.getIndexTablesOffset();
            int numFixed = -1;
            int numVar = -1;
            short[] buf = new short[512];
            if (io.readRemote(setupAddress, buf) != 512) continue;
            for (int j = 0; j < s.getExecutorCount(); ++j) {
                short[] buf2;
                if (buf[0] != bufExec[2 * j + 1] || buf[1] != bufExec[2 * j]) continue;
                n = 2 * (s.getExecutorCount() + j);
                int protAddress = (bufExec[n] | bufExec[n + 1] << 8) + s.getIndexTablesOffset();
                if (io.readRemote(protAddress + 2, buf2 = new short[2]) != 2) break;
                numFixed = buf2[0] >> 4;
                numVar = buf2[0] & 0xF;
                break;
            }
            if (numFixed < 0) continue;
            int setupLength = 3 + numFixed;
            int mapbyteCount = 0;
            int mapIndex = buf[2] - 1;
            int mapbyte = buf[3];
            boolean bl = hasDigits = (mapbyte & 0x80) == 128;
            if (mapIndex >= 0) {
                mapbyte |= 0x80;
            }
            setupLength += (10 * (mapbyte >> 7 & 1) + 3 * (mapbyte >> 6 & 1) + 2 * (mapbyte >> 5 & 1)) * numVar;
            mapbyte &= 0x1F;
            int j = 0;
            while (j < 32) {
                ++setupLength;
                ++mapbyteCount;
                for (int k = 1; k < 8; ++k) {
                    setupLength += (mapbyte >> k & 1) * numVar;
                }
                if ((mapbyte & 1) == 1) break;
                mapbyte = buf[3 + ++j];
            }
            int destPos = srcPos = 3 + numFixed + mapbyteCount;
            Hex pidHex = new Hex(buf, 0, 2);
            Hex setupHex = new Hex(setupLength);
            System.arraycopy(buf, 0, setupHex.getData(), 0, srcPos);
            setupHex.set((short)0, 2);
            if (mapIndex >= 0) {
                short[] sArray = setupHex.getData();
                sArray[3] = (short)(sArray[3] | 0x80);
                System.arraycopy(bufNum, 10 * mapIndex, setupHex.getData(), destPos, 10 * numVar);
                destPos += 10 * numVar;
                if (hasDigits) {
                    srcPos += 10 * numVar;
                }
            }
            System.arraycopy(buf, srcPos, setupHex.getData(), destPos, setupLength - destPos);
            DeviceUpgrade du = new DeviceUpgrade(new String[0]);
            try {
                du.setRemoteConfig(this);
                du.setSizeCmdBytes(numVar);
                du.setSizeDevBytes(numFixed);
                du.importRawUpgrade(setupHex, this.remote, alias, new Hex(pidHex), null);
                du.setSetupCode(setupCode & mask);
                du.setSegmentFlags(255);
                du.setRemote(this.remote);
                Protocol protocol = du.getProtocol();
                if (protocol.getDefaultCmdLength() != numVar || protocol.getFixedDataLength() != numFixed) {
                    String title = "Protocol Variant Error";
                    String message = "Error in RDF.  Wrong variant specified for PID = " + protocol.getID().toString() + ".  Number of fixed/command bytes\nshould be " + numFixed + "/" + numVar + ", for specified variant it is " + protocol.getDefaultCmdLength() + "/" + protocol.getFixedDataLength() + ".";
                    JOptionPane.showMessageDialog(null, message, title, 2);
                }
            }
            catch (ParseException pe) {
                pe.printStackTrace(System.err);
                du = null;
            }
            if (du == null) continue;
            this.devices.add(du);
        }
    }

    public int getLanguageIndex() {
        List<Segment> setupSegs = this.segments.get(18);
        if (setupSegs != null) {
            return setupSegs.get(0).getHex().getData()[4];
        }
        return 0;
    }

    public void setDeviceCategories(IO hid, int textAddress, int categoryAddress) {
        short[] buffer = new short[1024];
        if (hid.readRemote(categoryAddress, buffer, 48) != 48) {
            return;
        }
        int brandStart = 2 * (buffer[2] | buffer[3] << 8);
        int categoryCount = buffer[0] | buffer[1] << 8;
        int codeStart = 2 * (buffer[2 * categoryCount + 2] | buffer[2 * categoryCount + 3] << 8);
        int size = codeStart - brandStart;
        short[] bBuffer = new short[size];
        if (hid.readRemote(131072 + brandStart, bBuffer, size) != size) {
            return;
        }
        size = categoryAddress - 131072 - codeStart;
        short[] cBuffer = new short[size];
        if (hid.readRemote(131072 + codeStart, cBuffer, size) != size) {
            return;
        }
        this.categoryBrands = new LinkedHashMap();
        this.codeLocations = new LinkedHashMap();
        for (int i = 0; i < categoryCount; ++i) {
            int catOffset = 2 * (buffer[2 * i + 2] | buffer[2 * i + 3] << 8) - brandStart;
            int catSize = bBuffer[catOffset] | bBuffer[catOffset + 1] << 8;
            int start = catOffset + 2 * catSize + 2;
            ArrayList<String> names = new ArrayList<String>();
            for (int j = 0; j < catSize; ++j) {
                int len = bBuffer[start];
                char[] name = new char[len];
                for (int k = 0; k < len; ++k) {
                    name[k] = (char)bBuffer[start + k + 1];
                }
                start += len + 1;
                names.add(new String(name));
                int codeOffset = 2 * (bBuffer[catOffset + 2 * j + 2] | bBuffer[catOffset + 2 * j + 3] << 8) - codeStart;
                len = cBuffer[codeOffset] | cBuffer[codeOffset + 1] << 8;
                for (int k = 0; k < len; ++k) {
                    int code = cBuffer[codeOffset + 2 * k + 2] | cBuffer[codeOffset + 2 * k + 3] << 8;
                    int type = code >> 12;
                    code = code & 0xFFF | type << 16;
                    if (this.codeLocations.keySet().contains(code)) continue;
                    int location = i << 24 | j << 16 | k + 1 << 8 | len;
                    this.codeLocations.put(code, location);
                }
            }
            this.categoryBrands.put(i, names);
        }
        if (hid.readRemote(textAddress + 20, buffer, 70) != 70) {
            return;
        }
        int pos = 14 * this.getLanguageIndex();
        int tableOffset = buffer[pos + 2] << 8 | buffer[pos + 3];
        int indexOffset = buffer[pos + 4] << 8 | buffer[pos + 5];
        if (hid.readRemote(textAddress + indexOffset, buffer, 1024) != 1024) {
            return;
        }
        int categoryStart = buffer[132] << 8 | buffer[133];
        if (hid.readRemote(textAddress + tableOffset + categoryStart, buffer, 512) != 512) {
            return;
        }
        pos = 0;
        System.err.println();
        System.err.println("Device Categories:");
        this.deviceCategories = new LinkedHashMap();
        for (int i = 0; i < categoryCount; ++i) {
            int len = buffer[pos];
            char[] text = new char[len];
            for (int j = 0; j < len; ++j) {
                text[j] = (char)buffer[pos + j + 1];
            }
            pos += len + 1;
            String category = new String(text);
            System.err.println("   " + category);
            this.deviceCategories.put(i, category);
        }
    }

    public boolean setDeviceCategories() {
        IO hid = null;
        boolean result = false;
        for (IO temp : this.owner.getInterfaces()) {
            String tempName = temp.getInterfaceName();
            if (!tempName.equals("CommHID")) continue;
            hid = (CommHID)(temp.openRemote("UPG").equals("UPG") ? temp : null);
            if (hid == null) break;
            this.categoryBrands = new LinkedHashMap();
            this.codeLocations = new LinkedHashMap();
            this.deviceCategories = new LinkedHashMap();
            Items items = new Items();
            if (this.regionFilename == null) {
                short[] filedata = ((CommHID)hid).readXZITEFile("system.xcf");
                List<String> tagNames = this.getBXMLtagnames("system.xcf", filedata, 0);
                int start = filedata[14] + 256 * filedata[15] + 17;
                this.parseXCFFile(items, 1, filedata, start, tagNames, true);
            }
            items.codes = new ArrayList<Integer>();
            temp.getProgressUpdater().updateProgress(70);
            items.irdb = ((CommHID)hid).readXZITEFile("irdb.bin");
            List<String> tagNames = this.getBXMLtagnames("irdb.bin", items.irdb, 0);
            if (tagNames == null) break;
            int start = items.irdb[14] + 256 * items.irdb[15] + 17;
            this.parseXCFFile(items, -1, items.irdb, start, tagNames, true);
            temp.getProgressUpdater().updateProgress(85);
            short[] filedata = ((CommHID)hid).readXZITEFile(this.regionFilename);
            tagNames = this.getBXMLtagnames(this.regionFilename, filedata, 0);
            if (tagNames == null) break;
            start = filedata[14] + 256 * filedata[15] + 17;
            this.parseXCFFile(items, -2, filedata, start, tagNames, true);
            result = true;
            temp.getProgressUpdater().updateProgress(100);
            break;
        }
        if (hid != null) {
            hid.closeRemote();
        }
        return result;
    }

    private LinkedHashMap<Integer, String> parseNameSegment(Segment segment) {
        LinkedHashMap<Integer, String> nameMap = new LinkedHashMap<Integer, String>();
        Hex hex = segment.getHex();
        int count = hex.getData()[2];
        int start = 4 + count;
        for (int i = 0; i < count; ++i) {
            short nameLen = hex.getData()[start];
            nameMap.put(new Integer(hex.getData()[i + 3]), hex.subString(start + 1, nameLen));
            start += nameLen + 1;
        }
        return nameMap;
    }

    private Hex createNameHex(LinkedHashMap<Button, String> map) {
        int size = 4;
        for (String str : map.values()) {
            size += 2 + str.length();
        }
        Hex hex = new Hex(size += (size & 1) == 1 ? 1 : 0);
        hex.set((short)255, size - 1);
        hex.put(0, 0);
        hex.set((short)map.size(), 2);
        int i = 3;
        int j = 4 + map.size();
        for (Button btn : map.keySet()) {
            hex.set(btn.getKeyCode(), i++);
            String name = map.get(btn);
            hex.set((short)name.length(), j++);
            for (char ch : name.toCharArray()) {
                hex.set((short)ch, j++);
            }
        }
        if (!map.isEmpty()) {
            hex.set((short)0, i);
        }
        return hex;
    }

    private void setMacro(Macro macro) {
        if (macro.getDeviceButtonIndex() == 0) {
            macro.setDeviceButtonIndex(-1);
        }
        if (!this.remote.usesEZRC() && macro.getDeviceButtonIndex() != -1) {
            for (SpecialProtocol sp : this.remote.getSpecialProtocols()) {
                int dbi;
                if (!sp.isInternal() || this.remote.getDeviceButton(dbi = macro.getDeviceButtonIndex() - (sp.getInternalSerial() << this.remote.getSeqShift())) == null && (dbi != 0 || sp.getInternalSerial() <= 0)) continue;
                macro.setDeviceButtonIndex(dbi == 0 ? -1 : dbi);
                macro.setSequenceNumber(sp.getInternalSerial());
                SpecialProtocolFunction sf = sp.createFunction(macro);
                if (sf != null) {
                    this.specialFunctions.add(sf);
                }
                return;
            }
        }
        this.macros.add(macro);
    }

    public void setDeviceButtonSegments() {
        List<Segment> devNamesList;
        List<Segment> dbList = this.segments.get(0);
        if (dbList != null) {
            for (Segment segment : dbList) {
                DeviceButton db;
                Hex hex = segment.getHex();
                if (segment.getFlags() != 255 || (db = this.remote.getDeviceButton(hex.getData()[0])) == null) continue;
                db.setDefaultName();
                db.setVolumePT(this.getPTButton(db, hex, 6));
                db.setTransportPT(this.getPTButton(db, hex, 7));
                db.setChannelPT(this.getPTButton(db, hex, 8));
                if (this.remote.getPunchThru().contains("X")) {
                    db.setxPT(this.getPTButton(db, hex, 9));
                }
                if (this.remote.getPunchThru().contains("Y")) {
                    db.setInputPT(this.getPTButton(db, hex, 10));
                }
                if (this.remote.getPunchThru().contains("Z")) {
                    db.setzPT(this.getPTButton(db, hex, 11));
                }
                segment.setObject(db);
                short setupCode = db.getSetupCode(hex.getData());
                int devType = db.getDeviceTypeIndex(hex.getData());
                db.setConstructed(this.remote.usesEZRC() && setupCode == -1 && devType != 255);
            }
        }
        if ((devNamesList = this.segments.get(21)) != null) {
            this.deviceButtonList = new ArrayList<DeviceButton>();
            for (Segment segment : devNamesList) {
                LinkedHashMap<Integer, String> nameMap = this.parseNameSegment(segment);
                for (Integer key : nameMap.keySet()) {
                    DeviceButton devBtn = this.remote.getDeviceButton(key);
                    if (devBtn == null) continue;
                    this.deviceButtonList.add(devBtn);
                    devBtn.setName(nameMap.get(key));
                }
            }
        }
    }

    public Segment getInternalSegment() {
        return this.internalSegment;
    }

    private DeviceButton getPTButton(DeviceButton db, Hex hex, int index) {
        DeviceButton devBtn = this.remote.getDeviceButton(hex.getData()[index]);
        return devBtn == null ? DeviceButton.noButton : devBtn;
    }

    private KeyMove findKeyMove(List<KeyMove> advCodes, String deviceName, String keyName) {
        DeviceButton[] deviceButtons = this.remote.getDeviceButtons();
        for (KeyMove keyMove : advCodes) {
            int keyCode;
            String buttonName;
            DeviceButton devButton = deviceButtons[keyMove.getDeviceButtonIndex()];
            if (!devButton.getName().equals(deviceName) || !(buttonName = this.remote.getButtonName(keyCode = keyMove.getKeyCode())).equalsIgnoreCase(keyName)) continue;
            return keyMove;
        }
        System.err.println("No keymove found matching " + deviceName + ':' + keyName);
        return null;
    }

    private Macro findMacro(String keyName) {
        for (Macro macro : this.macros) {
            int keyCode = macro.getKeyCode();
            String buttonName = this.remote.getButtonName(keyCode);
            if (!buttonName.equalsIgnoreCase(keyName)) continue;
            return macro;
        }
        System.err.println("No macro found assigned to key " + keyName);
        return null;
    }

    private ProtocolUpgrade findProtocolUpgrade(int pid) {
        for (ProtocolUpgrade pu : this.protocols) {
            if (pu.getPid() != pid) continue;
            return pu;
        }
        System.err.println("No protocol upgrade found w/ pid $" + Integer.toHexString(pid));
        return null;
    }

    private LearnedSignal findLearnedSignal(String deviceName, String keyName) {
        for (LearnedSignal ls : this.learned) {
            int keyCode;
            String buttonName;
            DeviceButton devButton = this.remote.getDeviceButton(ls.getDeviceButtonIndex());
            if (!devButton.getName().equals(deviceName) || !(buttonName = this.remote.getButtonName(keyCode = ls.getKeyCode())).equalsIgnoreCase(keyName)) continue;
            return ls;
        }
        System.err.println("No learned signal found matching " + deviceName + ':' + keyName);
        return null;
    }

    private LearnedSignal findLearnedSignal(DeviceButton db, Button btn) {
        for (LearnedSignal ls : this.learned) {
            DeviceButton devButton;
            if (!ls.forUpload() || (devButton = this.remote.getDeviceButton(ls.getDeviceButtonIndex())) != db || btn.getKeyCode() != ls.getKeyCode()) continue;
            return ls;
        }
        return null;
    }

    public void importIR(PropertyReader pr, boolean deleteUsedProts) throws IOException {
        Iterator<Highlight> it;
        int e2FormatOffset;
        Property property = null;
        if (pr != null) {
            property = this.loadBuffer(pr);
        }
        if (deleteUsedProts) {
            ProtocolManager.getProtocolManager().reset();
        }
        if ((e2FormatOffset = this.remote.getE2FormatOffset()) >= 0) {
            short n;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 20 - e2FormatOffset && (n = this.data[e2FormatOffset + i]) != 255; ++i) {
                sb.append((char)n);
            }
            String e2f = sb.toString();
            String string = this.eepromFormatVersion = e2f.isEmpty() ? null : e2f;
        }
        if (this.remote.usesEZRC()) {
            this.gidList = new ArrayList<Integer>();
            this.gidRegister = new HashMap();
        }
        if (this.remote.isSSD()) {
            this.ssdFileData = new ArrayList<SSDFileInfo>();
            this.savedSSDFileData = new ArrayList<SSDFileInfo>();
            this.loadFiles(true);
            return;
        }
        if (this.hasSegments()) {
            this.loadSegments(true);
        }
        this.decodeSettings();
        this.decodeUpgrades();
        List<AdvancedCode> advCodes = this.decodeAdvancedCodes();
        if (this.remote.hasFavKey() && this.remote.getFavKey().isSegregated()) {
            this.decodeFavScans();
        }
        if (this.remote.hasTimedMacroSupport() && this.remote.getMacroCodingType().get_Type() == 1) {
            this.decodeTimedMacros();
        }
        this.decodeLearnedSignals();
        if (pr != null) {
            while (property != null && !property.name.startsWith("[")) {
                System.err.println("property.name=" + property.name);
                property = pr.nextProperty();
            }
            if (property != null) {
                IniSection section = pr.nextSection();
                if (section != null) {
                    section.setName(property.name.substring(1, property.name.length() - 1));
                }
                while (section != null) {
                    DeviceUpgrade device;
                    String text;
                    String key;
                    Enumeration<?> keys;
                    String name = section.getName();
                    if (name.equals("Notes")) {
                        System.err.println("Importing notes");
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            int base = 10;
                            if (key.charAt(0) == '$') {
                                base = 16;
                                key = key.substring(1);
                            }
                            int index = Integer.parseInt(key, base);
                            int flag = index >> 12;
                            System.err.println("index=" + (index &= 0xFFF) + ", flag=" + flag + ",text=" + text);
                            if (flag == 0) {
                                this.notes = text;
                                continue;
                            }
                            if (flag == 1) {
                                if (index >= advCodes.size()) continue;
                                advCodes.get(index).setNotes(text);
                                continue;
                            }
                            if (flag == 2 && this.remote.getTimedMacroAddress() != null) {
                                this.timedMacros.get(index).setNotes(text);
                                continue;
                            }
                            if (flag == 3) {
                                if (index >= this.devices.size() || (device = this.devices.get(index)) == null) continue;
                                device.setDescription(text);
                                continue;
                            }
                            if (flag == 4) {
                                if (index >= this.protocols.size()) continue;
                                this.protocols.get(index).setNotes(text);
                                continue;
                            }
                            if (flag == 5) {
                                this.learned.get(index).setNotes(text);
                                continue;
                            }
                            if (flag != 6) continue;
                            this.deviceButtonNotes[index] = text;
                        }
                    } else if (name.equals("General")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            if (!key.equals("Notes")) continue;
                            this.notes = text;
                        }
                    } else if (name.equals("KeyMoves")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            String keyName;
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            StringTokenizer st = new StringTokenizer(key, ":");
                            String deviceName = st.nextToken();
                            KeyMove km = this.findKeyMove(this.keymoves, deviceName, keyName = st.nextToken());
                            if (km == null) continue;
                            km.setNotes(text);
                        }
                    } else if (name.equals("Macros")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            String keyName = (String)keys.nextElement();
                            text = section.getProperty(keyName);
                            Macro macro = this.findMacro(keyName);
                            if (macro == null) continue;
                            macro.setNotes(text);
                        }
                    } else if (name.equals("Devices")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            StringTokenizer st = new StringTokenizer(key, ": ");
                            String deviceTypeName = st.nextToken();
                            int setupCode = Integer.parseInt(st.nextToken());
                            device = this.findDeviceUpgrade(this.remote.getDeviceType(deviceTypeName).getNumber(), setupCode);
                            if (device == null) continue;
                            device.setDescription(text);
                        }
                    } else if (name.equals("Protocols")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            StringTokenizer st = new StringTokenizer(key, "$");
                            st.nextToken();
                            int pid = Integer.parseInt(st.nextToken(), 16);
                            ProtocolUpgrade protocol = this.findProtocolUpgrade(pid);
                            if (protocol == null) continue;
                            protocol.setNotes(text);
                        }
                    } else if (name.equals("Learned")) {
                        keys = section.propertyNames();
                        while (keys.hasMoreElements()) {
                            String keyName;
                            key = (String)keys.nextElement();
                            text = section.getProperty(key);
                            StringTokenizer st = new StringTokenizer(key, ": ");
                            String deviceName = st.nextToken();
                            LearnedSignal ls = this.findLearnedSignal(deviceName, keyName = st.nextToken());
                            if (ls == null) continue;
                            ls.setNotes(text);
                        }
                    }
                    section = pr.nextSection();
                }
            }
        }
        this.convertKeyMoves();
        this.migrateKeyMovesToDeviceUpgrades();
        if (deleteUsedProts) {
            it = this.protocols.iterator();
            while (it.hasNext()) {
                if (!((ProtocolUpgrade)it.next()).isUsed()) continue;
                it.remove();
            }
            for (ProtocolUpgrade pu : this.protocols) {
                pu.setManualProtocol(this.remote);
            }
        }
        it = this.devices.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        if (this.remote.usesEZRC() && this.deviceButtonList == null) {
            this.deviceButtonList = new ArrayList<DeviceButton>();
        }
    }

    public void saveAltPIDs() {
        for (DeviceUpgrade du : this.devices) {
            if (du.getProtocol() == null) continue;
            du.getProtocol().saveAltPID(this.remote);
        }
        for (ProtocolUpgrade pu : this.protocols) {
            if (pu.getProtocol() == null) continue;
            pu.getProtocol().saveAltPID(this.remote);
        }
    }

    private int exportAdvancedCodeNotes(List<? extends AdvancedCode> codes, int index, PrintWriter out) throws IOException {
        for (AdvancedCode advancedCode : codes) {
            String text = advancedCode.getNotes();
            if (text != null && !text.trim().isEmpty()) {
                out.printf("$%4X=%s\n", index, this.exportNotes(text));
            }
            ++index;
        }
        return index;
    }

    public void exportIR(File file) throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        this.exportIR(pw);
    }

    public String exportIR() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exportIR(pw);
        return sw.toString();
    }

    public void exportIR(PrintWriter out) throws IOException {
        String text;
        String text2;
        int sigAddr;
        boolean sigDataTest;
        this.updateImage();
        boolean bl = this.sigData == null ? true : (sigDataTest = (this.sigData[2] | this.sigData[3]) != 0 || this.sigData[0] + this.sigData[1] == 255);
        if (this.hasSegments()) {
            out.println("[Signature]");
            String sig = this.remote.getSignature();
            sigAddr = Math.max(this.getSigAddress(), 0);
            short[] sd = this.sigData;
            if (sd == null || sig.startsWith("USB") || !sigDataTest) {
                sigAddr = 0;
                sd = new short[sig.length()];
                for (int i = 0; i < sig.length(); ++i) {
                    sd[i] = (short)sig.charAt(i);
                }
            }
            Hex.print(out, sd, sigAddr);
            out.println();
            out.println("[Buffer]");
        }
        short[] dataToSave = this.owner.useSavedData() ? this.savedData : this.data;
        Hex.print(out, Arrays.copyOf(dataToSave, this.getDataEnd(dataToSave)), this.remote.getBaseAddress());
        if (this.hasSegments()) {
            if (this.icinfo != null) {
                out.println();
                out.println("[Info]");
                out.println(Hex.toString(this.icinfo));
            }
            sigAddr = 0;
            if (this.sigData != null && (sigAddr = this.getSigAddress()) >= 0 && (this.remote.getSignature().startsWith("USB") || !sigDataTest)) {
                out.println();
                out.println("[SigBlock]");
                Hex.print(out, this.sigData, sigAddr);
            }
            if (this.rfData != null) {
                out.println();
                out.println("[RFData]");
                Hex.print(out, this.rfData, RMIRSetup.getRfDataAddress());
            }
        }
        out.println();
        out.println("[Notes]");
        if (this.notes != null && !this.notes.trim().isEmpty()) {
            out.println("$0000=" + this.exportNotes(this.notes));
        }
        if (this.remote.isSSD()) {
            out.close();
            return;
        }
        int i = 4096;
        this.updateSpecialFunctionSublists();
        i = this.exportAdvancedCodeNotes(this.keymoves, i, out);
        i = this.exportAdvancedCodeNotes(this.upgradeKeyMoves, i, out);
        i = this.exportAdvancedCodeNotes(this.specialFunctionKeyMoves, i, out);
        i = this.exportAdvancedCodeNotes(this.macros, i, out);
        i = this.exportAdvancedCodeNotes(this.specialFunctionMacros, i, out);
        if (this.remote.hasFavKey() && !this.remote.getFavKey().isSegregated()) {
            i = this.exportAdvancedCodeNotes(this.favScans, i, out);
        }
        if (this.remote.getMacroCodingType().hasTimedMacros()) {
            i = this.exportAdvancedCodeNotes(this.timedMacros, i, out);
        }
        i = 8192;
        if (this.remote.getTimedMacroAddress() != null) {
            i = this.exportAdvancedCodeNotes(this.timedMacros, i, out);
        }
        i = 12288;
        ArrayList<DeviceUpgrade> devIndependent = new ArrayList<DeviceUpgrade>();
        ArrayList<DeviceUpgrade> devDependent = new ArrayList<DeviceUpgrade>();
        for (DeviceUpgrade dev : this.devices) {
            if (dev.getButtonIndependent().booleanValue()) {
                devIndependent.add(dev);
                continue;
            }
            if (dev.getButtonRestriction() == DeviceButton.noButton) continue;
            devDependent.add(dev);
        }
        if (!this.remote.usesEZRC()) {
            Collections.sort(devDependent, new DependentUpgradeComparator());
        }
        for (DeviceUpgrade device : devIndependent) {
            text2 = device.getDescription();
            if (text2 != null && !text2.trim().isEmpty()) {
                out.printf("$%4X=%s\n", i, this.exportNotes(text2));
            }
            ++i;
        }
        for (int j = devDependent.size() - 1; j >= 0; --j) {
            int k = this.hasSegments() ? devDependent.size() - j - 1 : j;
            text2 = ((DeviceUpgrade)devDependent.get(k)).getDescription();
            if (text2 != null && !text2.trim().isEmpty()) {
                out.printf("$%4X=%s\n", i, this.exportNotes(text2));
            }
            ++i;
        }
        LinkedHashMap<Protocol, ProtocolUpgrade> outputProtocols = this.getOutputProtocolUpgrades(false);
        for (int j = devDependent.size() - 1; j >= 0; --j) {
            Protocol p;
            DeviceUpgrade dev = (DeviceUpgrade)devDependent.get(j);
            if (!dev.needsProtocolCode() || outputProtocols.get(p = dev.getProtocol()) != null) continue;
            int pid = p.getID().get(0);
            outputProtocols.put(p, new ProtocolUpgrade(pid, dev.getCode(), p.getName()));
        }
        i = 16384;
        for (ProtocolUpgrade protocol : outputProtocols.values()) {
            text = protocol.getNotes();
            if (text != null && !text.trim().isEmpty()) {
                out.printf("$%4X=%s\n", i, this.exportNotes(text));
            }
            ++i;
        }
        i = 20480;
        for (LearnedSignal signal : this.learned) {
            text = signal.getNotes();
            if (text != null && !text.trim().isEmpty()) {
                out.printf("$%4X=%s\n", i, this.exportNotes(text));
            }
            ++i;
        }
        i = 24576;
        for (int j = 0; j < this.deviceButtonNotes.length; ++j) {
            text2 = this.deviceButtonNotes[j];
            if (text2 == null || text2.trim().isEmpty()) continue;
            out.printf("$%4X=%s\n", i + j, this.exportNotes(text2));
        }
        out.close();
    }

    public DeviceUpgrade findDeviceUpgrade(DeviceButton deviceButton) {
        short[] data = this.hasSegments() ? deviceButton.getSegment().getHex().getData() : this.data;
        return this.findDeviceUpgrade(deviceButton.getDeviceTypeIndex(data), deviceButton.getSetupCode(data));
    }

    public DeviceUpgrade findDeviceUpgrade(int deviceTypeIndex, int setupCode) {
        System.err.println("in findDeviceUpgrade( " + deviceTypeIndex + ", " + setupCode + " )");
        for (DeviceUpgrade deviceUpgrade : this.devices) {
            System.err.println("Checking " + deviceUpgrade);
            if (deviceTypeIndex != deviceUpgrade.getDeviceType().getNumber() || setupCode != deviceUpgrade.getSetupCode()) continue;
            System.err.println("It's a match!");
            return deviceUpgrade;
        }
        System.err.println("No match found!");
        return null;
    }

    public int findBoundDeviceButtonIndex(DeviceUpgrade upgrade) {
        int deviceTypeIndex = upgrade.getDeviceType().getNumber();
        int setupCode = upgrade.getSetupCode();
        if (!this.remote.usesEZRC()) {
            return this.findBoundDeviceButtonIndex(deviceTypeIndex, setupCode);
        }
        DeviceButton devBtn = upgrade.getButtonRestriction();
        for (int i = 0; i < this.deviceButtonList.size(); ++i) {
            if (devBtn != this.deviceButtonList.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int findBoundDeviceButtonIndex(int deviceTypeIndex, int setupCode) {
        short[] data = this.data;
        DeviceButton[] deviceButtons = this.remote.getDeviceButtons();
        for (int i = 0; i < deviceButtons.length; ++i) {
            DeviceButton deviceButton = deviceButtons[i];
            if (this.hasSegments()) {
                if (deviceButton.getSegment() == null) continue;
                data = deviceButton.getSegment().getHex().getData();
            }
            if (deviceButton.getDeviceTypeIndex(data) != deviceTypeIndex || deviceButton.getSetupCode(data) != setupCode) continue;
            return i;
        }
        return -1;
    }

    public RemoteConfiguration(Remote remote, RMIRSetup rm) {
        int eepromSize;
        this.owner = rm;
        this.remote = remote;
        this.createActivities();
        SetupCode.setMax(remote);
        RMIRSetup.disableActivitiesItem.setSelected(false);
        int pageSize = remote.getProcessor().getPageSize();
        int dataSize = eepromSize = remote.getEepromSize();
        if (remote.isJP2style() && eepromSize % pageSize != 0) {
            dataSize = (eepromSize / pageSize + 1) * pageSize;
        }
        this.data = new short[dataSize];
        this.highlight = new Color[dataSize + 8 * remote.getSettingAddresses().size()];
        for (int i = 0; i < this.highlight.length; ++i) {
            this.highlight[i] = Color.WHITE;
        }
        if (remote.usesEZRC()) {
            this.gidList = new ArrayList<Integer>();
            this.gidRegister = new HashMap();
        }
        this.deviceButtonNotes = new String[remote.getDeviceButtons().length];
        RMIRSetup.setSystemFilesItems(rm, remote);
    }

    public void parseData() throws IOException {
        System.err.println("Data parsing started");
        this.importIR(null, true);
        System.err.println("Data parsing ended");
    }

    public void decodeSettings() {
        System.err.println("Decoding settings");
        Setting[] settings = this.remote.getSettings();
        List<Segment> segs = null;
        for (Setting setting : settings) {
            if (this.hasSegments()) {
                int type = (setting.getByteAddress() >> 8) - 1;
                if (type < 0 || (segs = this.segments.get(type)) == null || segs.size() == 0) continue;
                setting.decode(segs.get(0).getHex().getData(), this.remote);
                continue;
            }
            setting.decode(this.data, this.remote);
        }
    }

    public List<SpecialProtocol> getSpecialProtocols() {
        ArrayList<SpecialProtocol> availableSpecialProtocols = new ArrayList<SpecialProtocol>();
        List<SpecialProtocol> specialProtocols = this.remote.getSpecialProtocols();
        for (SpecialProtocol sp : specialProtocols) {
            if (!sp.isPresent(this)) continue;
            availableSpecialProtocols.add(sp);
        }
        return availableSpecialProtocols;
    }

    private void decodeFavScans() {
        if (!this.remote.hasFavKey() || !this.remote.getFavKey().isSegregated()) {
            return;
        }
        HexReader reader = new HexReader(this.data, this.remote.getFavScanAddress());
        FavScan favScan = FavScan.read(reader, this.remote);
        if (favScan != null) {
            this.favScans.add(favScan);
            this.favKeyDevButton = favScan.getDeviceButtonFromIndex(this.remote);
        }
    }

    private void decodeTimedMacros() {
        if (this.remote.getMacroCodingType().get_Type() == 2 || !this.remote.hasTimedMacroSupport()) {
            return;
        }
        HexReader reader = new HexReader(this.data, this.remote.getTimedMacroAddress());
        TimedMacro timedMacro = null;
        while ((timedMacro = TimedMacro.read(reader, this.remote)) != null) {
            this.timedMacros.add(timedMacro);
        }
    }

    private List<DeviceUpgrade> getSpecialUpgrades() {
        ArrayList<DeviceUpgrade> specialUpgrades = new ArrayList<DeviceUpgrade>();
        List<SpecialProtocol> specialProtocols = this.remote.getSpecialProtocols();
        for (SpecialProtocol sp : specialProtocols) {
            if (sp.isInternal()) continue;
            System.err.println("Checking for Special Procotol " + sp.getName() + " w/ PID=" + sp.getPid().toString());
            DeviceUpgrade device = sp.getDeviceUpgrade(this.devices);
            if (device == null) continue;
            specialUpgrades.add(device);
            System.err.println("SpecialFunction Upgrade at " + device.getDeviceType().getName() + "/" + device.getSetupCode());
        }
        return specialUpgrades;
    }

    private List<AdvancedCode> decodeAdvancedCodes() {
        System.err.println("Decoding advanced codes");
        List<DeviceUpgrade> specialUpgrades = this.getSpecialUpgrades();
        ArrayList<AdvancedCode> advCodes = new ArrayList<AdvancedCode>();
        if (this.remote.getAdvancedCodeAddress() == null) {
            return advCodes;
        }
        HexReader reader = new HexReader(this.data, this.remote.getAdvancedCodeAddress());
        AdvancedCode advCode = null;
        while ((advCode = AdvancedCode.read(reader, this.remote)) != null) {
            SpecialProtocol sp;
            if (advCode instanceof Macro) {
                Button[] multiBtns;
                Button baseBtn;
                Macro macro = (Macro)advCode;
                sp = this.getSpecialProtocol(macro);
                if (sp != null) {
                    baseBtn = this.remote.getBaseButton(macro.getKeyCode());
                    multiBtns = this.remote.getMacroButtons(Macro.MacroClass.MULTI, false);
                    macro.setMacroClass(multiBtns != null && Arrays.asList(multiBtns).contains(baseBtn) ? Macro.MacroClass.MULTI : Macro.MacroClass.NORMAL);
                    SpecialProtocolFunction sf = sp.createFunction(macro);
                    if (sf == null) continue;
                    this.specialFunctions.add(sf);
                    advCodes.add(sf.getMacro());
                    continue;
                }
                baseBtn = this.remote.getBaseButton(macro.getKeyCode());
                multiBtns = this.remote.getMacroButtons(Macro.MacroClass.MULTI, false);
                macro.setMacroClass(multiBtns != null && Arrays.asList(multiBtns).contains(baseBtn) ? Macro.MacroClass.MULTI : Macro.MacroClass.NORMAL);
                this.macros.add(macro);
                advCodes.add(macro);
                continue;
            }
            if (advCode instanceof FavScan) {
                FavScan favScan = (FavScan)advCode;
                if (this.remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
                    int deviceIndex = this.data[this.remote.getFavKey().getDeviceButtonAddress()];
                    if (deviceIndex == 255) {
                        deviceIndex = -1;
                    }
                    favScan.setDeviceIndex(deviceIndex);
                    this.favKeyDevButton = favScan.getDeviceButtonFromIndex(this.remote);
                } else {
                    this.favKeyDevButton = favScan.getDeviceButtonFromIndex(this.remote);
                    favScan.setDeviceButton(this.favKeyDevButton);
                }
                this.favScans.add(favScan);
                advCodes.add(favScan);
                continue;
            }
            if (advCode instanceof TimedMacro) {
                TimedMacro timedMacro = (TimedMacro)advCode;
                this.timedMacros.add(timedMacro);
                advCodes.add(timedMacro);
                continue;
            }
            KeyMove keyMove = (KeyMove)advCode;
            sp = this.getSpecialProtocol(keyMove, specialUpgrades);
            if (sp != null) {
                SpecialProtocolFunction sf = sp.createFunction(keyMove = new KeyMove(keyMove.getKeyCode(), keyMove.getDeviceButtonIndex(), keyMove.getData(), keyMove.getNotes()));
                if (sf == null) continue;
                this.specialFunctions.add(sf);
                advCodes.add(sf.getKeyMove());
                continue;
            }
            this.keymoves.add(keyMove);
            advCodes.add(keyMove);
        }
        return advCodes;
    }

    private void convertKeyMoves() {
        ListIterator<KeyMove> it = this.keymoves.listIterator();
        while (it.hasNext()) {
            KeyMove keyMove = it.next();
            if (keyMove instanceof KeyMoveKey) continue;
            int keyCode = keyMove.getKeyCode();
            DeviceUpgrade moveUpgrade = this.findDeviceUpgrade(keyMove.getDeviceType(), keyMove.getSetupCode());
            Hex cmd = keyMove.getCmd();
            if (this.remote.getAdvCodeBindFormat() != AdvancedCode.BindFormat.LONG || this.remote.getAdvCodeFormat() != AdvancedCode.Format.HEX || moveUpgrade == null || moveUpgrade.getProtocol().getDefaultCmdLength() != 1 || cmd.length() != 2) continue;
            int segFlags = keyMove.getSegmentFlags();
            cmd = cmd.subHex(0, 1);
            keyMove = new KeyMoveLong(keyCode, keyMove.getDeviceButtonIndex(), keyMove.getDeviceType(), keyMove.getSetupCode(), cmd, keyMove.getNotes());
            keyMove.setSegmentFlags(segFlags);
            it.set(keyMove);
        }
    }

    private void migrateKeyMovesToDeviceUpgrades() {
        ArrayList<KeyMove> kmToRemove = new ArrayList<KeyMove>();
        for (KeyMove keyMove : this.keymoves) {
            Button b;
            if (keyMove.getClass() == KeyMoveKey.class) continue;
            int keyCode = keyMove.getKeyCode();
            DeviceButton boundDeviceButton = this.remote.getDeviceButton(keyMove.getDeviceButtonIndex());
            DeviceUpgrade boundUpgrade = this.findDeviceUpgrade(boundDeviceButton);
            DeviceUpgrade moveUpgrade = this.findDeviceUpgrade(keyMove.getDeviceType(), keyMove.getSetupCode());
            if (boundUpgrade == null || boundUpgrade != moveUpgrade) continue;
            Hex cmd = keyMove.getCmd();
            boolean migrate = true;
            for (int i : this.getDeviceButtonIndexList(boundUpgrade)) {
                if (i == keyMove.getDeviceButtonIndex()) continue;
                migrate = false;
                for (KeyMove km : this.keymoves) {
                    if (km.getDeviceButtonIndex() != i || km.getKeyCode() != keyCode) continue;
                    boolean bl = migrate = km.getDeviceType() == keyMove.getDeviceType() && km.getSetupCode() == keyMove.getSetupCode() && km.getCmd().equals(keyMove.getCmd());
                    break;
                }
                if (migrate) continue;
                break;
            }
            if (migrate && (b = this.remote.getButton(keyMove.getKeyCode())) != null) {
                boolean bl = migrate = !this.remote.getDeviceTypeByIndex(keyMove.getDeviceType()).getButtonMap().isPresent(b);
            }
            if (!migrate) continue;
            Function f = boundUpgrade.getFunction(cmd);
            if (f == null) {
                f = new Function(this.remote.getButtonName(keyCode), cmd, keyMove.getNotes());
                f.setUpgrade(boundUpgrade);
                boundUpgrade.getFunctions().add(f);
            }
            System.err.println("Moving keymove on " + boundDeviceButton + ':' + this.remote.getButtonName(keyMove.getKeyCode()) + " to device upgrade " + boundUpgrade.getDeviceType() + '/' + boundUpgrade.getSetupCode());
            boundUpgrade.setFunction(keyCode, f);
            kmToRemove.add(keyMove);
        }
        for (KeyMove km : kmToRemove) {
            this.keymoves.remove(km);
        }
    }

    public List<Integer> getDeviceButtonIndexList(DeviceUpgrade upgrade) {
        ArrayList<Integer> dbList = new ArrayList<Integer>();
        DeviceButton[] deviceButtons = this.remote.getDeviceButtons();
        short[] data = this.data;
        for (int i = 0; i < deviceButtons.length; ++i) {
            DeviceButton button = deviceButtons[i];
            if (this.hasSegments()) {
                if (button.getSegment() == null) continue;
                data = button.getSegment().getHex().getData();
            }
            if (button.getDeviceTypeIndex(data) != upgrade.getDeviceType().getNumber() || button.getSetupCode(data) != upgrade.getSetupCode()) continue;
            dbList.add(button.getButtonIndex());
        }
        return dbList;
    }

    public DeviceUpgrade getAssignedDeviceUpgrade(DeviceButton deviceButton) {
        short[] data = this.data;
        if (this.hasSegments()) {
            data = deviceButton.getSegment().getHex().getData();
        }
        DeviceType deviceType = this.remote.getDeviceTypeByIndex(deviceButton.getDeviceTypeIndex(data));
        short setupCode = deviceButton.getSetupCode(data);
        DeviceUpgrade upgrade = null;
        for (DeviceUpgrade candidate : this.devices) {
            if (candidate.setupCode != setupCode || candidate.getDeviceType() != deviceType) continue;
            upgrade = candidate;
            break;
        }
        return upgrade;
    }

    public SpecialProtocol getSpecialProtocol(DeviceUpgrade upgrade) {
        for (SpecialProtocol sp : this.remote.getSpecialProtocols()) {
            if (!upgrade.getProtocol().getID().equals(sp.getPid())) continue;
            return sp;
        }
        return null;
    }

    private SpecialProtocol getSpecialProtocol(KeyMove keyMove, List<DeviceUpgrade> specialUpgrades) {
        System.err.println("getSpecialProtocol");
        int setupCode = keyMove.getSetupCode();
        int deviceType = keyMove.getDeviceType();
        System.err.println("getSpecialProtocol: looking for " + deviceType + '/' + setupCode);
        for (SpecialProtocol sp : this.remote.getSpecialProtocols()) {
            System.err.println("Checking " + sp);
            if (!sp.isPresent(this) || setupCode != sp.getSetupCode() || deviceType != sp.getDeviceType().getNumber()) continue;
            return sp;
        }
        DeviceUpgrade moveUpgrade = this.findDeviceUpgrade(keyMove.getDeviceType(), keyMove.getSetupCode());
        if (moveUpgrade != null && specialUpgrades.contains(moveUpgrade)) {
            return this.getSpecialProtocol(moveUpgrade);
        }
        return null;
    }

    public SpecialProtocol getSpecialProtocol(Macro macro) {
        for (SpecialProtocol sp : this.remote.getSpecialProtocols()) {
            if (!sp.isInternal() || sp.getInternalSerial() != macro.getSequenceNumber() || macro.getDeviceButtonIndex() == -1 || macro.getMacroClass() == Macro.MacroClass.ACTIVITYPOWER) continue;
            return sp;
        }
        return null;
    }

    public void checkUnassignedUpgrades() {
        for (DeviceUpgrade device : this.devices) {
            int boundDeviceButtonIndex = this.findBoundDeviceButtonIndex(device);
            if (device.getKeyMoves().isEmpty() || boundDeviceButtonIndex != -1) continue;
            Object[] devButtons = this.remote.getDeviceButtons();
            DeviceButton devButton = (DeviceButton)JOptionPane.showInputDialog(RemoteMaster.getFrame(), "The device upgrade \"" + device.toString() + "\" uses keymoves.\n\nThese keymoves will not be available unless it is assigned to a device button.\n\nIf you like to assign this device upgrade to a device button?\nTo assign it, select the desired device button and press OK.  Otherwise please press Cancel.", "Unassigned Device Upgrade", 3, null, devButtons, null);
            if (devButton == null) continue;
            devButton.setSetupCode((short)device.getSetupCode(), this.data);
            devButton.setDeviceTypeIndex((short)this.remote.getDeviceTypeByAliasName(device.getDeviceTypeAliasName()).getNumber(), this.data);
        }
    }

    public void updateImage() {
        LinkedHashMap<Protocol, ProtocolUpgrade> outputProtocols = null;
        this.cleanMacros();
        if (this.remote.isSSD()) {
            this.ssdFiles.remove("home.xcf");
            this.ssdFiles.remove("system.xcf");
            this.ssdFiles.remove("devices.xcf");
            this.ssdFiles.remove("activities.xcf");
            this.ssdFiles.remove("profiles.xcf");
            this.ssdFiles.remove("favorites.xcf");
            this.ssdFiles.remove("macros.xcf");
            this.ssdFileData.clear();
            LinkedHashMap<Integer, ArrayList<GeneralFunction.RMIcon>> map = new LinkedHashMap<Integer, ArrayList<GeneralFunction.RMIcon>>();
            Comparator<GeneralFunction.RMIcon> sortUp = new Comparator<GeneralFunction.RMIcon>(){

                @Override
                public int compare(GeneralFunction.RMIcon icon1, GeneralFunction.RMIcon icon2) {
                    return new Integer(icon1.ref).compareTo(new Integer(icon2.ref));
                }
            };
            Comparator<GeneralFunction.RMIcon> sortDown = new Comparator<GeneralFunction.RMIcon>(){

                @Override
                public int compare(GeneralFunction.RMIcon icon1, GeneralFunction.RMIcon icon2) {
                    return new Integer(icon2.ref).compareTo(new Integer(icon1.ref));
                }
            };
            if (this.userIcons == null) {
                this.userIcons = new LinkedHashMap();
            }
            for (GeneralFunction.RMIcon rMIcon : this.userIcons.values()) {
                int type = rMIcon.type;
                ArrayList<GeneralFunction.RMIcon> list = (ArrayList<GeneralFunction.RMIcon>)map.get(type);
                if (list == null) {
                    list = new ArrayList<GeneralFunction.RMIcon>();
                    map.put(type, list);
                }
                list.add(rMIcon);
            }
            this.userIcons.clear();
            int ref = 127;
            if (map.get(6) != null) {
                Collections.sort((List)map.get(6), sortUp);
                for (GeneralFunction.RMIcon icon : (List)map.get(6)) {
                    icon.ref = ref++;
                    this.userIcons.put(icon.ref, icon);
                }
            }
            ref = 206;
            if (map.get(9) != null) {
                Collections.sort((List)map.get(9), sortDown);
                for (GeneralFunction.RMIcon icon : (List)map.get(9)) {
                    icon.ref = ref--;
                    this.userIcons.put(icon.ref, icon);
                }
            }
            if (map.get(8) != null) {
                Collections.sort((List)map.get(8), sortDown);
                for (GeneralFunction.RMIcon icon : (List)map.get(8)) {
                    icon.ref = ref--;
                    this.userIcons.put(icon.ref, icon);
                }
            }
            ArrayList<Highlight> arrayList = new ArrayList<Highlight>();
            this.macros = this.getAllMacros(false);
            arrayList.addAll(this.getAllMacros(false));
            arrayList.addAll(this.learned);
            this.setHighlightUploadStatusValues(arrayList);
            this.updateSettings();
            SSDFile file = this.makeDevicesXCF();
            if (file != null) {
                this.ssdFiles.put("devices.xcf", file);
                file.index = 2;
            }
            if ((file = this.makeActivitiesXCF()) != null) {
                this.ssdFiles.put("activities.xcf", file);
                file.index = 3;
            }
            if ((file = this.makeProfilesXCF()) != null) {
                this.ssdFiles.put("profiles.xcf", file);
                file.index = 4;
            }
            if ((file = this.makeFavoritesXCF()) != null) {
                this.ssdFiles.put("favorites.xcf", file);
                file.index = 5;
            }
            if ((file = this.makeMacrosXCF()) != null) {
                this.ssdFiles.put("macros.xcf", file);
                file.index = 6;
            }
            file = this.makeHomeXCF();
            this.ssdFiles.put("home.xcf", file);
            file.index = 0;
            file = this.makeSystemXCF();
            if (file != null) {
                this.ssdFiles.put("system.xcf", file);
                file.index = 1;
            }
            int pos = 4;
            int status = 0;
            Arrays.fill(this.data, (short)255);
            Hex hex = null;
            for (int n = 0; n < Remote.userFilenames.length; ++n) {
                SSDFileInfo info = new SSDFileInfo();
                String name = Remote.userFilenames[n];
                if (name.equals("usericons.pkg")) {
                    hex = this.makeUserIconsPKG();
                    info.index = n;
                    this.ssdFileData.add(info);
                } else if (name.equalsIgnoreCase("SysIcons.pkg")) {
                    this.remote.getUsageRange().setFreeStart(pos);
                    file = this.ssdFiles.get(name);
                    hex = file != null ? file.hex : null;
                    info.index = n;
                    this.ssdFileData.add(info);
                } else if (name.endsWith(".xcf")) {
                    file = this.ssdFiles.get(name);
                    if (file == null) continue;
                    this.ssdFileData.add(info);
                    info.index = file.index;
                    int tagSize = 0;
                    for (String s : file.tagNames) {
                        tagSize += s.length() + 1;
                    }
                    info.xcfStart = pos + 17 + tagSize;
                    hex = this.makeBXMLFile(file);
                    System.err.print("File " + name + ": bxmlStart=" + Integer.toHexString(info.fileStart) + "  xcfStart=" + Integer.toHexString(info.xcfStart) + "\n\n");
                }
                if (hex == null) continue;
                status |= 1 << n;
                System.arraycopy(hex.getData(), 0, this.data, pos, hex.length());
                info.fileStart = pos;
                info.fileEnd = pos += hex.length();
            }
            this.data[0] = (short)(status & 0xFF);
            this.data[1] = (short)(status >> 8 & 0xF | pos >> 12 & 0xF0);
            this.data[2] = (short)(pos & 0xFF);
            this.data[3] = (short)(pos >> 8 & 0xFF);
            return;
        }
        for (int i = 0; i < this.highlight.length; ++i) {
            this.highlight[i] = Color.WHITE;
        }
        if (this.remote.usesEZRC()) {
            ArrayList<Highlight> highlights = new ArrayList<Highlight>();
            highlights.addAll(this.getAllMacros(false));
            highlights.addAll(this.learned);
            this.setHighlightUploadStatusValues(highlights);
            List<Button> sysBtns = this.remote.getSystemButtons();
            block7: for (DeviceButton db : this.deviceButtonList) {
                DeviceUpgrade deviceUpgrade = db.getUpgrade();
                if (deviceUpgrade == null) continue;
                ArrayList<Function> sysFns = new ArrayList<Function>();
                if (sysBtns != null) {
                    for (Button b : sysBtns) {
                        Function f = null;
                        f = deviceUpgrade.getAssignments().getAssignment(b);
                        if (f == null) continue;
                        if (!sysFns.contains(f)) {
                            sysFns.add(f);
                        }
                        deviceUpgrade.getAssignments().assign(b, null);
                    }
                }
                db.getUpgrade().filterFunctionMap();
                for (Function f : sysFns) {
                    if (deviceUpgrade.getFunctionMap().containsValue(f)) continue;
                    int serial = deviceUpgrade.getNewFunctionSerial(f, true);
                    if (serial < 0) continue block7;
                    deviceUpgrade.getFunctionMap().put(serial, f);
                    f.setSerial(serial);
                }
            }
        }
        this.updateFixedData(false);
        this.updateAutoSet();
        this.updateDeviceButtons();
        if (this.hasSegments()) {
            this.updateInputKeySetting();
        }
        this.updateSettings();
        this.updateAdvancedCodes();
        if (this.remote.hasFavKey() && this.remote.getFavKey().isSegregated()) {
            this.updateFavScans();
        }
        if (this.remote.getTimedMacroAddress() != null) {
            this.updateTimedMacros();
        }
        this.updateLearnedSignals();
        outputProtocols = this.updateUpgrades();
        if (this.hasSegments()) {
            short erasedByte;
            Hex hex;
            this.updateActivities();
            this.updateKeyAssignments();
            this.updateFavorites();
            this.updateLEDColor();
            this.updateGlobalPunchthru();
            int pos = 2;
            int e2Offset = this.remote.getE2FormatOffset();
            if (e2Offset >= 0) {
                int i;
                Arrays.fill(this.data, 0, 20, (short)255);
                int size = this.remote.getEepromSize();
                for (i = 24; i >= 0; i -= 8) {
                    this.data[pos++] = (short)(size >> i & 0xFF);
                }
                if (this.eepromFormatVersion != null) {
                    for (i = 0; i < this.eepromFormatVersion.length(); ++i) {
                        this.data[pos++] = (short)this.eepromFormatVersion.charAt(i);
                    }
                }
                pos = 20;
            }
            if (this.segmentLoadOrder.contains(221) && this.segments.get(221) == null) {
                Hex segData = new Hex(new short[]{0, 238, 255, 255});
                this.segments.put(221, new ArrayList());
                this.segments.get(221).add(new Segment(221, 255, segData));
            }
            if (this.segments.get(29) != null && !this.remote.hasFavorites() && (hex = this.segments.get(29).get(0).getHex()).length() > 3) {
                hex.getData()[2] = 0;
            }
            for (int type : this.segmentLoadOrder) {
                List<Segment> list = this.segments.get(type);
                if (list == null) continue;
                pos = Segment.writeData(list, this.data, pos);
            }
            if (this.segmentBackups != null) {
                for (int type : this.segmentLoadOrder) {
                    List<Segment> list = this.segmentBackups.get(type);
                    if (list == null) continue;
                    pos = Segment.writeData(list, this.data, pos);
                }
            }
            this.data[pos] = erasedByte = this.remote.getProcessor().getErasedByte();
            this.data[pos + 1] = erasedByte;
            this.remote.getUsageRange().setFreeStart(pos + 2);
            this.settingMap.clear();
            for (int n : this.remote.getSettingAddresses().keySet()) {
                int segmentType = (n >> 8) - 1;
                int byteAddress = n & 0xFF;
                List<Segment> segs = this.segments.get(segmentType);
                if (segs == null || segs.size() == 0) continue;
                int address = segs.get(0).getAddress();
                int offset = address + 4 + byteAddress;
                this.settingMap.put(offset, this.remote.getSettingAddresses().get(n));
            }
            this.updateKeyMoveHighlights(this.keymoves);
            this.updateKeyMoveHighlights(this.upgradeKeyMoves);
            this.updateMacroHighlights();
            this.updateUpgradeHighlights(outputProtocols);
            this.updateLearnedHighlights();
            this.updateglobalPunchthruHighlights();
            if (this.remote.usesEZRC()) {
                this.updateActivityHighlightsEZRC();
                this.updateFavoritesHighlights();
            } else if (this.remote.usesSimpleset()) {
                this.updateActivityHighlightsEZRC();
            } else {
                this.updateActivityHighlights();
            }
            this.owner.setRfRegistrationEnabled(false);
            if (this.remote.hasRf4ceSupport() && this.segments.get(32) != null) {
                int rfCodeCount = this.remote.getRfSetupCodes().size();
                for (Segment seg : this.segments.get(32)) {
                    short nvid = seg.getHex().getData()[1];
                    short pairRef = seg.getHex().getData()[2];
                    if (nvid < 36 || nvid >= 36 + rfCodeCount || pairRef == 255) continue;
                    this.owner.setRfRegistrationEnabled(true);
                    break;
                }
            } else if (this.remote.hasRf4ceSupport() && this.rfData != null) {
                this.owner.setRfRegistrationEnabled(true);
            }
            AddressRange range = this.remote.getCheckSums()[0].getAddressRange();
            int n = range.getEnd();
            range.setEnd(pos - 1);
            while (pos <= n) {
                this.data[pos++] = erasedByte;
            }
            if (erasedByte != 255) {
                pos = range.getEnd() + 1;
                while (pos < this.remote.getEepromSize()) {
                    this.data[pos++] = erasedByte;
                }
            }
        }
        this.updateCheckSums();
        this.checkImageForByteOverflows();
    }

    public HashMap<Integer, Integer> getSettingMap() {
        return this.settingMap;
    }

    private void updateKeyMoveHighlights(List<KeyMove> keyMoves) {
        for (KeyMove keyMove : keyMoves) {
            Segment segment = keyMove.getSegment();
            if (segment == null) {
                return;
            }
            int segType = segment.get_Type();
            int address = segment.getAddress();
            this.updateHighlight(keyMove, address + 4, segType == 7 ? 6 : 8);
        }
    }

    private void updateMacroHighlights() {
        ArrayList<Macro> allMacros = new ArrayList<Macro>();
        allMacros.addAll(this.getAllMacros(false));
        allMacros.addAll(this.specialFunctionMacros);
        for (Macro macro : allMacros) {
            int len;
            Segment segment = macro.getSegment();
            if (segment == null) continue;
            int index = macro.getIndex();
            int segType = segment.get_Type();
            int address = segment.getAddress();
            short[] segData = segment.getHex().getData();
            if (segType == 1) {
                this.updateHighlight(macro, address + 4, segData[2] + 3);
                continue;
            }
            if (segType == 2) {
                int pos = 3;
                for (int i = 0; i < index; ++i) {
                    pos += segData[pos] + 1;
                }
                this.updateHighlight(macro, address + pos + 4, segData[pos] + 1);
                if (index != 0) continue;
                this.updateHighlight(macro, address + pos + 1, 2);
                continue;
            }
            if (segType == 3) {
                len = 2 * segData[2];
                if (macro.getItems().size() > 0 && macro.getItems().get(0).getCodeSize() == 2) {
                    len *= 2;
                }
                if (this.remote.usesEZRC()) {
                    len += segData[3 + len] + 3;
                }
                this.updateHighlight(macro, address + 4, len + 3);
                continue;
            }
            if (segType != 4) continue;
            len = macro.getData().length() + 5;
            this.updateHighlight(macro, address + 4, len);
        }
    }

    private void updateUpgradeHighlights(LinkedHashMap<Protocol, ProtocolUpgrade> outputProtocols) {
        int address;
        Segment segment;
        for (DeviceUpgrade dev : this.devices) {
            Protocol prot;
            ProtocolUpgrade pu;
            segment = dev.getSegment();
            if (segment == null) continue;
            address = segment.getAddress();
            int protOffset = segment.get_Type() == 14 ? 0 : segment.getHex().get(2);
            int segSize = segment.getHex().length();
            int devSize = protOffset == 0 ? segSize - 4 : protOffset;
            this.updateHighlight(dev, address + 8, devSize);
            if (this.remote.getSegmentTypes().contains(16)) {
                int protSize = protOffset == 0 ? 0 : segSize - protOffset - 4;
                for (int i = 0; i < protSize; ++i) {
                    this.highlight[address + protOffset + 8 + i] = dev.getProtocolHighlight();
                }
            } else if (this.remote.getSegmentTypes().contains(15) && (pu = outputProtocols.get(prot = dev.getProtocol())) != null) {
                segment = pu.getSegment();
                address = segment.getAddress();
                int protSize = segment.getHex().length() - 4;
                dev.addProtocolMemoryUsage(-4);
                for (int i = 0; i < protSize; ++i) {
                    this.highlight[address + 8 + i] = dev.getProtocolHighlight();
                }
            }
            if ((segment = dev.getSoftButtonSegment()) != null) {
                address = segment.getAddress();
                this.updateHighlight(dev, address + 4, segment.getHex().length());
            }
            if ((segment = dev.getSoftFunctionSegment()) == null) continue;
            address = segment.getAddress();
            this.updateHighlight(dev, address + 4, segment.getHex().length());
        }
        if (this.remote.getSegmentTypes().contains(15)) {
            for (ProtocolUpgrade pu : this.protocols) {
                segment = pu.getSegment();
                if (segment == null) continue;
                address = segment.getAddress();
                this.updateHighlight(pu, address + 8, pu.getCode().length());
            }
        }
    }

    private void updateLearnedHighlights() {
        for (LearnedSignal ls : this.learned) {
            Segment segment = ls.getSegment();
            if (segment == null) continue;
            int address = segment.getAddress();
            int segSize = segment.getHex().length();
            this.updateHighlight(ls, address + 4, segSize);
        }
    }

    private void updateActivityHighlights() {
        if (this.activities == null) {
            return;
        }
        for (Activity activity : this.activities.values()) {
            Macro macro;
            if (activity.getSegment() == null) continue;
            Segment segment = activity.getSegment();
            int address = segment.getAddress();
            int type = segment.get_Type();
            if (type == 233) {
                activity.clearMemoryUsage();
                int tabIndex = this.remote.getButtonGroups().get("Activity").indexOf(activity.getButton());
                this.updateHighlight(activity, address + 8 + tabIndex, 1);
                continue;
            }
            if (type >= 205 && type < 205 + this.activities.size() && this.remote.hasActivityControl()) {
                activity.clearMemoryUsage();
                this.updateHighlight(activity, address + 4, 4);
                continue;
            }
            if (type == 205 && !this.remote.hasActivityControl() && this.noSetup == null) {
                activity.clearMemoryUsage();
                short[] segData = segment.getHex().getData();
                this.updateHighlight(activity, address + 4, segData[2] + 3);
                continue;
            }
            ActivityGroup[] groups = activity.getActivityGroups();
            int incr = this.remote.hasActivityControl() ? 0 : 1;
            int pos = 1 - incr;
            for (ActivityGroup group : groups) {
                group.clearMemoryUsage();
                this.updateHighlight(group, address + 6 + pos, 1);
                pos += incr;
            }
            activity.clearMemoryUsage();
            if (this.remote.hasActivityControl()) {
                this.updateHighlight(activity, address + 6, 1);
            }
            if ((segment = activity.getHelpSegment()) != null) {
                address = segment.getAddress();
                this.updateHighlight(activity, address + 4, 4);
            }
            if ((macro = activity.getMacro()) == null) continue;
            activity.addMemoryUsage(activity.getMacro().getMemoryUsage());
        }
    }

    private void updateActivityHighlightsEZRC() {
        Activity favActivity;
        Activity activity = favActivity = this.remote.getFavKey() != null ? this.remote.getFavKey().getActivity() : null;
        if (this.activities == null && favActivity == null) {
            return;
        }
        ArrayList<Activity> list = new ArrayList<Activity>();
        list.addAll(this.activities.values());
        if (this.favScans.size() > 0) {
            list.add(favActivity);
        }
        for (Activity activity2 : list) {
            int index;
            int len;
            short[] segData;
            Segment segment;
            if (!activity2.isActive()) continue;
            ActivityGroup[] groups = activity2.getActivityGroups();
            if (groups.length > 0) {
                segment = groups[0].getSegment();
                ArrayList<Short> keyCodes = new ArrayList<Short>();
                segData = segment.getHex().getData();
                len = segData[2];
                for (int i = 0; i < len; ++i) {
                    keyCodes.add(segData[3 + i]);
                }
                int address = segment.getAddress();
                for (ActivityGroup group : groups) {
                    group.clearMemoryUsage();
                    for (Button btn : group.getButtonGroup()) {
                        int pos = keyCodes.indexOf(btn.getKeyCode());
                        if (pos < 0) continue;
                        this.updateHighlight(group, address + 7 + pos, 1);
                        this.updateHighlight(group, address + len + 7 + pos, 1);
                    }
                    Segment softSegment = group.getSoftNamesSegment();
                    if (softSegment == null) continue;
                    int softAddress = softSegment.getAddress();
                    int softLen = softSegment.getHex().length();
                    if (softSegment.getHex().getData()[softLen - 1] == 255) {
                        --softLen;
                    }
                    this.updateHighlight(group, softAddress + 4, softLen);
                }
            }
            activity2.clearMemoryUsage();
            segment = activity2.getSegment();
            if (segment == null) {
                Macro macro = activity2.getMacro();
                if (macro == null || macro.getSegment() == null || macro.getData() == null) continue;
                activity2.addMemoryUsage(macro.getData().length() + 5);
                continue;
            }
            int address = segment.getAddress();
            segData = segment.getHex().getData();
            len = segData[2];
            for (index = 0; index < len && segData[3 + index] != activity2.getButton().getKeyCode(); ++index) {
            }
            if (index < len) {
                int i;
                int mPos;
                this.updateHighlight(activity2, address + 7 + index, 1);
                int nPos = mPos = 3 + len;
                for (i = 0; i < len; ++i) {
                    int incr = 2 * segData[nPos] + 1;
                    nPos += incr;
                    if (i >= index) continue;
                    mPos += incr;
                }
                ++nPos;
                for (i = 0; i < index; ++i) {
                    nPos += segData[nPos] + 1;
                }
                this.updateHighlight(activity2, address + 4 + mPos, 2 * segData[mPos] + 1);
                this.updateHighlight(activity2, address + 4 + nPos, segData[nPos] + 1);
            }
            if ((segment = activity2.getHelpSegment()) == null) continue;
            address = segment.getAddress();
            this.updateHighlight(activity2, address + 4, segment.getHex().length());
        }
    }

    private void updateFavoritesHighlights() {
        int i;
        int count = this.favScans.size();
        if (count == 0) {
            return;
        }
        Segment segment = this.favScans.get(0).getSegment();
        int address = segment.getAddress();
        short[] segData = segment.getHex().getData();
        int mPos = 7;
        int nPos = 7;
        for (i = 0; i < count; ++i) {
            nPos += segData[nPos] + 1;
        }
        ++nPos;
        for (i = 0; i < count; ++i) {
            FavScan fav = this.favScans.get(i);
            fav.clearMemoryUsage();
            this.updateHighlight(fav, address + 4 + mPos, segData[mPos] + 1);
            this.updateHighlight(fav, address + 4 + nPos, segData[nPos] + 1);
            mPos += segData[mPos] + 1;
            nPos += segData[nPos] + 1;
        }
    }

    private void updateglobalPunchthruHighlights() {
        for (GlobalPT globalPT : this.globalPTs) {
            Segment segment = globalPT.getSegment();
            if (segment == null) {
                return;
            }
            int address = segment.getAddress();
            int segSize = segment.getHex().length();
            this.updateHighlight(globalPT, address + 4, segSize);
        }
    }

    private void checkImageForByteOverflows() {
        for (int i = 0; i < this.data.length; ++i) {
            short s = this.data[i];
            if ((s & 0xFF00) == 0) continue;
            String message = String.format("Overflow at %04X: %04X", i, s);
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message);
        }
    }

    public boolean isUpgradeWithKeymoves(int devBtnIndex, DeviceType devType, SetupCode setupCode, boolean ask) {
        DeviceUpgrade du;
        if (devType != null && setupCode != null && (du = this.findDeviceUpgrade(devType.getNumber(), setupCode.getValue())) != null && du.getKeyMoves().size() > 0) {
            if (ask) {
                String title;
                boolean confirmed;
                String message = "The current device " + devType.getName() + " " + setupCode.getValue() + " contains keymoves.  Do you want to preserve them?";
                boolean bl = confirmed = JOptionPane.showConfirmDialog(null, message, title = "Device Change", 0, 3) == 0;
                if (!confirmed) {
                    du.assignmentColors.remove(devBtnIndex);
                }
                return confirmed;
            }
            return true;
        }
        return false;
    }

    private boolean isSharedVirtualDevice(DeviceButton db) {
        if (this.remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
            return false;
        }
        List<DeviceButton> devBtns = Arrays.asList(this.remote.getDeviceButtons());
        int index = devBtns.indexOf(db);
        return index >= 8 && devBtns.get(index - 8) != null;
    }

    public ShareType shareType(DeviceButton db, DeviceType devType, SetupCode setupCode) {
        if (!this.isSharedVirtualDevice(db)) {
            return ShareType.UNSHARED;
        }
        if (this.isUpgradeWithKeymoves(-1, devType, setupCode, false)) {
            return ShareType.SHARED;
        }
        return ShareType.SHAREABLE;
    }

    public DeviceButton[] getAllowedDeviceButtons() {
        ArrayList<DeviceButton> allowedDB = new ArrayList<DeviceButton>();
        for (DeviceButton db : this.remote.getDeviceButtons()) {
            if (this.isSharedVirtualDevice(db)) continue;
            allowedDB.add(db);
        }
        return allowedDB.toArray(new DeviceButton[0]);
    }

    private int updateMacros(List<Macro> allMacros, int offset) {
        int segSize;
        int index;
        LinkedHashMap[] multiMaps = new LinkedHashMap[2];
        LinkedHashMap activityMap = new LinkedHashMap();
        for (int i = 0; i < multiMaps.length; ++i) {
            multiMaps[i] = new LinkedHashMap();
        }
        for (Macro macro : allMacros) {
            if (!macro.forUpload()) continue;
            if (this.hasSegments()) {
                int type;
                Macro.MacroClass macroClass = macro.getMacroClass();
                int n = macroClass == Macro.MacroClass.NORMAL ? 1 : (macroClass == Macro.MacroClass.MULTI ? 2 : (macroClass == Macro.MacroClass.ACTIVITYPOWER ? 4 : (macroClass == Macro.MacroClass.MASTERPOWER ? 205 : (type = macro.getActivity() != null ? 30 : 3))));
                if (type == 2 || type == 30) {
                    int dbi = macro.getDeviceButtonIndex();
                    if (dbi == -1) {
                        dbi = 0;
                    }
                    int subset = type == 2 ? macro.getKeyCode() | dbi << 8 : this.remote.getButtonByStandardName("Activities").getKeyCode();
                    index = type == 2 ? 0 : 1;
                    List list = (List)multiMaps[index].get(subset |= macro.getSegmentFlags() << 16);
                    if (list == null) {
                        multiMaps[index].put(subset, new ArrayList());
                        if (index == 1) {
                            activityMap.put(subset, new ArrayList());
                        }
                    }
                    ((List)multiMaps[index].get(subset)).add(macro);
                    if (index != 1) continue;
                    ((List)activityMap.get(subset)).add(macro.getActivity());
                    continue;
                }
                if (type == 4 && macro.dataLength() != 2 * this.remote.getDeviceButtons().length) {
                    this.remote.correctType04Macro(macro);
                }
                int size = macro.dataLength() + type - (type == 4 ? 2 : (type == 205 ? 205 : 1));
                if (type == 3) {
                    size += macro.dataLength();
                    size += this.remote.usesEZRC() ? macro.getName().length() + 1 : -2;
                }
                segSize = size + 3;
                int lenMod = segSize & this.remote.getForceModulus() - 1;
                Hex segData = new Hex(segSize += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                segData.put(65535, segData.length() - 2);
                int flags = macro.getSegmentFlags();
                int index2 = macro.getDeviceButtonIndex();
                if (index2 == -1) {
                    index2 = 0;
                }
                segData.set((short)(index2 + (macro.getSequenceNumber() << this.remote.getSeqShift())), 0);
                int pos = 1;
                segData.set((short)macro.getKeyCode(), pos++);
                if (type == 4) {
                    segData.set((short)0, 0);
                    segData.set((short)index2, 1);
                    segData.set((short)1, pos++);
                    segData.set((short)macro.getKeyCode(), pos++);
                }
                macro.store(segData.getData(), pos, this.remote);
                List<Segment> list = this.segments.get(type);
                if (list == null) {
                    list = new ArrayList<Segment>();
                    this.segments.put(type, list);
                }
                list.add(new Segment(type, flags, segData, macro));
                continue;
            }
            this.updateHighlight(macro, offset, macro.getSize(this.remote));
            offset = macro.store(this.data, offset, this.remote);
        }
        for (int i = 0; i < multiMaps.length; ++i) {
            if (multiMaps[i].isEmpty()) continue;
            Iterator iterator = multiMaps[i].keySet().iterator();
            while (iterator.hasNext()) {
                int segType;
                List<Segment> segList;
                int subset = (Integer)iterator.next();
                List<Macro> list = new ArrayList();
                List actList = (List)activityMap.get(subset);
                if (i == 1) {
                    Collections.sort(actList, Activity.activitySort);
                    for (Activity act : actList) {
                        list.add(act.getMacro());
                    }
                } else {
                    list = (List)multiMaps[0].get(subset);
                }
                segSize = i + 3;
                index = 0;
                for (Macro m : list) {
                    segSize += (1 + m.dataLength()) * (i + 1);
                    if (i != 1) continue;
                    segSize += m.getActivity().getName().length() + 1;
                }
                int lenMod = segSize & this.remote.getForceModulus() - 1;
                Hex segData = new Hex(segSize += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                segData.put(65535, segData.length() - 2);
                segData.set((short)(subset >> 8 & 0xFF), 0);
                int pos = 1;
                segData.set((short)(subset & 0xFF), pos++);
                segData.set((short)list.size(), pos++);
                if (i == 1) {
                    for (Macro m : list) {
                        segData.set((short)m.getKeyCode(), pos++);
                    }
                }
                for (Macro m : list) {
                    pos = m.store(segData.getData(), pos, this.remote);
                }
                if (i == 1) {
                    segData.set((short)0, pos++);
                    for (Activity act : actList) {
                        String name = act.getName();
                        segData.set((short)name.length(), pos++);
                        segData.put(new Hex(name, 8), pos);
                        pos += name.length();
                    }
                }
                if ((segList = this.segments.get(segType = i == 0 ? 2 : 30)) == null) {
                    segList = new ArrayList<Segment>();
                    this.segments.put(segType, segList);
                }
                int flags = subset >> 16;
                Segment seg = new Segment(segType, flags, segData);
                segList.add(seg);
                for (Macro m : list) {
                    m.setSegment(seg, i == 0 ? index++ : 0);
                }
                if (segType != 30) continue;
                for (Activity act : actList) {
                    act.setSegment(seg);
                }
            }
        }
        return offset;
    }

    private int updateKeyMoves(List<? extends KeyMove> moves, int offset) {
        for (KeyMove keyMove : moves) {
            keyMove.clearMemoryUsage();
            if (!this.hasSegments()) {
                this.updateHighlight(keyMove, offset, keyMove.getSize(this.remote));
                offset = keyMove.store(this.data, offset, this.remote);
                continue;
            }
            if (!keyMove.forUpload()) continue;
            int type = keyMove instanceof KeyMoveKey ? 7 : 8;
            int flags = keyMove.getSegmentFlags();
            int segSize = type == 7 ? 6 : 8;
            int lenMod = segSize & this.remote.getForceModulus() - 1;
            Hex segData = new Hex(segSize += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
            segData.put(65535, segData.length() - 2);
            if (!this.remote.getSegmentTypes().contains(type)) continue;
            if (this.segments.get(type) == null) {
                this.segments.put(type, new ArrayList());
            }
            keyMove.store(segData.getData(), offset, this.remote);
            this.segments.get(type).add(new Segment(type, flags, segData, keyMove));
        }
        return offset;
    }

    private void updateFavorites() {
        int count = this.favScans.size();
        if (!this.remote.hasFavorites() || count == 0) {
            return;
        }
        this.segments.remove(29);
        int dataLen = 8;
        int k = 7;
        int flags = 0;
        DeviceButton favDevice = this.favScans.get(0).getDeviceButton();
        for (FavScan fav : this.favScans) {
            int size = fav.getChannel().length();
            k += size + 1;
            dataLen += size + fav.getName().length() + 2;
            flags = fav.getSegmentFlags();
        }
        Button favFinalKey = favDevice.getFavFinalKey();
        if (favFinalKey != null && favFinalKey != Button.noButton) {
            k += count;
            dataLen += count;
        }
        int lenMod = dataLen & this.remote.getForceModulus() - 1;
        Hex segData = new Hex(dataLen += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
        segData.set((short)255, dataLen - 1);
        if (this.segments.get(29) == null) {
            this.segments.put(29, new ArrayList());
        }
        Segment segment = new Segment(29, flags, segData);
        segData.set((short)favDevice.getButtonIndex(), 0);
        segData.set((short)this.remote.getFavKey().getKeyCode(), 1);
        segData.set((short)favDevice.getFavoriteWidth(), 2);
        segData.set((short)this.remote.getFavKey().getFavPause(), 3);
        segData.set(favFinalKey == Button.noButton ? (short)255 : (short)favFinalKey.getKeyCode(), 4);
        segData.set((short)255, 5);
        segData.set((short)count, 6);
        segData.set((short)0, k++);
        int i = 7;
        for (FavScan fav : this.favScans) {
            String channel = fav.getChannel();
            int len = channel.length();
            for (int j = 0; j < len; ++j) {
                Button b;
                String bName = channel.substring(j, j + 1);
                if (bName.equals(".")) {
                    bName = "+100";
                }
                short keyCode = (b = this.remote.getButtonByStandardName(bName)) != null ? b.getKeyCode() : (short)0;
                segData.set(keyCode, i + j + 1);
            }
            if (favFinalKey != null && favFinalKey != Button.noButton) {
                segData.set(favFinalKey.getKeyCode(), i + ++len);
            }
            segData.set((short)len, i);
            i += len + 1;
            String name = fav.getName();
            segData.set((short)name.length(), k++);
            for (int n = 0; n < name.length(); ++n) {
                segData.set((short)name.charAt(n), k++);
            }
            fav.setSegment(segment);
        }
        this.segments.get(29).add(segment);
        this.updateActivityData(this.remote.getFavKey().getActivity());
    }

    private void updateActivities() {
        if (this.activities == null) {
            return;
        }
        List<Integer> types = this.remote.getSegmentTypes();
        if (types.contains(219)) {
            this.segments.remove(219);
            this.segments.remove(220);
            for (Activity activity : this.activities.values()) {
                Setting sv;
                Button btn = activity.getButton();
                ActivityGroup[] groups = activity.getActivityGroups();
                int dataLen = this.remote.hasActivityControl() ? 4 : groups.length + 2;
                int lenMod = dataLen & this.remote.getForceModulus() - 1;
                if (this.remote.doForceEvenStarts() && lenMod > 0) {
                    dataLen += this.remote.getForceModulus() - lenMod;
                }
                Hex segData = new Hex(dataLen);
                segData.set((short)0, 0);
                segData.set(btn.getKeyCode(), 1);
                int pos = 2;
                if (this.remote.hasActivityControl()) {
                    if (activity.getSelector() == null) {
                        segData.put(65280, pos);
                    } else {
                        segData.set(activity.getSelector().getKeyCode(), pos++);
                        short val = 0;
                        for (ActivityGroup group : groups) {
                            int index = Arrays.asList(this.remote.getDeviceButtons()).indexOf(group.getDevice());
                            if (index < 0) continue;
                            val = (short)(val | 1 << index);
                        }
                        segData.set(val, pos++);
                    }
                } else {
                    for (ActivityGroup group : groups) {
                        segData.set((short)group.getDeviceIndex(), pos++);
                    }
                }
                int flags = activity.getSegmentFlags();
                if (this.segments.get(219) == null) {
                    this.segments.put(219, new ArrayList());
                }
                this.segments.get(219).add(new Segment(219, flags, segData, activity));
                segData = new Hex(4);
                segData.set((short)0, 0);
                segData.set(activity.getButton().getKeyCode(), 1);
                Setting sa = this.remote.getSetting("AudioHelp");
                if (sa != null) {
                    sa.setValue(activity.getAudioHelp());
                    sa.store(segData.getData(), this.remote);
                }
                if ((sv = this.remote.getSetting("VideoHelp")) != null) {
                    sv.setValue(activity.getVideoHelp());
                    sv.store(segData.getData(), this.remote);
                }
                flags = activity.getHelpSegmentFlags();
                if (sa == null && sv == null) continue;
                if (this.segments.get(220) == null) {
                    this.segments.put(220, new ArrayList());
                }
                Segment segment = new Segment(220, flags, segData);
                activity.setHelpSegment(segment);
                this.segments.get(220).add(segment);
            }
        } else if (types.contains(233)) {
            this.segments.remove(233);
            List<Button> activityBtns = this.remote.getButtonGroups().get("Activity");
            int dataLen = 4 + activityBtns.size();
            int lenMod = dataLen & this.remote.getForceModulus() - 1;
            Hex segData = new Hex(dataLen += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
            if (this.segments.get(233) == null) {
                this.segments.put(233, new ArrayList());
            }
            segData.set((short)0, 0);
            segData.set((short)0, 1);
            segData.set((short)0, 2);
            segData.set((short)((1 << activityBtns.size()) - 1), 3);
            Segment segment = new Segment(233, 0, segData);
            for (int i = 0; i < activityBtns.size(); ++i) {
                Activity activity = this.activities.get(activityBtns.get(i));
                activity.setSegment(segment);
                segment.setFlags(activity.getSegmentFlags());
                Button selector = activity.getSelector();
                int val = selector == null ? 15 : Integer.valueOf(selector.getName()) - 1;
                segData.set((short)val, 4 + i);
            }
            this.segments.get(233).add(segment);
        } else if (types.contains(205) && this.noSetup == null) {
            List<Button> activityBtns = this.remote.getButtonGroups().get("Activity");
            if (!this.remote.hasActivityControl() && this.noSetup == null) {
                Activity activity = this.activities.get(activityBtns.get(0));
                if (activity.getMacro() != null) {
                    activity.setSegment(activity.getMacro().getSegment());
                }
            } else {
                for (int i = 0; i < activityBtns.size(); ++i) {
                    this.segments.remove(205 + i);
                    if (RMIRSetup.disableActivitiesItem.isSelected()) continue;
                    Activity activity = this.activities.get(activityBtns.get(i));
                    activity.setActive(false);
                    Button selector = activity.getSelector();
                    int val = 0;
                    if (selector == null) {
                        val = this.getDefaultActivitySetting(i);
                        if ((val & 0x80) == 0) {
                            activity.setSelector(this.remote.getButton("" + val));
                        }
                    } else {
                        val = Integer.valueOf(selector.getName());
                    }
                    if (val == 0) continue;
                    if (this.segments.get(205 + i) == null) {
                        this.segments.put(205 + i, new ArrayList());
                    }
                    activity.setActive(true);
                    Hex segData = new Hex(new short[]{0, 0, (short)val, 1});
                    Segment segment = new Segment(205 + i, 255, segData);
                    this.segments.get(205 + i).add(segment);
                    activity.setSegment(segment);
                }
            }
        } else if (this.noSetup != null && (types.contains(205) || types.contains(27))) {
            List<Button> activityBtns = this.remote.getButtonGroups().get("Activity");
            Segment activitySetup = (types.contains(27) ? this.segments.get(27) : this.segments.get(205)).get(0);
            Activity activity = this.activities.get(activityBtns.get(0));
            this.activitySetupAddresses = new Hex(12);
            for (ActivityGroup group : activity.getActivityGroups()) {
                int index = group.getIndex();
                int val = group.getDeviceIndex();
                int addr = 0;
                Hex code = null;
                if (index == 0) {
                    int offset = this.noSetup.getMode0Codes().indexOf(val);
                    addr = this.noSetup.getSetupInfo()[2] + 2 * offset;
                    if (this.noSetup.getSetupInfo()[12] == 1) {
                        code = this.noSetup.getHex().subHex(addr, 2);
                    } else {
                        short[] data = new short[]{(short)(addr >> 8), (short)(addr & 0xFF)};
                        code = new Hex(data);
                    }
                    this.activitySetupAddresses.put(code, 0);
                }
                addr = this.noSetup.getSetupInfo()[4] + 2 * (val - 1);
                if (this.noSetup.getSetupInfo()[12] == 1) {
                    code = this.noSetup.getHex().subHex(addr, 2);
                } else {
                    short[] data = new short[]{(short)(addr >> 8), (short)(addr & 0xFF)};
                    code = new Hex(data);
                }
                this.activitySetupAddresses.put(code, 2 * index + 2);
            }
            activitySetup.getHex().put(this.activitySetupAddresses, types.contains(27) ? 3 : 12);
        } else if (types.contains(11)) {
            this.segments.remove(11);
            this.segments.remove(31);
            ArrayList<Activity> activeActivities = new ArrayList<Activity>();
            for (Activity activity : this.activities.values()) {
                if (!activity.isActive()) continue;
                activeActivities.add(activity);
            }
            if (activeActivities.isEmpty()) {
                return;
            }
            Collections.sort(activeActivities, Activity.activitySort);
            for (Activity activity : activeActivities) {
                this.updateActivityData(activity);
            }
        } else if (types.contains(47)) {
            short flags = this.segments.get(47).get(0).getHex().getData()[2];
            Activity activity = this.activities.get(null);
            ActivityGroup[] groups = activity.getActivityGroups();
            groups[0].setDevice(this.remote.getDeviceButtons()[2]);
            groups[1].setDevice(this.remote.getDeviceButtons()[0]);
            DeviceButton audio = this.remote.getDeviceButtons()[1];
            short[] audioData = audio.getSegment().getHex().getData();
            short audioSetupCode = audio.getSetupCode(audioData);
            groups[2].setDevice(this.remote.getDeviceButtons()[audioSetupCode < 0 ? 0 : 1]);
            groups[3].setDevice(this.remote.getDeviceButtons()[(flags & 8) > 0 ? 0 : 2]);
            groups[4].setDevice(this.remote.getDeviceButtons()[(flags & 8) > 0 ? 0 : 2]);
            groups[3].setOverride((flags & 1) > 0 ? this.remote.getDeviceButtons()[0] : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateActivityData(Activity activity) {
        ActivityGroup[] groups;
        int count = 0;
        for (ActivityGroup activityGroup : groups = activity.getActivityGroups()) {
            count += activityGroup.getButtonGroup().length;
        }
        int dataLen = 2 * count + 4;
        Hex segData = new Hex(dataLen);
        segData.set((short)255, dataLen - 1);
        if (this.remote.getSegmentTypes().contains(11)) {
            if (this.segments.get(11) == null) {
                this.segments.put(11, new ArrayList());
            }
            LinkedHashMap<Button, KeySpec> map = new LinkedHashMap<Button, KeySpec>();
            for (ActivityGroup group : groups) {
                DeviceButton db = group.getDevice();
                for (Button b : group.getButtonGroup()) {
                    map.put(b, new KeySpec(db, b));
                }
            }
            Segment segment = new Segment(11, groups[0].getSegmentFlags(), segData);
            int pos = 0;
            segData.set(activity.getButton().getKeyCode(), pos++);
            segData.set((short)0, pos++);
            segData.set((short)count, pos++);
            for (ActivityGroup group : groups) {
                group.setSegment(segment);
            }
            Iterator<Short> iterator = this.remote.getActivityOrder().iterator();
            while (iterator.hasNext()) {
                KeySpec ks;
                int code = ((Short)iterator.next()).shortValue();
                Button b = this.remote.getButton(code);
                if (b == null || (ks = (KeySpec)map.get(b)) == null || ks.db == null || ks.db == DeviceButton.noButton) continue;
                segData.set((short)ks.db.getButtonIndex(), pos + count);
                segData.set(b.getKeyCode(), pos++);
            }
            this.segments.get(11).add(segment);
        }
        if (activity.getSelector() == null) {
            return;
        }
        if (this.remote.getSegmentTypes().contains(10)) {
            if (this.segments.get(10) == null) {
                this.segments.put(10, new ArrayList());
            }
            LinkedHashMap<Button, String> map2 = new LinkedHashMap<Button, String>();
            Segment segment = new Segment(10, groups[0].getSegmentFlags(), null);
            this.segments.get(10).add(segment);
            for (ActivityGroup group : groups) {
                DeviceUpgrade du;
                DeviceButton db = group.getDevice();
                if (db == null || (du = db.getUpgrade()) == null || du.getSoftButtons() == null || du.getSoftButtons().isEmpty() || !this.remote.isSoftButton(group.getButtonGroup()[0])) continue;
                for (Button btn : group.getButtonGroup()) {
                    GeneralFunction gf = null;
                    if (!du.getSoftButtons().contains(btn) || (gf = du.getGeneralFunction(btn.getKeyCode(), false)) == null) continue;
                    map2.put(btn, gf.getName());
                }
                group.setSoftNamesSegment(segment);
            }
            segData = this.createNameHex(map2);
            segData.set(activity.getButton().getKeyCode(), 0);
            segment.setHex(segData);
        }
        if (this.remote.getSegmentTypes().contains(31)) {
            void var7_19;
            if (this.segments.get(31) == null) {
                this.segments.put(31, new ArrayList());
            }
            dataLen = 5;
            int[] sizes = new int[]{0, 0, 0};
            boolean bl = false;
            while (var7_19 < 3) {
                List<Activity.Assister> a = activity.getAssists().get((int)var7_19);
                for (Activity.Assister assist : a) {
                    if (!assist.ks.isValid()) continue;
                    void v0 = var7_19;
                    sizes[v0] = sizes[v0] + 1;
                    dataLen += assist.getDeviceName().length() + 3;
                }
                dataLen += sizes[var7_19] > 0 ? 1 : 0;
                ++var7_19;
            }
            int n = dataLen & this.remote.getForceModulus() - 1;
            segData = new Hex(dataLen += this.remote.doForceEvenStarts() && n > 0 ? this.remote.getForceModulus() - n : 0);
            segData.set((short)255, dataLen - 1);
            Segment segment2 = new Segment(31, activity.getHelpSegmentFlags(), segData);
            int pos = 0;
            segData.set(activity.getSelector().getKeyCode(), pos++);
            segData.set((short)0, pos++);
            for (int i = 0; i < 3; ++i) {
                List<Activity.Assister> a = activity.getAssists().get(i);
                int aLen = sizes[i];
                segData.set((short)aLen, pos++);
                if (aLen <= 0) continue;
                segData.set((short)0, pos + 2 * aLen);
                int namePos = pos + 2 * aLen + 1;
                int n2 = 0;
                for (int j = 0; j < a.size(); ++j) {
                    if (!a.get((int)j).ks.isValid()) continue;
                    if (a.get((int)j).ks.getButton() != null) {
                        segData.set(a.get((int)j).ks.getButton().getKeyCode(), pos + n2);
                        segData.set((short)a.get((int)j).ks.db.getButtonIndex(), pos + n2 + aLen);
                    } else {
                        segData.set((short)(a.get((int)j).ks.fn.getSerial() & 0xFF), pos + n2);
                        segData.set((short)a.get((int)j).ks.db.getButtonIndex(), pos + n2 + aLen);
                    }
                    int nameLen = a.get((int)j).ks.db.getName().length();
                    segData.set((short)nameLen, namePos++);
                    for (int k = 0; k < nameLen; ++k) {
                        segData.set((short)a.get((int)j).ks.db.getName().charAt(k), namePos++);
                    }
                }
                pos = namePos;
                ++n2;
            }
            activity.setHelpSegment(segment2);
            this.segments.get(31).add(segment2);
        }
    }

    public int getDefaultActivitySetting(int index) {
        if (this.remote.getSoftDevices() == null || !this.remote.getSoftDevices().inUse()) {
            return 1;
        }
        int states = 0;
        int val = 1;
        for (DeviceButton devBtn : this.remote.getDeviceButtons()) {
            short[] data = devBtn.getSegment().getHex().getData();
            if (devBtn.getSetupCode(data) >= 0) {
                states |= val;
            }
            val <<= 1;
        }
        val = 0;
        Integer[] mapList = this.remote.getActivityControl()[index].maps;
        int bestCount = 0;
        int bestIndex = -1;
        for (int i = 0; i < mapList.length; ++i) {
            int count;
            if ((mapList[i] & states) != mapList[i] || (count = this.countSetBits(mapList[i])) <= bestCount) continue;
            bestCount = count;
            bestIndex = i;
        }
        if (bestIndex >= 0) {
            return 129 + bestIndex;
        }
        return 0;
    }

    public int countSetBits(int n) {
        int count = 0;
        while (n != 0) {
            n &= n - 1;
            ++count;
        }
        return count;
    }

    public List<KeyMove> getUpgradeKeyMoves() {
        return this.upgradeKeyMoves;
    }

    public void setUpgradeKeyMoves() {
        ArrayList<KeyMove> newUpgradeKeyMoves = new ArrayList<KeyMove>();
        for (DeviceUpgrade device : this.devices) {
            for (Integer dbIndex : this.getDeviceButtonIndexList(device)) {
                for (KeyMove keyMove : device.getKeyMoves(dbIndex)) {
                    boolean done = false;
                    for (KeyMove km : this.upgradeKeyMoves) {
                        if (km.deviceButtonIndex != dbIndex || km.keyCode != keyMove.keyCode) continue;
                        newUpgradeKeyMoves.add(km);
                        done = true;
                        break;
                    }
                    if (done) continue;
                    keyMove.setDeviceButtonIndex(dbIndex);
                    newUpgradeKeyMoves.add(keyMove);
                }
            }
        }
        this.upgradeKeyMoves = newUpgradeKeyMoves;
    }

    private void updateFavScans() {
        if (this.hasSegments() || !this.remote.hasFavKey() || !this.remote.getFavKey().isSegregated()) {
            return;
        }
        AddressRange range = this.remote.getFavScanAddress();
        int offset = range.getStart();
        if (this.favScans.size() == 0) {
            this.data[offset] = 0;
            return;
        }
        FavScan favScan = this.favScans.get(0);
        int buttonIndex = this.favKeyDevButton == DeviceButton.noButton ? 255 : this.favKeyDevButton.getButtonIndex();
        this.data[this.remote.getFavKey().getDeviceButtonAddress()] = (short)buttonIndex;
        favScan.clearMemoryUsage();
        this.updateHighlight(favScan, offset, favScan.getSize(this.remote));
        favScan.store(this.data, offset, this.remote);
    }

    private void updateTimedMacros() {
        AddressRange range = this.remote.getTimedMacroAddress();
        if (range == null) {
            return;
        }
        int offset = range.getStart();
        for (TimedMacro timedMacro : this.timedMacros) {
            timedMacro.clearMemoryUsage();
            this.updateHighlight(timedMacro, offset, timedMacro.getSize(this.remote));
            offset = timedMacro.store(this.data, offset, this.remote);
        }
        this.data[offset++] = this.remote.getSectionTerminator();
        range.setFreeStart(offset);
    }

    public void updateAdvancedCodes() {
        AddressRange range = this.remote.getAdvancedCodeAddress();
        if (this.remote.isSSD() || !this.hasSegments() && range == null) {
            return;
        }
        int offset = range != null ? range.getStart() : 0;
        ArrayList<Highlight> allHighlights = new ArrayList<Highlight>();
        ArrayList<Macro> macros = new ArrayList<Macro>();
        LinkedHashMap<Button, ArrayList<Macro>> multiMacros = new LinkedHashMap<Button, ArrayList<Macro>>();
        if (this.hasSegments()) {
            List<Integer> types = this.remote.getSegmentTypes();
            if (types.contains(1)) {
                this.segments.remove(1);
            }
            if (types.contains(2)) {
                this.segments.remove(2);
            }
            if (types.contains(3)) {
                this.segments.remove(3);
            }
            if (types.contains(4)) {
                this.segments.remove(4);
            }
            if (types.contains(7)) {
                this.segments.remove(7);
            }
            if (types.contains(8)) {
                this.segments.remove(8);
            }
            if (types.contains(9)) {
                this.segments.remove(9);
            }
            if (types.contains(30)) {
                this.segments.remove(30);
            }
            if (types.contains(205) && !this.remote.hasActivityControl() && this.noSetup == null) {
                this.segments.remove(205);
            }
            macros = this.getAllMacros(false);
        } else {
            for (Macro macro : this.getAllMacros(false)) {
                int keyCode = macro.getKeyCode();
                Button button = this.remote.getButton(keyCode);
                if (this.remote.hasMultiMacroSupport() && button != null && button.getMultiMacro() != null) {
                    ArrayList<Macro> list = (ArrayList<Macro>)multiMacros.get(button);
                    if (list == null) {
                        list = new ArrayList<Macro>();
                        multiMacros.put(button, list);
                    }
                    list.add(macro);
                    macro.setSequenceNumber(list.size());
                }
                macros.add(macro);
            }
        }
        this.updateSpecialFunctionSublists();
        macros.addAll(this.specialFunctionMacros);
        this.setUpgradeKeyMoves();
        allHighlights.addAll(this.keymoves);
        allHighlights.addAll(this.upgradeKeyMoves);
        allHighlights.addAll(this.specialFunctionKeyMoves);
        allHighlights.addAll(macros);
        allHighlights.addAll(this.learned);
        this.setHighlightUploadStatusValues(allHighlights);
        offset = this.updateKeyMoves(this.keymoves, offset);
        offset = this.updateKeyMoves(this.upgradeKeyMoves, offset);
        offset = this.updateKeyMoves(this.specialFunctionKeyMoves, offset);
        offset = this.updateMacros(macros, offset);
        if (range == null) {
            return;
        }
        for (Button btn : multiMacros.keySet()) {
            List list = (List)multiMacros.get(btn);
            MultiMacro multiMacro = btn.getMultiMacro();
            multiMacro.setCount(list.size());
            multiMacro.store(this.data, this.remote);
        }
        if (this.remote.hasFavKey() && !this.remote.getFavKey().isSegregated()) {
            for (FavScan favScan : this.favScans) {
                if (this.remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
                    int buttonIndex = this.favKeyDevButton == DeviceButton.noButton ? 255 : this.favKeyDevButton.getButtonIndex();
                    this.data[this.remote.getFavKey().getDeviceButtonAddress()] = (short)buttonIndex;
                }
                favScan.clearMemoryUsage();
                this.updateHighlight(favScan, offset, favScan.getSize(this.remote));
                offset = favScan.store(this.data, offset, this.remote);
            }
        }
        if (this.remote.getMacroCodingType().hasTimedMacros()) {
            for (TimedMacro timedMacro : this.timedMacros) {
                timedMacro.clearMemoryUsage();
                this.updateHighlight(timedMacro, offset, timedMacro.getSize(this.remote));
                offset = timedMacro.store(this.data, offset, this.remote);
            }
            int timedMacroCountAddress = this.remote.getMacroCodingType().getTimedMacroCountAddress();
            if (timedMacroCountAddress > 0) {
                this.data[timedMacroCountAddress] = (short)this.timedMacros.size();
            }
        }
        this.data[offset++] = this.remote.getSectionTerminator();
        range.setFreeStart(offset);
    }

    public List<Macro> getAllMacros(boolean forSaving) {
        ArrayList<Macro> allMacros = new ArrayList<Macro>();
        if (this.remote.isSSD()) {
            allMacros.addAll(this.macros);
        }
        if (this.hasSegments() && this.activities != null) {
            for (Activity activity : this.activities.values()) {
                Macro macro;
                if (!activity.isActive() || (macro = activity.getMacro()) == null || macro.getValueString(this).isEmpty() || allMacros.contains(macro)) continue;
                allMacros.add(macro);
            }
        }
        if (!this.remote.isSSD()) {
            for (Macro macro : this.macros) {
                if (macro == null || allMacros.contains(macro)) continue;
                allMacros.add(macro);
            }
        }
        return allMacros;
    }

    private int getHighlightType(Highlight hl, List<DeviceUpgrade> specialUpgrades) {
        int hlType = 0;
        if (hl instanceof KeyMove) {
            hlType = this.getSpecialProtocol((KeyMove)hl, specialUpgrades) != null ? 3 : 1;
        } else if (hl instanceof Macro) {
            Macro m = (Macro)hl;
            hlType = this.getSpecialProtocol((Macro)hl) != null ? 3 : (m.getMacroClass() == Macro.MacroClass.ACTIVITYPOWER ? 5 : 2);
        } else if (hl instanceof LearnedSignal) {
            hlType = 4;
        }
        return hlType;
    }

    private void setHighlightUploadStatusValues(List<Highlight> allHighlights) {
        long subset;
        LinkedHashMap<Long, ArrayList<Highlight>> bySubset = new LinkedHashMap<Long, ArrayList<Highlight>>();
        LinkedHashMap byUntypedSubset = new LinkedHashMap();
        List<DeviceUpgrade> specialUpgrades = this.getSpecialUpgrades();
        for (Highlight highlight : allHighlights) {
            highlight.setSegment(null);
            highlight.clearMemoryUsage();
            highlight.setUploadStatus(Highlight.UploadStatus.NO);
            int hlType = this.getHighlightType(highlight, specialUpgrades);
            if (highlight.keyCode == Button.noButton.getKeyCode() && hlType != 5) continue;
            subset = (long)hlType << 32 | (long)highlight.getSegmentFlags() << 24 | (long)((highlight.getDeviceButtonIndex() & 0xFFFF) << 8) | (long)highlight.getKeyCode();
            ArrayList<Highlight> subList = (ArrayList<Highlight>)bySubset.get(subset);
            if (subList == null) {
                subList = new ArrayList<Highlight>();
                bySubset.put(subset, subList);
            }
            subList.add(highlight);
        }
        ArrayList<Long> devIndList = new ArrayList<Long>();
        Iterator iterator = bySubset.keySet().iterator();
        while (iterator.hasNext()) {
            long devIndSubset;
            int nullIndex;
            int devIndex;
            Highlight h;
            ListIterator it;
            long subset2 = (Long)iterator.next();
            long untypedSubset = subset2 & 0xFFFFFFFFL;
            ArrayList<Highlight> untypedList = (ArrayList<Highlight>)byUntypedSubset.get(untypedSubset);
            if (untypedList == null) {
                untypedList = new ArrayList<Highlight>();
                byUntypedSubset.put(untypedSubset, untypedList);
            }
            List list = (List)bySubset.get(subset2);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Macro m;
                Highlight hl3 = (Highlight)iterator2.next();
                if (!(hl3 instanceof Macro) || (m = (Macro)hl3).getMacroClass() != Macro.MacroClass.UNDETERMINED) continue;
                m.setMacroClass(list.size() > 1 ? Macro.MacroClass.MULTI : Macro.MacroClass.NORMAL);
            }
            Highlight hl4 = (Highlight)list.get(0);
            untypedList.add(hl4);
            if (!this.remote.usesEZRC()) {
                if (!(hl4 instanceof Macro) || ((Macro)hl4).getMacroClass() != Macro.MacroClass.MULTI) {
                    list.clear();
                    list.add(hl4);
                } else {
                    it = list.listIterator();
                    while (it.hasNext()) {
                        h = (Highlight)it.next();
                        if (((Macro)h).getMacroClass() == Macro.MacroClass.MULTI) continue;
                        it.remove();
                    }
                }
            } else {
                it = list.listIterator();
                while (it.hasNext()) {
                    h = (Highlight)it.next();
                    if (h.getUsers().size() != 0) continue;
                    it.remove();
                }
            }
            if ((devIndex = (int)(untypedSubset >> 8 & 0xFFFFL)) == (nullIndex = 65535) || devIndList.contains(devIndSubset = untypedSubset & 0xFFFF0000FFL | (long)(nullIndex << 8))) continue;
            devIndList.add(devIndSubset);
        }
        ArrayList arrayList = new ArrayList();
        Iterator<Object> iterator3 = devIndList.iterator();
        while (iterator3.hasNext()) {
            subset = (Long)iterator3.next();
            if (byUntypedSubset.get(subset) == null) continue;
            arrayList.addAll((Collection)byUntypedSubset.get(subset));
        }
        iterator3 = byUntypedSubset.keySet().iterator();
        while (iterator3.hasNext()) {
            long untypedSubset = (Long)iterator3.next();
            List unTypedList = (List)byUntypedSubset.get(untypedSubset);
            LinkedHashMap<Highlight, List> listMap = new LinkedHashMap<Highlight, List>();
            for (Highlight hl : unTypedList) {
                int hlType = this.getHighlightType(hl, specialUpgrades);
                List list = (List)bySubset.get(untypedSubset | (long)hlType << 32);
                listMap.put(hl, list);
            }
            Highlight.UploadStatus status = unTypedList.size() == 1 ? (arrayList.contains(unTypedList.get(0)) ? Highlight.UploadStatus.INFO : Highlight.UploadStatus.YES) : Highlight.UploadStatus.WARN;
            for (Highlight hl5 : unTypedList) {
                if (RMIRSetup.disableUploadRestrictionsItem.isSelected()) {
                    hl5.setUploadStatus(Highlight.UploadStatus.YES);
                    continue;
                }
                Macro m = null;
                Macro.MacroClass macroClass = null;
                if (hl5 instanceof Macro) {
                    m = (Macro)hl5;
                } else if (hl5 instanceof DSMFunction) {
                    m = ((DSMFunction)hl5).getMacro();
                }
                if (m != null) {
                    macroClass = m.getMacroClass();
                }
                if (macroClass != null && macroClass != Macro.MacroClass.ACTIVITYPOWER) {
                    Button bb;
                    List<Button> macroButtons = Arrays.asList(this.remote.getMacroButtons(macroClass, false));
                    int keyCode = hl5.getKeyCode();
                    Button b = this.remote.getBaseButton(keyCode);
                    if (b != null && !macroButtons.contains(b) && ((bb = b.getBaseButton()) != null && this.remote.getShiftEnabled() && keyCode == bb.getShiftedKeyCode() && bb.allowsMacro(1) || bb != null && this.remote.getXShiftEnabled() && keyCode == bb.getXShiftedKeyCode() && bb.allowsMacro(2))) {
                        b = bb;
                    }
                    if (b == null || !macroButtons.contains(b) && m.getActivity() == null) {
                        hl5.setUploadStatus(Highlight.UploadStatus.TEST);
                        continue;
                    }
                }
                for (Highlight h : (List)listMap.get(hl5)) {
                    h.setUploadStatus(status);
                }
            }
        }
    }

    private void updateHighlight(Highlight item, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.highlight[offset + i] = item.getHighlight();
        }
        item.addMemoryUsage(length);
    }

    public void updateCheckSums() {
        CheckSum[] sums = this.remote.getCheckSums();
        for (int i = 0; i < sums.length; ++i) {
            sums[i].setCheckSum(this.data);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDeviceButtons() {
        void var4_11;
        ArrayList<DeviceButton> deviceButtons = new ArrayList<DeviceButton>();
        DeviceButton[] deviceButtonArray = this.remote.getDeviceButtons();
        int n = deviceButtonArray.length;
        boolean bl = false;
        while (var4_11 < n) {
            DeviceButton deviceButton = deviceButtonArray[var4_11];
            deviceButtons.add(deviceButton);
            ++var4_11;
        }
        for (DeviceButton deviceButton : deviceButtons) {
            if (this.isReplacement) {
                short s = this.internalSegment.getHex().getData()[2];
                deviceButton.getSegment().getHex().getData()[5] = (short)(s ^ 1);
            }
            deviceButton.store(this.remote);
            deviceButton.doHighlight(this.highlight);
        }
        if (!this.hasSegments() || this.remote.isSSD()) {
            return;
        }
        if (this.segments.get(0) != null) {
            this.segments.get(0).clear();
        }
        boolean allowEmpty = this.remote.getSoftDevices() != null && this.remote.getSoftDevices().getAllowEmptyButtonSettings();
        for (DeviceButton deviceButton : deviceButtons) {
            if (allowEmpty && (deviceButton.getSegment() == null || deviceButton.getDeviceSlot(deviceButton.getSegment().getHex().getData()) == 65535)) continue;
            if (allowEmpty && this.segments.get(0) == null) {
                this.segments.put(0, new ArrayList());
            }
            if (this.segments.get(0) == null) continue;
            this.segments.get(0).add(deviceButton.getSegment());
        }
        if (this.remote.getSegmentTypes().contains(21) || this.remote.getSegmentTypes().contains(17)) {
            LinkedHashMap<Button, String> linkedHashMap = new LinkedHashMap<Button, String>();
            if (this.deviceButtonList == null) {
                this.deviceButtonList = new ArrayList<DeviceButton>();
            }
            for (DeviceButton deviceButton : this.deviceButtonList) {
                linkedHashMap.put(this.remote.getButton(deviceButton.getButtonIndex()), deviceButton.getName());
            }
            if (this.remote.getSegmentTypes().contains(21)) {
                this.segments.put(21, new ArrayList());
                if (!linkedHashMap.isEmpty()) {
                    Hex hex = this.createNameHex(linkedHashMap);
                    this.segments.get(21).add(new Segment(21, 255, hex));
                }
            }
            if (this.remote.getSegmentTypes().contains(17)) {
                Object var4_17 = null;
                this.segments.put(17, new ArrayList());
                if (this.remote.usesSimpleset()) {
                    for (DeviceButton db : this.remote.getDeviceButtons()) {
                        int size;
                        int dbIndex = db.getButtonIndex();
                        short[] dbData = db.getSegment().getHex().getData();
                        int dbTypeIndex = db.getDeviceTypeIndex(dbData);
                        ArrayList<short[]> duDataList = new ArrayList<short[]>();
                        int count = 0;
                        for (DeviceUpgrade du : this.devices) {
                            DeviceType duType = this.remote.getDeviceTypeByAliasName(du.getDeviceTypeAliasName());
                            int duTypeIndex = duType.getNumber();
                            if (duTypeIndex != dbTypeIndex) continue;
                            int setupCode = du.getSetupCode();
                            duDataList.add(new short[]{(short)duTypeIndex, (short)(setupCode >> 8), (short)(setupCode & 0xFF)});
                            ++count;
                        }
                        if (duDataList.isEmpty()) continue;
                        Hex hex = new Hex(size += ((size = 3 * count + 3) & 1) == 1 ? 1 : 0);
                        hex.put(65535, size - 2);
                        hex.set((short)dbIndex, 0);
                        hex.set((short)dbTypeIndex, 1);
                        hex.set((short)count, 2);
                        int pos = 3;
                        for (short[] duData : duDataList) {
                            hex.put(duData, pos);
                            pos += 3;
                        }
                        this.segments.get(17).add(new Segment(17, 255, hex));
                    }
                } else {
                    int n2;
                    int n3 = n2 + (((n2 = 3 + 3 * this.deviceButtonList.size()) & 1) == 1 ? 1 : 0);
                    Hex hex = new Hex(n3);
                    hex.put(65535, n3 - 2);
                    hex.put(0, 0);
                    hex.set((short)this.deviceButtonList.size(), 2);
                    int i = 3;
                    for (DeviceButton db : this.remote.getDeviceButtons()) {
                        if (!this.deviceButtonList.contains(db)) continue;
                        short[] data = db.getSegment().getHex().getData();
                        hex.set((short)db.getDeviceTypeIndex(data), i);
                        hex.put(db.getSetupCode(data), i + 1);
                        i += 3;
                    }
                    this.segments.get(17).add(new Segment(17, 255, hex));
                }
            }
        }
        if (this.remote.getSegmentTypes().contains(45)) {
            void var5_29;
            this.segments.remove(45);
            DeviceButton[] deviceButtonArray2 = this.remote.getDeviceButtons();
            int n4 = deviceButtonArray2.length;
            boolean bl2 = false;
            while (var5_29 < n4) {
                DeviceButton db = deviceButtonArray2[var5_29];
                int size = 0;
                if (db.getRfSelectors() != null && (size = db.getRfSelectors().length) != 0) {
                    int rawSize = 7 * size + 3;
                    int lenMod = rawSize & this.remote.getForceModulus() - 1;
                    int segSize = rawSize + (this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                    Hex segData = new Hex(segSize);
                    Arrays.fill(segData.getData(), rawSize, segSize, (short)255);
                    segData.getData()[0] = (short)db.getButtonIndex();
                    segData.getData()[1] = 0;
                    segData.getData()[2] = (short)size;
                    for (int i = 0; i < size; ++i) {
                        Remote.RFSelector rfSel = db.getRfSelectors()[i];
                        segData.getData()[3 + i] = rfSel.btn.getKeyCode();
                        segData.getData()[3 + size + 3 * i] = (short)rfSel.irDevType.getNumber();
                        segData.put(rfSel.irCode.getValue(), 4 + size + 3 * i);
                        segData.getData()[3 + 4 * size + 3 * i] = (short)rfSel.rfDevType.getNumber();
                        segData.put(rfSel.rfCode.getValue(), 4 + 4 * size + 3 * i);
                    }
                    if (this.segments.get(45) == null) {
                        this.segments.put(45, new ArrayList());
                    }
                    this.segments.get(45).add(new Segment(45, 255, segData));
                }
                ++var5_29;
            }
        }
    }

    private void updateSettings() {
        Setting[] settings = this.remote.getSettings();
        List<Segment> segs = null;
        for (Setting setting : settings) {
            if (this.remote.isSSD()) {
                if (setting.getTitle().equals("Language")) {
                    String[] langData = languageCodes[setting.getValue()];
                    this.language = langData[0];
                    this.languageFilename = "lang." + langData[1];
                } else if (setting.getTitle().equals("Region")) {
                    String[] rgnData = regionNames[setting.getValue()];
                    this.region = rgnData[0];
                    this.regionFilename = rgnData[1] + ".rgn";
                }
            } else if (this.hasSegments()) {
                int type = (setting.getByteAddress() >> 8) - 1;
                if (type < 0 || (segs = this.segments.get(type)) == null || segs.size() == 0) continue;
                setting.store(segs.get(0).getHex().getData(), this.remote);
            } else {
                setting.store(this.data, this.remote);
            }
            int index = this.remote.getSettingAddresses().get(setting.getByteAddress());
            setting.doHighlight(this.highlight, index, this);
        }
    }

    private void updateFixedData(boolean replace) {
        boolean mismatch = false;
        FixedData[] fixedData = this.remote.getFixedData();
        if (fixedData == null) {
            return;
        }
        for (FixedData fixed : fixedData) {
            if (fixed.getLocation() != FixedData.Location.E2 || fixed.check(this.remote, this.data)) continue;
            mismatch = true;
            break;
        }
        if (mismatch && !replace) {
            String message = "The fixed data in the RDF does not match the values in the remote.\nDo you want to replace the values in the remote with those from the RDF?";
            String title = "Fixed data mismatch";
            boolean bl = replace = JOptionPane.showConfirmDialog(null, message, title, 0, 3) == 0;
        }
        if (!replace) {
            this.remote.setFixedData(null);
        } else {
            for (FixedData fixed : fixedData) {
                if (fixed.getLocation() != FixedData.Location.E2) continue;
                fixed.store(this.remote, this.data);
            }
        }
    }

    private void updateAutoSet() {
        FixedData[] autoSet = this.remote.getAutoSet();
        if (autoSet == null) {
            return;
        }
        for (FixedData auto : autoSet) {
            if (auto.getLocation() != FixedData.Location.E2) continue;
            auto.store(this.remote, this.data);
        }
        int rdfVersionAddress = this.remote.getRdfVersionAddress();
        if (rdfVersionAddress > 0) {
            this.data[rdfVersionAddress] = 5;
        }
    }

    public ProtocolUpgrade getProtocol(int pid) {
        for (ProtocolUpgrade pu : this.protocols) {
            if (pu.getPid() != pid) continue;
            return pu;
        }
        return null;
    }

    private int getLimit(int offset, int[] bounds) {
        int limit = this.remote.getEepromSize();
        for (int i = 0; i < bounds.length; ++i) {
            if (bounds[i] == 0 || offset >= bounds[i] || limit <= bounds[i]) continue;
            limit = bounds[i];
        }
        return limit;
    }

    private int getAddressIndex(int address, AddressRange[] ranges) {
        int ndx = -1;
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i] == null || !ranges[i].contains(address)) continue;
            ndx = i;
            break;
        }
        return ndx;
    }

    private void decodeUpgrades() {
        int setupCode;
        int fullCode;
        int i;
        System.err.println("Decoding upgrades");
        AddressRange upgRange = this.remote.getUpgradeAddress();
        AddressRange lrnRange = this.remote.getLearnedAddress();
        AddressRange advRange = this.remote.getAdvancedCodeAddress();
        AddressRange[] addrRanges = new AddressRange[]{upgRange, lrnRange, advRange};
        AddressRange devAddr = this.remote.getDeviceUpgradeAddress();
        Processor processor = this.remote.getProcessor();
        if (upgRange == null || processor == null) {
            return;
        }
        int deviceTableOffset = processor.getInt(this.data, upgRange.getStart()) - this.remote.getBaseAddress();
        int protocolTableOffset = processor.getInt(this.data, upgRange.getStart() + 2) - this.remote.getBaseAddress();
        int devDependentTableOffset = devAddr == null ? 0 : processor.getInt(this.data, devAddr.getStart()) + devAddr.getStart();
        int[] bounds = new int[]{0, 0, deviceTableOffset, protocolTableOffset, upgRange.getEnd() + 1, advRange != null ? advRange.getEnd() + 1 : 0, lrnRange != null ? lrnRange.getEnd() + 1 : 0, devAddr != null ? devAddr.getEnd() + 1 : 0};
        int offset = protocolTableOffset;
        int count = offset == 0 ? 0 : processor.getInt(this.data, offset);
        offset += 2;
        for (i = 0; i < count; ++i) {
            int j;
            int pid = processor.getInt(this.data, offset);
            int codeOffset = processor.getInt(this.data, offset + 2 * count) - this.remote.getBaseAddress();
            int addrIndex = this.getAddressIndex(codeOffset, addrRanges);
            if (i == 0) {
                bounds[1] = codeOffset;
            } else {
                for (j = 1; j <= i; ++j) {
                    bounds[1] = processor.getInt(this.data, offset + 2 * (count - j)) - this.remote.getBaseAddress();
                    if (this.getAddressIndex(bounds[1], addrRanges) == addrIndex) break;
                    if (j != i) continue;
                    bounds[1] = codeOffset;
                }
            }
            if (i == count - 1) {
                bounds[0] = 0;
            } else {
                for (j = 1; j < count - i; ++j) {
                    bounds[0] = processor.getInt(this.data, offset + 2 * (count + j)) - this.remote.getBaseAddress();
                    if (this.getAddressIndex(bounds[0], addrRanges) == addrIndex) break;
                    if (j != count - i - 1) continue;
                    bounds[0] = 0;
                }
            }
            int limit = this.getLimit(codeOffset, bounds);
            Hex code = Hex.subHex(this.data, codeOffset, limit - codeOffset);
            this.protocols.add(new ProtocolUpgrade(pid, code, null));
            offset += 2;
        }
        offset = deviceTableOffset;
        count = offset == 0 ? 0 : processor.getInt(this.data, offset);
        for (i = 0; i < count; ++i) {
            String alias;
            int j;
            fullCode = processor.getInt(this.data, offset += 2);
            setupCode = fullCode & 0xFFF;
            if (!this.remote.usesTwoBytePID()) {
                setupCode &= 0x7FF;
            }
            setupCode += this.remote.getDeviceCodeOffset();
            DeviceType devType = this.remote.getDeviceTypeByIndex(fullCode >> 12 & 0xF);
            int codeOffset = offset + 2 * count;
            int addrIndex = this.getAddressIndex(codeOffset, addrRanges);
            codeOffset = processor.getInt(this.data, codeOffset) - this.remote.getBaseAddress();
            int pid = this.data[codeOffset];
            if (this.remote.usesTwoBytePID()) {
                pid = processor.getInt(this.data, codeOffset);
            } else if ((fullCode & 0x800) == 2048) {
                pid += 256;
            }
            if (i == 0) {
                bounds[1] = codeOffset;
            } else {
                for (j = 1; j <= i; ++j) {
                    bounds[1] = processor.getInt(this.data, offset + 2 * (count - j)) - this.remote.getBaseAddress();
                    if (this.getAddressIndex(bounds[1], addrRanges) == addrIndex) break;
                    if (j != i) continue;
                    bounds[1] = codeOffset;
                }
            }
            if (i == count - 1) {
                bounds[0] = 0;
            } else {
                for (j = 1; j < count - i; ++j) {
                    bounds[0] = processor.getInt(this.data, offset + 2 * (count + j)) - this.remote.getBaseAddress();
                    if (this.getAddressIndex(bounds[0], addrRanges) == addrIndex) break;
                    if (j != count - i - 1) continue;
                    bounds[0] = 0;
                }
            }
            int limit = this.getLimit(codeOffset, bounds);
            Hex deviceHex = Hex.subHex(this.data, codeOffset, limit - codeOffset);
            this.protocolUpgradeUsed = this.getProtocol(pid);
            Hex protocolCode = null;
            if (this.protocolUpgradeUsed != null) {
                protocolCode = this.protocolUpgradeUsed.getCode();
            }
            if ((alias = this.remote.getDeviceTypeAlias(devType)) == null) {
                String message = String.format("No device type alias found for device upgrade %1$s/%2$04d.  The device upgrade could not be imported and was discarded.", devType, setupCode);
                JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                continue;
            }
            short[] pidHex = new short[]{(short)(pid >> 8), (short)(pid & 0xFF)};
            DeviceUpgrade upgrade = new DeviceUpgrade();
            try {
                upgrade.setRemoteConfig(this);
                System.err.println();
                System.err.println("Setup code=" + alias + "/" + setupCode);
                upgrade.importRawUpgrade(deviceHex, this.remote, alias, new Hex(pidHex), protocolCode);
                upgrade.setSetupCode(setupCode);
                if (this.protocolUpgradeUsed != null) {
                    this.protocolUpgradeUsed.setUsed(true);
                }
            }
            catch (ParseException pe) {
                pe.printStackTrace(System.err);
                upgrade = null;
            }
            this.devices.add(upgrade);
        }
        if (devAddr == null) {
            return;
        }
        offset = devDependentTableOffset;
        while (this.data[offset] != this.remote.getSectionTerminator()) {
            int deviceTypeIndex;
            DeviceUpgrade upg;
            DeviceButton deviceButton = this.remote.getDeviceButtons()[this.data[offset + 2]];
            fullCode = Hex.get(this.data, offset + 3);
            setupCode = fullCode & 0xFFF;
            setupCode += this.remote.getDeviceCodeOffset();
            if (!this.remote.usesTwoBytePID()) {
                setupCode &= 0x7FF;
            }
            if ((upg = this.findDeviceUpgrade(deviceTypeIndex = fullCode >> 12 & 0xF, setupCode)) != null) {
                upg.setButtonRestriction(deviceButton);
            } else {
                DeviceType devType = this.remote.getDeviceTypeByIndex(deviceTypeIndex);
                int codeOffset = offset + 5;
                int pid = this.data[codeOffset];
                if (this.remote.usesTwoBytePID()) {
                    pid = processor.getInt(this.data, codeOffset);
                } else if ((fullCode & 0x800) == 2048) {
                    pid += 256;
                }
                bounds[0] = offset + this.data[offset];
                bounds[1] = offset + this.data[offset + 1];
                int limit = this.getLimit(offset, bounds);
                Hex deviceHex = Hex.subHex(this.data, codeOffset, limit - codeOffset);
                ProtocolUpgrade pu = this.getProtocol(pid);
                Hex protocolCode = null;
                if (pu != null) {
                    pu.setUsed(true);
                    protocolCode = pu.getCode();
                } else if (this.data[offset + 1] > 0) {
                    codeOffset = bounds[1];
                    while (bounds[0] < codeOffset) {
                        bounds[0] = bounds[0] + this.data[bounds[0]];
                    }
                    limit = this.getLimit(codeOffset, bounds);
                    protocolCode = Hex.subHex(this.data, codeOffset, limit - codeOffset);
                    pu = new ProtocolUpgrade(pid, protocolCode, null);
                    pu.setUsed(true);
                    this.protocols.add(pu);
                }
                String alias = this.remote.getDeviceTypeAlias(devType);
                if (alias == null) {
                    String message = String.format("No device type alias found for device upgrade %1$s/%2$04d.  The device upgrade could not be imported and was discarded.", devType, setupCode);
                    JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                    continue;
                }
                short[] pidHex = new short[]{(short)(pid > 255 ? 1 : 0), (short)(pid & 0xFF)};
                DeviceUpgrade upgrade = new DeviceUpgrade();
                try {
                    upgrade.setRemoteConfig(this);
                    System.err.println();
                    System.err.println("Setup code=" + alias + "/" + setupCode);
                    upgrade.importRawUpgrade(deviceHex, this.remote, alias, new Hex(pidHex), protocolCode);
                    upgrade.setSetupCode(setupCode);
                    upgrade.setButtonIndependent(false);
                    upgrade.setButtonRestriction(deviceButton);
                }
                catch (ParseException pe) {
                    pe.printStackTrace(System.err);
                    upgrade = null;
                }
                this.devices.add(upgrade);
            }
            if ((offset += this.data[offset]) <= devAddr.getEnd()) continue;
            String message = "Invalid data in device-specific upgrade.  The data appears to overrun the section.";
            JOptionPane.showMessageDialog(null, message, "Upgrade Error", 0);
            break;
        }
    }

    public LinkedHashMap<Protocol, ProtocolUpgrade> getOutputProtocolUpgrades(boolean check) {
        LinkedHashMap<Integer, ProtocolUpgrade> firstProtocols = new LinkedHashMap<Integer, ProtocolUpgrade>();
        LinkedHashMap<Protocol, ProtocolUpgrade> outputProtocols = new LinkedHashMap<Protocol, ProtocolUpgrade>();
        for (DeviceUpgrade dev : this.devices) {
            Hex code;
            Protocol p;
            ProtocolUpgrade output;
            if (!dev.getButtonIndependent().booleanValue() || !dev.needsProtocolCode() || (output = (p = dev.getProtocol()).getProtocolUpgrade(this.remote)) == null || (code = output.getCode()) == null || code.length() == 0) continue;
            output.setHighlight(dev.getProtocolHighlight());
            int pid = output.getPid();
            ProtocolUpgrade first = (ProtocolUpgrade)firstProtocols.get(pid);
            if (first == null) {
                firstProtocols.put(pid, output);
            } else {
                if (first.getCode().equals(code)) continue;
                if (check) {
                    String message = "The protocol code used by the device upgrade for " + dev.getDeviceTypeAliasName() + '/' + dev.getSetupCode() + " is different from the code already used by another device upgrade, and may not work as intended.";
                    JOptionPane.showMessageDialog(null, message, "Protocol Code Mismatch", 0);
                }
            }
            outputProtocols.put(p, output);
        }
        for (ProtocolUpgrade pu : this.protocols) {
            outputProtocols.put(pu.getProtocol(), pu);
        }
        return outputProtocols;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap<Protocol, ProtocolUpgrade> updateUpgrades() {
        int n;
        void var11_37;
        void var11_36;
        int n2;
        void var11_31;
        ArrayList<DeviceUpgrade> devIndependent = new ArrayList<DeviceUpgrade>();
        ArrayList<DeviceUpgrade> devDependent = new ArrayList<DeviceUpgrade>();
        for (DeviceUpgrade dev : this.devices) {
            if (dev.hasSerial() || dev.isInternal()) continue;
            dev.clearMemoryUsage();
            dev.clearProtocolMemoryUsage();
            if (dev.getButtonIndependent().booleanValue()) {
                devIndependent.add(dev);
                if (dev.needsProtocolCode() && dev.getCode() != null) {
                    dev.addProtocolMemoryUsage(dev.getCode().length() + 4);
                }
            }
            if (this.remote.hasDeviceDependentUpgrades() <= 0 || dev.getButtonRestriction() == DeviceButton.noButton) continue;
            devDependent.add(dev);
        }
        AddressRange addr = this.remote.getUpgradeAddress();
        AddressRange devAddr = this.remote.getDeviceUpgradeAddress();
        LinkedHashMap<Protocol, ProtocolUpgrade> outputProtocols = this.getOutputProtocolUpgrades(false);
        if (this.hasSegments()) {
            int upgType = this.remote.getSegmentTypes().contains(14) ? 14 : (this.remote.getSegmentTypes().contains(16) ? 16 : -1);
            boolean usesProtocolUpgrade = this.remote.getSegmentTypes().contains(15);
            if (upgType < 0) {
                return null;
            }
            this.segments.remove(upgType);
            if (usesProtocolUpgrade) {
                this.segments.remove(15);
            }
            for (DeviceUpgrade dev : this.devices) {
                void var11_18;
                void var11_21;
                Hex hex;
                if (dev.hasSerial() || dev.isInternal()) continue;
                dev.classifyButtons();
                if (dev.getProtocol() == null) continue;
                Hex hex2 = dev.getUpgradeHex();
                Hex hex3 = hex = dev.needsProtocolCode() ? dev.getCode() : null;
                if (hex != null && this.remote.usesEZRC()) {
                    Hex hex4 = RemoteConfiguration.encryptObjcode(hex);
                }
                if (var11_21 != null && upgType == 14) {
                    if (!usesProtocolUpgrade) {
                        System.err.println("Skipping device " + dev.getName() + " as it requires protocol code");
                        continue;
                    }
                    Object var11_22 = null;
                }
                int codeOffset = 0;
                int size = hex2.length() + (var11_18 != null ? codeOffset + var11_18.length() : 0) + (dev.getExtraData() != null ? dev.getExtraData().length() : 0);
                int lenMod = (size += this.remote.doForceEvenStarts() && (size & 1) == 0 ? 10 : 9) & this.remote.getForceModulus() - 1;
                Hex segData = new Hex(size += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                int flags = dev.getSegmentFlags();
                Arrays.fill(segData.getData(), 0, 4, (short)0);
                segData.getData()[segData.length() - 1] = (short)(this.remote.usesEZRC() ? 255 : 0);
                if (!dev.getButtonIndependent().booleanValue()) {
                    segData.getData()[0] = (short)dev.getButtonRestriction().getButtonIndex();
                }
                if (var11_18 != null) {
                    segData.put(hex2.length() + 5 + codeOffset, 2);
                }
                segData.set((short)dev.getDeviceType().getNumber(), 4);
                segData.put(dev.getSetupCode(), 5);
                segData.set((short)dev.getSizeCmdBytes(), 7);
                segData.set((short)dev.getSizeDevBytes(), 8);
                segData.put(hex2, 9);
                if (var11_18 != null) {
                    segData.put((Hex)var11_18, hex2.length() + 9 + codeOffset);
                }
                if (dev.getExtraData() != null) {
                    segData.put(dev.getExtraData(), hex2.length() + 9 + (var11_18 != null ? codeOffset + var11_18.length() : 0));
                }
                if (upgType == 14) {
                    Hex newHex = new Hex(segData.subHex(0, 2), 0, segData.length() - 2);
                    newHex.put(segData.subHex(4), 2);
                    segData = newHex;
                }
                if (this.segments.get(upgType) == null) {
                    this.segments.put(upgType, new ArrayList());
                }
                this.segments.get(upgType).add(new Segment(upgType, flags, segData, dev));
                if (this.remote.hasDeviceDependentUpgrades() <= 0 || dev.getButtonRestriction() == DeviceButton.noButton || var11_18 == null) continue;
                dev.addProtocolMemoryUsage(var11_18.length());
            }
            if (this.remote.getSegmentTypes().contains(15)) {
                for (ProtocolUpgrade pu : outputProtocols.values()) {
                    pu.clearMemoryUsage();
                    Hex code = pu.getCode();
                    int n3 = pu.getPid();
                    int size = code.length() + 4;
                    int lenMod = size & this.remote.getForceModulus() - 1;
                    Hex segData = new Hex(size += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                    segData.put(0, 0);
                    segData.put(n3, 2);
                    segData.put(code, 4);
                    if (this.segments.get(15) == null) {
                        this.segments.put(15, new ArrayList());
                    }
                    this.segments.get(15).add(new Segment(15, 255, segData, pu));
                }
            }
            if (!this.remote.hasRf4ceSupport() && (this.remote.getSegmentTypes().contains(10) || this.remote.getSegmentTypes().contains(32))) {
                if (this.remote.getSegmentTypes().contains(10)) {
                    this.segments.remove(10);
                }
                if (this.remote.getSegmentTypes().contains(32)) {
                    this.segments.remove(32);
                }
                for (Iterator<Highlight> iterator : this.remote.getDeviceButtons()) {
                    Segment segment;
                    Object hex;
                    DeviceUpgrade du = ((DeviceButton)((Object)iterator)).getUpgrade();
                    LinkedHashMap<Button, String> map = new LinkedHashMap<Button, String>();
                    if (this.remote.getSegmentTypes().contains(10)) {
                        boolean allowEmpty;
                        if (this.segments.get(10) == null) {
                            this.segments.put(10, new ArrayList());
                        }
                        if (du != null) {
                            for (Button b : du.getSoftButtons()) {
                                String name = null;
                                if (this.remote.usesEZRC()) {
                                    name = du.getButtonRestriction().getGeneralFunction(b).getName();
                                }
                                if (name == null) {
                                    name = du.getGeneralFunction(b.getKeyCode(), true).getName();
                                }
                                map.put(b, name);
                            }
                        }
                        hex = this.createNameHex(map);
                        ((Hex)hex).set((short)((DeviceButton)((Object)iterator)).getButtonIndex(), 0);
                        segment = new Segment(10, 255, (Hex)hex);
                        if (du != null) {
                            du.setSoftButtonSegment(segment);
                        }
                        boolean bl = allowEmpty = this.remote.getSoftDevices() != null && this.remote.getSoftDevices().getAllowEmptyButtonSettings();
                        if (!allowEmpty || du != null) {
                            this.segments.get(10).add(segment);
                        }
                    }
                    map.clear();
                    if (this.remote.hasRf4ceSupport() || !this.remote.getSegmentTypes().contains(32) || du == null || du.getHardButtons().isEmpty()) continue;
                    if (this.segments.get(32) == null) {
                        this.segments.put(32, new ArrayList());
                    }
                    for (Button b : du.getHardButtons()) {
                        String name = null;
                        if (this.remote.usesEZRC()) {
                            name = du.getButtonRestriction().getGeneralFunction(b).getName();
                        }
                        if (name == null) {
                            name = du.getGeneralFunction(b.getKeyCode(), true).getName();
                        }
                        map.put(b, name);
                    }
                    hex = this.createNameHex(map);
                    ((Hex)hex).set((short)((DeviceButton)((Object)iterator)).getButtonIndex(), 0);
                    segment = new Segment(32, 255, (Hex)hex);
                    du.setSoftFunctionSegment(segment);
                    this.segments.get(32).add(segment);
                }
            }
            return outputProtocols;
        }
        if (addr == null && devAddr == null) {
            return null;
        }
        Processor processor = this.remote.getProcessor();
        int devCount = devIndependent.size();
        int prCount = outputProtocols.size();
        int tableSize = 4 * (devCount + prCount + 1);
        if (processor.getName().equals("740")) {
            tableSize += 4;
        }
        updateLocator ul = new updateLocator(tableSize);
        boolean bl = false;
        int[] devOffsets = new int[devCount];
        LinkedHashMap<Protocol, DeviceUpgrade> forCodeTranslators = new LinkedHashMap<Protocol, DeviceUpgrade>();
        int i = 0;
        for (DeviceUpgrade dev : devIndependent) {
            Hex hex = dev.getUpgradeHex();
            Protocol protocol = dev.getProtocol();
            if (protocol != null && protocol.getCodeTranslators(this.remote) != null) {
                forCodeTranslators.put(protocol, dev);
            }
            int n4 = ul.nextOffset(hex.length());
            devOffsets[i++] = Math.max(0, n4);
            if (ul.isFull()) continue;
            this.updateHighlight(dev, n4, hex.length());
            Hex.put(hex, this.data, n4);
        }
        int devUpgradesEnd = addr.getFreeStart() + this.remote.getBaseAddress();
        int[] prOffsets = new int[prCount];
        i = 0;
        for (ProtocolUpgrade protocolUpgrade : outputProtocols.values()) {
            protocolUpgrade.clearMemoryUsage();
            Hex hex = protocolUpgrade.getCode();
            if (hex == null) continue;
            DeviceUpgrade du = (DeviceUpgrade)forCodeTranslators.get(protocolUpgrade.getProtocol());
            if (du != null) {
                du.translateCode(hex);
            }
            int n5 = ul.nextOffset(hex.length());
            prOffsets[i++] = Math.max(0, n5);
            if (ul.isFull()) continue;
            this.updateHighlight(protocolUpgrade, n5, hex.length());
            Hex.put(hex, this.data, n5);
        }
        int protUpgradesEnd = addr.getFreeStart() + this.remote.getBaseAddress();
        int n6 = addr.getFreeStart();
        processor.putInt(protUpgradesEnd, this.data, addr.getStart());
        processor.putInt(devCount, this.data, n6);
        var11_29 += 2;
        for (DeviceUpgrade dev : devIndependent) {
            void var11_30;
            this.updateHighlight(dev, (int)var11_30, 2);
            processor.putInt(Hex.get(dev.getHexSetupCode(), 0), this.data, (int)var11_30);
            var11_30 += 2;
        }
        i = 0;
        for (int devOffset : devOffsets) {
            this.updateHighlight((Highlight)devIndependent.get(i++), (int)var11_31, 2);
            processor.putInt(devOffset + this.remote.getBaseAddress(), this.data, (int)var11_31);
            var11_31 += 2;
        }
        if (processor.getName().equals("740")) {
            processor.putInt(devUpgradesEnd, this.data, (int)var11_31);
            var11_32 += 2;
        }
        if (devCount == 0 && prCount == 0) {
            n2 = protUpgradesEnd - this.remote.getBaseAddress();
        }
        processor.putInt((int)(n2 + this.remote.getBaseAddress()), this.data, addr.getStart() + 2);
        processor.putInt(prCount, this.data, n2);
        var11_34 += 2;
        i = 0;
        Color[] colorArray = new Color[prCount];
        for (ProtocolUpgrade pr : outputProtocols.values()) {
            void var11_35;
            this.updateHighlight(pr, (int)var11_35, 2);
            processor.putInt(pr.getPid(), this.data, (int)var11_35);
            var11_35 += 2;
            colorArray[i++] = pr.getHighlight();
            pr.addMemoryUsage(2);
        }
        for (i = 0; i < prCount; ++i) {
            Color color = colorArray[i];
            this.highlight[var11_36 + true] = color;
            this.highlight[var11_36] = color;
            processor.putInt(prOffsets[i] + this.remote.getBaseAddress(), this.data, (int)var11_36);
            var11_36 += 2;
        }
        if (processor.getName().equals("740")) {
            processor.putInt(protUpgradesEnd, this.data, (int)var11_36);
            processor.putInt((int)((var11_37 += 2) - addr.getStart() + 2), this.data, addr.getStart() - 2);
        }
        addr.setFreeStart((int)var11_37);
        if (ul.newOverflow()) {
            String title = "Upgrade Overflow";
            String message = "The upgrades have overflowed into the Learned and/or\nMove/Macro regions.  Progress bars for regions that include\nsuch overflow have either background or text color YELLOW\ninstead of the normal color.  Which is YELLOW depends on\nthe look-and=feel.";
            JOptionPane.showMessageDialog(null, message, title, 1);
        }
        if (devAddr == null) {
            return null;
        }
        Collections.sort(devDependent, new DependentUpgradeComparator());
        int lastProtID = -1;
        int lastProtAddr = -1;
        int lastDevAddr = n = devAddr.getEnd();
        this.data[n] = this.remote.getSectionTerminator();
        for (i = 0; i < devDependent.size(); ++i) {
            void var11_39;
            DeviceUpgrade upg = (DeviceUpgrade)devDependent.get(i);
            int upgLength = upg.getUpgradeLength();
            int protOffset = 0;
            int buttonIndex = upg.getButtonRestriction().getButtonIndex();
            if (upg.needsProtocolCode()) {
                int protID = upg.getProtocol().getID().get(0);
                if (protID == lastProtID && lastProtAddr - var11_39 + upgLength + 5 <= 255) {
                    protOffset = lastProtAddr - var11_39 + upgLength + 5;
                } else {
                    Hex hex = upg.getCode();
                    if (hex != null && hex.length() > 0) {
                        var11_39 -= hex.length();
                        for (int j = 0; j < hex.length(); ++j) {
                            this.highlight[var11_39 + j] = upg.getProtocolHighlight();
                        }
                        upg.addProtocolMemoryUsage(hex.length());
                        Hex.put(hex, this.data, (int)var11_39);
                        lastProtID = protID;
                        lastProtAddr = var11_39;
                        protOffset = upgLength + 5;
                    }
                }
            }
            Hex hex = upg.getUpgradeHex();
            this.updateHighlight(upg, (int)(var11_39 -= upgLength + 5), hex.length() + 5);
            Hex.put(hex, this.data, (int)(var11_39 + 5));
            Hex.put(upg.getHexSetupCode(), this.data, (int)(var11_39 + 3));
            this.data[var11_39 + 2] = (short)buttonIndex;
            this.data[var11_39 + true] = (short)protOffset;
            this.data[var11_39] = (short)(lastDevAddr - var11_39);
            upg.setDependentOffset((int)var11_39);
            lastDevAddr = var11_39;
            devAddr.setFreeEnd((int)(var11_39 - true));
        }
        int n7 = devAddr.getStart();
        processor.putInt(lastDevAddr - n7, this.data, n7);
        devAddr.setFreeStart(n7 + 2);
        return null;
    }

    public void decodeLearnedSignals() {
        AddressRange addr = this.remote.getLearnedAddress();
        if (addr == null) {
            return;
        }
        HexReader reader = new HexReader(this.data, addr);
        LearnedSignal signal = null;
        while ((signal = LearnedSignal.read(reader, this.remote)) != null) {
            this.learned.add(signal);
        }
    }

    private void updateInputKeySetting() {
        if (!this.hasSegments() || !this.remote.getSegmentTypes().contains(47) || this.remote.getKeyButtonGroups() == null) {
            return;
        }
        Hex segData = new Hex(4);
        segData.put(0, 0);
        segData.getData()[2] = 17;
        segData.getData()[3] = 255;
        if (this.segments.get(47) == null) {
            this.segments.put(47, new ArrayList());
            this.segments.get(47).add(new Segment(47, 255, segData));
        }
    }

    private void updateLEDColor() {
        if (!(this.hasSegments() && this.remote.getSegmentTypes().contains(46) && this.remote.usesLedColor())) {
            return;
        }
        int devCount = this.remote.getDeviceButtons().length;
        if (this.remote.getLedParams().length > devCount && this.remote.getLedSettings() != null) {
            for (int i = 0; i < Math.min(this.remote.getLedParams().length - devCount, this.remote.getLedSettings().length); ++i) {
                Setting s = this.remote.getSetting(this.remote.getLedSettings()[i]);
                if (s == null) continue;
                this.remote.getDeviceButtons()[i].setColorIndex(Math.abs(this.remote.getLedParams()[devCount * s.getValue() + i]));
            }
        }
        this.segments.remove(46);
        DeviceButton db = null;
        for (DeviceButton test : this.remote.getDeviceButtons()) {
            if (!test.isColorEditable() || test.getColorParams() == null) continue;
            db = test;
            break;
        }
        if (db != null) {
            Hex segData = new Hex(6);
            int[] params = db.getColorParams();
            segData.put(0, 0);
            for (int i = 0; i < 3 && i < params.length; ++i) {
                segData.getData()[i + 2] = (short)params[i];
            }
            segData.getData()[5] = (short)db.getColorIndex();
            if (this.segments.get(46) == null) {
                this.segments.put(46, new ArrayList());
            }
            this.segments.get(46).add(new Segment(46, 255, segData));
        }
    }

    private void updateLearnedSignals() {
        if (this.hasSegments()) {
            if (!this.remote.getSegmentTypes().contains(9)) {
                return;
            }
            for (LearnedSignal ls : this.learned) {
                if (!ls.forUpload()) continue;
                int format = this.remote.getLearnedFormat();
                ls.clearMemoryUsage();
                Hex hex = ls.getData();
                int size = hex.length();
                int segSize = size + 2 + (format == 0 || format == 4 ? 0 : (format == 3 ? 5 : 2));
                int lenMod = segSize & this.remote.getForceModulus() - 1;
                Hex segData = new Hex(segSize += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
                int flags = ls.getSegmentFlags();
                segData.set((short)ls.getDeviceButtonIndex(), 0);
                segData.set((short)ls.getKeyCode(), 1);
                if (format == 1 || format == 2) {
                    segData.set((short)(size + 1), 2);
                    segData.set((short)0, 3);
                    segData.put(hex, 4);
                    if ((size & 1) == 1) {
                        segData.set((short)255, segSize - 1);
                    }
                } else if (format == 3) {
                    segData.set((short)0, 2);
                    segData.set((short)(size + 3), 3);
                    segData.set((short)0, 4);
                    segData.set((short)ls.getKeyCode(), 5);
                    segData.set((short)0, 6);
                    segData.put(hex, 7);
                } else {
                    segData.put(hex, 2);
                }
                if (this.segments.get(9) == null) {
                    this.segments.put(9, new ArrayList());
                }
                this.segments.get(9).add(new Segment(9, flags, segData, ls));
            }
            return;
        }
        AddressRange addr = this.remote.getLearnedAddress();
        if (addr == null) {
            return;
        }
        int offset = addr.getStart();
        for (LearnedSignal ls : this.learned) {
            if (!ls.forUpload()) continue;
            ls.clearMemoryUsage();
            this.updateHighlight(ls, offset, ls.getSize());
            offset = ls.store(this.data, offset, this.remote);
        }
        this.data[offset++] = this.remote.getSectionTerminator();
        addr.setFreeStart(offset);
    }

    private void updateGlobalPunchthru() {
        if (!this.remote.getSegmentTypes().contains(25)) {
            return;
        }
        this.segments.remove(25);
        for (GlobalPT globalPT : this.globalPTs) {
            globalPT.clearMemoryUsage();
            int segSize = globalPT.getActiveBtnCodes().length() + globalPT.getActiveDevCodes().length() + 4;
            int lenMod = segSize & this.remote.getForceModulus() - 1;
            Hex segData = new Hex(segSize += this.remote.doForceEvenStarts() && lenMod > 0 ? this.remote.getForceModulus() - lenMod : 0);
            int btnCount = globalPT.getActiveBtnCodes().length();
            int devCount = globalPT.getActiveDevCodes().length();
            segData.set((short)255, segData.length() - 1);
            segData.set((short)globalPT.getDeviceButtonIndex(), 0);
            segData.set((short)0, 1);
            segData.set((short)btnCount, 2);
            segData.set((short)devCount, 3);
            segData.put(globalPT.getActiveBtnCodes(), 4);
            segData.put(globalPT.getActiveDevCodes(), 4 + btnCount);
            if (this.segments.get(25) == null) {
                this.segments.put(25, new ArrayList());
            }
            this.segments.get(25).add(new Segment(25, 255, segData, globalPT));
        }
    }

    public int getDataEnd(short[] data) {
        if (this.remote.isSSD()) {
            int end = data[2] + (data[3] << 8) + ((data[1] & 0xF0) << 12);
            return end + 1023 & 0xFFFFFC00;
        }
        return data.length;
    }

    public void save(File file) throws IOException {
        int len;
        int i;
        int remaining;
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        PropertyWriter pw = new PropertyWriter(out);
        short[] dataToSave = this.owner.useSavedData() ? this.savedData : this.data;
        pw.printHeader("General");
        pw.print("Remote.name", this.remote.getName());
        pw.print("Remote.signature", this.remote.getSignature());
        if (this.hasSegments() && this.sigData != null) {
            short[] sigDataOut = this.sigData;
            if (this.remote.usesSimpleset()) {
                sigDataOut = Arrays.copyOfRange(this.sigData, 0, 64);
            }
            if ((this.sigData[2] | this.sigData[3]) != 0 || this.remote.usesSimpleset()) {
                pw.print("Remote.sigData", Hex.toString(sigDataOut));
            }
        }
        if (this.notes != null) {
            pw.print("Notes", this.notes);
        }
        if (this.icinfo != null) {
            pw.print("Info", Hex.toString(this.icinfo));
        }
        int sigAddress = 0;
        if (this.sigData != null && (sigAddress = this.getSigAddress()) >= 0) {
            out.println("Signature:");
            remaining = this.sigData.length;
            for (i = 0; i < this.sigData.length; i += 16) {
                len = Math.min(remaining, 16);
                remaining -= len;
                pw.print(String.format("%04X", i + sigAddress), Hex.toString(this.sigData, i, len));
            }
        }
        if (this.rfData != null) {
            out.println("RFData:");
            remaining = this.rfData.length;
            for (i = 0; i < 128; i += 16) {
                len = Math.min(remaining, 16);
                remaining -= len;
                pw.print(String.format("%04X", i + this.rfDataAddress), Hex.toString(this.rfData, i, len));
            }
        }
        pw.printHeader("Buffer");
        int base = this.remote.getBaseAddress();
        for (i = 0; i < this.getDataEnd(dataToSave); i += 16) {
            pw.print(String.format("%04X", i + base), Hex.toString(dataToSave, i, 16));
        }
        boolean haveNotes = false;
        for (String string : this.deviceButtonNotes) {
            if (string == null) continue;
            haveNotes = true;
            break;
        }
        if (haveNotes) {
            pw.printHeader("DeviceButtonNotes");
            DeviceButton[] deviceButtons = this.remote.getDeviceButtons();
            for (int i2 = 0; i2 < this.deviceButtonNotes.length; ++i2) {
                String note = this.deviceButtonNotes[i2];
                Highlight highlight = deviceButtons[i2];
                if (note == null) continue;
                pw.print(highlight.getName(), note);
            }
        }
        if (this.remote.hasRf4ceSupport()) {
            for (Highlight highlight : this.remote.getDeviceButtons()) {
                if (((DeviceButton)highlight).getRfSelectors() == null || ((DeviceButton)highlight).getRfSelectors().length <= 0) continue;
                pw.printHeader("DeviceButton");
                ((DeviceButton)highlight).store(pw);
            }
        }
        pw.printHeader("Settings");
        for (Highlight highlight : this.remote.getSettings()) {
            ((Setting)highlight).store(pw);
        }
        for (KeyMove keyMove : this.keymoves) {
            String className = keyMove.getClass().getName();
            int n = className.lastIndexOf(46);
            className = className.substring(n + 1);
            pw.printHeader(className);
            keyMove.store(pw);
        }
        for (Macro macro : this.getAllMacros(true)) {
            pw.printHeader("Macro");
            macro.store(pw, this.remote);
        }
        for (SpecialProtocolFunction sp : this.specialFunctions) {
            String className = sp.getClass().getName();
            int n = className.lastIndexOf(46);
            className = className.substring(n + 1);
            pw.printHeader(className);
            if (className.equals("UserSpecialFunction")) {
                pw.print("Function", sp.get_Type(this));
            }
            if (sp.isInternal()) {
                pw.print("Internal", "true");
                sp.getMacro().store(pw, this.remote);
                continue;
            }
            sp.getKeyMove().store(pw);
        }
        for (TimedMacro tm : this.timedMacros) {
            pw.printHeader("TimedMacro");
            tm.store(pw);
        }
        for (GlobalPT globalPT : this.globalPTs) {
            pw.printHeader("GlobalPT");
            globalPT.store(pw);
        }
        for (FavScan fs : this.favScans) {
            pw.printHeader("FavScan");
            fs.store(pw, this);
        }
        if (this.remote.usesEZRC() && this.favScans.size() > 0) {
            Activity activity = null;
            activity = this.remote.getFavKey().getActivity();
            if (activity != null) {
                pw.printHeader("FavData");
                pw.print("Pause", this.remote.getFavKey().getFavPause());
                if (!this.remote.isSSD()) {
                    pw.print("FavWidth", this.favKeyDevButton.getFavoriteWidth());
                    Button favFinalKey = this.favKeyDevButton.getFavFinalKey();
                    if (favFinalKey != null && favFinalKey != Button.noButton) {
                        pw.print("FinalKey", favFinalKey.getKeyCode());
                    }
                }
                ActivityGroup.store(pw, activity.getActivityGroups());
            }
        }
        for (DeviceUpgrade device : this.devices) {
            if (device.hasSerial() || device.isInternal()) continue;
            pw.printHeader("DeviceUpgrade");
            device.store(pw);
        }
        for (ProtocolUpgrade protocol : this.protocols) {
            pw.printHeader("ProtocolUpgrade");
            protocol.store(pw);
            ManualProtocol mp = protocol.getManualProtocol(this.remote);
            if (mp == null) continue;
            pw.printHeader("ManualProtocol");
            pw.print("Name", mp.getName());
            pw.print("PID", mp.getID());
            mp.store(pw);
        }
        if (this.activities != null) {
            for (Activity activity : this.activities.values()) {
                if (!activity.isActive()) continue;
                pw.printHeader("Activity");
                activity.store(pw);
            }
        }
        if (this.remote.getFavKey() != null && this.remote.getFavKey().getProfiles() != null) {
            for (Activity activity : this.remote.getFavKey().getProfiles()) {
                pw.printHeader("Profile");
                activity.store(pw);
            }
        }
        for (LearnedSignal signal : this.learned) {
            pw.printHeader("LearnedSignal");
            signal.store(pw);
        }
        out.close();
    }

    private String exportNotes(String text) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(text));
        StringBuilder buff = new StringBuilder(text.length());
        String line = br.readLine();
        while (line != null) {
            buff.append(line);
            line = br.readLine();
            if (line == null) continue;
            buff.append('\u00ae');
        }
        return buff.toString();
    }

    public Remote getRemote() {
        return this.remote;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String text) {
        this.notes = text;
    }

    public short[] getData() {
        return this.data;
    }

    public List<SSDFileInfo> getSsdFileData() {
        return this.ssdFileData;
    }

    public void setSsdFileData(List<SSDFileInfo> ssdFileData) {
        this.ssdFileData = ssdFileData;
    }

    public List<SSDFileInfo> getSavedSSDFileData() {
        return this.savedSSDFileData;
    }

    public void setSavedSSDFileData(List<SSDFileInfo> savedSSDFileData) {
        this.savedSSDFileData = savedSSDFileData;
    }

    public void resizeData(int newLength) {
        if (this.data.length == newLength) {
            return;
        }
        short[] newData = Arrays.copyOf(this.data, newLength);
        short[] newSavedData = Arrays.copyOf(this.savedData, newLength);
        if (newLength > this.data.length) {
            Arrays.fill(newData, this.data.length, newLength, (short)255);
            Arrays.fill(newSavedData, this.data.length, newLength, (short)255);
        }
        this.data = newData;
        this.savedData = newSavedData;
        if (this.baselineData != null) {
            short[] newBaselineData = Arrays.copyOf(this.baselineData, newLength);
            if (newLength > this.data.length) {
                Arrays.fill(newBaselineData, this.data.length, newLength, (short)255);
            }
            this.baselineData = newBaselineData;
        }
    }

    public String getSigString() {
        if (this.sigData == null || (this.sigData[2] | this.sigData[3]) == 0) {
            return null;
        }
        char[] sig = new char[26];
        for (int i = 0; i < Math.min(this.sigData.length, 26); ++i) {
            sig[i] = (char)this.sigData[i];
        }
        return String.valueOf(sig);
    }

    private int getSigAddress() {
        if (this.icinfo != null) {
            int sigAddress = 0;
            for (int i = 2; i < this.icinfo.length; ++i) {
                sigAddress = (sigAddress << 8) + this.icinfo[i];
            }
            return sigAddress;
        }
        int addrLen = this.remote.getProcessor().getAddressLength();
        int sigOffset = 0;
        int valueOffset = 0;
        if (this.sigData == null) {
            return 0;
        }
        if (Hex.get(this.sigData, 2) == 0) {
            int blockLen = Hex.get(this.sigData, 4);
            sigOffset = blockLen == 512 ? 43 + 2 * addrLen : 44 + addrLen;
        } else {
            sigOffset = 26 + addrLen;
            valueOffset = 1;
        }
        int baseAddr = 0;
        try {
            baseAddr = Hex.get(this.sigData, sigOffset);
            if (addrLen == 4) {
                baseAddr = baseAddr * 65536 + Hex.get(this.sigData, sigOffset + 2);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return baseAddr + valueOffset;
    }

    public Color[] getHighlight() {
        return this.highlight;
    }

    public short[] getSavedData() {
        return this.savedData;
    }

    public void setSavedData() {
        this.savedData = new short[this.data.length];
        System.arraycopy(this.data, 0, this.savedData, 0, this.data.length);
    }

    public short[] getBaselineData() {
        return this.baselineData;
    }

    public void setBaselineData() {
        short[] dataToShow = this.owner.useSavedData() ? this.savedData : this.data;
        this.baselineData = new short[dataToShow.length];
        System.arraycopy(dataToShow, 0, this.baselineData, 0, this.baselineData.length);
    }

    public void clearBaselineData() {
        this.baselineData = null;
    }

    public Remote.SetupValidation getSetupValidation() {
        return this.owner.validationOverride == null ? this.remote.getRDFSetupValidation() : this.owner.validationOverride;
    }

    public String[] getDeviceButtonNotes() {
        return this.deviceButtonNotes;
    }

    public void setDeviceButtonNotes(String[] deviceButtonNotes) {
        this.deviceButtonNotes = deviceButtonNotes;
    }

    public List<KeyMove> getKeyMoves() {
        return this.keymoves;
    }

    public void setKeyMoves(List<KeyMove> keymoves) {
        this.keymoves = keymoves;
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public List<GlobalPT> getGlobalPTs() {
        return this.globalPTs;
    }

    public List<Macro> getTableMacros() {
        ArrayList<Macro> list = new ArrayList<Macro>();
        for (Macro macro : this.macros) {
            if (!macro.accept(false)) continue;
            list.add(macro);
        }
        return list;
    }

    public List<FavScan> getFavScans() {
        return this.favScans;
    }

    public List<TimedMacro> getTimedMacros() {
        return this.timedMacros;
    }

    public List<DeviceButton> getDeviceButtonList() {
        return this.deviceButtonList;
    }

    public List<DeviceUpgrade> getDeviceUpgrades() {
        return this.devices;
    }

    public void setDeviceUpgrades(List<DeviceUpgrade> devices) {
        this.devices = devices;
    }

    public List<ProtocolUpgrade> getProtocolUpgrades() {
        return this.protocols;
    }

    public void setProtocolUpgrades(List<ProtocolUpgrade> protocols) {
        this.protocols = protocols;
    }

    public List<LearnedSignal> getLearnedSignals() {
        return this.learned;
    }

    public void setLearnedSignals(List<LearnedSignal> learned) {
        this.learned = learned;
    }

    public List<SpecialProtocolFunction> getSpecialFunctions() {
        return this.specialFunctions;
    }

    public short[] getIcInfo() {
        return this.icinfo;
    }

    public void setIcInfo(short[] icinfo) {
        this.icinfo = icinfo;
    }

    public short[] getSigData() {
        return this.sigData;
    }

    public void setSigData(short[] sigData) {
        this.sigData = sigData;
    }

    public short[] getRfData() {
        return this.rfData;
    }

    public void setRfData(short[] rfData) {
        this.rfData = rfData;
    }

    public int getRfDataAddress() {
        return this.rfDataAddress;
    }

    public void setRfDataAddress(int rfDataAddress) {
        this.rfDataAddress = rfDataAddress;
    }

    public String getEepromFormatVersion() {
        return this.eepromFormatVersion;
    }

    public HashMap<Button, Macro> getActivityMacros() {
        return this.activityMacros;
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    public void addGid(String name, int gid) {
        List<Integer> list = this.gidRegister.get(name);
        if (this.gidRegister.get(name) == null) {
            list = new ArrayList<Integer>();
            this.gidRegister.put(name, list);
        }
        if (!list.contains(gid)) {
            list.add(gid);
        }
        if (!this.gidList.contains(gid)) {
            this.gidList.add(gid);
        }
    }

    public LinkedHashMap<String, SSDFile> getSsdFiles() {
        return this.ssdFiles;
    }

    public String getRegion() {
        return this.region == null ? "this region" : this.region;
    }

    public boolean isSetToDanish() {
        return this.isSetToDanish;
    }

    public void setIsSetToDanish(boolean isSetToDanish) {
        this.isSetToDanish = isSetToDanish;
    }

    public Setting.NamedHex[] getSSDHexSettings() {
        Setting.NamedHex[] values = new Setting.NamedHex[this.remote.getSettings().length];
        for (int i = 0; i < values.length; ++i) {
            Setting setting = this.remote.getSettings()[i];
            Object[] options = setting.getOptions(this.remote);
            if (options == null || options.length != 1 || !(options[0] instanceof Setting.NamedHex)) continue;
            Setting.NamedHex option = (Setting.NamedHex)options[0];
            values[i] = option.getName().equals("directv_rf") ? new Setting.NamedHex(option.getName(), this.directv_rf) : new Setting.NamedHex(option.getName(), option.getHex());
        }
        return values;
    }

    public String getRegionDisplayName() {
        if (this.remote.isSSD() && this.regionFilename != null) {
            String name2;
            ArrayList<String> ucSysNames = new ArrayList<String>();
            for (String name2 : CommHID.xziteSysNames) {
                ucSysNames.add(name2.toUpperCase());
            }
            int ndx = ucSysNames.indexOf(this.regionFilename.toUpperCase());
            if (ndx >= 0 && (ndx = (name2 = CommHID.xziteSysNames.get(ndx)).indexOf(46)) > 0) {
                return name2.substring(0, ndx);
            }
        }
        return null;
    }

    public String getLanguageDisplayName() {
        if (this.remote.isSSD() && this.language != null) {
            return this.language.substring(0, 1).toUpperCase() + this.language.substring(1);
        }
        return null;
    }

    public LinkedHashMap<Integer, String> getDeviceCategories() {
        return this.deviceCategories;
    }

    public LinkedHashMap<Integer, List<String>> getCategoryBrands() {
        return this.categoryBrands;
    }

    public LinkedHashMap<Integer, Integer> getCodeLocations() {
        return this.codeLocations;
    }

    private void updateSpecialFunctionSublists() {
        this.specialFunctionKeyMoves.clear();
        this.specialFunctionMacros.clear();
        for (SpecialProtocolFunction sp : this.specialFunctions) {
            if (sp.isInternal()) {
                this.specialFunctionMacros.add(sp.getMacro());
                continue;
            }
            this.specialFunctionKeyMoves.add(sp.getKeyMove());
        }
    }

    public DeviceButton getFavKeyDevButton() {
        return this.favKeyDevButton;
    }

    public void setFavKeyDevButton(DeviceButton devButton) {
        this.favKeyDevButton = devButton;
        if (this.remote.usesEZRC()) {
            return;
        }
        if (this.favScans.size() > 0) {
            int size = this.favScans.size();
            this.favScans.get(size - 1).setDeviceButton(devButton);
        }
        if (this.remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
            int buttonIndex = this.favKeyDevButton == DeviceButton.noButton ? 255 : this.favKeyDevButton.getButtonIndex();
            this.data[this.remote.getFavKey().getDeviceButtonAddress()] = (short)buttonIndex;
        } else {
            this.updateAdvancedCodes();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeSetup(int startAddr) {
        SoftDevices softDevices;
        Arrays.fill(this.data, startAddr, this.data.length, (short)255);
        if (!this.remote.isSSD()) {
            if (this.hasSegments()) {
                this.initializeSegments();
                this.owner.resetSegmentPanel();
            } else {
                int start = this.remote.getInterfaceType().equals("JP1") ? 2 : 0;
                byte[] sigBytes = new byte[]{};
                try {
                    sigBytes = this.remote.getSignature().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                for (int i = 0; i < sigBytes.length; ++i) {
                    this.data[start + i] = (short)(sigBytes[i] & 0xFF);
                }
            }
        }
        if ((softDevices = this.remote.getSoftDevices()) == null || !softDevices.inUse() || softDevices.isSetupCodesOnly()) {
            Highlight[] devBtns = this.remote.getDeviceButtons();
            List<DeviceType> devTypeList = this.remote.getDeviceTypeList();
            short[] data = this.data;
            boolean bl = false;
            for (int i = 0; i < devBtns.length; ++i) {
                void var6_13;
                DeviceType dt = devTypeList.get((int)var6_13);
                Highlight db = devBtns[i];
                if (this.hasSegments()) {
                    data = db.getSegment().getHex().getData();
                }
                ((DeviceButton)db).zeroDeviceSlot(data);
                ((DeviceButton)db).setDeviceTypeIndex((short)dt.getNumber(), data);
                ((DeviceButton)db).setDeviceGroup((short)dt.getGroup(), data);
                if (softDevices == null || !softDevices.inUse()) {
                    ((DeviceButton)db).setSetupCode((short)((DeviceButton)db).getDefaultSetupCode(), data);
                }
                if (var6_13 >= devTypeList.size() - 1) continue;
                ++var6_13;
            }
        } else if (this.remote.getSoftDevices().usesFilledSlotCount()) {
            this.data[this.remote.getSoftDevices().getCountAddress()] = 0;
        }
        if (!this.hasSegments()) {
            for (Highlight highlight : this.remote.getSettings()) {
                if (((Setting)highlight).isInverted() || ((Setting)highlight).getByteAddress() < startAddr) continue;
                this.data[((Setting)highlight).getByteAddress()] = 0;
            }
        }
        this.updateFixedData(true);
        if (this.remote.hasFavKey() && this.remote.getFavKey().isSegregated()) {
            int offset = this.remote.getFavScanAddress().getStart();
            this.data[offset++] = 0;
            this.data[offset++] = 0;
        }
        if (this.remote.usesEZRC()) {
            this.deviceButtonList = new ArrayList<DeviceButton>();
        }
        RemoteConfiguration.resetDialogs();
    }

    public void setDateIndicator() {
        Calendar now = Calendar.getInstance();
        int year = now.get(1) % 100;
        int month = now.get(2) - 0 + 1;
        int date = now.get(5);
        if (this.remote.getAdvancedCodeAddress() == null) {
            return;
        }
        int offset = this.remote.getAdvancedCodeAddress().getEnd() - 2;
        this.data[offset++] = (short)(year / 10 << 4 | year % 10);
        this.data[offset++] = (short)(month / 10 << 4 | month % 10);
        this.data[offset++] = (short)(date / 10 << 4 | date % 10);
        this.updateCheckSums();
    }

    public void initializeSegments() {
        List<Integer> segmentTypes = this.remote.getSegmentTypes();
        this.segmentLoadOrder.addAll(segmentTypes);
        if (this.hasSegments()) {
            Hex hex;
            ArrayList<Segment> list = new ArrayList<Segment>();
            for (DeviceButton db : this.remote.getDeviceButtons()) {
                Hex hex2 = new Hex(12);
                short[] data = hex2.getData();
                Arrays.fill(data, (short)255);
                data[0] = (short)db.getButtonIndex();
                data[1] = 0;
                list.add(new Segment(0, 255, hex2, db));
            }
            this.segments.put(0, list);
            if (segmentTypes.contains(218)) {
                list = new ArrayList();
                hex = new Hex(this.remote.getDeviceButtons().length + 2);
                short[] data = hex.getData();
                Arrays.fill(data, (short)255);
                int i = 0;
                data[i++] = 0;
                data[i++] = 0;
                for (DeviceButton db : this.remote.getDeviceButtons()) {
                    data[i++] = (short)db.getButtonIndex();
                }
                list.add(new Segment(218, 255, hex));
            }
            this.segments.put(218, list);
            if (segmentTypes.contains(26)) {
                list = new ArrayList();
                hex = new Hex(3);
                short[] data = hex.getData();
                data[0] = 0;
                data[1] = 0;
                data[2] = 64;
                list.add(new Segment(26, 255, hex));
            }
            this.segments.put(26, list);
        }
    }

    public static void resetDialogs() {
        MacroDialog.reset();
        TimedMacroDialog.reset();
        SpecialFunctionDialog.reset();
        FavScanDialog.reset();
        LearnedSignalDialog.reset();
        LearnedSignalTimingSummaryDialog.reset();
        RMListChooser.reset();
    }

    public boolean allowHighlighting() {
        return this.owner.highlightItem.isSelected() && !this.remote.isSSD();
    }

    public LinkedHashMap<Integer, Hex> getNIB() {
        return this.nib;
    }

    public LinkedHashMap<Integer, GeneralFunction.RMIcon> getUserIcons() {
        return this.userIcons;
    }

    public LinkedHashMap<Integer, GeneralFunction.RMIcon> getSysIcons() {
        return this.sysIcons;
    }

    public LinkedHashMap<Integer, GeneralFunction.RMIcon> getSavedUserIcons() {
        return this.savedUserIcons;
    }

    public RMIRSetup getOwner() {
        return this.owner;
    }

    private Hex makeBXMLFile(SSDFile file) {
        if (file == null) {
            return null;
        }
        int tagSize = 0;
        short tagCount = 0;
        for (String s : file.tagNames) {
            tagSize += s.length() + 1;
            tagCount = (short)(tagCount + 1);
        }
        int hexSize = 17 + tagSize + file.hex.length();
        Hex fileHex = new Hex(hexSize);
        fileHex.put(file.prefix, 0);
        fileHex.put(new Hex("bxml10", 8), 8);
        fileHex.put(this.getLittleEndian(tagSize), 14);
        fileHex.set(tagCount, 16);
        int pos = 17;
        for (String s : file.tagNames) {
            fileHex.put(new Hex(s, 8), pos);
            pos += s.length();
            fileHex.set((short)0, pos++);
        }
        fileHex.put(file.hex, pos);
        return fileHex;
    }

    private short getTag(String name) {
        int tag = this.tagList.indexOf(name);
        if (tag == -1) {
            tag = this.tagList.size();
            this.tagList.add(name);
        }
        return (short)tag;
    }

    private Hex endTag(String name) {
        int tag = this.tagList.indexOf(name);
        if (tag == -1) {
            System.err.println("Tag error:  undefined end tag \"" + name + "\"");
            tag = 128;
        } else {
            tag |= 0x80;
        }
        return new Hex(new short[]{(short)tag});
    }

    private Hex makeItem(String tagName, Hex value, boolean end) {
        Hex hex = new Hex(value.length() + (end ? 3 : 2));
        short tag = this.getTag(tagName);
        hex.set(tag, 0);
        hex.set((short)value.length(), 1);
        hex.put(value, 2);
        if (end) {
            hex.set((short)(tag | 0x80), value.length() + 2);
        }
        return hex;
    }

    private SSDFile makeMacrosXCF() {
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        work.add(this.makeItem("macros", new Hex("macros.xcf", 8), false));
        Iterator<Macro> it = this.getAllMacros(false).iterator();
        while (it.hasNext()) {
            Macro macro = it.next();
            if (macro.isSystemMacro() && macro.getUsers().isEmpty()) {
                it.remove();
            }
            if (!macro.forUpload()) continue;
            work.add(this.makeItem("macro", this.getLittleEndian(macro.getSerial()), false));
            if (macro.getName() == null) continue;
            work.add(this.makeItem("name16", new Hex(macro.getName(), 16), true));
            String btnTag = null;
            Hex btnHex = null;
            boolean isSysMacro = macro.isSystemMacro();
            ListIterator<KeySpec> ksit = macro.getItems().listIterator();
            while (ksit.hasNext()) {
                int val;
                boolean hardKey;
                KeySpec item = ksit.next();
                if (!item.isValid()) {
                    ksit.remove();
                    continue;
                }
                Button b = item.getButton();
                boolean ir = (b == null || isSysMacro) && item.fn != null && item.fn.getSerial() >= 0;
                boolean softKey = !ir && this.remote.isSoftButton(b);
                boolean bl = hardKey = !ir && !softKey;
                btnTag = softKey ? "sendsoftkey" : (hardKey ? "sendhardkey" : "sendir");
                short dev = (short)item.db.getSerial();
                short softPage = (short)(softKey ? (b.getKeyCode() - 49) / 6 : 0);
                int n = val = ir ? item.fn.getSerial() : b.getKeyCode() - 6 * softPage;
                btnHex = softKey ? new Hex(new short[]{dev, softPage, (short)val}) : (hardKey ? new Hex(new short[]{dev, (short)val}) : new Hex(new short[]{dev, (short)(val & 0xFF), (short)(val >> 8)}));
                short delay = (short)item.delay;
                short duration = (short)item.duration;
                work.add(this.makeItem(btnTag, btnHex, false));
                if (isSysMacro || duration >= 0) {
                    work.add(this.makeItem("duration", new Hex(new Hex(this.getLittleEndian(duration * 100), 0, 4)), true));
                }
                work.add(this.endTag(btnTag));
                work.add(this.makeItem("delay", new Hex(new short[]{delay}), true));
            }
            boolean assistantDone = false;
            if (isSysMacro) {
                work.add(this.makeItem("issystemmacro", new Hex(new short[]{1}), true));
            }
            if (isSysMacro) {
                assistantDone = true;
                work.add(this.makeItem("assistant", new Hex(0), false));
            }
            if (macro.getAssists() != null && !macro.getAssists().isEmpty()) {
                LinkedHashMap<Integer, List<Activity.Assister>> assists = macro.getAssists();
                String[] tagNames = null;
                for (int i = 0; i < 3; ++i) {
                    List<Activity.Assister> assisters = assists.get(2 - i);
                    if (assisters.size() <= 0) continue;
                    if (!assistantDone) {
                        assistantDone = true;
                        work.add(this.makeItem("assistant", new Hex(0), false));
                    }
                    if (tagNames == null) {
                        tagNames = new String[]{"powerkeys", "audioinputs", "pictureinputs"};
                        for (String tagName : tagNames) {
                            this.getTag(tagName);
                        }
                    }
                    work.add(this.makeItem((String)tagNames[i], new Hex(0), false));
                    for (Activity.Assister assister : assists.get(2 - i)) {
                        int val;
                        boolean hardKey;
                        if (!assister.ks.isValid()) continue;
                        short dev = (short)assister.ks.db.getSerial();
                        GeneralFunction f = assister.ks.fn;
                        Button b = assister.ks.getButton();
                        boolean ir = b == null;
                        boolean softKey = !ir && this.remote.isSoftButton(b);
                        boolean bl = hardKey = !ir && !softKey;
                        btnTag = softKey ? "softkey" : (hardKey ? "hardkey" : "irref");
                        short softPage = (short)(softKey ? (b.getKeyCode() - 49) / 6 : 0);
                        int n = val = ir ? f.getSerial() : b.getKeyCode() - 6 * softPage;
                        btnHex = softKey ? new Hex(new short[]{dev, softPage, (short)val}) : (hardKey ? new Hex(new short[]{dev, (short)val}) : new Hex(new short[]{dev, (short)(val & 0xFF), (short)(val >> 8)}));
                        work.add(this.makeItem(btnTag, btnHex, true));
                    }
                    work.add(this.endTag(tagNames[i]));
                }
            }
            if (assistantDone) {
                work.add(this.endTag("assistant"));
            }
            work.add(this.endTag("macro"));
        }
        work.add(this.endTag("macros"));
        if (this.tagList.size() == 1) {
            return null;
        }
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private SSDFile makeDevicesXCF() {
        if (this.deviceButtonList == null) {
            return null;
        }
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        work.add(this.makeItem("devices", new Hex("devices.xcf", 8), false));
        for (DeviceButton db : this.deviceButtonList) {
            String model;
            Segment seg = db.getSegment();
            if (seg == null) continue;
            short[] segData = seg.getHex().getData();
            short serial = (short)(db.getButtonIndex() - 80);
            work.add(this.makeItem("device", new Hex("" + new Hex(new short[]{serial}) + " " + new Hex(db.getName(), 16)), false));
            String brand = this.remote.getDeviceLabels().getText2(segData, 1);
            if (brand != null) {
                work.add(this.makeItem("brand", new Hex(brand, 8), true));
            }
            if ((model = this.remote.getDeviceLabels().getText2(segData, 2)) != null) {
                work.add(this.makeItem("model", new Hex(model, 8), true));
            }
            if ((model = this.remote.getDeviceLabels().getText2(segData, 3)) != null) {
                work.add(this.makeItem("remotemodel", new Hex(model, 8), true));
            }
            int iconref = db.icon.ref;
            work.add(this.makeItem("iconref", new Hex(new short[]{(short)iconref}), true));
            Button favFinalKey = db.getFavFinalKey();
            if (favFinalKey != null && favFinalKey != Button.noButton) {
                work.add(this.makeItem("enterkey", new Hex(new short[]{favFinalKey.getKeyCode()}), true));
            }
            work.add(this.makeItem("favoritewidth", new Hex(new short[]{(short)db.getFavoriteWidth()}), true));
            if (db.getVpt() == 2) {
                work.add(this.makeItem("volumemaster", new Hex(0), true));
            }
            if (db.getVpt() >= 1) {
                work.add(this.makeItem("volumelock", new Hex(0), true));
            }
            String s = new String(new char[]{(char)db.getDeviceTypeIndex(segData)});
            s = s + (db.isConstructed() ? "????" : new SetupCode(db.getSetupCode(segData)).toString());
            work.add(this.makeItem("codeset", new Hex(s, 8), false));
            DeviceUpgrade upg = db.getUpgrade();
            Protocol prot = upg.getProtocol();
            if (!db.isConstructed()) {
                Hex fixed = prot.getFixedData(upg.getParmValues());
                if (fixed.length() > 0) {
                    work.add(this.makeItem("prefix", fixed, true));
                }
                work.add(this.makeItem("executor", new Hex(new short[]{prot.getID().getData()[1], prot.getID().getData()[0]}), false));
                Hex code = upg.getCode();
                if (upg.needsProtocolCode() && code != null && code.length() != 0) {
                    work.add(this.makeItem("objcode", RemoteConfiguration.encryptObjcode(code), true));
                }
                work.add(this.endTag("executor"));
            }
            ArrayList<Button> buttons = new ArrayList<Button>(Arrays.asList(this.remote.getUpgradeButtons()));
            Collections.sort(buttons, DeviceUpgrade.ButtonSorter);
            Integer softpage = null;
            boolean irUsed = false;
            upg.filterFunctionMap();
            for (Button b : buttons) {
                Function f = upg.getAssignments().getAssignment(b);
                Macro macro = db.getUpgrade().getMacroMap().get(b.getKeyCode());
                LearnedSignal ls = this.findLearnedSignal(db, b);
                String btnTag = "keydef";
                String name = null;
                GeneralFunction gf = db.getGeneralFunction(b);
                String softName = gf != null ? gf.getName() : null;
                int keyCode = b.getKeyCode();
                if ((f == null || f.getHex() == null) && macro == null && ls == null) {
                    if (f == null) continue;
                    upg.getAssignments().assign(b, null);
                    continue;
                }
                if (!this.remote.isSoftButton(b) && softpage != null || this.remote.isSoftButton(b) && softpage != null && softpage != (keyCode - 49) / 6) {
                    work.add(this.endTag("softpage"));
                    softpage = null;
                }
                if (this.remote.isSoftButton(b) && softpage == null) {
                    softpage = (keyCode - 49) / 6;
                    work.add(this.makeItem("softpage", new Hex(new short[]{(short)softpage.intValue()}), false));
                }
                if (softpage != null) {
                    keyCode -= 6 * softpage;
                }
                Hex btnHex = new Hex(new short[]{(short)keyCode});
                work.add(this.makeItem(btnTag, btnHex, false));
                if (ls != null) {
                    int len = ls.getData().length();
                    Hex hex = new Hex(len + 9);
                    hex.set((short)(len + 8), 0);
                    hex.put(ls.getHeader(), 1);
                    hex.set((short)len, 8);
                    System.arraycopy(ls.getData().getData(), 0, hex.getData(), 9, len);
                    work.add(this.makeItem("learnedkey", hex, false));
                    if (f != null && f.getName() != null && ls.getName() != null && !f.getName().equals(ls.getName())) {
                        work.add(this.makeItem("name8", new Hex(ls.getName(), 8), true));
                    } else {
                        name = f == null || f.getName() == null ? ls.getName() : f.getName();
                    }
                    work.add(this.endTag("learnedkey"));
                }
                if (f != null && f.getHex() != null) {
                    work.add(this.makeItem("keygid", this.getLittleEndian(f.getGid() == null ? 0 : f.getGid()), true));
                    work.add(this.makeItem("keyflags", new Hex(new short[]{(short)(f.getKeyflags() == null ? 0 : f.getKeyflags())}), true));
                    work.add(this.makeItem("irdata", f.getHex(), true));
                    String string = name = softName != null ? softName : f.getName();
                }
                if (gf.icon != null && gf.icon.ref > 0) {
                    work.add(this.makeItem("iconref", new Hex(new short[]{(short)gf.icon.ref}), true));
                }
                if (macro != null) {
                    work.add(this.makeItem("macroref", this.getLittleEndian(macro.getSerial()), true));
                    String string = macro.isSystemMacro() ? (softName != null ? softName : b.getName()) : (name = macro.getName());
                    if (f != null && f.icon != null && f.icon.ref > 0) {
                        work.add(this.makeItem("iconref", new Hex(new short[]{(short)f.icon.ref}), true));
                    }
                }
                if (name == null) {
                    System.err.println("Null name at " + db + " : " + b);
                } else {
                    work.add(this.makeItem("name8", new Hex(name, 8), true));
                }
                work.add(this.endTag(btnTag));
            }
            if (softpage != null) {
                work.add(this.endTag("softpage"));
            }
            ArrayList<Integer> fnkeys = new ArrayList<Integer>(upg.getFunctionMap().keySet());
            Collections.sort(fnkeys);
            Iterator iterator = fnkeys.iterator();
            while (iterator.hasNext()) {
                String name;
                int fnkey = (Integer)iterator.next();
                Function f = upg.getFunctionMap().get(fnkey);
                if (f == null || f.getHex() == null) continue;
                if (!irUsed) {
                    work.add(this.makeItem("irdefs", new Hex(0), false));
                    irUsed = true;
                }
                Hex btnHex = new Hex(new short[]{(short)(fnkey & 0xFF), (short)(fnkey >> 8)});
                work.add(this.makeItem("irdef", btnHex, false));
                work.add(this.makeItem("keygid", this.getLittleEndian(f.getGid() == null ? 0 : f.getGid()), true));
                work.add(this.makeItem("keyflags", new Hex(new short[]{(short)(f.getKeyflags() == null ? 0 : f.getKeyflags())}), true));
                work.add(this.makeItem("irdata", f.getHex(), true));
                if (f.icon != null && f.icon.ref > 0) {
                    work.add(this.makeItem("iconref", new Hex(new short[]{(short)f.icon.ref}), true));
                }
                if ((name = f.getName()) != null) {
                    work.add(this.makeItem("name8", new Hex(name, 8), true));
                }
                work.add(this.endTag("irdef"));
            }
            if (irUsed) {
                work.add(this.endTag("irdefs"));
                irUsed = false;
            }
            work.add(this.endTag("codeset"));
            work.add(this.endTag("device"));
        }
        work.add(this.endTag("devices"));
        if (this.tagList.size() == 1) {
            return null;
        }
        this.getTag("learnedkey");
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private SSDFile makeHomeXCF() {
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        work.add(this.makeItem("root", new Hex(0), false));
        work.add(this.makeItem("home", new Hex(0), false));
        String[] names = new String[]{"devices", "profiles", "favorites", "macros", "activities"};
        for (int i = 0; i < names.length; ++i) {
            String name;
            String fileName = (name = names[i]) + ".xcf";
            SSDFile file = this.ssdFiles.get(fileName);
            work.add(this.makeItem(name, file == null && (i == 1 || i == 2) ? new Hex(0) : new Hex(fileName, 8), true));
        }
        work.add(this.endTag("home"));
        work.add(this.endTag("root"));
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private SSDFile makeSystemXCF() {
        if (this.language == null || this.region == null) {
            return null;
        }
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        work.add(this.makeItem("system", new Hex(0), false));
        work.add(this.makeItem("language", new Hex(this.language.toLowerCase(), 8), false));
        work.add(this.makeItem("filename", new Hex(this.languageFilename, 8), true));
        work.add(this.endTag("language"));
        work.add(this.makeItem("region", new Hex(this.region.toLowerCase(), 8), false));
        work.add(this.makeItem("filename", new Hex(this.regionFilename.toLowerCase(), 8), true));
        work.add(this.endTag("region"));
        if (this.directv_rf != null) {
            work.add(this.makeItem("directv_rf", new Hex(this.directv_rf), true));
        }
        work.add(this.endTag("system"));
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private SSDFile makeProfilesXCF() {
        if (!this.remote.hasFavorites()) {
            return null;
        }
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        LinkedHashMap<Button, KeySpec> map = new LinkedHashMap<Button, KeySpec>();
        work.add(this.makeItem("profiles", new Hex("profiles.xcf", 8), false));
        for (Activity activity : this.remote.getFavKey().getProfiles()) {
            work.add(this.makeItem("profile", new Hex("" + new Hex(new short[]{(short)activity.getProfileIndex()}) + " " + new Hex(activity.getName(), 16)), false));
            if (activity.icon != null && activity.icon.ref > 0) {
                work.add(this.makeItem("iconref", new Hex(new short[]{(short)activity.icon.ref}), true));
            }
            work.add(this.makeItem("punchthrumap", new Hex(0), false));
            ActivityGroup[] groups = activity.getActivityGroups();
            for (ActivityGroup group : groups) {
                Macro macro = group.getTarget();
                DeviceButton db = group.getDevice();
                if (group.getButtonGroup().length == 1 && macro != null) {
                    Button source = group.getButtonGroup()[0];
                    db = macro.getDeviceButton(this);
                    Button target = this.remote.getButton(group.getTarget().getKeyCode());
                    map.put(source, new KeySpec(db, target));
                    continue;
                }
                if (db == null || db == DeviceButton.noButton) continue;
                for (Button source : group.getButtonGroup()) {
                    map.put(source, new KeySpec(db, source));
                }
            }
            Iterator<Short> iterator = this.remote.getActivityOrder().iterator();
            while (iterator.hasNext()) {
                KeySpec ks;
                short source = (Short)iterator.next();
                Button b = this.remote.getButton(source);
                if (b == null || (ks = (KeySpec)map.get(b)) == null) continue;
                short target = ks.btn.getKeyCode();
                short serial = (short)(ks.db.getButtonIndex() - 80);
                work.add(this.makeItem("punchthruspec", new Hex(new short[]{serial, target, source}), true));
            }
            work.add(this.endTag("punchthrumap"));
            work.add(this.endTag("profile"));
        }
        work.add(this.endTag("profiles"));
        if (this.tagList.size() == 1) {
            return null;
        }
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private SSDFile makeFavoritesXCF() {
        ActivityGroup[] groups;
        if (this.favScans.isEmpty() || this.remote.getFavKey() == null) {
            return null;
        }
        this.tagList = new ArrayList<String>();
        Activity activity = this.remote.getFavKey().getActivity();
        ArrayList<Hex> work = new ArrayList<Hex>();
        LinkedHashMap<Button, KeySpec> map = new LinkedHashMap<Button, KeySpec>();
        work.add(this.makeItem("favorites", new Hex("favorites.xcf", 8), false));
        work.add(this.makeItem("delay", new Hex(new short[]{(short)this.remote.getFavKey().getFavPause()}), true));
        for (FavScan favScan : this.favScans) {
            work.add(this.makeItem("favorite", new Hex("" + new Hex(new short[]{(short)favScan.getSerial()}) + " " + new Hex(favScan.getName(), 16)), false));
            if (favScan.getProfileIndices() != null) {
                for (int index : favScan.getProfileIndices()) {
                    work.add(this.makeItem("profileindex", new Hex(new short[]{(short)index}), true));
                }
            }
            work.add(this.makeItem("deviceid", new Hex(new short[]{(short)(favScan.getDeviceButton().getButtonIndex() - 80)}), true));
            if (favScan.icon != null && favScan.icon.ref > 0) {
                work.add(this.makeItem("iconref", new Hex(new short[]{(short)favScan.icon.ref}), true));
            }
            String channel = favScan.getChannel();
            short[] data = new short[]{0, 0, 0, 0};
            for (int i = 0; i < channel.length(); ++i) {
                int digit = channel.charAt(channel.length() - i - 1) & 0xF;
                if (digit == 14) {
                    digit = 10;
                }
                int n = i / 2;
                data[n] = (short)(data[n] | digit << (i % 2 << 2));
            }
            work.add(this.makeItem("channelnumber", new Hex(data), true));
            work.add(this.endTag("favorite"));
        }
        work.add(this.makeItem("punchthrumap", new Hex(0), false));
        for (ActivityGroup group : groups = activity.getActivityGroups()) {
            Macro macro = group.getTarget();
            DeviceButton db = group.getDevice();
            if (group.getButtonGroup().length == 1 && macro != null) {
                Button source = group.getButtonGroup()[0];
                db = macro.getDeviceButton(this);
                Button target = this.remote.getButton(group.getTarget().getKeyCode());
                map.put(source, new KeySpec(db, target));
                continue;
            }
            if (db == null || db == DeviceButton.noButton) continue;
            for (Button source : group.getButtonGroup()) {
                map.put(source, new KeySpec(db, source));
            }
        }
        for (short source : this.remote.getActivityOrder()) {
            KeySpec ks;
            Button b = this.remote.getButton(source);
            if (b == null || (ks = (KeySpec)map.get(b)) == null) continue;
            short serial = (short)(ks.db.getButtonIndex() - 80);
            short target = ks.btn.getKeyCode();
            work.add(this.makeItem("punchthruspec", new Hex(new short[]{serial, target, source}), true));
        }
        work.add(this.endTag("punchthrumap"));
        work.add(this.endTag("favorites"));
        SSDFile sSDFile = new SSDFile(this.tagList, work);
        this.tagList = null;
        return sSDFile;
    }

    private SSDFile makeActivitiesXCF() {
        this.tagList = new ArrayList<String>();
        ArrayList<Hex> work = new ArrayList<Hex>();
        LinkedHashMap<Object, KeySpec> map = new LinkedHashMap<Object, KeySpec>();
        work.add(this.makeItem("activities", new Hex("activities.xcf", 8), false));
        for (Activity activity : this.activities.values()) {
            DeviceButton db;
            Button btn = activity.getButton();
            if (activity == null || !activity.isActive()) continue;
            short serial = (short)(btn.getKeyCode() & 0xF);
            work.add(this.makeItem("activity", new Hex("" + new Hex(new short[]{serial}) + " " + new Hex(activity.getName(), 16)), false));
            if (activity.icon != null && activity.icon.ref > 0) {
                work.add(this.makeItem("iconref", new Hex(new short[]{(short)activity.icon.ref}), true));
            }
            work.add(this.makeItem("macroref", new Hex(new short[]{(short)activity.getMacro().getSerial(), 0}), true));
            work.add(this.makeItem("punchthrumap", new Hex(0), false));
            ActivityGroup[] groups = activity.getActivityGroups();
            for (ActivityGroup group : groups) {
                Macro macro = group.getTarget();
                db = group.getDevice();
                if (group.getButtonGroup().length == 1 && macro != null) {
                    Button[] source = group.getButtonGroup()[0];
                    db = macro.getDeviceButton(this);
                    Button target = this.remote.getButton(group.getTarget().getKeyCode());
                    map.put(source, new KeySpec(db, target));
                    continue;
                }
                if (db == null || db == DeviceButton.noButton) continue;
                for (Button source : group.getButtonGroup()) {
                    map.put(source, new KeySpec(db, source));
                }
            }
            Iterator<Short> iterator = this.remote.getActivityOrder().iterator();
            while (iterator.hasNext()) {
                KeySpec ks;
                short source = (Short)iterator.next();
                Button b = this.remote.getButton(source);
                if (b == null || (ks = (KeySpec)map.get(b)) == null || ks.db == null || ks.db == DeviceButton.noButton) continue;
                short target = ks.btn.getKeyCode();
                serial = (short)(ks.db.getButtonIndex() - 80);
                work.add(this.makeItem("punchthruspec", new Hex(new short[]{serial, target, source}), true));
            }
            int count = -1;
            short softIndex = -1;
            for (Button b : this.remote.getButtonGroups().get("Soft")) {
                String name;
                GeneralFunction f;
                GeneralFunction gf;
                KeySpec ks = (KeySpec)map.get(b);
                if (ks == null || ks.db == null || ks.db == DeviceButton.noButton) continue;
                db = ks.db;
                serial = (short)(db.getButtonIndex() - 80);
                if (++count % 6 == 0) {
                    if (count > 0) {
                        work.add(this.endTag("softpage"));
                    }
                    work.add(this.makeItem("softpage", new Hex(new short[]{softIndex = (short)((short)(softIndex + 1))}), false));
                }
                String softName = (gf = db.getGeneralFunction(b)) != null ? gf.getName() : null;
                int code = b.getKeyCode() - 6 * softIndex;
                work.add(this.makeItem("punchthruspec", new Hex(new short[]{serial, (short)code, (short)code}), false));
                DeviceUpgrade upg = db.getUpgrade();
                GeneralFunction generalFunction = f = upg != null ? upg.getGeneralFunction(b.getKeyCode(), false) : null;
                if (gf != null && gf.icon != null && gf.icon.ref > 0) {
                    work.add(this.makeItem("iconref", new Hex(new short[]{(short)gf.icon.ref}), true));
                }
                String string = softName != null ? softName : (name = f != null ? f.getName() : null);
                if (name != null) {
                    work.add(this.makeItem("name8", new Hex(name, 8), true));
                }
                work.add(this.endTag("punchthruspec"));
            }
            if (softIndex >= 0) {
                work.add(this.endTag("softpage"));
            }
            work.add(this.endTag("punchthrumap"));
            work.add(this.endTag("activity"));
        }
        work.add(this.endTag("activities"));
        if (this.tagList.size() == 1) {
            return null;
        }
        SSDFile file = new SSDFile(this.tagList, work);
        this.tagList = null;
        return file;
    }

    private Hex makeUserIconsPKG() {
        int i;
        Object image;
        ArrayList<Hex> work = new ArrayList<Hex>();
        ArrayList<Integer> refs = new ArrayList<Integer>(this.userIcons.keySet());
        LinkedHashMap<Integer, Boolean> transparencies = new LinkedHashMap<Integer, Boolean>();
        Collections.sort(refs);
        Iterator iterator = refs.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            GeneralFunction.RMIcon icon = this.userIcons.get(i2);
            image = (BufferedImage)icon.image.getImage();
            int width = ((BufferedImage)image).getWidth();
            int height = ((BufferedImage)image).getHeight();
            int size = width * height;
            Hex hex1 = new Hex(2 * size);
            Hex hex2 = new Hex(size);
            int pos = 0;
            boolean usesTransparency = false;
            for (int k = 0; k < height; ++k) {
                for (int j = 0; j < width; ++j) {
                    int rgb = ((BufferedImage)image).getRGB(j, k);
                    int alpha = rgb >> 24 & 0xFF;
                    if (alpha != 255) {
                        usesTransparency = true;
                    }
                    double rf = (double)(rgb >> 16 & 0xFF) / 255.0;
                    double gf = (double)(rgb >> 8 & 0xFF) / 255.0;
                    double bf = (double)(rgb & 0xFF) / 255.0;
                    int r = (int)(rf * 31.0 + 0.5);
                    int g = (int)(gf * 63.0 + 0.5);
                    int b = (int)(bf * 31.0 + 0.5);
                    int val = r << 11 | g << 5 | b;
                    hex1.set((short)(val & 0xFF), 2 * pos);
                    hex1.set((short)(val >> 8 & 0xFF), 2 * pos + 1);
                    hex2.set((short)alpha, pos++);
                }
            }
            work.add(hex1);
            transparencies.put(i2, usesTransparency);
            if (!usesTransparency) continue;
            work.add(hex2);
        }
        ArrayList<Hex> work2 = new ArrayList<Hex>();
        work2.add(new Hex(new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        int iconCount = refs.size();
        work2.add(this.getLittleEndian(iconCount));
        int indexSize = 127;
        image = refs.iterator();
        while (image.hasNext()) {
            int n = (Integer)image.next();
            indexSize = Math.max(indexSize, n + 1);
        }
        work2.add(this.getLittleEndian(indexSize));
        int pos = 16 + 28 * iconCount + indexSize;
        Iterator n = refs.iterator();
        while (n.hasNext()) {
            i = (Integer)n.next();
            GeneralFunction.RMIcon icon = this.userIcons.get(i);
            int excess = (Boolean)transparencies.get(i) != false ? 512 : 256;
            BufferedImage image2 = (BufferedImage)icon.image.getImage();
            int width = image2.getWidth();
            int height = image2.getHeight();
            int size = width * height;
            work2.add(icon.intro);
            work2.add(this.getLittleEndian(width));
            work2.add(this.getLittleEndian(height));
            work2.add(new Hex(new short[]{0, 0, 0, (short)icon.type}));
            work2.add(this.getLittleEndianWord(pos));
            pos += 2 * size;
            if (excess == 512) {
                work2.add(this.getLittleEndianWord(pos));
                pos += size;
            } else {
                work2.add(this.getLittleEndianWord(0));
            }
            work2.add(this.getLittleEndianWord(2 * size + excess));
        }
        int n2 = 1;
        for (i = 0; i < indexSize; ++i) {
            work2.add(new Hex(new short[]{(short)(refs.contains(i) ? n2++ : 0)}));
        }
        work.addAll(0, work2);
        SSDFile file = new SSDFile(null, work);
        return file.hex;
    }

    private Hex getLittleEndian(int n) {
        return new Hex(new short[]{(short)(n & 0xFF), (short)(n >> 8 & 0xFF)});
    }

    private Hex getLittleEndianWord(int n) {
        return new Hex(new short[]{(short)(n & 0xFF), (short)(n >> 8 & 0xFF), (short)(n >> 16 & 0xFF), (short)(n >> 24 & 0xFF)});
    }

    public int getNewMacroSerial() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Macro macro : this.macros) {
            list.add(macro.getSerial());
        }
        int serial = 1;
        while (list.contains(serial)) {
            ++serial;
        }
        return serial;
    }

    public void cleanMacros() {
        ListIterator<Macro> li = this.macros.listIterator();
        while (li.hasNext()) {
            Macro m = li.next();
            if (!m.isSystemMacro() || !m.getUsers().isEmpty()) continue;
            li.remove();
        }
    }

    public HashMap<KeySpec, List<Highlight>> getAllKeySpecs() {
        List<Activity> list;
        LinkedHashMap<KeySpec, List<Highlight>> ksm = new LinkedHashMap<KeySpec, List<Highlight>>();
        for (Macro m : this.getAllMacros(true)) {
            if (m.getItems() != null) {
                ListIterator<KeySpec> it = m.getItems().listIterator();
                while (it.hasNext()) {
                    KeySpec keySpec = it.next();
                    if (keySpec.db != null && keySpec.db.getUpgrade() != null) continue;
                    if (keySpec.db != null) {
                        String s = "Item \"" + keySpec.toString() + "\" deleted from macro " + m.getName() + " as device upgrade is missing";
                        System.err.println(s);
                    }
                    it.remove();
                }
                for (KeySpec keySpec : m.getItems()) {
                    ArrayList<Macro> list2 = (ArrayList<Macro>)((HashMap)ksm).get(keySpec);
                    if (list2 == null) {
                        list2 = new ArrayList<Macro>();
                        ksm.put(keySpec, list2);
                    }
                    list2.add(m);
                }
            }
            if (m.getAssists() == null) continue;
            for (List list2 : m.getAssists().values()) {
                for (Activity.Assister as : list2) {
                    list = (ArrayList<Macro>)((HashMap)ksm).get(as.ks);
                    if (list == null) {
                        list = new ArrayList<Macro>();
                        ksm.put(as.ks, list);
                    }
                    list.add((Activity)((Object)m));
                }
            }
        }
        if (this.activities != null) {
            for (Activity a : this.activities.values()) {
                if (!a.isActive() || a.getAssists() == null) continue;
                for (List list3 : a.getAssists().values()) {
                    for (Activity.Assister as : list3) {
                        list = (List)((HashMap)ksm).get(as.ks);
                        if (list == null) {
                            list = new ArrayList();
                            ksm.put(as.ks, list);
                        }
                        list.add(a);
                    }
                }
            }
        }
        return ksm;
    }

    public void swapFunctions(DeviceUpgrade du) {
        LinkedHashMap<Function, Function> map = null;
        map = du.getSwapList();
        if (map == null) {
            return;
        }
        for (int key : du.getFunctionMap().keySet()) {
            Function f = map.get(du.getFunctionMap().get(key));
            if (f == null) continue;
            du.getFunctionMap().put(key, f);
        }
        Function f = null;
        for (KeySpec ks : this.getAllKeySpecs().keySet()) {
            if (ks.fn != null && !(ks.fn instanceof Function) || ks.fn == null || !(ks.fn instanceof Function) || (f = map.get((Function)ks.fn)) == null) continue;
            ks.fn = f;
        }
    }

    public void updateKeyAssignments() {
        if (this.remote.getKeyButtonGroups() == null) {
            return;
        }
        for (Remote.KeyButtonGroup kbg : this.remote.getKeyButtonGroups()) {
            Setting keySetting = this.remote.getSetting(kbg.name + " key");
            Setting keyAssign = this.remote.getSetting(kbg.name + " assign");
            if (keySetting == null) continue;
            int ndx = keyAssign == null || keyAssign.getValue() == 1 ? keySetting.getValue() : 0;
            Button newButton = kbg.buttons.get(ndx);
            if (this.remote.hasActivityAlgorithm()) {
                short[] devData;
                DeviceButton db;
                int devTypeIndex;
                DeviceType type;
                ButtonMap map;
                Activity activity = this.activities.get(null);
                ActivityGroup group = null;
                for (ActivityGroup temp : activity.getActivityGroups()) {
                    if (!Arrays.asList(temp.getButtonGroup()).contains(newButton)) continue;
                    group = temp;
                    break;
                }
                if (!(map = (type = this.remote.getDeviceTypeByIndex(devTypeIndex = (db = group.getDevice()).getDeviceTypeIndex(devData = db.getSegment().getHex().getData()))).getButtonMap()).isPresent(newButton)) {
                    for (Button b : kbg.buttons) {
                        if (!map.isPresent(b)) continue;
                        newButton = b;
                        break;
                    }
                }
            }
            kbg.setButtonShape();
            ButtonShape shape = kbg.shape;
            ButtonShape oldPhantomShape = null;
            ButtonShape newPhantomShape = null;
            if (shape == null || shape.getButton() == newButton) continue;
            for (ButtonShape bs : this.remote.getPhantomShapes()) {
                if (bs.getButton() == newButton) {
                    newPhantomShape = bs;
                    continue;
                }
                if ((bs.getButton().getKeyCode() & 0xC0) != 0) continue;
                oldPhantomShape = bs;
            }
            if (newPhantomShape == null) continue;
            if (oldPhantomShape != null) {
                newPhantomShape.setButton(oldPhantomShape.getButton());
                oldPhantomShape.setButton(shape.getButton());
            } else {
                newPhantomShape.setButton(shape.getButton());
            }
            shape.setButton(newButton);
        }
    }

    public List<Integer> getSegmentLoadOrder() {
        return this.segmentLoadOrder;
    }

    public String getInterfaceType() {
        String temp = this.remote.getInterfaceType();
        if (!temp.equals("JP2") || this.sigData == null || this.sigData.length < 32 || Hex.get(this.sigData, 2) == 0) {
            return temp;
        }
        int firstEnd = Hex.get(this.sigData, 28);
        int secondStart = Hex.get(this.sigData, 30);
        return secondStart == firstEnd + 1 ? "JP2" : "JP2.1";
    }

    private void setNibSizes() {
        if (!this.remote.hasRf4ceSupport() || this.remote.getRfSetupCodes() == null) {
            return;
        }
        this.nibSizes = new LinkedHashMap();
        int rfCodeCount = this.remote.getRfSetupCodes().size();
        block5: for (String[] ns : nibSizeData) {
            int nvid = Integer.parseInt(ns[0], 16);
            int size = Integer.parseInt(ns[1], 10);
            switch (nvid) {
                case 36: {
                    int i;
                    for (i = 0; i < rfCodeCount; ++i) {
                        this.nibSizes.put(36 + i, size);
                    }
                    continue block5;
                }
                case 37: {
                    int i;
                    for (i = 0; i < rfCodeCount; ++i) {
                        this.nibSizes.put(36 + rfCodeCount + i, size);
                    }
                    continue block5;
                }
                case 38: {
                    this.nibSizes.put(36 + 2 * rfCodeCount, rfCodeCount);
                    continue block5;
                }
                default: {
                    this.nibSizes.put(nvid, size);
                }
            }
        }
    }

    public void exportToGirrFile() {
        String source = this.owner.file != null ? this.owner.file.getAbsolutePath() : this.remote.getName();
        RemoteSet fullSet = new RemoteSet(System.getProperty("user.name"), source, new Date().toString(), RemoteMaster.class.getSimpleName(), RemoteMaster.getFullVersion(), null, null);
        ArrayList<String> exports = new ArrayList<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        int exported = 0;
        int failed = 0;
        for (DeviceUpgrade upgrade : this.devices) {
            DeviceUpgradeExporter exporter;
            RemoteSet rSet;
            if (upgrade.getProtocol() == null || upgrade.getProtocol() instanceof ManualProtocol || (rSet = (exporter = new DeviceUpgradeExporter(upgrade)).getRemoteSet()) == null) continue;
            String description = rSet.iterator().next().getName();
            if (!exports.contains(description)) {
                fullSet.append(rSet);
                exports.add(description);
                ++exported;
                continue;
            }
            if (!duplicates.contains(description)) {
                duplicates.add(description);
                ++failed;
                continue;
            }
            ++failed;
        }
        File file = DeviceUpgradeExporter.getFileToSave(true);
        if (file != null) {
            DeviceUpgradeExporter.exportGirrFile(fullSet, file);
            String title = "Export of remote as Girr file";
            String message = "" + exported + " upgrades from remote " + this.remote.getName() + " have been exported to Girr file\n" + file.getAbsolutePath();
            if (failed > 0) {
                message = message + "\n\nA further " + failed + " upgrades were not included due to the\nfollowing duplicate descriptions:";
                for (String desc : duplicates) {
                    message = message + "\n  " + desc;
                }
            }
            JOptionPane.showMessageDialog(this.owner, message, title, 1);
        }
    }

    public NoSetup getNoSetup() {
        if (this.savedNoSetup == null) {
            this.noSetup = new NoSetup(this.remote.getSignature());
            this.savedNoSetup = new NoSetup(this.remote.getSignature());
        }
        if (this.savedNoSetup.getProcessor() == null) {
            return null;
        }
        return this.noSetup;
    }

    public List<Integer> getGidList() {
        return this.gidList;
    }

    public HashMap<String, List<Integer>> getGidRegister() {
        return this.gidRegister;
    }

    static /* synthetic */ Remote access$200(RemoteConfiguration x0) {
        return x0.remote;
    }

    public static class KeySpec {
        DeviceButton db = null;
        Button btn = null;
        GeneralFunction fn = null;
        int btnState = 0;
        int irSerial = -1;
        int duration = -1;
        int delay = 0;
        int codeSize = 1;
        boolean isEZRC = true;
        public static Remote remote = null;

        public KeySpec() {
        }

        public KeySpec(DeviceButton db, Button btn) {
            this.db = db;
            this.btn = btn;
        }

        public KeySpec(DeviceButton db, GeneralFunction fn) {
            this.db = db;
            this.fn = fn;
        }

        public KeySpec(DeviceButton db, int irSerial) {
            this.db = db;
            this.irSerial = irSerial;
        }

        public Button getButton() {
            if (this.fn == null) {
                return this.btn;
            }
            if (!(this.fn instanceof Function) && !(this.fn instanceof LearnedSignal)) {
                DeviceUpgrade du = this.db.getUpgrade();
                for (int keyCode : du.getSelectorMap().keySet()) {
                    if (du.getSelectorMap().get(keyCode) != this.fn) continue;
                    return du.getRemote().getButton(keyCode);
                }
            } else {
                for (GeneralFunction.User u : this.fn.getUsers()) {
                    if (u.db != this.db || u.button == null || !(this.fn instanceof LearnedSignal) && this.db.getUpgrade().getLearnedMap().get(u.button.getKeyCode()) != null) continue;
                    return u.button;
                }
            }
            return null;
        }

        public GeneralFunction getGeneralFunction() {
            DeviceUpgrade du;
            if (this.fn != null) {
                return this.fn;
            }
            if (this.btn != null && (du = this.db.getUpgrade()) != null) {
                return du.getAssignments().getAssignment(this.btn);
            }
            return null;
        }

        public boolean isValid() {
            if (this.fn == null && this.btn != null && this.db != null && this.db.getUpgrade() == null) {
                return true;
            }
            if (this.fn == null && this.btn == null) {
                return false;
            }
            if (this.btn != null) {
                return true;
            }
            if (this.db != null && this.db.getUpgrade() != null) {
                int serial = this.fn.getSerial();
                Remote remote = this.db.getUpgrade().getRemote();
                if (this.getButton() == null && serial < 0 || !remote.isSSD() && serial >= remote.getSystemButtons().size()) {
                    return false;
                }
            }
            return true;
        }

        public boolean isEZRC() {
            return this.isEZRC;
        }

        public void setEZRC(boolean isEZRC) {
            this.isEZRC = isEZRC;
        }

        public int getCodeSize() {
            return this.codeSize;
        }

        public void setCodeSize(int codeSize) {
            this.codeSize = codeSize;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.isEZRC) {
                buff.append(this.db.getName() + ";");
            }
            if (this.duration >= 0) {
                double value = this.isEZRC || this.codeSize == 2 ? (double)this.duration * 0.1 : Macro.valueLowToHold(this.duration);
                String format = this.isEZRC || this.codeSize == 2 ? "Hold(%3.1f);" : "Hold(%4.2f);";
                buff.append(String.format(format, value));
            }
            if (this.btn != null && this.db != null && this.db.getUpgrade() != null) {
                int index = -1;
                GeneralFunction gf = null;
                if (remote.getSystemButtons() != null && (index = remote.getSystemButtons().indexOf(this.btn)) >= 0) {
                    gf = this.db.getUpgrade().getFunctionMap().get(index);
                }
                if (gf == null) {
                    gf = this.db.getUpgrade().getGeneralFunction(this.btn.getKeyCode(), true);
                }
                if (gf != null) {
                    buff.append(gf.getDisplayName(remote));
                } else {
                    buff.append(this.btn.getName(this.btnState));
                }
            } else if (this.btn != null) {
                buff.append(this.btn.getName(this.btnState));
            } else if (this.fn != null) {
                buff.append(this.fn);
            }
            if (this.delay != 0) {
                buff.append("(" + this.delay / 10 + "." + this.delay % 10 + ")");
            }
            return buff.toString();
        }
    }

    private class Items {
        DeviceButton db = null;
        List<DeviceButton> dbList = new ArrayList<DeviceButton>();
        DeviceUpgrade upgrade = null;
        Hex fixedData = null;
        Hex pCode = null;
        Hex pid = null;
        int setupCode = 0;
        String alias = null;
        List<Key> keys = null;
        Key key = null;
        int missingIndex = 0;
        Macro macro = null;
        Activity activity = null;
        List<Activity> activities = new ArrayList<Activity>();
        List<Activity.Assister> assisters = null;
        LinkedHashMap<Button, KeySpec> map = null;
        LinkedHashMap<Integer, Macro> macroMap = new LinkedHashMap();
        LinkedHashMap<GeneralFunction, Integer> iconrefMap = new LinkedHashMap();
        Integer softPageIndex = null;
        FavScan fav = null;
        String lastTag = null;
        int category = 0;
        int brandIndex = 0;
        int codeset_base = -1;
        short[] irdb = null;
        List<Integer> codes = null;
        List<Macro> unreferencedMacros = new ArrayList<Macro>();

        private Items() {
        }
    }

    public class SSDFile {
        int index = -1;
        List<String> tagNames = null;
        Hex hex = null;
        Hex prefix = null;

        public SSDFile() {
        }

        public SSDFile(List<String> tagNames, List<Hex> sectors) {
            int len = 0;
            for (Hex hex : sectors) {
                len += hex.length();
            }
            short[] data = new short[len];
            len = 0;
            for (Hex hex : sectors) {
                System.arraycopy(hex.getData(), 0, data, len, hex.length());
                len += hex.length();
            }
            this.tagNames = tagNames;
            this.hex = new Hex(data);
            this.prefix = new Hex("ezrc    ", 8);
        }
    }

    public class SSDFileInfo {
        int index = -1;
        int fileStart = 0;
        int xcfStart = 0;
        int fileEnd = 0;

        public String toString() {
            return this.index >= 0 ? Remote.userFilenames[this.index].toLowerCase() : null;
        }
    }

    private class Key {
        Button btn = null;
        int keycode = 0;
        int irserial = -1;
        Integer keyflags = 0;
        Integer keygid = null;
        Hex irdata = null;
        LearnedSignal ls = null;
        String bname = null;
        String lname = null;
        Integer iconref = null;
        Integer macroref = null;
        boolean inLS = false;

        private Key() {
        }
    }

    public static enum ShareType {
        UNSHARED,
        SHARED,
        SHAREABLE;

    }

    private class updateLocator {
        private int activeRegion = 0;
        private int tableSize = 0;
        private boolean full = false;
        private boolean oldOverflow = false;
        private AddressRange upgRange = RemoteConfiguration.access$200(RemoteConfiguration.this).getUpgradeAddress();
        private AddressRange advRange = RemoteConfiguration.access$200(RemoteConfiguration.this).getAdvancedCodeAddress();
        private AddressRange lrnRange = RemoteConfiguration.access$200(RemoteConfiguration.this).getLearnedAddress();

        public updateLocator(int tableSize) {
            this.tableSize = tableSize;
            this.upgRange.setFreeStart(this.upgRange.getStart() + 4);
            if (this.lrnRange != null) {
                this.oldOverflow |= this.lrnRange.getFreeEnd() < this.lrnRange.getEnd();
                this.lrnRange.setFreeEnd(this.lrnRange.getEnd());
            }
            if (this.advRange != null) {
                this.oldOverflow |= this.advRange.getFreeEnd() < this.advRange.getEnd();
                this.advRange.setFreeEnd(this.advRange.getEnd());
            }
        }

        public int nextOffset(int length) {
            int start;
            int end = this.upgRange.getFreeStart() + length;
            if (end + this.tableSize <= this.upgRange.getEnd() + 1) {
                this.full = false;
                this.upgRange.setFreeStart(end);
                return end - length;
            }
            if (this.lrnRange != null) {
                this.activeRegion = 1;
            } else if (this.advRange != null) {
                this.activeRegion = 2;
            } else {
                this.full = true;
                this.upgRange.setFreeStart(end);
                return end - length;
            }
            if (this.activeRegion == 1) {
                start = this.lrnRange.getFreeEnd() - length + 1;
                if (start >= this.lrnRange.getFreeStart()) {
                    this.full = false;
                    this.lrnRange.setFreeEnd(start - 1);
                    return start;
                }
                if (this.advRange != null) {
                    this.activeRegion = 2;
                } else {
                    this.full = true;
                    this.lrnRange.setFreeEnd(start - 1);
                    return start;
                }
            }
            if (this.activeRegion == 2) {
                start = this.advRange.getFreeEnd() - length + 1;
                this.full = start < this.advRange.getFreeStart();
                this.advRange.setFreeEnd(start - 1);
                return start;
            }
            return 0;
        }

        public boolean isFull() {
            return this.full;
        }

        public boolean newOverflow() {
            return this.activeRegion > 0 && !this.oldOverflow;
        }
    }
}

