/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ChoiceArea;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.RMDirectoryChooser;
import com.hifiremote.jp1.RMNewDialog;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class RemoteManager {
    private static RemoteManager remoteManager = new RemoteManager();
    private TreeMap<String, Remote> remotes = new TreeMap();
    private HashMap<String, List<Remote>> remotesBySignature = new HashMap();
    private HashMap<String, Remote> remotesByRDF = new HashMap();
    private File loadPath = null;
    private Hashtable<String, String> oldRemoteNames = null;
    private boolean filesSet = false;

    protected RemoteManager() {
    }

    protected File initPath(PropertyFile properties, String propName, String defaultName, String extension, String type) {
        File path = properties.getFileProperty(propName);
        if (path == null) {
            path = new File(RemoteMaster.getWorkDir(), defaultName);
        }
        while (!path.exists() || !path.isDirectory()) {
            path = path.getParentFile();
        }
        File[] files = new File[]{};
        File dir = path;
        ExtensionFilter filter = new ExtensionFilter(extension);
        while (files.length == 0) {
            files = dir.listFiles(filter);
            if (files.length == 0) {
                this.filesSet = true;
                JOptionPane.showMessageDialog(null, "No " + type + " files were found!", "Error", 0);
                RMDirectoryChooser chooser = new RMDirectoryChooser(dir, extension, type);
                ChoiceArea area = new ChoiceArea(chooser);
                chooser.setAccessory(area);
                chooser.setDialogTitle("Choose the directory containing the " + type + " files");
                int returnVal = chooser.showDialog(null, "OK");
                chooser.removePropertyChangeListener(area);
                if (returnVal != 0) {
                    return properties.getFileProperty(propName);
                }
                dir = chooser.getSelectedFile();
                chooser.getDialog().dispose();
            }
            path = dir;
        }
        properties.setProperty(propName, path);
        return path;
    }

    public void loadRemotes(PropertyFile properties) {
        if (this.loadPath != null) {
            return;
        }
        this.initPath(properties, "ImagePath", "Images", ".map", "Map");
        this.loadPath = this.initPath(properties, "RDFPath", "RDF", ".rdf", "RDF");
        if (this.loadPath == null) {
            return;
        }
        if (this.filesSet) {
            try {
                properties.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File[] files = this.loadPath.listFiles(new ExtensionFilter(".rdf"));
        for (int i = 0; i < files.length; ++i) {
            File rdf = files[i];
            Remote r = new Remote(rdf);
            this.remotesByRDF.put(rdf.getName(), r);
            this.addRemote(r);
        }
    }

    private void addRemote(Remote remote) {
        List<Remote> list = this.remotesBySignature.get(remote.getSignature());
        if (list == null) {
            list = new ArrayList<Remote>();
            this.remotesBySignature.put(remote.getSignature(), list);
        }
        for (int j = 0; j < remote.getNameCount(); ++j) {
            Remote dupRemote = new Remote(remote, j);
            if (dupRemote.getName().equals(remote.getName())) {
                this.remotes.put(remote.getName(), remote);
                list.add(remote);
                continue;
            }
            this.remotes.put(dupRemote.getName(), dupRemote);
            list.add(dupRemote);
        }
    }

    public void replaceRemote(Remote oldRemote, Remote newRemote) {
        List<Remote> list = this.remotesBySignature.get(oldRemote.getSignature());
        if (list != null) {
            for (int j = 0; j < oldRemote.getNameCount(); ++j) {
                String name = new Remote(oldRemote, j).getName();
                Remote remote = this.remotes.get(name);
                if (remote == null) continue;
                list.remove(remote);
            }
        }
        this.addRemote(newRemote);
    }

    public Collection<Remote> getRemotes() {
        return this.remotes.values();
    }

    public static RemoteManager getRemoteManager() {
        return remoteManager;
    }

    public JComboBox<Remote> getRemotesBox(Remote remote, int sort) {
        ArrayList<Remote> remotesList = new ArrayList<Remote>();
        DefaultListCellRenderer renderer = null;
        if (remote == null) {
            remotesList.addAll(this.getRemotes());
        } else {
            remotesList.add(remote);
        }
        if (sort == 0) {
            Collections.sort(remotesList);
            renderer = RMNewDialog.DESCRIPTION;
        } else {
            Collections.sort(remotesList, RMNewDialog.BY_SIGNATURE);
            renderer = RMNewDialog.SIGNATURE;
        }
        JComboBox<Remote> box = new JComboBox<Remote>(remotesList.toArray(new Remote[0]));
        box.setRenderer(renderer);
        return box;
    }

    public Remote findRemoteByName(String name) {
        System.err.println("Searching for remote with name " + name);
        if (name == null) {
            return null;
        }
        Remote remote = this.remotes.get(name = name.trim().replaceAll("\\s+", " "));
        if (remote == null && name.startsWith("Radio Shack")) {
            remote = this.remotes.get("RS" + name.substring(11));
        }
        if (remote == null) {
            remote = this.findRemoteByOldName(name);
            if (remote != null) {
                return remote;
            }
            String[] subNames = new String[]{};
            int slash = name.indexOf(47);
            if (slash != -1) {
                int count = 2;
                while ((slash = name.indexOf(47, slash + 1)) != -1) {
                    ++count;
                }
                subNames = new String[count];
                StringTokenizer nameTokenizer = new StringTokenizer(name, " /");
                for (int i = 0; i < count; ++i) {
                    subNames[i] = nameTokenizer.nextToken().trim();
                }
            } else {
                subNames = new String[1];
                StringTokenizer nameTokenizer = new StringTokenizer(name);
                subNames[0] = nameTokenizer.nextToken().trim();
            }
            int mostMatches = 0;
            ArrayList<Remote> similarRemotes = new ArrayList<Remote>();
            for (Remote r : this.remotes.values()) {
                int numMatches = 0;
                for (int j = 0; j < subNames.length; ++j) {
                    if (r.getName().indexOf(subNames[j]) == -1) continue;
                    System.err.println("Remote '" + r.getName() + "' matches subName '" + subNames[j] + "'");
                    ++numMatches;
                }
                if (numMatches > mostMatches) {
                    mostMatches = numMatches;
                    similarRemotes.clear();
                }
                if (numMatches != mostMatches) continue;
                similarRemotes.add(r);
            }
            Object[] simRemotes = new Remote[]{};
            if (similarRemotes.size() == 0) {
                simRemotes = this.remotes.values().toArray(simRemotes);
            } else if (similarRemotes.size() == 1) {
                remote = (Remote)similarRemotes.get(0);
            } else {
                simRemotes = similarRemotes.toArray(simRemotes);
            }
            if (remote == null) {
                String message = "The upgrade file you are loading is for the remote \"" + name + "\".\nThere is no remote with that exact name.  Please choose the best match from the list below:";
                Remote rc = (Remote)JOptionPane.showInputDialog(null, message, "Unknown Remote", 0, null, simRemotes, simRemotes[0]);
                if (rc == null) {
                    return remote;
                }
                remote = rc;
            }
        }
        remote.load();
        return remote;
    }

    public void loadOldRemoteNames() {
        try {
            File file = new File(this.loadPath, "OldRemoteNames.ini");
            if (file.exists()) {
                this.oldRemoteNames = new Hashtable();
                BufferedReader rdr = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    int equals;
                    char ch;
                    if (line.length() == 0 || (ch = line.charAt(0)) == '#' || ch == '!' || (equals = line.indexOf(61)) == -1) continue;
                    String oldName = line.substring(0, equals);
                    String newName = line.substring(equals + 1);
                    this.oldRemoteNames.put(oldName.trim().replaceAll("\\s+", " "), newName.trim().replaceAll("\\s+", " "));
                }
                rdr.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public Remote findRemoteByOldName(String oldName) {
        if (this.oldRemoteNames == null) {
            this.loadOldRemoteNames();
        }
        if (this.oldRemoteNames == null) {
            return null;
        }
        String newName = this.oldRemoteNames.get(oldName.trim().replaceAll("\\s+", " "));
        if (newName == null) {
            return null;
        }
        return this.remotes.get(newName);
    }

    public List<Remote> findRemoteBySignature(String signature) {
        ArrayList<Remote> rc = new ArrayList<Remote>();
        List<Remote> list = this.remotesBySignature.get(signature);
        if (list != null) {
            rc.addAll(list);
        }
        return rc;
    }

    public Remote findRemoteByRDF(String rdfName) {
        return this.remotesByRDF.get(rdfName);
    }

    public void reset() {
        this.remotes.clear();
        this.remotesBySignature.clear();
        this.loadPath = null;
        this.oldRemoteNames = null;
    }

    public boolean isFilesSet() {
        return this.filesSet;
    }

    protected class ExtensionFilter
    implements FilenameFilter {
        private String match;

        public ExtensionFilter(String match) {
            this.match = match;
        }

        public void setExtension(String extension) {
            this.match = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            int dot = name.lastIndexOf(46);
            if (dot < 0) {
                return false;
            }
            return name.substring(dot).toLowerCase().equals(this.match);
        }
    }
}

