/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.hifiremote.LibraryLoader;
import com.hifiremote.jp1.DigitMaps;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMProtocolBuilder;
import com.hifiremote.jp1.RemoteManager;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.security.CodeSource;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RemoteMaster {
    private static File workDir = null;
    private static PropertyFile properties = null;
    private static File errorsFile = null;
    private static JCommander argumentParser;
    private static File addonDir;
    private static String irpTransmogrifierCommitId;
    private static String girrCommitId;
    private static File rmirSys;
    private static File rmduSys;
    private static File rmpbSys;
    public static JP1Frame frame;
    public static boolean admin;
    public static boolean useCommHIDB;
    public static boolean useCommHIDBDefault;
    public static Color defaultPBForegroundColor;
    public static final String[] upgradeEndings;
    public static final String[] upgradeImportEndings;
    public static final String[] setupExtractEndings;
    public static final String[] protocolEndings;
    public static final String[] girrEndings;
    public static final String[] ictEndings;
    public static final CommandLineArgs commandLineArgs;
    public static final String version = "3.2";
    public static final String buildSeparator = ".";
    public static final int buildVer = 3;

    public static boolean hasEnding(String filename, String[] ... endings) {
        String[][] stringArray = endings;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] ends;
            for (String ending : ends = stringArray[i]) {
                if (!filename.toLowerCase().endsWith(ending)) continue;
                return true;
            }
        }
        return false;
    }

    public static File getAddonDir() {
        return addonDir;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public static String getGirrCommitId() {
        String girrId = "ccadf6318dec74bd1c3ffebd323fab0a40fe1cdb";
        if (girrCommitId == null) {
            girrCommitId = girrId != null && girrId.length() > 7 ? girrId.substring(0, 7) : "<unknown>";
        }
        return girrCommitId;
    }

    public static String getIrpTransmogrifierCommitId() {
        if (irpTransmogrifierCommitId == null) {
            irpTransmogrifierCommitId = "5d47234259a37ad45b2f16cb979c3a92b5bace1c" != null && "5d47234259a37ad45b2f16cb979c3a92b5bace1c".length() > 7 ? "5d47234259a37ad45b2f16cb979c3a92b5bace1c".substring(0, 7) : "<unknown>";
        }
        return irpTransmogrifierCommitId;
    }

    public static JP1Frame getFrame() {
        return frame;
    }

    public static String getFullVersion() {
        String version = RemoteMaster.getDisplayVersion().replaceAll("\\s", "");
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        return version;
    }

    public static String getDisplayVersion() {
        return "v3.2.3";
    }

    public static File getErrorsFile() {
        return errorsFile;
    }

    public static File getJarContainingFolder(Class<?> aclass) throws Exception {
        File jarFile;
        CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = aclass.getResource(aclass.getSimpleName() + ".class").getPath();
            String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
            jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            jarFile = new File(jarFilePath);
        }
        return jarFile.getParentFile();
    }

    public static File getWritableFile(File workDir, String fileName) {
        File dir = workDir;
        File file = new File(dir, fileName);
        boolean canWrite = true;
        if (!file.exists()) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                pw.println("Write Test");
                pw.flush();
                pw.close();
                file.delete();
            }
            catch (IOException ioe) {
                canWrite = false;
            }
        } else {
            canWrite = file.canWrite();
        }
        if (!canWrite) {
            String baseFolderName = null;
            if (System.getProperty("os.name").startsWith("Windows") && Float.parseFloat(System.getProperty("os.version")) >= 6.0f) {
                baseFolderName = System.getenv("APPDATA");
            }
            if (baseFolderName == null || "".equals(baseFolderName)) {
                baseFolderName = System.getProperty("user.home");
            }
            if (!(dir = new File(baseFolderName, "RemoteMaster")).exists() && !(dir = new File(baseFolderName, ".RemoteMaster")).exists()) {
                dir.mkdirs();
            }
            file = new File(dir, fileName);
        }
        return file;
    }

    public static void main(String[] args) {
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setAllowAbbreviatedOptions(true);
        argumentParser.setProgramName("java -jar RemoteMaster.jar");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            return;
        }
        if (commandLineArgs.helpRequested) {
            argumentParser.usage();
            return;
        }
        if (commandLineArgs.versionRequested) {
            System.out.println(RemoteMaster.getFullVersion());
            return;
        }
        if (commandLineArgs.testInstallationReadOnly) {
            System.out.println("Installation folder is read-only: " + RemoteMaster.testReadOnly());
            return;
        }
        try {
            workDir = commandLineArgs.homeDir != null ? commandLineArgs.homeDir : RemoteMaster.getJarContainingFolder(RemoteMaster.class);
        }
        catch (Exception e) {
            System.err.println("Fatal error: Unable to find jar file containing RemoteMaster.class");
            return;
        }
        rmirSys = new File(workDir, "RMIR.sys");
        rmduSys = new File(workDir, "RMDU.sys");
        rmpbSys = new File(workDir, "RMPB.sys");
        errorsFile = RemoteMaster.commandLineArgs.errorsFile;
        if (errorsFile == null) {
            errorsFile = RemoteMaster.getWritableFile(workDir, "rmaster.err");
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream(errorsFile)));
            if (RemoteMaster.commandLineArgs.propertiesFile == null) {
                RemoteMaster.commandLineArgs.propertiesFile = RemoteMaster.getWritableFile(workDir, "RemoteMaster.properties");
            }
            properties = new PropertyFile(RemoteMaster.commandLineArgs.propertiesFile);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (commandLineArgs.scaling != null) {
            System.setProperty("sun.java2d.uiScale", commandLineArgs.scaling);
        }
        if (RemoteMaster.commandLineArgs.admin) {
            admin = true;
        }
        RemoteMaster.commandLineArgs.launchRMIR = !RemoteMaster.commandLineArgs.launchRMDU && !RemoteMaster.commandLineArgs.launchRMPB;
        try {
            String hidInterface;
            File fileToOpen = null;
            if (RemoteMaster.commandLineArgs.fileName != null) {
                fileToOpen = new File(RemoteMaster.commandLineArgs.fileName).getCanonicalFile();
                if (RemoteMaster.hasEnding(RemoteMaster.commandLineArgs.fileName, upgradeEndings, upgradeImportEndings)) {
                    if (RemoteMaster.commandLineArgs.launchRMIR || RemoteMaster.commandLineArgs.launchRMPB) {
                        System.err.println("Starting RM due to ending of the argument file \"" + RemoteMaster.commandLineArgs.fileName + '\"');
                        RemoteMaster.commandLineArgs.launchRMIR = false;
                        RemoteMaster.commandLineArgs.launchRMPB = false;
                        RemoteMaster.commandLineArgs.launchRMDU = true;
                    }
                } else if (RemoteMaster.hasEnding(RemoteMaster.commandLineArgs.fileName, new String[][]{protocolEndings}) && (RemoteMaster.commandLineArgs.launchRMIR || RemoteMaster.commandLineArgs.launchRMDU)) {
                    System.err.println("Starting RMPB due to ending of the argument file \"" + RemoteMaster.commandLineArgs.fileName + '\"');
                    RemoteMaster.commandLineArgs.launchRMIR = false;
                    RemoteMaster.commandLineArgs.launchRMDU = false;
                    RemoteMaster.commandLineArgs.launchRMPB = true;
                }
            }
            System.err.println("RMIR " + RemoteMaster.getDisplayVersion());
            if (commandLineArgs.scaling != null) {
                System.err.println("Scaling has been set to " + commandLineArgs.scaling + " but please note that scaling ");
                System.err.println("is supported only in Java versions 11 or greater");
            }
            System.err.println("Installation folder is " + (RemoteMaster.testReadOnly() ? "" : "not ") + "read-only");
            System.err.println("Incorporates Girr v2.2.14");
            System.err.println("Girr Commit Id: " + RemoteMaster.getGirrCommitId());
            System.err.println("Incorporates IrpTransmogrifier v1.2.14");
            System.err.println("IrpTransmogrifier Commit Id: " + RemoteMaster.getIrpTransmogrifierCommitId());
            String libFolder = LibraryLoader.getLibraryFolderName();
            useCommHIDB = libFolder.equals("Mac OS X-i386") ? false : (libFolder.equals("Linux-arm") ? true : ((hidInterface = properties.getProperty("HIDInterface")) == null ? useCommHIDBDefault : hidInterface.equals("hid4java")));
            String[] propertyNames = new String[]{"java.version", "sun.java2d.uiScale", "java.vendor", "os.name", "os.arch", "java.home", "java.class.path"};
            System.err.println("System Properties:");
            for (String name : propertyNames) {
                if (name.equals("java.class.path") && !admin) continue;
                System.err.println("   " + name + " = " + System.getProperty(name));
            }
            System.err.println();
            String lookAndFeel = properties.getProperty("LookAndFeel", UIManager.getSystemLookAndFeelClassName());
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                JP1TableModel.normalBGColor = UIManager.getColor("Table.background");
                JP1TableModel.normalFGColor = UIManager.getColor("Table.foreground");
                defaultPBForegroundColor = UIManager.getColor("ProgressBar.foreground");
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            addonDir = properties.getFileProperty("AddonPath", new File(workDir, "AddOns"));
            RemoteManager.getRemoteManager().loadRemotes(properties);
            ProtocolManager.getProtocolManager().load(new File(workDir, "protocols.ini"), properties);
            System.err.println();
            DigitMaps.load(new File(workDir, "digitmaps.bin"));
            RemoteMaster.createAndShowGUI(commandLineArgs, properties, fileToOpen);
        }
        catch (Exception e) {
            System.err.println("Caught exception in RemoteMaster.main()!");
            e.printStackTrace(System.err);
            System.err.flush();
            System.exit(1);
        }
        System.err.flush();
    }

    public static File getRmirSys() {
        return rmirSys;
    }

    public static File getRmduSys() {
        return rmduSys;
    }

    public static File getRmpbSys() {
        return rmpbSys;
    }

    public static boolean testReadOnly() {
        boolean readOnly = false;
        File file = new File(workDir, "rmaster.err");
        if (!file.exists()) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                pw.println("Write Test");
                pw.flush();
                pw.close();
                file.delete();
            }
            catch (IOException ioe) {
                readOnly = true;
            }
        } else {
            readOnly = !file.canWrite();
        }
        return readOnly;
    }

    private static void createAndShowGUI(final CommandLineArgs args, final PropertyFile properties, final File fileToOpen) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.launchRMIR) {
                        RMIRSetup rm = new RMIRSetup(workDir, properties, commandLineArgs.scaling);
                        if (fileToOpen != null) {
                            rm.openFile(fileToOpen);
                        }
                    } else if (args.launchRMPB) {
                        RMProtocolBuilder pb = new RMProtocolBuilder(properties);
                        pb.loadProtocol(fileToOpen);
                    } else {
                        KeyMapMaster km = new KeyMapMaster(properties);
                        if (fileToOpen != null) {
                            km.loadUpgrade(fileToOpen);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Unable to create GUI");
                    e.printStackTrace(System.err);
                    System.err.flush();
                    System.exit(1);
                }
                System.err.flush();
            }
        });
    }

    static {
        addonDir = null;
        irpTransmogrifierCommitId = null;
        girrCommitId = null;
        rmirSys = null;
        rmduSys = null;
        rmpbSys = null;
        frame = null;
        admin = false;
        useCommHIDB = true;
        useCommHIDBDefault = true;
        defaultPBForegroundColor = null;
        upgradeEndings = new String[]{".rmdu", ".txt"};
        upgradeImportEndings = new String[]{".girr", ".ict"};
        setupExtractEndings = new String[]{".csv"};
        protocolEndings = new String[]{".rmpb"};
        girrEndings = new String[]{".girr"};
        ictEndings = new String[]{".ict"};
        commandLineArgs = new CommandLineArgs();
    }

    public static final class CommandLineArgs {
        @Parameter(names={"-help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"-version"}, description="Display version information")
        private boolean versionRequested = false;
        @Parameter(names={"-readOnly"}, description="Test if installation folder is read-only")
        private boolean testInstallationReadOnly = false;
        @Parameter(names={"-ir"}, description="Open as RMIR")
        public boolean launchRMIR = false;
        @Parameter(names={"-rm"}, description="Open as RMDU")
        public boolean launchRMDU = false;
        @Parameter(names={"-pb"}, description="Open as RMPB")
        public boolean launchRMPB = false;
        @Parameter(names={"-admin"}, description="Open in administrator mode")
        public boolean admin = false;
        @Parameter(names={"-home"}, description="Set home directory")
        private File homeDir = null;
        @Parameter(names={"-properties"}, description="Set properties file")
        public File propertiesFile = null;
        @Parameter(names={"-errors"}, description="Set errors file")
        public File errorsFile = null;
        @Parameter(names={"-scaling"}, description="Set scaling of the GUI. Accepted values and their semantics depend on the JVM.")
        private String scaling = null;
        @Parameter(description="[file]", required=false)
        public String fileName = null;
    }
}

