/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.BigEndianProcessor;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Remote;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class S3C80Processor
extends BigEndianProcessor {
    public static final int newRAMAddress = 65280;
    private static String[] conditionCodes = new String[]{"F", "LT", "LE", "ULE", "OV", "MI", "EQ", "C", "", "GE", "GT", "UGT", "NOV", "PL", "NE", "NC"};

    public S3C80Processor() {
        this("S3C80");
    }

    protected S3C80Processor(String name) {
        super(name, null);
        this.setRAMAddress(32768);
    }

    @Override
    public String getConditionCode(int n) {
        return conditionCodes[n] == "" ? "" : conditionCodes[n] + ", ";
    }

    @Override
    public int getConditionIndex(String cc) {
        if (cc.equals("T")) {
            cc = "";
        }
        return Arrays.asList(conditionCodes).indexOf(cc);
    }

    @Override
    public AssemblerOpCode.AddressMode disasmModify(AssemblerOpCode.AddressMode mode, Object[] obj) {
        int modifier = mode.modifier;
        switch (modifier) {
            case 1: {
                obj[1] = (Integer)obj[1] >> 1;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                Integer val;
                obj[1] = (Integer)obj[1] & 0xE;
                if (modifier != 8 || (val = (Integer)obj[2]) == null || val <= 127) break;
                obj[2] = val - 256;
                break;
            }
            case 4: {
                obj[0] = (Integer)obj[0] & 0xFC;
                break;
            }
            case 5: {
                int n = mode.argMap[0] - 1;
                if (((Integer)obj[n] & 1) != 1) break;
                obj[0] = "*";
                break;
            }
            case 6: {
                if (((Integer)obj[0] & 1) != 1 && ((Integer)obj[1] & 1) != 1) break;
                obj[0] = "*";
            }
        }
        return mode;
    }

    @Override
    public void asmModify(int modifier, int[] obj) {
        switch (modifier) {
            case 1: {
                obj[1] = obj[1] << 1;
            }
        }
    }

    @Override
    public boolean checkModifier(AssemblerOpCode.AddressMode mode, AssemblerOpCode.OpArg args) {
        for (int i = 0; i < args.size(); ++i) {
            AssemblerOpCode.Token t = (AssemblerOpCode.Token)args.get(i);
            if (t.type != AssemblerOpCode.TokenType.NUMBER) continue;
            int val = t.value;
            if (mode.modifier == 8 && (val < -128 || val > 127)) {
                return false;
            }
            if (mode.modifier == 8 || val >= 0 && val <= mode.argLimits[i]) continue;
            return false;
        }
        String simpleOutline = null;
        switch (mode.modifier) {
            case 2: 
            case 8: {
                simpleOutline = args.outline.replace("WW", "W");
                break;
            }
            case 5: {
                simpleOutline = args.outline + ",";
                int index = simpleOutline.indexOf(",");
                String start = simpleOutline.substring(0, index);
                String end = simpleOutline.substring(index, simpleOutline.length() - 1);
                simpleOutline = start.replace("RR", "R") + end;
                break;
            }
            case 6: {
                simpleOutline = args.outline.replace("RR", "R");
                break;
            }
            default: {
                simpleOutline = args.outline;
            }
        }
        if (!mode.outline.equals(simpleOutline)) {
            return false;
        }
        switch (mode.modifier) {
            case 2: 
            case 3: 
            case 8: {
                int n = Arrays.asList(mode.argMap).indexOf(2);
                if (n < 0) {
                    return false;
                }
                Integer val = ((AssemblerOpCode.Token)args.get((int)n)).value;
                return val != null && (val & 1) == 0 && (mode.modifier != 2 || val != 0);
            }
            case 4: {
                Integer val = ((AssemblerOpCode.Token)args.get((int)0)).value;
                return val != null && (val & 3) == 0;
            }
            case 5: {
                Integer val = ((AssemblerOpCode.Token)args.get((int)0)).value;
                return val != null && (val & 1) == 0;
            }
            case 6: {
                Integer val = ((AssemblerOpCode.Token)args.get((int)0)).value;
                Integer val2 = ((AssemblerOpCode.Token)args.get((int)1)).value;
                return val != null && val2 != null && (val & 1) == 0 && (val2 & 1) == 0;
            }
        }
        return true;
    }

    @Override
    public void addToMap(AssemblerOpCode op) {
        AssemblerOpCode op1 = op.clone();
        int index = op.getIndex();
        switch (index) {
            case 1: {
                op1.setHex(new Hex(op1.getHex(), 0, 2));
                op1.getHex().set((short)1, 1);
            }
            case 4: {
                op1.setMode(this.getAddressModes().get(op.getMode().name + "Z"));
                super.addToMap(op1);
            }
            case 0: 
            case 5: {
                super.addToMap(op);
                if (index < 2) break;
                AssemblerOpCode op2 = op.clone();
                op2.setName(op2.getName().replaceFirst("C", "E"));
                op2.setHex(new Hex(op2.getHex(), 0, 2));
                op2.getHex().set((short)1, 1);
                super.addToMap(op2);
                if (index == 5) break;
                op2 = op1.clone();
                op2.setName(op2.getName().replaceFirst("C", "E"));
                op2.setHex(new Hex(op2.getHex(), 0, 2));
                op2.getHex().set((short)1, 1);
                super.addToMap(op2);
                break;
            }
            case 2: 
            case 3: {
                op1.setName(op.getName() + (index == 2 ? "F" : "R"));
                super.addToMap(op1);
                op1 = op.clone();
                op1.setName(op.getName() + (index == 2 ? "T" : "S"));
                op1.setHex(new Hex(op1.getHex(), 0, 2));
                op1.getHex().set((short)1, 1);
                super.addToMap(op1);
                break;
            }
            case 6: {
                super.addToMap(op);
                op1.setName(op.getName() + "0");
                op1.setHex(new Hex(op1.getHex(), 0, 2));
                op1.getHex().set((short)2, 1);
                super.addToMap(op1);
                op1 = op.clone();
                op1.setName(op.getName() + "1");
                op1.setHex(new Hex(op1.getHex(), 0, 2));
                op1.getHex().set((short)1, 1);
                super.addToMap(op1);
            }
        }
        if (op.getMode().modifier == 7) {
            op1 = op.clone();
            op1.setMode(this.getAddressModes().get(op.getMode().name + "Z"));
            op1.getHex().set((short)(op1.getHex().getData()[0] | this.getConditionIndex("T") << 4), 0);
            super.addToMap(op1);
        }
    }

    @Override
    public AssemblerOpCode getOpCode(Hex hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        AssemblerOpCode opCode = this.getInstructions().get(0)[hex.getData()[0]].clone();
        int index = opCode.getIndex();
        if (index > 0 && hex.length() == 1) {
            return new AssemblerOpCode();
        }
        short byte2 = index > 0 ? hex.getData()[1] : (short)0;
        switch (index) {
            case 1: {
                if ((byte2 & 1) != 1) break;
                opCode.setMode(this.getAddressModes().get(opCode.getMode().name + "Z"));
                break;
            }
            case 2: {
                opCode.setName(opCode.getName() + ((byte2 & 1) == 0 ? "F" : "T"));
                break;
            }
            case 3: {
                opCode.setName(opCode.getName() + ((byte2 & 1) == 0 ? "R" : "S"));
                break;
            }
            case 4: {
                if ((byte2 & 0xE) == 0) {
                    opCode.setMode(this.getAddressModes().get(opCode.getMode().name + "Z"));
                }
            }
            case 5: {
                if ((byte2 & 1) != 1) break;
                opCode.setName(opCode.getName().replaceFirst("C", "E"));
                break;
            }
            case 6: {
                opCode.setName(opCode.getName() + ((byte2 & 3) == 1 ? "1" : ((byte2 & 3) == 2 ? "0" : "")));
                if ((byte2 & 3) != 3) break;
                opCode = new AssemblerOpCode();
                opCode.getMode().length = 1;
                break;
            }
        }
        if (opCode.getMode() == null) {
            opCode.setMode(new AssemblerOpCode.AddressMode());
        }
        if (opCode.getIndex() > 0) {
            opCode.setIndex(0);
        }
        return opCode;
    }

    public CodeType testCode(Hex hex) {
        if (hex.length() < 5) {
            return CodeType.UNKNOWN;
        }
        int oldCount = 0;
        int newCount = 0;
        int bothCount = 0;
        short[] data = hex.getData();
        int offset = 3;
        if ((data[3] & 0xFF) == 139) {
            offset = (data[4] & 0xFF) + 5;
        }
        block0: for (int i = offset; i < data.length; ++i) {
            int third;
            int second;
            int first = data[i] & 0xFF;
            if (first != 246 && first != 141) continue;
            if ((second = data[++i] & 0xFF) == 255) {
                ++newCount;
                continue;
            }
            if (second == 128) {
                ++oldCount;
                continue;
            }
            if (second != 1) continue;
            if ((third = data[++i] & 0xFF) == 51) {
                ++bothCount;
                continue;
            }
            int temp1 = third - 44;
            int temp2 = third - 70;
            for (int j = 0; j < 2; ++j) {
                if (0 <= temp1 && temp1 <= 14 && temp1 % 7 == 0 || 0 <= temp2 && temp2 <= 45 && temp2 % 3 == 0) {
                    oldCount += j;
                    newCount += 1 - j;
                    continue block0;
                }
                temp1 += 19;
                temp2 += 19;
            }
        }
        if (newCount > oldCount) {
            return CodeType.NEW;
        }
        if (oldCount > newCount) {
            return CodeType.OLD;
        }
        if (oldCount == 0 && newCount == 0 && bothCount > 0) {
            return CodeType.OLD;
        }
        return CodeType.UNKNOWN;
    }

    @Override
    public Hex translate(Hex hex, Remote remote) {
        if (hex.length() < 4) {
            return hex;
        }
        CodeType codeType = this.testCode(hex);
        if (!(remote.getRAMAddress() == 32768 && codeType == CodeType.NEW || remote.getRAMAddress() == 65280 && codeType == CodeType.OLD)) {
            return hex;
        }
        try {
            hex = (Hex)hex.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace(System.err);
        }
        short[] data = hex.getData();
        int offset = 3;
        if ((data[3] & 0xFF) == 139) {
            offset = (data[4] & 0xFF) + 5;
        }
        for (int i = offset; i < data.length; ++i) {
            int first = data[i] & 0xFF;
            if (first != 246 && first != 141) continue;
            int second = data[++i] & 0xFF;
            if (codeType == CodeType.NEW && second == 255) {
                data[i] = 128;
                continue;
            }
            if (codeType == CodeType.OLD && second == 128) {
                data[i] = 255;
                continue;
            }
            if (second != 1) continue;
            int third = data[++i] & 0xFF;
            data[i] = (short)this.adjust(third, codeType);
        }
        return hex;
    }

    private int adjust(int val, CodeType codeType) {
        int type = codeType == CodeType.NEW ? 0 : 1;
        int temp1 = val - 44 + 19 * type;
        int temp2 = val - 70 + 19 * type;
        if (0 <= temp1 && temp1 <= 14 && temp1 % 7 == 0 || 0 <= temp2 && temp2 <= 45 && temp2 % 3 == 0) {
            val += 19 * (2 * type - 1);
        }
        return val;
    }

    @Override
    public String getRegisterPrefix() {
        return "R";
    }

    @Override
    public List<String> getHexPrefixes() {
        List<String> list = super.getHexPrefixes();
        list.addAll(Arrays.asList("R", "RR", "W", "WW"));
        return list;
    }

    @Override
    public String simplifyOutline(String outline) {
        outline = outline.replace("RR%", "R%");
        outline = outline.replace("WW%", "W%");
        return outline;
    }

    @Override
    public String getAlternateArgument(String argText, int n) {
        argText = super.getAlternateArgument(argText, 0);
        if (n == 0) {
            return argText;
        }
        StringTokenizer st = new StringTokenizer(argText, ",@[].", true);
        StringBuilder sb = new StringBuilder();
        String pattern = "(RRC|RC|WW|W)[0-9A-F]";
        int i = 0;
        int[] map = new int[]{0, 2, 1, 3};
        int n2 = n = n < 5 ? map[n - 1] : n - 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.matches(pattern)) {
                int bit;
                token = (bit = n >> i++ & 1) == 0 ? token.replaceFirst("RRC|RC", "W") : token.replaceFirst("WW|W", "RC");
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static enum CodeType {
        OLD,
        NEW,
        UNKNOWN;

    }
}

