/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.io.JPS;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class Scanner {
    private int irdbAddress = 0;
    private int eepromAddress = 0;
    private int numberTableAddress = 0;
    private int numberTableSize = 0;
    private int executorIndexAddress = 0;
    private int executorCount = 0;
    private int setupCodeIndexAddress = 0;
    private int setupTypeIndexAddress = 0;
    private int setupCodeCount = 0;
    private int setupTypeCount = 0;
    private int indexTablesOffset = 0;
    private boolean codeIncludesType = true;
    private JPS io = null;

    public Scanner(JPS io, int irdbAddress) {
        this.io = io;
        this.irdbAddress = irdbAddress;
        this.eepromAddress = io.getRemoteEepromAddress();
    }

    public boolean scan() {
        int numberTableLength;
        Hex hex = new Hex(64);
        this.io.readRemote(this.irdbAddress, hex.getData());
        this.numberTableAddress = hex.get(20) * 2;
        this.setupCodeIndexAddress = hex.get(22) * 2;
        this.setupTypeIndexAddress = hex.get(26) * 2;
        this.executorIndexAddress = hex.get(28) * 2;
        this.indexTablesOffset = hex.get(34) * 2;
        this.setupCodeCount = this.getInt(this.setupCodeIndexAddress);
        this.executorCount = this.getInt(this.executorIndexAddress);
        if (RemoteMaster.admin) {
            System.err.println();
            int regionalPointersAddress = hex.get(36) * 2;
            int buttonMapDataLength = regionalPointersAddress - (this.irdbAddress + 40);
            if (buttonMapDataLength > 0) {
                int mapEnd;
                int ptr = this.irdbAddress + 42;
                int mapStart = this.getInt(ptr);
                int count = (mapStart - ptr) / 2;
                for (int i = 0; i < count && (mapEnd = (mapStart = this.getInt(ptr = this.irdbAddress + 42 + 2 * i))) <= regionalPointersAddress; ++i) {
                    while (this.getByte(mapEnd++) != 255) {
                    }
                    short[] mapData = new short[mapEnd - mapStart - 1];
                    this.io.readRemote(mapStart, mapData);
                    String mapString = "Map " + i + " Data = ";
                    for (int j = 0; j < mapData.length; ++j) {
                        mapString = mapString + (j > 0 ? ", " : "") + String.format("$%02X", mapData[j]);
                    }
                    System.err.println(mapString);
                }
            }
        }
        if ((numberTableLength = this.setupCodeIndexAddress - this.numberTableAddress) % 10 != 0) {
            System.err.println("Parsing failed: number table has invalid length");
            return false;
        }
        this.numberTableSize = numberTableLength / 10;
        if (RemoteMaster.admin) {
            System.err.println("Start address of setup code index: $" + Integer.toHexString(this.setupCodeIndexAddress));
            System.err.println("Start address of setup type index: $" + Integer.toHexString(this.setupTypeIndexAddress));
            System.err.println("Count of setup codes: " + Integer.toString(this.setupCodeCount));
            System.err.println("Start address of executor index: $" + Integer.toHexString(this.executorIndexAddress));
            System.err.println("Count of executors: " + Integer.toString(this.executorCount));
            Hex checksum = new Hex(2);
            this.io.readRemote(this.io.getCodeAddress(), checksum.getData());
            System.err.println("Code checksum read: " + checksum);
            XorCheckSum cs = new XorCheckSum(0, new AddressRange(2, this.io.getCodeSize() - 1), false);
            short[] code = new short[this.io.getCodeSize()];
            this.io.readRemote(this.io.getCodeAddress(), code);
            short c = cs.calculateCheckSum(code, 2, this.io.getCodeSize() - 1);
            checksum.set(c, 0);
            checksum.set(~c, 1);
            System.err.println("Code checksum calculated: " + checksum);
            this.io.readRemote(this.io.getSigAddress(), checksum.getData());
            System.err.println("SigBlk checksum read: " + checksum);
            cs = new XorCheckSum(0, new AddressRange(2, this.io.getSigSize() - 1), false);
            code = new short[this.io.getSigSize()];
            this.io.readRemote(this.io.getSigAddress(), code);
            c = cs.calculateCheckSum(code, 2, this.io.getSigSize() - 1);
            checksum.set(c, 0);
            checksum.set(~c, 1);
            System.err.println("SigBlk checksum calculated: " + checksum);
        }
        int type = -1;
        int typeLimit = this.getInt(this.setupTypeIndexAddress + 2 * type + 2) * 2;
        for (int i = 0; i < this.setupCodeCount; ++i) {
            int codeAddress = this.setupCodeIndexAddress + 2 + 2 * i;
            if (codeAddress == typeLimit) {
                typeLimit = this.getInt(this.setupTypeIndexAddress + 2 * ++type + 2) * 2;
            }
            int setupCode = this.getInt(this.setupCodeIndexAddress + 2 * i + 2);
            int typeFromSetupCode = setupCode >> 12;
            if (!this.codeIncludesType || type == typeFromSetupCode) continue;
            this.codeIncludesType = false;
        }
        this.setupTypeCount = type + 1;
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        for (int i = 0; i < this.executorCount; ++i) {
            pidList.add(this.getInt(this.executorIndexAddress + 2 * i + 2));
        }
        boolean chaining = false;
        int maxMap = 0;
        int maxMapPid = -1;
        for (int i = 0; i < this.setupCodeCount; ++i) {
            int addr = this.getInt(this.setupCodeIndexAddress + 2 * this.setupCodeCount + 2 * i + 2) + this.indexTablesOffset;
            if (addr >= this.eepromAddress) {
                System.err.println("Parsing failed: setup code address out of range");
                return false;
            }
            hex = new Hex(4);
            this.io.readRemote(addr, hex.getData());
            int testPid = hex.get(0);
            if (!pidList.contains(testPid)) {
                if (pidList.contains(testPid & 0xFFF)) {
                    chaining = true;
                    testPid &= 0xFFF;
                } else {
                    System.err.println("Parsing failed: setup data contains nonexistent pid");
                    return false;
                }
            }
            if (hex.getData()[2] > maxMap) {
                maxMap = hex.getData()[2];
                maxMapPid = testPid;
            }
            maxMap = Math.max(maxMap, hex.getData()[2]);
        }
        int index = pidList.indexOf(maxMapPid);
        int addr = this.getInt(this.executorIndexAddress + 2 * this.executorCount + 2 * index + 2) + this.indexTablesOffset;
        int numVar = this.getInt(addr + 2) & 0xF;
        if ((maxMap += numVar - 1) > this.numberTableSize) {
            System.err.println("Parsing failed: setup data contains nonexistent map imdex");
            return false;
        }
        if (RemoteMaster.admin) {
            System.err.println("Start address of number tables: $" + Integer.toHexString(this.numberTableAddress));
            System.err.println("Count of number tables/Last used: " + Integer.toString(this.numberTableSize) + "/" + Integer.toString(maxMap));
            System.err.println("Setup data " + (chaining ? "uses" : "does not use") + " chaining");
            System.err.println();
        }
        return true;
    }

    public void dump() {
        short[] buffer = new short[this.eepromAddress - this.irdbAddress];
        this.io.readRemote(this.irdbAddress, buffer);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            Hex.print(pw, Arrays.copyOf(buffer, buffer.length), this.irdbAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.err.print(sw.toString());
        buffer = null;
    }

    public int getInt(int addr) {
        short[] buf = new short[2];
        this.io.readRemote(addr, buf);
        return buf[0] | buf[1] << 8;
    }

    public int getByte(int addr) {
        short[] buf = new short[2];
        this.io.readRemote(addr, buf);
        return buf[0];
    }

    public int getNumberTableAddress() {
        return this.numberTableAddress;
    }

    public int getNumberTableSize() {
        return this.numberTableSize;
    }

    public int getExecutorIndexAddress() {
        return this.executorIndexAddress;
    }

    public int getExecutorCount() {
        return this.executorCount;
    }

    public int getSetupCodeIndexAddress() {
        return this.setupCodeIndexAddress;
    }

    public int getSetupTypeIndexAddress() {
        return this.setupTypeIndexAddress;
    }

    public int getSetupCodeCount() {
        return this.setupCodeCount;
    }

    public int getSetupTypeCount() {
        return this.setupTypeCount;
    }

    public int getIndexTablesOffset() {
        return this.indexTablesOffset;
    }

    public boolean setupCodeIncludesType() {
        return this.codeIncludesType;
    }
}

