/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import java.util.List;

public class Segment
extends Highlight {
    private int type = 0;
    private int flags = 255;
    private Hex hex = null;
    private int address = 0;

    public static int writeData(List<Segment> list, short[] data, int pos) {
        for (Segment seg : list) {
            Hex hex = seg.getHex();
            Hex.put(hex.length() + 4, data, pos);
            data[pos + 2] = (short)seg.get_Type();
            data[pos + 3] = (short)seg.getFlags();
            Hex.put(hex, data, pos + 4);
            seg.setAddress(pos);
            pos += hex.length() + 4;
        }
        return pos;
    }

    public Segment(int type, int flags, Hex hex) {
        this.hex = hex;
        this.type = type;
        this.flags = flags;
    }

    public Segment(int type, int flags, Hex hex, Highlight object) {
        this(type, flags, hex);
        object.setSegment(this);
    }

    public Segment(int type, int flags, Hex hex, List<? extends Highlight> list) {
        this(type, flags, hex);
        int index = 0;
        for (Highlight highlight : list) {
            highlight.setSegment(this, index++);
        }
    }

    public int get_Type() {
        return this.type;
    }

    public void set_Type(int type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Hex getHex() {
        return this.hex;
    }

    public void setObject(Highlight object) {
        object.setSegment(this);
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setHex(Hex hex) {
        this.hex = hex;
    }
}

