/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SegmentTableModel;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class SegmentPanel
extends RMPanel
implements ActionListener,
ListSelectionListener {
    private SegmentTableModel model = null;
    private SegmentTable table = null;
    private RemoteConfiguration config = null;
    private JLabel signatureLabel = new JLabel();
    private JLabel processorLabel = new JLabel();
    private JLabel interfaceLabel = new JLabel();
    private JLabel infoLabel1 = new JLabel("Data in black: RMIR data displayed");
    private JLabel infoLabel2 = new JLabel("Data in blue: Original data displayed");
    private JLabel infoLabel3 = new JLabel("Select between them with \"Preserve original data\"");
    private JLabel infoLabel4 = new JLabel("    on the Advanced menu.");
    private JButton applyButton = new JButton("Apply");
    private JButton undoButton = new JButton("Undo");
    private JButton upButton = new JButton("Move up");
    private JButton downButton = new JButton("Move down");
    private JButton insertButton = new JButton("Insert");
    private JButton deleteButton = new JButton("Delete");
    private JButton rmirButton = new JButton("Sort into RMIR order");
    private boolean lastSorted = false;

    public SegmentPanel() {
        this.model = new SegmentTableModel();
        this.table = new SegmentTable(this.model);
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.model.setTable(this.table);
        this.table.setGridColor(Color.lightGray);
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        Dimension d = this.table.getPreferredScrollableViewportSize();
        d.width = this.table.getPreferredSize().width;
        this.table.setPreferredScrollableViewportSize(d);
        this.add((Component)scrollPane, "Center");
        String message = "When original data is displayed, segments can be edited, inserted, deleted or re-ordered.  When RMIR data is displayed, they can only be edited, and that only for those segment types not known to RMIR.\n\nEdits are not applied to the data concerned until the Apply button is pressed.  Until that time they can be undone with the Undo button and WILL be undone by leaving this tab or switching the display.\n\nUpload will upload whichever of original or RMIR data is currently selected.";
        ProtocolDataPanel.DisplayArea note = new ProtocolDataPanel.DisplayArea(message, null);
        double b = 2.0;
        double c = 5.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size = new double[][]{{2.0 * c, pr, b, pr, pr, 2.0 * c}, {c, pr, pr, pr, pr, 2.0 * c, pr, c, pr, c, pr, 8.0 * c, pr, 2.0 * c, pr, b, pr, pr, 2.0 * c, pr, pf}};
        JPanel buttonPanel = new JPanel(new TableLayout(size));
        buttonPanel.add((Component)this.infoLabel1, "1, 1, 4, 1");
        buttonPanel.add((Component)this.infoLabel2, "1, 2, 4, 2");
        buttonPanel.add((Component)this.infoLabel3, "1, 3, 4, 3");
        buttonPanel.add((Component)this.infoLabel4, "1, 4, 4, 4");
        buttonPanel.add((Component)this.signatureLabel, "1, 6, 4, 6");
        buttonPanel.add((Component)this.processorLabel, "1, 8, 4, 8");
        buttonPanel.add((Component)this.interfaceLabel, "1, 10, 4, 10");
        buttonPanel.add((Component)this.applyButton, "1, 12");
        buttonPanel.add((Component)this.undoButton, "3, 12");
        buttonPanel.add((Component)this.insertButton, "1, 14");
        buttonPanel.add((Component)this.deleteButton, "3, 14");
        buttonPanel.add((Component)this.upButton, "1, 16");
        buttonPanel.add((Component)this.downButton, "3, 16");
        buttonPanel.add((Component)this.rmirButton, "1, 17, 3, 17");
        buttonPanel.add((Component)note, "1, 19, 4, 19");
        this.add((Component)buttonPanel, "After");
        this.applyButton.addActionListener(this);
        this.undoButton.addActionListener(this);
        this.insertButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.rmirButton.addActionListener(this);
        Font boldFont = new JLabel().getFont().deriveFont(1);
        this.infoLabel1.setFont(boldFont);
        this.infoLabel2.setFont(boldFont);
        this.infoLabel2.setForeground(Color.BLUE);
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.config = remoteConfig;
        Remote remote = null;
        this.model.setSorted(this.lastSorted);
        this.model.setChanged(false);
        this.setButtons();
        if (remoteConfig != null && remoteConfig.hasSegments() && !(remote = remoteConfig.getRemote()).isSSD()) {
            this.model.set(remoteConfig);
            String sig = remoteConfig.getSigString();
            if (sig == null) {
                sig = remote.getSignature();
            }
            this.signatureLabel.setText("Signature:  " + sig);
            this.processorLabel.setText("Processor:  " + remote.getProcessorDescription());
            this.interfaceLabel.setText("Interface:  " + remoteConfig.getInterfaceType());
        }
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener l) {
        if (this.model != null && l != null) {
            this.model.addPropertyChangeListener(l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Remote remote = this.config.getRemote();
        int row = this.table.getSelectedRow();
        int count = this.table.getSelectedRowCount();
        this.finishEditing();
        if (source == this.applyButton) {
            this.model.updateData();
            this.model.setChanged(false);
            this.lastSorted = this.model.getSorted();
        } else if (source == this.undoButton) {
            this.model.resetData();
            this.model.setSorted(this.lastSorted);
            this.model.setChanged(false);
        } else if (source == this.upButton) {
            for (int i = 0; i < count; ++i) {
                this.model.moveRow(row + i - 1, row + i);
                if (((Segment)this.model.getRow(row + i - 1)).get_Type() == ((Segment)this.model.getRow(row + i)).get_Type()) continue;
                this.model.setSorted(false);
            }
            this.model.resetAddresses();
            this.model.setChanged(true);
            this.table.setRowSelectionInterval(row - 1, row + count - 2);
        } else if (source == this.downButton) {
            for (int i = count; i > 0; --i) {
                this.model.moveRow(row + i - 1, row + i);
                if (((Segment)this.model.getRow(row + i - 1)).get_Type() == ((Segment)this.model.getRow(row + i)).get_Type()) continue;
                this.model.setSorted(false);
            }
            this.model.resetAddresses();
            this.model.setChanged(true);
            this.table.setRowSelectionInterval(row + 1, row + count);
        } else if (source == this.deleteButton) {
            for (int i = 0; i < count; ++i) {
                this.model.removeRow(row);
                this.model.resetAddresses();
                if (row < this.model.getRowCount()) continue;
                --row;
            }
            this.model.setChanged(true);
            this.table.setRowSelectionInterval(row, row);
        } else if (source == this.insertButton) {
            for (int i = 0; i < count; ++i) {
                Segment seg = new Segment(((Segment)this.model.getRow(row + i)).get_Type(), 255, new Hex(0));
                this.model.insertRow(row + i, seg);
            }
            this.model.resetAddresses();
            this.model.setChanged(true);
            this.table.setRowSelectionInterval(row, row | count - 1);
        } else if (source == this.rmirButton) {
            LinkedHashMap<Integer, ArrayList<Segment>> segMap1 = new LinkedHashMap<Integer, ArrayList<Segment>>();
            LinkedHashMap segMap2 = new LinkedHashMap();
            LinkedHashMap<Integer, ArrayList<Segment>> segMap = null;
            for (Segment seg : this.model.getData()) {
                int type = seg.get_Type();
                int flags = seg.getFlags();
                segMap = (flags & 0x80) == 128 ? segMap1 : segMap2;
                ArrayList<Segment> list = (ArrayList<Segment>)segMap.get(type);
                if (list == null) {
                    list = new ArrayList<Segment>();
                    segMap.put(type, list);
                }
                list.add(seg);
            }
            this.model.getData().clear();
            for (int i = 0; i < 2; ++i) {
                List list;
                segMap = i == 0 ? segMap1 : segMap2;
                for (int key : remote.getSegmentTypes()) {
                    list = (List)segMap.get(key);
                    if (list == null) continue;
                    this.model.getData().addAll(list);
                }
                for (int key : segMap.keySet()) {
                    if (remote.getSegmentTypes().contains(key) || (list = (List)segMap.get(key)) == null) continue;
                    this.model.getData().addAll(list);
                }
            }
            this.model.fireTableDataChanged();
            this.model.setSorted(true);
            this.model.setChanged(true);
        }
        this.setButtons();
    }

    protected void finishEditing() {
        TableCellEditor editor;
        int editRow = this.table.getEditingRow();
        if (editRow != -1 && !(editor = this.table.getCellEditor(editRow, this.table.getEditingColumn())).stopCellEditing()) {
            editor.cancelCellEditing();
        }
    }

    public void resetLastSorted() {
        this.lastSorted = false;
    }

    private void setButtons() {
        int row = this.table.getSelectedRow();
        int count = this.table.getSelectedRowCount();
        int size = this.table.getRowCount();
        boolean savedData = this.config.getOwner().useSavedData();
        this.upButton.setEnabled(savedData && row > 0 && row + count - 1 < size);
        this.downButton.setEnabled(savedData && row >= 0 && row + count < size);
        this.insertButton.setEnabled(savedData && row >= 0 && row + count - 1 < size);
        this.deleteButton.setEnabled(savedData && row >= 0 && row + count - 1 < size);
        this.applyButton.setEnabled(this.model.isChanged());
        this.undoButton.setEnabled(this.model.isChanged());
        this.rmirButton.setEnabled(savedData && !this.model.getSorted());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setButtons();
    }

    protected class SegmentTable
    extends JP1Table {
        public SegmentTable(TableModel model) {
            super(model);
        }
    }
}

