/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SegmentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SegmentTableModel
extends JP1TableModel<Segment> {
    private RemoteConfiguration config = null;
    private SegmentPanel.SegmentTable table = null;
    private boolean changed = false;
    private boolean sorted = false;
    private static Font lblFont = new JLabel().getFont();
    private static final String[] colNames = new String[]{"    ", "Address", "Length", "Type", "Flags", "Data"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Address_", "Length_", "Type_", "Flags_", "Data___________________________"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, String.class, String.class, Hex.class};

    public void setTable(SegmentPanel.SegmentTable table) {
        this.table = table;
    }

    @Override
    public String getToolTipText(int row, int col) {
        if (col == 5) {
            Segment seg = (Segment)this.getRow(row);
            int type = seg.get_Type();
            String description = this.segmentDescription(seg);
            return description != null ? description : "Segment type not known to RMIR";
        }
        return null;
    }

    private String segmentDescription(Segment segment) {
        Remote remote = this.config.getRemote();
        int type = segment.get_Type();
        switch (type) {
            case 0: {
                return "Device Button segment";
            }
            case 1: {
                return "Macro segment";
            }
            case 2: {
                return "Multi Macro segment";
            }
            case 3: {
                short keyCode;
                Button btn;
                int codeSize = remote.getMacroSupport();
                if (codeSize == 2 && (btn = remote.getButton(keyCode = segment.getHex().getData()[1])) != null && !btn.allowsControlledMacro()) {
                    codeSize = 1;
                }
                return codeSize == 2 ? "Controlled Macro segment" : (remote.getMacroSupport() == 2 ? "Real-time Macro Segment" : "Key Delayed Macro segment");
            }
            case 4: {
                return "Activity Power Macro segment";
            }
            case 7: {
                return "Keycode Keymove segment";
            }
            case 8: {
                return "EFC-style Keymove segment";
            }
            case 9: {
                return "Learned Signal segment";
            }
            case 10: {
                return "Soft Key Names segment";
            }
            case 11: {
                return "Button Device Assignments segment";
            }
            case 14: {
                return "Device Upgrade Definition segment";
            }
            case 15: {
                return "Protocol Upgrade Definition segment";
            }
            case 16: {
                return "Combined Upgrade Definition segment";
            }
            case 17: {
                return "Upgrade Assignments segment";
            }
            case 18: {
                return "Language Setting segment";
            }
            case 20: {
                return "Vendor Setup ID segment";
            }
            case 21: {
                return "Device Names segment";
            }
            case 25: {
                return "Global Punchthrough segment";
            }
            case 27: {
                return "Internal setup segment";
            }
            case 29: {
                return remote.hasFavorites() ? "Favorites Definition segment" : null;
            }
            case 30: {
                return "Activity Definition segment";
            }
            case 31: {
                return "Activity Assist Definition segment";
            }
            case 32: {
                return remote.usesEZRC() && !remote.isSSD() ? "Function Names segment" : (remote.hasRf4ceSupport() ? "RF Network Information Base attribute" : null);
            }
            case 39: {
                return "RF Network Information Base attribute";
            }
            case 43: {
                return "RF Vendor Data segment";
            }
            case 45: {
                return "RF Selectors segment";
            }
            case 46: {
                return remote.usesLedColor() ? "Streamer LED Color segment" : null;
            }
            case 47: {
                return remote.getSettings() != null && remote.getSettings().length > 0 ? "Settings Assignment segment" : null;
            }
            case 205: {
                return remote.hasMasterPowerSupport() ? "Master Power macro segment" : "WatchTV Activity segment";
            }
            case 206: {
                return "WatchMovie Activity segment";
            }
            case 207: {
                return "ListenToMusic Activity segment";
            }
            case 219: {
                return "Activity Device Settings segment";
            }
            case 220: {
                return "Activity Help Settings segment";
            }
            case 233: {
                return "Activity Assignment segment";
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col != 5;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 5) {
            return new TextAreaRenderer();
        }
        return null;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (col == 5) {
            return new TextAreaEditor();
        }
        return null;
    }

    private boolean isTypeEditable(Segment segment) {
        if (this.useSavedData()) {
            return true;
        }
        int type = segment.get_Type();
        return !this.config.getRemote().getSegmentTypes().contains(type) || this.segmentDescription(segment) == null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Segment seg = (Segment)this.getRow(row);
        return this.isTypeEditable(seg) && col > (this.useSavedData() ? 2 : 3);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Segment seg = (Segment)this.getRow(row);
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return String.format("%04X", seg.getAddress());
            }
            case 2: {
                return String.format("%04X", seg.getHex().length() + 4);
            }
            case 3: {
                return String.format("%02X", seg.get_Type());
            }
            case 4: {
                return String.format("%02X", seg.getFlags());
            }
            case 5: {
                return seg.getHex().toString();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Segment seg = (Segment)this.getRow(row);
        if (col == 3) {
            int type = Integer.parseInt((String)value, 16);
            seg.set_Type(type);
            if (!(row != 0 && type == ((Segment)this.getRow(row - 1)).get_Type() || row != this.table.getRowCount() - 1 && type == ((Segment)this.getRow(row + 1)).get_Type())) {
                this.sorted = false;
            }
        } else if (col == 4) {
            try {
                int flags = Integer.parseInt((String)value, 16);
                if (!this.useSavedData()) {
                    flags |= 0x80;
                }
                if ((flags & 0x80) != (seg.getFlags() & 0x80)) {
                    this.sorted = false;
                }
                seg.setFlags(flags);
            }
            catch (NumberFormatException e) {
                seg.setFlags(255);
            }
        } else if (col == 5) {
            seg.setHex((Hex)value);
        }
        this.changed = true;
        this.resetAddresses();
        this.fireTableDataChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private boolean useSavedData() {
        return this.config.getOwner().useSavedData();
    }

    public void resetData() {
        this.set(this.config);
    }

    public void resetAddresses() {
        Remote remote = this.config.getRemote();
        int addr = remote.getBaseAddress();
        addr += remote.usesEZRC() || remote.usesSimpleset() ? 20 : 2;
        for (Segment seg : this.data) {
            seg.setAddress(addr);
            addr += seg.getHex().length() + 4;
        }
    }

    public void set(RemoteConfiguration config) {
        this.config = config;
        this.changed = false;
        Remote remote = config.getRemote();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        short[] dataToShow = this.useSavedData() ? config.getSavedData() : config.getData();
        int base = remote.getBaseAddress();
        int segLength = 0;
        for (int pos = remote.getE2FormatOffset() >= 0 ? 20 : 2; pos < remote.getEepromSize() && (segLength = Hex.get(dataToShow, pos)) <= remote.getEepromSize() - pos && segLength != 0; pos += segLength) {
            short segType = dataToShow[pos + 2];
            short segFlags = dataToShow[pos + 3];
            Hex segData = new Hex(dataToShow, pos + 4, segLength - 4);
            Segment seg = new Segment(segType, segFlags, segData);
            seg.setAddress(base + pos);
            segments.add(seg);
        }
        this.setData(segments);
        this.table.initColumns();
    }

    public void updateData() {
        int pos;
        Remote remote = this.config.getRemote();
        int n = pos = remote.getE2FormatOffset() >= 0 ? 20 : 2;
        if (this.useSavedData()) {
            for (int i = pos = Segment.writeData(this.data, this.config.getSavedData(), pos); i < this.config.getSavedData().length; ++i) {
                this.config.getSavedData()[i] = 255;
            }
            CheckSum sum = remote.getCheckSums()[0];
            int oldEnd = sum.getAddressRange().getEnd();
            sum.getAddressRange().setEnd(pos - 1);
            sum.setCheckSum(this.config.getSavedData());
            sum.getAddressRange().setEnd(oldEnd);
            this.resetAddresses();
            return;
        }
        LinkedHashMap<Integer, List<Segment>> list = this.config.getSegments();
        int n2 = 0;
        for (int type : this.config.getSegmentLoadOrder()) {
            List<Segment> segs = list.get(type);
            if (segs == null) continue;
            for (Segment seg : segs) {
                if (!this.isTypeEditable(seg)) {
                    ++n2;
                    continue;
                }
                seg.setFlags(((Segment)this.data.get(n2)).getFlags());
                seg.setHex(new Hex(((Segment)this.data.get(n2++)).getHex()));
            }
        }
        this.propertyChangeSupport.firePropertyChange("data", null, null);
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    private class TextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        private Color selectionBackground = null;
        private Color selectionForeground = null;
        private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();

        public TextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setFont(lblFont);
            UIDefaults defaults = UIManager.getDefaults();
            this.selectionBackground = defaults.getColor("List.selectionBackground");
            this.selectionForeground = defaults.getColor("List.selectionForeground");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String text = (String)value;
            this.setText(text);
            this.adjustRowHeight(table, row, col);
            this.setBackground(isSelected ? this.selectionBackground : Color.WHITE);
            this.setForeground(isSelected ? this.selectionForeground : (SegmentTableModel.this.useSavedData() ? Color.BLUE : Color.BLACK));
            return this;
        }

        private void adjustRowHeight(JTable table, int row, int column) {
            int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
            this.setSize(new Dimension(cWidth, 1000));
            int prefH = this.getPreferredSize().height;
            while (this.rowColHeight.size() <= row) {
                this.rowColHeight.add(new ArrayList(column));
            }
            List<Integer> colHeights = this.rowColHeight.get(row);
            while (colHeights.size() <= column) {
                colHeights.add(0);
            }
            colHeights.set(column, prefH);
            int maxH = prefH;
            for (Integer colHeight : colHeights) {
                if (colHeight <= maxH) continue;
                maxH = colHeight;
            }
            if (table.getRowHeight(row) != maxH) {
                table.setRowHeight(row, maxH);
            }
        }
    }

    private class TextAreaEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextArea();
        JTextArea area = (JTextArea)this.component;

        public TextAreaEditor() {
            this.area.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        TextAreaEditor.this.stopCellEditing();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            this.area.setFont(lblFont);
            this.area.setText((String)value);
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.area.setForeground(SegmentTableModel.this.useSavedData() ? Color.BLUE : Color.BLACK);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return new Hex(this.area.getText());
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            return event == null || !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 2;
        }
    }
}

