/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.Segment;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public class Setting
extends Highlight {
    private String title;
    private int byteAddress;
    private int bitNumber;
    private int numberOfBits;
    private int initialValue;
    private boolean inverted;
    private Object[] optionList = null;
    private String sectionName = null;
    private int value = 0;

    public String getTitle() {
        return this.title;
    }

    public int getByteAddress() {
        return this.byteAddress;
    }

    public int getBitNumber() {
        return this.bitNumber;
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    boolean isInverted() {
        return this.inverted;
    }

    public Object[] getOptions(Remote r) {
        Object[] choices = null;
        if (this.optionList != null) {
            choices = this.optionList;
        } else if (this.sectionName != null) {
            choices = r.getSection(this.sectionName);
            if (r.getSoftDevices() != null && r.getSoftDevices().getAllowEmptyButtonSettings() && this.sectionName.equals("DeviceButtons")) {
                Object[] oldChoices = choices;
                int length = oldChoices.length;
                choices = new Object[length + 1];
                System.arraycopy(oldChoices, 0, choices, 0, length);
                choices[length] = DeviceButton.noButton;
            }
        }
        return choices;
    }

    public Setting(String name, int byteAddr, int bitNum, int numBits, int initVal, boolean invert, Object[] options, String section) {
        this.title = name;
        this.byteAddress = byteAddr;
        this.bitNumber = bitNum;
        this.numberOfBits = numBits;
        this.initialValue = initVal;
        this.inverted = invert;
        this.sectionName = section;
        this.value = initVal;
        if (this.numberOfBits == 0 && (options != null && options.length > 0 && ((String)options[0]).contains(":") || this.sectionName != null && this.sectionName.startsWith("[") && this.sectionName.endsWith("]"))) {
            if (this.sectionName == null) {
                NamedHex[] named = new NamedHex[options.length];
                for (int i = 0; i < options.length; ++i) {
                    String str = (String)options[i];
                    int pos = str.indexOf(58);
                    if (pos <= 0 || pos == str.length() - 1) {
                        System.err.println("Illegal format of Named Hex option \"" + options[i] + "\"");
                        named[i] = null;
                        continue;
                    }
                    String hexName = str.substring(0, pos).trim();
                    Hex hexVal = new Hex(str.substring(pos + 1).trim());
                    named[i] = new NamedHex(hexName, hexVal);
                }
                this.optionList = named;
            }
        } else {
            this.optionList = options;
        }
    }

    public void optionsFromButtonGroup(Remote remote) {
        if (this.numberOfBits > 0 || this.optionList != null || this.sectionName == null || remote.getButtonGroups() == null) {
            return;
        }
        String groupName = this.sectionName.substring(1, this.sectionName.length() - 1).trim();
        List<Button> btnList = remote.getButtonGroups().get(groupName);
        if (btnList == null) {
            return;
        }
        this.optionList = new NamedHex[btnList.size()];
        int i = 0;
        for (Button btn : btnList) {
            Hex hex = new Hex(1);
            hex.getData()[0] = btn.getKeyCode();
            NamedHex nh = new NamedHex(btn.getName(), hex);
            this.optionList[i++] = nh;
        }
    }

    @Override
    public String toString() {
        StringBuilder temp = new StringBuilder(100);
        temp.append(this.title).append("=$").append(Integer.toHexString(this.byteAddress)).append('.').append(this.bitNumber).append('.').append(this.numberOfBits).append('.').append(this.initialValue).append('.').append(this.inverted ? 1 : 0);
        if (this.optionList != null) {
            temp.append(" (");
            for (int i = 0; i < this.optionList.length; ++i) {
                Object obj;
                if (i > 0) {
                    temp.append(';');
                }
                if ((obj = this.optionList[i]) instanceof NamedHex) {
                    NamedHex nh = (NamedHex)obj;
                    temp.append(nh.getName() + " : " + nh.getHex());
                    continue;
                }
                temp.append(this.optionList[i]);
            }
            temp.append(')');
        } else if (this.sectionName != null) {
            temp.append(' ').append(this.sectionName);
        }
        return temp.toString();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void decode(short[] data, Remote remote) {
        int byteAddr = remote.getSegmentTypes() == null ? this.byteAddress : this.byteAddress & 0xFF;
        int temp = data[byteAddr];
        if (remote.getSoftDevices() != null && remote.getSoftDevices().getAllowEmptyButtonSettings() && this.sectionName != null && this.sectionName.equals("DeviceButtons") && temp == 255) {
            this.value = this.getOptions(remote).length - 1;
            return;
        }
        if (this.numberOfBits == 0) {
            for (int i = 0; i < this.optionList.length; ++i) {
                Hex hex = ((NamedHex)this.optionList[i]).getHex();
                int size = hex.length();
                if (!Hex.subHex(data, byteAddr, size).equals(hex)) continue;
                this.value = i;
                return;
            }
            this.value = this.initialValue;
            return;
        }
        int mask = (1 << this.numberOfBits) - 1;
        if (this.inverted) {
            temp ^= 0xFFFFFFFF;
        }
        int shift = this.bitNumber - this.numberOfBits + 1;
        this.value = (temp >>= shift) & mask;
    }

    public int[] getMasks() {
        int[] masks = null;
        if (this.numberOfBits == 0 && this.optionList != null && this.optionList.length > 0 && this.optionList[0] instanceof NamedHex || this.sectionName != null && this.sectionName.startsWith("[") && this.sectionName.endsWith("]")) {
            int maxSize = 0;
            if (this.optionList != null) {
                for (int i = 0; i < this.optionList.length; ++i) {
                    maxSize = Math.max(maxSize, ((NamedHex)this.optionList[i]).hex.length());
                }
            } else {
                maxSize = 1;
            }
            masks = new int[maxSize];
            Arrays.fill(masks, 0);
        } else {
            int mask = (1 << this.numberOfBits) - 1;
            int shift = this.bitNumber - this.numberOfBits + 1;
            mask <<= shift;
            masks = new int[]{mask ^= 0xFFFFFFFF};
        }
        return masks;
    }

    public void store(short[] data, Remote remote) {
        int byteAddr;
        int n = byteAddr = remote.getSegmentTypes() == null ? this.byteAddress : this.byteAddress & 0xFF;
        if (remote.getSoftDevices() != null && remote.getSoftDevices().getAllowEmptyButtonSettings() && this.sectionName != null && this.sectionName.equals("DeviceButtons") && this.value == this.getOptions(remote).length - 1) {
            data[byteAddr] = 255;
            return;
        }
        if (this.numberOfBits == 0 && this.optionList.length > 0 && this.optionList[0] instanceof NamedHex) {
            NamedHex nh = (NamedHex)this.optionList[this.value];
            Hex.put(nh.getHex().getData(), data, byteAddr);
            return;
        }
        int mask = (1 << this.numberOfBits) - 1;
        int shift = this.bitNumber - this.numberOfBits + 1;
        int val = this.value;
        if (this.inverted) {
            val ^= 0xFFFFFFFF;
        }
        val &= mask;
        mask <<= shift;
        int temp = data[byteAddr];
        temp &= (mask ^= 0xFFFFFFFF);
        data[byteAddr] = (short)(temp |= (val <<= shift));
    }

    @Override
    public void store(PropertyWriter pw) {
        pw.print(this.title, this.value);
    }

    public void doHighlight(Color[] highlight, int index, RemoteConfiguration config) {
        Remote remote = config.getRemote();
        if (this.optionList != null && this.optionList[this.value] instanceof NamedHex) {
            int segmentType = -1;
            int byteAddress = remote.getSettingBytes().get(index);
            if (remote.getSegmentTypes() != null) {
                segmentType = (byteAddress >> 8) - 1;
                byteAddress &= 0xFF;
                List<Segment> segs = config.getSegments().get(segmentType);
                if (segs == null || segs.size() == 0) {
                    return;
                }
                Segment segment = segs.get(0);
                int address = segment.getAddress();
                byteAddress += address + 4;
            }
            NamedHex nh = (NamedHex)this.optionList[this.value];
            int size = nh.getHex().length();
            for (int i = 0; i < size; ++i) {
                highlight[byteAddress + i] = this.getHighlight();
            }
            this.setMemoryUsage(size);
            return;
        }
        int end = highlight.length - 1;
        for (int i = 0; i < this.numberOfBits; ++i) {
            highlight[end - 8 * index - this.bitNumber + i] = this.getHighlight();
        }
        this.setMemoryUsage(-this.numberOfBits);
    }

    public static class NamedHex {
        private String name = null;
        private Hex hex = null;

        public NamedHex(String name, Hex hex) {
            this.name = name;
            this.hex = hex;
        }

        public String getName() {
            return this.name;
        }

        public Hex getHex() {
            return this.hex;
        }

        public String toString() {
            return this.name;
        }
    }
}

