/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.BoundedIntegerEditor;
import com.hifiremote.jp1.CellEditorModel;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.Setting;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SettingsTableModel
extends JP1TableModel<Setting>
implements CellEditorModel {
    private static final String[] colNames = new String[]{"#", "Setting", "Value", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "A Setting Name", "A Value", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, Setting.class, Color.class};
    private RemoteConfiguration remoteConfig = null;
    private BoundedIntegerEditor intEditor = new BoundedIntegerEditor();
    private DefaultCellEditor comboEditor = new DefaultCellEditor(new JComboBox());
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();

    public SettingsTableModel() {
        this.comboEditor.setClickCountToStart(2);
    }

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            this.setData(remoteConfig.getRemote().getSettings());
        }
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        if (col == 2 && this.remoteConfig != null && this.remoteConfig.getRemote().isSSD()) {
            return "A Long Region Name__";
        }
        return colPrototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 3 || col == 2 && row < this.remoteConfig.getRemote().getStartReadOnlySettings() - 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Remote r = this.remoteConfig.getRemote();
        Setting setting = r.getSettings()[row];
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return setting.getTitle();
            }
            case 2: {
                if (this.remoteConfig.getRemote().isSSD() && this.remoteConfig.getSSDHexSettings()[row] != null) {
                    Setting.NamedHex nh = this.remoteConfig.getSSDHexSettings()[row];
                    if (nh.getName().equals("directv_rf")) {
                        if (nh.getHex() == null) {
                            System.err.println("DEBUG: Silly nh.getHex detected, just outputting 0");
                            return String.format("%06d", 0);
                        }
                        short[] hexData = nh.getHex().getData();
                        int rfInt = 0;
                        for (int i = 0; i < 4; ++i) {
                            rfInt = (rfInt << 8) + hexData[3 - i];
                        }
                        if (rfInt > 999999) {
                            rfInt = 0;
                        }
                        return String.format("%06d", rfInt);
                    }
                    return nh.getHex();
                }
                int val = setting.getValue();
                Object[] choices = setting.getOptions(r);
                if (choices == null) {
                    return new Integer(val);
                }
                if (val > choices.length) {
                    return null;
                }
                return choices[val];
            }
            case 3: {
                return setting.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Remote r = this.remoteConfig.getRemote();
        Setting setting = r.getSettings()[row];
        if (col == 2) {
            Object[] choices = setting.getOptions(r);
            if (choices == null) {
                Integer oldValue = setting.getValue();
                setting.setValue((Integer)value);
                this.propertyChangeSupport.firePropertyChange("value", oldValue, value);
            } else {
                for (int i = 0; i < choices.length; ++i) {
                    Object oldValue = choices[setting.getValue()];
                    if (!choices[i].equals(value)) continue;
                    if (r.isFDRA() && !this.remoteConfig.isSetToDanish() && setting.getTitle().equals("Language") && i == 5) {
                        String message = "Language cannot be set to Danish in RMIR.  Use Settings on the remote to set it.\nIf Danish does not appear in the list of available languages then it needs to be\ninstalled with RMIR.  Select the menu item\n\"Advanced > XSight operations > Set upgrade source file\"\nand select Danish as the additional language support required.  Then do a download\nfrom the remote and accept the offer of performing an upgrade.";
                        String title = "Additional Language support";
                        JOptionPane.showMessageDialog(this.remoteConfig.getOwner(), message, title, 1);
                        return;
                    }
                    setting.setValue(i);
                    this.propertyChangeSupport.firePropertyChange("value", oldValue, value);
                }
            }
        } else if (col == 3) {
            setting.setHighlight((Color)value);
            this.propertyChangeSupport.firePropertyChange("highlight", null, null);
        }
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 3) {
            return this.colorRenderer;
        }
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                boolean isNormal;
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
                boolean bl = isNormal = row < SettingsTableModel.this.remoteConfig.getRemote().getStartReadOnlySettings() - 1;
                c.setForeground(isSelected ? Color.WHITE : (isNormal ? Color.BLACK : Color.GRAY));
                return c;
            }
        };
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 2) {
            Remote r = this.remoteConfig.getRemote();
            Setting setting = this.remoteConfig.getRemote().getSettings()[row];
            Object[] options = setting.getOptions(r);
            if (options == null) {
                int bits = setting.getNumberOfBits();
                this.intEditor.setMin(0);
                this.intEditor.setMax((1 << bits) - 1);
                return this.intEditor;
            }
            JComboBox cb = (JComboBox)this.comboEditor.getComponent();
            cb.setModel(new DefaultComboBoxModel<Object>(options));
            return this.comboEditor;
        }
        if (col == 3) {
            return this.colorEditor;
        }
        return null;
    }
}

