/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Remote;

public class SetupCode {
    private int value;
    private boolean asHex = false;
    private static int max = 2047;

    public static void setMax(Remote r) {
        max = r.getSegmentTypes() == null ? (r.usesTwoBytePID() ? 4095 : 2047) : (r.usesTwoByteSetupCode() || r.getMaxBuiltInCode() > 4095 ? 8999 : 4095);
    }

    public static int getMax() {
        return max;
    }

    public SetupCode(String s, boolean allowEmpty) {
        if (allowEmpty && s.trim().isEmpty()) {
            this.value = 65535;
        } else {
            this.value = Integer.parseInt(s);
            if (this.value < 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    public SetupCode(int value) {
        this.value = value;
    }

    public void setAsHex(boolean asHex) {
        this.asHex = asHex;
    }

    public boolean isAsHex() {
        return this.asHex;
    }

    public String toString() {
        if (this.asHex) {
            return String.format("%04X", this.value);
        }
        return SetupCode.toString(this.value);
    }

    public static String toString(int value) {
        StringBuilder buff = new StringBuilder();
        if (value < 1000) {
            buff.append('0');
        }
        if (value < 100) {
            buff.append('0');
        }
        if (value < 10) {
            buff.append('0');
        }
        buff.append(Integer.toString(value));
        return buff.toString();
    }

    public int getValue() {
        return this.value;
    }
}

