/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.RFSelectorTableModel;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.SetupCodeRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;

public class SetupCodeEditor
extends SelectAllCellEditor
implements DocumentListener {
    private JTextField textField = null;
    private SetupCodeRenderer setupCodeRenderer = null;

    public SetupCodeEditor(SetupCodeRenderer setupCodeRenderer) {
        this.setupCodeRenderer = setupCodeRenderer;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        TableModel model = table.getModel();
        if (model instanceof DeviceButtonTableModel) {
            DeviceButtonTableModel dbTableModel = (DeviceButtonTableModel)model;
            this.setupCodeRenderer.setDeviceType((DeviceType)dbTableModel.getValueAt(row, 2));
            this.setupCodeRenderer.setDeviceButton((DeviceButton)dbTableModel.getRow(row));
        } else if (model instanceof RFSelectorTableModel) {
            RFSelectorTableModel rfTableModel = (RFSelectorTableModel)model;
            this.setupCodeRenderer.setDeviceType((DeviceType)rfTableModel.getValueAt(row, col - 1));
            this.setupCodeRenderer.setDeviceButton(rfTableModel.getDevBtn());
        }
        this.textField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, col);
        this.textField.getDocument().addDocumentListener(this);
        return this.textField;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void update(DocumentEvent e) {
        int setupCodeValue = 0;
        try {
            setupCodeValue = Integer.parseInt(this.textField.getText());
        }
        catch (NumberFormatException e1) {
            return;
        }
        this.textField.setForeground(this.setupCodeRenderer.getTextColor(setupCodeValue, false));
    }
}

