/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.SetupCode;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class SetupCodeFilter
extends DocumentFilter {
    private JTextField tf;
    private static boolean skipCheck = false;

    public SetupCodeFilter(JTextField tf) {
        this.tf = tf;
    }

    public static void setSkipCheck(boolean skip) {
        skipCheck = skip;
    }

    public static boolean doSkipCheck() {
        return skipCheck;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (string == null) {
            return;
        }
        this.replace(fb, offset, 0, string, attr);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        this.replace(fb, offset, length, "", null);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        int currentLength = doc.getLength();
        String currentContent = doc.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + (text == null ? "" : text) + after;
        this.checkInput(newValue, offset);
        fb.replace(offset, length, text, attrs);
    }

    private void checkInput(String proposedValue, int offset) throws BadLocationException {
        if (skipCheck) {
            return;
        }
        if (proposedValue.length() > 0) {
            boolean isValid = false;
            try {
                int value = Integer.parseInt(proposedValue);
                isValid = value >= 0 && value <= SetupCode.getMax();
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
            if (!isValid) {
                Toolkit.getDefaultToolkit().beep();
                KeyMapMaster.showMessage("Setup code " + proposedValue + " is invalid.  Enter a number between 0 and " + SetupCode.getMax(), this.tf);
                throw new BadLocationException(proposedValue, offset);
            }
            KeyMapMaster.clearMessage(this.tf);
        }
    }
}

