/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.RFSelectorTableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class SetupCodeRenderer
extends DefaultTableCellRenderer {
    private RemoteConfiguration remoteConfig = null;
    private DeviceButton deviceButton = null;
    private DeviceType deviceType = null;
    private boolean isRf = false;

    public SetupCodeRenderer(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
        TableModel model = table.getModel();
        if (model instanceof DeviceButtonTableModel) {
            DeviceButtonTableModel dbTableModel = (DeviceButtonTableModel)model;
            this.deviceType = (DeviceType)dbTableModel.getValueAt(row, 2);
            this.deviceButton = (DeviceButton)dbTableModel.getRow(row);
            this.isRf = this.deviceButton.isRf();
        } else if (model instanceof RFSelectorTableModel) {
            RFSelectorTableModel rfTableModel = (RFSelectorTableModel)model;
            this.deviceType = (DeviceType)rfTableModel.getValueAt(row, col - 1);
            this.deviceButton = rfTableModel.getDevBtn();
            this.isRf = col > 3;
        }
        SetupCode setupCode = (SetupCode)value;
        if (this.deviceType != null && setupCode != null) {
            Color clr = this.getTextColor(setupCode.getValue(), isSelected);
            if (clr != null) {
                c.setForeground(clr);
            }
        } else if (setupCode != null && setupCode.isAsHex()) {
            c.setForeground(isSelected ? Color.WHITE : Color.BLACK);
        }
        return c;
    }

    private boolean isValidUpgrade(int setupCodeValue) {
        for (DeviceUpgrade devUpgrade : this.remoteConfig.getDeviceUpgrades()) {
            if (this.deviceType.getNumber() != devUpgrade.getDeviceType().getNumber() || setupCodeValue != devUpgrade.getSetupCode() || this.isRf != devUpgrade.isRfUpgrade() || !devUpgrade.getButtonIndependent().booleanValue() && this.deviceButton.getButtonIndex() != devUpgrade.getButtonRestriction().getButtonIndex()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(int setupCodeValue) {
        if (setupCodeValue > SetupCode.getMax()) {
            return false;
        }
        Remote remote = this.remoteConfig.getRemote();
        if (this.remoteConfig.getSetupValidation() == Remote.SetupValidation.OFF || this.deviceButton.isConstructed()) {
            return true;
        }
        boolean isBuiltIn = this.isRf ? remote.hasRfSetupCode(this.deviceType, setupCodeValue) : remote.hasSetupCode(this.deviceType, setupCodeValue);
        return isBuiltIn || this.isValidUpgrade(setupCodeValue);
    }

    public Color getTextColor(int setupCodeValue, boolean isSelected) {
        if (this.isValid(setupCodeValue)) {
            return isSelected ? null : JP1TableModel.normalFGColor;
        }
        return isSelected ? Color.YELLOW : Color.RED;
    }

    public void setDeviceButton(DeviceButton deviceButton) {
        this.deviceButton = deviceButton;
        this.isRf = deviceButton.isRf();
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }
}

