/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceEditorPanel;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.FocusSelector;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexFormat;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SetupCodeFilter;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.Value;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;

public class SetupPanel
extends KMPanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
DocumentListener,
FocusListener {
    private JTextField setupCode = null;
    private JComboBox protocolList = null;
    private JTextField protocolID = null;
    private JButton toManual = null;
    private int toManualRow = 0;
    private JFormattedTextField altPID = null;
    private JLabel altPIDLabel = null;
    private JLabel altPIDMessage = null;
    private JTextPane altPIDReason = null;
    private int altPIDRow = 0;
    private int altPIDReasonRow = 0;
    private AltPIDStatus status = null;
    private JLabel preserveLabel = null;
    private JComboBox preserveBox = null;
    private int preserveRow = 0;
    private JTextArea notes = null;
    private JPanel protocolHolder = null;
    private JScrollPane pScrollPane = null;
    private JTextField fixedData = null;
    private JEditorPane protocolNotes = null;
    private DeviceParameter[] parameters = null;
    private TableLayout tl;
    private TableLayout tlPH;
    private boolean updateInProgress = false;
    private JTextComponent controlWithFocus = null;
    private SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private DeviceEditorPanel editor = null;

    public static String getAltPIDReason(int index) {
        String reason = "";
        if (index == 0) {
            return reason;
        }
        switch (index & 0xFF) {
            case 1: {
                reason = "Protocol ID exceeds 01FF, not valid for this remote.  An Alternate PID is required.";
                break;
            }
            case 2: {
                reason = "Protocol is a manual protocol.  Its PID may be changed by setting an Alternate PID.";
                break;
            }
            case 3: {
                reason = "Protocol ID conflicts with a built-in protocol.  To use both this and the built-in protocol in device upgrades, this one needs to be given an Alternate PID.";
                break;
            }
            case 4: {
                reason = "Protocol ID conflicts with existing upgrade.  To use this built-in protocol, edit the conflicting upgrade to give it an Alternate PID.";
                break;
            }
            case 5: {
                reason = "Protocol has already been given an Alternate PID but it is not, or no longer, needed.";
            }
        }
        if ((index & 0x1000) == 4096) {
            if (!reason.isEmpty()) {
                reason = reason + "\n";
            }
            reason = reason + "Protocol has custom code.  To change its PID, first convert it to Manual Settings.";
        }
        String addendum = "";
        switch (index & 0xF00) {
            case 256: {
                addendum = "Protocol already used in another device upgrade, so the Alternate PID has been taken from that upgrade and cannot be changed.";
                break;
            }
            case 512: {
                addendum = "Protocol ID already used in another device upgrade by a different protocol.  An Alternate PID is required.";
                break;
            }
            case 768: {
                addendum = "Protocol ID clashes with that of an unused protocol upgrade.  To keep that upgrade accessible, this protocol needs an Alternate PID.";
                break;
            }
            case 1024: {
                addendum = "Another protocol with same PID and code is already used in another device upgrade, so the Alternate PID has been taken from that upgrade and cannot be changed.";
                break;
            }
            case 1280: {
                addendum = "At least one other upgrade uses this manual protocol, so any alternate PID will also affect those upgrades.";
                break;
            }
            case 2048: {
                break;
            }
            case 2304: {
                addendum = "Protocol already used by another device upgrade without an Alternate PID, so an alternate cannot be given for this upgrade.";
                break;
            }
            case 2560: {
                addendum = "This case should not occur!";
                break;
            }
            case 2816: {
                break;
            }
            case 3072: {
                addendum = "Another protocol with same PID and code is already used in another device upgrade without an Alternate PID, so an alternate cannot be given for this upgrade.";
            }
        }
        if (!addendum.isEmpty()) {
            reason = reason + (reason.isEmpty() ? addendum : "\n" + addendum);
        }
        return reason;
    }

    public SetupPanel(DeviceEditorPanel editor, DeviceUpgrade deviceUpgrade) {
        super("Setup", deviceUpgrade);
        this.editor = editor;
        TitledBorder border = BorderFactory.createTitledBorder("Protocol Parameters");
        this.pScrollPane = new JScrollPane();
        this.pScrollPane.setBorder(border);
        this.pScrollPane.setHorizontalScrollBarPolicy(31);
        Insets insets = border.getBorderInsets(this.pScrollPane);
        double bl = insets.left + 10;
        double br = insets.right;
        double b = 10.0;
        double i = 5.0;
        double v = 20.0;
        double c = 10.0;
        double f = -1.0;
        double p = -2.0;
        double[][] size = new double[][]{{b, bl, p, b, p, br, c, f, b}, {b, p, v, 0.0, 0.0, p, i, p, 0.0, 0.0, 0.0, 0.0, 0.0, v, p, b, f, 0.0, b}};
        this.tl = new TableLayout(size);
        this.setLayout(this.tl);
        double[][] sizePH = new double[][]{{b, p, b, f}, {p}};
        this.tlPH = new TableLayout(sizePH);
        int row = 1;
        JLabel label = new JLabel("Setup Code:", 4);
        this.add((Component)label, "2, " + row);
        this.setupCode = new JTextField();
        SetupCodeFilter filter = new SetupCodeFilter(this.setupCode);
        ((AbstractDocument)this.setupCode.getDocument()).setDocumentFilter(filter);
        this.setupCode.getDocument().addDocumentListener(this);
        FocusSelector.selectOnFocus(this.setupCode);
        label.setLabelFor(this.setupCode);
        this.setupCode.setToolTipText("Enter the desired setup code (between 0 and " + SetupCode.getMax() + ") for the device upgrade.");
        this.add((Component)this.setupCode, "4, " + row);
        this.preserveLabel = new JLabel("Preserve:", 4);
        String[] choices = new String[]{"OBC and function parameters", "EFC and function hex"};
        this.preserveBox = new JComboBox<String>(choices);
        this.preserveLabel.setLabelFor(this.preserveBox);
        this.preserveRow = row += 2;
        this.preserveBox.setToolTipText("Select what to preserve when changing protocols");
        this.preserveBox.setSelectedIndex(0);
        this.preserveBox.addActionListener(this);
        if (Boolean.parseBoolean(JP1Frame.getProperties().getProperty("enablePreserveSelection", "false"))) {
            this.add((Component)this.preserveLabel, "2, " + this.preserveRow);
            this.add((Component)this.preserveBox, "4, " + this.preserveRow);
            this.tl.setRow(this.preserveRow, p);
            this.tl.setRow(this.preserveRow + 1, i);
        }
        label = new JLabel("Protocol:", 4);
        this.add((Component)label, "2, " + (row += 2));
        this.protocolList = new JComboBox();
        this.protocolList.addActionListener(this);
        label.setLabelFor(this.protocolList);
        this.protocolList.setMaximumRowCount(25);
        this.protocolList.setToolTipText("Select the protocol to be used for this device upgrade from the drop-down list.");
        this.add((Component)this.protocolList, "4, " + row);
        label = new JLabel("Protocol ID:", 4);
        this.add((Component)label, "2, " + (row += 2));
        this.protocolID = new JTextField();
        label.setLabelFor(this.protocolID);
        this.protocolID.setEditable(false);
        this.protocolID.setToolTipText("This is the protocol ID (PID) that corresponds to the selected protocol.");
        this.add((Component)this.protocolID, "4, " + row);
        this.toManualRow = row += 2;
        this.toManual = new JButton("Convert to Manual");
        this.toManual.setToolTipText("Convert custom code to Manual Settings protocol");
        this.toManual.addActionListener(this);
        this.toManual.setVisible(false);
        this.add((Component)this.toManual, "4, " + row);
        this.altPIDRow = row += 2;
        this.altPIDLabel = new JLabel("Alternate PID:", 4);
        this.add((Component)this.altPIDLabel, "2, " + row);
        this.altPID = new JFormattedTextField(new HexFormat(0, 2));
        this.altPID.addPropertyChangeListener("value", this);
        this.altPIDLabel.setLabelFor(this.altPID);
        this.altPID.setVisible(false);
        this.altPIDLabel.setVisible(false);
        this.altPID.setToolTipText("An alternate PID to be used instead of the main PID.");
        this.add((Component)this.altPID, "4, " + row);
        this.altPIDMessage = new JLabel("Prototype message");
        this.altPIDMessage.setForeground(Color.RED);
        this.tl.setRow(++row, this.altPIDMessage.getPreferredSize().height);
        this.add((Component)this.altPIDMessage, "4, " + row);
        this.tl.setRow(++row, v - (double)this.altPIDMessage.getPreferredSize().height);
        this.altPIDMessage.setText("");
        this.protocolHolder = new JPanel(this.tlPH);
        this.pScrollPane.setViewportView(this.protocolHolder);
        this.add((Component)this.pScrollPane, "1, " + ++row + ", 5, " + row);
        label = new JLabel("Fixed Data:", 4);
        this.fixedData = new JTextField();
        this.fixedData.setEditable(false);
        this.protocolHolder.add((Component)label, "1, 0");
        this.protocolHolder.add((Component)this.fixedData, "3, 0");
        this.notes = new JTextArea(5, 50);
        this.notes.setToolTipText("Enter any notes about this device upgrade.");
        this.notes.setLineWrap(true);
        this.notes.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.notes);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Upgrade Notes"), scrollPane.getBorder()));
        this.notes.getDocument().addDocumentListener(this);
        new TextPopupMenu(this.notes);
        this.add((Component)scrollPane, "7, 1, 7, " + row);
        row += 2;
        this.protocolNotes = new JEditorPane();
        this.protocolNotes.setBackground(label.getBackground());
        this.protocolNotes.setToolTipText("Notes about the selected protocol.");
        this.protocolNotes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.protocolNotes.setEditable(false);
        scrollPane = new JScrollPane(this.protocolNotes);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Protocol Notes"), scrollPane.getBorder()));
        this.add((Component)scrollPane, "1, " + row + ", 7, " + row);
        ++row;
        this.altPIDReason = new JTextPane();
        this.altPIDReason.setEditable(false);
        this.altPIDReason.setBackground(label.getBackground());
        Font font = this.altPIDReason.getFont();
        Font font2 = font.deriveFont(1, 12.0f);
        this.altPIDReason.setFont(font2);
        this.altPIDReason.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.altPIDReasonRow = row;
        JP1Frame.getProperties().addPropertyChangeListener("enablePreserveSelection", this);
    }

    private void showToManual() {
        boolean isCustom = this.deviceUpgrade.isCustom();
        this.toManual.setVisible(isCustom);
        this.tl.setRow(this.toManualRow - 1, isCustom ? 5.0 : 0.0);
        this.tl.setRow(this.toManualRow, isCustom ? -2.0 : 0.0);
    }

    private void showAltPID() {
        this.status = this.deviceUpgrade.testAltPID();
        this.altPIDLabel.setVisible(this.status.visible);
        this.altPID.setVisible(this.status.visible);
        this.tl.setRow(this.altPIDRow - 1, this.status.visible ? 5.0 : 0.0);
        this.tl.setRow(this.altPIDRow, this.status.visible ? -2.0 : 0.0);
        this.altPID.setEditable(this.status.editable);
        if (this.status.hasValue) {
            Hex hx = new Hex(2);
            hx.put(this.status.value, 0);
            this.altPID.setValue(hx);
        }
        if (this.status.visible && this.status.required) {
            this.protocolID.setText(this.protocolID.getText() + " : ALT PID REQUIRED");
        }
        if (this.editor.getOwner().isVisible()) {
            this.setAltPIDReason();
        }
    }

    public void setAltPIDReason() {
        if (this.status.msgIndex == 0 && this.tl.getRow(this.altPIDReasonRow) != 0.0) {
            this.remove(this.altPIDReason);
            this.tl.setRow(this.altPIDReasonRow, 0.0);
        } else if (this.status.msgIndex > 0 && this.tl.getRow(this.altPIDReasonRow) == 0.0) {
            this.add((Component)this.altPIDReason, "1, " + this.altPIDReasonRow + ", 7, " + this.altPIDReasonRow);
            this.tl.setRow(this.altPIDReasonRow, -2.0);
        }
        this.altPIDReason.setText(SetupPanel.getAltPIDReason(this.status.msgIndex));
    }

    @Override
    public void update() {
        if (this.deviceUpgrade == null) {
            return;
        }
        this.updateInProgress = true;
        Protocol p = this.deviceUpgrade.getProtocol();
        Remote remote = this.deviceUpgrade.getRemote();
        int val = this.deviceUpgrade.getSetupCode();
        if (SetupCodeFilter.doSkipCheck() && val > SetupCode.getMax()) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.setupCode, "Setup code " + val + " is invalid.  Enter a number between 0 and " + SetupCode.getMax());
            this.deviceUpgrade.setSetupCode(0);
            val = 0;
        }
        String valStr = this.deviceUpgrade.hasSerial() ? "" + val : SetupCode.toString(val);
        this.setupCode.setText(val < 0 ? null : valStr);
        this.setupCode.setToolTipText("Enter the desired setup code (between 0 and " + SetupCode.getMax() + ") for the device upgrade.");
        List<Protocol> protocols = ProtocolManager.getProtocolManager().getProtocolsForRemote(remote);
        if (p != null && !protocols.contains(p)) {
            protocols = new ArrayList<Protocol>(protocols);
            protocols.add(p);
        }
        this.protocolList.setModel(new DefaultComboBoxModel<Object>(protocols.toArray()));
        if (p == null) {
            this.protocolList.setSelectedIndex(-1);
            this.updateInProgress = false;
            return;
        }
        Value[] vals = this.deviceUpgrade.getParmValues();
        p.setDeviceParms(vals);
        this.updateParameters();
        this.protocolList.setSelectedItem(p);
        this.protocolID.setText(p.getID(remote, false).toString());
        this.notes.setText(this.deviceUpgrade.getNotes());
        this.fixedData.setText(p.getFixedData(vals).toString());
        this.updateProtocolNotes(p.getNotes());
        this.showAltPID();
        this.showToManual();
        if (p instanceof ManualProtocol && p.getAlternatePID() != null) {
            this.altPID.setValue(p.getAlternatePID());
        } else {
            this.altPID.setValue(p.getRemoteAltPID().get(remote.getSignature()));
        }
        this.setAltPIDMessage();
        this.updateInProgress = false;
    }

    public void updateParameters() {
        DeviceParameter[] newParameters = this.deviceUpgrade.getProtocol().getDeviceParameters();
        int maxWidth = this.altPIDLabel.getPreferredSize().width;
        int offset = this.pScrollPane.getVerticalScrollBar().getPreferredSize().width + 5;
        if (this.parameters != newParameters) {
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].removeListener(this);
                    this.protocolHolder.remove(this.parameters[i].getLabel());
                    this.protocolHolder.remove(this.parameters[i].getComponent());
                    this.tlPH.deleteRow(0);
                    this.tlPH.deleteRow(0);
                }
            }
            this.parameters = newParameters;
            if (this.parameters != null) {
                int row = 0;
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].addListener(this);
                    this.tlPH.insertRow(row, -2.0);
                    JLabel label = this.parameters[i].getLabel();
                    maxWidth = Math.max(maxWidth, label.getPreferredSize().width);
                    this.protocolHolder.add((Component)label, "1, " + row);
                    this.protocolHolder.add((Component)this.parameters[i].getComponent(), "3, " + row);
                    int n = ++row;
                    ++row;
                    this.tlPH.insertRow(n, 5.0);
                }
                int maxRows = 7;
                int maxHeight = maxRows * (this.fixedData.getPreferredSize().height + 5);
                Insets insets = this.pScrollPane.getBorder().getBorderInsets(this.pScrollPane);
                this.pScrollPane.setPreferredSize(null);
                Dimension d = this.pScrollPane.getPreferredSize();
                if (d.height > (maxHeight += insets.top + insets.bottom)) {
                    offset = 0;
                }
                d.height = maxHeight;
                this.pScrollPane.setPreferredSize(d);
                this.tl.setColumn(2, maxWidth + offset);
                this.tlPH.setColumn(1, maxWidth + offset);
            }
        }
    }

    public void updateFixedData() {
        Protocol p = this.deviceUpgrade.getProtocol();
        p.initializeParms();
        this.deviceUpgrade.setParmValues(p.getDeviceParmValues());
        this.fixedData.setText(p.getFixedData(this.deviceUpgrade.getParmValues()).toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.protocolList) {
            this.protocolList.hidePopup();
            Protocol newProtocol = this.getSelectedProtocol();
            Protocol oldProtocol = this.deviceUpgrade.getProtocol();
            RemoteConfiguration remoteConfig = this.deviceUpgrade.getRemoteConfig();
            if (newProtocol != oldProtocol) {
                if (this.deviceUpgrade.setProtocol(newProtocol)) {
                    Remote remote = this.deviceUpgrade.getRemote();
                    this.protocolID.setText(newProtocol.getID(remote, false).toString());
                    this.altPID.setValue(newProtocol.getRemoteAltPID().get(remote.getSignature()));
                    this.showAltPID();
                    this.showToManual();
                    this.setAltPIDMessage();
                    this.updateParameters();
                    this.fixedData.setText(newProtocol.getFixedData(newProtocol.getDeviceParmValues()).toString());
                    this.updateProtocolNotes(newProtocol.getNotes());
                    this.revalidate();
                    this.deviceUpgrade.checkSize();
                    this.propertyChangeSupport.firePropertyChange("protocol", oldProtocol, newProtocol);
                } else {
                    this.protocolList.removeActionListener(this);
                    this.protocolList.setSelectedItem(oldProtocol);
                    this.protocolList.addActionListener(this);
                }
            } else if (!this.updateInProgress && remoteConfig != null) {
                String title = "Multiple custom protocols";
                String message = "You have reselected the existing protocol for this device upgrade\nand there is more than one protocol upgrade in this remote that\ncan act as custom code for it.  Do you want to change to a different\ncustom code?\n\nRepeating this and selecting YES each time will cycle through all\navailable compatible custom codes.";
                ProtocolUpgrade pu = oldProtocol.getCustomUpgrade(remoteConfig, false);
                if (pu != null && oldProtocol.matched() && !pu.getCode().equals(this.deviceUpgrade.getCode()) && JOptionPane.showConfirmDialog(null, message, title, 0, 3) == 0) {
                    String proc = remoteConfig.getRemote().getProcessor().getEquivalentName();
                    oldProtocol.newCustomCode = pu;
                    oldProtocol.customCode.put(proc, pu.getCode());
                }
            }
        } else if (source == this.preserveBox) {
            this.deviceUpgrade.setPreserveOBC(this.preserveBox.getSelectedIndex() == 0);
        } else if (source == this.toManual) {
            JFrame frame = this.editor.getOwner();
            if (frame instanceof DeviceUpgradeEditor) {
                String message = "Do you want to save this device upgrade as a separate .rmdu file before the\nprotocol is converted to Manual Settings?\n\nIn the conversion, you lose the device parameters of the original protocol, which\nmakes the device upgrade more difficult to edit.  By saving it, you preserve these\nparameters in a file that can be edited with RM and then loaded into RMIR.";
                String title = "Convert Custom Code to Manual Settings";
                int ans = JOptionPane.showConfirmDialog(null, message, title, 1, 2);
                if (ans == 2) {
                    return;
                }
                if (ans == 0) {
                    try {
                        ((DeviceUpgradeEditor)frame).save();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            Remote remote = this.deviceUpgrade.getRemote();
            this.deviceUpgrade.originalProtocol = this.deviceUpgrade.protocol;
            Hex code = null;
            try {
                code = (Hex)this.deviceUpgrade.originalProtocol.getCustomCode(remote.getProcessor()).clone();
            }
            catch (CloneNotSupportedException e1) {
                e1.printStackTrace();
            }
            this.deviceUpgrade.convertedProtocol = this.deviceUpgrade.originalProtocol.convertToManual(remote, this.deviceUpgrade.getParmValues(), code);
            ProtocolManager.getProtocolManager().add(this.deviceUpgrade.convertedProtocol);
            this.deviceUpgrade.changeProtocol(this.deviceUpgrade.originalProtocol, this.deviceUpgrade.convertedProtocol);
            this.update();
        } else {
            this.updateFixedData();
        }
    }

    protected void updateProtocolNotes(String text) {
        String contentType = "text/html";
        if (text != null && !text.startsWith("<")) {
            text = text.replaceAll("\\n", "<br>");
        }
        EditorKit kit = this.protocolNotes.getEditorKitForContentType(contentType);
        this.protocolNotes.setEditorKit(kit);
        this.protocolNotes.setText(text);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.protocolNotes.getDocument()).getStyleSheet().addRule(bodyRule);
        this.protocolNotes.setCaretPosition(0);
        this.protocolNotes.revalidate();
    }

    public Protocol getSelectedProtocol() {
        Protocol protocol = (Protocol)this.protocolList.getSelectedItem();
        return protocol;
    }

    @Override
    public void commit() {
        if (this.deviceUpgrade.getProtocol() != null) {
            this.deviceUpgrade.getProtocol().updateFunctions(this.deviceUpgrade.getFunctions());
        }
    }

    private void updateNotes() {
        this.deviceUpgrade.setNotes(this.notes.getText());
    }

    private void updateSetupCode() {
        String text = this.setupCode.getText();
        if (text.equals("")) {
            return;
        }
        int val = Integer.parseInt(this.setupCode.getText());
        int oldSetupCode = this.deviceUpgrade.getSetupCode();
        this.deviceUpgrade.setSetupCode(val);
        this.propertyChangeSupport.firePropertyChange("setupCode", oldSetupCode, val);
    }

    @Override
    public void release() {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].removeListener(this);
        }
    }

    private void docChanged(DocumentEvent e) {
        if (!this.updateInProgress) {
            Document doc = e.getDocument();
            if (doc == this.notes.getDocument()) {
                this.updateNotes();
            } else if (doc == this.setupCode.getDocument()) {
                this.updateSetupCode();
            } else {
                this.updateFixedData();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        JP1Frame.clearMessage(this.controlWithFocus);
        this.controlWithFocus = (JTextComponent)e.getSource();
        JP1Frame.clearMessage(this.controlWithFocus);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.updateInProgress) {
            this.updateFixedData();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("enablePreserveSelection")) {
            boolean oldValue = Boolean.parseBoolean((String)event.getOldValue());
            boolean newValue = Boolean.parseBoolean((String)event.getNewValue());
            if (oldValue && !newValue) {
                this.remove(this.preserveLabel);
                this.remove(this.preserveBox);
                this.tl.setRow(this.preserveRow, 0.0);
                this.tl.setRow(this.preserveRow + 1, 0.0);
            } else {
                this.add((Component)this.preserveLabel, "2, " + this.preserveRow);
                this.add((Component)this.preserveBox, "4, " + this.preserveRow);
                this.tl.setRow(this.preserveRow, -2.0);
                this.tl.setRow(this.preserveRow + 1, 5.0);
            }
        } else if (event.getSource() == this.altPID) {
            Hex pid = (Hex)this.altPID.getValue();
            if (pid == null) {
                return;
            }
            if (pid.length() == 1) {
                short val = pid.getData()[0];
                pid = new Hex(2);
                pid.getData()[1] = val;
                this.altPID.setValue(pid);
                return;
            }
            if (this.deviceUpgrade.originalProtocol == null && this.deviceUpgrade.protocol instanceof ManualProtocol) {
                this.deviceUpgrade.originalProtocol = this.deviceUpgrade.protocol;
            }
            if (this.deviceUpgrade.originalProtocol != null && this.deviceUpgrade.convertedProtocol == null) {
                this.deviceUpgrade.convertedProtocol = new ManualProtocol(((ManualProtocol)this.deviceUpgrade.originalProtocol).getIniSection());
                this.deviceUpgrade.setProtocol(this.deviceUpgrade.convertedProtocol);
            }
            this.deviceUpgrade.getProtocol().setAltPID(this.deviceUpgrade.getRemote(), pid);
            this.setAltPIDMessage();
            this.update();
        } else if (!this.updateInProgress) {
            this.updateSetupCode();
        }
    }

    private boolean setAltPIDMessage() {
        boolean valid = true;
        if (this.status.visible) {
            Hex pid = (Hex)this.altPID.getValue();
            if (pid == null) {
                pid = new Hex(0);
            }
            Remote remote = this.deviceUpgrade.getRemote();
            RemoteConfiguration remoteConfig = this.deviceUpgrade.getRemoteConfig();
            List<Protocol> builtIn = ProtocolManager.getProtocolManager().getBuiltinProtocolsForRemote(remote, pid);
            if (pid.length() > 1 && pid.get(0) > 511 && !remote.usesTwoBytePID()) {
                this.altPIDMessage.setText("PID > 01FF not supported");
                this.altPID.setForeground(Color.RED);
                valid = false;
            } else if (!builtIn.isEmpty()) {
                this.altPIDMessage.setText("Conflicts with built-in protocol");
                this.altPID.setForeground(Color.RED);
                valid = false;
            } else if (this.status != null && this.status.required && pid.length() == 0) {
                this.altPIDMessage.setText("Alternate PID cannot be null");
                this.altPID.setForeground(Color.RED);
                valid = false;
            } else if (remoteConfig != null) {
                for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                    if (du == this.deviceUpgrade.getBaseUpgrade() || du.getProtocol() == this.deviceUpgrade.protocol || du.getProtocol() == this.deviceUpgrade.originalProtocol || !du.getProtocol().getID(remote).equals(this.deviceUpgrade.getProtocol().getID(remote))) continue;
                    this.altPIDMessage.setText("Conflicts with existing upgrade");
                    this.altPID.setForeground(Color.RED);
                    valid = false;
                    break;
                }
            }
            if (valid) {
                this.altPIDMessage.setText("");
                this.altPID.setForeground(Color.BLACK);
                if (this.deviceUpgrade.getProtocol().getCustomUpgrade(remoteConfig, false) != null) {
                    this.altPIDMessage.setText("Conflicts with protocol upgrade");
                }
            }
        } else if (this.status.required) {
            valid = false;
            this.altPIDMessage.setText("PID in use, Alt PID not available");
        } else {
            this.altPIDMessage.setText("");
        }
        this.editor.tabbedPane.setEnabled(valid);
        JFrame frame = this.editor.getOwner();
        if (frame instanceof DeviceUpgradeEditor) {
            DeviceUpgradeEditor editor = (DeviceUpgradeEditor)frame;
            editor.okButton.setEnabled(valid);
            editor.saveAsButton.setEnabled(valid);
        } else if (frame instanceof KeyMapMaster) {
            KeyMapMaster km = (KeyMapMaster)frame;
            km.saveItem.setEnabled(valid && this.deviceUpgrade.getFile() != null);
            km.saveAsItem.setEnabled(valid);
        }
        return valid;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null && listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public static class AltPIDStatus {
        public boolean visible = true;
        public boolean required = false;
        public boolean editable = true;
        public boolean hasValue = false;
        public int value = 0;
        public int msgIndex = 0;
    }
}

