/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ParameterTokenizer;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.List;

public class SoftDevices
extends RDFParameter {
    private boolean use = true;
    private boolean allowEmptyButtonSettings = false;
    private boolean setupCodesOnly = false;
    private int countAddress = 0;
    private int sequenceAddress = 0;

    @Override
    public void parse(String text, Remote remote) throws Exception {
        List<String> settings = ParameterTokenizer.getTokens(text);
        String useStr = settings.get(0);
        if (useStr.equalsIgnoreCase("SetupCodesOnly")) {
            this.setupCodesOnly = true;
        } else {
            this.use = RDFReader.parseFlag(settings.get(0));
        }
        if (this.use && settings.size() > 1) {
            this.allowEmptyButtonSettings = RDFReader.parseFlag(settings.get(1));
            if (settings.size() > 2) {
                this.countAddress = RDFReader.parseNumber(settings.get(2));
            }
            if (settings.size() > 3) {
                this.sequenceAddress = RDFReader.parseNumber(settings.get(3));
            }
        }
    }

    public boolean inUse() {
        return this.use;
    }

    public boolean isSetupCodesOnly() {
        return this.setupCodesOnly;
    }

    public boolean getAllowEmptyButtonSettings() {
        return this.allowEmptyButtonSettings;
    }

    public int getCountAddress() {
        return this.countAddress;
    }

    public boolean usesSequence() {
        return this.sequenceAddress != 0;
    }

    public int getSequenceIndex(int position, short[] data) {
        int sequence = data[this.sequenceAddress + position];
        if (sequence == 255) {
            sequence = -1;
        }
        return sequence;
    }

    public void setSequenceIndex(int index, int position, short[] data) {
        if (index == -1) {
            index = 255;
        }
        data[this.sequenceAddress + position] = (short)index;
    }

    public int getSequencePosition(int index, int limit, short[] data) {
        int position;
        for (position = 0; position < limit && data[this.sequenceAddress + position] != index; ++position) {
        }
        return position < limit ? position : -1;
    }

    public boolean deleteSequenceIndex(int index, int limit, short[] data) {
        int p = this.getSequencePosition(index, limit, data);
        if (p == -1) {
            return false;
        }
        while (p < limit - 1) {
            data[this.sequenceAddress + p] = data[this.sequenceAddress + p + 1];
            ++p;
        }
        data[this.sequenceAddress + limit - 1] = 255;
        return true;
    }

    public void insertSequenceIndex(int index, int position, int limit, short[] data) {
        for (int p = limit - 1; p > position; --p) {
            data[this.sequenceAddress + p] = data[this.sequenceAddress + p - 1];
        }
        data[this.sequenceAddress + position] = (short)index;
    }

    public boolean usesFilledSlotCount() {
        return this.countAddress != 0;
    }

    public int getFilledSlotCount(short[] data) {
        return data[this.countAddress];
    }

    public void setFilledSlotCount(int count, short[] data) {
        if (this.countAddress != 0) {
            data[this.countAddress] = (short)count;
        }
    }
}

