/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.FocusSelector;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyCodeListRenderer;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroButtonRenderer;
import com.hifiremote.jp1.PauseFunction;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SpecialProtocol;
import com.hifiremote.jp1.SpecialProtocolFunction;
import com.hifiremote.jp1.ToadTogFunction;
import com.hifiremote.jp1.UserSpecialFunction;
import com.hifiremote.jp1.WrappingSpinnerNumberModel;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;

public class SpecialFunctionDialog
extends JDialog
implements ActionListener,
FocusListener,
ItemListener,
ListSelectionListener {
    private JComboBox boundDevice = new JComboBox();
    private JComboBox boundKey = new JComboBox();
    private JCheckBox shift = new JCheckBox();
    private JCheckBox xShift = new JCheckBox();
    private JComboBox type = new JComboBox();
    private JPanel parameterCard = new JPanel(new CardLayout());
    private JTextField hexField = new JTextField(12);
    private JTextField modeName = new JTextField(10);
    private JComboBox deviceType = new JComboBox();
    private JFormattedTextField setupCode = null;
    private JSpinner duration = new JSpinner(new WrappingSpinnerNumberModel(0, 0, 15, 1));
    private PauseField pauseDuration = null;
    private JComboBox toggle = null;
    private JComboBox condition = new JComboBox<String>(ToadTogFunction.styleStrings);
    private JComboBox macroKey = new JComboBox();
    private KeyCodeListRenderer keyCodeRenderer = new KeyCodeListRenderer();
    private JComboBox uldkpDuration = null;
    private JLabel firstKeyLabel = new JLabel();
    private JComboBox firstMacroKey = new JComboBox();
    private JLabel secondKeyLabel = new JLabel();
    private JComboBox secondMacroKey = new JComboBox();
    private Box macroBox = null;
    private JLabel availableLabel = new JLabel("Available keys:");
    private JList availableButtons = new JList();
    private JButton add = new JButton("Add");
    private JButton insert = new JButton("Insert");
    private JButton addShift = new JButton("Add Shift");
    private JButton insertShift = new JButton("Ins Shift");
    private JButton addXShift = new JButton("Add xShift");
    private JButton insertXShift = new JButton("Ins xShift");
    private MacroButtonRenderer macroButtonRenderer = new MacroButtonRenderer();
    private JPanel firstKeysPanel = null;
    private JLabel firstMacroLabel = new JLabel("Short keys:");
    private JList firstMacroButtons = new JList();
    private JList targetList = this.firstMacroButtons;
    private JButton firstMoveUp = new JButton("Move up");
    private JButton firstMoveDown = new JButton("Move down");
    private JButton firstRemove = new JButton("Remove");
    private JButton firstClear = new JButton("Clear");
    private JButton firstDeselect = new JButton("Clear selection");
    private JPanel secondKeysPanel = null;
    private JLabel secondMacroLabel = new JLabel("Long keys:");
    private JList secondMacroButtons = new JList();
    private JButton secondMoveUp = new JButton("Move up");
    private JButton secondMoveDown = new JButton("Move down");
    private JButton secondRemove = new JButton("Remove");
    private JButton secondClear = new JButton("Clear");
    private JButton secondDeselect = new JButton("Clear selection");
    private JTextArea notes = new JTextArea(2, 2);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel paramPanel = null;
    private RemoteConfiguration config = null;
    private SpecialProtocolFunction function = null;
    private Hex cmd = null;
    public static SpecialFunctionDialog dialog = null;
    private Color activeColor;
    private Color inactiveColor;
    private Color disabledColor;
    private List<String> specialFunctionsByRDFName = new ArrayList<String>();
    private Box noteBox = null;

    public static SpecialProtocolFunction showDialog(JFrame frame, SpecialProtocolFunction function, RemoteConfiguration config) {
        if (dialog == null) {
            dialog = new SpecialFunctionDialog(frame);
        }
        dialog.setRemoteConfiguration(config);
        dialog.setFunction(function);
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        dialog.enableButtons();
        dialog.setVisible(true);
        return SpecialFunctionDialog.dialog.function;
    }

    public static void reset() {
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
        }
    }

    private void addToBox(JComponent j, Container c) {
        j.setAlignmentX(0.0f);
        c.add(j);
    }

    private SpecialFunctionDialog(JFrame frame) {
        super(frame, "Special Function", true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        this.addToBox(panel, contentPane);
        panel.setBorder(BorderFactory.createTitledBorder("Bound Key"));
        panel.add(new JLabel("Device:"));
        panel.add(this.boundDevice);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(new JLabel("Key:"));
        panel.add(this.boundKey);
        this.boundKey.addActionListener(this);
        this.shift.addActionListener(this);
        panel.add(this.shift);
        this.xShift.addActionListener(this);
        panel.add(this.xShift);
        this.paramPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.paramPanel.add(Box.createHorizontalStrut(5));
        this.addToBox(this.paramPanel, contentPane);
        this.paramPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        Box box = Box.createVerticalBox();
        this.addToBox(new JLabel("Type:"), box);
        this.addToBox(this.type, box);
        this.type.setRenderer(new FunctionTypeRenderer());
        this.type.addActionListener(this);
        this.paramPanel.add(box);
        this.paramPanel.add(this.parameterCard);
        panel = new JPanel();
        this.parameterCard.add((Component)panel, "Empty");
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "ModeName");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Text:"), box);
        this.addToBox(this.modeName, box);
        panel.add(box);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "Multiplex");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Device Type:"), box);
        this.addToBox(this.deviceType, box);
        panel.add(box);
        DecimalFormat format = new DecimalFormat("0000");
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(new Integer(0));
        formatter.setMaximum(new Integer(SetupCode.getMax()));
        this.setupCode = new JFormattedTextField(formatter);
        this.setupCode.setColumns(4);
        this.setupCode.setToolTipText(JTableX.getHtmlToolTip("The maximum setup code value<br>for this remote is " + SetupCode.getMax()));
        FocusSelector.selectOnFocus(this.setupCode);
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Setup Code:"), box);
        this.addToBox(this.setupCode, box);
        panel.add(box);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "Duration");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Duration:"), box);
        this.addToBox(this.duration, box);
        panel.add(box);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "ToadTog");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Toggle #:"), box);
        Integer[] toggles = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
        this.toggle = new JComboBox<Integer>(toggles);
        this.addToBox(this.toggle, box);
        panel.add(box);
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Condition:"), box);
        this.addToBox(this.condition, box);
        this.condition.addActionListener(this);
        panel.add(box);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "Pause");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Duration:"), box);
        Box durationBox = Box.createHorizontalBox();
        formatter = new NumberFormatter(PauseFunction.pauseFormat);
        formatter.setValueClass(Float.class);
        this.pauseDuration = new PauseField(formatter);
        durationBox.add(this.pauseDuration);
        durationBox.add(Box.createHorizontalStrut(5));
        durationBox.add(new JLabel("secs"));
        this.addToBox(durationBox, box);
        panel.add(box);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "Hex");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Hex:"), box);
        this.addToBox(this.hexField, box);
        panel.add(box);
        this.noteBox = Box.createVerticalBox();
        JLabel label = new JLabel("Note: A decimal point is");
        Font font = label.getFont();
        Font font2 = font.deriveFont(font.getSize2D() - 1.0f);
        label.setFont(font2);
        this.noteBox.add(label);
        label = new JLabel("allowed in the duration");
        label.setFont(font2);
        this.noteBox.add(label);
        label = new JLabel("value");
        label.setFont(font2);
        this.noteBox.add(label);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.noteBox);
        this.paramPanel.add(Box.createVerticalStrut(this.noteBox.getPreferredSize().height));
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "UDSM");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Key w/ Macro:"), box);
        this.addToBox(this.macroKey, box);
        panel.add(box);
        this.macroKey.setRenderer(this.keyCodeRenderer);
        panel = new JPanel(new FlowLayout(0, 10, 0));
        this.parameterCard.add((Component)panel, "ULDKP");
        box = Box.createVerticalBox();
        this.addToBox(new JLabel("Duration:"), box);
        Integer[] durations = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this.uldkpDuration = new JComboBox<Integer>(durations);
        this.addToBox(this.uldkpDuration, box);
        panel.add(box);
        box = Box.createVerticalBox();
        this.addToBox(this.firstKeyLabel, box);
        this.addToBox(this.firstMacroKey, box);
        panel.add(box);
        this.firstMacroKey.setRenderer(this.keyCodeRenderer);
        box = Box.createVerticalBox();
        this.addToBox(this.secondKeyLabel, box);
        this.addToBox(this.secondMacroKey, box);
        panel.add(box);
        this.secondMacroKey.setRenderer(this.keyCodeRenderer);
        this.macroBox = Box.createHorizontalBox();
        this.macroBox.setBorder(BorderFactory.createTitledBorder("Macro Definition:"));
        this.addToBox(this.macroBox, contentPane);
        JPanel availableBox = new JPanel(new BorderLayout());
        this.macroBox.add(availableBox);
        availableBox.add((Component)this.availableLabel, "North");
        this.availableButtons.setFixedCellWidth(100);
        availableBox.add((Component)new JScrollPane(this.availableButtons), "Center");
        this.availableButtons.setSelectionMode(0);
        this.availableButtons.addListSelectionListener(this);
        this.availableButtons.setToolTipText(JTableX.getHtmlToolTip("Double-click to add/insert.<br>Shift/double-click to add/insert shifted.<br>This will insert if a macro key is selected, add otherwise.<br>Right-click to clear macro key selection.<br><br>These actions all concern the macro that is currently active."));
        this.activeColor = this.availableButtons.getBackground();
        this.availableButtons.setEnabled(false);
        this.disabledColor = this.availableButtons.getBackground();
        this.inactiveColor = new Color(216, 228, 248);
        panel = new JPanel(new GridLayout(3, 2, 2, 2));
        availableBox.add((Component)panel, "South");
        this.add.addActionListener(this);
        panel.add(this.add);
        this.insert.addActionListener(this);
        panel.add(this.insert);
        this.addShift.addActionListener(this);
        panel.add(this.addShift);
        this.insertShift.addActionListener(this);
        panel.add(this.insertShift);
        this.addXShift.addActionListener(this);
        panel.add(this.addXShift);
        this.insertXShift.addActionListener(this);
        panel.add(this.insertXShift);
        this.macroBox.add(Box.createHorizontalStrut(10));
        this.firstKeysPanel = new JPanel(new BorderLayout());
        this.macroBox.add(this.firstKeysPanel);
        this.firstKeysPanel.add((Component)this.firstMacroLabel, "North");
        this.firstMacroButtons.setFixedCellWidth(100);
        this.firstKeysPanel.add((Component)new JScrollPane(this.firstMacroButtons), "Center");
        this.firstMacroButtons.setModel(new DefaultListModel());
        this.firstMacroButtons.setSelectionMode(0);
        this.firstMacroButtons.setCellRenderer(this.macroButtonRenderer);
        this.firstMacroButtons.addListSelectionListener(this);
        this.firstMacroButtons.addFocusListener(this);
        double b = 2.0;
        double pr = -2.0;
        double pf = -1.0;
        double[][] size2 = new double[][]{{pf, b, pf}, {pr, b, pr, b, pr}};
        JPanel buttonBox = new JPanel(new TableLayout(size2));
        this.firstKeysPanel.add((Component)buttonBox, "South");
        this.firstMoveUp.addActionListener(this);
        buttonBox.add((Component)this.firstMoveUp, "0,0");
        this.firstMoveDown.addActionListener(this);
        buttonBox.add((Component)this.firstMoveDown, "2,0");
        this.firstRemove.addActionListener(this);
        this.firstRemove.setToolTipText("Remove selected item.  Key: DEL");
        this.firstRemove.setFocusable(false);
        buttonBox.add((Component)this.firstRemove, "0,2");
        this.firstClear.addActionListener(this);
        buttonBox.add((Component)this.firstClear, "2,2");
        buttonBox.add((Component)this.firstDeselect, "0,4,2,4");
        this.firstDeselect.addActionListener(this);
        this.firstDeselect.setToolTipText("Deselects current selection.  Mouse: Right-click box");
        this.macroBox.add(Box.createHorizontalStrut(10));
        this.secondKeysPanel = new JPanel(new BorderLayout());
        this.macroBox.add(this.secondKeysPanel);
        this.secondKeysPanel.add((Component)this.secondMacroLabel, "North");
        this.secondMacroButtons.setFixedCellWidth(100);
        this.secondKeysPanel.add((Component)new JScrollPane(this.secondMacroButtons), "Center");
        this.secondMacroButtons.setModel(new DefaultListModel());
        this.secondMacroButtons.setSelectionMode(0);
        this.secondMacroButtons.setCellRenderer(this.macroButtonRenderer);
        this.secondMacroButtons.addListSelectionListener(this);
        this.secondMacroButtons.addFocusListener(this);
        buttonBox = new JPanel(new TableLayout(size2));
        this.secondKeysPanel.add((Component)buttonBox, "South");
        this.secondMoveUp.addActionListener(this);
        buttonBox.add((Component)this.secondMoveUp, "0,0");
        this.secondMoveDown.addActionListener(this);
        buttonBox.add((Component)this.secondMoveDown, "2,0");
        this.secondRemove.addActionListener(this);
        this.secondRemove.setToolTipText("Remove selected item.  Key: DEL");
        this.secondRemove.setFocusable(false);
        buttonBox.add((Component)this.secondRemove, "0,2");
        this.secondClear.addActionListener(this);
        buttonBox.add((Component)this.secondClear, "2,2");
        buttonBox.add((Component)this.secondDeselect, "0,4,2,4");
        this.secondDeselect.addActionListener(this);
        this.secondDeselect.setToolTipText("Deselects current selection.  Mouse: Right-click box");
        panel = new JPanel(new BorderLayout());
        this.addToBox(panel, contentPane);
        panel.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.notes.setLineWrap(true);
        panel.add(new JScrollPane(this.notes, 22, 31));
        panel = new JPanel(new FlowLayout(2));
        this.addToBox(panel, contentPane);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
        this.firstMacroButtons.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.firstMacroButtons && SpecialFunctionDialog.this.firstRemove.isVisible() && SpecialFunctionDialog.this.firstRemove.isEnabled()) {
                    SpecialFunctionDialog.this.firstRemove.doClick();
                }
            }
        });
        this.secondMacroButtons.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.secondMacroButtons && SpecialFunctionDialog.this.secondRemove.isVisible() && SpecialFunctionDialog.this.secondRemove.isEnabled()) {
                    SpecialFunctionDialog.this.secondRemove.doClick();
                }
            }
        });
        this.availableButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (SpecialFunctionDialog.this.targetList.getSelectedValue() != null) {
                        if ((e.getModifiers() & 1) != 0) {
                            if (SpecialFunctionDialog.this.insertShift.isVisible() && SpecialFunctionDialog.this.insertShift.isEnabled()) {
                                SpecialFunctionDialog.this.insertShift.doClick();
                            }
                        } else if (SpecialFunctionDialog.this.insert.isVisible() && SpecialFunctionDialog.this.insert.isEnabled()) {
                            SpecialFunctionDialog.this.insert.doClick();
                        }
                    } else if ((e.getModifiers() & 1) != 0) {
                        if (SpecialFunctionDialog.this.addShift.isVisible() && SpecialFunctionDialog.this.addShift.isEnabled()) {
                            SpecialFunctionDialog.this.addShift.doClick();
                        }
                    } else if (SpecialFunctionDialog.this.add.isVisible() && SpecialFunctionDialog.this.add.isEnabled()) {
                        SpecialFunctionDialog.this.add.doClick();
                    }
                } else if (e.getButton() == 2 || e.getButton() == 3) {
                    if (SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.firstMacroButtons && SpecialFunctionDialog.this.firstDeselect.isVisible() && SpecialFunctionDialog.this.firstDeselect.isEnabled()) {
                        SpecialFunctionDialog.this.firstDeselect.doClick();
                    } else if (SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.secondMacroButtons && SpecialFunctionDialog.this.secondDeselect.isVisible() && SpecialFunctionDialog.this.secondDeselect.isEnabled()) {
                        SpecialFunctionDialog.this.secondDeselect.doClick();
                    }
                }
            }
        });
        this.firstMacroButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getButton() == 2 || e.getButton() == 3) && SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.firstMacroButtons && SpecialFunctionDialog.this.firstDeselect.isVisible() && SpecialFunctionDialog.this.firstDeselect.isEnabled()) {
                    SpecialFunctionDialog.this.firstDeselect.doClick();
                }
            }
        });
        this.secondMacroButtons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getButton() == 2 || e.getButton() == 3) && SpecialFunctionDialog.this.targetList == SpecialFunctionDialog.this.secondMacroButtons && SpecialFunctionDialog.this.secondDeselect.isVisible() && SpecialFunctionDialog.this.secondDeselect.isEnabled()) {
                    SpecialFunctionDialog.this.secondDeselect.doClick();
                }
            }
        });
    }

    private void setRemoteConfiguration(RemoteConfiguration config) {
        this.config = config;
        Remote remote = config.getRemote();
        this.shift.setText(remote.getShiftLabel());
        this.xShift.setText(remote.getXShiftLabel());
        this.xShift.setVisible(remote.getXShiftEnabled());
        DefaultComboBoxModel<DeviceButton> comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
        if (remote.hasGlobalSpecialFunctions()) {
            comboModel.addElement(DeviceButton.noButton);
        }
        this.boundDevice.setModel(comboModel);
        this.boundKey.setModel(new DefaultComboBoxModel<Button>(remote.getMacroButtons()));
        this.deviceType.setModel(new DefaultComboBoxModel<DeviceType>(remote.getDeviceTypes()));
        ArrayList<String> specialFunctionsByUserName = new ArrayList<String>();
        for (SpecialProtocol specialProtocol : config.getSpecialProtocols()) {
            for (int i = 0; i < specialProtocol.getFunctions().length; ++i) {
                specialFunctionsByUserName.add(specialProtocol.getUserFunctions()[i]);
                this.specialFunctionsByRDFName.add(specialProtocol.getFunctions()[i]);
            }
        }
        this.type.setModel(new DefaultComboBoxModel<Object>(specialFunctionsByUserName.toArray()));
        this.keyCodeRenderer.setRemote(remote);
        ArrayList<Integer> macroKeys = new ArrayList<Integer>();
        for (Macro macro : config.getMacros()) {
            macroKeys.add(new Integer(macro.getKeyCode()));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(macroKeys.toArray());
        this.macroKey.setModel(defaultComboBoxModel);
        this.firstMacroKey.setModel(defaultComboBoxModel);
        this.secondMacroKey.setModel(defaultComboBoxModel);
        List<Button> buttons = remote.getDistinctButtons();
        DefaultListModel<Button> listModel = new DefaultListModel<Button>();
        for (Button b : buttons) {
            if (!b.canAssignToMacro() && !b.canAssignShiftedToMacro() && !b.canAssignXShiftedToMacro()) continue;
            listModel.addElement(b);
        }
        this.availableButtons.setModel(listModel);
        this.macroButtonRenderer.setRemote(remote);
    }

    private void setFunction(SpecialProtocolFunction function) {
        this.function = null;
        if (function == null) {
            this.cmd = null;
            this.boundDevice.setSelectedIndex(-1);
            this.boundKey.setSelectedIndex(-1);
            this.shift.setSelected(false);
            this.xShift.setSelected(false);
            this.setupCode.setValue(null);
            this.setDuration(4);
            this.setPauseDuration(null);
            this.setULDKPDuration(4);
            this.setModeName("");
            this.setHexField(new Hex(0));
            this.setToggle(0);
            this.setCondition(0);
            ((DefaultListModel)this.firstMacroButtons.getModel()).clear();
            ((DefaultListModel)this.secondMacroButtons.getModel()).clear();
            if (this.type.getItemCount() > 0) {
                this.type.setSelectedIndex(0);
            }
            this.notes.setText("");
            return;
        }
        Remote remote = this.config.getRemote();
        this.cmd = function.getCmd();
        if (this.cmd != null) {
            this.cmd = new Hex(this.cmd);
        }
        DeviceButton db = null;
        int index = function.getDeviceButtonIndex();
        db = remote.hasGlobalSpecialFunctions() && index == 0 ? DeviceButton.noButton : remote.getDeviceButton(index);
        this.boundDevice.setSelectedItem(db);
        this.shift.setSelected(false);
        this.xShift.setSelected(false);
        this.setButton(function.getKeyCode(), this.boundKey, this.shift, this.xShift);
        String selector = function instanceof UserSpecialFunction ? function.getDisplayType(this.config) : function.get_Type(this.config);
        this.type.setSelectedItem(selector);
        function.update(this);
        this.notes.setText(function.getNotes());
    }

    private void setButton(int code, JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        Remote remote = this.config.getRemote();
        Button b = remote.getButton(code);
        if (!Arrays.asList(remote.getMacroButtons()).contains(b)) {
            b = null;
        }
        if (b == null) {
            int base = code & 0x3F;
            if (base != 0) {
                b = remote.getButton(base);
                if ((base | remote.getShiftMask()) == code) {
                    shiftBox.setEnabled(b.allowsShiftedMacro());
                    shiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
                if (remote.getXShiftEnabled() && (base | remote.getXShiftMask()) == code) {
                    xShiftBox.setEnabled(remote.getXShiftEnabled() & b.allowsXShiftedMacro());
                    xShiftBox.setSelected(true);
                    comboBox.setSelectedItem(b);
                    return;
                }
            }
            if ((b = remote.getButton(code & ~remote.getShiftMask())) != null) {
                shiftBox.setSelected(true);
            } else if (remote.getXShiftEnabled() && (b = remote.getButton(code ^ ~remote.getXShiftMask())) != null) {
                xShiftBox.setSelected(true);
            }
        }
        shiftBox.setEnabled(b.allowsShiftedKeyMove());
        xShiftBox.setEnabled(b.allowsXShiftedKeyMove());
        if (b.getIsXShifted()) {
            xShiftBox.setSelected(true);
        } else if (b.getIsShifted()) {
            shiftBox.setSelected(true);
        }
        comboBox.removeActionListener(this);
        comboBox.setSelectedItem(b);
        comboBox.addActionListener(this);
    }

    private int getKeyCode(JComboBox comboBox, JCheckBox shiftBox, JCheckBox xShiftBox) {
        int keyCode = ((Button)comboBox.getSelectedItem()).getKeyCode();
        if (shiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getShiftMask();
        } else if (xShiftBox.isSelected()) {
            keyCode |= this.config.getRemote().getXShiftMask();
        }
        return keyCode;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Missing Information", 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Remote remote = this.config.getRemote();
        Button b = (Button)this.boundKey.getSelectedItem();
        if (source == this.type) {
            String typeStr;
            String cardStr = typeStr = this.specialFunctionsByRDFName.get(this.type.getSelectedIndex());
            if (typeStr.equals("DKP")) {
                cardStr = "Duration";
                this.enableMacros(true);
                this.firstMacroLabel.setText("Single keys:");
                this.secondMacroLabel.setText("Double keys:");
            } else if (typeStr.equals("DSM")) {
                cardStr = "Empty";
                this.enableMacros(true, false);
                this.setTarget(this.firstMacroButtons);
                this.firstMacroLabel.setText("Keys:");
                this.secondMacroLabel.setText("<unused>");
            } else if (typeStr.equals("LKP")) {
                cardStr = "Duration";
                this.enableMacros(true);
                this.firstMacroLabel.setText("Short keys:");
                this.secondMacroLabel.setText("Long keys:");
            } else if (typeStr.equals("ToadTog")) {
                this.enableMacros(true);
                int i = this.condition.getSelectedIndex();
                if (i == -1) {
                    i = 0;
                }
                this.condition.setSelectedIndex(i);
            } else if (typeStr.equals("ULKP")) {
                cardStr = "ULDKP";
                this.firstKeyLabel.setText("Short Key:");
                this.secondKeyLabel.setText("Long Key:");
                this.enableMacros(false);
            } else if (typeStr.equals("UDKP")) {
                cardStr = "ULDKP";
                this.firstKeyLabel.setText("Single Key:");
                this.secondKeyLabel.setText("Double Key:");
                this.enableMacros(false);
            } else if (typeStr.equals("Multiplex") || typeStr.equals("Pause") || typeStr.equals("ModeName")) {
                this.enableMacros(false);
            } else {
                cardStr = "Hex";
                this.enableMacros(false);
            }
            CardLayout cl = (CardLayout)this.parameterCard.getLayout();
            cl.show(this.parameterCard, cardStr);
            this.noteBox.setVisible(typeStr.equals("Pause"));
        } else if (source == this.condition) {
            int i = this.condition.getSelectedIndex();
            this.firstMacroLabel.setText(ToadTogFunction.onStrings[i]);
            this.secondMacroLabel.setText(ToadTogFunction.offStrings[i]);
        } else if (source == this.okButton) {
            if (this.boundDevice.getSelectedIndex() == -1) {
                this.showWarning("You must select a device for the bound key.");
                return;
            }
            if (this.boundKey.getSelectedItem() == null) {
                this.showWarning("You must select a key for the bound key.");
                return;
            }
            if (this.secondMacroButtons.isEnabled() && this.getFirstMacroButtons().length > 7) {
                this.showWarning("The first macro cannot be longer than 7 keys");
                return;
            }
            DeviceButton db = (DeviceButton)this.boundDevice.getSelectedItem();
            int deviceIndex = db == DeviceButton.noButton ? -1 : db.getButtonIndex();
            int keyCode = this.getKeyCode(this.boundKey, this.shift, this.xShift);
            int checkCode = keyCode & 0x3F;
            String typeStr = (String)this.type.getSelectedItem();
            if (this.config.hasSegments() && typeStr.equals("LKP") && (checkCode == 1 || checkCode == 3)) {
                String message = "Due to the Setup/Copy uses of the WatchTV/WatchMovie buttons, it is not possible to\ncreate LKP special functions on them.";
                String title = "LKP Special Function issue";
                JOptionPane.showMessageDialog(this.config.getOwner(), message, title, 0);
                return;
            }
            SpecialProtocol protocol = null;
            for (SpecialProtocol sp : this.config.getSpecialProtocols()) {
                for (String func : sp.getUserFunctions()) {
                    if (!func.equals(typeStr)) continue;
                    protocol = sp;
                    break;
                }
                if (protocol == null) continue;
                break;
            }
            if (protocol == null) {
                this.showWarning("No special protocol found for type " + typeStr);
                return;
            }
            Hex hex = protocol.createHex(this);
            if (hex == null) {
                return;
            }
            if (protocol.isInternal()) {
                Macro macro = new Macro(keyCode, hex, this.notes.getText());
                macro.setSequenceNumber(protocol.getInternalSerial());
                macro.setDeviceButtonIndex(deviceIndex);
                macro.setMacroClass(Macro.MacroClass.NORMAL);
                if (this.config.hasSegments()) {
                    macro.setSegmentFlags(255);
                }
                this.function = protocol.createFunction(macro);
            } else {
                DeviceType devType = null;
                int setupCode = 0;
                if (protocol.getDeviceType() != null) {
                    devType = protocol.getDeviceType();
                    setupCode = protocol.getSetupCode();
                } else {
                    DeviceUpgrade deviceUpgrade = protocol.getDeviceUpgrade(this.config.getDeviceUpgrades());
                    devType = deviceUpgrade.getDeviceType();
                    setupCode = deviceUpgrade.getSetupCode();
                }
                KeyMove km = new KeyMove(keyCode, deviceIndex, devType.getNumber(), setupCode, hex, this.notes.getText());
                if (this.config.hasSegments()) {
                    km.setSegmentFlags(255);
                }
                this.function = protocol.createFunction(km);
            }
            if (this.function == null) {
                return;
            }
            this.setVisible(false);
        } else if (source == this.cancelButton) {
            this.function = null;
            this.setVisible(false);
        } else if (source == this.shift) {
            if (this.shift.isSelected()) {
                this.xShift.setSelected(false);
            } else if (b != null && remote.getXShiftEnabled()) {
                this.xShift.setSelected(b.needsShift(Button.MACRO_BIND));
            }
        } else if (source == this.xShift) {
            if (this.xShift.isSelected()) {
                this.shift.setSelected(false);
            } else if (b != null) {
                this.shift.setSelected(b.needsShift(Button.MACRO_BIND));
            }
        } else if (source == this.boundKey) {
            if (b != null) {
                b.setShiftBoxes(Button.MACRO_BIND, this.shift, this.xShift);
            }
        } else if (source == this.add) {
            this.addKey(0);
        } else if (source == this.insert) {
            this.insertKey(0);
        } else if (source == this.addShift) {
            this.addKey(remote.getShiftMask());
        } else if (source == this.insertShift) {
            this.insertKey(remote.getShiftMask());
        } else if (source == this.addXShift) {
            this.addKey(remote.getXShiftMask());
        } else if (source == this.insertXShift) {
            this.insertKey(remote.getXShiftMask());
        } else if (source == this.firstMoveUp || source == this.secondMoveUp) {
            JList list = this.firstMacroButtons;
            if (source == this.secondMoveUp) {
                list = this.secondMacroButtons;
            }
            int index = list.getSelectedIndex();
            this.swap(list, index, index - 1);
        } else if (source == this.firstMoveDown || source == this.secondMoveDown) {
            JList list = this.firstMacroButtons;
            if (source == this.secondMoveDown) {
                list = this.secondMacroButtons;
            }
            int index = list.getSelectedIndex();
            this.swap(list, index, index + 1);
        } else if (source == this.firstRemove || source == this.secondRemove) {
            JList list = this.firstMacroButtons;
            if (source == this.secondRemove) {
                list = this.secondMacroButtons;
            }
            int index = list.getSelectedIndex();
            DefaultListModel model = (DefaultListModel)list.getModel();
            model.removeElementAt(index);
            int last = model.getSize() - 1;
            if (index > last) {
                index = last;
            }
            list.setSelectedIndex(index);
        } else if (source == this.firstClear) {
            ((DefaultListModel)this.firstMacroButtons.getModel()).clear();
        } else if (source == this.secondClear) {
            ((DefaultListModel)this.secondMacroButtons.getModel()).clear();
        } else if (source == this.firstDeselect) {
            this.firstMacroButtons.clearSelection();
        } else if (source == this.secondDeselect) {
            this.secondMacroButtons.clearSelection();
        }
    }

    private int getSelectedKeyCode() {
        return ((Button)this.availableButtons.getSelectedValue()).getKeyCode();
    }

    private void addKey(int mask) {
        Integer value = new Integer(this.getSelectedKeyCode() | mask);
        ((DefaultListModel)this.targetList.getModel()).addElement(value);
    }

    private void insertKey(int mask) {
        Integer value = new Integer(this.getSelectedKeyCode() | mask);
        int index = this.targetList.getSelectedIndex();
        DefaultListModel model = (DefaultListModel)this.targetList.getModel();
        if (index == -1) {
            model.add(0, value);
        } else {
            model.add(index, value);
        }
        this.targetList.setSelectedIndex(index + 1);
        this.targetList.ensureIndexIsVisible(index + 1);
    }

    private void swap(JList list, int index1, int index2) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        Object o1 = model.get(index1);
        Object o2 = model.get(index2);
        model.set(index1, o2);
        model.set(index2, o1);
        list.setSelectedIndex(index2);
        list.ensureIndexIsVisible(index2);
    }

    private void enableMacros(boolean flag) {
        this.enableMacros(flag, flag);
    }

    private void enableMacros(boolean mainFlag, boolean secondFlag) {
        if (!mainFlag) {
            secondFlag = false;
        }
        this.macroBox.setEnabled(mainFlag);
        this.availableLabel.setEnabled(mainFlag);
        this.availableButtons.setEnabled(mainFlag);
        this.add.setEnabled(mainFlag);
        this.insert.setEnabled(mainFlag);
        this.addShift.setEnabled(mainFlag);
        this.insertShift.setEnabled(mainFlag);
        this.addXShift.setEnabled(mainFlag);
        this.insertXShift.setEnabled(mainFlag);
        this.firstKeysPanel.setEnabled(mainFlag);
        this.firstMacroLabel.setEnabled(mainFlag);
        this.firstMacroButtons.setEnabled(mainFlag);
        this.firstMoveUp.setEnabled(mainFlag);
        this.firstMoveDown.setEnabled(mainFlag);
        this.firstRemove.setEnabled(mainFlag);
        this.firstClear.setEnabled(mainFlag);
        this.secondKeysPanel.setEnabled(secondFlag);
        this.secondMacroLabel.setEnabled(secondFlag);
        this.secondMacroButtons.setEnabled(secondFlag);
        this.secondMoveUp.setEnabled(secondFlag);
        this.secondMoveDown.setEnabled(secondFlag);
        this.secondRemove.setEnabled(secondFlag);
        this.secondClear.setEnabled(secondFlag);
        if (this.firstMacroButtons.isEnabled()) {
            this.targetList = this.firstMacroButtons;
            this.targetList.setBackground(this.activeColor);
        } else {
            this.firstMacroButtons.setBackground(this.disabledColor);
        }
        if (this.secondMacroButtons.isEnabled()) {
            this.secondMacroButtons.setBackground(this.inactiveColor);
        } else {
            this.secondMacroButtons.setBackground(this.disabledColor);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        this.setTarget((JList)source);
    }

    private void setTarget(JList list) {
        if (this.targetList != list && this.targetList.isEnabled()) {
            this.targetList.setBackground(this.inactiveColor);
        }
        this.targetList = list;
        this.targetList.setBackground(this.activeColor);
        this.enableButtons();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.enableButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        DefaultListModel listModel;
        int limit = 15;
        if (this.config.getRemote().getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
            limit = 255;
        }
        boolean moreRoom = (listModel = (DefaultListModel)this.firstMacroButtons.getModel()).getSize() < limit;
        Button b = (Button)this.availableButtons.getSelectedValue();
        boolean canAdd = b != null && moreRoom;
        this.add.setEnabled(canAdd && b.canAssignToMacro());
        this.insert.setEnabled(canAdd && b.canAssignToMacro());
        this.addShift.setEnabled(canAdd && b.canAssignShiftedToMacro());
        this.insertShift.setEnabled(canAdd && b.canAssignShiftedToMacro());
        boolean xShiftEnabled = this.config.getRemote().getXShiftEnabled();
        this.addXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
        this.insertXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToMacro());
        int selected = this.firstMacroButtons.getSelectedIndex();
        this.firstMoveUp.setEnabled(selected > 0);
        this.firstMoveDown.setEnabled(selected != -1 && selected < listModel.getSize() - 1);
        this.firstRemove.setEnabled(this.firstMacroButtons.isFocusOwner() && selected != -1);
        this.firstClear.setEnabled(listModel.getSize() > 0);
        this.firstDeselect.setEnabled(selected != -1);
        listModel = (DefaultListModel)this.secondMacroButtons.getModel();
        moreRoom = listModel.getSize() < limit;
        canAdd = b != null && moreRoom;
        boolean isEnabled = this.secondMacroButtons.isEnabled();
        selected = this.secondMacroButtons.getSelectedIndex();
        this.secondMoveUp.setEnabled(isEnabled && selected > 0);
        this.secondMoveDown.setEnabled(isEnabled && selected != -1 && selected < listModel.getSize() - 1);
        this.secondRemove.setEnabled(this.secondMacroButtons.isFocusOwner() && isEnabled && selected != -1);
        this.secondClear.setEnabled(isEnabled && listModel.getSize() > 0);
        this.secondDeselect.setEnabled(selected != -1);
    }

    private void setMacroButtons(Integer[] keyCodes, JList list) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.clear();
        for (Integer keyCode : keyCodes) {
            model.addElement(keyCode);
        }
        list.setSelectedIndex(-1);
    }

    private Integer[] getMacroButtons(JList list) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        Integer[] keyCodes = new Integer[model.size()];
        for (int i = 0; i < keyCodes.length; ++i) {
            keyCodes[i] = (Integer)model.elementAt(i);
        }
        return keyCodes;
    }

    public String get_Type() {
        return this.specialFunctionsByRDFName.get(this.type.getSelectedIndex());
    }

    public void setModeName(String text) {
        this.modeName.setText(text);
    }

    public void setHexField(Hex hex) {
        this.hexField.setText("" + hex);
    }

    public String getHexString() {
        return this.hexField.getText();
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public void setDeviceType(int deviceTypeIndex) {
        this.deviceType.setSelectedIndex(deviceTypeIndex);
    }

    public int getDeviceType() {
        return this.deviceType.getSelectedIndex();
    }

    public void setSetupCode(int code) {
        this.setupCode.setValue(new Integer(code));
    }

    public int getSetupCode() {
        return (Integer)this.setupCode.getValue();
    }

    public void setDuration(int d) {
        this.duration.setValue(new Integer(d));
    }

    public int getDuration() {
        return (Integer)this.duration.getValue();
    }

    public Float getPauseDuration() {
        if (this.pauseDuration.getText().isEmpty() || !this.pauseDuration.isEditValid()) {
            this.showWarning("The pause value must be a number.  A decimal\npoint is allowed.  Examples of valid entries are\n0.6, 2, 3.45.");
            return null;
        }
        try {
            this.pauseDuration.commitEdit();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (Float)this.pauseDuration.getValue();
    }

    public void setPauseDuration(Float f) {
        if (f == null) {
            this.pauseDuration.setText(null);
        } else {
            this.pauseDuration.setValue(new Float(f.floatValue()));
        }
    }

    public void setToggle(int t) {
        this.toggle.setSelectedIndex(t);
    }

    public int getToggle() {
        return this.toggle.getSelectedIndex();
    }

    public void setCondition(int c) {
        this.condition.setSelectedIndex(c);
    }

    public int getCondition() {
        return this.condition.getSelectedIndex();
    }

    public void setMacroKey(int keyCode) {
        this.macroKey.setSelectedItem(new Integer(keyCode));
    }

    public int getMacroKey() {
        return (Integer)this.macroKey.getSelectedItem();
    }

    public void setULDKPDuration(int d) {
        this.uldkpDuration.setSelectedIndex(d);
    }

    public int getULDKPDuration() {
        return this.uldkpDuration.getSelectedIndex();
    }

    public void setFirstMacroKey(int keyCode) {
        this.firstMacroKey.setSelectedItem(new Integer(keyCode));
    }

    public int getFirstMacroKey() {
        return (Integer)this.firstMacroKey.getSelectedItem();
    }

    public void setSecondMacroKey(int keyCode) {
        this.secondMacroKey.setSelectedItem(new Integer(keyCode));
    }

    public int getSecondMacroKey() {
        return (Integer)this.secondMacroKey.getSelectedItem();
    }

    public void setFirstMacroButtons(Integer[] keyCodes) {
        this.setMacroButtons(keyCodes, this.firstMacroButtons);
    }

    public Integer[] getFirstMacroButtons() {
        return this.getMacroButtons(this.firstMacroButtons);
    }

    public void setSecondMacroButtons(Integer[] keyCodes) {
        this.setMacroButtons(keyCodes, this.secondMacroButtons);
    }

    public Integer[] getSecondMacroButtons() {
        return this.getMacroButtons(this.secondMacroButtons);
    }

    public RemoteConfiguration getRemoteConfiguration() {
        return this.config;
    }

    private class PauseField
    extends JFormattedTextField {
        public PauseField(NumberFormatter nf) {
            super(nf);
            this.setColumns(8);
            this.setFocusLostBehavior(3);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.selectAll();
            }
        }
    }

    public class FunctionTypeRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = (String)value;
            if (text != null && text.length() > 0 && text.charAt(0) == 'U') {
                text = text.substring(1);
            }
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }
}

