/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DSMFunction;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDialog;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialFunctionTableModel;
import com.hifiremote.jp1.SpecialProtocol;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class SpecialFunctionPanel
extends RMTablePanel<SpecialProtocolFunction> {
    private JTextPane notesPane = new JTextPane();

    public SpecialFunctionPanel() {
        super(new SpecialFunctionTableModel());
        this.footerPanel.add((Component)this.notesPane, "First");
        this.notesPane.setBackground(this.getBackground());
        this.notesPane.setForeground(Color.BLACK);
        this.notesPane.setVisible(true);
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        Remote remote = remoteConfig.getRemote();
        ((SpecialFunctionTableModel)this.model).set(remoteConfig);
        this.table.initColumns(this.model);
        boolean keymove = remote.hasKeyMoveSupport();
        boolean learned = remote.hasLearnedSupport();
        String notes = "Special Functions with Device Button and Key values shaded Pink (if selected, Red) conflict with another Special Function on the same Device Button/Key combination that has higher priority, so that Special Function will be saved in a .rmir file but not uploaded to the remote.";
        if (keymove || learned) {
            notes = notes + "  If shaded Orange (if selected, Brown) there is such a conflict with a ";
            notes = notes + (keymove && learned ? "Key Move or Learned Signal" : (learned ? "Learned Signal" : "Key Move"));
            notes = notes + ".  This is for information only, as both will be uploaded but they may not work as intended.";
        }
        this.notesPane.setText(notes);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SpecialProtocolFunction createRowObject(SpecialProtocolFunction baseFunction) {
        void var13_17;
        RemoteConfiguration config = ((SpecialFunctionTableModel)this.model).getRemoteConfig();
        List<SpecialProtocol> spList = config.getSpecialProtocols();
        Remote remote = config.getRemote();
        boolean supportsControlled = remote.getMacroSupport() == 2;
        Button[] realTimeMacroButtons = remote.getMacroButtons(Macro.MacroClass.REALTIME, false);
        Button[] multiMacroButtons = remote.getMacroButtons(Macro.MacroClass.MULTI, false);
        boolean supportsRealTime = realTimeMacroButtons != null && realTimeMacroButtons.length > 0;
        boolean supportsMultiMacros = remote.getSegmentTypes() != null && multiMacroButtons != null && multiMacroButtons.length > 0;
        boolean dsmOnly = spList.size() == 1 && spList.get(0).getFunctions()[0] == "DSM";
        int mode = 0;
        Macro baseMacro = null;
        if (baseFunction == null && (supportsControlled || supportsRealTime || supportsMultiMacros)) {
            int reply;
            Object[] objectArray = new String[supportsRealTime && (supportsControlled || supportsMultiMacros) ? 3 : 2];
            String string = objectArray[0] = dsmOnly ? "DSM" : "Other function";
            String string2 = supportsControlled ? "Controlled DSM" : (objectArray[1] = supportsMultiMacros && objectArray.length == 2 ? "MultiDSM" : "RealTime DSM");
            if (objectArray.length == 3) {
                objectArray[2] = supportsMultiMacros ? "MultiDSM" : "RealTime DSM";
            }
            String title = "Special Function choice";
            String message = "This remote supports creating more than one type of Device-Specific Macro (DSM), and maybe other\nSpecial Functions as well, selected by option buttons shown below.  Here are some notes on them.\n\n";
            message = dsmOnly ? message + "DSM: Select this option for a device-specific normal macro,\n" : message + "Other function: Select this for a normal device-specific macro or non-macro Special Function.\n";
            if (objectArray[1].equals("RealTime DSM") || objectArray.length > 2 && objectArray[2].equals("RealTime DSM")) {
                message = message + "Real-time DSM: This allow you to specify, for each key in the macro, how long the key is held for and the\ndelay before the next key.  Hold times can be specified fairly accurately but delay times only in multiples\nof 100ms.\n";
            }
            if (objectArray[1].equals("Controlled DSM")) {
                message = message + "Controlled DSM: Controlled DSMs are similar to real-time ones but are stored differently in the\nremote.  Hold times, like delay times, are set as multiples of 100ms.\n";
            }
            if (objectArray[1].equals("MultiDSM") || objectArray.length > 2 && objectArray[2].equals("MultiDSM")) {
                message = message + "MultiDSM: This is a set of ordinary DSMs bound to the same key that are sent in turn on successive\nkeypresses.  Each DSM of the set is created and listed separately in RMIR.\n";
            }
            if ((reply = JOptionPane.showOptionDialog(this, message = message + "\nPlease choose which type of Special Function you wish to create.", title, 0, -1, null, objectArray, objectArray[0])) < 0) return null;
            mode = reply == 1 ? (supportsControlled ? 1 : (supportsMultiMacros && objectArray.length == 2 ? 3 : 2)) : (reply == 2 && supportsMultiMacros ? 3 : reply);
        } else if (baseFunction instanceof DSMFunction && baseFunction.getMacro() != null) {
            baseMacro = baseFunction.getMacro();
            mode = baseMacro.getMacroClass() == Macro.MacroClass.CONTROLLED ? 1 : (baseMacro.getMacroClass() == Macro.MacroClass.MULTI ? 3 : (baseMacro.getMacroClass() == Macro.MacroClass.REALTIME ? 2 : 0));
        }
        Object var13_14 = null;
        if (mode > 0 || mode == 0 && dsmOnly) {
            DSMFunction dSMFunction = new DSMFunction(MacroDialog.showDialog(this, baseMacro, config, mode, true));
            return var13_17;
        } else {
            SpecialProtocolFunction specialProtocolFunction = SpecialFunctionDialog.showDialog((JFrame)SwingUtilities.getRoot(this), baseFunction, ((SpecialFunctionTableModel)this.model).getRemoteConfig());
        }
        return var13_17;
    }
}

